/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractFilter;
import io.scif.filters.MetadataWrapper;
import io.scif.io.RandomAccessInputStream;
import java.io.File;
import java.io.IOException;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginService;

public abstract class AbstractReaderFilter
extends AbstractFilter<Reader>
implements Reader {
    private Metadata wrappedMeta = null;
    private final Class<? extends MetadataWrapper> metaClass;
    @Parameter
    private PluginService pluginService;

    public AbstractReaderFilter() {
        this((Class<? extends MetadataWrapper>)null);
    }

    public AbstractReaderFilter(Class<? extends MetadataWrapper> metaClass) {
        super(Reader.class);
        this.metaClass = metaClass;
    }

    protected void setSourceHelper(String source, SCIFIOConfig config) throws IOException {
        String filterSource;
        String string = filterSource = this.getMetadata() == null ? null : this.getMetadata().getSource().getFileName();
        if (filterSource == null || !filterSource.equals(source)) {
            this.setMetadata(((Reader)this.getParent()).getMetadata());
        }
    }

    protected void openPlaneHelper() {
    }

    protected void readPlaneHelper() {
    }

    protected Metadata getParentMeta() {
        return ((Reader)this.getParent()).getMetadata();
    }

    @Override
    public Class<?> target() {
        return Reader.class;
    }

    @Override
    public void setParent(Object parent) {
        super.setParent(parent);
        Reader r = (Reader)parent;
        if (this.metaClass != null) {
            MetadataWrapper wrapper = null;
            try {
                wrapper = this.metaClass.newInstance();
                this.wrappedMeta = wrapper;
                this.getContext().inject((Object)wrapper);
                wrapper.wrap(r.getMetadata());
            }
            catch (InstantiationException e) {
                this.log().error((Object)("Failed to create MetadataWrapper of type: " + this.metaClass), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log().error((Object)("Failed to create MetadataWrapper of type: " + this.metaClass), (Throwable)e);
            }
        } else {
            this.wrappedMeta = r.getMetadata();
        }
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return Reader.class.isAssignableFrom(c);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, planeMin, planeMax, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, planeMin, planeMax, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, planeMin, planeMax, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
        this.openPlaneHelper();
        return ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, planeMin, planeMax, config);
    }

    @Override
    public Plane openThumbPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return ((Reader)this.getParent()).openThumbPlane(imageIndex, planeIndex);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return ((Reader)this.getParent()).fileGroupOption(id);
    }

    @Override
    public String getCurrentFile() {
        return ((Reader)this.getParent()).getCurrentFile();
    }

    @Override
    public String[] getDomains() {
        return ((Reader)this.getParent()).getDomains();
    }

    @Override
    public RandomAccessInputStream getStream() {
        return ((Reader)this.getParent()).getStream();
    }

    @Override
    public Reader[] getUnderlyingReaders() {
        return ((Reader)this.getParent()).getUnderlyingReaders();
    }

    @Override
    public long getOptimalTileWidth(int imageIndex) {
        return ((Reader)this.getParent()).getOptimalTileWidth(imageIndex);
    }

    @Override
    public long getOptimalTileHeight(int imageIndex) {
        return ((Reader)this.getParent()).getOptimalTileHeight(imageIndex);
    }

    @Override
    public void setMetadata(Metadata meta) throws IOException {
        ((Reader)this.getParent()).setMetadata(meta);
        if (this.wrappedMeta instanceof MetadataWrapper) {
            ((MetadataWrapper)this.wrappedMeta).wrap(meta);
        } else {
            this.wrappedMeta = meta;
        }
    }

    @Override
    public Metadata getMetadata() {
        return this.wrappedMeta;
    }

    @Override
    public void setNormalized(boolean normalize) {
        ((Reader)this.getParent()).setNormalized(normalize);
    }

    @Override
    public boolean isNormalized() {
        return ((Reader)this.getParent()).isNormalized();
    }

    @Override
    public boolean hasCompanionFiles() {
        return ((Reader)this.getParent()).hasCompanionFiles();
    }

    @Override
    public void setSource(String fileName) throws IOException {
        ((Reader)this.getParent()).setSource(fileName);
        this.setSourceHelper(fileName, new SCIFIOConfig());
    }

    @Override
    public void setSource(File file) throws IOException {
        ((Reader)this.getParent()).setSource(file);
        this.setSourceHelper(file.getAbsolutePath(), new SCIFIOConfig());
    }

    @Override
    public void setSource(RandomAccessInputStream stream) throws IOException {
        ((Reader)this.getParent()).setSource(stream);
        this.setSourceHelper(stream.getFileName(), new SCIFIOConfig());
    }

    @Override
    public void setSource(String fileName, SCIFIOConfig config) throws IOException {
        ((Reader)this.getParent()).setSource(fileName, config);
        this.setSourceHelper(fileName, config);
    }

    @Override
    public void setSource(File file, SCIFIOConfig config) throws IOException {
        ((Reader)this.getParent()).setSource(file, config);
        this.setSourceHelper(file.getAbsolutePath(), config);
    }

    @Override
    public void setSource(RandomAccessInputStream stream, SCIFIOConfig config) throws IOException {
        ((Reader)this.getParent()).setSource(stream, config);
        this.setSourceHelper(stream.getFileName(), config);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        ((Reader)this.getParent()).close(fileOnly);
        if (this.wrappedMeta != null) {
            this.wrappedMeta.close(fileOnly);
            this.wrappedMeta = null;
        }
        if (!fileOnly) {
            this.cleanUp();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    @Override
    public Plane readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, Plane plane) throws IOException {
        this.readPlaneHelper();
        return ((Reader)this.getParent()).readPlane(s, imageIndex, planeMin, planeMax, plane);
    }

    @Override
    public Plane readPlane(RandomAccessInputStream s, int imageIndex, long[] planeMin, long[] planeMax, int scanlinePad, Plane plane) throws IOException {
        this.readPlaneHelper();
        return ((Reader)this.getParent()).readPlane(s, imageIndex, planeMin, planeMax, scanlinePad, plane);
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return ((Reader)this.getParent()).getPlaneCount(imageIndex);
    }

    @Override
    public int getImageCount() {
        return ((Reader)this.getParent()).getImageCount();
    }

    @Override
    public Plane createPlane(long[] planeMin, long[] planeMax) {
        return ((Reader)this.getParent()).createPlane(planeMin, planeMax);
    }

    @Override
    public Plane createPlane(ImageMetadata meta, long[] planeMin, long[] planeMax) {
        return ((Reader)this.getParent()).createPlane(meta, planeMin, planeMax);
    }

    @Override
    public <P extends Plane> P castToTypedPlane(Plane plane) {
        return ((Reader)this.getParent()).castToTypedPlane(plane);
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return ((Reader)this.getParent()).isSingleFile(id);
    }

    @Override
    public Format getFormat() {
        return ((Reader)this.getParent()).getFormat();
    }

    @Override
    public String getFormatName() {
        return ((Reader)this.getParent()).getFormatName();
    }

    public Context getContext() {
        return ((Reader)this.getParent()).getContext();
    }

    public void setContext(Context ctx) {
        ((Reader)this.getParent()).setContext(ctx);
    }

    protected boolean metaCheck() {
        Metadata meta = this.getMetadata();
        return this.metaClass.isAssignableFrom(meta.getClass());
    }

    protected void cleanUp() throws IOException {
    }
}

