/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.FormatException;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.io.RandomAccessInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.scijava.plugin.Plugin;

@Plugin(type=Codec.class)
public class PackbitsCodec
extends AbstractCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("Packbits Compression not currently supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws FormatException, IOException {
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        long fp = in.getFilePointer();
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        int nread = 0;
        BufferedInputStream s = new BufferedInputStream(in, 262144);
        while (output.size() < options.maxBytes) {
            byte n = (byte)(s.read() & 0xFF);
            ++nread;
            if (n >= 0) {
                byte[] b = new byte[n + 1];
                s.read(b);
                nread += n + 1;
                output.write(b);
                b = null;
                continue;
            }
            if (n == -128) continue;
            int len = -n + 1;
            byte inp = (byte)(s.read() & 0xFF);
            ++nread;
            for (int i = 0; i < len; ++i) {
                output.write(inp);
            }
        }
        if (fp + (long)nread < in.length()) {
            in.seek(fp + (long)nread);
        }
        return output.toByteArray();
    }
}

