/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import org.scijava.AbstractContextual;

public class DataTypeVariableBitSignedComplexFloat
extends AbstractContextual
implements DataType<BigComplex> {
    private BigComplex type = new BigComplex();

    @Override
    public BigComplex getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "Unbounded complex";
    }

    @Override
    public String longName() {
        return "Unbounded complex float";
    }

    @Override
    public String description() {
        return "A complex data type whose size is unrestricted and precise to 50 decimal places";
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public void lowerBound(BigComplex dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public void upperBound(BigComplex dest) {
        throw new UnsupportedOperationException("complex numbers are unbounded");
    }

    @Override
    public int bitCount() {
        return -1;
    }

    @Override
    public BigComplex createVariable() {
        return new BigComplex();
    }

    @Override
    public void cast(BigComplex val, BigComplex dest) {
        dest.setReal(val.getReal());
        dest.setImag(val.getImag());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return false;
    }

    @Override
    public double asDouble(BigComplex val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(BigComplex val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(BigComplex val, double v) {
        val.setReal(v);
        val.setImag(BigDecimal.ZERO);
    }

    @Override
    public void setLong(BigComplex val, long v) {
        val.setReal(v);
        val.setImag(BigDecimal.ZERO);
    }
}

