/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.imagej.table.Column;
import net.imagej.table.Table;
import org.scijava.util.SizableArrayList;

public abstract class AbstractTable<C extends Column<? extends T>, T>
extends SizableArrayList<C>
implements Table<C, T> {
    private final SizableArrayList<String> rowHeaders;
    private int rowCount;

    public AbstractTable() {
        this(0, 0);
    }

    public AbstractTable(int colCount, int rowCount) {
        this.checkRowCount(rowCount);
        this.rowHeaders = new SizableArrayList();
        this.rowCount = rowCount;
        this.setColumnCount(colCount);
    }

    @Override
    public int getColumnCount() {
        return this.size();
    }

    @Override
    public void setColumnCount(int colCount) {
        this.checkColCount(colCount);
        this.setSize(colCount);
        this.scaleColumns();
    }

    @Override
    public C get(String colHeader) {
        return (C)((Column)this.get(this.colIndex(colHeader)));
    }

    @Override
    public C appendColumn() {
        return this.appendColumn(null);
    }

    @Override
    public C appendColumn(String header) {
        return this.insertColumn(this.getColumnCount(), header);
    }

    @Override
    public ArrayList<C> appendColumns(int count) {
        ArrayList<C> result = new ArrayList<C>(count);
        for (int c = 0; c < count; ++c) {
            result.add(this.appendColumn());
        }
        return result;
    }

    @Override
    public ArrayList<C> appendColumns(String ... headers) {
        ArrayList<C> result = new ArrayList<C>(headers.length);
        for (String header : headers) {
            result.add(this.appendColumn(header));
        }
        return result;
    }

    @Override
    public C insertColumn(int col) {
        return this.insertColumn(col, null);
    }

    @Override
    public C insertColumn(int col, String header) {
        List result = this.insertColumns(col, 1);
        this.setColumnHeader(col, header);
        return (C)((Column)((ArrayList)result).get(0));
    }

    @Override
    public ArrayList<C> insertColumns(int col, int count) {
        this.checkCol(col, 0);
        int oldColCount = this.getColumnCount();
        int newColCount = oldColCount + count;
        this.setColumnCount(newColCount);
        for (int oldC = oldColCount - 1; oldC >= col; --oldC) {
            int newC = oldC + count;
            this.set(newC, this.get(oldC));
        }
        ArrayList<C> result = new ArrayList<C>(count);
        for (int c = 0; c < count; ++c) {
            C column = this.createColumn(null);
            column.setSize(this.getRowCount());
            result.add(column);
            this.set(col + c, column);
        }
        return result;
    }

    @Override
    public ArrayList<C> insertColumns(int col, String ... headers) {
        List result = this.insertColumns(col, headers.length);
        for (int c = 0; c < headers.length; ++c) {
            this.setColumnHeader(col + c, headers[c]);
        }
        return result;
    }

    @Override
    public C removeColumn(int col) {
        return (C)((Column)this.remove(col));
    }

    @Override
    public C removeColumn(String header) {
        return this.removeColumn(this.colIndex(header));
    }

    @Override
    public ArrayList<C> removeColumns(int col, int count) {
        this.checkCol(col, count);
        ArrayList<Object> result = new ArrayList<Object>(count);
        for (int c = 0; c < count; ++c) {
            result.add(this.get(col + c));
        }
        int oldColCount = this.getColumnCount();
        int newColCount = oldColCount - count;
        for (int oldC = col + count; oldC < oldColCount; ++oldC) {
            int newC = oldC - count;
            this.set(newC, this.get(oldC));
        }
        this.setColumnCount(newColCount);
        return result;
    }

    @Override
    public ArrayList<C> removeColumns(String ... headers) {
        ArrayList<C> result = new ArrayList<C>(headers.length);
        for (String header : headers) {
            result.add(this.removeColumn(header));
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void setRowCount(int rowCount) {
        this.checkRowCount(rowCount);
        this.rowCount = rowCount;
        this.scaleColumns();
    }

    @Override
    public void appendRow() {
        this.appendRow(null);
    }

    @Override
    public void appendRow(String header) {
        this.insertRow(this.getRowCount(), header);
    }

    @Override
    public void appendRows(int count) {
        for (int c = 0; c < count; ++c) {
            this.appendRow();
        }
    }

    @Override
    public void appendRows(String ... headers) {
        for (String header : headers) {
            this.appendRow(header);
        }
    }

    @Override
    public void insertRow(int row) {
        this.insertRow(row, null);
    }

    @Override
    public void insertRow(int row, String header) {
        this.insertRows(row, 1);
        this.setRowHeader(row, header);
    }

    @Override
    public void insertRows(int row, int count) {
        int r;
        int newR;
        int oldR;
        this.checkRow(row, 0);
        int oldRowCount = this.getRowCount();
        int newRowCount = oldRowCount + count;
        this.setRowCount(newRowCount);
        for (oldR = oldRowCount - 1; oldR >= row; --oldR) {
            newR = oldR + count;
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, newR, this.get(c, oldR));
            }
        }
        for (oldR = oldRowCount - 1; oldR >= row; --oldR) {
            newR = oldR + count;
            this.setRowHeader(newR, this.getRowHeader(oldR));
        }
        for (r = 0; r < count; ++r) {
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, row + r, null);
            }
        }
        for (r = 0; r < count; ++r) {
            this.setRowHeader(row + r, null);
        }
    }

    @Override
    public void insertRows(int row, String ... headers) {
        this.insertRows(row, headers.length);
        for (int r = 0; r < headers.length; ++r) {
            this.setRowHeader(row + r, headers[r]);
        }
    }

    @Override
    public void removeRow(int row) {
        this.removeRows(row, 1);
    }

    @Override
    public void removeRow(String header) {
        int row = this.getColumnIndex(header);
        if (row < 0) {
            throw new IndexOutOfBoundsException("No such row: " + header);
        }
        this.removeRow(row);
    }

    @Override
    public void removeRows(int row, int count) {
        this.checkRow(row, count);
        int oldRowCount = this.getRowCount();
        int newRowCount = oldRowCount - count;
        for (int oldR = row + count; oldR < oldRowCount; ++oldR) {
            int newR = oldR - count;
            this.setRowHeader(newR, this.getRowHeader(oldR));
            for (int c = 0; c < this.getColumnCount(); ++c) {
                this.set(c, newR, this.get(c, oldR));
            }
        }
        this.setRowCount(newRowCount);
        if (this.rowHeaders.size() > newRowCount) {
            this.rowHeaders.setSize(newRowCount);
        }
    }

    @Override
    public void removeRows(String ... headers) {
        for (String header : headers) {
            this.removeRow(header);
        }
    }

    @Override
    public void setDimensions(int colCount, int rowCount) {
        this.setColumnCount(colCount);
        this.setRowCount(rowCount);
    }

    @Override
    public String getColumnHeader(int col) {
        return ((Column)this.get(col)).getHeader();
    }

    @Override
    public void setColumnHeader(int col, String header) {
        ((Column)this.get(col)).setHeader(header);
    }

    @Override
    public int getColumnIndex(String header) {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            String h = this.getColumnHeader(c);
            if (!this.equal(h, header)) continue;
            return c;
        }
        return -1;
    }

    @Override
    public String getRowHeader(int row) {
        this.checkRow(row, 1);
        if (this.rowHeaders.size() <= row) {
            return null;
        }
        return (String)this.rowHeaders.get(row);
    }

    @Override
    public void setRowHeader(int row, String header) {
        this.checkRow(row, 1);
        if (row >= this.rowHeaders.size()) {
            this.rowHeaders.setSize(row + 1);
        }
        this.rowHeaders.set(row, (Object)header);
    }

    @Override
    public int getRowIndex(String header) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            String h = this.getRowHeader(r);
            if (!this.equal(h, header)) continue;
            return r;
        }
        return -1;
    }

    @Override
    public void set(int col, int row, T value) {
        this.check(col, row);
        this.assign((Column)this.get(col), row, value);
    }

    @Override
    public void set(String colHeader, int row, T value) {
        int col = this.colIndex(colHeader);
        this.checkRow(row, 1);
        this.assign((Column)this.get(col), row, value);
    }

    @Override
    public T get(int col, int row) {
        this.check(col, row);
        return (T)((Column)this.get(col)).get(row);
    }

    @Override
    public T get(String colHeader, int row) {
        int col = this.colIndex(colHeader);
        this.checkRow(row, 1);
        return (T)((Column)this.get(col)).get(row);
    }

    @Override
    public boolean add(C column) {
        if (column.size() > this.rowCount) {
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.add(column);
    }

    @Override
    public void add(int col, C column) {
        super.add(col, column);
        if (column.size() > this.rowCount) {
            this.rowCount = column.size();
        }
        this.scaleColumns();
    }

    @Override
    public boolean addAll(Collection<? extends C> c) {
        for (Column column : c) {
            if (column.size() <= this.rowCount) continue;
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int col, Collection<? extends C> c) {
        for (Column column : c) {
            if (column.size() <= this.rowCount) continue;
            this.rowCount = column.size();
        }
        this.scaleColumns();
        return super.addAll(col, c);
    }

    protected abstract C createColumn(String var1);

    private void scaleColumns() {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (this.get(c) == null) {
                this.set(c, this.createColumn(null));
            }
            ((Column)this.get(c)).setSize(this.getRowCount());
        }
    }

    private void check(int col, int row) {
        this.checkCol(col, 1);
        this.checkRow(row, 1);
    }

    private void checkCol(int col, int count) {
        this.check("column", col, count, this.getColumnCount());
    }

    private void checkRow(int row, int count) {
        this.check("row", row, count, this.getRowCount());
    }

    private void check(String name, int index, int count, int bound) {
        int last = index + count - 1;
        if (index >= 0 && last < bound) {
            return;
        }
        if (count <= 1) {
            throw new IndexOutOfBoundsException("Invalid " + name + ": " + index);
        }
        throw new IndexOutOfBoundsException("Invalid " + name + "s: " + index + " - " + last);
    }

    private void checkColCount(int count) {
        this.checkCount("column", count);
    }

    private void checkRowCount(int count) {
        this.checkCount("row", count);
    }

    private void checkCount(String name, int count) {
        if (count >= 0) {
            return;
        }
        throw new IllegalArgumentException("Invalid " + name + " count: " + count);
    }

    private int colIndex(String header) {
        int col = this.getColumnIndex(header);
        if (col < 0) {
            throw new IllegalArgumentException("No such column: " + header);
        }
        return col;
    }

    private <U> void assign(Column<U> column, int row, Object value) {
        if (value != null && !column.getType().isInstance(value)) {
            throw new IllegalArgumentException("value of type " + value.getClass() + " is not a " + column.getType());
        }
        Object typedValue = value;
        column.set(row, typedValue);
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }
}

