/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DataView;
import net.imagej.display.DefaultImageCanvas;
import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.event.AxisActivatedEvent;
import net.imagej.display.event.AxisPositionEvent;
import net.imagej.event.DataRestructuredEvent;
import net.imagej.event.DataUpdatedEvent;
import net.imagej.interval.CalibratedRealInterval;
import net.imagej.interval.CombinedCalibratedRealInterval;
import net.imagej.lut.LUTService;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.display.ColorTable;
import org.scijava.Context;
import org.scijava.display.AbstractDisplay;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.util.RealRect;

@Plugin(type=Display.class)
public class DefaultImageDisplay
extends AbstractDisplay<DataView>
implements ImageDisplay {
    private final CombinedCalibratedRealInterval<CalibratedAxis, CalibratedRealInterval<CalibratedAxis>> combinedInterval = new CombinedCalibratedRealInterval();
    @Parameter
    private ThreadService threadService;
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private EventService eventService;
    @Parameter(required=false)
    private ImageDisplayService imageDisplayService;
    @Parameter(required=false)
    private DatasetService datasetService;
    @Parameter(required=false)
    private LUTService lutService;
    private AxisType activeAxis = null;
    private ImageCanvas canvas;
    private final ConcurrentHashMap<AxisType, Long> pos = new ConcurrentHashMap();

    public DefaultImageDisplay() {
        super(DataView.class);
    }

    protected void rebuild() {
        DataView view;
        super.rebuild();
        this.combinedInterval.clear();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            view = (DataView)iterator.next();
            this.combinedInterval.add(view.getData());
        }
        this.combinedInterval.update();
        iterator = this.iterator();
        while (iterator.hasNext()) {
            view = (DataView)iterator.next();
            view.rebuild();
        }
        for (AxisType axis : this.pos.keySet()) {
            if (this.dimensionIndex(axis) >= 0) continue;
            this.pos.remove(axis);
        }
        for (int i = 0; i < this.numDimensions(); ++i) {
            AxisType axis;
            axis = this.axis(i).type();
            if (axis.isXY() || this.pos.containsKey(axis)) continue;
            this.pos.put(axis, this.min(i));
        }
        if (this.getActiveAxis() == null) {
            this.initActiveAxis();
        }
    }

    @Override
    public DataView getActiveView() {
        return this.size() > 0 ? (DataView)this.get(0) : null;
    }

    @Override
    public AxisType getActiveAxis() {
        return this.activeAxis;
    }

    @Override
    public void setActiveAxis(AxisType axis) {
        if (this.dimensionIndex(axis) < 0) {
            throw new IllegalArgumentException("Unknown axis: " + axis);
        }
        this.activeAxis = axis;
        if (this.eventService != null) {
            this.eventService.publish((SciJavaEvent)new AxisActivatedEvent(this, this.activeAxis));
        }
    }

    @Override
    public boolean isVisible(DataView view) {
        for (int i = 0; i < this.numDimensions(); ++i) {
            double max;
            AxisType axis = this.axis(i).type();
            if (axis.isXY()) continue;
            long value = this.getLongPosition(axis);
            int index = view.getData().dimensionIndex(axis);
            if (index < 0) {
                if (value == view.getLongPosition(axis)) continue;
                return false;
            }
            double min = index < 0 ? 0.0 : view.getData().realMin(index);
            double d = max = index < 0 ? 0.0 : view.getData().realMax(index);
            if (!((double)value < min) && !((double)value > max)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ImageCanvas getCanvas() {
        if (this.canvas == null) {
            this.canvas = new DefaultImageCanvas(this);
        }
        return this.canvas;
    }

    @Override
    public RealRect getPlaneExtents() {
        int xAxis = this.dimensionIndex(Axes.X);
        int yAxis = this.dimensionIndex(Axes.Y);
        double xMin = this.realMin(xAxis);
        double yMin = this.realMin(yAxis);
        double width = this.realMax(xAxis) - this.realMin(xAxis);
        double height = this.realMax(yAxis) - this.realMin(yAxis);
        return new RealRect(xMin, yMin, width, height);
    }

    public boolean canDisplay(Class<?> c) {
        return this.imageDisplayService != null && this.isImageClass(c) || this.lutService != null && ColorTable.class.isAssignableFrom(c) || super.canDisplay(c);
    }

    public void display(Object o) {
        DataView dataView = null;
        Data data = null;
        if (o instanceof DataView) {
            dataView = (DataView)o;
        } else if (o instanceof Data) {
            data = (Data)o;
        } else if (o instanceof RandomAccessibleInterval) {
            Dataset d = this.datasetService.create((RandomAccessibleInterval)o);
            data = d;
        } else if (o instanceof ColorTable) {
            ColorTable colorTable = (ColorTable)o;
            data = this.lutService.createDataset(null, colorTable);
        }
        if (data != null) {
            if (this.imageDisplayService == null) {
                throw new IllegalStateException("An ImageDisplayService is required to display Data objects");
            }
            dataView = this.imageDisplayService.createDataView(data);
        }
        if (dataView == null) {
            throw new IllegalArgumentException("Incompatible object: " + o + " [" + o.getClass().getName() + "]");
        }
        super.display((Object)dataView);
        this.updateName(dataView);
        this.rebuild();
    }

    public boolean isDisplaying(Object o) {
        if (super.isDisplaying(o)) {
            return true;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            if (o != view.getData()) continue;
            return true;
        }
        return false;
    }

    public void update() {
        this.combinedInterval.update();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            for (int i = 0; i < this.numDimensions(); ++i) {
                Data data;
                double size;
                long p;
                int axisNum;
                AxisType axis = this.axis(i).type();
                if (axis.isXY() || (axisNum = view.getData().dimensionIndex(axis)) < 0 || !((double)(p = this.getLongPosition(axis)) < (size = (data = view.getData()).realMax(axisNum) - data.realMin(axisNum) + 1.0))) continue;
                view.setPosition(p, axis);
            }
            view.update();
        }
        super.update();
    }

    @Override
    public long min(int d) {
        return (long)Math.floor(this.combinedInterval.realMin(d));
    }

    @Override
    public void min(long[] min) {
        for (int i = 0; i < min.length; ++i) {
            min[i] = this.min(i);
        }
    }

    @Override
    public void min(Positionable min) {
        for (int i = 0; i < min.numDimensions(); ++i) {
            min.setPosition(this.min(i), i);
        }
    }

    @Override
    public long max(int d) {
        return (long)Math.ceil(this.combinedInterval.realMax(d));
    }

    @Override
    public void max(long[] max) {
        for (int i = 0; i < max.length; ++i) {
            max[i] = this.max(i);
        }
    }

    @Override
    public void max(Positionable max) {
        for (int i = 0; i < max.numDimensions(); ++i) {
            max.setPosition(this.max(i), i);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = this.dimension(i);
        }
    }

    @Override
    public long dimension(int d) {
        return this.max(d) - this.min(d) + 1L;
    }

    @Override
    public double realMin(int d) {
        return this.combinedInterval.realMin(d);
    }

    @Override
    public void realMin(double[] min) {
        this.combinedInterval.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.combinedInterval.realMin(min);
    }

    @Override
    public double realMax(int d) {
        return this.combinedInterval.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.combinedInterval.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.combinedInterval.realMax(max);
    }

    @Override
    public int numDimensions() {
        return this.combinedInterval.numDimensions();
    }

    @Override
    public double averageScale(int d) {
        return this.combinedInterval.averageScale(d);
    }

    @Override
    public int dimensionIndex(AxisType axis) {
        return this.combinedInterval.dimensionIndex(axis);
    }

    @Override
    public CalibratedAxis axis(int d) {
        return (CalibratedAxis)this.combinedInterval.axis(d);
    }

    public void axes(CalibratedAxis[] axes) {
        this.combinedInterval.axes(axes);
    }

    @Override
    public void setAxis(CalibratedAxis axis, int d) {
        this.combinedInterval.setAxis(axis, d);
    }

    @Override
    public int getIntPosition(AxisType axis) {
        return (int)this.getLongPosition(axis);
    }

    @Override
    public long getLongPosition(AxisType axis) {
        int d = this.dimensionIndex(axis);
        if (d < 0) {
            return 0L;
        }
        Long value = this.pos.get(axis);
        if (value == null) {
            return 0L;
        }
        long min = this.min(d);
        if (value < min) {
            return min;
        }
        long max = this.max(d);
        if (value > max) {
            return max;
        }
        return value;
    }

    @Override
    public void setPosition(long position, AxisType axis) {
        int axisIndex = this.dimensionIndex(axis);
        if (axisIndex < 0) {
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
        long min = this.min(axisIndex);
        long max = this.max(axisIndex);
        long value = position;
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        this.pos.put(axis, value);
        if (this.eventService != null) {
            this.eventService.publishLater((SciJavaEvent)new AxisPositionEvent(this, axis));
        }
    }

    @Override
    public void localize(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getIntPosition(i);
        }
    }

    @Override
    public void localize(long[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getLongPosition(i);
        }
    }

    @Override
    public int getIntPosition(int d) {
        return this.getIntPosition(this.axis(d).type());
    }

    @Override
    public long getLongPosition(int d) {
        return this.getLongPosition(this.axis(d).type());
    }

    @Override
    public void localize(float[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getFloatPosition(i);
        }
    }

    @Override
    public void localize(double[] position) {
        for (int i = 0; i < position.length; ++i) {
            position[i] = this.getDoublePosition(i);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public void fwd(int d) {
        this.setPosition(this.getLongPosition(d) + 1L, d);
    }

    @Override
    public void bck(int d) {
        this.setPosition(this.getLongPosition(d) - 1L, d);
    }

    @Override
    public void move(int distance, int d) {
        this.setPosition(this.getLongPosition(d) + (long)distance, d);
    }

    @Override
    public void move(long distance, int d) {
        this.setPosition(this.getLongPosition(d) + distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        for (int i = 0; i < localizable.numDimensions(); ++i) {
            this.move(localizable.getLongPosition(i), i);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.move(distance[i], i);
        }
    }

    @Override
    public void move(long[] distance) {
        for (int i = 0; i < distance.length; ++i) {
            this.move(distance[i], i);
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int i = 0; i < localizable.numDimensions(); ++i) {
            this.setPosition(localizable.getLongPosition(i), i);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.setPosition(position[i], i);
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int i = 0; i < position.length; ++i) {
            this.setPosition(position[i], i);
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.setPosition((long)position, this.axis(d).type());
    }

    @Override
    public void setPosition(long position, int d) {
        this.setPosition(position, this.axis(d).type());
    }

    @EventHandler
    protected void onEvent(final DataRestructuredEvent event) {
        this.threadService.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Context context = DefaultImageDisplay.this.getContext();
                synchronized (context) {
                    Iterator iterator = DefaultImageDisplay.this.iterator();
                    while (iterator.hasNext()) {
                        DataView view = (DataView)iterator.next();
                        if (event.getObject() != view.getData()) continue;
                        DefaultImageDisplay.this.rebuild();
                        DefaultImageDisplay.this.update();
                        return;
                    }
                }
            }
        });
    }

    @EventHandler
    protected void onEvent(DataUpdatedEvent event) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            if (event.getObject() != view.getData()) continue;
            this.update();
            return;
        }
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent event) {
        if (event.getObject() != this) {
            return;
        }
        this.cleanup();
    }

    private void updateName(DataView dataView) {
        if (this.getName() != null) {
            return;
        }
        String dataName = dataView.getData().getName();
        if (dataName != null && !dataName.isEmpty()) {
            this.setName(this.createName(dataName));
        }
    }

    private String createName(String proposedName) {
        if (this.displayService == null) {
            return proposedName;
        }
        String theName = proposedName;
        int n = 0;
        while (!this.displayService.isUniqueName(theName)) {
            theName = proposedName + "-" + ++n;
        }
        return theName;
    }

    private boolean isImageClass(Class<?> c) {
        return Data.class.isAssignableFrom(c) || RandomAccessibleInterval.class.isAssignableFrom(c);
    }

    private void initActiveAxis() {
        if (this.activeAxis == null) {
            for (int i = 0; i < this.numDimensions(); ++i) {
                AxisType axisType = this.axis(i).type();
                if (axisType.isXY()) continue;
                this.setActiveAxis(axisType);
                return;
            }
        }
    }

    private void cleanup() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            DataView view = (DataView)iterator.next();
            view.dispose();
        }
        this.clear();
        this.combinedInterval.clear();
    }
}

