/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.erode;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.map.Maps;
import net.imagej.ops.map.neighborhood.MapNeighborhood;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.Erode.class)
public class DefaultErode<T extends RealType<T>>
extends AbstractBinaryHybridCF<RandomAccessibleInterval<T>, Shape, IterableInterval<T>>
implements Ops.Morphology.Erode,
Contingent {
    @Parameter(required=false)
    private boolean isFull;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> f;
    private T maxVal;
    private MapNeighborhood<T, T, RandomAccessibleInterval<T>, IterableInterval<T>, UnaryComputerOp<Iterable<T>, T>> mapper;
    private UnaryFunctionOp<Dimensions, Img<T>> imgCreator;

    @Override
    public boolean conforms() {
        if (this.out() == null) {
            return true;
        }
        if (this.isFull) {
            return ((IterableInterval)this.createOutput(this.in())).iterationOrder().equals(this.out());
        }
        return Maps.compatible((RandomAccessibleInterval)this.in(), (IterableInterval)this.out());
    }

    @Override
    public void initialize() {
        this.maxVal = (RealType)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable();
        this.maxVal.setReal(this.maxVal.getMaxValue());
        if (this.f == null) {
            this.f = new OutOfBoundsConstantValueFactory(this.maxVal);
        }
        ErodeBitType neighborComputer = this.maxVal instanceof BitType ? new ErodeBitType() : Computers.unary(this.ops(), Ops.Stats.Min.class, this.maxVal.createVariable(), Iterable.class, new Object[0]);
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, this.in(), this.maxVal.createVariable());
        if (this.out() == null) {
            this.setOutput(this.createOutput(this.in()));
        }
        this.mapper = this.ops().op(MapNeighborhood.class, this.out(), this.in1(), this.in2(), neighborComputer);
    }

    @Override
    public IterableInterval<T> createOutput(RandomAccessibleInterval<T> in1, Shape in2) {
        if (this.isFull) {
            long[] dims = MorphologyUtils.computeTargetImageDimensionsAndOffset(in1, (Shape)in2)[0];
            return (IterableInterval)this.imgCreator.calculate((Dimensions)new FinalInterval(dims));
        }
        return (IterableInterval)this.imgCreator.calculate((Dimensions)in1);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> in1, Shape in2, IterableInterval<T> output) {
        IntervalView shifted;
        IntervalView extended = RAIs.extend(in1, this.f);
        if (this.isFull) {
            long[] offset = MorphologyUtils.computeTargetImageDimensionsAndOffset(in1, (Shape)in2)[1];
            shifted = Views.translate(extended, (long[])offset);
        } else {
            shifted = extended;
        }
        this.mapper.compute(Views.interval(shifted, output), in2, output);
    }

    private static class ErodeBitType
    extends AbstractUnaryComputerOp<Iterable<BitType>, BitType> {
        private ErodeBitType() {
        }

        @Override
        public void compute(Iterable<BitType> input, BitType output) {
            for (BitType e : input) {
                if (e.get()) continue;
                output.set(false);
                return;
            }
            output.set(true);
        }
    }
}

