/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.inplace.AbstractUnaryInplaceOp;
import net.imagej.ops.thread.chunker.Chunk;
import net.imagej.ops.thread.chunker.ChunkerOp;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class ConstantToArrayImageP {
    private ConstantToArrayImageP() {
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideUnsignedShort
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<UnsignedShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] / value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] / value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyUnsignedShort
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<UnsignedShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] * value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] * value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractUnsignedShort
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<UnsignedShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] - value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] - value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddUnsignedShort
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<UnsignedShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] + value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] + value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedShortType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideUnsignedLong
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedLongType, LongArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<UnsignedLongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyUnsignedLong
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedLongType, LongArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<UnsignedLongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractUnsignedLong
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedLongType, LongArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<UnsignedLongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddUnsignedLong
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedLongType, LongArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<UnsignedLongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedLongType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideUnsignedInt
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedIntType, IntArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<UnsignedIntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyUnsignedInt
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedIntType, IntArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<UnsignedIntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractUnsignedInt
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedIntType, IntArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<UnsignedIntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddUnsignedInt
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedIntType, IntArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<UnsignedIntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedIntType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideUnsignedByte
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<UnsignedByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] / value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] / value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyUnsignedByte
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<UnsignedByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] * value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] * value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractUnsignedByte
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<UnsignedByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] - value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] - value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddUnsignedByte
    extends AbstractUnaryInplaceOp<ArrayImg<UnsignedByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<UnsignedByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] + value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] + value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof UnsignedByteType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideDouble
    extends AbstractUnaryInplaceOp<ArrayImg<DoubleType, DoubleArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private double value;

        @Override
        public void mutate(ArrayImg<DoubleType, DoubleArray> arg) {
            final double[] data = ((DoubleArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyDouble
    extends AbstractUnaryInplaceOp<ArrayImg<DoubleType, DoubleArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private double value;

        @Override
        public void mutate(ArrayImg<DoubleType, DoubleArray> arg) {
            final double[] data = ((DoubleArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractDouble
    extends AbstractUnaryInplaceOp<ArrayImg<DoubleType, DoubleArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private double value;

        @Override
        public void mutate(ArrayImg<DoubleType, DoubleArray> arg) {
            final double[] data = ((DoubleArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddDouble
    extends AbstractUnaryInplaceOp<ArrayImg<DoubleType, DoubleArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private double value;

        @Override
        public void mutate(ArrayImg<DoubleType, DoubleArray> arg) {
            final double[] data = ((DoubleArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof DoubleType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideFloat
    extends AbstractUnaryInplaceOp<ArrayImg<FloatType, FloatArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private float value;

        @Override
        public void mutate(ArrayImg<FloatType, FloatArray> arg) {
            final float[] data = ((FloatArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyFloat
    extends AbstractUnaryInplaceOp<ArrayImg<FloatType, FloatArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private float value;

        @Override
        public void mutate(ArrayImg<FloatType, FloatArray> arg) {
            final float[] data = ((FloatArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractFloat
    extends AbstractUnaryInplaceOp<ArrayImg<FloatType, FloatArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private float value;

        @Override
        public void mutate(ArrayImg<FloatType, FloatArray> arg) {
            final float[] data = ((FloatArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddFloat
    extends AbstractUnaryInplaceOp<ArrayImg<FloatType, FloatArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private float value;

        @Override
        public void mutate(ArrayImg<FloatType, FloatArray> arg) {
            final float[] data = ((FloatArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof FloatType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideShort
    extends AbstractUnaryInplaceOp<ArrayImg<ShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<ShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] / value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] / value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyShort
    extends AbstractUnaryInplaceOp<ArrayImg<ShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<ShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] * value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] * value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractShort
    extends AbstractUnaryInplaceOp<ArrayImg<ShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<ShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] - value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] - value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddShort
    extends AbstractUnaryInplaceOp<ArrayImg<ShortType, ShortArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private short value;

        @Override
        public void mutate(ArrayImg<ShortType, ShortArray> arg) {
            final short[] data = ((ShortArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (short)(data[n] + value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (short)(data[n] + value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ShortType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideLong
    extends AbstractUnaryInplaceOp<ArrayImg<LongType, LongArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<LongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyLong
    extends AbstractUnaryInplaceOp<ArrayImg<LongType, LongArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<LongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractLong
    extends AbstractUnaryInplaceOp<ArrayImg<LongType, LongArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<LongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddLong
    extends AbstractUnaryInplaceOp<ArrayImg<LongType, LongArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private long value;

        @Override
        public void mutate(ArrayImg<LongType, LongArray> arg) {
            final long[] data = ((LongArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof LongType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideInt
    extends AbstractUnaryInplaceOp<ArrayImg<IntType, IntArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<IntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] / value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] / value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyInt
    extends AbstractUnaryInplaceOp<ArrayImg<IntType, IntArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<IntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] * value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] * value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractInt
    extends AbstractUnaryInplaceOp<ArrayImg<IntType, IntArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<IntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] - value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] - value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddInt
    extends AbstractUnaryInplaceOp<ArrayImg<IntType, IntArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private int value;

        @Override
        public void mutate(ArrayImg<IntType, IntArray> arg) {
            final int[] data = ((IntArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = data[n] + value;
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = data[n] + value;
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof IntType;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=101.0)
    public static class DivideByte
    extends AbstractUnaryInplaceOp<ArrayImg<ByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Divide {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<ByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] / value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] / value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=101.0)
    public static class MultiplyByte
    extends AbstractUnaryInplaceOp<ArrayImg<ByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Multiply {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<ByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] * value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] * value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=101.0)
    public static class SubtractByte
    extends AbstractUnaryInplaceOp<ArrayImg<ByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Subtract {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<ByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] - value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] - value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ByteType;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=101.0)
    public static class AddByte
    extends AbstractUnaryInplaceOp<ArrayImg<ByteType, ByteArray>>
    implements Contingent,
    Ops.Math.Add {
        @Parameter
        private byte value;

        @Override
        public void mutate(ArrayImg<ByteType, ByteArray> arg) {
            final byte[] data = ((ByteArray)arg.update(null)).getCurrentStorageArray();
            this.ops().run(ChunkerOp.class, new Chunk(){

                @Override
                public void execute(int startIndex, int stepSize, int numSteps) {
                    if (stepSize != 1) {
                        int i = startIndex;
                        for (int j = 0; j < numSteps; ++j) {
                            int n = i;
                            data[n] = (byte)(data[n] + value);
                            i += stepSize;
                        }
                    } else {
                        int i = startIndex;
                        while (i < startIndex + numSteps) {
                            int n = i++;
                            data[n] = (byte)(data[n] + value);
                        }
                    }
                }
            }, data.length);
        }

        @Override
        public boolean conforms() {
            return ((ArrayImg)this.in()).firstElement() instanceof ByteType;
        }
    }
}

