/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.ArrayList;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.SmallestEnclosingBoundingBox.class, label="Geometric (2D): Smallest Enclosing Rectangle")
public class DefaultSmallestEnclosingRectangle
extends AbstractUnaryFunctionOp<Polygon, Polygon>
implements Contingent,
Ops.Geometric.SmallestEnclosingBoundingBox {
    private UnaryFunctionOp<Polygon, Polygon> convexHullFunc;
    private UnaryFunctionOp<Polygon, RealLocalizable> centroidFunc;
    private UnaryFunctionOp<Polygon, DoubleType> areaFunc;
    private UnaryFunctionOp<Polygon, Polygon> boundingBoxFunc;

    @Override
    public void initialize() {
        this.convexHullFunc = Functions.unary(this.ops(), Ops.Geometric.ConvexHull.class, Polygon.class, this.in(), new Object[0]);
        this.centroidFunc = Functions.unary(this.ops(), Ops.Geometric.Centroid.class, RealLocalizable.class, this.in(), new Object[0]);
        this.areaFunc = Functions.unary(this.ops(), Ops.Geometric.Size.class, DoubleType.class, this.in(), new Object[0]);
        this.boundingBoxFunc = Functions.unary(this.ops(), Ops.Geometric.BoundingBox.class, Polygon.class, this.in(), new Object[0]);
    }

    private Polygon rotate(Polygon inPoly, double angle, RealLocalizable center) {
        ArrayList<RealPoint> out = new ArrayList<RealPoint>();
        for (RealLocalizable realLocalizable : inPoly.getVertices()) {
            double cosTheta = Math.cos(angle);
            double sinTheta = Math.sin(angle);
            double x = cosTheta * (realLocalizable.getDoublePosition(0) - center.getDoublePosition(0)) - sinTheta * (realLocalizable.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(0);
            double y = sinTheta * (realLocalizable.getDoublePosition(0) - center.getDoublePosition(0)) + cosTheta * (realLocalizable.getDoublePosition(1) - center.getDoublePosition(1)) + center.getDoublePosition(1);
            out.add(new RealPoint(new double[]{x, y}));
        }
        return new Polygon(out);
    }

    @Override
    public Polygon calculate(Polygon input) {
        Polygon ch = this.convexHullFunc.calculate(input);
        RealLocalizable cog = this.centroidFunc.calculate(ch);
        Polygon minBounds = input;
        double minArea = Double.POSITIVE_INFINITY;
        for (int i = 1; i < ch.getVertices().size() - 1; ++i) {
            double angle = Math.atan2(ch.getVertices().get(i).getDoublePosition(1) - ch.getVertices().get(i - 1).getDoublePosition(1), ch.getVertices().get(i).getDoublePosition(0) - ch.getVertices().get(i - 1).getDoublePosition(0));
            Polygon rotatedPoly = this.rotate(ch, -angle, cog);
            Polygon bounds = this.boundingBoxFunc.calculate(rotatedPoly);
            double area = this.areaFunc.calculate(bounds).get();
            if (!(area < minArea)) continue;
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        double angle = Math.atan2(ch.getVertices().get(0).getDoublePosition(1) - ch.getVertices().get(ch.getVertices().size() - 1).getDoublePosition(1), ch.getVertices().get(0).getDoublePosition(0) - ch.getVertices().get(ch.getVertices().size() - 1).getDoublePosition(0));
        Polygon rotatedPoly = this.rotate(ch, -angle, cog);
        Polygon bounds = this.boundingBoxFunc.calculate(rotatedPoly);
        double area = this.areaFunc.calculate(bounds).get();
        if (area < minArea) {
            minArea = area;
            minBounds = this.rotate(bounds, angle, cog);
        }
        return minBounds;
    }

    @Override
    public boolean conforms() {
        return this.in() != null;
    }
}

