/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.roi.geometric.Polygon;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.Eccentricity.class, label="Geometric (2D): Eccentricity")
public class DefaultEccentricity
extends AbstractUnaryHybridCF<Polygon, DoubleType>
implements Ops.Geometric.Eccentricity {
    private UnaryFunctionOp<Polygon, DoubleType> minorAxisFunc;
    private UnaryFunctionOp<Polygon, DoubleType> majorAxisFunc;

    @Override
    public void initialize() {
        this.minorAxisFunc = RTs.function(this.ops(), Ops.Geometric.MinorAxis.class, this.in(), new Object[0]);
        this.majorAxisFunc = RTs.function(this.ops(), Ops.Geometric.MajorAxis.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Polygon input, DoubleType output) {
        double a = this.majorAxisFunc.calculate(input).get() / 2.0;
        double b = this.minorAxisFunc.calculate(input).get() / 2.0;
        output.set(Math.sqrt(1.0 - Math.pow(b / a, 2.0)));
    }

    @Override
    public DoubleType createOutput(Polygon input) {
        return new DoubleType();
    }
}

