/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.service;

import com.twosigma.beaker.jupyter.Utils;
import com.twosigma.jupyter.ConfigurationFile;
import com.twosigma.jupyter.KernelRunner;
import com.twosigma.jupyter.KernelSocketsFactoryImpl;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.scijava.Context;
import org.scijava.command.CommandService;
import org.scijava.jupyter.commands.InstallScijavaKernel;
import org.scijava.jupyter.kernel.ScijavaKernel;
import org.scijava.jupyter.kernel.configuration.ScijavaKernelConfigurationFile;
import org.scijava.jupyter.kernel.evaluator.ScijavaEvaluator;
import org.scijava.jupyter.service.JupyterService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultJupyterService
extends AbstractService
implements JupyterService {
    @Parameter
    private transient LogService log;
    @Parameter
    private transient Context context;
    @Parameter
    private transient CommandService command;

    @Override
    public void installKernel(String ... args) {
        Map<String, Object> parameters = this.parseArgumentsInstall(args);
        this.installKernel((String)parameters.get("scriptLanguage"), (String)parameters.get("logLevel"), (String)parameters.get("pythonBinaryPath"), (boolean)((Boolean)parameters.get("installAllKernels")), (String)parameters.get("classpath"), (String)parameters.get("javaBinaryPath"));
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, String pythonBinaryPath) {
        this.installKernel(scriptLanguage, logLevel, Paths.get(pythonBinaryPath, new String[0]));
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, Path pythonBinaryPath) {
        this.installKernel(scriptLanguage, logLevel, pythonBinaryPath.toFile());
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, File pythonBinaryPath) {
        this.installKernel(scriptLanguage, logLevel, pythonBinaryPath, false, null, null);
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, String pythonBinaryPath, boolean installAllKernels, String classpath, String javaBinaryPath) {
        this.installKernel(scriptLanguage, logLevel, new File(pythonBinaryPath), installAllKernels, classpath, javaBinaryPath);
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, String pythonBinaryPath, boolean installAllKernels) {
        this.installKernel(scriptLanguage, logLevel, new File(pythonBinaryPath), installAllKernels, null, null);
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, Path pythonBinaryPath, boolean installAllKernels) {
        this.installKernel(scriptLanguage, logLevel, pythonBinaryPath.toFile(), installAllKernels, null, null);
    }

    @Override
    public void installKernel(String scriptLanguage, String logLevel, File pythonBinaryPath, boolean installAllKernels, String classpath, String javaBinaryPath) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("scriptLanguage", scriptLanguage);
        parameters.put("logLevel", logLevel);
        parameters.put("pythonBinaryPath", pythonBinaryPath);
        parameters.put("installAllKernels", installAllKernels);
        parameters.put("classpath", classpath);
        parameters.put("javaBinaryPath", new File(javaBinaryPath));
        this.command.run(InstallScijavaKernel.class, true, parameters);
    }

    @Override
    public void runKernel(String ... args) {
        Map<String, Object> parameters = this.parseArgumentsRun(args);
        this.runKernel((String)parameters.get("scriptLanguage"), (String)parameters.get("logLevel"), (String)parameters.get("connectionFile"));
    }

    @Override
    public void runKernel(String scriptLanguage, String logLevel, String connectionFile) {
        this.runKernel(scriptLanguage, logLevel, Paths.get(connectionFile, new String[0]));
    }

    @Override
    public void runKernel(String scriptLanguage, String logLevel, File connectionFile) {
        this.runKernel(scriptLanguage, logLevel, connectionFile.toPath());
    }

    @Override
    public void runKernel(String scriptLanguage, String logLevel, Path connectionFile) {
        KernelRunner.run(() -> {
            String id = Utils.uuid();
            ScijavaKernelConfigurationFile config = new ScijavaKernelConfigurationFile(this.context, scriptLanguage, logLevel, connectionFile);
            KernelSocketsFactoryImpl kernelSocketsFactory = new KernelSocketsFactoryImpl((ConfigurationFile)config);
            ScijavaEvaluator evaluator = new ScijavaEvaluator(this.context, id, id, config.getLanguageName());
            ScijavaKernel.scriptLanguage = evaluator.getScriptLanguage();
            return new ScijavaKernel(this.context, id, evaluator, config, kernelSocketsFactory);
        });
    }

    private Map<String, Object> parseArgumentsRun(String ... args) {
        if (args.length > 0) {
            try {
                Options options = new Options();
                options.addOption("connectionFile", true, "Connection File Path");
                options.addOption("language", true, "Language Name");
                options.addOption("verbose", true, "Verbose Mode");
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(options, args);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("connectionFile", cmd.getOptionValue("connectionFile"));
                parameters.put("scriptLanguage", cmd.getOptionValue("language"));
                parameters.put("logLevel", cmd.getOptionValue("verbose"));
                return parameters;
            }
            catch (ParseException ex) {
                this.log.error("Error parsing arguments : " + ex.toString());
            }
        } else {
            this.log.error("No parameters passed to the Scijava kernel.");
        }
        return null;
    }

    private Map<String, Object> parseArgumentsInstall(String ... args) {
        if (args.length > 0) {
            try {
                Options options = new Options();
                options.addOption("pythonBinaryPath", true, "Python Binary Path");
                options.addOption("language", true, "Language Name");
                options.addOption("verbose", true, "Verbose Mode");
                options.addOption("installAllKernels", "Install all the kernels ?");
                options.addOption("classpath", true, "Additional JAVA classpath ?");
                options.addOption("javaBinaryPath", true, "Java Binary Path");
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(options, args);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("pythonBinaryPath", cmd.getOptionValue("pythonBinaryPath"));
                if (!cmd.hasOption("installAllKernels")) {
                    parameters.put("scriptLanguage", cmd.getOptionValue("language"));
                    parameters.put("installAllKernels", false);
                } else {
                    parameters.put("installAllKernels", true);
                    parameters.put("scriptLanguage", "");
                }
                parameters.put("logLevel", cmd.getOptionValue("verbose"));
                if (cmd.getOptionValue("classpath") != null) {
                    parameters.put("classpath", cmd.getOptionValue("classpath"));
                } else {
                    parameters.put("classpath", null);
                }
                if (cmd.getOptionValue("javaBinaryPath") != null) {
                    parameters.put("javaBinaryPath", cmd.getOptionValue("javaBinaryPath"));
                } else {
                    parameters.put("javaBinaryPath", null);
                }
                return parameters;
            }
            catch (ParseException ex) {
                this.log.error("Error parsing arguments : " + ex.toString());
            }
        } else {
            this.log.error("No parameters passed to the Scijava kernel.");
        }
        return null;
    }
}

