/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.PairOfPointsNeighborhoodFactory;
import net.imglib2.util.Intervals;

public class PairOfPointsNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final long[] offset;
    private final int ndims;
    private final RandomAccess<T> ra;

    public static <T> PairOfPointsNeighborhoodFactory<T> factory() {
        return new PairOfPointsNeighborhoodFactory<T>(){

            @Override
            public Neighborhood<T> create(long[] position, long[] offset, RandomAccess<T> sourceRandomAccess) {
                return new PairOfPointsNeighborhood(position, offset, sourceRandomAccess);
            }
        };
    }

    PairOfPointsNeighborhood(long[] position, long[] offset, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.ra = sourceRandomAccess.copyRandomAccess();
        this.offset = offset;
        this.ndims = sourceRandomAccess.numDimensions();
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        int d;
        long[] minmax = new long[this.ndims * 2];
        for (d = 0; d < this.ndims; ++d) {
            minmax[d] = Math.min(this.position[d], this.position[d] + this.offset[d]);
        }
        for (d = this.ndims; d < 2 * this.ndims; ++d) {
            int sd = d - this.ndims;
            minmax[d] = Math.max(this.position[sd], this.position[sd] + this.offset[sd]);
        }
        return Intervals.createMinMax((long[])minmax);
    }

    public long size() {
        return 2L;
    }

    public T firstElement() {
        return this.cursor().next();
    }

    public Object iterationOrder() {
        return this;
    }

    public double realMin(int d) {
        return Math.min(this.position[d], this.position[d] + this.offset[d]);
    }

    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = Math.min(this.position[d], this.position[d] + this.offset[d]);
        }
    }

    public void realMin(RealPositionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(Math.min(this.position[d], this.position[d] + this.offset[d]), d);
        }
    }

    public double realMax(int d) {
        return Math.max(this.position[d], this.position[d] + this.offset[d]);
    }

    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = Math.max(this.position[d], this.position[d] + this.offset[d]);
        }
    }

    public void realMax(RealPositionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(Math.max(this.position[d], this.position[d] + this.offset[d]), d);
        }
    }

    public Iterator<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return Math.min(this.position[d], this.position[d] + this.offset[d]);
    }

    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = Math.min(this.position[d], this.position[d] + this.offset[d]);
        }
    }

    public void min(Positionable min) {
        for (int d = 0; d < min.numDimensions(); ++d) {
            min.setPosition(Math.min(this.position[d], this.position[d] + this.offset[d]), d);
        }
    }

    public long max(int d) {
        return Math.max(this.position[d], this.position[d] + this.offset[d]);
    }

    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = Math.max(this.position[d], this.position[d] + this.offset[d]);
        }
    }

    public void max(Positionable max) {
        for (int d = 0; d < max.numDimensions(); ++d) {
            max.setPosition(Math.max(this.position[d], this.position[d] + this.offset[d]), d);
        }
    }

    public void dimensions(long[] dimensions) {
        for (int d = 0; d < dimensions.length; ++d) {
            dimensions[d] = Math.abs(this.offset[d]) + 1L;
        }
    }

    public long dimension(int d) {
        return Math.abs(this.offset[d]) + 1L;
    }

    public LocalCursor cursor() {
        return new LocalCursor(this.ra.copyRandomAccess());
    }

    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    public class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private int index;
        private RandomAccess<T> source;

        private LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.reset();
        }

        private LocalCursor(LocalCursor c) {
            this(c.source.copyRandomAccess());
            this.index = c.index;
        }

        public T get() {
            return this.source.get();
        }

        public void fwd() {
            ++this.index;
            if (this.index == 1) {
                for (int d = 0; d < PairOfPointsNeighborhood.this.offset.length; ++d) {
                    this.source.move(PairOfPointsNeighborhood.this.offset[d], d);
                }
            }
        }

        public void jumpFwd(long steps) {
            for (long i = 0L; i < steps; ++i) {
                this.fwd();
            }
        }

        public T next() {
            this.fwd();
            return this.get();
        }

        public void remove() {
        }

        public void reset() {
            this.index = -1;
            this.source.setPosition(PairOfPointsNeighborhood.this.position);
        }

        public boolean hasNext() {
            return this.index < 1;
        }

        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        public void localize(long[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.source.getLongPosition(d);
            }
        }

        public void localize(float[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.source.getFloatPosition(d);
            }
        }

        public void localize(double[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.source.getDoublePosition(d);
            }
        }

        public void localize(int[] position) {
            for (int d = 0; d < position.length; ++d) {
                position[d] = this.source.getIntPosition(d);
            }
        }

        public LocalCursor copy() {
            return new LocalCursor(this);
        }

        public LocalCursor copyCursor() {
            return this.copy();
        }
    }
}

