/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.util.Arrays;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.gnur.api.GnuStringVector;
import org.renjin.gnur.api.UnimplementedGnuApiMethod;
import org.renjin.primitives.Vectors;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public final class Rinternals {
    public static SEXP R_GlobalEnv;
    public static SEXP R_EmptyEnv;
    public static SEXP R_BaseEnv;
    public static SEXP R_BaseNamespace;
    public static SEXP R_NamespaceRegistry;
    public static SEXP R_Srcref;
    public static SEXP R_NilValue;
    public static SEXP R_UnboundValue;
    public static SEXP R_MissingArg;
    public static SEXP R_RestartToken;
    public static SEXP R_baseSymbol;
    public static SEXP R_BaseSymbol;
    public static SEXP R_BraceSymbol;
    public static SEXP R_Bracket2Symbol;
    public static SEXP R_BracketSymbol;
    public static SEXP R_ClassSymbol;
    public static SEXP R_DeviceSymbol;
    public static SEXP R_DimNamesSymbol;
    public static SEXP R_DimSymbol;
    public static SEXP R_DollarSymbol;
    public static SEXP R_DotsSymbol;
    public static SEXP R_DoubleColonSymbol;
    public static SEXP R_DropSymbol;
    public static SEXP R_LastvalueSymbol;
    public static SEXP R_LevelsSymbol;
    public static SEXP R_ModeSymbol;
    public static SEXP R_NaRmSymbol;
    public static SEXP R_NameSymbol;
    public static SEXP R_NamesSymbol;
    public static SEXP R_NamespaceEnvSymbol;
    public static SEXP R_PackageSymbol;
    public static SEXP R_PreviousSymbol;
    public static SEXP R_QuoteSymbol;
    public static SEXP R_RowNamesSymbol;
    public static SEXP R_SeedsSymbol;
    public static SEXP R_SortListSymbol;
    public static SEXP R_SourceSymbol;
    public static SEXP R_SpecSymbol;
    public static SEXP R_TripleColonSymbol;
    public static SEXP R_TspSymbol;
    public static SEXP R_dot_defined;
    public static SEXP R_dot_Method;
    public static SEXP R_dot_packageName;
    public static SEXP R_dot_target;
    public static SEXP R_NaString;
    public static SEXP R_BlankString;
    public static SEXP R_BlankScalarString;

    private Rinternals() {
    }

    public static BytePtr R_CHAR(SEXP x) {
        GnuCharSexp charSexp = (GnuCharSexp)x;
        return charSexp.getValue();
    }

    public static boolean Rf_isNull(SEXP s) {
        return s == Null.INSTANCE;
    }

    public static boolean Rf_isSymbol(SEXP s) {
        return s instanceof Symbol;
    }

    public static boolean Rf_isLogical(SEXP s) {
        return s instanceof LogicalVector;
    }

    public static boolean Rf_isReal(SEXP s) {
        return s instanceof DoubleVector;
    }

    public static boolean Rf_isComplex(SEXP s) {
        return s instanceof ComplexVector;
    }

    public static boolean Rf_isExpression(SEXP s) {
        return s instanceof ExpressionVector;
    }

    public static boolean Rf_isEnvironment(SEXP s) {
        return s instanceof Environment;
    }

    public static boolean Rf_isString(SEXP s) {
        throw new UnimplementedGnuApiMethod("Rf_isString");
    }

    public static boolean Rf_isObject(SEXP s) {
        throw new UnimplementedGnuApiMethod("Rf_isObject");
    }

    public static SEXP ATTRIB(SEXP x) {
        return x.getAttributes().asPairList();
    }

    public static boolean OBJECT(SEXP x) {
        return x.isObject();
    }

    public static int MARK(SEXP x) {
        throw new UnimplementedGnuApiMethod("MARK");
    }

    public static int TYPEOF(SEXP s) {
        if (s == Null.INSTANCE) {
            return 0;
        }
        if (s instanceof ExpressionVector) {
            return 20;
        }
        if (s instanceof ListVector) {
            return 19;
        }
        if (s instanceof StringVector) {
            return 16;
        }
        if (s instanceof DoubleVector) {
            return 14;
        }
        if (s instanceof IntVector) {
            return 13;
        }
        if (s instanceof LogicalVector) {
            return 10;
        }
        if (s instanceof RawVector) {
            return 24;
        }
        if (s instanceof Environment) {
            return 4;
        }
        if (s instanceof ComplexVector) {
            return 15;
        }
        if (s instanceof Closure) {
            return 3;
        }
        if (s instanceof FunctionCall) {
            return 6;
        }
        if (s instanceof PairList) {
            return 2;
        }
        if (s instanceof S4Object) {
            return 25;
        }
        throw new UnsupportedOperationException("Unknown SEXP Type: " + s.getClass().getName());
    }

    public static int NAMED(SEXP sexp) {
        return 2;
    }

    public static void SET_NAMED(SEXP sexp, int value) {
    }

    public static int REFCNT(SEXP x) {
        throw new UnimplementedGnuApiMethod("REFCNT");
    }

    public static void SET_OBJECT(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_OBJECT");
    }

    public static void SET_TYPEOF(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_TYPEOF");
    }

    public static void SET_ATTRIB(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_ATTRIB");
    }

    public static void DUPLICATE_ATTRIB(SEXP to, SEXP from) {
        throw new UnimplementedGnuApiMethod("DUPLICATE_ATTRIB");
    }

    public static int IS_S4_OBJECT(SEXP x) {
        throw new UnimplementedGnuApiMethod("IS_S4_OBJECT");
    }

    public static void SET_S4_OBJECT(SEXP x) {
        throw new UnimplementedGnuApiMethod("SET_S4_OBJECT");
    }

    public static void UNSET_S4_OBJECT(SEXP x) {
        throw new UnimplementedGnuApiMethod("UNSET_S4_OBJECT");
    }

    public static int LENGTH(SEXP x) {
        return x.length();
    }

    public static int TRUELENGTH(SEXP x) {
        throw new UnimplementedGnuApiMethod("TRUELENGTH");
    }

    public static void SETLENGTH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SETLENGTH");
    }

    public static void SET_TRUELENGTH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_TRUELENGTH");
    }

    public static int XLENGTH(SEXP x) {
        return x.length();
    }

    public static int XTRUELENGTH(SEXP x) {
        throw new UnimplementedGnuApiMethod("XTRUELENGTH");
    }

    public static int IS_LONG_VEC(SEXP x) {
        throw new UnimplementedGnuApiMethod("IS_LONG_VEC");
    }

    public static int LEVELS(SEXP x) {
        throw new UnimplementedGnuApiMethod("LEVELS");
    }

    public static int SETLEVELS(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SETLEVELS");
    }

    public static IntPtr LOGICAL(SEXP x) {
        throw new UnimplementedGnuApiMethod("LOGICAL");
    }

    public static IntPtr INTEGER(SEXP x) {
        if (x instanceof IntArrayVector) {
            return new IntPtr(((IntArrayVector)x).toIntArrayUnsafe());
        }
        if (x instanceof IntVector) {
            return new IntPtr(((IntVector)x).toIntArray());
        }
        throw new EvalException("INTEGER(): expected integer vector, found %s", new Object[]{x.getTypeName()});
    }

    public static BytePtr RAW(SEXP x) {
        throw new UnimplementedGnuApiMethod("RAW");
    }

    public static DoublePtr REAL(SEXP x) {
        if (x instanceof DoubleArrayVector) {
            return new DoublePtr(((DoubleArrayVector)x).toDoubleArrayUnsafe());
        }
        if (x instanceof DoubleVector) {
            return new DoublePtr(((DoubleVector)x).toDoubleArray());
        }
        throw new EvalException("REAL(): expected numeric vector, found %s", new Object[]{x.getTypeName()});
    }

    public static DoublePtr COMPLEX(SEXP x) {
        throw new UnimplementedGnuApiMethod("COMPLEX");
    }

    public static SEXP STRING_ELT(SEXP x, int i) {
        StringVector stringVector = (StringVector)x;
        String string = stringVector.getElementAsString(i);
        return new GnuCharSexp(string);
    }

    public static SEXP VECTOR_ELT(SEXP x, int i) {
        return ((ListVector)x).getElementAsSEXP(i);
    }

    public static void SET_STRING_ELT(SEXP x, int index, SEXP value) {
        GnuStringVector stringVector = (GnuStringVector)x;
        GnuCharSexp charValue = (GnuCharSexp)value;
        stringVector.set(index, charValue);
    }

    public static SEXP SET_VECTOR_ELT(SEXP x, int index, SEXP value) {
        ListVector listVector = (ListVector)x;
        SEXP[] elements = listVector.toArrayUnsafe();
        elements[index] = value;
        return value;
    }

    public static SEXP TAG(SEXP e) {
        throw new UnimplementedGnuApiMethod("TAG");
    }

    public static SEXP CAR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CAR");
    }

    public static SEXP CDR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CDR");
    }

    public static SEXP CAAR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CAAR");
    }

    public static SEXP CDAR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CDAR");
    }

    public static SEXP CADR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CADR");
    }

    public static SEXP CDDR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CDDR");
    }

    public static SEXP CDDDR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CDDDR");
    }

    public static SEXP CADDR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CADDR");
    }

    public static SEXP CADDDR(SEXP e) {
        throw new UnimplementedGnuApiMethod("CADDDR");
    }

    public static SEXP CAD4R(SEXP e) {
        throw new UnimplementedGnuApiMethod("CAD4R");
    }

    public static int MISSING(SEXP x) {
        throw new UnimplementedGnuApiMethod("MISSING");
    }

    public static void SET_MISSING(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_MISSING");
    }

    public static void SET_TAG(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SET_TAG");
    }

    public static SEXP SETCAR(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCAR");
    }

    public static SEXP SETCDR(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCDR");
    }

    public static SEXP SETCADR(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCADR");
    }

    public static SEXP SETCADDR(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCADDR");
    }

    public static SEXP SETCADDDR(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCADDDR");
    }

    public static SEXP SETCAD4R(SEXP e, SEXP y) {
        throw new UnimplementedGnuApiMethod("SETCAD4R");
    }

    public static SEXP CONS_NR(SEXP a, SEXP b) {
        throw new UnimplementedGnuApiMethod("CONS_NR");
    }

    public static SEXP FORMALS(SEXP x) {
        throw new UnimplementedGnuApiMethod("FORMALS");
    }

    public static SEXP BODY(SEXP x) {
        throw new UnimplementedGnuApiMethod("BODY");
    }

    public static SEXP CLOENV(SEXP x) {
        throw new UnimplementedGnuApiMethod("CLOENV");
    }

    public static int RDEBUG(SEXP x) {
        throw new UnimplementedGnuApiMethod("RDEBUG");
    }

    public static int RSTEP(SEXP x) {
        throw new UnimplementedGnuApiMethod("RSTEP");
    }

    public static int RTRACE(SEXP x) {
        throw new UnimplementedGnuApiMethod("RTRACE");
    }

    public static void SET_RDEBUG(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RDEBUG");
    }

    public static void SET_RSTEP(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RSTEP");
    }

    public static void SET_RTRACE(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_RTRACE");
    }

    public static void SET_FORMALS(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_FORMALS");
    }

    public static void SET_BODY(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_BODY");
    }

    public static void SET_CLOENV(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_CLOENV");
    }

    public static SEXP PRINTNAME(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRINTNAME");
    }

    public static SEXP SYMVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("SYMVALUE");
    }

    public static SEXP INTERNAL(SEXP x) {
        throw new UnimplementedGnuApiMethod("INTERNAL");
    }

    public static int DDVAL(SEXP x) {
        throw new UnimplementedGnuApiMethod("DDVAL");
    }

    public static void SET_DDVAL(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_DDVAL");
    }

    public static void SET_PRINTNAME(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRINTNAME");
    }

    public static void SET_SYMVALUE(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_SYMVALUE");
    }

    public static void SET_INTERNAL(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_INTERNAL");
    }

    public static SEXP FRAME(SEXP x) {
        throw new UnimplementedGnuApiMethod("FRAME");
    }

    public static SEXP ENCLOS(SEXP x) {
        throw new UnimplementedGnuApiMethod("ENCLOS");
    }

    public static SEXP HASHTAB(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHTAB");
    }

    public static int ENVFLAGS(SEXP x) {
        throw new UnimplementedGnuApiMethod("ENVFLAGS");
    }

    public static void SET_ENVFLAGS(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_ENVFLAGS");
    }

    public static void SET_FRAME(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_FRAME");
    }

    public static void SET_ENCLOS(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_ENCLOS");
    }

    public static void SET_HASHTAB(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_HASHTAB");
    }

    public static SEXP PRCODE(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRCODE");
    }

    public static SEXP PRENV(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRENV");
    }

    public static SEXP PRVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRVALUE");
    }

    public static int PRSEEN(SEXP x) {
        throw new UnimplementedGnuApiMethod("PRSEEN");
    }

    public static void SET_PRSEEN(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_PRSEEN");
    }

    public static void SET_PRENV(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRENV");
    }

    public static void SET_PRVALUE(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRVALUE");
    }

    public static void SET_PRCODE(SEXP x, SEXP v) {
        throw new UnimplementedGnuApiMethod("SET_PRCODE");
    }

    public static int HASHASH(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHASH");
    }

    public static int HASHVALUE(SEXP x) {
        throw new UnimplementedGnuApiMethod("HASHVALUE");
    }

    public static void SET_HASHASH(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_HASHASH");
    }

    public static void SET_HASHVALUE(SEXP x, int v) {
        throw new UnimplementedGnuApiMethod("SET_HASHVALUE");
    }

    public static SEXP R_GetCurrentSrcref(int p0) {
        throw new UnimplementedGnuApiMethod("R_GetCurrentSrcref");
    }

    public static SEXP R_GetSrcFilename(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_GetSrcFilename");
    }

    public static SEXP Rf_asChar(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_asChar");
    }

    public static SEXP Rf_coerceVector(SEXP p0, int type) {
        switch (type) {
            case 13: {
                return Vectors.asInteger((Vector)((Vector)p0)).setAttributes(p0.getAttributes());
            }
            case 14: {
                return Vectors.asDouble((Vector)((Vector)p0)).setAttributes(p0.getAttributes());
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_coerceVector");
    }

    public static SEXP Rf_PairToVectorList(SEXP x) {
        throw new UnimplementedGnuApiMethod("Rf_PairToVectorList");
    }

    public static SEXP Rf_VectorToPairList(SEXP x) {
        throw new UnimplementedGnuApiMethod("Rf_VectorToPairList");
    }

    public static SEXP Rf_asCharacterFactor(SEXP x) {
        throw new UnimplementedGnuApiMethod("Rf_asCharacterFactor");
    }

    public static int Rf_asLogical(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x)) {
            if (Rinternals.XLENGTH(x) < 1) {
                return Integer.MIN_VALUE;
            }
            return ((AtomicVector)x).getElementAsRawLogical(0);
        }
        if (x instanceof GnuCharSexp) {
            return StringVector.logicalFromString((String)((GnuCharSexp)x).getValue().nullTerminatedString());
        }
        return LogicalVector.NA;
    }

    public static int Rf_asInteger(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x) && Rinternals.XLENGTH(x) >= 1) {
            if (x instanceof AtomicVector) {
                return ((AtomicVector)x).getElementAsInt(0);
            }
            throw Rinternals.UNIMPLEMENTED_TYPE("asInteger", x);
        }
        if (x instanceof CHARSEXP) {
            throw new UnsupportedOperationException();
        }
        return Integer.MIN_VALUE;
    }

    public static double Rf_asReal(SEXP x) {
        boolean warn = false;
        if (Rinternals.Rf_isVectorAtomic(x) && Rinternals.XLENGTH(x) >= 1) {
            if (x instanceof AtomicVector) {
                return ((AtomicVector)x).getElementAsDouble(0);
            }
            throw Rinternals.UNIMPLEMENTED_TYPE("asReal", x);
        }
        if (x instanceof CHARSEXP) {
            throw new UnsupportedOperationException();
        }
        return DoubleVector.NA;
    }

    private static EvalException UNIMPLEMENTED_TYPE(String s, SEXP t) {
        return new EvalException("unimplemented type '%s' in '%s'\n", new Object[]{t.getTypeName(), s});
    }

    public static BytePtr Rf_acopy_string(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_acopy_string");
    }

    public static void Rf_addMissingVarsToNewEnv(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_addMissingVarsToNewEnv");
    }

    public static SEXP Rf_alloc3DArray(int p0, int p1, int p2, int p3) {
        throw new UnimplementedGnuApiMethod("Rf_alloc3DArray");
    }

    public static SEXP Rf_allocArray(int p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_allocArray");
    }

    public static SEXP Rf_allocFormalsList2(SEXP sym1, SEXP sym2) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList2");
    }

    public static SEXP Rf_allocFormalsList3(SEXP sym1, SEXP sym2, SEXP sym3) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList3");
    }

    public static SEXP Rf_allocFormalsList4(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList4");
    }

    public static SEXP Rf_allocFormalsList5(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4, SEXP sym5) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList5");
    }

    public static SEXP Rf_allocFormalsList6(SEXP sym1, SEXP sym2, SEXP sym3, SEXP sym4, SEXP sym5, SEXP sym6) {
        throw new UnimplementedGnuApiMethod("Rf_allocFormalsList6");
    }

    public static SEXP Rf_allocMatrix(int type, int numRows, int numCols) {
        AttributeMap attributes = AttributeMap.builder().setDim(numRows, numCols).build();
        switch (type) {
            case 13: {
                return new IntArrayVector(new int[numRows * numCols], attributes);
            }
            case 14: {
                return new DoubleArrayVector(new double[numRows * numCols], attributes);
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static SEXP Rf_allocList(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_allocList");
    }

    public static SEXP Rf_allocS4Object() {
        throw new UnimplementedGnuApiMethod("Rf_allocS4Object");
    }

    public static SEXP Rf_allocSExp(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_allocSExp");
    }

    public static int Rf_any_duplicated(SEXP x, boolean from_last) {
        throw new UnimplementedGnuApiMethod("Rf_any_duplicated");
    }

    public static int Rf_any_duplicated3(SEXP x, SEXP incomp, boolean from_last) {
        throw new UnimplementedGnuApiMethod("Rf_any_duplicated3");
    }

    public static SEXP Rf_applyClosure(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        throw new UnimplementedGnuApiMethod("Rf_applyClosure");
    }

    public static SEXP Rf_classgets(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_classgets");
    }

    public static SEXP Rf_cons(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_cons");
    }

    public static void Rf_copyMatrix(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_copyMatrix");
    }

    public static void Rf_copyListMatrix(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_copyListMatrix");
    }

    public static void Rf_copyMostAttrib(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_copyMostAttrib");
    }

    public static void Rf_copyVector(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_copyVector");
    }

    public static int Rf_countContexts(int p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_countContexts");
    }

    public static SEXP Rf_CreateTag(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_CreateTag");
    }

    public static void Rf_defineVar(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_defineVar");
    }

    public static SEXP Rf_dimgets(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_dimgets");
    }

    public static SEXP Rf_dimnamesgets(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_dimnamesgets");
    }

    public static SEXP Rf_DropDims(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_DropDims");
    }

    public static SEXP Rf_duplicate(SEXP sexp) {
        if (sexp instanceof DoubleVector) {
            return new DoubleArrayVector((DoubleVector)sexp);
        }
        if (sexp instanceof IntVector) {
            return new IntArrayVector((IntVector)sexp);
        }
        throw new UnimplementedGnuApiMethod("Rf_duplicate: " + sexp.getTypeName());
    }

    public static SEXP Rf_shallow_duplicate(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_shallow_duplicate");
    }

    public static SEXP Rf_lazy_duplicate(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_lazy_duplicate");
    }

    public static SEXP Rf_duplicated(SEXP p0, boolean p1) {
        throw new UnimplementedGnuApiMethod("Rf_duplicated");
    }

    public static boolean R_envHasNoSpecialSymbols(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_envHasNoSpecialSymbols");
    }

    public static SEXP Rf_eval(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_eval");
    }

    public static SEXP Rf_findFun(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_findFun");
    }

    public static SEXP Rf_findVar(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_findVar");
    }

    public static SEXP Rf_findVarInFrame(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_findVarInFrame");
    }

    public static SEXP Rf_findVarInFrame3(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_findVarInFrame3");
    }

    public static SEXP Rf_getAttrib(SEXP sexp, SEXP attributeSexp) {
        return sexp.getAttribute((Symbol)attributeSexp);
    }

    public static SEXP Rf_GetArrayDimnames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetArrayDimnames");
    }

    public static SEXP Rf_GetColNames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetColNames");
    }

    public static SEXP Rf_GetOption(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_GetOption");
    }

    public static SEXP Rf_GetOption1(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetOption1");
    }

    public static int Rf_GetOptionDigits() {
        throw new UnimplementedGnuApiMethod("Rf_GetOptionDigits");
    }

    public static int Rf_GetOptionWidth() {
        throw new UnimplementedGnuApiMethod("Rf_GetOptionWidth");
    }

    public static SEXP Rf_GetRowNames(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_GetRowNames");
    }

    public static void Rf_gsetVar(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_gsetVar");
    }

    public static SEXP Rf_install(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_install");
    }

    public static SEXP Rf_installChar(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_installChar");
    }

    public static SEXP Rf_installDDVAL(int i) {
        throw new UnimplementedGnuApiMethod("Rf_installDDVAL");
    }

    public static SEXP Rf_installS3Signature(BytePtr p0, BytePtr p1) {
        throw new UnimplementedGnuApiMethod("Rf_installS3Signature");
    }

    public static boolean Rf_isFree(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isFree");
    }

    public static boolean Rf_isOrdered(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isOrdered");
    }

    public static boolean Rf_isUnordered(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isUnordered");
    }

    public static boolean Rf_isUnsorted(SEXP p0, boolean p1) {
        throw new UnimplementedGnuApiMethod("Rf_isUnsorted");
    }

    public static SEXP Rf_xlengthgets(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_xlengthgets");
    }

    public static SEXP R_lsInternal(SEXP p0, boolean p1) {
        throw new UnimplementedGnuApiMethod("R_lsInternal");
    }

    public static SEXP R_lsInternal3(SEXP p0, boolean p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("R_lsInternal3");
    }

    public static SEXP Rf_match(SEXP p0, SEXP p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_match");
    }

    public static SEXP Rf_matchE(SEXP p0, SEXP p1, int p2, SEXP p3) {
        throw new UnimplementedGnuApiMethod("Rf_matchE");
    }

    public static SEXP Rf_namesgets(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_namesgets");
    }

    public static SEXP Rf_mkChar(BytePtr string) {
        int length = string.nullTerminatedStringLength();
        byte[] copy = new byte[length + 1];
        System.arraycopy(string.array, string.offset, copy, 0, length);
        return new GnuCharSexp(copy);
    }

    public static SEXP Rf_mkCharLen(BytePtr p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_mkCharLen");
    }

    public static boolean Rf_NonNullStringMatch(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_NonNullStringMatch");
    }

    public static int Rf_ncols(SEXP s) {
        if (Rinternals.Rf_isVector(s) || Rinternals.Rf_isList(s)) {
            Vector dim = s.getAttributes().getDim();
            if (dim.length() >= 2) {
                return dim.getElementAsInt(1);
            }
            return 1;
        }
        if (Rinternals.Rf_isFrame(s)) {
            return Rinternals.Rf_length(s);
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    public static int Rf_nrows(SEXP s) {
        if (Rinternals.Rf_isVector(s) || Rinternals.Rf_isList(s)) {
            Vector dim = s.getAttributes().getDim();
            if (dim.length() >= 1) {
                return dim.getElementAsInt(0);
            }
            return 1;
        }
        if (Rinternals.Rf_isFrame(s)) {
            return Rinternals.Rf_nrows(s.getElementAsSEXP(0));
        }
        throw new EvalException("object is not a matrix", new Object[0]);
    }

    public static SEXP Rf_nthcdr(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_nthcdr");
    }

    public static boolean Rf_pmatch(SEXP p0, SEXP p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_pmatch");
    }

    public static boolean Rf_psmatch(BytePtr p0, BytePtr p1, boolean p2) {
        throw new UnimplementedGnuApiMethod("Rf_psmatch");
    }

    public static void Rf_PrintValue(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_PrintValue");
    }

    public static SEXP Rf_setAttrib(SEXP sexp, SEXP attributeName, SEXP newValue) {
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is NULL");
        }
        Symbol attributeSymbol = (Symbol)attributeName;
        AbstractSEXP abstractSEXP = (AbstractSEXP)sexp;
        abstractSEXP.unsafeSetAttributes(sexp.getAttributes().copy().set(attributeSymbol, newValue).build());
        return sexp;
    }

    public static void Rf_setVar(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_setVar");
    }

    public static SEXP Rf_stringSuffix(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_stringSuffix");
    }

    public static int Rf_str2type(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_str2type");
    }

    public static boolean Rf_StringBlank(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_StringBlank");
    }

    public static SEXP Rf_substitute(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_substitute");
    }

    public static BytePtr Rf_translateChar(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_translateChar");
    }

    public static BytePtr Rf_translateChar0(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_translateChar0");
    }

    public static BytePtr Rf_translateCharUTF8(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_translateCharUTF8");
    }

    public static BytePtr Rf_type2char(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2char");
    }

    public static SEXP Rf_type2rstr(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2rstr");
    }

    public static SEXP Rf_type2str(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2str");
    }

    public static SEXP Rf_type2str_nowarn(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_type2str_nowarn");
    }

    public static void Rf_unprotect_ptr(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_unprotect_ptr");
    }

    public static void R_signal_protect_error() {
        throw new UnimplementedGnuApiMethod("R_signal_protect_error");
    }

    public static void R_signal_unprotect_error() {
        throw new UnimplementedGnuApiMethod("R_signal_unprotect_error");
    }

    public static void R_signal_reprotect_error(int i) {
        throw new UnimplementedGnuApiMethod("R_signal_reprotect_error");
    }

    public static SEXP R_tryEval(SEXP p0, SEXP p1, IntPtr p2) {
        throw new UnimplementedGnuApiMethod("R_tryEval");
    }

    public static SEXP R_tryEvalSilent(SEXP p0, SEXP p1, IntPtr p2) {
        throw new UnimplementedGnuApiMethod("R_tryEvalSilent");
    }

    public static BytePtr R_curErrorBuf() {
        throw new UnimplementedGnuApiMethod("R_curErrorBuf");
    }

    public static boolean Rf_isS4(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isS4");
    }

    public static SEXP Rf_asS4(SEXP p0, boolean p1, int p2) {
        throw new UnimplementedGnuApiMethod("Rf_asS4");
    }

    public static SEXP Rf_S3Class(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_S3Class");
    }

    public static int Rf_isBasicClass(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_isBasicClass");
    }

    public static boolean R_cycle_detected(SEXP s, SEXP child) {
        throw new UnimplementedGnuApiMethod("R_cycle_detected");
    }

    public static SEXP R_forceAndCall(SEXP e, int n, SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_forceAndCall");
    }

    public static SEXP R_MakeExternalPtr(Ptr p, SEXP tag, SEXP prot) {
        throw new UnimplementedGnuApiMethod("R_MakeExternalPtr");
    }

    public static Ptr R_ExternalPtrAddr(SEXP s) {
        throw new UnimplementedGnuApiMethod("R_ExternalPtrAddr");
    }

    public static SEXP R_ExternalPtrTag(SEXP s) {
        throw new UnimplementedGnuApiMethod("R_ExternalPtrTag");
    }

    public static SEXP R_ExternalPtrProtected(SEXP s) {
        throw new UnimplementedGnuApiMethod("R_ExternalPtrProtected");
    }

    public static void R_ClearExternalPtr(SEXP s) {
        throw new UnimplementedGnuApiMethod("R_ClearExternalPtr");
    }

    public static void R_SetExternalPtrAddr(SEXP s, Ptr p) {
        throw new UnimplementedGnuApiMethod("R_SetExternalPtrAddr");
    }

    public static void R_SetExternalPtrTag(SEXP s, SEXP tag) {
        throw new UnimplementedGnuApiMethod("R_SetExternalPtrTag");
    }

    public static void R_SetExternalPtrProtected(SEXP s, SEXP p) {
        throw new UnimplementedGnuApiMethod("R_SetExternalPtrProtected");
    }

    public static void R_RegisterFinalizer(SEXP s, SEXP fun) {
        throw new UnimplementedGnuApiMethod("R_RegisterFinalizer");
    }

    public static void R_RegisterFinalizerEx(SEXP s, SEXP fun, boolean onexit) {
        throw new UnimplementedGnuApiMethod("R_RegisterFinalizerEx");
    }

    public static void R_RunPendingFinalizers() {
        throw new UnimplementedGnuApiMethod("R_RunPendingFinalizers");
    }

    public static SEXP R_MakeWeakRef(SEXP key, SEXP val, SEXP fin, boolean onexit) {
        throw new UnimplementedGnuApiMethod("R_MakeWeakRef");
    }

    public static SEXP R_WeakRefKey(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_WeakRefKey");
    }

    public static SEXP R_WeakRefValue(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_WeakRefValue");
    }

    public static void R_RunWeakRefFinalizer(SEXP w) {
        throw new UnimplementedGnuApiMethod("R_RunWeakRefFinalizer");
    }

    public static SEXP R_PromiseExpr(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_PromiseExpr");
    }

    public static SEXP R_ClosureExpr(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_ClosureExpr");
    }

    public static void R_initialize_bcode() {
        throw new UnimplementedGnuApiMethod("R_initialize_bcode");
    }

    public static SEXP R_bcEncode(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_bcEncode");
    }

    public static SEXP R_bcDecode(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_bcDecode");
    }

    public static void R_RestoreHashCount(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_RestoreHashCount");
    }

    public static boolean R_IsPackageEnv(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_IsPackageEnv");
    }

    public static SEXP R_PackageEnvName(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_PackageEnvName");
    }

    public static SEXP R_FindPackageEnv(SEXP info) {
        throw new UnimplementedGnuApiMethod("R_FindPackageEnv");
    }

    public static boolean R_IsNamespaceEnv(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_IsNamespaceEnv");
    }

    public static SEXP R_NamespaceEnvSpec(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_NamespaceEnvSpec");
    }

    public static SEXP R_FindNamespace(SEXP info) {
        throw new UnimplementedGnuApiMethod("R_FindNamespace");
    }

    public static void R_LockEnvironment(SEXP env, boolean bindings) {
        throw new UnimplementedGnuApiMethod("R_LockEnvironment");
    }

    public static boolean R_EnvironmentIsLocked(SEXP env) {
        throw new UnimplementedGnuApiMethod("R_EnvironmentIsLocked");
    }

    public static void R_LockBinding(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_LockBinding");
    }

    public static void R_unLockBinding(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_unLockBinding");
    }

    public static void R_MakeActiveBinding(SEXP sym, SEXP fun, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_MakeActiveBinding");
    }

    public static boolean R_BindingIsLocked(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_BindingIsLocked");
    }

    public static boolean R_BindingIsActive(SEXP sym, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_BindingIsActive");
    }

    public static boolean R_HasFancyBindings(SEXP rho) {
        throw new UnimplementedGnuApiMethod("R_HasFancyBindings");
    }

    public static void R_XDREncodeDouble(double d, Ptr buf) {
        throw new UnimplementedGnuApiMethod("R_XDREncodeDouble");
    }

    public static double R_XDRDecodeDouble(Ptr buf) {
        throw new UnimplementedGnuApiMethod("R_XDRDecodeDouble");
    }

    public static void R_XDREncodeInteger(int i, Ptr buf) {
        throw new UnimplementedGnuApiMethod("R_XDREncodeInteger");
    }

    public static int R_XDRDecodeInteger(Ptr buf) {
        throw new UnimplementedGnuApiMethod("R_XDRDecodeInteger");
    }

    public static SEXP R_do_slot(SEXP obj, SEXP name) {
        throw new UnimplementedGnuApiMethod("R_do_slot");
    }

    public static SEXP R_do_slot_assign(SEXP obj, SEXP name, SEXP value) {
        throw new UnimplementedGnuApiMethod("R_do_slot_assign");
    }

    public static int R_has_slot(SEXP obj, SEXP name) {
        throw new UnimplementedGnuApiMethod("R_has_slot");
    }

    public static SEXP R_do_MAKE_CLASS(BytePtr what) {
        throw new UnimplementedGnuApiMethod("R_do_MAKE_CLASS");
    }

    public static SEXP R_getClassDef(BytePtr what) {
        throw new UnimplementedGnuApiMethod("R_getClassDef");
    }

    public static SEXP R_getClassDef_R(SEXP what) {
        throw new UnimplementedGnuApiMethod("R_getClassDef_R");
    }

    public static boolean R_has_methods_attached() {
        throw new UnimplementedGnuApiMethod("R_has_methods_attached");
    }

    public static boolean R_isVirtualClass(SEXP class_def, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_isVirtualClass");
    }

    public static boolean R_extends(SEXP class1, SEXP class2, SEXP env) {
        throw new UnimplementedGnuApiMethod("R_extends");
    }

    public static SEXP R_do_new_object(SEXP class_def) {
        throw new UnimplementedGnuApiMethod("R_do_new_object");
    }

    public static void R_PreserveObject(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_PreserveObject");
    }

    public static void R_ReleaseObject(SEXP p0) {
        throw new UnimplementedGnuApiMethod("R_ReleaseObject");
    }

    public static void R_dot_Last() {
        throw new UnimplementedGnuApiMethod("R_dot_Last");
    }

    public static void R_RunExitFinalizers() {
        throw new UnimplementedGnuApiMethod("R_RunExitFinalizers");
    }

    public static int R_system(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("R_system");
    }

    public static boolean R_compute_identical(SEXP p0, SEXP p1, int p2) {
        throw new UnimplementedGnuApiMethod("R_compute_identical");
    }

    public static void R_orderVector(IntPtr indx, int n, SEXP arglist, boolean nalast, boolean decreasing) {
        throw new UnimplementedGnuApiMethod("R_orderVector");
    }

    public static SEXP Rf_allocVector(int type, int length) {
        switch (type) {
            case 13: {
                return new IntArrayVector(new int[length]);
            }
            case 14: {
                return new DoubleArrayVector(new double[length]);
            }
            case 10: {
                return new LogicalArrayVector(new int[length]);
            }
            case 19: {
                Object[] elements = new SEXP[length];
                Arrays.fill(elements, Null.INSTANCE);
                return new ListVector((SEXP[])elements);
            }
            case 16: {
                return new GnuStringVector(new BytePtr[length]);
            }
        }
        throw new UnimplementedGnuApiMethod("Rf_allocVector: type = " + type);
    }

    public static boolean Rf_conformable(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_conformable");
    }

    public static SEXP Rf_elt(SEXP p0, int p1) {
        throw new UnimplementedGnuApiMethod("Rf_elt");
    }

    public static boolean Rf_inherits(SEXP p0, BytePtr p1) {
        return p0.inherits(p1.nullTerminatedString());
    }

    public static boolean Rf_isArray(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isArray");
    }

    public static boolean Rf_isFactor(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isFactor");
    }

    public static boolean Rf_isFrame(SEXP s) {
        return s.inherits("data.frame");
    }

    public static boolean Rf_isFunction(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isFunction");
    }

    public static boolean Rf_isInteger(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isInteger");
    }

    public static boolean Rf_isLanguage(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isLanguage");
    }

    public static boolean Rf_isList(SEXP s) {
        return s == Null.INSTANCE || s instanceof PairList.Node;
    }

    public static boolean Rf_isMatrix(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isMatrix");
    }

    public static boolean Rf_isNewList(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isNewList");
    }

    public static boolean Rf_isNumber(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isNumber");
    }

    public static boolean Rf_isNumeric(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isNumeric");
    }

    public static boolean Rf_isPairList(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isPairList");
    }

    public static boolean Rf_isPrimitive(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isPrimitive");
    }

    public static boolean Rf_isTs(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isTs");
    }

    public static boolean Rf_isUserBinop(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isUserBinop");
    }

    public static boolean Rf_isValidString(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isValidString");
    }

    public static boolean Rf_isValidStringF(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isValidStringF");
    }

    public static boolean Rf_isVector(SEXP s) {
        return s instanceof Vector;
    }

    public static boolean Rf_isVectorAtomic(SEXP s) {
        return s instanceof AtomicVector;
    }

    public static boolean Rf_isVectorList(SEXP s) {
        return s instanceof ListVector;
    }

    public static boolean Rf_isVectorizable(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_isVectorizable");
    }

    public static SEXP Rf_lang1(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_lang1");
    }

    public static SEXP Rf_lang2(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_lang2");
    }

    public static SEXP Rf_lang3(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_lang3");
    }

    public static SEXP Rf_lang4(SEXP p0, SEXP p1, SEXP p2, SEXP p3) {
        throw new UnimplementedGnuApiMethod("Rf_lang4");
    }

    public static SEXP Rf_lang5(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        throw new UnimplementedGnuApiMethod("Rf_lang5");
    }

    public static SEXP Rf_lang6(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4, SEXP p5) {
        throw new UnimplementedGnuApiMethod("Rf_lang6");
    }

    public static SEXP Rf_lastElt(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_lastElt");
    }

    public static SEXP Rf_lcons(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_lcons");
    }

    public static int Rf_length(SEXP sexp) {
        return sexp.length();
    }

    public static SEXP Rf_list1(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_list1");
    }

    public static SEXP Rf_list2(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_list2");
    }

    public static SEXP Rf_list3(SEXP p0, SEXP p1, SEXP p2) {
        throw new UnimplementedGnuApiMethod("Rf_list3");
    }

    public static SEXP Rf_list4(SEXP p0, SEXP p1, SEXP p2, SEXP p3) {
        throw new UnimplementedGnuApiMethod("Rf_list4");
    }

    public static SEXP Rf_list5(SEXP p0, SEXP p1, SEXP p2, SEXP p3, SEXP p4) {
        throw new UnimplementedGnuApiMethod("Rf_list5");
    }

    public static SEXP Rf_listAppend(SEXP p0, SEXP p1) {
        throw new UnimplementedGnuApiMethod("Rf_listAppend");
    }

    public static SEXP Rf_mkNamed(int sexpType, ObjectPtr<BytePtr> names) {
        if (sexpType == 19) {
            String name;
            ListVector.NamedBuilder list = new ListVector.NamedBuilder();
            int i = 0;
            while (!(name = ((BytePtr)names.get(i)).nullTerminatedString()).isEmpty()) {
                list.add(name, (SEXP)Null.INSTANCE);
                ++i;
            }
            return list.build();
        }
        throw new UnsupportedOperationException("mkNamed: type = " + sexpType);
    }

    public static SEXP Rf_mkString(BytePtr p0) {
        throw new UnimplementedGnuApiMethod("Rf_mkString");
    }

    public static int Rf_nlevels(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_nlevels");
    }

    public static int Rf_stringPositionTr(SEXP p0, BytePtr p1) {
        throw new UnimplementedGnuApiMethod("Rf_stringPositionTr");
    }

    public static SEXP Rf_ScalarInteger(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_ScalarInteger");
    }

    public static SEXP Rf_ScalarLogical(int p0) {
        throw new UnimplementedGnuApiMethod("Rf_ScalarLogical");
    }

    public static SEXP Rf_ScalarReal(double p0) {
        throw new UnimplementedGnuApiMethod("Rf_ScalarReal");
    }

    public static SEXP Rf_ScalarString(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_ScalarString");
    }

    public static int Rf_xlength(SEXP p0) {
        throw new UnimplementedGnuApiMethod("Rf_xlength");
    }

    public static SEXP Rf_protect(SEXP p0) {
        return p0;
    }

    public static void Rf_unprotect(int p0) {
    }

    public static void R_ProtectWithIndex(SEXP p0, IntPtr p1) {
    }

    public static void R_Reprotect(SEXP p0, int p1) {
    }

    public static SEXP R_FixupRHS(SEXP x, SEXP y) {
        throw new UnimplementedGnuApiMethod("R_FixupRHS");
    }

    static {
        R_NilValue = Null.INSTANCE;
        R_UnboundValue = Symbol.UNBOUND_VALUE;
        R_MissingArg = Symbol.MISSING_ARG;
        R_baseSymbol = Symbol.get((String)"base");
        R_BaseSymbol = Symbol.get((String)"base");
        R_BraceSymbol = Symbol.get((String)"{");
        R_Bracket2Symbol = Symbol.get((String)"[[");
        R_BracketSymbol = Symbol.get((String)"[");
        R_ClassSymbol = Symbol.get((String)"class");
        R_DeviceSymbol = Symbol.get((String)".Device");
        R_DimNamesSymbol = Symbol.get((String)"dimnames");
        R_DimSymbol = Symbol.get((String)"dim");
        R_DollarSymbol = Symbol.get((String)"$");
        R_DotsSymbol = Symbol.get((String)"...");
        R_DoubleColonSymbol = Symbol.get((String)"::");
        R_DropSymbol = Symbol.get((String)"drop");
        R_LastvalueSymbol = Symbol.get((String)".Last.value");
        R_LevelsSymbol = Symbol.get((String)"level");
        R_ModeSymbol = Symbol.get((String)"mode");
        R_NaRmSymbol = Symbol.get((String)"na.rm");
        R_NameSymbol = Symbol.get((String)"name");
        R_NamesSymbol = Symbol.get((String)"names");
        R_NamespaceEnvSymbol = Symbol.get((String)".__NAMESPACE__.");
        R_PackageSymbol = Symbol.get((String)"package");
        R_PreviousSymbol = Symbol.get((String)"previous");
        R_QuoteSymbol = Symbol.get((String)"quote");
        R_RowNamesSymbol = Symbol.get((String)"row.names");
        R_SeedsSymbol = Symbol.get((String)".Random.seed");
        R_SortListSymbol = Symbol.get((String)"sort.list");
        R_SourceSymbol = Symbol.get((String)"source");
        R_SpecSymbol = Symbol.get((String)"spec");
        R_TripleColonSymbol = Symbol.get((String)":::");
        R_TspSymbol = Symbol.get((String)"tsp");
        R_dot_defined = Symbol.get((String)".defined");
        R_dot_Method = Symbol.get((String)".Method");
        R_dot_packageName = Symbol.get((String)".packageName");
        R_dot_target = Symbol.get((String)".target");
        R_NaString = null;
        R_BlankString = new GnuCharSexp("");
        R_BlankScalarString = new GnuStringVector("");
    }
}

