/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.jython;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.LinkedList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.scijava.log.LogService;
import org.scijava.plugins.scripting.jython.JythonScriptEngine;
import org.scijava.thread.ThreadService;

public class JythonReferenceCleaner {
    private final LinkedList<JythonEnginePhantomReference> phantomReferences = new LinkedList();
    private final ReferenceQueue<JythonScriptEngine> queue = new ReferenceQueue();
    private boolean shutDown = false;

    public synchronized void queueCleanup(JythonScriptEngine engine, ThreadService threadService, final LogService log) {
        this.phantomReferences.add(new JythonEnginePhantomReference(engine, this.queue));
        if (this.phantomReferences.size() == 1) {
            threadService.run(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean done = false;
                    while (!done) {
                        try {
                            Thread.sleep(100L);
                            JythonReferenceCleaner jythonReferenceCleaner = JythonReferenceCleaner.this;
                            synchronized (jythonReferenceCleaner) {
                                JythonEnginePhantomReference ref = (JythonEnginePhantomReference)JythonReferenceCleaner.this.queue.poll();
                                if (ref != null) {
                                    ref.cleanup();
                                    JythonReferenceCleaner.this.phantomReferences.remove(ref);
                                }
                                done = JythonReferenceCleaner.this.phantomReferences.size() == 0 || JythonReferenceCleaner.this.shutDown;
                            }
                        }
                        catch (Exception ex) {
                            log.error((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public void shutDown() {
        this.shutDown = true;
    }

    private static class JythonEnginePhantomReference
    extends PhantomReference<JythonScriptEngine> {
        public PythonInterpreter interpreter;

        public JythonEnginePhantomReference(JythonScriptEngine engine, ReferenceQueue<JythonScriptEngine> queue) {
            super(engine, queue);
            this.interpreter = engine.interpreter;
        }

        public void cleanup() {
            ArrayList<String> scriptLocals = new ArrayList<String>();
            PythonInterpreter interp = this.interpreter;
            if (interp == null) {
                return;
            }
            PyObject locals = interp.getLocals();
            for (PyObject item : locals.__iter__().asIterable()) {
                String localVar = item.toString();
                if (localVar.contains("__name__") || localVar.contains("__doc__")) continue;
                scriptLocals.add(item.toString());
            }
            for (String string : scriptLocals) {
                interp.set(string, null);
            }
        }
    }
}

