/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.Arrays;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.integer.Slicing;

public class SlicingRandomAccess<T>
extends AbstractLocalizable
implements RandomAccess<T> {
    private final RandomAccess<T> s;
    private final int m;
    private final boolean[] sourceZero;
    private final int[] sourceComponent;
    private final long[] tmpPosition;
    private final long[] tmpDistance;

    SlicingRandomAccess(RandomAccess<T> source, Slicing transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.m = transformToSource.numTargetDimensions();
        boolean[] targetZero = new boolean[this.m];
        int[] targetComponent = new int[this.m];
        transformToSource.getComponentZero(targetZero);
        transformToSource.getComponentMapping(targetComponent);
        this.sourceZero = new boolean[this.n];
        this.sourceComponent = new int[this.n];
        Arrays.fill(this.sourceZero, true);
        for (int d = 0; d < this.m; ++d) {
            if (targetZero[d]) {
                this.s.setPosition(transformToSource.getTranslation(d), d);
                continue;
            }
            int e = targetComponent[d];
            this.sourceZero[e] = false;
            this.sourceComponent[e] = d;
        }
        this.tmpPosition = new long[this.m];
        transformToSource.getTranslation(this.tmpPosition);
        this.tmpDistance = new long[this.m];
    }

    protected SlicingRandomAccess(SlicingRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.s = randomAccess.s.copyRandomAccess();
        this.m = randomAccess.m;
        this.sourceZero = (boolean[])randomAccess.sourceZero.clone();
        this.sourceComponent = (int[])randomAccess.sourceComponent.clone();
        this.tmpPosition = (long[])randomAccess.tmpPosition.clone();
        this.tmpDistance = (long[])randomAccess.tmpDistance.clone();
    }

    @Override
    public void fwd(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + 1L;
        if (!this.sourceZero[d]) {
            this.s.fwd(this.sourceComponent[d]);
        }
    }

    @Override
    public void bck(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] - 1L;
        if (!this.sourceZero[d]) {
            this.s.bck(this.sourceComponent[d]);
        }
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
        if (!this.sourceZero[d]) {
            this.s.move(distance, this.sourceComponent[d]);
        }
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (!this.sourceZero[d]) {
            this.s.move(distance, this.sourceComponent[d]);
        }
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long distance = localizable.getLongPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            if (this.sourceZero[d]) continue;
            this.tmpDistance[this.sourceComponent[d]] = distance;
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
            if (this.sourceZero[d]) continue;
            this.tmpDistance[this.sourceComponent[d]] = distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            if (this.sourceZero[d]) continue;
            this.tmpDistance[this.sourceComponent[d]] = distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = localizable.getLongPosition(d);
            if (this.sourceZero[d]) continue;
            this.tmpPosition[this.sourceComponent[d]] = p;
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = (long)position[d];
            if (this.sourceZero[d]) continue;
            this.tmpPosition[this.sourceComponent[d]] = p;
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            long p;
            this.position[d] = p = position[d];
            if (this.sourceZero[d]) continue;
            this.tmpPosition[this.sourceComponent[d]] = p;
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d < this.n);
        this.position[d] = position;
        if (!this.sourceZero[d]) {
            this.s.setPosition(position, this.sourceComponent[d]);
        }
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d < this.n);
        this.position[d] = position;
        if (!this.sourceZero[d]) {
            this.s.setPosition(position, this.sourceComponent[d]);
        }
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public SlicingRandomAccess<T> copy() {
        return new SlicingRandomAccess<T>(this);
    }

    @Override
    public SlicingRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }
}

