/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.scijava.ui.awt.AWTWindows;

public class SwingDialog {
    public static final int UNKNOWN_OPTION = -14614183;
    private final JOptionPane optionPane;
    private Component buttons;
    private Component parentComponent;
    private Component focusComponent;
    private String title;
    private boolean modal = true;
    private boolean resizable = true;
    private boolean sizeLimited = true;

    public SwingDialog(Component c, int messageType, boolean scrollBars) {
        this(c, -1, messageType, scrollBars);
    }

    public SwingDialog(Component c, int optionType, int messageType, boolean scrollBars) {
        this.optionPane = new JOptionPane(c, messageType, optionType);
        this.rebuildPane(scrollBars);
    }

    public Component getParent() {
        return this.parentComponent;
    }

    public void setParent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public Component getFocus() {
        return this.focusComponent;
    }

    public void setFocus(Component focusComponent) {
        this.focusComponent = focusComponent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
        this.buttons.setVisible(modal);
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isSizeLimited() {
        return this.sizeLimited;
    }

    public void setSizeLimited(boolean sizeLimited) {
        this.sizeLimited = sizeLimited;
    }

    public int show() {
        JDialog dialog = this.optionPane.createDialog(this.parentComponent, this.title);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(this.resizable);
        dialog.setModal(this.modal);
        dialog.pack();
        if (this.sizeLimited) {
            AWTWindows.ensureSizeReasonable((Window)dialog);
        }
        dialog.setSize(dialog.getSize().width + 20, dialog.getSize().height);
        AWTWindows.centerWindow((Window)dialog);
        if (this.focusComponent != null) {
            this.setDefaultFocusComponent(dialog, this.focusComponent);
        }
        dialog.setVisible(true);
        if (this.modal) {
            dialog.dispose();
        }
        if (!this.modal) {
            return 0;
        }
        Object result = this.optionPane.getValue();
        if (result == null || !(result instanceof Integer)) {
            return -14614183;
        }
        return (Integer)result;
    }

    public boolean isVisible() {
        return this.optionPane.isVisible();
    }

    private void rebuildPane(boolean scrollBars) {
        Component[] optionComponents = this.optionPane.getComponents();
        int messageIndex = 0;
        int buttonIndex = optionComponents.length - 1;
        for (int i = 0; i < optionComponents.length; ++i) {
            String compName = optionComponents[i].getName();
            if ("OptionPane.messageArea".equals(compName)) {
                messageIndex = i;
                continue;
            }
            if (!"OptionPane.buttonArea".equals(compName)) continue;
            buttonIndex = i;
        }
        Component mainPane = optionComponents[messageIndex];
        Component buttonPane = optionComponents[buttonIndex];
        if (scrollBars) {
            JScrollPane wrappedMainPane = new JScrollPane(mainPane);
            JPanel wrappedButtonPane = new JPanel();
            wrappedButtonPane.setLayout(new BorderLayout());
            wrappedButtonPane.add(buttonPane);
            Border border = this.optionPane.getBorder();
            Insets insets = border.getBorderInsets(this.optionPane);
            wrappedButtonPane.setBorder(new EmptyBorder(0, insets.left, insets.bottom, insets.right));
            this.optionPane.setBorder(null);
            this.optionPane.removeAll();
            for (int i = 0; i < optionComponents.length; ++i) {
                if (i == messageIndex) {
                    this.optionPane.add(wrappedMainPane);
                    continue;
                }
                if (i == buttonIndex) {
                    this.optionPane.add(wrappedButtonPane);
                    continue;
                }
                this.optionPane.add(optionComponents[i]);
            }
            this.buttons = wrappedButtonPane;
        } else {
            this.buttons = buttonPane;
        }
    }

    private void setDefaultFocusComponent(Window w, final Component c) {
        w.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                c.requestFocusInWindow();
            }
        });
    }
}

