/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MIMEType {
    private static final String CLASS_PARAM = "class";
    private final String base;
    private final List<String> paramNames;
    private final Map<String, String> params;

    public MIMEType(String mimeType) {
        this(mimeType, null);
    }

    public MIMEType(String mimeType, Class<?> javaType) {
        StringTokenizer st = new StringTokenizer(mimeType, ";");
        this.base = st.nextToken().trim();
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        while (st.hasMoreTokens()) {
            String param = st.nextToken();
            int equals = param.indexOf("=");
            if (equals < 0) continue;
            String name = param.substring(0, equals).trim();
            String value = param.substring(equals + 1).trim();
            names.add(name);
            map.put(name, value);
        }
        if (javaType != null) {
            String mimeClassName = (String)map.get(CLASS_PARAM);
            String javaClassName = javaType.getName();
            if (mimeClassName == null) {
                map.put(CLASS_PARAM, javaClassName);
            } else if (!mimeClassName.equals(javaClassName)) {
                throw new IllegalArgumentException("MIME class (" + mimeClassName + ") and Java class (" + javaClassName + ") do not match");
            }
        }
        this.paramNames = Collections.unmodifiableList(names);
        this.params = Collections.unmodifiableMap(map);
    }

    public String getBase() {
        return this.base;
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public List<String> getParameters() {
        return this.paramNames;
    }

    public boolean isCompatible(MIMEType mimeType) {
        if (!this.getBase().equals(mimeType.getBase())) {
            return false;
        }
        for (String name : this.getParameters()) {
            if (this.getParameter(name).equals(mimeType.getParameter(name))) continue;
            return false;
        }
        return true;
    }

    public boolean isCompatible(Class<?> javaType) {
        return javaType.getName().equals(this.getParameter(CLASS_PARAM));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MIMEType)) {
            return false;
        }
        MIMEType mimeType = (MIMEType)o;
        return this.isCompatible(mimeType) && mimeType.isCompatible(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getBase());
        for (String name : this.getParameters()) {
            sb.append("; ");
            sb.append(name);
            sb.append("=");
            sb.append(this.getParameter(name));
        }
        return sb.toString();
    }
}

