/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command.run;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.run.AbstractCodeRunner;
import org.scijava.run.CodeRunner;

@Plugin(type=CodeRunner.class)
public class CommandCodeRunner
extends AbstractCodeRunner {
    @Parameter
    private CommandService commandService;

    @Override
    public void run(Object code, Object ... args) throws InvocationTargetException {
        CommandInfo info;
        Class<? extends Command> c = this.getCommandClass(code);
        if (c != null) {
            this.waitFor(this.commandService.run(c, true, args));
        }
        if ((info = this.getCommandInfo(code)) != null) {
            this.waitFor(this.commandService.run(info, true, args));
        }
    }

    @Override
    public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
        CommandInfo info;
        Class<? extends Command> c = this.getCommandClass(code);
        if (c != null) {
            this.waitFor(this.commandService.run(c, true, inputMap));
        }
        if ((info = this.getCommandInfo(code)) != null) {
            this.waitFor(this.commandService.run(info, true, inputMap));
        }
    }

    @Override
    public boolean supports(Object code) {
        return this.getCommandClass(code) != null || this.getCommandInfo(code) != null;
    }

    private Class<? extends Command> getCommandClass(Object code) {
        if (!(code instanceof Class)) {
            return null;
        }
        Class c = (Class)code;
        if (!Command.class.isAssignableFrom(c)) {
            return null;
        }
        Class commandClass = c;
        return commandClass;
    }

    private CommandInfo getCommandInfo(Object code) {
        if (!(code instanceof String)) {
            return null;
        }
        String command = (String)code;
        CommandInfo info = this.commandService.getCommand(command);
        if (info != null) {
            return info;
        }
        for (CommandInfo ci : this.commandService.getCommands()) {
            if (!command.equals(ci.getTitle())) continue;
            return ci;
        }
        return null;
    }
}

