/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.undo.AbstractUndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AbstractDrawingViewAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class DrawingAttributeAction
extends AbstractDrawingViewAction {
    protected Map<AttributeKey, Object> attributes;

    public <T> DrawingAttributeAction(DrawingEditor editor, AttributeKey<T> key, @Nullable T value) {
        this(editor, key, value, null, null);
    }

    public <T> DrawingAttributeAction(DrawingEditor editor, AttributeKey<T> key, @Nullable T value, @Nullable Icon icon) {
        this(editor, key, value, null, icon);
    }

    public <T> DrawingAttributeAction(DrawingEditor editor, AttributeKey<T> key, @Nullable T value, @Nullable String name) {
        this(editor, key, value, name, null);
    }

    public <T> DrawingAttributeAction(DrawingEditor editor, AttributeKey<T> key, @Nullable T value, @Nullable String name, @Nullable Icon icon) {
        this(editor, key, value, name, icon, null);
    }

    public <T> DrawingAttributeAction(DrawingEditor editor, AttributeKey<T> key, @Nullable T value, @Nullable String name, @Nullable Icon icon, @Nullable Action compatibleTextAction) {
        super(editor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(key, value);
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public DrawingAttributeAction(DrawingEditor editor, Map<AttributeKey, Object> attributes, String name, Icon icon) {
        super(editor);
        this.attributes = attributes;
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final ArrayList<Object> restoreData = new ArrayList<Object>();
        final Drawing drawing = this.getView().getDrawing();
        restoreData.add(drawing.getAttributesRestoreData());
        drawing.willChange();
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            drawing.set(entry.getKey(), entry.getValue());
        }
        drawing.changed();
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                String name = (String)DrawingAttributeAction.this.getValue("undoPresentationName");
                if (name == null) {
                    name = (String)DrawingAttributeAction.this.getValue("Name");
                }
                if (name == null) {
                    ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                    name = labels.getString("attribute.text");
                }
                return name;
            }

            @Override
            public void undo() {
                super.undo();
                Iterator iRestore = restoreData.iterator();
                drawing.willChange();
                drawing.restoreAttributesTo(iRestore.next());
                drawing.changed();
            }

            @Override
            public void redo() {
                super.redo();
                drawing.willChange();
                for (Map.Entry<AttributeKey, Object> entry : DrawingAttributeAction.this.attributes.entrySet()) {
                    drawing.set(entry.getKey(), entry.getValue());
                }
                drawing.changed();
            }
        };
        this.fireUndoableEditHappened(edit);
    }
}

