/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.jupyter;

import com.twosigma.beaker.autocomplete.AutocompleteResult;
import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.evaluator.EvaluatorManager;
import com.twosigma.beaker.jupyter.KernelManager;
import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jupyter.handler.CommOpenHandler;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.beaker.jupyter.threads.ExecutionResultSender;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.KernelHandlers;
import com.twosigma.jupyter.KernelParameters;
import com.twosigma.jupyter.KernelSockets;
import com.twosigma.jupyter.KernelSocketsFactory;
import com.twosigma.jupyter.handler.Handler;
import com.twosigma.jupyter.handler.KernelHandler;
import com.twosigma.jupyter.message.Message;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public abstract class Kernel
implements KernelFunctionality {
    private static final Logger logger = LoggerFactory.getLogger(Kernel.class);
    public static String OS = System.getProperty("os.name").toLowerCase();
    private String sessionId;
    private KernelSocketsFactory kernelSocketsFactory;
    private KernelHandlers handlers;
    private Map<String, Comm> commMap;
    private ExecutionResultSender executionResultSender;
    private EvaluatorManager evaluatorManager;
    private KernelSockets kernelSockets;

    public Kernel(String sessionId, Evaluator evaluator, KernelSocketsFactory kernelSocketsFactory) {
        this.sessionId = sessionId;
        this.kernelSocketsFactory = kernelSocketsFactory;
        this.commMap = new ConcurrentHashMap<String, Comm>();
        this.executionResultSender = new ExecutionResultSender(this);
        this.evaluatorManager = new EvaluatorManager(this, evaluator);
        this.handlers = new KernelHandlers(this, this.getCommOpenHandler(this), this.getKernelInfoHandler(this));
        this.configureSignalHandler();
    }

    public abstract CommOpenHandler getCommOpenHandler(Kernel var1);

    public abstract KernelHandler<Message> getKernelInfoHandler(Kernel var1);

    @Override
    public void run() {
        KernelManager.register(this);
        logger.debug("Jupyter kernel starting.");
        this.kernelSockets = this.kernelSocketsFactory.create(this, this::closeComms);
        this.kernelSockets.start();
        try {
            this.kernelSockets.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.exit();
        }
        logger.debug("Jupyter kernel shoutdown.");
    }

    private void exit() {
        this.evaluatorManager.exit();
        this.handlers.exit();
        this.executionResultSender.exit();
    }

    private void closeComms() {
        this.commMap.values().forEach(Comm::close);
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    @Override
    public synchronized void setShellOptions(KernelParameters kernelParameters) {
        this.evaluatorManager.setShellOptions(kernelParameters);
    }

    @Override
    public synchronized void cancelExecution() {
        this.evaluatorManager.killAllThreads();
    }

    @Override
    public synchronized boolean isCommPresent(String hash) {
        return this.commMap.containsKey(hash);
    }

    @Override
    public Set<String> getCommHashSet() {
        return this.commMap.keySet();
    }

    @Override
    public synchronized void addComm(String hash, Comm commObject) {
        if (!this.isCommPresent(hash)) {
            this.commMap.put(hash, commObject);
        }
    }

    @Override
    public synchronized Comm getComm(String hash) {
        return this.commMap.get(hash != null ? hash : "");
    }

    @Override
    public synchronized void removeComm(String hash) {
        if (hash != null && this.isCommPresent(hash)) {
            this.commMap.remove(hash);
        }
    }

    @Override
    public synchronized void publish(Message message) {
        this.kernelSockets.publish(message);
    }

    @Override
    public synchronized void send(Message message) {
        this.kernelSockets.send(message);
    }

    @Override
    public Handler<Message> getHandler(JupyterMessages type) {
        return this.handlers.get(type);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public ExecutionResultSender getExecutionResultSender() {
        return this.executionResultSender;
    }

    private void configureSignalHandler() {
        SignalHandler handler = new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                logger.info("Got " + sig.getName() + " signal, canceling cell execution");
                Kernel.this.cancelExecution();
            }
        };
        if (!Kernel.isWindows()) {
            Signal.handle(new Signal("INT"), handler);
        }
    }

    @Override
    public SimpleEvaluationObject executeCode(String code, Message message, int executionCount) {
        return this.evaluatorManager.executeCode(code, message, executionCount);
    }

    @Override
    public AutocompleteResult autocomplete(String code, int cursorPos) {
        return this.evaluatorManager.autocomplete(code, cursorPos);
    }
}

