/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.widgets;

import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jupyter.comm.TargetNamesEnum;
import com.twosigma.beaker.widgets.internal.CommWidget;
import java.io.Serializable;
import java.util.HashMap;

public abstract class Widget
implements CommWidget {
    public static final String MODEL_MODULE = "_model_module";
    public static final String MODEL_NAME = "_model_name";
    public static final String VIEW_MODULE = "_view_module";
    public static final String VIEW_NAME = "_view_name";
    public static final String MODEL_MODULE_VALUE = "jupyter-js-widgets";
    public static final String VIEW_MODULE_VALUE = "jupyter-js-widgets";
    public static final String VALUE = "value";
    public static final String DISABLED = "disabled";
    public static final String VISIBLE = "visible";
    public static final String DESCRIPTION = "description";
    public static final String MSG_THROTTLE = "msg_throttle";
    private Comm comm = new Comm(TargetNamesEnum.JUPYTER_WIDGET);

    protected void openComm() {
        this.comm.setData(this.createContent());
        this.addValueChangeMsgCallback();
        this.comm.open();
    }

    @Override
    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    private HashMap<String, Serializable> createContent() {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(MODEL_MODULE, (Serializable)((Object)"jupyter-js-widgets"));
        result.put(VIEW_MODULE, (Serializable)((Object)"jupyter-js-widgets"));
        result.put(MODEL_NAME, (Serializable)((Object)this.getModelNameValue()));
        result.put(VIEW_NAME, (Serializable)((Object)this.getViewNameValue()));
        result = this.content(result);
        return result;
    }

    protected abstract void addValueChangeMsgCallback();

    protected abstract HashMap<String, Serializable> content(HashMap<String, Serializable> var1);

    @Override
    public Comm getComm() {
        return this.comm;
    }

    public void sendUpdate(String propertyName, Object value) {
        this.comm.sendUpdate(propertyName, value);
    }
}

