/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.table;

import com.twosigma.beaker.chart.Color;
import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.jvm.serialization.BasicObjectSerializer;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.table.ColumnType;
import com.twosigma.beaker.table.ObservableTableDisplay;
import com.twosigma.beaker.table.TableDisplayAlignmentProvider;
import com.twosigma.beaker.table.format.TableDisplayStringFormat;
import com.twosigma.beaker.table.format.ValueStringFormat;
import com.twosigma.beaker.table.highlight.TableDisplayCellHighlighter;
import com.twosigma.beaker.table.highlight.ValueHighlighter;
import com.twosigma.beaker.table.renderer.TableDisplayCellRenderer;
import com.twosigma.beaker.widgets.internal.InternalCommWidget;
import com.twosigma.beaker.widgets.internal.InternalWidgetContent;
import com.twosigma.beaker.widgets.internal.InternalWidgetUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDisplay
extends ObservableTableDisplay
implements InternalCommWidget {
    public static final String VIEW_NAME_VALUE = "TableDisplayView";
    public static final String MODEL_NAME_VALUE = "TableDisplayModel";
    public static final String TABLE_DISPLAY_SUBTYPE = "TableDisplay";
    public static final String LIST_OF_MAPS_SUBTYPE = "ListOfMaps";
    public static final String MATRIX_SUBTYPE = "Matrix";
    public static final String DICTIONARY_SUBTYPE = "Dictionary";
    private static final Logger logger = LoggerFactory.getLogger((String)TableDisplay.class.getName());
    private final List<List<?>> values;
    private List<String> columns;
    private final List<String> classes;
    private String subtype;
    private TimeUnit stringFormatForTimes;
    private Map<ColumnType, TableDisplayStringFormat> stringFormatForType = new HashMap<ColumnType, TableDisplayStringFormat>();
    private Map<String, TableDisplayStringFormat> stringFormatForColumn = new HashMap<String, TableDisplayStringFormat>();
    private Map<ColumnType, TableDisplayCellRenderer> rendererForType = new HashMap<ColumnType, TableDisplayCellRenderer>();
    private Map<String, TableDisplayCellRenderer> rendererForColumn = new HashMap<String, TableDisplayCellRenderer>();
    private Map<ColumnType, TableDisplayAlignmentProvider> alignmentForType = new HashMap<ColumnType, TableDisplayAlignmentProvider>();
    private Map<String, TableDisplayAlignmentProvider> alignmentForColumn = new HashMap<String, TableDisplayAlignmentProvider>();
    private Map<String, Boolean> columnsFrozen = new HashMap<String, Boolean>();
    private Map<String, Boolean> columnsFrozenRight = new HashMap<String, Boolean>();
    private Map<String, Boolean> columnsVisible = new HashMap<String, Boolean>();
    private List<String> columnOrder = new ArrayList<String>();
    private List<TableDisplayCellHighlighter> cellHighlighters = new ArrayList<TableDisplayCellHighlighter>();
    private List<List<String>> tooltips = new ArrayList<List<String>>();
    private Integer dataFontSize;
    private Integer headerFontSize;
    private List<List<Color>> fontColor = new ArrayList<List<Color>>();
    private List<List<?>> filteredValues;
    private boolean headersVertical;
    private String hasIndex;
    private String timeZone;
    private Comm comm;

    @Override
    public Comm getComm() {
        return this.comm;
    }

    @Override
    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    @Override
    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    @Override
    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public TableDisplay(List<List<?>> v, List<String> co, List<String> cl) {
        this.values = v;
        this.columns = co;
        this.classes = cl;
        this.subtype = TABLE_DISPLAY_SUBTYPE;
        this.open();
    }

    public TableDisplay(Collection<Map<?, ?>> v) {
        this(v, new BasicObjectSerializer());
        this.open();
    }

    public TableDisplay(Collection<Map<?, ?>> v, BeakerObjectConverter serializer) {
        this.values = new ArrayList();
        this.columns = new ArrayList<String>();
        this.classes = new ArrayList<String>();
        this.subtype = LIST_OF_MAPS_SUBTYPE;
        for (Map<?, ?> m : v) {
            Set<Map.Entry<?, ?>> w = m.entrySet();
            for (Map.Entry<?, ?> s : w) {
                Map.Entry<?, ?> e = s;
                String c = e.getKey().toString();
                if (this.columns.contains(c)) continue;
                this.columns.add(c);
                String n = e.getValue() != null ? e.getValue().getClass().getName() : "string";
                this.classes.add(serializer.convertType(n));
            }
        }
        for (Map<?, ?> m : v) {
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String cn : this.columns) {
                if (m.containsKey(cn)) {
                    vals.add(this.getValueForSerializer(m.get(cn), serializer));
                    continue;
                }
                vals.add(null);
            }
            this.values.add(vals);
        }
    }

    private TableDisplay(Map<?, ?> v) {
        this.values = new ArrayList();
        this.columns = Arrays.asList("Key", "Value");
        this.classes = new ArrayList<String>();
        this.subtype = DICTIONARY_SUBTYPE;
        Set<Map.Entry<?, ?>> w = v.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = w.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> s;
            Map.Entry<?, ?> e = s = iterator.next();
            this.values.add(Arrays.asList(e.getKey().toString(), e.getValue()));
        }
        this.open();
    }

    public static TableDisplay createTableDisplayForMap(Map<?, ?> v) {
        return new TableDisplay(v);
    }

    private void open() {
        this.comm = InternalWidgetUtils.createComm(this, new InternalWidgetContent(){

            @Override
            public void addContent(HashMap<String, Serializable> content) {
                content.put("_model_name", (Serializable)((Object)TableDisplay.this.getModelNameValue()));
                content.put("_view_name", (Serializable)((Object)TableDisplay.this.getViewNameValue()));
            }
        });
    }

    public TimeUnit getStringFormatForTimes() {
        return this.stringFormatForTimes;
    }

    public void setStringFormatForTimes(TimeUnit stringFormatForTimes) {
        this.stringFormatForTimes = stringFormatForTimes;
    }

    public Map<ColumnType, TableDisplayStringFormat> getStringFormatForType() {
        return this.stringFormatForType;
    }

    public void setStringFormatForType(ColumnType type, TableDisplayStringFormat format) {
        this.stringFormatForType.put(type, format);
    }

    public Map<String, TableDisplayStringFormat> getStringFormatForColumn() {
        return this.stringFormatForColumn;
    }

    public void setStringFormatForColumn(String column, TableDisplayStringFormat format) {
        this.stringFormatForColumn.put(column, format);
    }

    public void setStringFormatForColumn(String column, Object closure) {
        int colIndex = this.columns.indexOf(column);
        if (colIndex == -1) {
            throw new IllegalArgumentException("Column " + column + " doesn't exist");
        }
        ArrayList<String> formattedValues = new ArrayList<String>();
        try {
            for (int row = 0; row < this.values.size(); ++row) {
                Object value = this.values.get(row).get(colIndex);
                Object[] params = new Object[]{value, row, colIndex, this};
                formattedValues.add((String)this.runClosure(closure, params));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not create format using closure.", e);
        }
        this.stringFormatForColumn.put(column, new ValueStringFormat(column, formattedValues));
    }

    public Map<ColumnType, TableDisplayCellRenderer> getRendererForType() {
        return this.rendererForType;
    }

    public void setRendererForType(ColumnType type, TableDisplayCellRenderer renderer) {
        this.rendererForType.put(type, renderer);
    }

    public Map<String, TableDisplayCellRenderer> getRendererForColumn() {
        return this.rendererForColumn;
    }

    public void setRendererForColumn(String column, TableDisplayCellRenderer renderer) {
        this.rendererForColumn.put(column, renderer);
    }

    public Map<ColumnType, TableDisplayAlignmentProvider> getAlignmentForType() {
        return this.alignmentForType;
    }

    public void setAlignmentProviderForType(ColumnType type, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForType.put(type, alignmentProvider);
    }

    public Map<String, TableDisplayAlignmentProvider> getAlignmentForColumn() {
        return this.alignmentForColumn;
    }

    public void setAlignmentProviderForColumn(String column, TableDisplayAlignmentProvider alignmentProvider) {
        this.alignmentForColumn.put(column, alignmentProvider);
    }

    public Map<String, Boolean> getColumnsFrozen() {
        return this.columnsFrozen;
    }

    public void setColumnFrozen(String column, boolean frozen) {
        this.columnsFrozen.put(column, frozen);
    }

    public Map<String, Boolean> getColumnsFrozenRight() {
        return this.columnsFrozenRight;
    }

    public void setColumnFrozenRight(String column, boolean frozen) {
        this.columnsFrozenRight.put(column, frozen);
    }

    public Map<String, Boolean> getColumnsVisible() {
        return this.columnsVisible;
    }

    public void setColumnVisible(String column, boolean visible) {
        this.columnsVisible.put(column, visible);
    }

    public List<String> getColumnOrder() {
        return this.columnOrder;
    }

    public List<TableDisplayCellHighlighter> getCellHighlighters() {
        return this.cellHighlighters;
    }

    public void addCellHighlighter(TableDisplayCellHighlighter cellHighlighter) {
        this.cellHighlighters.add(cellHighlighter);
    }

    public void addCellHighlighter(Object closure) {
        HashMap colors = new HashMap();
        try {
            int rowSize = this.values.get(0).size();
            for (int colInd = 0; colInd < rowSize; ++colInd) {
                boolean hasHighlightedValues = false;
                ArrayList<Color> columnColors = new ArrayList<Color>();
                for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    Color color = (Color)this.runClosure(closure, params);
                    if (color != null) {
                        hasHighlightedValues = true;
                    }
                    columnColors.add(color);
                }
                if (!hasHighlightedValues) continue;
                this.cellHighlighters.add(new ValueHighlighter(this.columns.get(colInd), columnColors));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set cell highlighter using closure.", e);
        }
    }

    public void removeAllCellHighlighters() {
        this.cellHighlighters.clear();
    }

    public void setColumnOrder(List<String> columnOrder) {
        this.columnOrder = columnOrder;
    }

    public void setToolTip(Object closure) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<String> rowToolTips = new ArrayList<String>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowToolTips.add((String)this.runClosure(closure, params));
                }
                this.tooltips.add(rowToolTips);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set tooltip using closure.", e);
        }
    }

    public List<List<String>> getTooltips() {
        return this.tooltips;
    }

    public Integer getDataFontSize() {
        return this.dataFontSize;
    }

    public void setDataFontSize(Integer dataFontSize) {
        this.dataFontSize = dataFontSize;
    }

    public Integer getHeaderFontSize() {
        return this.headerFontSize;
    }

    public void setHeaderFontSize(Integer headerFontSize) {
        this.headerFontSize = headerFontSize;
    }

    public List<List<Color>> getFontColor() {
        return this.fontColor;
    }

    public void setFontColorProvider(Object closure) {
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                List<?> row = this.values.get(rowInd);
                ArrayList<Color> rowFontColors = new ArrayList<Color>();
                for (int colInd = 0; colInd < row.size(); ++colInd) {
                    Object[] params = new Object[]{rowInd, colInd, this};
                    rowFontColors.add((Color)this.runClosure(closure, params));
                }
                this.fontColor.add(rowFontColors);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set font color using closure.", e);
        }
    }

    public void setRowFilter(Object closure) {
        ArrayList filteredValues = new ArrayList();
        try {
            for (int rowInd = 0; rowInd < this.values.size(); ++rowInd) {
                Object[] params = new Object[]{rowInd, this.values};
                if (!((Boolean)this.runClosure(closure, params)).booleanValue()) continue;
                filteredValues.add(this.values.get(rowInd));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can not set row filter using closure.", e);
        }
        this.filteredValues = filteredValues;
    }

    public void setHeadersVertical(boolean headersVertical) {
        this.headersVertical = headersVertical;
    }

    public Boolean getHeadersVertical() {
        return this.headersVertical;
    }

    public void setHasIndex(String hasIndex) {
        this.hasIndex = hasIndex;
    }

    public String getHasIndex() {
        return this.hasIndex;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public List<List<?>> getFilteredValues() {
        return this.filteredValues;
    }

    public static List<Map<String, Object>> getValuesAsRows(List<List<?>> values, List<String> columns) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        if (columns != null && values != null) {
            for (List<?> value : values) {
                HashMap m = new HashMap();
                for (int c = 0; c < columns.size(); ++c) {
                    if (value.size() <= c) continue;
                    m.put(columns.get(c), value.get(c));
                }
                rows.add(m);
            }
        } else {
            throw new IllegalArgumentException("Method 'getValuesAsRows' doesn't supported for this table");
        }
        return rows;
    }

    public static List<List<?>> getValuesAsMatrix(List<List<?>> values) {
        return values;
    }

    public static Map<String, Object> getValuesAsDictionary(List<List<?>> values) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (List<?> l : values) {
            if (l.size() != 2) {
                throw new IllegalArgumentException("Method 'getValuesAsDictionary' doesn't supported for this table");
            }
            m.put(l.get(0).toString(), l.get(1));
        }
        return m;
    }

    public List<Map<String, Object>> getValuesAsRows() {
        return TableDisplay.getValuesAsRows(this.values, this.columns);
    }

    public List<List<?>> getValuesAsMatrix() {
        return TableDisplay.getValuesAsMatrix(this.values);
    }

    public Map<String, Object> getValuesAsDictionary() {
        return TableDisplay.getValuesAsDictionary(this.values);
    }

    private Object getValueForSerializer(Object value, BeakerObjectConverter serializer) {
        if (value != null) {
            String clazz = serializer.convertType(value.getClass().getName());
            if ("int64".equals(clazz) || "bigint".equals(clazz)) {
                return value.toString();
            }
            return value;
        }
        return null;
    }

    public List<List<?>> getValues() {
        return this.values;
    }

    public List<String> getColumnNames() {
        return this.columns;
    }

    public List<String> getTypes() {
        return this.classes;
    }

    public String getSubtype() {
        return this.subtype;
    }
}

