/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.object;

import com.twosigma.beaker.jvm.object.OutputContainerLayoutManager;
import com.twosigma.beaker.jvm.object.SimpleLayoutManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputContainer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)OutputContainer.class.getName());
    private final List<Object> items;
    private final List<String> labels = new ArrayList<String>();
    private OutputContainerLayoutManager layoutManager = new SimpleLayoutManager();

    public OutputContainer() {
        this(new ArrayList<Object>());
    }

    public OutputContainer(List<Object> items) {
        this(items, null);
    }

    public OutputContainer(List<Object> items, List<String> labels) {
        if (items == null || labels != null && labels.size() != items.size()) {
            throw new RuntimeException();
        }
        this.items = items;
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        } else {
            for (int i = 0; i < items.size(); ++i) {
                this.labels.add("");
            }
        }
    }

    public void addItem(Object item) {
        this.addItem(item, this.items.size(), null);
    }

    public void addItem(Object item, int index) {
        this.addItem(item, index, null);
    }

    public void addItem(Object item, int index, String label) {
        this.items.add(index, item);
        this.labels.add(index, label);
    }

    public void addItem(Object item, String label) {
        this.addItem(item, this.items.size(), label);
    }

    public void removeItem(int index) {
        this.items.remove(index);
        this.labels.remove(index);
    }

    public OutputContainer leftShift(Object item) {
        this.addItem(item);
        return this;
    }

    public void removeItem(Object itemToRemove) {
        this.removeItem(this.items.indexOf(itemToRemove));
    }

    public List<Object> getItems() {
        return this.items;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void visit(CellVisitor visitor) {
        for (Object item : this.items) {
            visitor.visit(item);
        }
    }

    public OutputContainerLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(OutputContainerLayoutManager layoutManager) {
        if (layoutManager != null) {
            this.layoutManager = layoutManager;
        }
    }

    public static interface CellVisitor {
        public void visit(Object var1);
    }
}

