/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.commands;

import com.twosigma.beaker.jupyter.commands.MagicCommandFunctionality;
import com.twosigma.beaker.jupyter.msg.MessageCreator;
import com.twosigma.beaker.mimetype.MIMEContainer;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.message.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MagicCommand {
    public Map<String, MagicCommandFunctionality> commands = new HashMap<String, MagicCommandFunctionality>();
    private MessageCreator messageCreator;

    public MagicCommand(KernelFunctionality kernel) {
        this.messageCreator = new MessageCreator(kernel);
        this.buildCommands();
    }

    public void processUnknownCommand(String command, Message message, int executionCount) {
        String result = "Cell magic " + command + " not found";
        this.messageCreator.createMagicMessage(this.messageCreator.buildOutputMessage(message, result, true), executionCount, message);
    }

    private void buildCommands() {
        this.commands.put("%%javascript", (code, message, executionCount) -> {
            code = "<html><script>" + code.replace("%%javascript", "") + "</script></html>";
            this.publishResults(MIMEContainer.HTML(code), message, executionCount);
        });
        this.commands.put("%%html", (code, message, executionCount) -> {
            code = "<html>" + code.replace("%%html", "") + "</html>";
            this.publishResults(MIMEContainer.HTML(code), message, executionCount);
        });
        this.commands.put("%%bash", (code, message, executionCount) -> {
            String result = this.executeBashCode(code.replace("%%bash", ""));
            this.messageCreator.createMagicMessage(this.messageCreator.buildOutputMessage(message, result, false), executionCount, message);
        });
        this.commands.put("%lsmagic", (code, message, executionCount) -> {
            String result = "Available magic commands:\n";
            result = result + this.commands.entrySet().stream().filter(map -> map.getKey() != "%lsmagic").map(Map.Entry::getKey).collect(Collectors.joining(" "));
            this.messageCreator.createMagicMessage(this.messageCreator.buildOutputMessage(message, result, false), executionCount, message);
        });
    }

    private void publishResults(MIMEContainer result, Message message, int executionCount) {
        this.messageCreator.createMagicMessage(this.messageCreator.buildMessage(message, result.getMime().getMime(), result.getCode(), executionCount), executionCount, message);
    }

    private String executeBashCode(String code) {
        String[] cmd = new String[]{"/bin/bash", "-c", code};
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process process = pb.start();
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            process.destroy();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return output.toString();
    }
}

