/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.xychart;

import com.twosigma.beaker.chart.ObservableChart;
import com.twosigma.beaker.chart.xychart.XYChart;
import com.twosigma.beaker.jupyter.comm.Comm;
import com.twosigma.beaker.widgets.chart.InternalPlot;
import com.twosigma.beaker.widgets.internal.InternalCommWidget;
import com.twosigma.beaker.widgets.internal.InternalWidgetContent;
import com.twosigma.beaker.widgets.internal.InternalWidgetUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CombinedPlot
extends ObservableChart
implements InternalCommWidget,
InternalPlot {
    private int initWidth = 640;
    private int initHeight = 480;
    private String title;
    private String xLabel;
    private List<XYChart> subplots = new ArrayList<XYChart>();
    private List<Integer> weights = new ArrayList<Integer>();
    private boolean xTickLabelsVisible = true;
    private boolean yTickLabelsVisible = true;
    private Comm comm = InternalWidgetUtils.createComm(this, new InternalWidgetContent(){

        @Override
        public void addContent(HashMap<String, Serializable> content) {
            content.put("_model_name", (Serializable)((Object)CombinedPlot.this.getModelNameValue()));
            content.put("_view_name", (Serializable)((Object)CombinedPlot.this.getViewNameValue()));
        }
    });

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    @Override
    public Comm getComm() {
        return this.comm;
    }

    @Override
    public void close() {
        if (this.comm != null) {
            this.comm.close();
        }
    }

    public CombinedPlot setInitWidth(int w) {
        this.initWidth = w;
        return this;
    }

    public Integer getInitWidth() {
        return this.initWidth;
    }

    public CombinedPlot setInitHeight(int h) {
        this.initHeight = h;
        return this;
    }

    public Integer getInitHeight() {
        return this.initHeight;
    }

    public CombinedPlot setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CombinedPlot setXLabel(String xLabel) {
        this.xLabel = xLabel;
        return this;
    }

    public CombinedPlot setxLabel(String xLabel) {
        this.xLabel = xLabel;
        return this;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public CombinedPlot add(XYChart plot, int weight) {
        this.subplots.add(plot);
        this.weights.add(weight);
        return this;
    }

    public CombinedPlot add(XYChart plot) {
        this.subplots.add(plot);
        this.weights.add(1);
        return this;
    }

    public CombinedPlot leftShift(Object obj) {
        if (obj instanceof XYChart) {
            this.add((XYChart)obj, 1);
        } else if (obj instanceof List && ((List)obj).size() == 2) {
            List list = (List)obj;
            XYChart plot = (XYChart)list.get(0);
            int weight = ((Number)list.get(1)).intValue();
            this.add(plot, weight);
        } else {
            throw new IllegalArgumentException("leftShift takes XYChart or List that hold a XYChart and weight");
        }
        return this;
    }

    public List<XYChart> getSubplots() {
        return this.subplots;
    }

    public List<Integer> getWeights() {
        return this.weights;
    }

    public boolean isyTickLabelsVisible() {
        return this.yTickLabelsVisible;
    }

    public void setyTickLabelsVisible(boolean yTickLabelsVisible) {
        this.yTickLabelsVisible = yTickLabelsVisible;
    }

    public boolean isxTickLabelsVisible() {
        return this.xTickLabelsVisible;
    }

    public void setxTickLabelsVisible(boolean xTickLabelsVisible) {
        this.xTickLabelsVisible = xTickLabelsVisible;
    }
}

