/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.chart.xychart.plotitem.Rasters;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public class RastersSerializer
extends JsonSerializer<Rasters> {
    public void serialize(Rasters raster, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeObjectField("type", (Object)raster.getClass().getSimpleName());
        jgen.writeObjectField("x", raster.getX());
        jgen.writeObjectField("y", raster.getY());
        jgen.writeObjectField("opacity", raster.getOpacity());
        jgen.writeObjectField("visible", (Object)raster.getVisible());
        jgen.writeObjectField("yAxis", (Object)raster.getYAxis());
        jgen.writeObjectField("position", (Object)raster.getPosition());
        if (raster.getWidth() != null) {
            jgen.writeObjectField("width", raster.getWidth());
        }
        if (raster.getHeight() != null) {
            jgen.writeObjectField("height", raster.getHeight());
        }
        if (raster.getDataString() != null) {
            jgen.writeObjectField("value", (Object)this.Bytes2Base64(raster.getDataString(), null));
        } else if (!raster.getFilePath().isEmpty()) {
            String path = raster.getFilePath();
            byte[] picture = Files.readAllBytes(new File(path).toPath());
            String extension = "";
            int i = path.lastIndexOf(46);
            if (i > 0) {
                extension = path.substring(i + 1);
            }
            jgen.writeObjectField("value", (Object)this.Bytes2Base64(picture, extension));
        } else if (!raster.getFileUrl().isEmpty()) {
            jgen.writeObjectField("value", (Object)raster.getFileUrl());
        }
        jgen.writeEndObject();
    }

    private String processLargeNumber(Number largeNumber) {
        return largeNumber != null ? largeNumber.toString() : "";
    }

    private String Bytes2Base64(byte[] bytes, String format) {
        StringBuilder sb = new StringBuilder();
        if (format != null) {
            sb.append("data:image/" + format + ";base64,");
        } else {
            sb.append("data:image/png;base64,");
        }
        sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])bytes, (boolean)false)));
        return sb.toString();
    }
}

