/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageIconSerializer
extends JsonSerializer<ImageIcon> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(ImageIcon vi, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        ImageIcon imageIcon = vi;
        synchronized (imageIcon) {
            BufferedImage v = new BufferedImage(vi.getIconWidth(), vi.getIconHeight(), 1);
            Graphics2D g = v.createGraphics();
            vi.paintIcon(null, g, 0, 0);
            g.dispose();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)v, "png", baos);
            byte[] data = baos.toByteArray();
            jgen.writeStartObject();
            jgen.writeStringField("type", "ImageIcon");
            jgen.writeObjectField("imageData", (Object)data);
            jgen.writeNumberField("width", v.getWidth());
            jgen.writeNumberField("height", v.getHeight());
            jgen.writeEndObject();
        }
    }
}

