/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.object;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@Singleton
public class SparkProgressService {
    private static final Logger logger = Logger.getLogger(SparkProgressService.class.getName());
    private volatile SparkProgress progress = new SparkProgress();
    private int activeJobId;
    private String activeAppName;
    private Map<Integer, List<Long>> activeTasks = new HashMap<Integer, List<Long>>();
    private Map<Integer, List<Long>> failedTasks = new HashMap<Integer, List<Long>>();
    private Map<Integer, List<Long>> succeededTasks = new HashMap<Integer, List<Long>>();
    private Map<Integer, StageProgress> stages = new HashMap<Integer, StageProgress>();
    private List<Integer> jobs = new ArrayList<Integer>();
    private Map<Integer, List<Integer>> stagesPerJob = new HashMap<Integer, List<Integer>>();
    private List<String> executorIds = new ArrayList<String>();

    public SparkProgress getProgress() {
        return this.progress;
    }

    public void clear() {
        this.progress.clear();
        this.jobs.clear();
        this.stagesPerJob.clear();
        this.activeTasks.clear();
        this.failedTasks.clear();
        this.succeededTasks.clear();
        this.stages.clear();
    }

    public void jobStart(int jobId, List<String> executorIds) {
        this.activeJobId = jobId;
        if (!this.jobs.contains(jobId)) {
            this.jobs.add(jobId);
            this.stagesPerJob.put(jobId, new ArrayList());
        }
        if (!executorIds.isEmpty()) {
            this.executorIds.clear();
            this.executorIds.addAll(executorIds);
        }
    }

    public void jobEnd(int jobId, List<String> executorIds) {
        if (jobId != this.activeJobId) {
            logger.warning(String.format("Spark job %d was not registered as active.", jobId));
        }
        if (!executorIds.isEmpty()) {
            this.executorIds.clear();
            this.executorIds.addAll(executorIds);
        }
    }

    public void stageStart(int stageId, int numTasks) {
        if (this.stages.containsKey(stageId)) {
            logger.warning(String.format("Spark stage %d already exists and will be started.", stageId));
        }
        StageProgress sp = new StageProgress();
        sp.setStageId(stageId);
        sp.setRunning(true);
        sp.setTotalTasks(numTasks);
        this.stages.put(stageId, sp);
        List sts = this.stagesPerJob.getOrDefault(this.activeJobId, new ArrayList());
        sts.add(stageId);
        this.stagesPerJob.put(this.activeJobId, sts);
        this.activeTasks.put(stageId, new ArrayList());
        this.failedTasks.put(stageId, new ArrayList());
        this.succeededTasks.put(stageId, new ArrayList());
    }

    public void stageEnd(int stageId, String failureReason) {
        if (!this.stages.containsKey(stageId)) {
            logger.warning(String.format("Spark stage %d could not be found for stage progress reporting.", stageId));
        }
        StageProgress sp = this.stages.getOrDefault(stageId, new StageProgress());
        sp.setStageId(stageId);
        sp.setRunning(false);
        sp.setFailureReason(failureReason);
        this.stages.put(stageId, sp);
    }

    private void removeTask(int stageId, long taskId) {
        List st;
        List ft;
        List at = this.activeTasks.getOrDefault(stageId, new ArrayList());
        if (at.contains(taskId)) {
            at.remove(taskId);
            this.activeTasks.put(stageId, at);
        }
        if ((ft = (List)this.failedTasks.getOrDefault(stageId, new ArrayList())).contains(taskId)) {
            ft.remove(taskId);
            this.failedTasks.put(stageId, ft);
        }
        if ((st = (List)this.succeededTasks.getOrDefault(stageId, new ArrayList())).contains(taskId)) {
            st.remove(taskId);
            this.succeededTasks.put(stageId, st);
        }
    }

    public void taskStart(int stageId, long taskId) {
        if (!this.stages.containsKey(stageId)) {
            logger.warning(String.format("Spark stage %d could not be found for task progress reporting.", stageId));
            return;
        }
        this.removeTask(stageId, taskId);
        List at = this.activeTasks.getOrDefault(stageId, new ArrayList());
        at.add(taskId);
        this.activeTasks.put(stageId, at);
    }

    public void taskEnd(int stageId, long taskId, boolean failed) {
        if (!this.stages.containsKey(stageId)) {
            logger.warning(String.format("Spark stage %d could not be found for task progress reporting.", stageId));
            return;
        }
        this.removeTask(stageId, taskId);
        if (failed) {
            List ft = this.failedTasks.getOrDefault(stageId, new ArrayList());
            ft.add(taskId);
            this.failedTasks.put(stageId, ft);
        } else {
            List st = this.succeededTasks.getOrDefault(stageId, new ArrayList());
            st.add(taskId);
            this.succeededTasks.put(stageId, st);
        }
    }

    @JsonAutoDetect
    public static class SparkProgress {
        private List<JobProgress> jobs;
        private List<String> executorIds;

        public List<JobProgress> getJobs() {
            return this.jobs;
        }

        public void setJobs(List<JobProgress> jobs) {
            this.jobs = jobs;
        }

        public List<String> getExecutorIds() {
            return this.executorIds;
        }

        public void setExecutorIds(List<String> executorIds) {
            this.executorIds.clear();
            this.executorIds.addAll(executorIds);
        }

        public void clear() {
            this.jobs.clear();
            this.executorIds.clear();
            this.executorIds.add("Cleared progress");
        }

        public SparkProgress() {
            this.jobs = new ArrayList<JobProgress>();
            this.executorIds = new ArrayList<String>();
        }

        public SparkProgress(List<JobProgress> jobs, List<String> executorIds) {
            this.jobs = jobs;
            this.executorIds = executorIds;
        }
    }

    @JsonAutoDetect
    public static class StageProgress {
        private int stageId;
        private String failureReason;
        private int totalTasks;
        private int succeededTasks;
        private int failedTasks;
        private int activeTasks;
        private boolean running;

        public boolean hasFailed() {
            return this.failureReason != null && !this.failureReason.isEmpty();
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        public int getStageId() {
            return this.stageId;
        }

        public int getTotalTasks() {
            return this.totalTasks;
        }

        public int getSucceededTasks() {
            return this.succeededTasks;
        }

        public int getFailedTasks() {
            return this.failedTasks;
        }

        public int getActiveTasks() {
            return this.activeTasks;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public void setStageId(int stageId) {
            this.stageId = stageId;
        }

        public void setTotalTasks(int totalTasks) {
            this.totalTasks = totalTasks;
        }

        public void setSucceededTasks(int succeededTasks) {
            this.succeededTasks = succeededTasks;
        }

        public void setFailedTasks(int failedTasks) {
            this.failedTasks = failedTasks;
        }

        public void setActiveTasks(int activeTasks) {
            this.activeTasks = activeTasks;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public StageProgress() {
            this.failureReason = null;
        }

        public StageProgress(String failureReason, int stageId, int totalTasks, int succeededTasks, int failedTasks, int activeTasks, boolean running) {
            this.failureReason = failureReason;
            this.stageId = stageId;
            this.totalTasks = totalTasks;
            this.succeededTasks = succeededTasks;
            this.failedTasks = failedTasks;
            this.activeTasks = activeTasks;
            this.running = running;
        }
    }

    @JsonAutoDetect
    public static class JobProgress {
        private int id;
        private boolean running;
        private ArrayList<StageProgress> stages;
        private ArrayList<String> executorIds;

        public boolean isRunning() {
            return this.running;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }

        public ArrayList<StageProgress> getStages() {
            return this.stages;
        }

        public void setStages(ArrayList<StageProgress> stages) {
            this.stages = stages;
        }

        public ArrayList<String> getExecutorIds() {
            return this.executorIds;
        }

        public void setExecutorIds(ArrayList<String> executorIds) {
            this.executorIds = executorIds;
        }

        public JobProgress() {
            this.stages = new ArrayList();
            this.executorIds = new ArrayList();
        }

        public JobProgress(int id, boolean running) {
            this.id = id;
            this.running = running;
            this.stages = new ArrayList();
            this.executorIds = new ArrayList();
        }
    }

    @JsonAutoDetect
    public static class ApplicationProgress {
        private String appName;
        private boolean running;

        public boolean isRunning() {
            return this.running;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setRunnning(boolean running) {
            this.running = running;
        }

        public ApplicationProgress() {
        }

        public ApplicationProgress(String appName, boolean running) {
            this.appName = appName;
            this.running = running;
        }
    }
}

