/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.object;

import com.twosigma.beaker.jvm.object.ConsoleOutput;
import com.twosigma.beaker.jvm.object.ProgressReporting;
import com.twosigma.beaker.jvm.threads.BeakerOutputHandler;
import com.twosigma.beaker.jvm.threads.BeakerStdOutErrHandler;
import com.twosigma.jupyter.message.Message;
import java.util.Observable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEvaluationObject
extends Observable {
    private static final Logger logger = LoggerFactory.getLogger((String)SimpleEvaluationObject.class.getName());
    private Message jupyterMessage;
    private int executionCount;
    private EvaluationStatus status;
    private final String expression;
    private Object payload;
    private BeakerOutputHandler stdout;
    private BeakerOutputHandler stderr;
    private Queue<ConsoleOutput> consoleOutput = new ConcurrentLinkedQueue<ConsoleOutput>();
    private ProgressReporting progressReporting;

    public SimpleEvaluationObject(String e) {
        this.expression = e;
        this.status = EvaluationStatus.QUEUED;
    }

    public synchronized void started() {
        this.setOutputHandler();
        this.status = EvaluationStatus.RUNNING;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void finished(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.FINISHED;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void error(Object r) {
        this.clrOutputHandler();
        this.status = EvaluationStatus.ERROR;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void update(Object r) {
        this.status = EvaluationStatus.RUNNING;
        this.payload = r;
        this.setChanged();
        this.notifyObservers();
    }

    public String getExpression() {
        return this.expression;
    }

    public synchronized EvaluationStatus getStatus() {
        return this.status;
    }

    public synchronized Object getPayload() {
        return this.payload;
    }

    public void structuredUpdate(String message, int progress) {
        if (this.progressReporting == null) {
            this.progressReporting = new ProgressReporting();
        }
        this.progressReporting.structuredUpdate(message, progress);
    }

    public synchronized BeakerOutputHandler getStdOutputHandler() {
        if (this.stdout == null) {
            this.stdout = new SimpleOutputHandler(false);
        }
        return this.stdout;
    }

    public synchronized BeakerOutputHandler getStdErrorHandler() {
        if (this.stderr == null) {
            this.stderr = new SimpleOutputHandler(true);
        }
        return this.stderr;
    }

    public void setOutputHandler() {
        BeakerStdOutErrHandler.setOutputHandler(this.getStdOutputHandler(), this.getStdErrorHandler());
    }

    public void clrOutputHandler() {
        this.closeProgressUpdater();
        BeakerStdOutErrHandler.clrOutputHandler();
    }

    private void closeProgressUpdater() {
        if (this.progressReporting != null) {
            this.progressReporting.close();
            this.progressReporting = null;
        }
    }

    public Message getJupyterMessage() {
        return this.jupyterMessage;
    }

    public void setJupyterMessage(Message jupyterMessage) {
        this.jupyterMessage = jupyterMessage;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public Queue<ConsoleOutput> getConsoleOutput() {
        return this.consoleOutput;
    }

    public String toString() {
        return this.status.toString() + " Console messages size = " + this.consoleOutput.size();
    }

    public class SimpleOutputHandler
    implements BeakerOutputHandler {
        private boolean error;

        public SimpleOutputHandler(boolean error) {
            this.error = error;
        }

        @Override
        public void write(int b) {
            byte[] ba = new byte[]{(byte)b};
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(ba)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }

        @Override
        public void write(byte[] b) {
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(b)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }

        @Override
        public void write(byte[] b, int off, int len) {
            SimpleEvaluationObject.this.consoleOutput.add(new ConsoleOutput(this.error, new String(b, off, len)));
            SimpleEvaluationObject.this.setChanged();
            SimpleEvaluationObject.this.notifyObservers();
        }
    }

    public static enum EvaluationStatus {
        QUEUED,
        RUNNING,
        FINISHED,
        ERROR;

    }
}

