/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beaker.chart.categoryplot.CategoryPlot;
import com.twosigma.beaker.chart.categoryplot.plotitem.CategoryGraphics;
import com.twosigma.beaker.chart.serializer.AbstractChartSerializer;
import java.io.IOException;
import java.util.List;

public class CategoryPlotSerializer
extends AbstractChartSerializer<CategoryPlot> {
    public static final String GRAPHICS_LIST = "graphics_list";

    public void serialize(CategoryPlot categoryPlot, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        List<CategoryGraphics> categoryGraphicsList;
        jgen.writeStartObject();
        this.serialize(categoryPlot, jgen);
        List<String> categoryNames = categoryPlot.getCategoryNames();
        if (categoryNames != null) {
            jgen.writeObjectField("categoryNames", categoryNames);
        }
        if ((categoryGraphicsList = categoryPlot.getGraphics()) != null) {
            for (CategoryGraphics categoryGraphics : categoryGraphicsList) {
                categoryGraphics.createItemLabels(categoryPlot);
            }
            jgen.writeObjectField(GRAPHICS_LIST, categoryGraphicsList);
        }
        jgen.writeObjectField("orientation", (Object)categoryPlot.getOrientation());
        jgen.writeObjectField("category_margin", (Object)categoryPlot.getCategoryMargin());
        jgen.writeObjectField("categoryNamesLabelAngle", (Object)categoryPlot.getCategoryNamesLabelAngle());
        jgen.writeEndObject();
    }
}

