/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.dsp.WarpFunction2;
import edu.mines.jtk.util.ArrayMath;

public abstract class WarpFunction1 {
    private int _n;

    public static WarpFunction1 constant(double u, int n) {
        return new ConstantWarp1(u, n);
    }

    public static WarpFunction1 gaussian(double u, int n) {
        return new GaussianWarp1(u, n);
    }

    public static WarpFunction1 sinusoid(double u, int n) {
        return new SinusoidWarp1(u, n);
    }

    public static WarpFunction1 constantPlusSinusoid(double c, double u, int n) {
        return new SinusoidWarp1(c, u, n);
    }

    public abstract double u(double var1);

    public double ux(double x) {
        return this.u(x);
    }

    public double um(double m) {
        double up;
        double um = 0.0;
        do {
            up = um;
        } while (ArrayMath.abs((um = this.u(m - 0.5 * um)) - up) > 1.0E-4);
        return um;
    }

    public double uy(double y) {
        double up;
        double uy = 0.0;
        do {
            up = uy;
        } while (ArrayMath.abs((uy = this.u(y - uy)) - up) > 1.0E-4);
        return uy;
    }

    public float[] ux() {
        float[] u = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            double x = i;
            u[i] = (float)this.ux(x);
        }
        return u;
    }

    public float[] um() {
        float[] u = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            double m = i;
            u[i] = (float)this.um(m);
        }
        return u;
    }

    public float[] uy() {
        float[] u = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            double y = i;
            u[i] = (float)this.uy(y);
        }
        return u;
    }

    public float[] warp(float[] f) {
        SincInterpolator si = new SincInterpolator();
        float[] g = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            double y = i;
            double x = y - this.uy(y);
            g[i] = si.interpolate(this._n, 1.0, 0.0, f, x);
        }
        return g;
    }

    public float[] unwarp(float[] g) {
        SincInterpolator si = new SincInterpolator();
        float[] f = new float[this._n];
        for (int i = 0; i < this._n; ++i) {
            double x = i;
            double y = x + this.ux(x);
            f[i] = si.interpolate(this._n, 1.0, 0.0, g, y);
        }
        return f;
    }

    protected WarpFunction1(int n) {
        this._n = n;
    }

    private static class SinusoidWarp1
    extends WarpFunction1 {
        private double _a;
        private double _b;
        private double _c;
        private double _umax;
        private double _emax;

        public SinusoidWarp1(double umax, int n) {
            this(0.0, umax, n);
        }

        public SinusoidWarp1(double uadd, double umax, int n) {
            super(n);
            double l = n - 1;
            this._a = umax;
            this._b = Math.PI * 2 / l;
            this._c = uadd;
            this._umax = umax;
            this._emax = this._a * this._b;
        }

        @Override
        public double u(double x) {
            return this._c + this._a * ArrayMath.sin(this._b * x);
        }

        public double umax() {
            return this._umax;
        }

        public double e(double x) {
            return this._a * this._b * ArrayMath.cos(this._b * x);
        }

        public double emax() {
            return this._emax;
        }
    }

    private static class SinusoidWarp2
    extends WarpFunction2 {
        private double _a1;
        private double _a2;
        private double _b1;
        private double _b2;
        private double _c1;
        private double _c2;

        public SinusoidWarp2(double u1max, double u2max, int n1, int n2) {
            this(0.0, 0.0, u1max, u2max, n1, n2);
        }

        public SinusoidWarp2(double u1add, double u2add, double u1max, double u2max, int n1, int n2) {
            super(n1, n2);
            double l1 = n1 - 1;
            double l2 = n2 - 1;
            this._c1 = u1add;
            this._c2 = u2add;
            this._a1 = u1max;
            this._a2 = u2max;
            this._b1 = Math.PI * 2 / l1;
            this._b2 = Math.PI * 2 / l2;
        }

        @Override
        public double u1(double x1, double x2) {
            return this._c1 + this._a1 * ArrayMath.sin(this._b1 * x1) * ArrayMath.sin(0.5 * this._b2 * x2);
        }

        @Override
        public double u2(double x1, double x2) {
            return this._c2 + this._a2 * ArrayMath.sin(this._b2 * x2) * ArrayMath.sin(0.5 * this._b1 * x1);
        }
    }

    private static class GaussianWarp1
    extends WarpFunction1 {
        private double _a;
        private double _b;
        private double _c;
        private double _umax;
        private double _emax;

        public GaussianWarp1(double umax, int n) {
            super(n);
            this._a = (double)(n - 1) / 2.0;
            this._b = this._a / 3.0;
            this._c = umax * ArrayMath.exp(0.5) / this._b;
            this._umax = umax;
            this._emax = this._c;
        }

        @Override
        public double u(double x) {
            double xa = x - this._a;
            return -this._c * xa * ArrayMath.exp(-0.5 * (xa * xa) / (this._b * this._b));
        }

        public double umax() {
            return this._umax;
        }

        public double e(double x) {
            double xa = x - this._a;
            return -this._c * (1.0 - xa * xa / (this._b * this._b)) * ArrayMath.exp(-0.5 * (xa * xa) / (this._b * this._b));
        }

        public double emax() {
            return this._emax;
        }
    }

    private static class ConstantWarp1
    extends WarpFunction1 {
        private double _u;

        public ConstantWarp1(double u, int n) {
            super(n);
            this._u = u;
        }

        @Override
        public double u(double x) {
            return this._u;
        }

        public double umax() {
            return this._u;
        }

        public double e(double x) {
            return 0.0;
        }

        public double emax() {
            return 0.0;
        }
    }
}

