/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

public class LinearInterpolator {
    private Extrapolation _extrap = Extrapolation.ZERO;
    private int _nxu;
    private double _dxu;
    private double _fxu;
    private double _xf;
    private double _xs;
    private double _xb;
    private int _nxum;
    private float[] _yu;
    private int _nx1u;
    private int _nx2u;
    private int _nx3u;
    private double _x1f;
    private double _x2f;
    private double _x3f;
    private double _x1s;
    private double _x2s;
    private double _x3s;
    private double _x1b;
    private double _x2b;
    private double _x3b;
    private int _nx1um;
    private int _nx2um;
    private int _nx3um;
    private float[][] _yyu;
    private float[][][] _yyyu;

    public Extrapolation getExtrapolation() {
        return this._extrap;
    }

    public void setExtrapolation(Extrapolation extrap) {
        this._extrap = extrap;
    }

    public void setUniformSampling(int nxu, double dxu, double fxu) {
        this._nxu = nxu;
        this._dxu = dxu;
        this._fxu = fxu;
        this._xf = fxu;
        this._xs = 1.0 / dxu;
        this._xb = 2.0 - this._xf * this._xs;
        this._nxum = nxu - 1;
    }

    public void setUniformSamples(float[] yu) {
        this._yu = yu;
    }

    public void setUniform(int nxu, double dxu, double fxu, float[] yu) {
        this.setUniformSampling(nxu, dxu, fxu);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x) {
        float yr;
        double xn = this._xb + x * this._xs;
        int ixn = (int)xn;
        float a1 = (float)(xn - (double)ixn);
        float a0 = 1.0f - a1;
        int kyu = ixn - 2;
        if (0 <= kyu && kyu < this._nxum) {
            yr = a0 * this._yu[kyu] + a1 * this._yu[kyu + 1];
        } else if (this._extrap == Extrapolation.ZERO) {
            yr = 0.0f;
            if (0 <= kyu && kyu < this._nxu) {
                yr += a0 * this._yu[kyu];
            }
            if (0 <= ++kyu && kyu < this._nxu) {
                yr += a1 * this._yu[kyu];
            }
        } else {
            int jyu = kyu < 0 ? 0 : (this._nxu <= kyu ? this._nxum : kyu);
            yr = a0 * this._yu[jyu];
            jyu = ++kyu < 0 ? 0 : (this._nxu <= kyu ? this._nxum : kyu);
            yr += a1 * this._yu[jyu];
        }
        return yr;
    }

    public void interpolate(int nx, float[] x, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            y[ix] = this.interpolate(x[ix]);
        }
    }

    public void interpolate(int nx, double dx, double fx, float[] y) {
        for (int ix = 0; ix < nx; ++ix) {
            y[ix] = this.interpolate(fx + (double)ix * dx);
        }
    }

    public void setUniformSampling(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u) {
        this._nx1u = nx1u;
        this._x1f = fx1u;
        this._x1s = 1.0 / dx1u;
        this._x1b = 2.0 - this._x1f * this._x1s;
        this._nx1um = nx1u - 1;
        this._nx2u = nx2u;
        this._x2f = fx2u;
        this._x2s = 1.0 / dx2u;
        this._x2b = 2.0 - this._x2f * this._x2s;
        this._nx2um = nx2u - 1;
    }

    public void setUniformSamples(float[][] yu) {
        this._yyu = yu;
    }

    public void setUniform(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, float[][] yu) {
        this.setUniformSampling(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x1, double x2) {
        float yr;
        double x1n = this._x1b + x1 * this._x1s;
        double x2n = this._x2b + x2 * this._x2s;
        int ix1n = (int)x1n;
        int ix2n = (int)x2n;
        int ky1u = ix1n - 2;
        int ky2u = ix2n - 2;
        float a11 = (float)(x1n - (double)ix1n);
        float a12 = (float)(x2n - (double)ix2n);
        float a01 = 1.0f - a11;
        float a02 = 1.0f - a12;
        if (ky1u >= 0 && ky1u < this._nx1um && ky2u >= 0 && ky2u < this._nx2um) {
            float[] yyuk0 = this._yyu[ky2u];
            float[] yyuk1 = this._yyu[ky2u + 1];
            yr = a01 * a02 * yyuk0[ky1u] + a11 * a02 * yyuk0[ky1u + 1] + a01 * a12 * yyuk1[ky1u] + a11 * a12 * yyuk1[ky1u + 1];
        } else if (this._extrap == Extrapolation.ZERO) {
            int my1u;
            yr = 0.0f;
            if (0 <= ky2u && ky2u < this._nx2u) {
                my1u = ky1u;
                if (0 <= my1u && my1u < this._nx1u) {
                    yr += a01 * a02 * this._yyu[ky2u][my1u];
                }
                if (0 <= ++my1u && my1u < this._nx1u) {
                    yr += a11 * a02 * this._yyu[ky2u][my1u];
                }
            }
            if (0 <= ++ky2u && ky2u < this._nx2u) {
                my1u = ky1u;
                if (0 <= my1u && my1u < this._nx1u) {
                    yr += a01 * a12 * this._yyu[ky2u][my1u];
                }
                if (0 <= ++my1u && my1u < this._nx1u) {
                    yr += a11 * a12 * this._yyu[ky2u][my1u];
                }
            }
        } else {
            int jy2u = ky2u < 0 ? 0 : (this._nx2u <= ky2u ? this._nx2um : ky2u);
            int my1u = ky1u;
            int jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr = a01 * a02 * this._yyu[jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a02 * this._yyu[jy2u][jy1u];
            jy2u = ++ky2u < 0 ? 0 : (this._nx2u <= ky2u ? this._nx2um : ky2u);
            my1u = ky1u;
            jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a01 * a12 * this._yyu[jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a12 * this._yyu[jy2u][jy1u];
        }
        return yr;
    }

    public void setUniformSampling(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, int nx3u, double dx3u, double fx3u) {
        this._nx1u = nx1u;
        this._x1f = fx1u;
        this._x1s = 1.0 / dx1u;
        this._x1b = 2.0 - this._x1f * this._x1s;
        this._nx1um = nx1u - 1;
        this._nx2u = nx2u;
        this._x2f = fx2u;
        this._x2s = 1.0 / dx2u;
        this._x2b = 2.0 - this._x2f * this._x2s;
        this._nx2um = nx2u - 1;
        this._nx3u = nx3u;
        this._x3f = fx3u;
        this._x3s = 1.0 / dx3u;
        this._x3b = 2.0 - this._x3f * this._x3s;
        this._nx3um = nx3u - 1;
    }

    public void setUniformSamples(float[][][] yu) {
        this._yyyu = yu;
    }

    public void setUniform(int nx1u, double dx1u, double fx1u, int nx2u, double dx2u, double fx2u, int nx3u, double dx3u, double fx3u, float[][][] yu) {
        this.setUniformSampling(nx1u, dx1u, fx1u, nx2u, dx2u, fx2u, nx3u, dx3u, fx3u);
        this.setUniformSamples(yu);
    }

    public float interpolate(double x1, double x2, double x3) {
        float yr;
        double x1n = this._x1b + x1 * this._x1s;
        double x2n = this._x2b + x2 * this._x2s;
        double x3n = this._x3b + x3 * this._x3s;
        int ix1n = (int)x1n;
        int ix2n = (int)x2n;
        int ix3n = (int)x3n;
        int ky1u = ix1n - 2;
        int ky2u = ix2n - 2;
        int ky3u = ix3n - 2;
        float a11 = (float)(x1n - (double)ix1n);
        float a12 = (float)(x2n - (double)ix2n);
        float a13 = (float)(x3n - (double)ix3n);
        float a01 = 1.0f - a11;
        float a02 = 1.0f - a12;
        float a03 = 1.0f - a13;
        if (ky1u >= 0 && ky1u < this._nx1um && ky2u >= 0 && ky2u < this._nx2um && ky3u >= 0 && ky3u < this._nx3um) {
            float[] yyyuk00 = this._yyyu[ky3u][ky2u];
            float[] yyyuk01 = this._yyyu[ky3u][ky2u + 1];
            float[] yyyuk10 = this._yyyu[ky3u + 1][ky2u];
            float[] yyyuk11 = this._yyyu[ky3u + 1][ky2u + 1];
            yr = a01 * a02 * a03 * yyyuk00[ky1u] + a11 * a02 * a03 * yyyuk00[ky1u + 1] + a01 * a12 * a03 * yyyuk01[ky1u] + a11 * a12 * a03 * yyyuk01[ky1u + 1] + a01 * a02 * a13 * yyyuk10[ky1u] + a11 * a02 * a13 * yyyuk10[ky1u + 1] + a01 * a12 * a13 * yyyuk11[ky1u] + a11 * a12 * a13 * yyyuk11[ky1u + 1];
        } else if (this._extrap == Extrapolation.ZERO) {
            int my1u;
            int my2u;
            yr = 0.0f;
            if (0 <= ky3u && ky3u < this._nx3u) {
                my2u = ky2u;
                if (0 <= my2u && my2u < this._nx2u) {
                    my1u = ky1u;
                    if (0 <= my1u && my1u < this._nx1u) {
                        yr += a01 * a02 * a03 * this._yyyu[ky3u][my2u][my1u];
                    }
                    if (0 <= ++my1u && my1u < this._nx1u) {
                        yr += a11 * a02 * a03 * this._yyyu[ky3u][my2u][my1u];
                    }
                }
                if (0 <= ++my2u && my2u < this._nx2u) {
                    my1u = ky1u;
                    if (0 <= my1u && my1u < this._nx1u) {
                        yr += a01 * a12 * a03 * this._yyyu[ky3u][my2u][my1u];
                    }
                    if (0 <= ++my1u && my1u < this._nx1u) {
                        yr += a11 * a12 * a03 * this._yyyu[ky3u][my2u][my1u];
                    }
                }
            }
            if (0 <= ++ky3u && ky3u < this._nx3u) {
                my2u = ky2u;
                if (0 <= my2u && my2u < this._nx2u) {
                    my1u = ky1u;
                    if (0 <= my1u && my1u < this._nx1u) {
                        yr += a01 * a02 * a13 * this._yyyu[ky3u][my2u][my1u];
                    }
                    if (0 <= ++my1u && my1u < this._nx1u) {
                        yr += a11 * a02 * a13 * this._yyyu[ky3u][my2u][my1u];
                    }
                }
                if (0 <= ++my2u && my2u < this._nx2u) {
                    my1u = ky1u;
                    if (0 <= my1u && my1u < this._nx1u) {
                        yr += a01 * a12 * a13 * this._yyyu[ky3u][my2u][my1u];
                    }
                    if (0 <= ++my1u && my1u < this._nx1u) {
                        yr += a11 * a12 * a13 * this._yyyu[ky3u][my2u][my1u];
                    }
                }
            }
        } else {
            int jy3u = ky3u < 0 ? 0 : (this._nx3u <= ky3u ? this._nx3um : ky3u);
            int my2u = ky2u;
            int jy2u = my2u < 0 ? 0 : (this._nx2u <= my2u ? this._nx2um : my2u);
            int my1u = ky1u;
            int jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr = a01 * a02 * a03 * this._yyyu[jy3u][jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a02 * a03 * this._yyyu[jy3u][jy2u][jy1u];
            jy2u = ++my2u < 0 ? 0 : (this._nx2u <= my2u ? this._nx2um : my2u);
            my1u = ky1u;
            jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a01 * a12 * a03 * this._yyyu[jy3u][jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a12 * a03 * this._yyyu[jy3u][jy2u][jy1u];
            jy3u = ++ky3u < 0 ? 0 : (this._nx3u <= ky3u ? this._nx3um : ky3u);
            my2u = ky2u;
            jy2u = my2u < 0 ? 0 : (this._nx2u <= my2u ? this._nx2um : my2u);
            my1u = ky1u;
            jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a01 * a02 * a13 * this._yyyu[jy3u][jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a02 * a13 * this._yyyu[jy3u][jy2u][jy1u];
            jy2u = ++my2u < 0 ? 0 : (this._nx2u <= my2u ? this._nx2um : my2u);
            my1u = ky1u;
            jy1u = my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a01 * a12 * a13 * this._yyyu[jy3u][jy2u][jy1u];
            jy1u = ++my1u < 0 ? 0 : (this._nx1u <= my1u ? this._nx1um : my1u);
            yr += a11 * a12 * a13 * this._yyyu[jy3u][jy2u][jy1u];
        }
        return yr;
    }

    public static enum Extrapolation {
        ZERO,
        CONSTANT;

    }
}

