'''
This script is used to kick off a salt proxy minion daemon
'''

from salt.scripts import salt_proxy_minion
from salt.utils import is_windows
from multiprocessing import freeze_support


if __name__ == '__main__':
    if is_windows():
        # Since this file does not have a '.py' extension, when running on
        # Windows, spawning any addional processes will fail due to Python
        # not being able to load this 'module' in the new process.
        # Work around this by creating a '.pyc' file which will enable the
        # spawned process to load this 'module' and proceed.
        import os.path
        import py_compile
        cfile = os.path.splitext(__file__)[0] + '.pyc'
        if not os.path.exists(cfile):
            py_compile.compile(__file__, cfile)
    # This handles the bootstrapping code that is included with frozen
    # scripts. It is a no-op on unfrozen code.
    freeze_support()
    salt_proxy_minion()
