
# Import python libs
import sys

# Import salt libs
import salt.scripts
from salt.utils import is_windows


def get_avail():
    '''
    Return the available salt commands
    '''
    ret = []
    for fun in dir(salt.scripts):
        if fun.startswith('salt'):
            ret.append(fun[5:])
    return ret


def redirect():
    '''
    Change the args and redirect to another salt script
    '''
    avail = get_avail()
    if len(sys.argv) < 2:
        msg = 'Must pass in a salt command, available commands are:'
        for cmd in avail:
            msg += '\n{0}'.format(cmd)
        print(msg)
        sys.exit(1)
    cmd = sys.argv[1]
    if cmd not in avail:
        # Fall back to the salt command
        sys.argv[0] = 'salt'
        s_fun = salt.scripts.salt_main
    else:
        sys.argv[0] = 'salt-{0}'.format(cmd)
        sys.argv.pop(1)
        s_fun = getattr(salt.scripts, 'salt_{0}'.format(cmd))
    s_fun()


if __name__ == '__main__':
    if is_windows():
        # Since this file does not have a '.py' extension, when running on
        # Windows, spawning any addional processes will fail due to Python
        # not being able to load this 'module' in the new process.
        # Work around this by creating a '.pyc' file which will enable the
        # spawned process to load this 'module' and proceed.
        import os.path
        import py_compile
        cfile = os.path.splitext(__file__)[0] + '.pyc'
        if not os.path.exists(cfile):
            py_compile.compile(__file__, cfile)
    redirect()
