var searchIndex = JSON.parse('{\
"alloc":{"doc":"The Rust core allocation and collections library","i":[[0,"alloc","alloc","Memory allocation APIs",null,null],[3,"AllocErr","alloc::alloc","The `AllocErr` error indicates an allocation failure that…",null,null],[4,"AllocInit","","A desired initial state for allocated memory.",null,null],[13,"Uninitialized","","The contents of the new memory are uninitialized.",0,null],[13,"Zeroed","","The new memory is guaranteed to be zeroed.",0,null],[3,"MemoryBlock","","Represents a block of allocated memory returned by an…",null,null],[12,"ptr","","",1,null],[12,"size","","",1,null],[4,"ReallocPlacement","","A placement constraint when growing or shrinking an…",null,null],[13,"MayMove","","The allocator is allowed to move the allocation to a…",2,null],[13,"InPlace","","The address of the new memory must not change.",2,null],[8,"AllocRef","","An implementation of `AllocRef` can allocate, grow,…",null,null],[10,"alloc","","Attempts to allocate a block of memory.",3,[[["allocinit",4],["layout",3]],[["result",4],["allocerr",3],["memoryblock",3]]]],[10,"dealloc","","Deallocates the memory referenced by `ptr`.",3,[[["nonnull",3],["layout",3]]]],[11,"grow","","Attempts to extend the memory block.",3,[[["reallocplacement",4],["layout",3],["allocinit",4],["nonnull",3]],[["result",4],["allocerr",3],["memoryblock",3]]]],[11,"shrink","","Attempts to shrink the memory block.",3,[[["reallocplacement",4],["nonnull",3],["layout",3]],[["result",4],["allocerr",3],["memoryblock",3]]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of…",3,[[]]],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard…",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",4,[[["layout",3]]]],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer…",4,[[["layout",3]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",4,[[["layout",3]]]],[11,"realloc","","Shrink or grow a block of memory to the given `new_size`.…",4,[[["layout",3]]]],[3,"Layout","","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some…",null,null],[3,"Global","","The global memory allocator.",null,null],[5,"alloc","","Allocate memory with the global allocator.",null,[[["layout",3]]]],[5,"dealloc","","Deallocate memory with the global allocator.",null,[[["layout",3]]]],[5,"realloc","","Reallocate memory with the global allocator.",null,[[["layout",3]]]],[5,"alloc_zeroed","","Allocate zero-initialized memory with the global allocator.",null,[[["layout",3]]]],[5,"handle_alloc_error","","Abort on memory allocation error or failure.",null,[[["layout",3]]]],[0,"boxed","alloc","A pointer type for heap allocation.",null,null],[3,"Box","alloc::boxed","A pointer type for heap allocation.",null,null],[11,"new","","Allocates memory on the heap and then places `x` into it.",5,[[],["box",3]]],[11,"new_uninit","","Constructs a new box with uninitialized contents.",5,[[],[["box",3],["maybeuninit",19]]]],[11,"new_zeroed","","Constructs a new `Box` with uninitialized contents, with…",5,[[],[["box",3],["maybeuninit",19]]]],[11,"pin","","Constructs a new `Pin<Box<T>>`. If `T` does not implement…",5,[[],[["pin",3],["box",3]]]],[11,"into_boxed_slice","","Converts a `Box<T>` into a `Box<[T]>`",5,[[["box",3]],["box",3]]],[11,"new_uninit_slice","","Constructs a new boxed slice with uninitialized contents.",5,[[],["box",3]]],[11,"assume_init","","Converts to `Box<T>`.",5,[[],["box",3]]],[11,"assume_init","","Converts to `Box<[T]>`.",5,[[],["box",3]]],[11,"from_raw","","Constructs a box from a raw pointer.",5,[[]]],[11,"into_raw","","Consumes the `Box`, returning a wrapped raw pointer.",5,[[["box",3]]]],[11,"into_raw_non_null","","Consumes the `Box`, returning the wrapped pointer as…",5,[[["box",3]],["nonnull",3]]],[11,"leak","","Consumes and leaks the `Box`, returning a mutable…",5,[[["box",3]]]],[11,"into_pin","","Converts a `Box<T>` into a `Pin<Box<T>>`",5,[[["box",3]],[["pin",3],["box",3]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",5,[[],[["box",3],["result",4],["box",3]]]],[11,"downcast","","Attempt to downcast the box to a concrete type.",5,[[],[["result",4],["box",3],["box",3]]]],[0,"borrow","alloc","A module for working with borrowed data.",null,null],[8,"Borrow","alloc::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",6,[[]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",7,[[]]],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",8,null],[13,"Owned","","Owned data.",8,null],[8,"ToOwned","","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","The resulting type after obtaining ownership.",9,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",9,[[]]],[11,"clone_into","","Uses borrowed data to replace owned data, usually by…",9,[[]]],[11,"is_borrowed","","Returns true if the data is borrowed, i.e. if `to_mut`…",8,[[]]],[11,"is_owned","","Returns true if the data is owned, i.e. if `to_mut` would…",8,[[]]],[11,"to_mut","","Acquires a mutable reference to the owned form of the data.",8,[[]]],[11,"into_owned","","Extracts the owned data.",8,[[]]],[0,"collections","alloc","Collection types.",null,null],[4,"TryReserveError","alloc::collections","The error type for `try_reserve` methods.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the…",10,null],[13,"AllocError","","The memory allocator returned an error",10,null],[12,"layout","alloc::collections::TryReserveError","The layout of allocation request that failed",11,null],[0,"binary_heap","alloc::collections","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","alloc::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest…",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIterSorted","","",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"DrainSorted","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[11,"pop","","Removes the peeked value from the heap and returns it.",12,[[["peekmut",3]]]],[11,"new","","Creates an empty `BinaryHeap` as a max-heap.",13,[[],["binaryheap",3]]],[11,"with_capacity","","Creates an empty `BinaryHeap` with a specific capacity.…",13,[[],["binaryheap",3]]],[11,"peek_mut","","Returns a mutable reference to the greatest item in the…",13,[[],[["peekmut",3],["option",4]]]],[11,"pop","","Removes the greatest item from the binary heap and returns…",13,[[],["option",4]]],[11,"push","","Pushes an item onto the binary heap.",13,[[]]],[11,"into_sorted_vec","","Consumes the `BinaryHeap` and returns a vector in sorted…",13,[[],["vec",3]]],[11,"append","","Moves all the elements of `other` into `self`, leaving…",13,[[]]],[11,"drain_sorted","","Returns an iterator which retrieves elements in heap…",13,[[],["drainsorted",3]]],[11,"retain","","Retains only the elements specified by the predicate.",13,[[]]],[11,"iter","","Returns an iterator visiting all values in the underlying…",13,[[],["iter",3]]],[11,"into_iter_sorted","","Returns an iterator which retrieves elements in heap…",13,[[],["intoitersorted",3]]],[11,"peek","","Returns the greatest item in the binary heap, or `None` if…",13,[[],["option",4]]],[11,"capacity","","Returns the number of elements the binary heap can hold…",13,[[]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",13,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",13,[[]]],[11,"shrink_to_fit","","Discards as much additional capacity as possible.",13,[[]]],[11,"shrink_to","","Discards capacity with a lower bound.",13,[[]]],[11,"into_vec","","Consumes the `BinaryHeap` and returns the underlying…",13,[[],["vec",3]]],[11,"len","","Returns the length of the binary heap.",13,[[]]],[11,"is_empty","","Checks if the binary heap is empty.",13,[[]]],[11,"drain","","Clears the binary heap, returning an iterator over the…",13,[[],["drain",3]]],[11,"clear","","Drops all items from the binary heap.",13,[[]]],[0,"linked_list","alloc::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","alloc::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"Cursor","","A cursor over a `LinkedList`.",null,null],[3,"CursorMut","","A cursor over a `LinkedList` with editing operations.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on…",null,null],[11,"new","","Creates an empty `LinkedList`.",14,[[]]],[11,"append","","Moves all elements from `other` to the end of the list.",14,[[]]],[11,"prepend","","Moves all elements from `other` to the begin of the list.",14,[[]]],[11,"iter","","Provides a forward iterator.",14,[[],["iter",3]]],[11,"iter_mut","","Provides a forward iterator with mutable references.",14,[[],["itermut",3]]],[11,"cursor_front","","Provides a cursor at the front element.",14,[[],["cursor",3]]],[11,"cursor_front_mut","","Provides a cursor with editing operations at the front…",14,[[],["cursormut",3]]],[11,"cursor_back","","Provides a cursor at the back element.",14,[[],["cursor",3]]],[11,"cursor_back_mut","","Provides a cursor with editing operations at the back…",14,[[],["cursormut",3]]],[11,"is_empty","","Returns `true` if the `LinkedList` is empty.",14,[[]]],[11,"len","","Returns the length of the `LinkedList`.",14,[[]]],[11,"clear","","Removes all elements from the `LinkedList`.",14,[[]]],[11,"contains","","Returns `true` if the `LinkedList` contains an element…",14,[[]]],[11,"front","","Provides a reference to the front element, or `None` if…",14,[[],["option",4]]],[11,"front_mut","","Provides a mutable reference to the front element, or…",14,[[],["option",4]]],[11,"back","","Provides a reference to the back element, or `None` if the…",14,[[],["option",4]]],[11,"back_mut","","Provides a mutable reference to the back element, or…",14,[[],["option",4]]],[11,"push_front","","Adds an element first in the list.",14,[[]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the…",14,[[],["option",4]]],[11,"push_back","","Appends an element to the back of a list.",14,[[]]],[11,"pop_back","","Removes the last element from a list and returns it, or…",14,[[],["option",4]]],[11,"split_off","","Splits the list into two at the given index. Returns…",14,[[],["linkedlist",3]]],[11,"remove","","Removes the element at the given index and returns it.",14,[[]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if…",14,[[],["drainfilter",3]]],[11,"insert_next","","Inserts the given element just after the element most…",15,[[]]],[11,"peek_next","","Provides a reference to the next element, without changing…",15,[[],["option",4]]],[11,"index","","Returns the cursor position index within the `LinkedList`.",16,[[],["option",4]]],[11,"move_next","","Moves the cursor to the next element of the `LinkedList`.",16,[[]]],[11,"move_prev","","Moves the cursor to the previous element of the…",16,[[]]],[11,"current","","Returns a reference to the element that the cursor is…",16,[[],["option",4]]],[11,"peek_next","","Returns a reference to the next element.",16,[[],["option",4]]],[11,"peek_prev","","Returns a reference to the previous element.",16,[[],["option",4]]],[11,"index","","Returns the cursor position index within the `LinkedList`.",17,[[],["option",4]]],[11,"move_next","","Moves the cursor to the next element of the `LinkedList`.",17,[[]]],[11,"move_prev","","Moves the cursor to the previous element of the…",17,[[]]],[11,"current","","Returns a reference to the element that the cursor is…",17,[[],["option",4]]],[11,"peek_next","","Returns a reference to the next element.",17,[[],["option",4]]],[11,"peek_prev","","Returns a reference to the previous element.",17,[[],["option",4]]],[11,"as_cursor","","Returns a read-only cursor pointing to the current element.",17,[[],["cursor",3]]],[11,"insert_after","","Inserts a new element into the `LinkedList` after the…",17,[[]]],[11,"insert_before","","Inserts a new element into the `LinkedList` before the…",17,[[]]],[11,"remove_current","","Removes the current element from the `LinkedList`.",17,[[],["option",4]]],[11,"remove_current_as_list","","Removes the current element from the `LinkedList` without…",17,[[],[["linkedlist",3],["option",4]]]],[11,"splice_after","","Inserts the elements from the given `LinkedList` after the…",17,[[["linkedlist",3]]]],[11,"splice_before","","Inserts the elements from the given `LinkedList` before…",17,[[["linkedlist",3]]]],[11,"split_after","","Splits the list into two after the current element. This…",17,[[],["linkedlist",3]]],[11,"split_before","","Splits the list into two before the current element. This…",17,[[],["linkedlist",3]]],[0,"vec_deque","alloc::collections","A double-ended queue implemented with a growable ring…",null,null],[3,"Drain","alloc::collections::vec_deque","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"VecDeque","","A double-ended queue implemented with a growable ring…",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[11,"new","","Creates an empty `VecDeque`.",18,[[],["vecdeque",3]]],[11,"with_capacity","","Creates an empty `VecDeque` with space for at least…",18,[[],["vecdeque",3]]],[11,"get","","Provides a reference to the element at the given index.",18,[[],["option",4]]],[11,"get_mut","","Provides a mutable reference to the element at the given…",18,[[],["option",4]]],[11,"swap","","Swaps elements at indices `i` and `j`.",18,[[]]],[11,"capacity","","Returns the number of elements the `VecDeque` can hold…",18,[[]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",18,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",18,[[]]],[11,"try_reserve_exact","","Tries to reserve the minimum capacity for exactly…",18,[[],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",18,[[],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the `VecDeque` as much as possible.",18,[[]]],[11,"shrink_to","","Shrinks the capacity of the `VecDeque` with a lower bound.",18,[[]]],[11,"truncate","","Shortens the `VecDeque`, keeping the first `len` elements…",18,[[]]],[11,"iter","","Returns a front-to-back iterator.",18,[[],["iter",3]]],[11,"iter_mut","","Returns a front-to-back iterator that returns mutable…",18,[[],["itermut",3]]],[11,"as_slices","","Returns a pair of slices which contain, in order, the…",18,[[]]],[11,"as_mut_slices","","Returns a pair of slices which contain, in order, the…",18,[[]]],[11,"len","","Returns the number of elements in the `VecDeque`.",18,[[]]],[11,"is_empty","","Returns `true` if the `VecDeque` is empty.",18,[[]]],[11,"drain","","Creates a draining iterator that removes the specified…",18,[[],["drain",3]]],[11,"clear","","Clears the `VecDeque`, removing all values.",18,[[]]],[11,"contains","","Returns `true` if the `VecDeque` contains an element equal…",18,[[]]],[11,"front","","Provides a reference to the front element, or `None` if…",18,[[],["option",4]]],[11,"front_mut","","Provides a mutable reference to the front element, or…",18,[[],["option",4]]],[11,"back","","Provides a reference to the back element, or `None` if the…",18,[[],["option",4]]],[11,"back_mut","","Provides a mutable reference to the back element, or…",18,[[],["option",4]]],[11,"pop_front","","Removes the first element and returns it, or `None` if the…",18,[[],["option",4]]],[11,"pop_back","","Removes the last element from the `VecDeque` and returns…",18,[[],["option",4]]],[11,"push_front","","Prepends an element to the `VecDeque`.",18,[[]]],[11,"push_back","","Appends an element to the back of the `VecDeque`.",18,[[]]],[11,"swap_remove_front","","Removes an element from anywhere in the `VecDeque` and…",18,[[],["option",4]]],[11,"swap_remove_back","","Removes an element from anywhere in the `VecDeque` and…",18,[[],["option",4]]],[11,"insert","","Inserts an element at `index` within the `VecDeque`,…",18,[[]]],[11,"remove","","Removes and returns the element at `index` from the…",18,[[],["option",4]]],[11,"split_off","","Splits the `VecDeque` into two at the given index.",18,[[]]],[11,"append","","Moves all the elements of `other` into `self`, leaving…",18,[[]]],[11,"retain","","Retains only the elements specified by the predicate.",18,[[]]],[11,"resize_with","","Modifies the `VecDeque` in-place so that `len()` is equal…",18,[[]]],[11,"make_contiguous","","Rearranges the internal storage of this deque so it is one…",18,[[]]],[11,"rotate_left","","Rotates the double-ended queue `mid` places to the left.",18,[[]]],[11,"rotate_right","","Rotates the double-ended queue `k` places to the right.",18,[[]]],[11,"resize","","Modifies the `VecDeque` in-place so that `len()` is equal…",18,[[]]],[0,"btree_map","alloc::collections","A map based on a B-Tree.",null,null],[3,"BTreeMap","alloc::collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a…",null,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of…",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part…",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on BTreeMap.",null,null],[4,"Entry","","A view into a single entry in a map, which may either be…",null,null],[13,"Vacant","","A vacant entry.",19,null],[13,"Occupied","","An occupied entry.",19,null],[0,"btree_set","alloc::collections","A set based on a B-Tree.",null,null],[3,"BTreeSet","alloc::collections::btree_set","A set based on a B-Tree.",null,null],[3,"Iter","","An iterator over the items of a `BTreeSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of…",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric…",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of…",null,null],[3,"Union","","A lazy iterator producing elements in the union of…",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on BTreeSet.",null,null],[0,"fmt","alloc","Utilities for formatting and printing `String`s.",null,null],[4,"Alignment","alloc::fmt","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",20,null],[13,"Right","","Indication that contents should be right-aligned.",20,null],[13,"Center","","Indication that contents should be center-aligned.",20,null],[3,"Error","","The error type which is returned from formatting a message…",null,null],[5,"write","","The `write` function takes an output stream, and an…",null,[[["write",8],["arguments",3]],[["error",3],["result",4]]]],[3,"Arguments","","This structure represents a safely precompiled version of…",null,null],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",21,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",22,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",23,[[["formatter",3]],[["error",3],["result",4]]]],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",24,[[["formatter",3]],[["error",3],["result",4]]]],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a…",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether…",25,[[],[["error",3],["result",4]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the…",25,[[],[["error",3],["result",4]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors…",25,[[["arguments",3]],[["error",3],["result",4]]]],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",26,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",27,[[["formatter",3]],[["error",3],["result",4]]]],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",28,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",29,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",30,[[["formatter",3]],[["error",3],["result",4]]]],[5,"format","","The `format` function takes an [`Arguments`] struct and…",null,[[["arguments",3]],["string",3]]],[0,"prelude","alloc","The alloc Prelude",null,null],[0,"v1","alloc::prelude","The first version of the prelude of `alloc` crate.",null,null],[0,"rc","alloc","Single-threaded reference-counting pointers. \'Rc\' stands…",null,null],[3,"Rc","alloc::rc","A single-threaded reference-counting pointer. \'Rc\' stands…",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning…",null,null],[11,"new","","Constructs a new `Rc<T>`.",31,[[],["rc",3]]],[11,"new_uninit","","Constructs a new `Rc` with uninitialized contents.",31,[[],[["rc",3],["maybeuninit",19]]]],[11,"new_zeroed","","Constructs a new `Rc` with uninitialized contents, with…",31,[[],[["rc",3],["maybeuninit",19]]]],[11,"pin","","Constructs a new `Pin<Rc<T>>`. If `T` does not implement…",31,[[],[["rc",3],["pin",3]]]],[11,"try_unwrap","","Returns the inner value, if the `Rc` has exactly one…",31,[[],["result",4]]],[11,"new_uninit_slice","","Constructs a new reference-counted slice with…",31,[[],["rc",3]]],[11,"assume_init","","Converts to `Rc<T>`.",31,[[],["rc",3]]],[11,"assume_init","","Converts to `Rc<[T]>`.",31,[[],["rc",3]]],[11,"into_raw","","Consumes the `Rc`, returning the wrapped pointer.",31,[[]]],[11,"as_ptr","","Provides a raw pointer to the data.",31,[[]]],[11,"from_raw","","Constructs an `Rc<T>` from a raw pointer.",31,[[]]],[11,"into_raw_non_null","","Consumes the `Rc`, returning the wrapped pointer as…",31,[[],["nonnull",3]]],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this allocation.",31,[[],["weak",3]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this…",31,[[]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers to this…",31,[[]]],[11,"get_mut","","Returns a mutable reference into the given `Rc`, if there…",31,[[],["option",4]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given `Rc`, without…",31,[[]]],[11,"ptr_eq","","Returns `true` if the two `Rc`s point to the same…",31,[[]]],[11,"make_mut","","Makes a mutable reference into the given `Rc`.",31,[[]]],[11,"downcast","","Attempt to downcast the `Rc<dyn Any>` to a concrete type.",31,[[],[["rc",3],["rc",3],["result",4]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory.…",32,[[],["weak",3]]],[11,"as_ptr","","Returns a raw pointer to the object `T` pointed to by this…",32,[[]]],[11,"into_raw","","Consumes the `Weak<T>` and turns it into a raw pointer.",32,[[]]],[11,"from_raw","","Converts a raw pointer previously created by [`into_raw`]…",32,[[]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Rc`],…",32,[[],[["option",4],["rc",3]]]],[11,"strong_count","","Gets the number of strong (`Rc`) pointers pointing to this…",32,[[]]],[11,"weak_count","","Gets the number of `Weak` pointers pointing to this…",32,[[]]],[11,"ptr_eq","","Returns `true` if the two `Weak`s point to the same…",32,[[]]],[0,"slice","alloc","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"SliceIndex","alloc::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",33,null],[10,"get","","Returns a shared reference to the output at this location,…",33,[[],["option",4]]],[10,"get_mut","","Returns a mutable reference to the output at this…",33,[[],["option",4]]],[10,"get_unchecked","","Returns a shared reference to the output at this location,…",33,[[]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this…",33,[[]]],[10,"index","","Returns a shared reference to the output at this location,…",33,[[]]],[10,"index_mut","","Returns a mutable reference to the output at this…",33,[[]]],[5,"from_mut","","Converts a reference to T into a slice of length 1…",null,[[]]],[5,"from_ref","","Converts a reference to T into a slice of length 1…",null,[[]]],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[]]],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`],…",null,[[]]],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"Split","","An iterator over subslices separated by elements that…",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RSplit","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are…",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"SplitN","","An iterator over subslices separated by elements that…",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that…",null,null],[8,"Concat","","Helper trait for `[T]::concat`.",null,null],[16,"Output","","The resulting type after concatenation",34,null],[10,"concat","","Implementation of `[T]::concat`",34,[[]]],[8,"Join","","Helper trait for `[T]::join`",null,null],[16,"Output","","The resulting type after concatenation",35,null],[10,"join","","Implementation of `[T]::join`",35,[[]]],[0,"str","alloc","Unicode string slices.",null,null],[0,"pattern","alloc::str","The string Pattern API.",null,null],[8,"Pattern","alloc::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",36,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the…",36,[[]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",36,[[]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the…",36,[[]]],[11,"strip_prefix_of","","Removes the pattern from the front of haystack, if it…",36,[[],["option",4]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the…",36,[[]]],[11,"strip_suffix_of","","Removes the pattern from the back of haystack, if it…",36,[[],["option",4]]],[4,"SearchStep","","Result of calling `Searcher::next()` or…",null,null],[13,"Match","","Expresses that a match of the pattern has been found at…",37,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a…",37,null],[13,"Done","","Expresses that every byte of the haystack has been…",37,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",38,[[]]],[10,"next","","Performs the next search step starting from the front.",38,[[],["searchstep",4]]],[11,"next_match","","Finds the next `Match` result. See `next()`",38,[[],["option",4]]],[11,"next_reject","","Finds the next `Reject` result. See `next()` and…",38,[[],["option",4]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",39,[[],["searchstep",4]]],[11,"next_match_back","","Finds the next `Match` result. See `next_back()`",39,[[],["option",4]]],[11,"next_reject_back","","Finds the next `Reject` result. See `next_back()`",39,[[],["option",4]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be…",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<\'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<\'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<\'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<\'a>>::Searcher`.",null,null],[3,"EncodeUtf16","alloc::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a…",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a…",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["result",4],["utf8error",3]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,[[],[["result",4],["utf8error",3]]]],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and…",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without…",null,[[]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without…",null,[[]]],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`]…",null,null],[3,"EscapeDebug","","The return type of [`str::escape_debug`].",null,null],[3,"EscapeDefault","","The return type of [`str::escape_default`].",null,null],[3,"EscapeUnicode","","The return type of [`str::escape_unicode`].",null,null],[8,"FromStr","","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",40,null],[10,"from_str","","Parses a string `s` to return a value of this type.",40,[[],["result",4]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a…",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[5,"from_boxed_utf8_unchecked","","Converts a boxed slice of bytes to a boxed string slice…",null,[[["box",3]],["box",3]]],[0,"string","alloc","A UTF-8 encoded, growable string.",null,null],[3,"String","alloc::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a…",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a…",null,null],[3,"Drain","","A draining iterator for `String`.",null,null],[6,"ParseError","","A type alias for [`Infallible`].",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",41,[[],["string",3]]],[11,"new","","Creates a new empty `String`.",42,[[],["string",3]]],[11,"with_capacity","","Creates a new empty `String` with a particular capacity.",42,[[],["string",3]]],[11,"from_utf8","","Converts a vector of bytes to a `String`.",42,[[["vec",3]],[["fromutf8error",3],["string",3],["result",4]]]],[11,"from_utf8_lossy","","Converts a slice of bytes to a string, including invalid…",42,[[],["cow",4]]],[11,"from_utf16","","Decode a UTF-16 encoded vector `v` into a `String`,…",42,[[],[["result",4],["string",3],["fromutf16error",3]]]],[11,"from_utf16_lossy","","Decode a UTF-16 encoded slice `v` into a `String`,…",42,[[],["string",3]]],[11,"into_raw_parts","","Decomposes a `String` into its raw components.",42,[[]]],[11,"from_raw_parts","","Creates a new `String` from a length, capacity, and pointer.",42,[[],["string",3]]],[11,"from_utf8_unchecked","","Converts a vector of bytes to a `String` without checking…",42,[[["vec",3]],["string",3]]],[11,"into_bytes","","Converts a `String` into a byte vector.",42,[[],["vec",3]]],[11,"as_str","","Extracts a string slice containing the entire `String`.",42,[[]]],[11,"as_mut_str","","Converts a `String` into a mutable string slice.",42,[[]]],[11,"push_str","","Appends a given string slice onto the end of this `String`.",42,[[]]],[11,"capacity","","Returns this `String`\'s capacity, in bytes.",42,[[]]],[11,"reserve","","Ensures that this `String`\'s capacity is at least…",42,[[]]],[11,"reserve_exact","","Ensures that this `String`\'s capacity is `additional`…",42,[[]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",42,[[],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly…",42,[[],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of this `String` to match its length.",42,[[]]],[11,"shrink_to","","Shrinks the capacity of this `String` with a lower bound.",42,[[]]],[11,"push","","Appends the given [`char`] to the end of this `String`.",42,[[]]],[11,"as_bytes","","Returns a byte slice of this `String`\'s contents.",42,[[]]],[11,"truncate","","Shortens this `String` to the specified length.",42,[[]]],[11,"pop","","Removes the last character from the string buffer and…",42,[[],["option",4]]],[11,"remove","","Removes a [`char`] from this `String` at a byte position…",42,[[]]],[11,"retain","","Retains only the characters specified by the predicate.",42,[[]]],[11,"insert","","Inserts a character into this `String` at a byte position.",42,[[]]],[11,"insert_str","","Inserts a string slice into this `String` at a byte…",42,[[]]],[11,"as_mut_vec","","Returns a mutable reference to the contents of this…",42,[[],["vec",3]]],[11,"len","","Returns the length of this `String`, in bytes, not…",42,[[]]],[11,"is_empty","","Returns `true` if this `String` has a length of zero, and…",42,[[]]],[11,"split_off","","Splits the string into two at the given index.",42,[[],["string",3]]],[11,"clear","","Truncates this `String`, removing all contents.",42,[[]]],[11,"drain","","Creates a draining iterator that removes the specified…",42,[[],["drain",3]]],[11,"replace_range","","Removes the specified range in the string, and replaces it…",42,[[]]],[11,"into_boxed_str","","Converts this `String` into a [`Box`]`<`[`str`]`>`.",42,[[],["box",3]]],[11,"as_bytes","","Returns a slice of [`u8`]s bytes that were attempted to…",43,[[]]],[11,"into_bytes","","Returns the bytes that were attempted to convert to a…",43,[[],["vec",3]]],[11,"utf8_error","","Fetch a `Utf8Error` to get more details about the…",43,[[],["utf8error",3]]],[0,"sync","alloc","Thread-safe reference-counting pointers.",null,null],[3,"Arc","alloc::sync","A thread-safe reference-counting pointer. \'Arc\' stands for…",null,null],[3,"Weak","","`Weak` is a version of [`Arc`] that holds a non-owning…",null,null],[11,"new","","Constructs a new `Arc<T>`.",44,[[],["arc",3]]],[11,"new_uninit","","Constructs a new `Arc` with uninitialized contents.",44,[[],[["arc",3],["maybeuninit",19]]]],[11,"new_zeroed","","Constructs a new `Arc` with uninitialized contents, with…",44,[[],[["arc",3],["maybeuninit",19]]]],[11,"pin","","Constructs a new `Pin<Arc<T>>`. If `T` does not implement…",44,[[],[["arc",3],["pin",3]]]],[11,"try_unwrap","","Returns the inner value, if the `Arc` has exactly one…",44,[[],["result",4]]],[11,"new_uninit_slice","","Constructs a new reference-counted slice with…",44,[[],["arc",3]]],[11,"assume_init","","Converts to `Arc<T>`.",44,[[],["arc",3]]],[11,"assume_init","","Converts to `Arc<[T]>`.",44,[[],["arc",3]]],[11,"into_raw","","Consumes the `Arc`, returning the wrapped pointer.",44,[[]]],[11,"as_ptr","","Provides a raw pointer to the data.",44,[[]]],[11,"from_raw","","Constructs an `Arc<T>` from a raw pointer.",44,[[]]],[11,"into_raw_non_null","","Consumes the `Arc`, returning the wrapped pointer as…",44,[[],["nonnull",3]]],[11,"downgrade","","Creates a new [`Weak`][weak] pointer to this allocation.",44,[[],["weak",3]]],[11,"weak_count","","Gets the number of [`Weak`][weak] pointers to this…",44,[[]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers to this…",44,[[]]],[11,"incr_strong_count","","Increments the strong reference count on the `Arc<T>`…",44,[[]]],[11,"decr_strong_count","","Decrements the strong reference count on the `Arc<T>`…",44,[[]]],[11,"ptr_eq","","Returns `true` if the two `Arc`s point to the same…",44,[[]]],[11,"make_mut","","Makes a mutable reference into the given `Arc`.",44,[[]]],[11,"get_mut","","Returns a mutable reference into the given `Arc`, if there…",44,[[],["option",4]]],[11,"get_mut_unchecked","","Returns a mutable reference into the given `Arc`, without…",44,[[]]],[11,"downcast","","Attempt to downcast the `Arc<dyn Any + Send + Sync>` to a…",44,[[],[["arc",3],["result",4]]]],[11,"new","","Constructs a new `Weak<T>`, without allocating any memory.…",45,[[],["weak",3]]],[11,"as_ptr","","Returns a raw pointer to the object `T` pointed to by this…",45,[[]]],[11,"into_raw","","Consumes the `Weak<T>` and turns it into a raw pointer.",45,[[]]],[11,"from_raw","","Converts a raw pointer previously created by [`into_raw`]…",45,[[]]],[11,"upgrade","","Attempts to upgrade the `Weak` pointer to an [`Arc`],…",45,[[],[["option",4],["arc",3]]]],[11,"strong_count","","Gets the number of strong (`Arc`) pointers pointing to…",45,[[]]],[11,"weak_count","","Gets an approximation of the number of `Weak` pointers…",45,[[]]],[11,"ptr_eq","","Returns `true` if the two `Weak`s point to the same…",45,[[]]],[0,"task","alloc","Types and Traits for working with asynchronous tasks.",null,null],[8,"Wake","alloc::task","The implementation of waking a task on an executor.",null,null],[10,"wake","","Wake this task.",46,[[["arc",3]]]],[11,"wake_by_ref","","Wake this task without consuming the waker.",46,[[["arc",3]]]],[0,"vec","alloc","A contiguous growable array type with heap-allocated…",null,null],[3,"Vec","alloc::vec","A contiguous growable array type, written `Vec<T>` but…",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[11,"new","","Constructs a new, empty `Vec<T>`.",47,[[],["vec",3]]],[11,"with_capacity","","Constructs a new, empty `Vec<T>` with the specified…",47,[[],["vec",3]]],[11,"into_raw_parts","","Decomposes a `Vec<T>` into its raw components.",47,[[]]],[11,"from_raw_parts","","Creates a `Vec<T>` directly from the raw components of…",47,[[],["vec",3]]],[11,"capacity","","Returns the number of elements the vector can hold without…",47,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",47,[[]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",47,[[]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",47,[[],[["result",4],["tryreserveerror",4]]]],[11,"try_reserve_exact","","Tries to reserves the minimum capacity for exactly…",47,[[],[["result",4],["tryreserveerror",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the vector as much as possible.",47,[[]]],[11,"shrink_to","","Shrinks the capacity of the vector with a lower bound.",47,[[]]],[11,"into_boxed_slice","","Converts the vector into [`Box<[T]>`][owned slice].",47,[[],["box",3]]],[11,"truncate","","Shortens the vector, keeping the first `len` elements and…",47,[[]]],[11,"as_slice","","Extracts a slice containing the entire vector.",47,[[]]],[11,"as_mut_slice","","Extracts a mutable slice of the entire vector.",47,[[]]],[11,"as_ptr","","Returns a raw pointer to the vector\'s buffer.",47,[[]]],[11,"as_mut_ptr","","Returns an unsafe mutable pointer to the vector\'s buffer.",47,[[]]],[11,"set_len","","Forces the length of the vector to `new_len`.",47,[[]]],[11,"swap_remove","","Removes an element from the vector and returns it.",47,[[]]],[11,"insert","","Inserts an element at position `index` within the vector,…",47,[[]]],[11,"remove","","Removes and returns the element at position `index` within…",47,[[]]],[11,"retain","","Retains only the elements specified by the predicate.",47,[[]]],[11,"dedup_by_key","","Removes all but the first of consecutive elements in the…",47,[[]]],[11,"dedup_by","","Removes all but the first of consecutive elements in the…",47,[[]]],[11,"push","","Appends an element to the back of a collection.",47,[[]]],[11,"pop","","Removes the last element from a vector and returns it, or…",47,[[],["option",4]]],[11,"append","","Moves all the elements of `other` into `Self`, leaving…",47,[[]]],[11,"drain","","Creates a draining iterator that removes the specified…",47,[[],["drain",3]]],[11,"clear","","Clears the vector, removing all values.",47,[[]]],[11,"len","","Returns the number of elements in the vector, also…",47,[[]]],[11,"is_empty","","Returns `true` if the vector contains no elements.",47,[[]]],[11,"split_off","","Splits the collection into two at the given index.",47,[[]]],[11,"resize_with","","Resizes the `Vec` in-place so that `len` is equal to…",47,[[]]],[11,"leak","","Consumes and leaks the `Vec`, returning a mutable…",47,[[["vec",3]]]],[11,"resize","","Resizes the `Vec` in-place so that `len` is equal to…",47,[[]]],[11,"extend_from_slice","","Clones and appends all elements in a slice to the `Vec`.",47,[[]]],[11,"resize_default","","Resizes the `Vec` in-place so that `len` is equal to…",47,[[]]],[11,"dedup","","Removes consecutive repeated elements in the vector…",47,[[]]],[11,"remove_item","","Removes the first instance of `item` from the vector if…",47,[[],["option",4]]],[11,"splice","","Creates a splicing iterator that replaces the specified…",47,[[],["splice",3]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if…",47,[[],["drainfilter",3]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",48,[[]]],[11,"as_mut_slice","","Returns the remaining items of this iterator as a mutable…",48,[[]]],[11,"as_slice","","Returns the remaining items of this iterator as a slice.",49,[[]]],[14,"vec","alloc","Creates a [`Vec`] containing the arguments.",null,null],[14,"format","","Creates a `String` using interpolation of runtime…",null,null],[11,"to_owned","alloc::alloc","",50,[[]]],[11,"clone_into","","",50,[[]]],[11,"to_string","","",50,[[],["string",3]]],[11,"from","","",50,[[]]],[11,"try_from","","",50,[[],["result",4]]],[11,"into","","",50,[[]]],[11,"try_into","","",50,[[],["result",4]]],[11,"borrow","","",50,[[]]],[11,"borrow_mut","","",50,[[]]],[11,"type_id","","",50,[[],["typeid",3]]],[11,"to_owned","","",0,[[]]],[11,"clone_into","","",0,[[]]],[11,"from","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"into","","",0,[[]]],[11,"try_into","","",0,[[],["result",4]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"to_owned","","",1,[[]]],[11,"clone_into","","",1,[[]]],[11,"from","","",1,[[]]],[11,"try_from","","",1,[[],["result",4]]],[11,"into","","",1,[[]]],[11,"try_into","","",1,[[],["result",4]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"from","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"into","","",2,[[]]],[11,"try_into","","",2,[[],["result",4]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"to_owned","","",51,[[]]],[11,"clone_into","","",51,[[]]],[11,"from","","",51,[[]]],[11,"try_from","","",51,[[],["result",4]]],[11,"into","","",51,[[]]],[11,"try_into","","",51,[[],["result",4]]],[11,"borrow","","",51,[[]]],[11,"borrow_mut","","",51,[[]]],[11,"type_id","","",51,[[],["typeid",3]]],[11,"to_owned","","",52,[[]]],[11,"clone_into","","",52,[[]]],[11,"to_string","","",52,[[],["string",3]]],[11,"from","","",52,[[]]],[11,"try_from","","",52,[[],["result",4]]],[11,"into","","",52,[[]]],[11,"try_into","","",52,[[],["result",4]]],[11,"borrow","","",52,[[]]],[11,"borrow_mut","","",52,[[]]],[11,"type_id","","",52,[[],["typeid",3]]],[11,"to_owned","","",53,[[]]],[11,"clone_into","","",53,[[]]],[11,"from","","",53,[[]]],[11,"try_from","","",53,[[],["result",4]]],[11,"into","","",53,[[]]],[11,"try_into","","",53,[[],["result",4]]],[11,"borrow","","",53,[[]]],[11,"borrow_mut","","",53,[[]]],[11,"type_id","","",53,[[],["typeid",3]]],[11,"to_owned","alloc::boxed","",5,[[]]],[11,"clone_into","","",5,[[]]],[11,"to_string","","",5,[[],["string",3]]],[11,"from","","",5,[[]]],[11,"from","","",5,[[]]],[11,"into_iter","","",5,[[]]],[11,"into_searcher","","",5,[[],["charpredicatesearcher",3]]],[11,"is_contained_in","","",5,[[]]],[11,"is_prefix_of","","",5,[[]]],[11,"strip_prefix_of","","",5,[[],["option",4]]],[11,"is_suffix_of","","",5,[[]]],[11,"strip_suffix_of","","",5,[[],["option",4]]],[11,"try_from","","",5,[[],["result",4]]],[11,"into","","",5,[[]]],[11,"try_into","","",5,[[],["result",4]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"into_future","","",5,[[]]],[11,"to_owned","alloc::borrow","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"to_string","","",8,[[],["string",3]]],[11,"from","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"into","","",8,[[]]],[11,"try_into","","",8,[[],["result",4]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"to_owned","alloc::collections","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"to_string","","",10,[[],["string",3]]],[11,"from","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"into","","",10,[[]]],[11,"try_into","","",10,[[],["result",4]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"to_owned","alloc::collections::binary_heap","",13,[[]]],[11,"clone_into","","",13,[[]]],[11,"from","","",13,[[]]],[11,"into_iter","","",13,[[]]],[11,"try_from","","",13,[[],["result",4]]],[11,"into","","",13,[[]]],[11,"try_into","","",13,[[],["result",4]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",12,[[]]],[11,"try_from","","",12,[[],["result",4]]],[11,"into","","",12,[[]]],[11,"try_into","","",12,[[],["result",4]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"to_owned","","",54,[[]]],[11,"clone_into","","",54,[[]]],[11,"from","","",54,[[]]],[11,"into_iter","","",54,[[]]],[11,"try_from","","",54,[[],["result",4]]],[11,"into","","",54,[[]]],[11,"try_into","","",54,[[],["result",4]]],[11,"borrow","","",54,[[]]],[11,"borrow_mut","","",54,[[]]],[11,"type_id","","",54,[[],["typeid",3]]],[11,"to_owned","","",55,[[]]],[11,"clone_into","","",55,[[]]],[11,"from","","",55,[[]]],[11,"into_iter","","",55,[[]]],[11,"try_from","","",55,[[],["result",4]]],[11,"into","","",55,[[]]],[11,"try_into","","",55,[[],["result",4]]],[11,"borrow","","",55,[[]]],[11,"borrow_mut","","",55,[[]]],[11,"type_id","","",55,[[],["typeid",3]]],[11,"to_owned","","",56,[[]]],[11,"clone_into","","",56,[[]]],[11,"from","","",56,[[]]],[11,"into_iter","","",56,[[]]],[11,"try_from","","",56,[[],["result",4]]],[11,"into","","",56,[[]]],[11,"try_into","","",56,[[],["result",4]]],[11,"borrow","","",56,[[]]],[11,"borrow_mut","","",56,[[]]],[11,"type_id","","",56,[[],["typeid",3]]],[11,"from","","",57,[[]]],[11,"into_iter","","",57,[[]]],[11,"try_from","","",57,[[],["result",4]]],[11,"into","","",57,[[]]],[11,"try_into","","",57,[[],["result",4]]],[11,"borrow","","",57,[[]]],[11,"borrow_mut","","",57,[[]]],[11,"type_id","","",57,[[],["typeid",3]]],[11,"from","","",58,[[]]],[11,"into_iter","","",58,[[]]],[11,"try_from","","",58,[[],["result",4]]],[11,"into","","",58,[[]]],[11,"try_into","","",58,[[],["result",4]]],[11,"borrow","","",58,[[]]],[11,"borrow_mut","","",58,[[]]],[11,"type_id","","",58,[[],["typeid",3]]],[11,"to_owned","alloc::collections::btree_map","",59,[[]]],[11,"clone_into","","",59,[[]]],[11,"from","","",59,[[]]],[11,"into_iter","","",59,[[]]],[11,"try_from","","",59,[[],["result",4]]],[11,"into","","",59,[[]]],[11,"try_into","","",59,[[],["result",4]]],[11,"borrow","","",59,[[]]],[11,"borrow_mut","","",59,[[]]],[11,"type_id","","",59,[[],["typeid",3]]],[11,"to_owned","","",60,[[]]],[11,"clone_into","","",60,[[]]],[11,"from","","",60,[[]]],[11,"into_iter","","",60,[[]]],[11,"try_from","","",60,[[],["result",4]]],[11,"into","","",60,[[]]],[11,"try_into","","",60,[[],["result",4]]],[11,"borrow","","",60,[[]]],[11,"borrow_mut","","",60,[[]]],[11,"type_id","","",60,[[],["typeid",3]]],[11,"from","","",61,[[]]],[11,"into_iter","","",61,[[]]],[11,"try_from","","",61,[[],["result",4]]],[11,"into","","",61,[[]]],[11,"try_into","","",61,[[],["result",4]]],[11,"borrow","","",61,[[]]],[11,"borrow_mut","","",61,[[]]],[11,"type_id","","",61,[[],["typeid",3]]],[11,"from","","",62,[[]]],[11,"into_iter","","",62,[[]]],[11,"try_from","","",62,[[],["result",4]]],[11,"into","","",62,[[]]],[11,"try_into","","",62,[[],["result",4]]],[11,"borrow","","",62,[[]]],[11,"borrow_mut","","",62,[[]]],[11,"type_id","","",62,[[],["typeid",3]]],[11,"to_owned","","",63,[[]]],[11,"clone_into","","",63,[[]]],[11,"from","","",63,[[]]],[11,"into_iter","","",63,[[]]],[11,"try_from","","",63,[[],["result",4]]],[11,"into","","",63,[[]]],[11,"try_into","","",63,[[],["result",4]]],[11,"borrow","","",63,[[]]],[11,"borrow_mut","","",63,[[]]],[11,"type_id","","",63,[[],["typeid",3]]],[11,"to_owned","","",64,[[]]],[11,"clone_into","","",64,[[]]],[11,"from","","",64,[[]]],[11,"into_iter","","",64,[[]]],[11,"try_from","","",64,[[],["result",4]]],[11,"into","","",64,[[]]],[11,"try_into","","",64,[[],["result",4]]],[11,"borrow","","",64,[[]]],[11,"borrow_mut","","",64,[[]]],[11,"type_id","","",64,[[],["typeid",3]]],[11,"from","","",65,[[]]],[11,"into_iter","","",65,[[]]],[11,"try_from","","",65,[[],["result",4]]],[11,"into","","",65,[[]]],[11,"try_into","","",65,[[],["result",4]]],[11,"borrow","","",65,[[]]],[11,"borrow_mut","","",65,[[]]],[11,"type_id","","",65,[[],["typeid",3]]],[11,"to_owned","","",66,[[]]],[11,"clone_into","","",66,[[]]],[11,"from","","",66,[[]]],[11,"into_iter","","",66,[[]]],[11,"try_from","","",66,[[],["result",4]]],[11,"into","","",66,[[]]],[11,"try_into","","",66,[[],["result",4]]],[11,"borrow","","",66,[[]]],[11,"borrow_mut","","",66,[[]]],[11,"type_id","","",66,[[],["typeid",3]]],[11,"from","","",67,[[]]],[11,"into_iter","","",67,[[]]],[11,"try_from","","",67,[[],["result",4]]],[11,"into","","",67,[[]]],[11,"try_into","","",67,[[],["result",4]]],[11,"borrow","","",67,[[]]],[11,"borrow_mut","","",67,[[]]],[11,"type_id","","",67,[[],["typeid",3]]],[11,"from","","",68,[[]]],[11,"try_from","","",68,[[],["result",4]]],[11,"into","","",68,[[]]],[11,"try_into","","",68,[[],["result",4]]],[11,"borrow","","",68,[[]]],[11,"borrow_mut","","",68,[[]]],[11,"type_id","","",68,[[],["typeid",3]]],[11,"from","","",69,[[]]],[11,"try_from","","",69,[[],["result",4]]],[11,"into","","",69,[[]]],[11,"try_into","","",69,[[],["result",4]]],[11,"borrow","","",69,[[]]],[11,"borrow_mut","","",69,[[]]],[11,"type_id","","",69,[[],["typeid",3]]],[11,"from","","",70,[[]]],[11,"into_iter","","",70,[[]]],[11,"try_from","","",70,[[],["result",4]]],[11,"into","","",70,[[]]],[11,"try_into","","",70,[[],["result",4]]],[11,"borrow","","",70,[[]]],[11,"borrow_mut","","",70,[[]]],[11,"type_id","","",70,[[],["typeid",3]]],[11,"from","","",19,[[]]],[11,"try_from","","",19,[[],["result",4]]],[11,"into","","",19,[[]]],[11,"try_into","","",19,[[],["result",4]]],[11,"borrow","","",19,[[]]],[11,"borrow_mut","","",19,[[]]],[11,"type_id","","",19,[[],["typeid",3]]],[11,"to_owned","alloc::collections::btree_set","",71,[[]]],[11,"clone_into","","",71,[[]]],[11,"from","","",71,[[]]],[11,"into_iter","","",71,[[]]],[11,"try_from","","",71,[[],["result",4]]],[11,"into","","",71,[[]]],[11,"try_into","","",71,[[],["result",4]]],[11,"borrow","","",71,[[]]],[11,"borrow_mut","","",71,[[]]],[11,"type_id","","",71,[[],["typeid",3]]],[11,"to_owned","","",72,[[]]],[11,"clone_into","","",72,[[]]],[11,"from","","",72,[[]]],[11,"into_iter","","",72,[[]]],[11,"try_from","","",72,[[],["result",4]]],[11,"into","","",72,[[]]],[11,"try_into","","",72,[[],["result",4]]],[11,"borrow","","",72,[[]]],[11,"borrow_mut","","",72,[[]]],[11,"type_id","","",72,[[],["typeid",3]]],[11,"from","","",73,[[]]],[11,"into_iter","","",73,[[]]],[11,"try_from","","",73,[[],["result",4]]],[11,"into","","",73,[[]]],[11,"try_into","","",73,[[],["result",4]]],[11,"borrow","","",73,[[]]],[11,"borrow_mut","","",73,[[]]],[11,"type_id","","",73,[[],["typeid",3]]],[11,"to_owned","","",74,[[]]],[11,"clone_into","","",74,[[]]],[11,"from","","",74,[[]]],[11,"into_iter","","",74,[[]]],[11,"try_from","","",74,[[],["result",4]]],[11,"into","","",74,[[]]],[11,"try_into","","",74,[[],["result",4]]],[11,"borrow","","",74,[[]]],[11,"borrow_mut","","",74,[[]]],[11,"type_id","","",74,[[],["typeid",3]]],[11,"to_owned","","",75,[[]]],[11,"clone_into","","",75,[[]]],[11,"from","","",75,[[]]],[11,"into_iter","","",75,[[]]],[11,"try_from","","",75,[[],["result",4]]],[11,"into","","",75,[[]]],[11,"try_into","","",75,[[],["result",4]]],[11,"borrow","","",75,[[]]],[11,"borrow_mut","","",75,[[]]],[11,"type_id","","",75,[[],["typeid",3]]],[11,"to_owned","","",76,[[]]],[11,"clone_into","","",76,[[]]],[11,"from","","",76,[[]]],[11,"into_iter","","",76,[[]]],[11,"try_from","","",76,[[],["result",4]]],[11,"into","","",76,[[]]],[11,"try_into","","",76,[[],["result",4]]],[11,"borrow","","",76,[[]]],[11,"borrow_mut","","",76,[[]]],[11,"type_id","","",76,[[],["typeid",3]]],[11,"to_owned","","",77,[[]]],[11,"clone_into","","",77,[[]]],[11,"from","","",77,[[]]],[11,"into_iter","","",77,[[]]],[11,"try_from","","",77,[[],["result",4]]],[11,"into","","",77,[[]]],[11,"try_into","","",77,[[],["result",4]]],[11,"borrow","","",77,[[]]],[11,"borrow_mut","","",77,[[]]],[11,"type_id","","",77,[[],["typeid",3]]],[11,"to_owned","","",78,[[]]],[11,"clone_into","","",78,[[]]],[11,"from","","",78,[[]]],[11,"into_iter","","",78,[[]]],[11,"try_from","","",78,[[],["result",4]]],[11,"into","","",78,[[]]],[11,"try_into","","",78,[[],["result",4]]],[11,"borrow","","",78,[[]]],[11,"borrow_mut","","",78,[[]]],[11,"type_id","","",78,[[],["typeid",3]]],[11,"from","","",79,[[]]],[11,"into_iter","","",79,[[]]],[11,"try_from","","",79,[[],["result",4]]],[11,"into","","",79,[[]]],[11,"try_into","","",79,[[],["result",4]]],[11,"borrow","","",79,[[]]],[11,"borrow_mut","","",79,[[]]],[11,"type_id","","",79,[[],["typeid",3]]],[11,"to_owned","alloc::collections::linked_list","",14,[[]]],[11,"clone_into","","",14,[[]]],[11,"from","","",14,[[]]],[11,"into_iter","","",14,[[]]],[11,"try_from","","",14,[[],["result",4]]],[11,"into","","",14,[[]]],[11,"try_into","","",14,[[],["result",4]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"to_owned","","",80,[[]]],[11,"clone_into","","",80,[[]]],[11,"from","","",80,[[]]],[11,"into_iter","","",80,[[]]],[11,"try_from","","",80,[[],["result",4]]],[11,"into","","",80,[[]]],[11,"try_into","","",80,[[],["result",4]]],[11,"borrow","","",80,[[]]],[11,"borrow_mut","","",80,[[]]],[11,"type_id","","",80,[[],["typeid",3]]],[11,"from","","",15,[[]]],[11,"into_iter","","",15,[[]]],[11,"try_from","","",15,[[],["result",4]]],[11,"into","","",15,[[]]],[11,"try_into","","",15,[[],["result",4]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"to_owned","","",81,[[]]],[11,"clone_into","","",81,[[]]],[11,"from","","",81,[[]]],[11,"into_iter","","",81,[[]]],[11,"try_from","","",81,[[],["result",4]]],[11,"into","","",81,[[]]],[11,"try_into","","",81,[[],["result",4]]],[11,"borrow","","",81,[[]]],[11,"borrow_mut","","",81,[[]]],[11,"type_id","","",81,[[],["typeid",3]]],[11,"to_owned","","",16,[[]]],[11,"clone_into","","",16,[[]]],[11,"from","","",16,[[]]],[11,"try_from","","",16,[[],["result",4]]],[11,"into","","",16,[[]]],[11,"try_into","","",16,[[],["result",4]]],[11,"borrow","","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"from","","",17,[[]]],[11,"try_from","","",17,[[],["result",4]]],[11,"into","","",17,[[]]],[11,"try_into","","",17,[[],["result",4]]],[11,"borrow","","",17,[[]]],[11,"borrow_mut","","",17,[[]]],[11,"type_id","","",17,[[],["typeid",3]]],[11,"from","","",82,[[]]],[11,"into_iter","","",82,[[]]],[11,"try_from","","",82,[[],["result",4]]],[11,"into","","",82,[[]]],[11,"try_into","","",82,[[],["result",4]]],[11,"borrow","","",82,[[]]],[11,"borrow_mut","","",82,[[]]],[11,"type_id","","",82,[[],["typeid",3]]],[11,"from","alloc::collections::vec_deque","",83,[[]]],[11,"into_iter","","",83,[[]]],[11,"try_from","","",83,[[],["result",4]]],[11,"into","","",83,[[]]],[11,"try_into","","",83,[[],["result",4]]],[11,"borrow","","",83,[[]]],[11,"borrow_mut","","",83,[[]]],[11,"type_id","","",83,[[],["typeid",3]]],[11,"to_owned","","",18,[[]]],[11,"clone_into","","",18,[[]]],[11,"from","","",18,[[]]],[11,"into_iter","","",18,[[]]],[11,"try_from","","",18,[[],["result",4]]],[11,"into","","",18,[[]]],[11,"try_into","","",18,[[],["result",4]]],[11,"borrow","","",18,[[]]],[11,"borrow_mut","","",18,[[]]],[11,"type_id","","",18,[[],["typeid",3]]],[11,"to_owned","","",84,[[]]],[11,"clone_into","","",84,[[]]],[11,"from","","",84,[[]]],[11,"into_iter","","",84,[[]]],[11,"try_from","","",84,[[],["result",4]]],[11,"into","","",84,[[]]],[11,"try_into","","",84,[[],["result",4]]],[11,"borrow","","",84,[[]]],[11,"borrow_mut","","",84,[[]]],[11,"type_id","","",84,[[],["typeid",3]]],[11,"from","","",85,[[]]],[11,"into_iter","","",85,[[]]],[11,"try_from","","",85,[[],["result",4]]],[11,"into","","",85,[[]]],[11,"try_into","","",85,[[],["result",4]]],[11,"borrow","","",85,[[]]],[11,"borrow_mut","","",85,[[]]],[11,"type_id","","",85,[[],["typeid",3]]],[11,"to_owned","","",86,[[]]],[11,"clone_into","","",86,[[]]],[11,"from","","",86,[[]]],[11,"into_iter","","",86,[[]]],[11,"try_from","","",86,[[],["result",4]]],[11,"into","","",86,[[]]],[11,"try_into","","",86,[[],["result",4]]],[11,"borrow","","",86,[[]]],[11,"borrow_mut","","",86,[[]]],[11,"type_id","","",86,[[],["typeid",3]]],[11,"from","alloc::fmt","",20,[[]]],[11,"try_from","","",20,[[],["result",4]]],[11,"into","","",20,[[]]],[11,"try_into","","",20,[[],["result",4]]],[11,"borrow","","",20,[[]]],[11,"borrow_mut","","",20,[[]]],[11,"type_id","","",20,[[],["typeid",3]]],[11,"to_owned","","",87,[[]]],[11,"clone_into","","",87,[[]]],[11,"to_string","","",87,[[],["string",3]]],[11,"from","","",87,[[]]],[11,"try_from","","",87,[[],["result",4]]],[11,"into","","",87,[[]]],[11,"try_into","","",87,[[],["result",4]]],[11,"borrow","","",87,[[]]],[11,"borrow_mut","","",87,[[]]],[11,"type_id","","",87,[[],["typeid",3]]],[11,"to_owned","","",88,[[]]],[11,"clone_into","","",88,[[]]],[11,"to_string","","",88,[[],["string",3]]],[11,"from","","",88,[[]]],[11,"try_from","","",88,[[],["result",4]]],[11,"into","","",88,[[]]],[11,"try_into","","",88,[[],["result",4]]],[11,"borrow","","",88,[[]]],[11,"borrow_mut","","",88,[[]]],[11,"type_id","","",88,[[],["typeid",3]]],[11,"from","","",89,[[]]],[11,"try_from","","",89,[[],["result",4]]],[11,"into","","",89,[[]]],[11,"try_into","","",89,[[],["result",4]]],[11,"borrow","","",89,[[]]],[11,"borrow_mut","","",89,[[]]],[11,"type_id","","",89,[[],["typeid",3]]],[11,"from","","",90,[[]]],[11,"try_from","","",90,[[],["result",4]]],[11,"into","","",90,[[]]],[11,"try_into","","",90,[[],["result",4]]],[11,"borrow","","",90,[[]]],[11,"borrow_mut","","",90,[[]]],[11,"type_id","","",90,[[],["typeid",3]]],[11,"from","","",91,[[]]],[11,"try_from","","",91,[[],["result",4]]],[11,"into","","",91,[[]]],[11,"try_into","","",91,[[],["result",4]]],[11,"borrow","","",91,[[]]],[11,"borrow_mut","","",91,[[]]],[11,"type_id","","",91,[[],["typeid",3]]],[11,"from","","",92,[[]]],[11,"try_from","","",92,[[],["result",4]]],[11,"into","","",92,[[]]],[11,"try_into","","",92,[[],["result",4]]],[11,"borrow","","",92,[[]]],[11,"borrow_mut","","",92,[[]]],[11,"type_id","","",92,[[],["typeid",3]]],[11,"from","","",93,[[]]],[11,"try_from","","",93,[[],["result",4]]],[11,"into","","",93,[[]]],[11,"try_into","","",93,[[],["result",4]]],[11,"borrow","","",93,[[]]],[11,"borrow_mut","","",93,[[]]],[11,"type_id","","",93,[[],["typeid",3]]],[11,"from","","",94,[[]]],[11,"try_from","","",94,[[],["result",4]]],[11,"into","","",94,[[]]],[11,"try_into","","",94,[[],["result",4]]],[11,"borrow","","",94,[[]]],[11,"borrow_mut","","",94,[[]]],[11,"type_id","","",94,[[],["typeid",3]]],[11,"to_owned","alloc::rc","",31,[[]]],[11,"clone_into","","",31,[[]]],[11,"to_string","","",31,[[],["string",3]]],[11,"from","","",31,[[]]],[11,"from","","",31,[[]]],[11,"try_from","","",31,[[],["result",4]]],[11,"into","","",31,[[]]],[11,"try_into","","",31,[[],["result",4]]],[11,"borrow","","",31,[[]]],[11,"borrow_mut","","",31,[[]]],[11,"type_id","","",31,[[],["typeid",3]]],[11,"to_owned","","",32,[[]]],[11,"clone_into","","",32,[[]]],[11,"from","","",32,[[]]],[11,"try_from","","",32,[[],["result",4]]],[11,"into","","",32,[[]]],[11,"try_into","","",32,[[],["result",4]]],[11,"borrow","","",32,[[]]],[11,"borrow_mut","","",32,[[]]],[11,"type_id","","",32,[[],["typeid",3]]],[11,"to_owned","alloc::slice","",95,[[]]],[11,"clone_into","","",95,[[]]],[11,"from","","",95,[[]]],[11,"into_iter","","",95,[[]]],[11,"try_from","","",95,[[],["result",4]]],[11,"into","","",95,[[]]],[11,"try_into","","",95,[[],["result",4]]],[11,"borrow","","",95,[[]]],[11,"borrow_mut","","",95,[[]]],[11,"type_id","","",95,[[],["typeid",3]]],[11,"to_owned","","",96,[[]]],[11,"clone_into","","",96,[[]]],[11,"from","","",96,[[]]],[11,"into_iter","","",96,[[]]],[11,"try_from","","",96,[[],["result",4]]],[11,"into","","",96,[[]]],[11,"try_into","","",96,[[],["result",4]]],[11,"borrow","","",96,[[]]],[11,"borrow_mut","","",96,[[]]],[11,"type_id","","",96,[[],["typeid",3]]],[11,"to_owned","","",97,[[]]],[11,"clone_into","","",97,[[]]],[11,"from","","",97,[[]]],[11,"into_iter","","",97,[[]]],[11,"try_from","","",97,[[],["result",4]]],[11,"into","","",97,[[]]],[11,"try_into","","",97,[[],["result",4]]],[11,"borrow","","",97,[[]]],[11,"borrow_mut","","",97,[[]]],[11,"type_id","","",97,[[],["typeid",3]]],[11,"from","","",98,[[]]],[11,"into_iter","","",98,[[]]],[11,"try_from","","",98,[[],["result",4]]],[11,"into","","",98,[[]]],[11,"try_into","","",98,[[],["result",4]]],[11,"borrow","","",98,[[]]],[11,"borrow_mut","","",98,[[]]],[11,"type_id","","",98,[[],["typeid",3]]],[11,"from","","",99,[[]]],[11,"into_iter","","",99,[[]]],[11,"try_from","","",99,[[],["result",4]]],[11,"into","","",99,[[]]],[11,"try_into","","",99,[[],["result",4]]],[11,"borrow","","",99,[[]]],[11,"borrow_mut","","",99,[[]]],[11,"type_id","","",99,[[],["typeid",3]]],[11,"to_owned","","",100,[[]]],[11,"clone_into","","",100,[[]]],[11,"from","","",100,[[]]],[11,"into_iter","","",100,[[]]],[11,"try_from","","",100,[[],["result",4]]],[11,"into","","",100,[[]]],[11,"try_into","","",100,[[],["result",4]]],[11,"borrow","","",100,[[]]],[11,"borrow_mut","","",100,[[]]],[11,"type_id","","",100,[[],["typeid",3]]],[11,"from","","",101,[[]]],[11,"into_iter","","",101,[[]]],[11,"try_from","","",101,[[],["result",4]]],[11,"into","","",101,[[]]],[11,"try_into","","",101,[[],["result",4]]],[11,"borrow","","",101,[[]]],[11,"borrow_mut","","",101,[[]]],[11,"type_id","","",101,[[],["typeid",3]]],[11,"to_owned","","",102,[[]]],[11,"clone_into","","",102,[[]]],[11,"from","","",102,[[]]],[11,"into_iter","","",102,[[]]],[11,"try_from","","",102,[[],["result",4]]],[11,"into","","",102,[[]]],[11,"try_into","","",102,[[],["result",4]]],[11,"borrow","","",102,[[]]],[11,"borrow_mut","","",102,[[]]],[11,"type_id","","",102,[[],["typeid",3]]],[11,"from","","",103,[[]]],[11,"into_iter","","",103,[[]]],[11,"try_from","","",103,[[],["result",4]]],[11,"into","","",103,[[]]],[11,"try_into","","",103,[[],["result",4]]],[11,"borrow","","",103,[[]]],[11,"borrow_mut","","",103,[[]]],[11,"type_id","","",103,[[],["typeid",3]]],[11,"to_owned","","",104,[[]]],[11,"clone_into","","",104,[[]]],[11,"from","","",104,[[]]],[11,"into_iter","","",104,[[]]],[11,"try_from","","",104,[[],["result",4]]],[11,"into","","",104,[[]]],[11,"try_into","","",104,[[],["result",4]]],[11,"borrow","","",104,[[]]],[11,"borrow_mut","","",104,[[]]],[11,"type_id","","",104,[[],["typeid",3]]],[11,"to_owned","","",105,[[]]],[11,"clone_into","","",105,[[]]],[11,"from","","",105,[[]]],[11,"into_iter","","",105,[[]]],[11,"try_from","","",105,[[],["result",4]]],[11,"into","","",105,[[]]],[11,"try_into","","",105,[[],["result",4]]],[11,"borrow","","",105,[[]]],[11,"borrow_mut","","",105,[[]]],[11,"type_id","","",105,[[],["typeid",3]]],[11,"from","","",106,[[]]],[11,"into_iter","","",106,[[]]],[11,"try_from","","",106,[[],["result",4]]],[11,"into","","",106,[[]]],[11,"try_into","","",106,[[],["result",4]]],[11,"borrow","","",106,[[]]],[11,"borrow_mut","","",106,[[]]],[11,"type_id","","",106,[[],["typeid",3]]],[11,"from","","",107,[[]]],[11,"into_iter","","",107,[[]]],[11,"try_from","","",107,[[],["result",4]]],[11,"into","","",107,[[]]],[11,"try_into","","",107,[[],["result",4]]],[11,"borrow","","",107,[[]]],[11,"borrow_mut","","",107,[[]]],[11,"type_id","","",107,[[],["typeid",3]]],[11,"to_owned","","",108,[[]]],[11,"clone_into","","",108,[[]]],[11,"from","","",108,[[]]],[11,"into_iter","","",108,[[]]],[11,"try_from","","",108,[[],["result",4]]],[11,"into","","",108,[[]]],[11,"try_into","","",108,[[],["result",4]]],[11,"borrow","","",108,[[]]],[11,"borrow_mut","","",108,[[]]],[11,"type_id","","",108,[[],["typeid",3]]],[11,"from","","",109,[[]]],[11,"into_iter","","",109,[[]]],[11,"try_from","","",109,[[],["result",4]]],[11,"into","","",109,[[]]],[11,"try_into","","",109,[[],["result",4]]],[11,"borrow","","",109,[[]]],[11,"borrow_mut","","",109,[[]]],[11,"type_id","","",109,[[],["typeid",3]]],[11,"from","","",110,[[]]],[11,"into_iter","","",110,[[]]],[11,"try_from","","",110,[[],["result",4]]],[11,"into","","",110,[[]]],[11,"try_into","","",110,[[],["result",4]]],[11,"borrow","","",110,[[]]],[11,"borrow_mut","","",110,[[]]],[11,"type_id","","",110,[[],["typeid",3]]],[11,"from","","",111,[[]]],[11,"into_iter","","",111,[[]]],[11,"try_from","","",111,[[],["result",4]]],[11,"into","","",111,[[]]],[11,"try_into","","",111,[[],["result",4]]],[11,"borrow","","",111,[[]]],[11,"borrow_mut","","",111,[[]]],[11,"type_id","","",111,[[],["typeid",3]]],[11,"from","","",112,[[]]],[11,"into_iter","","",112,[[]]],[11,"try_from","","",112,[[],["result",4]]],[11,"into","","",112,[[]]],[11,"try_into","","",112,[[],["result",4]]],[11,"borrow","","",112,[[]]],[11,"borrow_mut","","",112,[[]]],[11,"type_id","","",112,[[],["typeid",3]]],[11,"from","","",113,[[]]],[11,"into_iter","","",113,[[]]],[11,"try_from","","",113,[[],["result",4]]],[11,"into","","",113,[[]]],[11,"try_into","","",113,[[],["result",4]]],[11,"borrow","","",113,[[]]],[11,"borrow_mut","","",113,[[]]],[11,"type_id","","",113,[[],["typeid",3]]],[11,"to_owned","alloc::str::pattern","",37,[[]]],[11,"clone_into","","",37,[[]]],[11,"from","","",37,[[]]],[11,"try_from","","",37,[[],["result",4]]],[11,"into","","",37,[[]]],[11,"try_into","","",37,[[],["result",4]]],[11,"borrow","","",37,[[]]],[11,"borrow_mut","","",37,[[]]],[11,"type_id","","",37,[[],["typeid",3]]],[11,"to_owned","","",114,[[]]],[11,"clone_into","","",114,[[]]],[11,"from","","",114,[[]]],[11,"try_from","","",114,[[],["result",4]]],[11,"into","","",114,[[]]],[11,"try_into","","",114,[[],["result",4]]],[11,"borrow","","",114,[[]]],[11,"borrow_mut","","",114,[[]]],[11,"type_id","","",114,[[],["typeid",3]]],[11,"to_owned","","",115,[[]]],[11,"clone_into","","",115,[[]]],[11,"from","","",115,[[]]],[11,"try_from","","",115,[[],["result",4]]],[11,"into","","",115,[[]]],[11,"try_into","","",115,[[],["result",4]]],[11,"borrow","","",115,[[]]],[11,"borrow_mut","","",115,[[]]],[11,"type_id","","",115,[[],["typeid",3]]],[11,"to_owned","","",116,[[]]],[11,"clone_into","","",116,[[]]],[11,"from","","",116,[[]]],[11,"try_from","","",116,[[],["result",4]]],[11,"into","","",116,[[]]],[11,"try_into","","",116,[[],["result",4]]],[11,"borrow","","",116,[[]]],[11,"borrow_mut","","",116,[[]]],[11,"type_id","","",116,[[],["typeid",3]]],[11,"to_owned","","",117,[[]]],[11,"clone_into","","",117,[[]]],[11,"from","","",117,[[]]],[11,"try_from","","",117,[[],["result",4]]],[11,"into","","",117,[[]]],[11,"try_into","","",117,[[],["result",4]]],[11,"borrow","","",117,[[]]],[11,"borrow_mut","","",117,[[]]],[11,"type_id","","",117,[[],["typeid",3]]],[11,"to_owned","alloc::str","",118,[[]]],[11,"clone_into","","",118,[[]]],[11,"from","","",118,[[]]],[11,"into_iter","","",118,[[]]],[11,"try_from","","",118,[[],["result",4]]],[11,"into","","",118,[[]]],[11,"try_into","","",118,[[],["result",4]]],[11,"borrow","","",118,[[]]],[11,"borrow_mut","","",118,[[]]],[11,"type_id","","",118,[[],["typeid",3]]],[11,"to_owned","","",119,[[]]],[11,"clone_into","","",119,[[]]],[11,"from","","",119,[[]]],[11,"into_iter","","",119,[[]]],[11,"try_from","","",119,[[],["result",4]]],[11,"into","","",119,[[]]],[11,"try_into","","",119,[[],["result",4]]],[11,"borrow","","",119,[[]]],[11,"borrow_mut","","",119,[[]]],[11,"type_id","","",119,[[],["typeid",3]]],[11,"to_owned","","",120,[[]]],[11,"clone_into","","",120,[[]]],[11,"from","","",120,[[]]],[11,"into_iter","","",120,[[]]],[11,"try_from","","",120,[[],["result",4]]],[11,"into","","",120,[[]]],[11,"try_into","","",120,[[],["result",4]]],[11,"borrow","","",120,[[]]],[11,"borrow_mut","","",120,[[]]],[11,"type_id","","",120,[[],["typeid",3]]],[11,"to_owned","","",121,[[]]],[11,"clone_into","","",121,[[]]],[11,"from","","",121,[[]]],[11,"into_iter","","",121,[[]]],[11,"try_from","","",121,[[],["result",4]]],[11,"into","","",121,[[]]],[11,"try_into","","",121,[[],["result",4]]],[11,"borrow","","",121,[[]]],[11,"borrow_mut","","",121,[[]]],[11,"type_id","","",121,[[],["typeid",3]]],[11,"to_owned","","",122,[[]]],[11,"clone_into","","",122,[[]]],[11,"from","","",122,[[]]],[11,"into_iter","","",122,[[]]],[11,"try_from","","",122,[[],["result",4]]],[11,"into","","",122,[[]]],[11,"try_into","","",122,[[],["result",4]]],[11,"borrow","","",122,[[]]],[11,"borrow_mut","","",122,[[]]],[11,"type_id","","",122,[[],["typeid",3]]],[11,"to_owned","","",123,[[]]],[11,"clone_into","","",123,[[]]],[11,"from","","",123,[[]]],[11,"into_iter","","",123,[[]]],[11,"try_from","","",123,[[],["result",4]]],[11,"into","","",123,[[]]],[11,"try_into","","",123,[[],["result",4]]],[11,"borrow","","",123,[[]]],[11,"borrow_mut","","",123,[[]]],[11,"type_id","","",123,[[],["typeid",3]]],[11,"to_owned","","",124,[[]]],[11,"clone_into","","",124,[[]]],[11,"to_string","","",124,[[],["string",3]]],[11,"from","","",124,[[]]],[11,"try_from","","",124,[[],["result",4]]],[11,"into","","",124,[[]]],[11,"try_into","","",124,[[],["result",4]]],[11,"borrow","","",124,[[]]],[11,"borrow_mut","","",124,[[]]],[11,"type_id","","",124,[[],["typeid",3]]],[11,"to_owned","","",125,[[]]],[11,"clone_into","","",125,[[]]],[11,"to_string","","",125,[[],["string",3]]],[11,"from","","",125,[[]]],[11,"into_iter","","",125,[[]]],[11,"try_from","","",125,[[],["result",4]]],[11,"into","","",125,[[]]],[11,"try_into","","",125,[[],["result",4]]],[11,"borrow","","",125,[[]]],[11,"borrow_mut","","",125,[[]]],[11,"type_id","","",125,[[],["typeid",3]]],[11,"to_owned","","",126,[[]]],[11,"clone_into","","",126,[[]]],[11,"to_string","","",126,[[],["string",3]]],[11,"from","","",126,[[]]],[11,"into_iter","","",126,[[]]],[11,"try_from","","",126,[[],["result",4]]],[11,"into","","",126,[[]]],[11,"try_into","","",126,[[],["result",4]]],[11,"borrow","","",126,[[]]],[11,"borrow_mut","","",126,[[]]],[11,"type_id","","",126,[[],["typeid",3]]],[11,"to_owned","","",127,[[]]],[11,"clone_into","","",127,[[]]],[11,"to_string","","",127,[[],["string",3]]],[11,"from","","",127,[[]]],[11,"into_iter","","",127,[[]]],[11,"try_from","","",127,[[],["result",4]]],[11,"into","","",127,[[]]],[11,"try_into","","",127,[[],["result",4]]],[11,"borrow","","",127,[[]]],[11,"borrow_mut","","",127,[[]]],[11,"type_id","","",127,[[],["typeid",3]]],[11,"to_owned","","",128,[[]]],[11,"clone_into","","",128,[[]]],[11,"to_string","","",128,[[],["string",3]]],[11,"from","","",128,[[]]],[11,"try_from","","",128,[[],["result",4]]],[11,"into","","",128,[[]]],[11,"try_into","","",128,[[],["result",4]]],[11,"borrow","","",128,[[]]],[11,"borrow_mut","","",128,[[]]],[11,"type_id","","",128,[[],["typeid",3]]],[11,"to_owned","","",129,[[]]],[11,"clone_into","","",129,[[]]],[11,"from","","",129,[[]]],[11,"into_iter","","",129,[[]]],[11,"try_from","","",129,[[],["result",4]]],[11,"into","","",129,[[]]],[11,"try_into","","",129,[[],["result",4]]],[11,"borrow","","",129,[[]]],[11,"borrow_mut","","",129,[[]]],[11,"type_id","","",129,[[],["typeid",3]]],[11,"to_owned","","",130,[[]]],[11,"clone_into","","",130,[[]]],[11,"from","","",130,[[]]],[11,"into_iter","","",130,[[]]],[11,"try_from","","",130,[[],["result",4]]],[11,"into","","",130,[[]]],[11,"try_into","","",130,[[],["result",4]]],[11,"borrow","","",130,[[]]],[11,"borrow_mut","","",130,[[]]],[11,"type_id","","",130,[[],["typeid",3]]],[11,"to_owned","","",131,[[]]],[11,"clone_into","","",131,[[]]],[11,"from","","",131,[[]]],[11,"into_iter","","",131,[[]]],[11,"try_from","","",131,[[],["result",4]]],[11,"into","","",131,[[]]],[11,"try_into","","",131,[[],["result",4]]],[11,"borrow","","",131,[[]]],[11,"borrow_mut","","",131,[[]]],[11,"type_id","","",131,[[],["typeid",3]]],[11,"to_owned","","",132,[[]]],[11,"clone_into","","",132,[[]]],[11,"from","","",132,[[]]],[11,"into_iter","","",132,[[]]],[11,"try_from","","",132,[[],["result",4]]],[11,"into","","",132,[[]]],[11,"try_into","","",132,[[],["result",4]]],[11,"borrow","","",132,[[]]],[11,"borrow_mut","","",132,[[]]],[11,"type_id","","",132,[[],["typeid",3]]],[11,"to_owned","","",133,[[]]],[11,"clone_into","","",133,[[]]],[11,"from","","",133,[[]]],[11,"into_iter","","",133,[[]]],[11,"try_from","","",133,[[],["result",4]]],[11,"into","","",133,[[]]],[11,"try_into","","",133,[[],["result",4]]],[11,"borrow","","",133,[[]]],[11,"borrow_mut","","",133,[[]]],[11,"type_id","","",133,[[],["typeid",3]]],[11,"to_owned","","",134,[[]]],[11,"clone_into","","",134,[[]]],[11,"from","","",134,[[]]],[11,"into_iter","","",134,[[]]],[11,"try_from","","",134,[[],["result",4]]],[11,"into","","",134,[[]]],[11,"try_into","","",134,[[],["result",4]]],[11,"borrow","","",134,[[]]],[11,"borrow_mut","","",134,[[]]],[11,"type_id","","",134,[[],["typeid",3]]],[11,"to_owned","","",135,[[]]],[11,"clone_into","","",135,[[]]],[11,"from","","",135,[[]]],[11,"into_iter","","",135,[[]]],[11,"try_from","","",135,[[],["result",4]]],[11,"into","","",135,[[]]],[11,"try_into","","",135,[[],["result",4]]],[11,"borrow","","",135,[[]]],[11,"borrow_mut","","",135,[[]]],[11,"type_id","","",135,[[],["typeid",3]]],[11,"to_owned","","",136,[[]]],[11,"clone_into","","",136,[[]]],[11,"from","","",136,[[]]],[11,"into_iter","","",136,[[]]],[11,"try_from","","",136,[[],["result",4]]],[11,"into","","",136,[[]]],[11,"try_into","","",136,[[],["result",4]]],[11,"borrow","","",136,[[]]],[11,"borrow_mut","","",136,[[]]],[11,"type_id","","",136,[[],["typeid",3]]],[11,"to_owned","","",137,[[]]],[11,"clone_into","","",137,[[]]],[11,"from","","",137,[[]]],[11,"into_iter","","",137,[[]]],[11,"try_from","","",137,[[],["result",4]]],[11,"into","","",137,[[]]],[11,"try_into","","",137,[[],["result",4]]],[11,"borrow","","",137,[[]]],[11,"borrow_mut","","",137,[[]]],[11,"type_id","","",137,[[],["typeid",3]]],[11,"to_owned","","",138,[[]]],[11,"clone_into","","",138,[[]]],[11,"from","","",138,[[]]],[11,"into_iter","","",138,[[]]],[11,"try_from","","",138,[[],["result",4]]],[11,"into","","",138,[[]]],[11,"try_into","","",138,[[],["result",4]]],[11,"borrow","","",138,[[]]],[11,"borrow_mut","","",138,[[]]],[11,"type_id","","",138,[[],["typeid",3]]],[11,"to_owned","","",139,[[]]],[11,"clone_into","","",139,[[]]],[11,"from","","",139,[[]]],[11,"into_iter","","",139,[[]]],[11,"try_from","","",139,[[],["result",4]]],[11,"into","","",139,[[]]],[11,"try_into","","",139,[[],["result",4]]],[11,"borrow","","",139,[[]]],[11,"borrow_mut","","",139,[[]]],[11,"type_id","","",139,[[],["typeid",3]]],[11,"to_owned","","",140,[[]]],[11,"clone_into","","",140,[[]]],[11,"from","","",140,[[]]],[11,"into_iter","","",140,[[]]],[11,"try_from","","",140,[[],["result",4]]],[11,"into","","",140,[[]]],[11,"try_into","","",140,[[],["result",4]]],[11,"borrow","","",140,[[]]],[11,"borrow_mut","","",140,[[]]],[11,"type_id","","",140,[[],["typeid",3]]],[11,"to_owned","alloc::string","",42,[[]]],[11,"clone_into","","",42,[[]]],[11,"to_string","","",42,[[],["string",3]]],[11,"from","","",42,[[]]],[11,"try_from","","",42,[[],["result",4]]],[11,"into","","",42,[[]]],[11,"try_into","","",42,[[],["result",4]]],[11,"borrow","","",42,[[]]],[11,"borrow_mut","","",42,[[]]],[11,"type_id","","",42,[[],["typeid",3]]],[11,"to_owned","","",43,[[]]],[11,"clone_into","","",43,[[]]],[11,"to_string","","",43,[[],["string",3]]],[11,"from","","",43,[[]]],[11,"try_from","","",43,[[],["result",4]]],[11,"into","","",43,[[]]],[11,"try_into","","",43,[[],["result",4]]],[11,"borrow","","",43,[[]]],[11,"borrow_mut","","",43,[[]]],[11,"type_id","","",43,[[],["typeid",3]]],[11,"to_string","","",141,[[],["string",3]]],[11,"from","","",141,[[]]],[11,"try_from","","",141,[[],["result",4]]],[11,"into","","",141,[[]]],[11,"try_into","","",141,[[],["result",4]]],[11,"borrow","","",141,[[]]],[11,"borrow_mut","","",141,[[]]],[11,"type_id","","",141,[[],["typeid",3]]],[11,"from","","",142,[[]]],[11,"into_iter","","",142,[[]]],[11,"try_from","","",142,[[],["result",4]]],[11,"into","","",142,[[]]],[11,"try_into","","",142,[[],["result",4]]],[11,"borrow","","",142,[[]]],[11,"borrow_mut","","",142,[[]]],[11,"type_id","","",142,[[],["typeid",3]]],[11,"to_owned","alloc::sync","",44,[[]]],[11,"clone_into","","",44,[[]]],[11,"to_string","","",44,[[],["string",3]]],[11,"from","","",44,[[]]],[11,"from","","",44,[[]]],[11,"try_from","","",44,[[],["result",4]]],[11,"into","","",44,[[]]],[11,"try_into","","",44,[[],["result",4]]],[11,"borrow","","",44,[[]]],[11,"borrow_mut","","",44,[[]]],[11,"type_id","","",44,[[],["typeid",3]]],[11,"to_owned","","",45,[[]]],[11,"clone_into","","",45,[[]]],[11,"from","","",45,[[]]],[11,"try_from","","",45,[[],["result",4]]],[11,"into","","",45,[[]]],[11,"try_into","","",45,[[],["result",4]]],[11,"borrow","","",45,[[]]],[11,"borrow_mut","","",45,[[]]],[11,"type_id","","",45,[[],["typeid",3]]],[11,"to_owned","alloc::vec","",47,[[]]],[11,"clone_into","","",47,[[]]],[11,"from","","",47,[[]]],[11,"into_iter","","",47,[[]]],[11,"try_from","","",47,[[],["result",4]]],[11,"into","","",47,[[]]],[11,"try_into","","",47,[[],["result",4]]],[11,"borrow","","",47,[[]]],[11,"borrow_mut","","",47,[[]]],[11,"type_id","","",47,[[],["typeid",3]]],[11,"to_owned","","",48,[[]]],[11,"clone_into","","",48,[[]]],[11,"from","","",48,[[]]],[11,"into_iter","","",48,[[]]],[11,"try_from","","",48,[[],["result",4]]],[11,"into","","",48,[[]]],[11,"try_into","","",48,[[],["result",4]]],[11,"borrow","","",48,[[]]],[11,"borrow_mut","","",48,[[]]],[11,"type_id","","",48,[[],["typeid",3]]],[11,"from","","",49,[[]]],[11,"into_iter","","",49,[[]]],[11,"try_from","","",49,[[],["result",4]]],[11,"into","","",49,[[]]],[11,"try_into","","",49,[[],["result",4]]],[11,"borrow","","",49,[[]]],[11,"borrow_mut","","",49,[[]]],[11,"type_id","","",49,[[],["typeid",3]]],[11,"from","","",143,[[]]],[11,"into_iter","","",143,[[]]],[11,"try_from","","",143,[[],["result",4]]],[11,"into","","",143,[[]]],[11,"try_into","","",143,[[],["result",4]]],[11,"borrow","","",143,[[]]],[11,"borrow_mut","","",143,[[]]],[11,"type_id","","",143,[[],["typeid",3]]],[11,"from","","",144,[[]]],[11,"into_iter","","",144,[[]]],[11,"try_from","","",144,[[],["result",4]]],[11,"into","","",144,[[]]],[11,"try_into","","",144,[[],["result",4]]],[11,"borrow","","",144,[[]]],[11,"borrow_mut","","",144,[[]]],[11,"type_id","","",144,[[],["typeid",3]]],[11,"write_str","alloc::fmt","",94,[[],[["error",3],["result",4]]]],[11,"write_char","","",94,[[],[["error",3],["result",4]]]],[11,"write_fmt","","",94,[[["arguments",3]],[["error",3],["result",4]]]],[11,"cmp","","",87,[[["error",3]],["ordering",4]]],[11,"hash","","",87,[[]]],[11,"next_back","alloc::str","",122,[[],["option",4]]],[11,"next_back","alloc::slice","",107,[[],["option",4]]],[11,"nth_back","","",107,[[],["option",4]]],[11,"next_back","","",100,[[],["option",4]]],[11,"next_back","","",97,[[],["option",4]]],[11,"nth_back","","",97,[[],["option",4]]],[11,"next_back","","",103,[[],["option",4]]],[11,"nth_back","","",103,[[],["option",4]]],[11,"next_back","","",95,[[],["option",4]]],[11,"nth_back","","",95,[[],["option",4]]],[11,"next_back","alloc::str","",129,[[],["option",4]]],[11,"next_back","","",132,[[],["option",4]]],[11,"next_back","","",139,[[],["option",4]]],[11,"next_back","","",119,[[],["option",4]]],[11,"next_back","","",134,[[],["option",4]]],[11,"next_back","","",140,[[],["option",4]]],[11,"next_back","alloc::slice","",104,[[],["option",4]]],[11,"nth_back","","",104,[[],["option",4]]],[11,"next_back","alloc::str","",130,[[],["option",4]]],[11,"next_back","alloc::slice","",102,[[],["option",4]]],[11,"nth_back","","",102,[[],["option",4]]],[11,"next_back","alloc::str","",123,[[],["option",4]]],[11,"next_back","alloc::slice","",101,[[],["option",4]]],[11,"next_back","alloc::str","",120,[[],["option",4]]],[11,"next_back","","",131,[[],["option",4]]],[11,"next_back","","",136,[[],["option",4]]],[11,"next_back","alloc::slice","",108,[[],["option",4]]],[11,"next_back","alloc::str","",135,[[],["option",4]]],[11,"next_back","alloc::slice","",109,[[],["option",4]]],[11,"next_back","","",105,[[],["option",4]]],[11,"nth_back","","",105,[[],["option",4]]],[11,"next_back","alloc::str","",121,[[],["option",4]]],[11,"nth_back","","",121,[[],["option",4]]],[11,"rfind","","",121,[[],["option",4]]],[11,"next_back","alloc::slice","",106,[[],["option",4]]],[11,"nth_back","","",106,[[],["option",4]]],[11,"next_back","","",98,[[],["option",4]]],[11,"nth_back","","",98,[[],["option",4]]],[11,"next_back","alloc::str","",133,[[],["option",4]]],[11,"next_back","alloc::slice","",96,[[],["option",4]]],[11,"nth_back","","",96,[[],["option",4]]],[11,"next_back","","",99,[[],["option",4]]],[11,"nth_back","","",99,[[],["option",4]]],[11,"haystack","alloc::str::pattern","",115,[[]]],[11,"next","","",115,[[],["searchstep",4]]],[11,"next_match","","",115,[[],["option",4]]],[11,"next_reject","","",115,[[],["option",4]]],[11,"haystack","","",114,[[]]],[11,"next","","",114,[[],["searchstep",4]]],[11,"next_match","","",114,[[],["option",4]]],[11,"haystack","","",117,[[]]],[11,"next","","",117,[[],["searchstep",4]]],[11,"next_match","","",117,[[],["option",4]]],[11,"haystack","","",116,[[]]],[11,"next","","",116,[[],["searchstep",4]]],[11,"next_match","","",116,[[],["option",4]]],[11,"next_reject","","",116,[[],["option",4]]],[11,"partial_cmp","alloc::fmt","",87,[[["error",3]],[["ordering",4],["option",4]]]],[11,"clone","alloc::str","",136,[[],["split",3]]],[11,"clone","alloc::alloc","",2,[[],["reallocplacement",4]]],[11,"clone","alloc::str::pattern","",37,[[],["searchstep",4]]],[11,"clone","alloc::slice","",100,[[],["split",3]]],[11,"clone","alloc::alloc","",51,[[],["layout",3]]],[11,"clone","alloc::fmt","",87,[[],["error",3]]],[11,"clone","alloc::slice","",95,[[],["chunks",3]]],[11,"clone","alloc::str","",125,[[],["escapedebug",3]]],[11,"clone","","",138,[[],["splitn",3]]],[11,"clone","","",122,[[],["charindices",3]]],[11,"clone","","",131,[[],["matchindices",3]]],[11,"clone","","",129,[[],["lines",3]]],[11,"clone","","",135,[[],["rsplit",3]]],[11,"clone","","",120,[[],["splitwhitespace",3]]],[11,"clone","","",134,[[],["rmatches",3]]],[11,"clone","alloc::str::pattern","",114,[[],["charsearcher",3]]],[11,"clone","alloc::str","",127,[[],["escapeunicode",3]]],[11,"clone","","",132,[[],["rmatchindices",3]]],[11,"clone","","",128,[[],["utf8error",3]]],[11,"clone","alloc::slice","",108,[[],["rsplit",3]]],[11,"clone","alloc::str","",118,[[],["encodeutf16",3]]],[11,"clone","alloc::slice","",105,[[],["rchunksexact",3]]],[11,"clone","","",104,[[],["rchunks",3]]],[11,"clone","alloc::alloc","",1,[[],["memoryblock",3]]],[11,"clone","alloc::str","",130,[[],["linesany",3]]],[11,"clone","","",119,[[],["splitasciiwhitespace",3]]],[11,"clone","alloc::slice","",97,[[],["chunksexact",3]]],[11,"clone","","",96,[[],["windows",3]]],[11,"clone","alloc::str","",124,[[],["parseboolerror",3]]],[11,"clone","alloc::alloc","",50,[[],["allocerr",3]]],[11,"clone","alloc::str","",140,[[],["splitterminator",3]]],[11,"clone","alloc::fmt","",88,[[],["arguments",3]]],[11,"clone","alloc::str","",123,[[],["chars",3]]],[11,"clone","","",126,[[],["escapedefault",3]]],[11,"clone","alloc::alloc","",0,[[],["allocinit",4]]],[11,"clone","alloc::str::pattern","",115,[[],["charslicesearcher",3]]],[11,"clone","alloc::str","",133,[[],["matches",3]]],[11,"clone","alloc::str::pattern","",116,[[],["charpredicatesearcher",3]]],[11,"clone","alloc::alloc","",52,[[],["layouterr",3]]],[11,"clone","alloc::str","",137,[[],["rsplitn",3]]],[11,"clone","","",121,[[],["bytes",3]]],[11,"clone","","",139,[[],["rsplitterminator",3]]],[11,"clone","alloc::slice","",102,[[],["iter",3]]],[11,"clone","alloc::str::pattern","",117,[[],["strsearcher",3]]],[11,"fmt","alloc::alloc","",50,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",88,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",87,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",127,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",125,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",52,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",128,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",124,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",126,[[["formatter",3]],[["error",3],["result",4]]]],[11,"len","alloc::slice","",102,[[]]],[11,"is_empty","","",102,[[]]],[11,"len","","",103,[[]]],[11,"is_empty","","",103,[[]]],[11,"is_empty","","",97,[[]]],[11,"is_empty","","",105,[[]]],[11,"is_empty","","",106,[[]]],[11,"is_empty","","",98,[[]]],[11,"len","alloc::str","",121,[[]]],[11,"is_empty","","",121,[[]]],[11,"fmt","alloc::slice","",99,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",105,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",132,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",52,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",87,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",110,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",101,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",138,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",116,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",118,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",136,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",127,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",51,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",121,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",122,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",95,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",103,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",117,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",37,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",1,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",50,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",126,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",106,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",20,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",112,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",115,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",108,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",135,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",119,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::fmt","",88,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",96,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",129,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",125,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",139,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str::pattern","",114,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",100,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",123,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",140,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",0,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",128,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::alloc","",2,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",107,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",120,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",98,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",113,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",134,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",102,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",133,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",137,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",131,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",109,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",124,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",97,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::str","",130,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::slice","",111,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","","",104,[[["formatter",3]],[["error",3],["result",4]]]],[11,"default","alloc::fmt","",87,[[],["error",3]]],[11,"as_ref","alloc::slice","",102,[[]]],[11,"next","","",95,[[],["option",4]]],[11,"size_hint","","",95,[[]]],[11,"count","","",95,[[]]],[11,"nth","","",95,[[],["option",4]]],[11,"last","","",95,[[],["option",4]]],[11,"next","alloc::str","",123,[[],["option",4]]],[11,"count","","",123,[[]]],[11,"size_hint","","",123,[[]]],[11,"last","","",123,[[],["option",4]]],[11,"next","alloc::slice","",103,[[],["option",4]]],[11,"size_hint","","",103,[[]]],[11,"count","","",103,[[]]],[11,"nth","","",103,[[],["option",4]]],[11,"last","","",103,[[],["option",4]]],[11,"for_each","","",103,[[]]],[11,"all","","",103,[[]]],[11,"any","","",103,[[]]],[11,"find","","",103,[[],["option",4]]],[11,"find_map","","",103,[[],["option",4]]],[11,"position","","",103,[[],["option",4]]],[11,"rposition","","",103,[[],["option",4]]],[11,"next","","",112,[[],["option",4]]],[11,"size_hint","","",112,[[]]],[11,"next","","",100,[[],["option",4]]],[11,"size_hint","","",100,[[]]],[11,"next","alloc::str","",120,[[],["option",4]]],[11,"size_hint","","",120,[[]]],[11,"last","","",120,[[],["option",4]]],[11,"next","","",126,[[],["option",4]]],[11,"size_hint","","",126,[[]]],[11,"try_fold","","",126,[[]]],[11,"fold","","",126,[[]]],[11,"next","","",129,[[],["option",4]]],[11,"size_hint","","",129,[[]]],[11,"last","","",129,[[],["option",4]]],[11,"next","alloc::slice","",97,[[],["option",4]]],[11,"size_hint","","",97,[[]]],[11,"count","","",97,[[]]],[11,"nth","","",97,[[],["option",4]]],[11,"last","","",97,[[],["option",4]]],[11,"next","alloc::str","",127,[[],["option",4]]],[11,"size_hint","","",127,[[]]],[11,"try_fold","","",127,[[]]],[11,"fold","","",127,[[]]],[11,"next","","",137,[[],["option",4]]],[11,"next","","",133,[[],["option",4]]],[11,"next","","",139,[[],["option",4]]],[11,"next","","",122,[[],["option",4]]],[11,"count","","",122,[[]]],[11,"size_hint","","",122,[[]]],[11,"last","","",122,[[],["option",4]]],[11,"next","","",140,[[],["option",4]]],[11,"next","alloc::slice","",106,[[],["option",4]]],[11,"size_hint","","",106,[[]]],[11,"count","","",106,[[]]],[11,"nth","","",106,[[],["option",4]]],[11,"last","","",106,[[],["option",4]]],[11,"next","","",101,[[],["option",4]]],[11,"size_hint","","",101,[[]]],[11,"next","","",111,[[],["option",4]]],[11,"size_hint","","",111,[[]]],[11,"next","alloc::str","",119,[[],["option",4]]],[11,"size_hint","","",119,[[]]],[11,"last","","",119,[[],["option",4]]],[11,"next","alloc::slice","",105,[[],["option",4]]],[11,"size_hint","","",105,[[]]],[11,"count","","",105,[[]]],[11,"nth","","",105,[[],["option",4]]],[11,"last","","",105,[[],["option",4]]],[11,"next","","",113,[[],["option",4]]],[11,"size_hint","","",113,[[]]],[11,"next","alloc::str","",125,[[],["option",4]]],[11,"size_hint","","",125,[[]]],[11,"try_fold","","",125,[[]]],[11,"fold","","",125,[[]]],[11,"next","alloc::slice","",96,[[],["option",4]]],[11,"size_hint","","",96,[[]]],[11,"count","","",96,[[]]],[11,"nth","","",96,[[],["option",4]]],[11,"last","","",96,[[],["option",4]]],[11,"next","alloc::str","",132,[[],["option",4]]],[11,"next","","",121,[[],["option",4]]],[11,"size_hint","","",121,[[]]],[11,"count","","",121,[[]]],[11,"last","","",121,[[],["option",4]]],[11,"nth","","",121,[[],["option",4]]],[11,"all","","",121,[[]]],[11,"any","","",121,[[]]],[11,"find","","",121,[[],["option",4]]],[11,"position","","",121,[[],["option",4]]],[11,"rposition","","",121,[[],["option",4]]],[11,"next","alloc::slice","",107,[[],["option",4]]],[11,"size_hint","","",107,[[]]],[11,"count","","",107,[[]]],[11,"nth","","",107,[[],["option",4]]],[11,"last","","",107,[[],["option",4]]],[11,"next","","",102,[[],["option",4]]],[11,"size_hint","","",102,[[]]],[11,"count","","",102,[[]]],[11,"nth","","",102,[[],["option",4]]],[11,"last","","",102,[[],["option",4]]],[11,"for_each","","",102,[[]]],[11,"all","","",102,[[]]],[11,"any","","",102,[[]]],[11,"find","","",102,[[],["option",4]]],[11,"find_map","","",102,[[],["option",4]]],[11,"position","","",102,[[],["option",4]]],[11,"rposition","","",102,[[],["option",4]]],[11,"is_sorted_by","","",102,[[]]],[11,"next","alloc::str","",138,[[],["option",4]]],[11,"next","alloc::slice","",104,[[],["option",4]]],[11,"size_hint","","",104,[[]]],[11,"count","","",104,[[]]],[11,"nth","","",104,[[],["option",4]]],[11,"last","","",104,[[],["option",4]]],[11,"next","alloc::str","",136,[[],["option",4]]],[11,"next","","",131,[[],["option",4]]],[11,"next","","",130,[[],["option",4]]],[11,"size_hint","","",130,[[]]],[11,"next","alloc::slice","",109,[[],["option",4]]],[11,"size_hint","","",109,[[]]],[11,"next","","",98,[[],["option",4]]],[11,"size_hint","","",98,[[]]],[11,"count","","",98,[[]]],[11,"nth","","",98,[[],["option",4]]],[11,"last","","",98,[[],["option",4]]],[11,"next","","",110,[[],["option",4]]],[11,"size_hint","","",110,[[]]],[11,"next","alloc::str","",134,[[],["option",4]]],[11,"next","alloc::slice","",108,[[],["option",4]]],[11,"size_hint","","",108,[[]]],[11,"next","","",99,[[],["option",4]]],[11,"size_hint","","",99,[[]]],[11,"count","","",99,[[]]],[11,"nth","","",99,[[],["option",4]]],[11,"last","","",99,[[],["option",4]]],[11,"next","alloc::str","",135,[[],["option",4]]],[11,"next","","",118,[[],["option",4]]],[11,"size_hint","","",118,[[]]],[11,"next_back","alloc::str::pattern","",116,[[],["searchstep",4]]],[11,"next_match_back","","",116,[[],["option",4]]],[11,"next_reject_back","","",116,[[],["option",4]]],[11,"next_back","","",117,[[],["searchstep",4]]],[11,"next_match_back","","",117,[[],["option",4]]],[11,"next_back","","",115,[[],["searchstep",4]]],[11,"next_match_back","","",115,[[],["option",4]]],[11,"next_reject_back","","",115,[[],["option",4]]],[11,"next_back","","",114,[[],["searchstep",4]]],[11,"next_match_back","","",114,[[],["option",4]]],[11,"eq","alloc::alloc","",50,[[["allocerr",3]]]],[11,"eq","","",0,[[["allocinit",4]]]],[11,"eq","alloc::str::pattern","",37,[[["searchstep",4]]]],[11,"ne","","",37,[[["searchstep",4]]]],[11,"eq","alloc::alloc","",51,[[["layout",3]]]],[11,"ne","","",51,[[["layout",3]]]],[11,"eq","","",52,[[["layouterr",3]]]],[11,"ne","","",52,[[["layouterr",3]]]],[11,"eq","alloc::str","",128,[[["utf8error",3]]]],[11,"ne","","",128,[[["utf8error",3]]]],[11,"eq","","",124,[[["parseboolerror",3]]]],[11,"ne","","",124,[[["parseboolerror",3]]]],[11,"eq","alloc::alloc","",2,[[["reallocplacement",4]]]],[11,"eq","alloc::fmt","",87,[[["error",3]]]],[11,"to_string","alloc::borrow","",8,[[],["string",3]]],[11,"to_string","alloc::string","",42,[[],["string",3]]],[11,"deref","alloc::boxed","",5,[[]]],[11,"deref","alloc::borrow","",8,[[]]],[11,"deref","alloc::collections::binary_heap","",12,[[]]],[11,"deref","alloc::rc","",31,[[]]],[11,"deref","alloc::string","",42,[[]]],[11,"deref","alloc::sync","",44,[[]]],[11,"deref","alloc::vec","",47,[[]]],[11,"deref_mut","alloc::boxed","",5,[[]]],[11,"deref_mut","alloc::collections::binary_heap","",12,[[]]],[11,"deref_mut","alloc::string","",42,[[]]],[11,"deref_mut","alloc::vec","",47,[[]]],[11,"from","alloc::boxed","Converts a generic type `T` into a `Box<T>`",5,[[]]],[11,"from","","Converts a `&[T]` into a `Box<[T]>`",5,[[],["box",3]]],[11,"from","","",5,[[["cow",4]],["box",3]]],[11,"from","","Converts a `&str` into a `Box<str>`",5,[[],["box",3]]],[11,"from","","",5,[[["cow",4]],["box",3]]],[11,"from","","Converts a `Box<str>>` into a `Box<[u8]>`",5,[[["box",3]]]],[11,"from","","Converts a `[T; N]` into a `Box<[T]>`",5,[[],["box",3]]],[11,"from","alloc::collections::binary_heap","Converts a `Vec<T>` into a `BinaryHeap<T>`.",13,[[["vec",3]],["binaryheap",3]]],[11,"from","alloc::vec","",47,[[["binaryheap",3]],["vec",3]]],[11,"from","alloc::collections::vec_deque","Turn a [`Vec<T>`] into a [`VecDeque<T>`].",18,[[["vec",3]]]],[11,"from","alloc::vec","Turn a [`VecDeque<T>`] into a [`Vec<T>`].",47,[[["vecdeque",3]]]],[11,"from","alloc::collections","",10,[[["layouterr",3]]]],[11,"from","alloc::rc","",31,[[]]],[11,"from","","",31,[[],["rc",3]]],[11,"from","","",31,[[],["rc",3]]],[11,"from","","",31,[[["string",3]],["rc",3]]],[11,"from","","",31,[[["box",3]],["rc",3]]],[11,"from","","",31,[[["vec",3]],["rc",3]]],[11,"from","","",31,[[["cow",4]],["rc",3]]],[11,"from","alloc::string","",42,[[],["string",3]]],[11,"from","","Converts a `&mut str` into a `String`.",42,[[],["string",3]]],[11,"from","","",42,[[["string",3]],["string",3]]],[11,"from","","Converts the given boxed `str` slice to a `String`. It is…",42,[[["box",3]],["string",3]]],[11,"from","alloc::boxed","Converts the given `String` to a boxed `str` slice that is…",5,[[["string",3]],["box",3]]],[11,"from","alloc::string","",42,[[["cow",4]],["string",3]]],[11,"from","alloc::borrow","",8,[[],["cow",4]]],[11,"from","","",8,[[["string",3]],["cow",4]]],[11,"from","","",8,[[["string",3]],["cow",4]]],[11,"from","alloc::vec","Converts the given `String` to a vector `Vec` that holds…",47,[[["string",3]],["vec",3]]],[11,"from","alloc::sync","",44,[[]]],[11,"from","","",44,[[],["arc",3]]],[11,"from","","",44,[[],["arc",3]]],[11,"from","","",44,[[["string",3]],["arc",3]]],[11,"from","","",44,[[["box",3]],["arc",3]]],[11,"from","","",44,[[["vec",3]],["arc",3]]],[11,"from","","",44,[[["cow",4]],["arc",3]]],[11,"from","alloc::vec","",47,[[],["vec",3]]],[11,"from","","",47,[[],["vec",3]]],[11,"from","","",47,[[],["vec",3]]],[11,"from","","",47,[[["cow",4]],["vec",3]]],[11,"from","","",47,[[["box",3]],["vec",3]]],[11,"from","alloc::boxed","",5,[[["vec",3]],["box",3]]],[11,"from","alloc::vec","",47,[[],["vec",3]]],[11,"from","alloc::borrow","",8,[[],["cow",4]]],[11,"from","","",8,[[["vec",3]],["cow",4]]],[11,"from","","",8,[[["vec",3]],["cow",4]]],[11,"fmt","alloc::alloc","",53,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::boxed","",5,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::borrow","",8,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::binary_heap","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",54,[[["formatter",3]],["result",6]]],[11,"fmt","","",55,[[["formatter",3]],["result",6]]],[11,"fmt","","",56,[[["formatter",3]],["result",6]]],[11,"fmt","","",57,[[["formatter",3]],["result",6]]],[11,"fmt","","",58,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::btree_map","",60,[[["formatter",3]],["result",6]]],[11,"fmt","","",61,[[["formatter",3]],["result",6]]],[11,"fmt","","",62,[[["formatter",3]],["result",6]]],[11,"fmt","","",63,[[["formatter",3]],["result",6]]],[11,"fmt","","",64,[[["formatter",3]],["result",6]]],[11,"fmt","","",65,[[["formatter",3]],["result",6]]],[11,"fmt","","",66,[[["formatter",3]],["result",6]]],[11,"fmt","","",67,[[["formatter",3]],["result",6]]],[11,"fmt","","",19,[[["formatter",3]],["result",6]]],[11,"fmt","","",68,[[["formatter",3]],["result",6]]],[11,"fmt","","",69,[[["formatter",3]],["result",6]]],[11,"fmt","","",70,[[["formatter",3]],["result",6]]],[11,"fmt","","",59,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::btree_set","",72,[[["formatter",3]],["result",6]]],[11,"fmt","","",73,[[["formatter",3]],["result",6]]],[11,"fmt","","",74,[[["formatter",3]],["result",6]]],[11,"fmt","","",75,[[["formatter",3]],["result",6]]],[11,"fmt","","",76,[[["formatter",3]],["result",6]]],[11,"fmt","","",77,[[["formatter",3]],["result",6]]],[11,"fmt","","",78,[[["formatter",3]],["result",6]]],[11,"fmt","","",79,[[["formatter",3]],["result",6]]],[11,"fmt","","",71,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::linked_list","",80,[[["formatter",3]],["result",6]]],[11,"fmt","","",15,[[["formatter",3]],["result",6]]],[11,"fmt","","",81,[[["formatter",3]],["result",6]]],[11,"fmt","","",16,[[["formatter",3]],["result",6]]],[11,"fmt","","",17,[[["formatter",3]],["result",6]]],[11,"fmt","","",82,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections::vec_deque","",83,[[["formatter",3]],["result",6]]],[11,"fmt","","",84,[[["formatter",3]],["result",6]]],[11,"fmt","","",85,[[["formatter",3]],["result",6]]],[11,"fmt","","",86,[[["formatter",3]],["result",6]]],[11,"fmt","","",18,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections","",10,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::rc","",31,[[["formatter",3]],["result",6]]],[11,"fmt","","",32,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::string","",43,[[["formatter",3]],["result",6]]],[11,"fmt","","",141,[[["formatter",3]],["result",6]]],[11,"fmt","","",42,[[["formatter",3]],["result",6]]],[11,"fmt","","",142,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",45,[[["formatter",3]],["result",6]]],[11,"fmt","","",44,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::vec","",47,[[["formatter",3]],["result",6]]],[11,"fmt","","",48,[[["formatter",3]],["result",6]]],[11,"fmt","","",49,[[["formatter",3]],["result",6]]],[11,"fmt","","",143,[[["formatter",3]],["result",6]]],[11,"fmt","","",144,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::boxed","",5,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::borrow","",8,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::collections","",10,[[["formatter",3]],[["error",3],["result",4]]]],[11,"fmt","alloc::rc","",31,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::string","",43,[[["formatter",3]],["result",6]]],[11,"fmt","","",141,[[["formatter",3]],["result",6]]],[11,"fmt","","",42,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",44,[[["formatter",3]],["result",6]]],[11,"eq","alloc::boxed","",5,[[["box",3]]]],[11,"ne","","",5,[[["box",3]]]],[11,"eq","alloc::borrow","",8,[[["cow",4]]]],[11,"eq","alloc::collections::btree_map","",59,[[["btreemap",3]]]],[11,"eq","alloc::collections::btree_set","",71,[[["btreeset",3]]]],[11,"ne","","",71,[[["btreeset",3]]]],[11,"eq","alloc::collections::linked_list","",14,[[]]],[11,"ne","","",14,[[]]],[11,"eq","alloc::collections::vec_deque","",18,[[["vecdeque",3]]]],[11,"eq","","",18,[[["vec",3]]]],[11,"eq","","",18,[[]]],[11,"eq","","",18,[[]]],[11,"eq","","",18,[[]]],[11,"eq","","",18,[[]]],[11,"eq","","",18,[[]]],[11,"eq","alloc::collections","",10,[[["tryreserveerror",4]]]],[11,"ne","","",10,[[["tryreserveerror",4]]]],[11,"eq","alloc::rc","Equality for two `Rc`s.",31,[[["rc",3]]]],[11,"ne","","Inequality for two `Rc`s.",31,[[["rc",3]]]],[11,"eq","alloc::string","",43,[[["fromutf8error",3]]]],[11,"ne","","",43,[[["fromutf8error",3]]]],[11,"eq","","",42,[[["string",3]]]],[11,"ne","","",42,[[["string",3]]]],[11,"eq","","",42,[[]]],[11,"ne","","",42,[[]]],[11,"eq","","",42,[[]]],[11,"ne","","",42,[[]]],[11,"eq","alloc::borrow","",8,[[]]],[11,"ne","","",8,[[]]],[11,"eq","","",8,[[]]],[11,"ne","","",8,[[]]],[11,"eq","","",8,[[["string",3]]]],[11,"ne","","",8,[[["string",3]]]],[11,"eq","alloc::string","",42,[[["cow",4]]]],[11,"ne","","",42,[[["cow",4]]]],[11,"eq","alloc::sync","Equality for two `Arc`s.",44,[[["arc",3]]]],[11,"ne","","Inequality for two `Arc`s.",44,[[["arc",3]]]],[11,"eq","alloc::vec","",47,[[["vec",3]]]],[11,"ne","","",47,[[["vec",3]]]],[11,"eq","","",47,[[]]],[11,"ne","","",47,[[]]],[11,"eq","","",47,[[]]],[11,"ne","","",47,[[]]],[11,"eq","alloc::borrow","",8,[[]]],[11,"ne","","",8,[[]]],[11,"eq","","",8,[[]]],[11,"ne","","",8,[[]]],[11,"eq","","",8,[[["vec",3]]]],[11,"ne","","",8,[[["vec",3]]]],[11,"eq","alloc::vec","",47,[[]]],[11,"ne","","",47,[[]]],[11,"eq","","",47,[[]]],[11,"ne","","",47,[[]]],[11,"cmp","alloc::boxed","",5,[[["box",3]],["ordering",4]]],[11,"cmp","alloc::borrow","",8,[[],["ordering",4]]],[11,"cmp","alloc::collections::btree_map","",59,[[["btreemap",3]],["ordering",4]]],[11,"cmp","alloc::collections::btree_set","",71,[[["btreeset",3]],["ordering",4]]],[11,"cmp","alloc::collections::linked_list","",14,[[],["ordering",4]]],[11,"cmp","alloc::collections::vec_deque","",18,[[["vecdeque",3]],["ordering",4]]],[11,"cmp","alloc::rc","Comparison for two `Rc`s.",31,[[["rc",3]],["ordering",4]]],[11,"cmp","alloc::string","",42,[[["string",3]],["ordering",4]]],[11,"cmp","alloc::sync","Comparison for two `Arc`s.",44,[[["arc",3]],["ordering",4]]],[11,"cmp","alloc::vec","",47,[[["vec",3]],["ordering",4]]],[11,"partial_cmp","alloc::boxed","",5,[[["box",3]],[["option",4],["ordering",4]]]],[11,"lt","","",5,[[["box",3]]]],[11,"le","","",5,[[["box",3]]]],[11,"ge","","",5,[[["box",3]]]],[11,"gt","","",5,[[["box",3]]]],[11,"partial_cmp","alloc::borrow","",8,[[["cow",4]],[["option",4],["ordering",4]]]],[11,"partial_cmp","alloc::collections::btree_map","",59,[[["btreemap",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","alloc::collections::btree_set","",71,[[["btreeset",3]],[["option",4],["ordering",4]]]],[11,"lt","","",71,[[["btreeset",3]]]],[11,"le","","",71,[[["btreeset",3]]]],[11,"gt","","",71,[[["btreeset",3]]]],[11,"ge","","",71,[[["btreeset",3]]]],[11,"partial_cmp","alloc::collections::linked_list","",14,[[],[["option",4],["ordering",4]]]],[11,"partial_cmp","alloc::collections::vec_deque","",18,[[["vecdeque",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","alloc::rc","Partial comparison for two `Rc`s.",31,[[["rc",3]],[["option",4],["ordering",4]]]],[11,"lt","","Less-than comparison for two `Rc`s.",31,[[["rc",3]]]],[11,"le","","\'Less than or equal to\' comparison for two `Rc`s.",31,[[["rc",3]]]],[11,"gt","","Greater-than comparison for two `Rc`s.",31,[[["rc",3]]]],[11,"ge","","\'Greater than or equal to\' comparison for two `Rc`s.",31,[[["rc",3]]]],[11,"partial_cmp","alloc::string","",42,[[["string",3]],[["option",4],["ordering",4]]]],[11,"lt","","",42,[[["string",3]]]],[11,"le","","",42,[[["string",3]]]],[11,"gt","","",42,[[["string",3]]]],[11,"ge","","",42,[[["string",3]]]],[11,"partial_cmp","alloc::sync","Partial comparison for two `Arc`s.",44,[[["arc",3]],[["option",4],["ordering",4]]]],[11,"lt","","Less-than comparison for two `Arc`s.",44,[[["arc",3]]]],[11,"le","","\'Less than or equal to\' comparison for two `Arc`s.",44,[[["arc",3]]]],[11,"gt","","Greater-than comparison for two `Arc`s.",44,[[["arc",3]]]],[11,"ge","","\'Greater than or equal to\' comparison for two `Arc`s.",44,[[["arc",3]]]],[11,"partial_cmp","alloc::vec","",47,[[["vec",3]],[["option",4],["ordering",4]]]],[11,"add","alloc::borrow","",8,[[]]],[11,"add","","",8,[[["cow",4]]]],[11,"add","alloc::string","",42,[[],["string",3]]],[11,"add_assign","alloc::borrow","",8,[[]]],[11,"add_assign","","",8,[[["cow",4]]]],[11,"add_assign","alloc::string","",42,[[]]],[11,"drop","alloc::boxed","",5,[[]]],[11,"drop","alloc::collections::binary_heap","",12,[[]]],[11,"drop","","Removes heap elements in heap order.",58,[[]]],[11,"drop","alloc::collections::btree_map","",59,[[]]],[11,"drop","","",62,[[]]],[11,"drop","","",70,[[]]],[11,"drop","alloc::collections::btree_set","",79,[[]]],[11,"drop","alloc::collections::linked_list","",14,[[]]],[11,"drop","","",82,[[]]],[11,"drop","alloc::collections::vec_deque","",83,[[]]],[11,"drop","","",18,[[]]],[11,"drop","alloc::rc","Drops the `Rc`.",31,[[]]],[11,"drop","","Drops the `Weak` pointer.",32,[[]]],[11,"drop","alloc::string","",142,[[]]],[11,"drop","alloc::sync","Drops the `Arc`.",44,[[]]],[11,"drop","","Drops the `Weak` pointer.",45,[[]]],[11,"drop","alloc::vec","",47,[[]]],[11,"drop","","",48,[[]]],[11,"drop","","",49,[[]]],[11,"drop","","",143,[[]]],[11,"drop","","",144,[[]]],[11,"call","alloc::boxed","",5,[[]]],[11,"call_mut","","",5,[[]]],[11,"call_once","","",5,[[]]],[11,"resume","","",5,[[["pin",3]],["generatorstate",4]]],[11,"index","alloc::collections::btree_map","Returns a reference to the value corresponding to the…",59,[[]]],[11,"index","alloc::collections::vec_deque","",18,[[]]],[11,"index","alloc::string","",42,[[["range",3]]]],[11,"index","","",42,[[["rangeto",3]]]],[11,"index","","",42,[[["rangefrom",3]]]],[11,"index","","",42,[[["rangefull",3]]]],[11,"index","","",42,[[["rangeinclusive",3]]]],[11,"index","","",42,[[["rangetoinclusive",3]]]],[11,"index","alloc::vec","",47,[[]]],[11,"index_mut","alloc::collections::vec_deque","",18,[[]]],[11,"index_mut","alloc::string","",42,[[["range",3]]]],[11,"index_mut","","",42,[[["rangeto",3]]]],[11,"index_mut","","",42,[[["rangefrom",3]]]],[11,"index_mut","","",42,[[["rangefull",3]]]],[11,"index_mut","","",42,[[["rangeinclusive",3]]]],[11,"index_mut","","",42,[[["rangetoinclusive",3]]]],[11,"index_mut","alloc::vec","",47,[[]]],[11,"hash","alloc::boxed","",5,[[]]],[11,"hash","alloc::borrow","",8,[[]]],[11,"hash","alloc::collections::btree_map","",59,[[]]],[11,"hash","alloc::collections::btree_set","",71,[[]]],[11,"hash","alloc::collections::linked_list","",14,[[]]],[11,"hash","alloc::collections::vec_deque","",18,[[]]],[11,"hash","alloc::rc","",31,[[]]],[11,"hash","alloc::string","",42,[[]]],[11,"hash","alloc::sync","",44,[[]]],[11,"hash","alloc::vec","",47,[[]]],[11,"finish","alloc::boxed","",5,[[]]],[11,"write","","",5,[[]]],[11,"write_u8","","",5,[[]]],[11,"write_u16","","",5,[[]]],[11,"write_u32","","",5,[[]]],[11,"write_u64","","",5,[[]]],[11,"write_u128","","",5,[[]]],[11,"write_usize","","",5,[[]]],[11,"write_i8","","",5,[[]]],[11,"write_i16","","",5,[[]]],[11,"write_i32","","",5,[[]]],[11,"write_i64","","",5,[[]]],[11,"write_i128","","",5,[[]]],[11,"write_isize","","",5,[[]]],[11,"next","","",5,[[],["option",4]]],[11,"size_hint","","",5,[[]]],[11,"nth","","",5,[[],["option",4]]],[11,"last","","",5,[[],["option",4]]],[11,"next","alloc::collections::binary_heap","",54,[[],["option",4]]],[11,"size_hint","","",54,[[]]],[11,"last","","",54,[[],["option",4]]],[11,"next","","",55,[[],["option",4]]],[11,"size_hint","","",55,[[]]],[11,"next","","",56,[[],["option",4]]],[11,"size_hint","","",56,[[]]],[11,"next","","",57,[[],["option",4]]],[11,"size_hint","","",57,[[]]],[11,"next","","",58,[[],["option",4]]],[11,"size_hint","","",58,[[]]],[11,"next","alloc::collections::btree_map","",60,[[],["option",4]]],[11,"size_hint","","",60,[[]]],[11,"last","","",60,[[],["option",4]]],[11,"next","","",61,[[],["option",4]]],[11,"size_hint","","",61,[[]]],[11,"last","","",61,[[],["option",4]]],[11,"next","","",62,[[],["option",4]]],[11,"size_hint","","",62,[[]]],[11,"next","","",63,[[],["option",4]]],[11,"size_hint","","",63,[[]]],[11,"last","","",63,[[],["option",4]]],[11,"next","","",64,[[],["option",4]]],[11,"size_hint","","",64,[[]]],[11,"last","","",64,[[],["option",4]]],[11,"next","","",70,[[],["option",4]]],[11,"size_hint","","",70,[[]]],[11,"next","","",66,[[],["option",4]]],[11,"last","","",66,[[],["option",4]]],[11,"next","","",65,[[],["option",4]]],[11,"size_hint","","",65,[[]]],[11,"last","","",65,[[],["option",4]]],[11,"next","","",67,[[],["option",4]]],[11,"last","","",67,[[],["option",4]]],[11,"next","alloc::collections::btree_set","",79,[[],["option",4]]],[11,"size_hint","","",79,[[]]],[11,"next","","",72,[[],["option",4]]],[11,"size_hint","","",72,[[]]],[11,"last","","",72,[[],["option",4]]],[11,"next","","",73,[[],["option",4]]],[11,"size_hint","","",73,[[]]],[11,"next","","",74,[[],["option",4]]],[11,"last","","",74,[[],["option",4]]],[11,"next","","",75,[[],["option",4]]],[11,"size_hint","","",75,[[]]],[11,"next","","",76,[[],["option",4]]],[11,"size_hint","","",76,[[]]],[11,"next","","",77,[[],["option",4]]],[11,"size_hint","","",77,[[]]],[11,"next","","",78,[[],["option",4]]],[11,"size_hint","","",78,[[]]],[11,"next","alloc::collections::linked_list","",80,[[],["option",4]]],[11,"size_hint","","",80,[[]]],[11,"last","","",80,[[],["option",4]]],[11,"next","","",15,[[],["option",4]]],[11,"size_hint","","",15,[[]]],[11,"last","","",15,[[],["option",4]]],[11,"next","","",82,[[],["option",4]]],[11,"size_hint","","",82,[[]]],[11,"next","","",81,[[],["option",4]]],[11,"size_hint","","",81,[[]]],[11,"next","alloc::collections::vec_deque","",83,[[],["option",4]]],[11,"size_hint","","",83,[[]]],[11,"next","","",84,[[],["option",4]]],[11,"size_hint","","",84,[[]]],[11,"fold","","",84,[[]]],[11,"try_fold","","",84,[[]]],[11,"nth","","",84,[[],["option",4]]],[11,"last","","",84,[[],["option",4]]],[11,"next","","",85,[[],["option",4]]],[11,"size_hint","","",85,[[]]],[11,"fold","","",85,[[]]],[11,"nth","","",85,[[],["option",4]]],[11,"last","","",85,[[],["option",4]]],[11,"next","","",86,[[],["option",4]]],[11,"size_hint","","",86,[[]]],[11,"next","alloc::string","",142,[[],["option",4]]],[11,"size_hint","","",142,[[]]],[11,"last","","",142,[[],["option",4]]],[11,"next","alloc::vec","",48,[[],["option",4]]],[11,"size_hint","","",48,[[]]],[11,"count","","",48,[[]]],[11,"next","","",49,[[],["option",4]]],[11,"size_hint","","",49,[[]]],[11,"next","","",143,[[],["option",4]]],[11,"size_hint","","",143,[[]]],[11,"next","","",144,[[],["option",4]]],[11,"size_hint","","",144,[[]]],[11,"next_back","alloc::boxed","",5,[[],["option",4]]],[11,"nth_back","","",5,[[],["option",4]]],[11,"next_back","alloc::collections::binary_heap","",54,[[],["option",4]]],[11,"next_back","","",55,[[],["option",4]]],[11,"next_back","","",57,[[],["option",4]]],[11,"next_back","alloc::collections::btree_map","",60,[[],["option",4]]],[11,"next_back","","",61,[[],["option",4]]],[11,"next_back","","",62,[[],["option",4]]],[11,"next_back","","",63,[[],["option",4]]],[11,"next_back","","",64,[[],["option",4]]],[11,"next_back","","",65,[[],["option",4]]],[11,"next_back","","",66,[[],["option",4]]],[11,"next_back","","",67,[[],["option",4]]],[11,"next_back","alloc::collections::btree_set","",72,[[],["option",4]]],[11,"next_back","","",73,[[],["option",4]]],[11,"next_back","","",74,[[],["option",4]]],[11,"next_back","alloc::collections::linked_list","",80,[[],["option",4]]],[11,"next_back","","",15,[[],["option",4]]],[11,"next_back","","",81,[[],["option",4]]],[11,"next_back","alloc::collections::vec_deque","",83,[[],["option",4]]],[11,"next_back","","",84,[[],["option",4]]],[11,"rfold","","",84,[[]]],[11,"try_rfold","","",84,[[]]],[11,"next_back","","",85,[[],["option",4]]],[11,"rfold","","",85,[[]]],[11,"next_back","","",86,[[],["option",4]]],[11,"next_back","alloc::string","",142,[[],["option",4]]],[11,"next_back","alloc::vec","",48,[[],["option",4]]],[11,"next_back","","",49,[[],["option",4]]],[11,"next_back","","",143,[[],["option",4]]],[11,"extend","alloc::collections::binary_heap","",13,[[["intoiterator",8]]]],[11,"extend_one","","",13,[[]]],[11,"extend_reserve","","",13,[[]]],[11,"extend","","",13,[[["intoiterator",8]]]],[11,"extend_one","","",13,[[]]],[11,"extend_reserve","","",13,[[]]],[11,"extend","alloc::collections::btree_map","",59,[[["intoiterator",8]]]],[11,"extend_one","","",59,[[]]],[11,"extend","","",59,[[["intoiterator",8]]]],[11,"extend_one","","",59,[[]]],[11,"extend","alloc::collections::btree_set","",71,[[["intoiterator",8]]]],[11,"extend_one","","",71,[[]]],[11,"extend","","",71,[[["intoiterator",8]]]],[11,"extend_one","","",71,[[]]],[11,"extend","alloc::collections::linked_list","",14,[[["intoiterator",8]]]],[11,"extend_one","","",14,[[]]],[11,"extend","","",14,[[["intoiterator",8]]]],[11,"extend_one","","",14,[[]]],[11,"extend","alloc::collections::vec_deque","",18,[[["intoiterator",8]]]],[11,"extend_one","","",18,[[]]],[11,"extend_reserve","","",18,[[]]],[11,"extend","","",18,[[["intoiterator",8]]]],[11,"extend_one","","",18,[[]]],[11,"extend_reserve","","",18,[[]]],[11,"extend","alloc::string","",42,[[["intoiterator",8]]]],[11,"extend_one","","",42,[[]]],[11,"extend_reserve","","",42,[[]]],[11,"extend","","",42,[[["intoiterator",8]]]],[11,"extend_one","","",42,[[]]],[11,"extend_reserve","","",42,[[]]],[11,"extend","","",42,[[["intoiterator",8]]]],[11,"extend_one","","",42,[[]]],[11,"extend","","",42,[[["intoiterator",8]]]],[11,"extend_one","","",42,[[["string",3]]]],[11,"extend","","",42,[[["intoiterator",8]]]],[11,"extend_one","","",42,[[["cow",4]]]],[11,"extend","alloc::vec","",47,[[["intoiterator",8]]]],[11,"extend_one","","",47,[[]]],[11,"extend_reserve","","",47,[[]]],[11,"extend","","",47,[[["intoiterator",8]]]],[11,"extend_one","","",47,[[]]],[11,"extend_reserve","","",47,[[]]],[11,"from_iter","alloc::boxed","",5,[[["intoiterator",8]]]],[11,"from_iter","alloc::collections::binary_heap","",13,[[["intoiterator",8]],["binaryheap",3]]],[11,"from_iter","alloc::collections::btree_map","",59,[[["intoiterator",8]],["btreemap",3]]],[11,"from_iter","alloc::collections::btree_set","",71,[[["intoiterator",8]],["btreeset",3]]],[11,"from_iter","alloc::collections::linked_list","",14,[[["intoiterator",8]]]],[11,"from_iter","alloc::collections::vec_deque","",18,[[["intoiterator",8]],["vecdeque",3]]],[11,"from_iter","alloc::rc","Takes each element in the `Iterator` and collects it into…",31,[[["intoiterator",8]]]],[11,"from_iter","alloc::string","",42,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",42,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",42,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",42,[[["intoiterator",8]],["string",3]]],[11,"from_iter","","",42,[[["intoiterator",8]],["string",3]]],[11,"from_iter","alloc::borrow","",8,[[["intoiterator",8]],["cow",4]]],[11,"from_iter","","",8,[[["intoiterator",8]],["cow",4]]],[11,"from_iter","","",8,[[["intoiterator",8]],["cow",4]]],[11,"from_iter","alloc::sync","Takes each element in the `Iterator` and collects it into…",44,[[["intoiterator",8]]]],[11,"from_iter","alloc::vec","",47,[[["intoiterator",8]],["vec",3]]],[11,"from_iter","alloc::borrow","",8,[[["intoiterator",8]],["cow",4]]],[11,"into_iter","alloc::collections::binary_heap","Creates a consuming iterator, that is, one that moves each…",13,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::btree_map","",59,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::btree_set","Gets an iterator for moving out the `BTreeSet`\'s contents.",71,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::linked_list","Consumes the list into an iterator yielding elements by…",14,[[],["intoiter",3]]],[11,"into_iter","alloc::collections::vec_deque","Consumes the `VecDeque` into a front-to-back iterator…",18,[[],["intoiter",3]]],[11,"into_iter","alloc::vec","Creates a consuming iterator, that is, one that moves each…",47,[[],["intoiter",3]]],[11,"len","alloc::boxed","",5,[[]]],[11,"is_empty","","",5,[[]]],[11,"is_empty","alloc::collections::binary_heap","",54,[[]]],[11,"is_empty","","",55,[[]]],[11,"is_empty","","",57,[[]]],[11,"len","alloc::collections::btree_map","",60,[[]]],[11,"len","","",61,[[]]],[11,"len","","",62,[[]]],[11,"len","","",63,[[]]],[11,"len","","",64,[[]]],[11,"len","","",65,[[]]],[11,"len","alloc::collections::btree_set","",72,[[]]],[11,"len","","",73,[[]]],[11,"is_empty","alloc::collections::vec_deque","",84,[[]]],[11,"is_empty","","",85,[[]]],[11,"is_empty","","",86,[[]]],[11,"is_empty","alloc::vec","",48,[[]]],[11,"is_empty","","",49,[[]]],[11,"try_from","alloc::boxed","",5,[[["box",3]],["result",4]]],[11,"try_from","alloc::rc","",31,[[["rc",3]],["result",4]]],[11,"try_from","alloc::sync","",44,[[["arc",3]],["result",4]]],[11,"from_str","alloc::string","",42,[[],[["result",4],["string",3]]]],[11,"write_str","","",42,[[],["result",6]]],[11,"write_char","","",42,[[],["result",6]]],[11,"as_ref","alloc::boxed","",5,[[]]],[11,"as_ref","alloc::borrow","",8,[[]]],[11,"as_ref","alloc::rc","",31,[[]]],[11,"as_ref","alloc::string","",42,[[]]],[11,"as_ref","","",42,[[]]],[11,"as_ref","alloc::sync","",44,[[]]],[11,"as_ref","alloc::vec","",47,[[],["vec",3]]],[11,"as_ref","","",47,[[]]],[11,"as_mut","alloc::boxed","",5,[[]]],[11,"as_mut","alloc::string","",42,[[]]],[11,"as_mut","alloc::vec","",47,[[],["vec",3]]],[11,"as_mut","","",47,[[]]],[11,"fmt","alloc::boxed","",5,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::rc","",31,[[["formatter",3]],["result",6]]],[11,"fmt","alloc::sync","",44,[[["formatter",3]],["result",6]]],[11,"clone","alloc::alloc","",53,[[],["global",3]]],[11,"clone","alloc::boxed","Returns a new box with a `clone()` of this box\'s contents.",5,[[],["box",3]]],[11,"clone_from","","Copies `source`\'s contents into `self` without creating a…",5,[[["box",3]]]],[11,"clone","","",5,[[]]],[11,"clone","","",5,[[]]],[11,"clone_from","","",5,[[]]],[11,"clone","alloc::borrow","",8,[[]]],[11,"clone_from","","",8,[[]]],[11,"clone","alloc::collections::binary_heap","",13,[[]]],[11,"clone_from","","",13,[[]]],[11,"clone","","",54,[[]]],[11,"clone","","",55,[[],["intoiter",3]]],[11,"clone","","",56,[[],["intoitersorted",3]]],[11,"clone","alloc::collections::btree_map","",59,[[],["btreemap",3]]],[11,"clone","","",60,[[]]],[11,"clone","","",63,[[]]],[11,"clone","","",64,[[]]],[11,"clone","","",66,[[]]],[11,"clone","alloc::collections::btree_set","",71,[[]]],[11,"clone_from","","",71,[[]]],[11,"clone","","",72,[[]]],[11,"clone","","",74,[[]]],[11,"clone","","",75,[[]]],[11,"clone","","",76,[[]]],[11,"clone","","",77,[[]]],[11,"clone","","",78,[[]]],[11,"clone","alloc::collections::linked_list","",80,[[]]],[11,"clone","","",81,[[],["intoiter",3]]],[11,"clone","","",16,[[]]],[11,"clone","","",14,[[]]],[11,"clone_from","","",14,[[]]],[11,"clone","alloc::collections::vec_deque","",18,[[],["vecdeque",3]]],[11,"clone_from","","",18,[[]]],[11,"clone","","",84,[[]]],[11,"clone","","",86,[[],["intoiter",3]]],[11,"clone","alloc::collections","",10,[[],["tryreserveerror",4]]],[11,"clone","alloc::rc","Makes a clone of the `Rc` pointer.",31,[[],["rc",3]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the…",32,[[],["weak",3]]],[11,"clone","alloc::string","",43,[[],["fromutf8error",3]]],[11,"clone","","",42,[[]]],[11,"clone_from","","",42,[[]]],[11,"clone","alloc::sync","Makes a clone of the `Arc` pointer.",44,[[],["arc",3]]],[11,"clone","","Makes a clone of the `Weak` pointer that points to the…",45,[[],["weak",3]]],[11,"clone","alloc::vec","",47,[[],["vec",3]]],[11,"clone_from","","",47,[[["vec",3]]]],[11,"clone","","",48,[[],["intoiter",3]]],[11,"default","alloc::alloc","",53,[[],["global",3]]],[11,"default","alloc::boxed","Creates a `Box<T>`, with the `Default` value for T.",5,[[],["box",3]]],[11,"default","","",5,[[],["box",3]]],[11,"default","","",5,[[],["box",3]]],[11,"default","alloc::borrow","Creates an owned Cow<\'a, B> with the default value for the…",8,[[]]],[11,"default","alloc::collections::binary_heap","Creates an empty `BinaryHeap<T>`.",13,[[],["binaryheap",3]]],[11,"default","alloc::collections::btree_map","Creates an empty `BTreeMap<K, V>`.",59,[[],["btreemap",3]]],[11,"default","alloc::collections::btree_set","Makes an empty `BTreeSet<T>` with a reasonable choice of B.",71,[[],["btreeset",3]]],[11,"default","alloc::collections::linked_list","Creates an empty `LinkedList<T>`.",14,[[]]],[11,"default","alloc::collections::vec_deque","Creates an empty `VecDeque<T>`.",18,[[],["vecdeque",3]]],[11,"default","alloc::rc","Creates a new `Rc<T>`, with the `Default` value for `T`.",31,[[],["rc",3]]],[11,"default","","Constructs a new `Weak<T>`, allocating memory for `T`…",32,[[],["weak",3]]],[11,"default","alloc::string","Creates an empty `String`.",42,[[],["string",3]]],[11,"default","alloc::sync","Constructs a new `Weak<T>`, without allocating memory.…",45,[[],["weak",3]]],[11,"default","","Creates a new `Arc<T>`, with the `Default` value for `T`.",44,[[],["arc",3]]],[11,"default","alloc::vec","Creates an empty `Vec<T>`.",47,[[],["vec",3]]],[11,"borrow","alloc::boxed","",5,[[]]],[11,"borrow","alloc::borrow","",8,[[]]],[11,"borrow","alloc::rc","",31,[[]]],[11,"borrow","alloc::vec","",47,[[]]],[11,"borrow","alloc::string","",42,[[]]],[11,"borrow","alloc::sync","",44,[[]]],[11,"borrow_mut","alloc::boxed","",5,[[]]],[11,"borrow_mut","alloc::vec","",47,[[]]],[11,"borrow_mut","alloc::string","",42,[[]]],[11,"poll","alloc::boxed","",5,[[["context",3],["pin",3]],["poll",4]]],[11,"alloc","alloc::alloc","",53,[[["layout",3],["allocinit",4]],[["memoryblock",3],["result",4],["allocerr",3]]]],[11,"dealloc","","",53,[[["layout",3],["nonnull",3]]]],[11,"grow","","",53,[[["allocinit",4],["layout",3],["reallocplacement",4],["nonnull",3]],[["memoryblock",3],["result",4],["allocerr",3]]]],[11,"shrink","","",53,[[["layout",3],["reallocplacement",4],["nonnull",3]],[["memoryblock",3],["result",4],["allocerr",3]]]],[11,"init","","Initialize the specified memory block.",0,[[["memoryblock",3]]]],[11,"init_offset","","Initialize the memory block like specified by `init` at…",0,[[["memoryblock",3]]]],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or…",51,[[],[["layout",3],["layouterr",3],["result",4]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",51,[[],["layout",3]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",51,[[]]],[11,"align","","The minimum byte alignment for a memory block of this…",51,[[]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type…",51,[[],["layout",3]]],[11,"for_value","","Produces layout describing a record that could be used to…",51,[[],["layout",3]]],[11,"dangling","","Creates a `NonNull` that is dangling, but well-aligned for…",51,[[],["nonnull",3]]],[11,"align_to","","Creates a layout describing the record that can hold a…",51,[[],[["layout",3],["layouterr",3],["result",4]]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self`…",51,[[]]],[11,"pad_to_align","","Creates a layout by rounding the size of this layout up to…",51,[[],["layout",3]]],[11,"repeat","","Creates a layout describing the record for `n` instances…",51,[[],[["layouterr",3],["result",4]]]],[11,"extend","","Creates a layout describing the record for `self` followed…",51,[[["layout",3]],[["layouterr",3],["result",4]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances…",51,[[],[["layout",3],["layouterr",3],["result",4]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed…",51,[[["layout",3]],[["layout",3],["layouterr",3],["result",4]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",51,[[],[["layout",3],["layouterr",3],["result",4]]]],[11,"new","alloc::collections::btree_map","Makes a new empty BTreeMap with a reasonable choice for B.",59,[[],["btreemap",3]]],[11,"clear","","Clears the map, removing all elements.",59,[[]]],[11,"get","","Returns a reference to the value corresponding to the key.",59,[[],["option",4]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied…",59,[[],["option",4]]],[11,"first_key_value","","Returns the first key-value pair in the map. The key in…",59,[[],["option",4]]],[11,"first_entry","","Returns the first entry in the map for in-place…",59,[[],[["option",4],["occupiedentry",3]]]],[11,"pop_first","","Removes and returns the first element in the map. The key…",59,[[],["option",4]]],[11,"last_key_value","","Returns the last key-value pair in the map. The key in…",59,[[],["option",4]]],[11,"last_entry","","Returns the last entry in the map for in-place…",59,[[],[["option",4],["occupiedentry",3]]]],[11,"pop_last","","Removes and returns the last element in the map. The key…",59,[[],["option",4]]],[11,"contains_key","","Returns `true` if the map contains a value for the…",59,[[]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to…",59,[[],["option",4]]],[11,"insert","","Inserts a key-value pair into the map.",59,[[],["option",4]]],[11,"remove","","Removes a key from the map, returning the value at the key…",59,[[],["option",4]]],[11,"remove_entry","","Removes a key from the map, returning the stored key and…",59,[[],["option",4]]],[11,"append","","Moves all elements from `other` into `Self`, leaving…",59,[[]]],[11,"range","","Constructs a double-ended iterator over a sub-range of…",59,[[],["range",3]]],[11,"range_mut","","Constructs a mutable double-ended iterator over a…",59,[[],["rangemut",3]]],[11,"entry","","Gets the given key\'s corresponding entry in the map for…",59,[[],["entry",4]]],[11,"split_off","","Splits the collection into two at the given key. Returns…",59,[[]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if…",59,[[],["drainfilter",3]]],[11,"iter","","Gets an iterator over the entries of the map, sorted by key.",59,[[],["iter",3]]],[11,"iter_mut","","Gets a mutable iterator over the entries of the map,…",59,[[],["itermut",3]]],[11,"keys","","Gets an iterator over the keys of the map, in sorted order.",59,[[],["keys",3]]],[11,"values","","Gets an iterator over the values of the map, in order by…",59,[[],["values",3]]],[11,"values_mut","","Gets a mutable iterator over the values of the map, in…",59,[[],["valuesmut",3]]],[11,"len","","Returns the number of elements in the map.",59,[[]]],[11,"is_empty","","Returns `true` if the map contains no elements.",59,[[]]],[11,"or_insert","","Ensures a value is in the entry by inserting the default…",19,[[]]],[11,"or_insert_with","","Ensures a value is in the entry by inserting the result of…",19,[[["fnonce",8]]]],[11,"or_insert_with_key","","Ensures a value is in the entry by inserting, if empty,…",19,[[["fnonce",8]]]],[11,"key","","Returns a reference to this entry\'s key.",19,[[]]],[11,"and_modify","","Provides in-place mutable access to an occupied entry…",19,[[]]],[11,"or_default","","Ensures a value is in the entry by inserting the default…",19,[[]]],[11,"key","","Gets a reference to the key that would be used when…",68,[[]]],[11,"into_key","","Take ownership of the key.",68,[[]]],[11,"insert","","Sets the value of the entry with the `VacantEntry`\'s key,…",68,[[]]],[11,"key","","Gets a reference to the key in the entry.",69,[[]]],[11,"remove_entry","","Take ownership of the key and value from the map.",69,[[]]],[11,"get","","Gets a reference to the value in the entry.",69,[[]]],[11,"get_mut","","Gets a mutable reference to the value in the entry.",69,[[]]],[11,"into_mut","","Converts the entry into a mutable reference to its value.",69,[[]]],[11,"insert","","Sets the value of the entry with the `OccupiedEntry`\'s…",69,[[]]],[11,"remove","","Takes the value of the entry out of the map, and returns it.",69,[[]]],[11,"new","alloc::collections::btree_set","Makes a new `BTreeSet` with a reasonable choice of B.",71,[[],["btreeset",3]]],[11,"range","","Constructs a double-ended iterator over a sub-range of…",71,[[],["range",3]]],[11,"difference","","Visits the values representing the difference, i.e., the…",71,[[["btreeset",3]],["difference",3]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference,…",71,[[["btreeset",3]],["symmetricdifference",3]]],[11,"intersection","","Visits the values representing the intersection, i.e., the…",71,[[["btreeset",3]],["intersection",3]]],[11,"union","","Visits the values representing the union, i.e., all the…",71,[[["btreeset",3]],["union",3]]],[11,"clear","","Clears the set, removing all values.",71,[[]]],[11,"contains","","Returns `true` if the set contains a value.",71,[[]]],[11,"get","","Returns a reference to the value in the set, if any, that…",71,[[],["option",4]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with…",71,[[["btreeset",3]]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e.,…",71,[[["btreeset",3]]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e.,…",71,[[["btreeset",3]]]],[11,"first","","Returns a reference to the first value in the set, if any.…",71,[[],["option",4]]],[11,"last","","Returns a reference to the last value in the set, if any.…",71,[[],["option",4]]],[11,"pop_first","","Removes the first value from the set and returns it, if…",71,[[],["option",4]]],[11,"pop_last","","Removes the last value from the set and returns it, if…",71,[[],["option",4]]],[11,"insert","","Adds a value to the set.",71,[[]]],[11,"replace","","Adds a value to the set, replacing the existing value, if…",71,[[],["option",4]]],[11,"remove","","Removes a value from the set. Returns whether the value…",71,[[]]],[11,"take","","Removes and returns the value in the set, if any, that is…",71,[[],["option",4]]],[11,"append","","Moves all elements from `other` into `Self`, leaving…",71,[[]]],[11,"split_off","","Splits the collection into two at the given key. Returns…",71,[[]]],[11,"drain_filter","","Creates an iterator which uses a closure to determine if a…",71,[[],["drainfilter",3]]],[11,"iter","","Gets an iterator that visits the values in the `BTreeSet`…",71,[[],["iter",3]]],[11,"len","","Returns the number of elements in the set.",71,[[]]],[11,"is_empty","","Returns `true` if the set contains no elements.",71,[[]]],[11,"entry","alloc::fmt","Adds a new entry to the list output.",89,[[["debug",8]],["debuglist",3]]],[11,"entries","","Adds the contents of an iterator of entries to the list…",89,[[],["debuglist",3]]],[11,"finish","","Finishes output and returns any error encountered.",89,[[],[["error",3],["result",4]]]],[11,"entry","","Adds a new entry to the map output.",90,[[["debug",8]],["debugmap",3]]],[11,"key","","Adds the key part of a new entry to the map output.",90,[[["debug",8]],["debugmap",3]]],[11,"value","","Adds the value part of a new entry to the map output.",90,[[["debug",8]],["debugmap",3]]],[11,"entries","","Adds the contents of an iterator of entries to the map…",90,[[],["debugmap",3]]],[11,"finish","","Finishes output and returns any error encountered.",90,[[],[["error",3],["result",4]]]],[11,"entry","","Adds a new entry to the set output.",91,[[["debug",8]],["debugset",3]]],[11,"entries","","Adds the contents of an iterator of entries to the set…",91,[[],["debugset",3]]],[11,"finish","","Finishes output and returns any error encountered.",91,[[],[["error",3],["result",4]]]],[11,"field","","Adds a new field to the generated struct output.",92,[[["debug",8]],["debugstruct",3]]],[11,"finish_non_exhaustive","","Marks the struct as non-exhaustive, indicating to the…",92,[[],[["error",3],["result",4]]]],[11,"finish","","Finishes output and returns any error encountered.",92,[[],[["error",3],["result",4]]]],[11,"field","","Adds a new field to the generated tuple struct output.",93,[[["debug",8]],["debugtuple",3]]],[11,"finish","","Finishes output and returns any error encountered.",93,[[],[["error",3],["result",4]]]],[11,"pad_integral","","Performs the correct padding for an integer which has…",94,[[],[["error",3],["result",4]]]],[11,"pad","","This function takes a string slice and emits it to the…",94,[[],[["error",3],["result",4]]]],[11,"write_str","","Writes some data to the underlying buffer contained within…",94,[[],[["error",3],["result",4]]]],[11,"write_fmt","","Writes some formatted information into this instance.",94,[[["arguments",3]],[["error",3],["result",4]]]],[11,"flags","","Flags for formatting",94,[[]]],[11,"fill","","Character used as \'fill\' whenever there is alignment.",94,[[]]],[11,"align","","Flag indicating what form of alignment was requested.",94,[[],[["alignment",4],["option",4]]]],[11,"width","","Optionally specified integer width that the output should…",94,[[],["option",4]]],[11,"precision","","Optionally specified precision for numeric types.…",94,[[],["option",4]]],[11,"sign_plus","","Determines if the `+` flag was specified.",94,[[]]],[11,"sign_minus","","Determines if the `-` flag was specified.",94,[[]]],[11,"alternate","","Determines if the `#` flag was specified.",94,[[]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",94,[[]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with…",94,[[],["debugstruct",3]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with…",94,[[],["debugtuple",3]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with…",94,[[],["debuglist",3]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with…",94,[[],["debugset",3]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with…",94,[[],["debugmap",3]]],[11,"remainder","alloc::slice","Returns the remainder of the original slice that is not…",97,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",98,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",102,[[]]],[11,"into_slice","","Views the underlying data as a subslice of the original…",103,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",103,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not…",105,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",106,[[]]],[11,"as_str","alloc::str","Views the underlying data as a subslice of the original…",122,[[]]],[11,"as_str","","Views the underlying data as a subslice of the original…",123,[[]]],[11,"valid_up_to","","Returns the index in the given string up to which valid…",128,[[]]],[11,"error_len","","Provides more information about the failure:",128,[[],["option",4]]]],"p":[[4,"AllocInit"],[3,"MemoryBlock"],[4,"ReallocPlacement"],[8,"AllocRef"],[8,"GlobalAlloc"],[3,"Box"],[8,"Borrow"],[8,"BorrowMut"],[4,"Cow"],[8,"ToOwned"],[4,"TryReserveError"],[13,"AllocError"],[3,"PeekMut"],[3,"BinaryHeap"],[3,"LinkedList"],[3,"IterMut"],[3,"Cursor"],[3,"CursorMut"],[3,"VecDeque"],[4,"Entry"],[4,"Alignment"],[8,"Binary"],[8,"Octal"],[8,"Debug"],[8,"Display"],[8,"Write"],[8,"LowerExp"],[8,"UpperExp"],[8,"LowerHex"],[8,"Pointer"],[8,"UpperHex"],[3,"Rc"],[3,"Weak"],[8,"SliceIndex"],[8,"Concat"],[8,"Join"],[8,"Pattern"],[4,"SearchStep"],[8,"Searcher"],[8,"ReverseSearcher"],[8,"FromStr"],[8,"ToString"],[3,"String"],[3,"FromUtf8Error"],[3,"Arc"],[3,"Weak"],[8,"Wake"],[3,"Vec"],[3,"IntoIter"],[3,"Drain"],[3,"AllocErr"],[3,"Layout"],[3,"LayoutErr"],[3,"Global"],[3,"Iter"],[3,"IntoIter"],[3,"IntoIterSorted"],[3,"Drain"],[3,"DrainSorted"],[3,"BTreeMap"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Keys"],[3,"Values"],[3,"ValuesMut"],[3,"Range"],[3,"RangeMut"],[3,"VacantEntry"],[3,"OccupiedEntry"],[3,"DrainFilter"],[3,"BTreeSet"],[3,"Iter"],[3,"IntoIter"],[3,"Range"],[3,"Difference"],[3,"SymmetricDifference"],[3,"Intersection"],[3,"Union"],[3,"DrainFilter"],[3,"Iter"],[3,"IntoIter"],[3,"DrainFilter"],[3,"Drain"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Error"],[3,"Arguments"],[3,"DebugList"],[3,"DebugMap"],[3,"DebugSet"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"Formatter"],[3,"Chunks"],[3,"Windows"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"ChunksMut"],[3,"Split"],[3,"SplitMut"],[3,"Iter"],[3,"IterMut"],[3,"RChunks"],[3,"RChunksExact"],[3,"RChunksExactMut"],[3,"RChunksMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"RSplitN"],[3,"RSplitNMut"],[3,"SplitN"],[3,"SplitNMut"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"EncodeUtf16"],[3,"SplitAsciiWhitespace"],[3,"SplitWhitespace"],[3,"Bytes"],[3,"CharIndices"],[3,"Chars"],[3,"ParseBoolError"],[3,"EscapeDebug"],[3,"EscapeDefault"],[3,"EscapeUnicode"],[3,"Utf8Error"],[3,"Lines"],[3,"LinesAny"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"RSplit"],[3,"Split"],[3,"RSplitN"],[3,"SplitN"],[3,"RSplitTerminator"],[3,"SplitTerminator"],[3,"FromUtf16Error"],[3,"Drain"],[3,"Splice"],[3,"DrainFilter"]],"a":{"{:?}":[240],"{}":[243]}},\
"core":{"doc":"The Rust Core Library","i":[[0,"i128","core","The 128-bit signed integer type.",null,null],[17,"MIN","core::i128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i16","core","The 16-bit signed integer type.",null,null],[17,"MIN","core::i16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i32","core","The 32-bit signed integer type.",null,null],[17,"MIN","core::i32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i64","core","The 64-bit signed integer type.",null,null],[17,"MIN","core::i64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i8","core","The 8-bit signed integer type.",null,null],[17,"MIN","core::i8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"isize","core","The pointer-sized signed integer type.",null,null],[17,"MIN","core::isize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u128","core","The 128-bit unsigned integer type.",null,null],[17,"MIN","core::u128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u16","core","The 16-bit unsigned integer type.",null,null],[17,"MIN","core::u16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u32","core","The 32-bit unsigned integer type.",null,null],[17,"MIN","core::u32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u64","core","The 64-bit unsigned integer type.",null,null],[17,"MIN","core::u64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u8","core","The 8-bit unsigned integer type.",null,null],[17,"MIN","core::u8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"usize","core","The pointer-sized unsigned integer type.",null,null],[17,"MIN","core::usize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"f32","core","This module provides constants which are specific to the…",null,null],[0,"consts","core::f32","Basic mathematical constants.",null,null],[17,"PI","core::f32::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f32","The radix or base of the internal representation of `f32`.…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f32`. Use `f32::EPSILON`…",null,null],[17,"MIN","","Smallest finite `f32` value. Use `f32::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value. Use…",null,null],[17,"MAX","","Largest finite `f32` value. Use `f32::MAX` instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f32::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f32::NAN` instead.",null,null],[17,"INFINITY","","Infinity (∞). Use `f32::INFINITY` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f32::NEG_INFINITY` instead.",null,null],[0,"f64","core","This module provides constants which are specific to the…",null,null],[0,"consts","core::f64","Basic mathematical constants.",null,null],[17,"PI","core::f64::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"RADIX","core::f64","The radix or base of the internal representation of `f64`.…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"DIGITS","","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f64`. Use `f64::EPSILON`…",null,null],[17,"MIN","","Smallest finite `f64` value. Use `f64::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value. Use…",null,null],[17,"MAX","","Largest finite `f64` value. Use `f64::MAX` instead.",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f64::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f64::NAN` instead.",null,null],[17,"INFINITY","","Infinity (∞). Use `f64::INFINITY` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f64::NEG_INFINITY` instead.",null,null],[0,"num","core","Numeric traits and functions for the built-in numeric types.",null,null],[3,"NonZeroU8","core::num","An integer that is known not to equal zero.",null,null],[3,"NonZeroU16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroU128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroUsize","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI8","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI16","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI32","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI64","","An integer that is known not to equal zero.",null,null],[3,"NonZeroI128","","An integer that is known not to equal zero.",null,null],[3,"NonZeroIsize","","An integer that is known not to equal zero.",null,null],[3,"Wrapping","","Provides intentionally-wrapped arithmetic on `T`.",null,null],[12,"0","","",0,null],[3,"TryFromIntError","","The error type returned when a checked integral type…",null,null],[3,"ParseIntError","","An error which can be returned when parsing an integer.",null,null],[3,"ParseFloatError","","An error which can be returned when parsing a float.",null,null],[4,"FpCategory","","A classification of floating point numbers.",null,null],[13,"Nan","","\\\"Not a Number\\\", often obtained by dividing by zero.",1,null],[13,"Infinite","","Positive or negative infinity.",1,null],[13,"Zero","","Positive or negative zero.",1,null],[13,"Subnormal","","De-normalized floating point representation (less precise…",1,null],[13,"Normal","","A regular floating point number.",1,null],[4,"IntErrorKind","","Enum to store the various types of errors that can cause…",null,null],[13,"Empty","","Value being parsed is empty.",2,null],[13,"InvalidDigit","","Contains an invalid digit.",2,null],[13,"Overflow","","Integer is too large to store in target integer type.",2,null],[13,"Underflow","","Integer is too small to store in target integer type.",2,null],[13,"Zero","","Value was Zero",2,null],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[18,"MIN","","Returns the smallest value that can be represented by this…",0,null],[18,"MAX","","Returns the largest value that can be represented by this…",0,null],[11,"count_ones","","Returns the number of ones in the binary representation of…",0,[[]]],[11,"count_zeros","","Returns the number of zeros in the binary representation…",0,[[]]],[11,"trailing_zeros","","Returns the number of trailing zeros in the binary…",0,[[]]],[11,"rotate_left","","Shifts the bits to the left by a specified amount, `n`,…",0,[[]]],[11,"rotate_right","","Shifts the bits to the right by a specified amount, `n`,…",0,[[]]],[11,"swap_bytes","","Reverses the byte order of the integer.",0,[[]]],[11,"reverse_bits","","Reverses the bit pattern of the integer.",0,[[]]],[11,"from_be","","Converts an integer from big endian to the target\'s…",0,[[]]],[11,"from_le","","Converts an integer from little endian to the target\'s…",0,[[]]],[11,"to_be","","Converts `self` to big endian from the target\'s endianness.",0,[[]]],[11,"to_le","","Converts `self` to little endian from the target\'s…",0,[[]]],[11,"pow","","Raises self to the power of `exp`, using exponentiation by…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"abs","","Computes the absolute value of `self`, wrapping around at…",0,[[],["wrapping",3]]],[11,"signum","","Returns a number representing sign of `self`.",0,[[],["wrapping",3]]],[11,"is_positive","","Returns `true` if `self` is positive and `false` if the…",0,[[]]],[11,"is_negative","","Returns `true` if `self` is negative and `false` if the…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"leading_zeros","","Returns the number of leading zeros in the binary…",0,[[]]],[11,"is_power_of_two","","Returns `true` if and only if `self == 2^k` for some `k`.",0,[[]]],[11,"next_power_of_two","","Returns the smallest power of two greater than or equal to…",0,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",3,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",3,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",3,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",4,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",4,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",4,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",5,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",5,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",5,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",6,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",6,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",6,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",7,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",7,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",7,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",8,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",8,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",8,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",9,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",9,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",9,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",10,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",10,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",10,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",11,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",11,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",11,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",12,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",12,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",12,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",13,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",13,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",13,[[]]],[11,"new_unchecked","","Creates a non-zero without checking the value.",14,[[]]],[11,"new","","Creates a non-zero if the given value is not zero.",14,[[],["option",4]]],[11,"get","","Returns the value as a primitive type.",14,[[]]],[11,"kind","","Outputs the detailed cause of parsing an integer failing.",15,[[],["interrorkind",4]]],[0,"prelude","core","The libcore prelude",null,null],[0,"v1","core::prelude","The core prelude",null,null],[0,"hint","core","Hints to compiler that affects how code should be emitted…",null,null],[5,"unreachable_unchecked","core::hint","Informs the compiler that this point in the code is not…",null,[[]]],[5,"spin_loop","","Emits a machine instruction hinting to the processor that…",null,[[]]],[5,"black_box","","An identity function that hints to the compiler to be…",null,[[]]],[0,"intrinsics","core","Compiler intrinsics.",null,null],[5,"copy_nonoverlapping","core::intrinsics","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at…",null,[[]]],[5,"atomic_cxchg","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,null],[5,"atomic_load","","Loads the current value of the pointer.",null,null],[5,"atomic_load_acq","","Loads the current value of the pointer.",null,null],[5,"atomic_load_relaxed","","Loads the current value of the pointer.",null,null],[5,"atomic_load_unordered","","",null,null],[5,"atomic_store","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_rel","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.",null,null],[5,"atomic_store_unordered","","",null,null],[5,"atomic_xchg","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_acq","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_rel","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location,…",null,null],[5,"atomic_xadd","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acq","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_rel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_acqrel","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xadd_relaxed","","Adds to the current value, returning the previous value.",null,null],[5,"atomic_xsub","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous…",null,null],[5,"atomic_and","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous…",null,null],[5,"atomic_nand","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the…",null,null],[5,"atomic_or","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous…",null,null],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous…",null,null],[5,"atomic_max","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acq","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_rel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_acqrel","","Maximum with the current value using a signed comparison.",null,null],[5,"atomic_max_relaxed","","Maximum with the current value.",null,null],[5,"atomic_min","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acq","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_rel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_acqrel","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_min_relaxed","","Minimum with the current value using a signed comparison.",null,null],[5,"atomic_umin","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_acq","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_rel","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_acqrel","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umin_relaxed","","Minimum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_acq","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_rel","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_acqrel","","Maximum with the current value using an unsigned comparison.",null,null],[5,"atomic_umax_relaxed","","Maximum with the current value using an unsigned comparison.",null,null],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,null],[5,"atomic_fence","","An atomic fence.",null,null],[5,"atomic_fence_acq","","An atomic fence.",null,null],[5,"atomic_fence_rel","","An atomic fence.",null,null],[5,"atomic_fence_acqrel","","An atomic fence.",null,null],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acq","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_rel","","A compiler-only memory barrier.",null,null],[5,"atomic_singlethreadfence_acqrel","","A compiler-only memory barrier.",null,null],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes…",null,null],[5,"abort","","Aborts the execution of the process.",null,null],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,…",null,null],[5,"assume","","Informs the optimizer that a condition is always true. If…",null,null],[5,"likely","","Hints to the compiler that branch condition is likely to…",null,null],[5,"unlikely","","Hints to the compiler that branch condition is likely to…",null,null],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,null],[5,"size_of","","The size of a type in bytes.",null,null],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,null],[5,"min_align_of","","The minimum alignment of a type.",null,null],[5,"pref_align_of","","The prefered alignment of a type.",null,null],[5,"size_of_val","","The size of the referenced value in bytes.",null,null],[5,"min_align_of_val","","The required alignment of the referenced value.",null,null],[5,"type_name","","Gets a static string slice containing the name of a type.",null,null],[5,"type_id","","Gets an identifier which is globally unique to the…",null,null],[5,"assert_inhabited","","A guard for unsafe functions that cannot ever be executed…",null,null],[5,"assert_zero_valid","","A guard for unsafe functions that cannot ever be executed…",null,null],[5,"assert_uninit_valid","","A guard for unsafe functions that cannot ever be executed…",null,null],[5,"caller_location","","Gets a reference to a static `Location` indicating where…",null,null],[5,"forget","","Moves a value out of scope without running drop glue.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,null],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires…",null,null],[5,"offset","","Calculates the offset from a pointer.",null,null],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,null],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*`…",null,null],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*`…",null,null],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*`…",null,null],[5,"volatile_load","","Performs a volatile load from the `src` pointer.",null,null],[5,"volatile_store","","Performs a volatile store to the `dst` pointer.",null,null],[5,"unaligned_volatile_load","","Performs a volatile load from the `src` pointer The…",null,null],[5,"unaligned_volatile_store","","Performs a volatile store to the `dst` pointer. The…",null,null],[5,"sqrtf32","","Returns the square root of an `f32`",null,null],[5,"sqrtf64","","Returns the square root of an `f64`",null,null],[5,"powif32","","Raises an `f32` to an integer power.",null,null],[5,"powif64","","Raises an `f64` to an integer power.",null,null],[5,"sinf32","","Returns the sine of an `f32`.",null,null],[5,"sinf64","","Returns the sine of an `f64`.",null,null],[5,"cosf32","","Returns the cosine of an `f32`.",null,null],[5,"cosf64","","Returns the cosine of an `f64`.",null,null],[5,"powf32","","Raises an `f32` to an `f32` power.",null,null],[5,"powf64","","Raises an `f64` to an `f64` power.",null,null],[5,"expf32","","Returns the exponential of an `f32`.",null,null],[5,"expf64","","Returns the exponential of an `f64`.",null,null],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,null],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,null],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,null],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,null],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,null],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,null],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,null],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,null],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,null],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,null],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,null],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,null],[5,"minnumf32","","Returns the minimum of two `f32` values.",null,null],[5,"minnumf64","","Returns the minimum of two `f64` values.",null,null],[5,"maxnumf32","","Returns the maximum of two `f32` values.",null,null],[5,"maxnumf64","","Returns the maximum of two `f64` values.",null,null],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,null],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,null],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,null],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,null],[5,"ceilf32","","Returns the smallest integer greater than or equal to an…",null,null],[5,"ceilf64","","Returns the smallest integer greater than or equal to an…",null,null],[5,"truncf32","","Returns the integer part of an `f32`.",null,null],[5,"truncf64","","Returns the integer part of an `f64`.",null,null],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an…",null,null],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an…",null,null],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,null],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,null],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way…",null,null],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way…",null,null],[5,"fadd_fast","","Float addition that allows optimizations based on…",null,null],[5,"fsub_fast","","Float subtraction that allows optimizations based on…",null,null],[5,"fmul_fast","","Float multiplication that allows optimizations based on…",null,null],[5,"fdiv_fast","","Float division that allows optimizations based on…",null,null],[5,"frem_fast","","Float remainder that allows optimizations based on…",null,null],[5,"float_to_int_unchecked","","Convert with LLVM’s fptoui/fptosi, which may return undef…",null,null],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,null],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an…",null,null],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when…",null,null],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an…",null,null],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when…",null,null],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,null],[5,"bitreverse","","Reverses the bits in an integer type `T`.",null,null],[5,"add_with_overflow","","Performs checked integer addition.",null,null],[5,"sub_with_overflow","","Performs checked integer subtraction",null,null],[5,"mul_with_overflow","","Performs checked integer multiplication",null,null],[5,"exact_div","","Performs an exact division, resulting in undefined…",null,null],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined…",null,null],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting…",null,null],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined…",null,null],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined…",null,null],[5,"unchecked_add","","Returns the result of an unchecked addition, resulting in…",null,null],[5,"unchecked_sub","","Returns the result of an unchecked subtraction, resulting…",null,null],[5,"unchecked_mul","","Returns the result of an unchecked multiplication,…",null,null],[5,"rotate_left","","Performs rotate left.",null,null],[5,"rotate_right","","Performs rotate right.",null,null],[5,"wrapping_add","","Returns (a + b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_sub","","Returns (a - b) mod 2N, where N is the width of T in bits.",null,null],[5,"wrapping_mul","","Returns (a * b) mod 2N, where N is the width of T in bits.",null,null],[5,"saturating_add","","Computes `a + b`, while saturating at numeric bounds.",null,null],[5,"saturating_sub","","Computes `a - b`, while saturating at numeric bounds.",null,null],[5,"discriminant_value","","Returns the value of the discriminant for the variant in…",null,null],[5,"try","","Rust\'s \\\"try catch\\\" construct which invokes the function…",null,null],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their…",null,null],[5,"ptr_offset_from","","See documentation of `<*const T>::offset_from` for details.",null,null],[5,"miri_start_panic","","Internal hook used by Miri to implement unwinding. ICEs…",null,null],[0,"mem","core","Basic functions for dealing with memory.",null,null],[3,"ManuallyDrop","core::mem","A wrapper to inhibit compiler from automatically calling…",null,null],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[19,"MaybeUninit","","A wrapper type to construct uninitialized instances of `T`.",null,null],[5,"forget","","Takes ownership and \\\"forgets\\\" about the value without…",null,[[]]],[5,"forget_unsized","","Like [`forget`], but also accepts unsized values.",null,[[["sized",8]]]],[5,"size_of","","Returns the size of a type in bytes.",null,[[]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,[[]]],[5,"size_of_val_raw","","Returns the size of the pointed-to value in bytes.",null,[[]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"align_of_val_raw","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"needs_drop","","Returns `true` if dropping values of type `T` matters.",null,[[]]],[5,"zeroed","","Returns the value of type `T` represented by the all-zero…",null,[[]]],[5,"uninitialized","","Bypasses Rust\'s normal memory-initialization checks by…",null,[[]]],[5,"swap","","Swaps the values at two mutable locations, without…",null,[[]]],[5,"take","","Replaces `dest` with the default value of `T`, returning…",null,[[],["default",8]]],[5,"replace","","Moves `src` into the referenced `dest`, returning the…",null,[[]]],[5,"drop","","Disposes of a value.",null,[[]]],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src`…",null,[[]]],[5,"discriminant","","Returns a value uniquely identifying the enum variant in…",null,[[],["discriminant",3]]],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,null],[11,"new","","Wrap a value to be manually dropped.",16,[[],["manuallydrop",3]]],[11,"into_inner","","Extracts the value from the `ManuallyDrop` container.",16,[[["manuallydrop",3]]]],[11,"take","","Takes the value from the `ManuallyDrop<T>` container out.",16,[[["manuallydrop",3]]]],[11,"drop","","Manually drops the contained value. This is exactly…",16,[[["manuallydrop",3]]]],[11,"new","","Creates a new `MaybeUninit<T>` initialized with the given…",17,[[],["maybeuninit",19]]],[11,"uninit","","Creates a new `MaybeUninit<T>` in an uninitialized state.",17,[[],["maybeuninit",19]]],[11,"uninit_array","","Create a new array of `MaybeUninit<T>` items, in an…",17,[[]]],[18,"UNINIT","","A promotable constant, equivalent to `uninit()`.",17,null],[11,"zeroed","","Creates a new `MaybeUninit<T>` in an uninitialized state,…",17,[[],["maybeuninit",19]]],[11,"write","","Sets the value of the `MaybeUninit<T>`. This overwrites…",17,[[]]],[11,"as_ptr","","Gets a pointer to the contained value. Reading from this…",17,[[]]],[11,"as_mut_ptr","","Gets a mutable pointer to the contained value. Reading…",17,[[]]],[11,"assume_init","","Extracts the value from the `MaybeUninit<T>` container.…",17,[[]]],[11,"read","","Reads the value from the `MaybeUninit<T>` container. The…",17,[[]]],[11,"get_ref","","Gets a shared reference to the contained value.",17,[[]]],[11,"get_mut","","Gets a mutable (unique) reference to the contained value.",17,[[]]],[11,"slice_get_ref","","Assuming all the elements are initialized, get a slice to…",17,[[]]],[11,"slice_get_mut","","Assuming all the elements are initialized, get a mutable…",17,[[]]],[11,"first_ptr","","Gets a pointer to the first element of the array.",17,[[]]],[11,"first_ptr_mut","","Gets a mutable pointer to the first element of the array.",17,[[]]],[0,"ptr","core","Manually manage memory through raw pointers.",null,null],[3,"NonNull","core::ptr","`*mut T` but non-zero and covariant.",null,null],[5,"copy_nonoverlapping","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at…",null,[[]]],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,[[]]],[5,"null","","Creates a null raw pointer.",null,[[]]],[5,"null_mut","","Creates a null mutable raw pointer.",null,[[]]],[5,"slice_from_raw_parts","","Forms a raw slice from a pointer and a length.",null,[[]]],[5,"slice_from_raw_parts_mut","","Performs the same functionality as…",null,[[]]],[5,"swap","","Swaps the values at two mutable locations of the same…",null,[[]]],[5,"swap_nonoverlapping","","Swaps `count * size_of::<T>()` bytes between the two…",null,[[]]],[5,"replace","","Moves `src` into the pointed `dst`, returning the previous…",null,[[]]],[5,"read","","Reads the value from `src` without moving it. This leaves…",null,[[]]],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves…",null,[[]]],[5,"write","","Overwrites a memory location with the given value without…",null,[[]]],[5,"write_unaligned","","Overwrites a memory location with the given value without…",null,[[]]],[5,"read_volatile","","Performs a volatile read of the value from `src` without…",null,[[]]],[5,"write_volatile","","Performs a volatile write of a memory location with the…",null,[[]]],[5,"eq","","Compares raw pointers for equality.",null,[[]]],[5,"hash","","Hash a raw pointer.",null,[[]]],[11,"dangling","","Creates a new `NonNull` that is dangling, but well-aligned.",18,[[]]],[11,"new_unchecked","","Creates a new `NonNull`.",18,[[]]],[11,"new","","Creates a new `NonNull` if `ptr` is non-null.",18,[[],["option",4]]],[11,"as_ptr","","Acquires the underlying `*mut` pointer.",18,[[]]],[11,"as_ref","","Dereferences the content.",18,[[]]],[11,"as_mut","","Mutably dereferences the content.",18,[[]]],[11,"cast","","Casts to a pointer of another type.",18,[[],["nonnull",3]]],[11,"slice_from_raw_parts","","Creates a non-null raw slice from a thin pointer and a…",18,[[["nonnull",3]]]],[11,"len","","Returns the length of a non-null raw slice.",18,[[]]],[0,"borrow","core","A module for working with borrowed data.",null,null],[8,"Borrow","core::borrow","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",19,[[]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",20,[[]]],[0,"clone","core","The `Clone` trait for types that cannot be \'implicitly…",null,null],[8,"Clone","core::clone","A common trait for the ability to explicitly duplicate an…",null,null],[10,"clone","","Returns a copy of the value.",21,[[]]],[11,"clone_from","","Performs copy-assignment from `source`.",21,[[]]],[0,"cmp","core","Functionality for ordering and comparison.",null,null],[3,"Reverse","core::cmp","A helper struct for reverse ordering.",null,null],[12,"0","","",22,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two…",null,null],[13,"Less","","An ordering where a compared value is less than another.",23,null],[13,"Equal","","An ordering where a compared value is equal to another.",23,null],[13,"Greater","","An ordering where a compared value is greater than another.",23,null],[5,"min","","Compares and returns the minimum of two values.",null,[[["ord",8]],["ord",8]]],[5,"min_by","","Returns the minimum of two values with respect to the…",null,[[["fnonce",8]]]],[5,"min_by_key","","Returns the element that gives the minimum value from the…",null,[[["fnmut",8]]]],[5,"max","","Compares and returns the maximum of two values.",null,[[["ord",8]],["ord",8]]],[5,"max_by","","Returns the maximum of two values with respect to the…",null,[[["fnonce",8]]]],[5,"max_by_key","","Returns the element that gives the maximum value from the…",null,[[["fnmut",8]]]],[8,"PartialEq","","Trait for equality comparisons which are partial…",null,null],[10,"eq","","This method tests for `self` and `other` values to be…",24,[[]]],[11,"ne","","This method tests for `!=`.",24,[[]]],[8,"Eq","","Trait for equality comparisons which are equivalence…",null,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an [`Ordering`] between `self` and…",25,[[],["ordering",4]]],[11,"max","","Compares and returns the maximum of two values.",25,[[]]],[11,"min","","Compares and returns the minimum of two values.",25,[[]]],[11,"clamp","","Restrict a value to a certain interval.",25,[[]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other`…",26,[[],[["ordering",4],["option",4]]]],[11,"lt","","This method tests less than (for `self` and `other`) and…",26,[[]]],[11,"le","","This method tests less than or equal to (for `self` and…",26,[[]]],[11,"gt","","This method tests greater than (for `self` and `other`)…",26,[[]]],[11,"ge","","This method tests greater than or equal to (for `self` and…",26,[[]]],[11,"reverse","","Reverses the `Ordering`.",23,[[],["ordering",4]]],[11,"then","","Chains two orderings.",23,[[["ordering",4]],["ordering",4]]],[11,"then_with","","Chains the ordering with the given function.",23,[[["fnonce",8]],["ordering",4]]],[0,"convert","core","Traits for conversions between types.",null,null],[4,"Infallible","core::convert","The error type for errors that can never happen.",null,null],[5,"identity","","The identity function.",null,[[]]],[8,"FloatToInt","","Supporting trait for inherent methods of `f32` and `f64`…",null,null],[8,"AsRef","","Used to do a cheap reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",27,[[]]],[8,"AsMut","","Used to do a cheap mutable-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",28,[[]]],[8,"Into","","A value-to-value conversion that consumes the input value.…",null,null],[10,"into","","Performs the conversion.",29,[[]]],[8,"From","","Used to do value-to-value conversions while consuming the…",null,null],[10,"from","","Performs the conversion.",30,[[]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or…",null,null],[16,"Error","","The type returned in the event of a conversion error.",31,null],[10,"try_into","","Performs the conversion.",31,[[],["result",4]]],[8,"TryFrom","","Simple and safe type conversions that may fail in a…",null,null],[16,"Error","","The type returned in the event of a conversion error.",32,null],[10,"try_from","","Performs the conversion.",32,[[],["result",4]]],[0,"default","core","The `Default` trait for types which may have meaningful…",null,null],[8,"Default","core::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \\\"default value\\\" for a type.",33,[[]]],[0,"marker","core","Primitive traits and types representing basic properties…",null,null],[3,"PhantomData","core::marker","Zero-sized type used to mark things that \\\"act like\\\" they…",null,null],[3,"PhantomPinned","","A marker type which does not implement `Unpin`.",null,null],[8,"Send","","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \\\"unsized\\\" to a dynamically-sized type.",null,null],[8,"StructuralPartialEq","","Required trait for constants used in pattern matches.",null,null],[8,"StructuralEq","","Required trait for constants used in pattern matches.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between…",null,null],[8,"DiscriminantKind","","Compiler-internal trait used to indicate the type of enum…",null,null],[16,"Discriminant","","The type of the dicriminant, which must satisfy the trait…",34,null],[8,"Unpin","","Types that can be safely moved after being pinned.",null,null],[0,"ops","core","Overloadable operators.",null,null],[3,"Range","core::ops","A (half-open) range bounded inclusively below and…",null,null],[12,"start","","The lower bound of the range (inclusive).",35,null],[12,"end","","The upper bound of the range (exclusive).",35,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",36,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",37,null],[3,"RangeInclusive","","A range bounded inclusively below and above (`start..=end`).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",38,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",39,null],[13,"Excluded","","An exclusive bound.",39,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in…",39,null],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",40,null],[13,"Complete","","The generator completed with a return value.",40,null],[11,"contains","","Returns `true` if `item` is contained in the range.",35,[[]]],[11,"is_empty","","Returns `true` if the range contains no items.",35,[[]]],[11,"contains","","Returns `true` if `item` is contained in the range.",36,[[]]],[11,"contains","","Returns `true` if `item` is contained in the range.",37,[[]]],[11,"new","","Creates a new inclusive range. Equivalent to writing…",41,[[]]],[11,"start","","Returns the lower bound of the range (inclusive).",41,[[]]],[11,"end","","Returns the upper bound of the range (inclusive).",41,[[]]],[11,"into_inner","","Destructures the `RangeInclusive` into (lower bound, upper…",41,[[]]],[11,"contains","","Returns `true` if `item` is contained in the range.",41,[[]]],[11,"is_empty","","Returns `true` if the range contains no items.",41,[[]]],[11,"contains","","Returns `true` if `item` is contained in the range.",38,[[]]],[11,"cloned","","Map a `Bound<&T>` to a `Bound<T>` by cloning the contents…",39,[[],["bound",4]]],[8,"Add","","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",42,null],[10,"add","","Performs the `+` operation.",42,[[]]],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",43,null],[10,"div","","Performs the `/` operation.",43,[[]]],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",44,null],[10,"mul","","Performs the `*` operation.",44,[[]]],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",45,null],[10,"neg","","Performs the unary `-` operation.",45,[[]]],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",46,null],[10,"rem","","Performs the `%` operation.",46,[[]]],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",47,null],[10,"sub","","Performs the `-` operation.",47,[[]]],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",48,[[]]],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",49,[[]]],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",50,[[]]],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",51,[[]]],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",52,[[]]],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",53,null],[10,"bitand","","Performs the `&` operation.",53,[[]]],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",54,null],[10,"bitor","","Performs the `|` operation.",54,[[]]],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",55,null],[10,"bitxor","","Performs the `^` operation.",55,[[]]],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",56,null],[10,"not","","Performs the unary `!` operation.",56,[[]]],[8,"Shl","","The left shift operator `<<`. Note that because this trait…",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",57,null],[10,"shl","","Performs the `<<` operation.",57,[[]]],[8,"Shr","","The right shift operator `>>`. Note that because this…",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",58,null],[10,"shr","","Performs the `>>` operation.",58,[[]]],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",59,[[]]],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",60,[[]]],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",61,[[]]],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",62,[[]]],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",63,[[]]],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",64,null],[10,"deref","","Dereferences the value.",64,[[]]],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v =…",null,null],[10,"deref_mut","","Mutably dereferences the value.",65,[[]]],[8,"Drop","","Custom code within the destructor.",null,null],[10,"drop","","Executes the destructor for this type.",66,[[]]],[8,"Fn","","The version of the call operator that takes an immutable…",null,null],[10,"call","","Performs the call operation.",67,[[]]],[8,"FnMut","","The version of the call operator that takes a mutable…",null,null],[10,"call_mut","","Performs the call operation.",68,[[]]],[8,"FnOnce","","The version of the call operator that takes a by-value…",null,null],[16,"Output","","The returned type after the call operator is used.",69,null],[10,"call_once","","Performs the call operation.",69,[[]]],[8,"Index","","Used for indexing operations (`container[index]`) in…",null,null],[16,"Output","","The returned type after indexing.",70,null],[10,"index","","Performs the indexing (`container[index]`) operation.",70,[[]]],[8,"IndexMut","","Used for indexing operations (`container[index]`) in…",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`)…",71,[[]]],[8,"RangeBounds","","`RangeBounds` is implemented by Rust\'s built-in range…",null,null],[10,"start_bound","","Start index bound.",72,[[],["bound",4]]],[10,"end_bound","","End index bound.",72,[[],["bound",4]]],[11,"contains","","Returns `true` if `item` is contained in the range.",72,[[]]],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",73,null],[16,"Error","","The type of this value when viewed as failed.",73,null],[10,"into_result","","Applies the \\\"?\\\" operator. A return of `Ok(t)` means that…",73,[[],["result",4]]],[10,"from_error","","Wrap an error value to construct the composite result. For…",73,[[]]],[10,"from_ok","","Wrap an OK value to construct the composite result. For…",73,[[]]],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",74,null],[16,"Return","","The type of value this generator returns.",74,null],[10,"resume","","Resumes the execution of this generator.",74,[[["pin",3]],["generatorstate",4]]],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper…",null,null],[8,"DispatchFromDyn","","This is used for object safety, to check that a method\'s…",null,null],[0,"any","core","This module implements the `Any` trait, which enables…",null,null],[3,"TypeId","core::any","A `TypeId` represents a globally unique identifier for a…",null,null],[5,"type_name","","Returns the name of a type as a string slice.",null,[[]]],[5,"type_name_of_val","","Returns the name of the type of the pointed-to value as a…",null,[[]]],[8,"Any","","A trait to emulate dynamic typing.",null,null],[10,"type_id","","Gets the `TypeId` of `self`.",75,[[],["typeid",3]]],[11,"is","","Returns `true` if the boxed type is the same as `T`.",75,[[]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type…",75,[[],["option",4]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is…",75,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type `Any`.",75,[[]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",75,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",75,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type `Any`.",75,[[]]],[11,"downcast_ref","","Forwards to the method defined on the type `Any`.",75,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type `Any`.",75,[[],["option",4]]],[11,"of","","Returns the `TypeId` of the type this generic function has…",76,[[],["typeid",3]]],[0,"array","core","Implementations of things like `Eq` for fixed-length…",null,null],[3,"IntoIter","core::array","A by-value [array] iterator.",null,null],[3,"TryFromSliceError","","The error type returned when a conversion from a slice to…",null,null],[11,"new","","Creates a new iterator over the given `array`.",77,[[]]],[8,"FixedSizeArray","","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",78,[[]]],[10,"as_mut_slice","","Converts the array to mutable slice",78,[[]]],[8,"LengthAtMost32","","Implemented for lengths where trait impls are allowed on…",null,null],[0,"ascii","core","Operations on ASCII strings and characters.",null,null],[3,"EscapeDefault","core::ascii","An iterator over the escaped version of a byte.",null,null],[5,"escape_default","","Returns an iterator that produces an escaped version of a…",null,[[],["escapedefault",3]]],[0,"cell","core","Shareable mutable containers.",null,null],[3,"Cell","core::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow…",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.…",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a…",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[11,"new","","Creates a new `Cell` containing the given value.",79,[[],["cell",3]]],[11,"set","","Sets the contained value.",79,[[]]],[11,"swap","","Swaps the values of two Cells. Difference with…",79,[[]]],[11,"replace","","Replaces the contained value, and returns it.",79,[[]]],[11,"into_inner","","Unwraps the value.",79,[[]]],[11,"get","","Returns a copy of the contained value.",79,[[]]],[11,"update","","Updates the contained value using a function and returns…",79,[[]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",79,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",79,[[]]],[11,"from_mut","","Returns a `&Cell<T>` from a `&mut T`",79,[[],["cell",3]]],[11,"take","","Takes the value of the cell, leaving `Default::default()`…",79,[[]]],[11,"as_slice_of_cells","","Returns a `&[Cell<T>]` from a `&Cell<[T]>`",79,[[]]],[11,"new","","Creates a new `RefCell` containing `value`.",80,[[],["refcell",3]]],[11,"into_inner","","Consumes the `RefCell`, returning the wrapped value.",80,[[]]],[11,"replace","","Replaces the wrapped value with a new one, returning the…",80,[[]]],[11,"replace_with","","Replaces the wrapped value with a new one computed from…",80,[[["fnonce",8]]]],[11,"swap","","Swaps the wrapped value of `self` with the wrapped value…",80,[[]]],[11,"borrow","","Immutably borrows the wrapped value.",80,[[],["ref",3]]],[11,"try_borrow","","Immutably borrows the wrapped value, returning an error if…",80,[[],[["result",4],["ref",3],["borrowerror",3]]]],[11,"borrow_mut","","Mutably borrows the wrapped value.",80,[[],["refmut",3]]],[11,"try_borrow_mut","","Mutably borrows the wrapped value, returning an error if…",80,[[],[["refmut",3],["result",4],["borrowmuterror",3]]]],[11,"as_ptr","","Returns a raw pointer to the underlying data in this cell.",80,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying data.",80,[[]]],[11,"undo_leak","","Undo the effect of leaked guards on the borrow state of…",80,[[]]],[11,"try_borrow_unguarded","","Immutably borrows the wrapped value, returning an error if…",80,[[],[["borrowerror",3],["result",4]]]],[11,"take","","Takes the wrapped value, leaving `Default::default()` in…",80,[[]]],[11,"clone","","Copies a `Ref`.",81,[[["ref",3]],["ref",3]]],[11,"map","","Makes a new `Ref` for a component of the borrowed data.",81,[[["ref",3]],[["sized",8],["ref",3]]]],[11,"map_split","","Splits a `Ref` into multiple `Ref`s for different…",81,[[["ref",3]]]],[11,"leak","","Convert into a reference to the underlying data.",81,[[["ref",3]]]],[11,"map","","Makes a new `RefMut` for a component of the borrowed data,…",82,[[["refmut",3]],[["sized",8],["refmut",3]]]],[11,"map_split","","Splits a `RefMut` into multiple `RefMut`s for different…",82,[[["refmut",3]]]],[11,"leak","","Convert into a mutable reference to the underlying data.",82,[[["refmut",3]]]],[11,"new","","Constructs a new instance of `UnsafeCell` which will wrap…",83,[[],["unsafecell",3]]],[11,"into_inner","","Unwraps the value.",83,[[]]],[11,"get","","Gets a mutable pointer to the wrapped value.",83,[[]]],[11,"raw_get","","Gets a mutable pointer to the wrapped value. The…",83,[[]]],[0,"char","core","A character type.",null,null],[3,"CharTryFromError","core::char","The error type returned when a conversion from u32 to char…",null,null],[3,"ParseCharError","","An error which can be returned when parsing a char.",null,null],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from…",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code…",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode…",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent…",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent…",null,null],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,[[]]],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,[[],["option",4]]],[5,"from_u32","","Converts a `u32` to a `char`.",null,[[],["option",4]]],[5,"decode_utf16","","Creates an iterator over the UTF-16 encoded code points in…",null,[[["intoiterator",8]],["decodeutf16",3]]],[11,"unpaired_surrogate","","Returns the unpaired surrogate which caused this error.",84,[[]]],[17,"MAX","","The highest valid code point a `char` can have.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to…",null,null],[0,"ffi","core","Utilities related to FFI bindings.",null,null],[3,"VaListImpl","core::ffi","Basic implementation of a `va_list`.",null,null],[3,"VaList","","A wrapper for a `va_list`",null,null],[4,"c_void","","Equivalent to C\'s `void` type when used as a [pointer].",null,null],[11,"as_va_list","","Convert a `VaListImpl` into a `VaList` that is…",85,[[],["valist",3]]],[11,"arg","","Advance to the next arg.",85,[[],["vaargsafe",8]]],[11,"with_copy","","Copies the `va_list` at the current location.",85,[[]]],[0,"iter","core","Composable external iteration.",null,null],[3,"Empty","core::iter","An iterator that yields nothing.",null,null],[3,"FromFn","","An iterator where each iteration calls the provided…",null,null],[3,"Once","","An iterator that yields an element exactly once.",null,null],[3,"OnceWith","","An iterator that yields a single element of type `A` by…",null,null],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by…",null,null],[3,"Successors","","An new iterator where each successive item is computed…",null,null],[3,"Cloned","","An iterator that clones the elements of an underlying…",null,null],[3,"Copied","","An iterator that copies the elements of an underlying…",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an…",null,null],[3,"MapWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that links two iterators together, in a chain.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element…",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with…",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements…",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Zip","","An iterator that iterates two other iterators…",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and…",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional…",null,null],[3,"Scan","","An iterator to maintain state while iterating another…",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate`…",null,null],[3,"Take","","An iterator that only iterates over the first `n`…",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"Fuse","","An iterator that yields `None` forever after the…",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each…",null,null],[5,"empty","","Creates an iterator that yields nothing.",null,[[],["empty",3]]],[5,"from_fn","","Creates a new iterator where each iteration calls the…",null,[[],["fromfn",3]]],[5,"once","","Creates an iterator that yields an element exactly once.",null,[[],["once",3]]],[5,"once_with","","Creates an iterator that lazily generates a value exactly…",null,[[["fnonce",8]],[["fnonce",8],["oncewith",3]]]],[5,"repeat","","Creates a new iterator that endlessly repeats a single…",null,[[["clone",8]],[["clone",8],["repeat",3]]]],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A`…",null,[[["fnmut",8]],[["fnmut",8],["repeatwith",3]]]],[5,"successors","","Creates a new iterator where each successive item is…",null,[[["option",4]],["successors",3]]],[11,"peek","","Returns a reference to the next() value without advancing…",86,[[],["option",4]]],[11,"next_if","","Consume the next value of this iterator if a condition is…",86,[[],["option",4]]],[11,"next_if_eq","","Consume the next item if it is equal to `expected`.",86,[[],["option",4]]],[8,"Iterator","","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",87,null],[10,"next","","Advances the iterator and returns the next value.",87,[[],["option",4]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",87,[[]]],[11,"count","","Consumes the iterator, counting the number of iterations…",87,[[]]],[11,"last","","Consumes the iterator, returning the last element.",87,[[],["option",4]]],[11,"nth","","Returns the `n`th element of the iterator.",87,[[],["option",4]]],[11,"step_by","","Creates an iterator starting at the same point, but…",87,[[],["stepby",3]]],[11,"chain","","Takes two iterators and creates a new iterator over both…",87,[[],["chain",3]]],[11,"zip","","\'Zips up\' two iterators into a single iterator of pairs.",87,[[],["zip",3]]],[11,"map","","Takes a closure and creates an iterator which calls that…",87,[[],["map",3]]],[11,"for_each","","Calls a closure on each element of an iterator.",87,[[]]],[11,"filter","","Creates an iterator which uses a closure to determine if…",87,[[],["filter",3]]],[11,"filter_map","","Creates an iterator that both filters and maps.",87,[[],["filtermap",3]]],[11,"enumerate","","Creates an iterator which gives the current iteration…",87,[[],["enumerate",3]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the…",87,[[],["peekable",3]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a…",87,[[],["skipwhile",3]]],[11,"take_while","","Creates an iterator that yields elements based on a…",87,[[],["takewhile",3]]],[11,"map_while","","Creates an iterator that both yields elements based on a…",87,[[],["mapwhile",3]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",87,[[],["skip",3]]],[11,"take","","Creates an iterator that yields its first `n` elements.",87,[[],["take",3]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds…",87,[[],["scan",3]]],[11,"flat_map","","Creates an iterator that works like map, but flattens…",87,[[],["flatmap",3]]],[11,"flatten","","Creates an iterator that flattens nested structure.",87,[[],["flatten",3]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",87,[[],["fuse",3]]],[11,"inspect","","Does something with each element of an iterator, passing…",87,[[],["inspect",3]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",87,[[]]],[11,"collect","","Transforms an iterator into a collection.",87,[[],["fromiterator",8]]],[11,"partition","","Consumes an iterator, creating two collections from it.",87,[[]]],[11,"partition_in_place","","Reorders the elements of this iterator in-place according…",87,[[]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned…",87,[[]]],[11,"try_fold","","An iterator method that applies a function as long as it…",87,[[]]],[11,"try_for_each","","An iterator method that applies a fallible function to…",87,[[]]],[11,"fold","","An iterator method that applies a function, producing a…",87,[[]]],[11,"fold_first","","The same as `fold()`, but uses the first element in the…",87,[[],["option",4]]],[11,"all","","Tests if every element of the iterator matches a predicate.",87,[[]]],[11,"any","","Tests if any element of the iterator matches a predicate.",87,[[]]],[11,"find","","Searches for an element of an iterator that satisfies a…",87,[[],["option",4]]],[11,"find_map","","Applies function to the elements of iterator and returns…",87,[[],["option",4]]],[11,"try_find","","Applies function to the elements of iterator and returns…",87,[[],[["option",4],["result",4]]]],[11,"position","","Searches for an element in an iterator, returning its index.",87,[[],["option",4]]],[11,"rposition","","Searches for an element in an iterator from the right,…",87,[[],["option",4]]],[11,"max","","Returns the maximum element of an iterator.",87,[[],["option",4]]],[11,"min","","Returns the minimum element of an iterator.",87,[[],["option",4]]],[11,"max_by_key","","Returns the element that gives the maximum value from the…",87,[[],["option",4]]],[11,"max_by","","Returns the element that gives the maximum value with…",87,[[],["option",4]]],[11,"min_by_key","","Returns the element that gives the minimum value from the…",87,[[],["option",4]]],[11,"min_by","","Returns the element that gives the minimum value with…",87,[[],["option",4]]],[11,"rev","","Reverses an iterator\'s direction.",87,[[],["rev",3]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",87,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",87,[[],["copied",3]]],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",87,[[],["cloned",3]]],[11,"cycle","","Repeats an iterator endlessly.",87,[[],["cycle",3]]],[11,"sum","","Sums the elements of an iterator.",87,[[]]],[11,"product","","Iterates over the entire iterator, multiplying all the…",87,[[]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[],["ordering",4]]],[11,"cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[],["ordering",4]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[],[["ordering",4],["option",4]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to…",87,[[]]],[11,"eq_by","","Determines if the elements of this `Iterator` are equal to…",87,[[]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal…",87,[[]]],[11,"lt","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"le","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"gt","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"ge","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",87,[[]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using…",87,[[]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using…",87,[[]]],[8,"Step","","Objects that have a notion of successor and predecessor…",null,null],[10,"steps_between","","Returns the number of successor steps required to get from…",88,[[],["option",4]]],[10,"forward_checked","","Returns the value that would be obtained by taking the…",88,[[],["option",4]]],[11,"forward","","Returns the value that would be obtained by taking the…",88,[[]]],[11,"forward_unchecked","","Returns the value that would be obtained by taking the…",88,[[]]],[10,"backward_checked","","Returns the value that would be obtained by taking the…",88,[[],["option",4]]],[11,"backward","","Returns the value that would be obtained by taking the…",88,[[]]],[11,"backward_unchecked","","Returns the value that would be obtained by taking the…",88,[[]]],[8,"FusedIterator","","An iterator that always continues to yield `None` when…",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",89,[[],["option",4]]],[11,"nth_back","","Returns the `n`th element from the end of the iterator.",89,[[],["option",4]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes…",89,[[]]],[11,"rfold","","An iterator method that reduces the iterator\'s elements to…",89,[[]]],[11,"rfind","","Searches for an element of an iterator from the back that…",89,[[],["option",4]]],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",90,[[["intoiterator",8]]]],[11,"extend_one","","Extends a collection with exactly one element.",90,[[]]],[11,"extend_reserve","","Reserves capacity in a collection for the given number of…",90,[[]]],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",91,[[["intoiterator",8]]]],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",92,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",92,null],[10,"into_iter","","Creates an iterator from a value.",92,[[]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact length of the iterator.",93,[[]]],[11,"is_empty","","Returns `true` if the iterator is empty.",93,[[]]],[8,"Product","","Trait to represent types that can be created by…",null,null],[10,"product","","Method which takes an iterator and generates `Self` from…",94,[[["iterator",8]]]],[8,"Sum","","Trait to represent types that can be created by summing up…",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from…",95,[[["iterator",8]]]],[0,"option","core","Optional values.",null,null],[3,"Iter","core::option","An iterator over a reference to the [`Some`] variant of an…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`]…",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an…",null,null],[3,"NoneError","","The error type that results from applying the try operator…",null,null],[4,"Option","","The `Option` type. See the module level documentation for…",null,null],[13,"None","","No value",96,null],[13,"Some","","Some value `T`",96,null],[11,"is_some","","Returns `true` if the option is a [`Some`] value.",96,[[]]],[11,"is_none","","Returns `true` if the option is a [`None`] value.",96,[[]]],[11,"contains","","Returns `true` if the option is a [`Some`] value…",96,[[]]],[11,"as_ref","","Converts from `&Option<T>` to `Option<&T>`.",96,[[],["option",4]]],[11,"as_mut","","Converts from `&mut Option<T>` to `Option<&mut T>`.",96,[[],["option",4]]],[11,"as_pin_ref","","Converts from [`Pin`]`<&Option<T>>` to…",96,[[["pin",3]],[["option",4],["pin",3]]]],[11,"as_pin_mut","","Converts from [`Pin`]`<&mut Option<T>>` to…",96,[[["pin",3]],[["pin",3],["option",4]]]],[11,"expect","","Returns the contained [`Some`] value, consuming the `self`…",96,[[]]],[11,"unwrap","","Returns the contained [`Some`] value, consuming the `self`…",96,[[]]],[11,"unwrap_or","","Returns the contained [`Some`] value or a provided default.",96,[[]]],[11,"unwrap_or_else","","Returns the contained [`Some`] value or computes it from a…",96,[[["fnonce",8]]]],[11,"map","","Maps an `Option<T>` to `Option<U>` by applying a function…",96,[[["fnonce",8]],["option",4]]],[11,"map_or","","Applies a function to the contained value (if any), or…",96,[[["fnonce",8]]]],[11,"map_or_else","","Applies a function to the contained value (if any), or…",96,[[["fnonce",8],["fnonce",8]]]],[11,"ok_or","","Transforms the `Option<T>` into a [`Result<T, E>`],…",96,[[],["result",4]]],[11,"ok_or_else","","Transforms the `Option<T>` into a [`Result<T, E>`],…",96,[[["fnonce",8]],["result",4]]],[11,"iter","","Returns an iterator over the possibly contained value.",96,[[],["iter",3]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained…",96,[[],["itermut",3]]],[11,"and","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["option",4]],["option",4]]],[11,"and_then","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["fnonce",8]],["option",4]]],[11,"filter","","Returns [`None`] if the option is [`None`], otherwise…",96,[[["fnonce",8]]]],[11,"or","","Returns the option if it contains a value, otherwise…",96,[[["option",4]],["option",4]]],[11,"or_else","","Returns the option if it contains a value, otherwise calls…",96,[[["fnonce",8]],["option",4]]],[11,"xor","","Returns [`Some`] if exactly one of `self`, `optb` is…",96,[[["option",4]],["option",4]]],[11,"get_or_insert","","Inserts `v` into the option if it is [`None`], then…",96,[[]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the option if it is…",96,[[["fnonce",8]]]],[11,"take","","Takes the value out of the option, leaving a [`None`] in…",96,[[],["option",4]]],[11,"replace","","Replaces the actual value in the option by the value given…",96,[[],["option",4]]],[11,"zip","","Zips `self` with another `Option`.",96,[[["option",4]],["option",4]]],[11,"zip_with","","Zips `self` and another `Option` with function `f`.",96,[[["option",4]],["option",4]]],[11,"copied","","Maps an `Option<&T>` to an `Option<T>` by copying the…",96,[[],["option",4]]],[11,"copied","","Maps an `Option<&mut T>` to an `Option<T>` by copying the…",96,[[],["option",4]]],[11,"cloned","","Maps an `Option<&T>` to an `Option<T>` by cloning the…",96,[[],["option",4]]],[11,"cloned","","Maps an `Option<&mut T>` to an `Option<T>` by cloning the…",96,[[],["option",4]]],[11,"expect_none","","Consumes `self` while expecting [`None`] and returning…",96,[[]]],[11,"unwrap_none","","Consumes `self` while expecting [`None`] and returning…",96,[[]]],[11,"unwrap_or_default","","Returns the contained [`Some`] value or a default",96,[[]]],[11,"as_deref","","Converts from `Option<T>` (or `&Option<T>`) to…",96,[[],["option",4]]],[11,"as_deref_mut","","Converts from `Option<T>` (or `&mut Option<T>`) to…",96,[[],["option",4]]],[11,"transpose","","Transposes an `Option` of a [`Result`] into a [`Result`]…",96,[[],[["result",4],["option",4]]]],[11,"flatten","","Converts from `Option<Option<T>>` to `Option<T>`",96,[[],["option",4]]],[0,"panic","core","Panic support in the standard library.",null,null],[3,"PanicInfo","core::panic","A struct providing information about a panic.",null,null],[3,"Location","","A struct containing information about the location of a…",null,null],[11,"payload","","Returns the payload associated with the panic.",97,[[],["any",8]]],[11,"message","","If the `panic!` macro from the `core` crate (not from…",97,[[],[["arguments",3],["option",4]]]],[11,"location","","Returns information about the location from which the…",97,[[],[["location",3],["option",4]]]],[11,"caller","","Returns the source location of the caller of this…",98,[[],["location",3]]],[11,"file","","Returns the name of the source file from which the panic…",98,[[]]],[11,"line","","Returns the line number from which the panic originated.",98,[[]]],[11,"column","","Returns the column from which the panic originated.",98,[[]]],[0,"panicking","core","Panic support for libcore",null,null],[5,"panic","core::panicking","The underlying implementation of libcore\'s `panic!` macro…",null,[[]]],[5,"panic_fmt","","The underlying implementation of libcore\'s `panic!` macro…",null,[[["arguments",3]]]],[0,"pin","core","Types that pin data to its location in memory.",null,null],[3,"Pin","core::pin","A pinned pointer.",null,null],[11,"new","","Construct a new `Pin<P>` around a pointer to some data of…",99,[[],["pin",3]]],[11,"into_inner","","Unwraps this `Pin<P>` returning the underlying pointer.",99,[[["pin",3]]]],[11,"new_unchecked","","Construct a new `Pin<P>` around a reference to some data…",99,[[],["pin",3]]],[11,"as_ref","","Gets a pinned shared reference from this pinned pointer.",99,[[],["pin",3]]],[11,"into_inner_unchecked","","Unwraps this `Pin<P>` returning the underlying pointer.",99,[[["pin",3]]]],[11,"as_mut","","Gets a pinned mutable reference from this pinned pointer.",99,[[],["pin",3]]],[11,"set","","Assigns a new value to the memory behind the pinned…",99,[[]]],[11,"map_unchecked","","Constructs a new pin by mapping the interior value.",99,[[],["pin",3]]],[11,"get_ref","","Gets a shared reference out of a pin.",99,[[]]],[11,"into_ref","","Converts this `Pin<&mut T>` into a `Pin<&T>` with the same…",99,[[],["pin",3]]],[11,"get_mut","","Gets a mutable reference to the data inside of this `Pin`.",99,[[]]],[11,"get_unchecked_mut","","Gets a mutable reference to the data inside of this `Pin`.",99,[[]]],[11,"map_unchecked_mut","","Construct a new pin by mapping the interior value.",99,[[],["pin",3]]],[0,"raw","core","Contains struct definitions for the layout of compiler…",null,null],[3,"TraitObject","core::raw","The representation of a trait object like `&dyn SomeTrait`.",null,null],[12,"data","","",100,null],[12,"vtable","","",100,null],[0,"result","core","Error handling with the `Result` type.",null,null],[3,"Iter","core::result","An iterator over a reference to the [`Ok`] variant of a…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant…",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a…",null,null],[4,"Result","","`Result` is a type that represents either success ([`Ok`])…",null,null],[13,"Ok","","Contains the success value",101,null],[13,"Err","","Contains the error value",101,null],[11,"is_ok","","Returns `true` if the result is [`Ok`].",101,[[]]],[11,"is_err","","Returns `true` if the result is [`Err`].",101,[[]]],[11,"contains","","Returns `true` if the result is an [`Ok`] value containing…",101,[[]]],[11,"contains_err","","Returns `true` if the result is an [`Err`] value…",101,[[]]],[11,"ok","","Converts from `Result<T, E>` to [`Option<T>`].",101,[[],["option",4]]],[11,"err","","Converts from `Result<T, E>` to [`Option<E>`].",101,[[],["option",4]]],[11,"as_ref","","Converts from `&Result<T, E>` to `Result<&T, &E>`.",101,[[],["result",4]]],[11,"as_mut","","Converts from `&mut Result<T, E>` to `Result<&mut T, &mut…",101,[[],["result",4]]],[11,"map","","Maps a `Result<T, E>` to `Result<U, E>` by applying a…",101,[[["fnonce",8]],["result",4]]],[11,"map_or","","Applies a function to the contained value (if [`Ok`]), or…",101,[[["fnonce",8]]]],[11,"map_or_else","","Maps a `Result<T, E>` to `U` by applying a function to a…",101,[[["fnonce",8],["fnonce",8]]]],[11,"map_err","","Maps a `Result<T, E>` to `Result<T, F>` by applying a…",101,[[["fnonce",8]],["result",4]]],[11,"iter","","Returns an iterator over the possibly contained value.",101,[[],["iter",3]]],[11,"iter_mut","","Returns a mutable iterator over the possibly contained…",101,[[],["itermut",3]]],[11,"and","","Returns `res` if the result is [`Ok`], otherwise returns…",101,[[["result",4]],["result",4]]],[11,"and_then","","Calls `op` if the result is [`Ok`], otherwise returns the…",101,[[["fnonce",8]],["result",4]]],[11,"or","","Returns `res` if the result is [`Err`], otherwise returns…",101,[[["result",4]],["result",4]]],[11,"or_else","","Calls `op` if the result is [`Err`], otherwise returns the…",101,[[["fnonce",8]],["result",4]]],[11,"unwrap_or","","Returns the contained [`Ok`] value or a provided default.",101,[[]]],[11,"unwrap_or_else","","Returns the contained [`Ok`] value or computes it from a…",101,[[["fnonce",8]]]],[11,"copied","","Maps a `Result<&T, E>` to a `Result<T, E>` by copying the…",101,[[],["result",4]]],[11,"copied","","Maps a `Result<&mut T, E>` to a `Result<T, E>` by copying…",101,[[],["result",4]]],[11,"cloned","","Maps a `Result<&T, E>` to a `Result<T, E>` by cloning the…",101,[[],["result",4]]],[11,"cloned","","Maps a `Result<&mut T, E>` to a `Result<T, E>` by cloning…",101,[[],["result",4]]],[11,"expect","","Returns the contained [`Ok`] value, consuming the `self`…",101,[[]]],[11,"unwrap","","Returns the contained [`Ok`] value, consuming the `self`…",101,[[]]],[11,"expect_err","","Returns the contained [`Err`] value, consuming the `self`…",101,[[]]],[11,"unwrap_err","","Returns the contained [`Err`] value, consuming the `self`…",101,[[]]],[11,"unwrap_or_default","","Returns the contained [`Ok`] value or a default",101,[[]]],[11,"into_ok","","Returns the contained [`Ok`] value, but never panics.",101,[[]]],[11,"as_deref","","Converts from `Result<T, E>` (or `&Result<T, E>`) to…",101,[[],["result",4]]],[11,"as_deref_err","","Converts from `Result<T, E>` (or `&Result<T, E>`) to…",101,[[],["result",4]]],[11,"as_deref_mut","","Converts from `Result<T, E>` (or `&mut Result<T, E>`) to…",101,[[],["result",4]]],[11,"as_deref_mut_err","","Converts from `Result<T, E>` (or `&mut Result<T, E>`) to…",101,[[],["result",4]]],[11,"transpose","","Transposes a `Result` of an `Option` into an `Option` of a…",101,[[],[["option",4],["result",4]]]],[11,"flatten","","Converts from `Result<Result<T, E>, E>` to `Result<T, E>`",101,[[],["result",4]]],[0,"sync","core","Synchronization primitives",null,null],[0,"atomic","core::sync","Atomic types",null,null],[3,"AtomicBool","core::sync::atomic","A boolean type which can be safely shared between threads.",null,null],[3,"AtomicPtr","","A raw pointer type which can be safely shared between…",null,null],[3,"AtomicI8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU8","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU16","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU32","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicI64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicU64","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicIsize","","An integer type which can be safely shared between threads.",null,null],[3,"AtomicUsize","","An integer type which can be safely shared between threads.",null,null],[4,"Ordering","","Atomic memory orderings",null,null],[13,"Relaxed","","No ordering constraints, only atomic operations.",102,null],[13,"Release","","When coupled with a store, all previous operations become…",102,null],[13,"Acquire","","When coupled with a load, if the loaded value was written…",102,null],[13,"AcqRel","","Has the effects of both [`Acquire`] and [`Release`]…",102,null],[13,"SeqCst","","Like [`Acquire`]/[`Release`]/[`AcqRel`] (for load, store,…",102,null],[5,"spin_loop_hint","","Signals the processor that it is inside a busy-wait…",null,[[]]],[5,"fence","","An atomic fence.",null,[[["ordering",4]]]],[5,"compiler_fence","","A compiler memory fence.",null,[[["ordering",4]]]],[17,"ATOMIC_BOOL_INIT","","An [`AtomicBool`] initialized to `false`.",null,null],[17,"ATOMIC_I8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U8_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U16_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U32_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_I64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_U64_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_ISIZE_INIT","","An atomic integer initialized to `0`.",null,null],[17,"ATOMIC_USIZE_INIT","","An atomic integer initialized to `0`.",null,null],[11,"new","","Creates a new `AtomicBool`.",103,[[],["atomicbool",3]]],[11,"get_mut","","Returns a mutable reference to the underlying [`bool`].",103,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",103,[[]]],[11,"load","","Loads a value from the bool.",103,[[["ordering",4]]]],[11,"store","","Stores a value into the bool.",103,[[["ordering",4]]]],[11,"swap","","Stores a value into the bool, returning the previous value.",103,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the [`bool`] if the current value is…",103,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the [`bool`] if the current value is…",103,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the [`bool`] if the current value is…",103,[[["ordering",4]],["result",4]]],[11,"fetch_and","","Logical \\\"and\\\" with a boolean value.",103,[[["ordering",4]]]],[11,"fetch_nand","","Logical \\\"nand\\\" with a boolean value.",103,[[["ordering",4]]]],[11,"fetch_or","","Logical \\\"or\\\" with a boolean value.",103,[[["ordering",4]]]],[11,"fetch_xor","","Logical \\\"xor\\\" with a boolean value.",103,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying [`bool`].",103,[[]]],[11,"new","","Creates a new `AtomicPtr`.",104,[[],["atomicptr",3]]],[11,"get_mut","","Returns a mutable reference to the underlying pointer.",104,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",104,[[]]],[11,"load","","Loads a value from the pointer.",104,[[["ordering",4]]]],[11,"store","","Stores a value into the pointer.",104,[[["ordering",4]]]],[11,"swap","","Stores a value into the pointer, returning the previous…",104,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the pointer if the current value is…",104,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the pointer if the current value is…",104,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the pointer if the current value is…",104,[[["ordering",4]],["result",4]]],[11,"new","","Creates a new atomic integer.",105,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",105,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",105,[[]]],[11,"load","","Loads a value from the atomic integer.",105,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",105,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",105,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",105,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",105,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",105,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",105,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",105,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",105,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",105,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",105,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",105,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",105,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",105,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",105,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",105,[[]]],[11,"new","","Creates a new atomic integer.",106,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",106,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",106,[[]]],[11,"load","","Loads a value from the atomic integer.",106,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",106,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",106,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",106,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",106,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",106,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",106,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",106,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",106,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",106,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",106,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",106,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",106,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",106,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",106,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",106,[[]]],[11,"new","","Creates a new atomic integer.",107,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",107,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",107,[[]]],[11,"load","","Loads a value from the atomic integer.",107,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",107,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",107,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",107,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",107,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",107,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",107,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",107,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",107,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",107,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",107,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",107,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",107,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",107,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",107,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",107,[[]]],[11,"new","","Creates a new atomic integer.",108,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",108,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",108,[[]]],[11,"load","","Loads a value from the atomic integer.",108,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",108,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",108,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",108,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",108,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",108,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",108,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",108,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",108,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",108,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",108,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",108,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",108,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",108,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",108,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",108,[[]]],[11,"new","","Creates a new atomic integer.",109,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",109,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",109,[[]]],[11,"load","","Loads a value from the atomic integer.",109,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",109,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",109,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",109,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",109,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",109,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",109,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",109,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",109,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",109,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",109,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",109,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",109,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",109,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",109,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",109,[[]]],[11,"new","","Creates a new atomic integer.",110,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",110,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",110,[[]]],[11,"load","","Loads a value from the atomic integer.",110,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",110,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",110,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",110,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",110,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",110,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",110,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",110,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",110,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",110,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",110,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",110,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",110,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",110,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",110,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",110,[[]]],[11,"new","","Creates a new atomic integer.",111,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",111,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",111,[[]]],[11,"load","","Loads a value from the atomic integer.",111,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",111,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",111,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",111,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",111,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",111,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",111,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",111,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",111,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",111,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",111,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",111,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",111,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",111,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",111,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",111,[[]]],[11,"new","","Creates a new atomic integer.",112,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",112,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",112,[[]]],[11,"load","","Loads a value from the atomic integer.",112,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",112,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",112,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",112,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",112,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",112,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",112,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",112,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",112,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",112,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",112,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",112,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",112,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",112,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",112,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",112,[[]]],[11,"new","","Creates a new atomic integer.",113,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",113,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",113,[[]]],[11,"load","","Loads a value from the atomic integer.",113,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",113,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",113,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",113,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",113,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",113,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",113,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",113,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",113,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",113,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",113,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",113,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",113,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",113,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",113,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",113,[[]]],[11,"new","","Creates a new atomic integer.",114,[[]]],[11,"get_mut","","Returns a mutable reference to the underlying integer.",114,[[]]],[11,"into_inner","","Consumes the atomic and returns the contained value.",114,[[]]],[11,"load","","Loads a value from the atomic integer.",114,[[["ordering",4]]]],[11,"store","","Stores a value into the atomic integer.",114,[[["ordering",4]]]],[11,"swap","","Stores a value into the atomic integer, returning the…",114,[[["ordering",4]]]],[11,"compare_and_swap","","Stores a value into the atomic integer if the current…",114,[[["ordering",4]]]],[11,"compare_exchange","","Stores a value into the atomic integer if the current…",114,[[["ordering",4]],["result",4]]],[11,"compare_exchange_weak","","Stores a value into the atomic integer if the current…",114,[[["ordering",4]],["result",4]]],[11,"fetch_add","","Adds to the current value, returning the previous value.",114,[[["ordering",4]]]],[11,"fetch_sub","","Subtracts from the current value, returning the previous…",114,[[["ordering",4]]]],[11,"fetch_and","","Bitwise \\\"and\\\" with the current value.",114,[[["ordering",4]]]],[11,"fetch_nand","","Bitwise \\\"nand\\\" with the current value.",114,[[["ordering",4]]]],[11,"fetch_or","","Bitwise \\\"or\\\" with the current value.",114,[[["ordering",4]]]],[11,"fetch_xor","","Bitwise \\\"xor\\\" with the current value.",114,[[["ordering",4]]]],[11,"fetch_update","","Fetches the value, and applies a function to it that…",114,[[["ordering",4]],["result",4]]],[11,"fetch_max","","Maximum with the current value.",114,[[["ordering",4]]]],[11,"fetch_min","","Minimum with the current value.",114,[[["ordering",4]]]],[11,"as_mut_ptr","","Returns a mutable pointer to the underlying integer.",114,[[]]],[0,"fmt","core","Utilities for formatting and printing strings.",null,null],[3,"DebugList","core::fmt","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Error","","The error type which is returned from formatting a message…",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[3,"Arguments","","This structure represents a safely precompiled version of…",null,null],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",115,null],[13,"Right","","Indication that contents should be right-aligned.",115,null],[13,"Center","","Indication that contents should be center-aligned.",115,null],[5,"write","","The `write` function takes an output stream, and an…",null,[[["write",8],["arguments",3]],["result",6]]],[11,"field","","Adds a new field to the generated struct output.",116,[[["debug",8]]]],[11,"finish_non_exhaustive","","Marks the struct as non-exhaustive, indicating to the…",116,[[],["result",6]]],[11,"finish","","Finishes output and returns any error encountered.",116,[[],["result",6]]],[11,"field","","Adds a new field to the generated tuple struct output.",117,[[["debug",8]]]],[11,"finish","","Finishes output and returns any error encountered.",117,[[],["result",6]]],[11,"entry","","Adds a new entry to the set output.",118,[[["debug",8]]]],[11,"entries","","Adds the contents of an iterator of entries to the set…",118,[[]]],[11,"finish","","Finishes output and returns any error encountered.",118,[[],["result",6]]],[11,"entry","","Adds a new entry to the list output.",119,[[["debug",8]]]],[11,"entries","","Adds the contents of an iterator of entries to the list…",119,[[]]],[11,"finish","","Finishes output and returns any error encountered.",119,[[],["result",6]]],[11,"entry","","Adds a new entry to the map output.",120,[[["debug",8]]]],[11,"key","","Adds the key part of a new entry to the map output.",120,[[["debug",8]]]],[11,"value","","Adds the value part of a new entry to the map output.",120,[[["debug",8]]]],[11,"entries","","Adds the contents of an iterator of entries to the map…",120,[[]]],[11,"finish","","Finishes output and returns any error encountered.",120,[[],["result",6]]],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a…",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether…",121,[[],["result",6]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the…",121,[[],["result",6]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors…",121,[[["arguments",3]],["result",6]]],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",122,[[["formatter",3]],["result",6]]],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",123,[[["formatter",3]],["result",6]]],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",124,[[["formatter",3]],["result",6]]],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",125,[[["formatter",3]],["result",6]]],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",126,[[["formatter",3]],["result",6]]],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",127,[[["formatter",3]],["result",6]]],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",128,[[["formatter",3]],["result",6]]],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",129,[[["formatter",3]],["result",6]]],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",130,[[["formatter",3]],["result",6]]],[11,"pad_integral","","Performs the correct padding for an integer which has…",131,[[],["result",6]]],[11,"pad","","This function takes a string slice and emits it to the…",131,[[],["result",6]]],[11,"write_str","","Writes some data to the underlying buffer contained within…",131,[[],["result",6]]],[11,"write_fmt","","Writes some formatted information into this instance.",131,[[["arguments",3]],["result",6]]],[11,"flags","","Flags for formatting",131,[[]]],[11,"fill","","Character used as \'fill\' whenever there is alignment.",131,[[]]],[11,"align","","Flag indicating what form of alignment was requested.",131,[[],[["alignment",4],["option",4]]]],[11,"width","","Optionally specified integer width that the output should…",131,[[],["option",4]]],[11,"precision","","Optionally specified precision for numeric types.…",131,[[],["option",4]]],[11,"sign_plus","","Determines if the `+` flag was specified.",131,[[]]],[11,"sign_minus","","Determines if the `-` flag was specified.",131,[[]]],[11,"alternate","","Determines if the `#` flag was specified.",131,[[]]],[11,"sign_aware_zero_pad","","Determines if the `0` flag was specified.",131,[[]]],[11,"debug_struct","","Creates a [`DebugStruct`] builder designed to assist with…",131,[[],["debugstruct",3]]],[11,"debug_tuple","","Creates a `DebugTuple` builder designed to assist with…",131,[[],["debugtuple",3]]],[11,"debug_list","","Creates a `DebugList` builder designed to assist with…",131,[[],["debuglist",3]]],[11,"debug_set","","Creates a `DebugSet` builder designed to assist with…",131,[[],["debugset",3]]],[11,"debug_map","","Creates a `DebugMap` builder designed to assist with…",131,[[],["debugmap",3]]],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[0,"hash","core","Generic hashing support.",null,null],[3,"SipHasher","core::hash","An implementation of SipHash 2-4.",null,null],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for…",null,null],[11,"new","","Creates a new `SipHasher` with the two initial keys set to…",132,[[],["siphasher",3]]],[11,"new_with_keys","","Creates a `SipHasher` that is keyed off the provided keys.",132,[[],["siphasher",3]]],[8,"Hash","","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",133,[[]]],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",133,[[]]],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",134,[[]]],[10,"write","","Writes some data into this `Hasher`.",134,[[]]],[11,"write_u8","","Writes a single `u8` into this hasher.",134,[[]]],[11,"write_u16","","Writes a single `u16` into this hasher.",134,[[]]],[11,"write_u32","","Writes a single `u32` into this hasher.",134,[[]]],[11,"write_u64","","Writes a single `u64` into this hasher.",134,[[]]],[11,"write_u128","","Writes a single `u128` into this hasher.",134,[[]]],[11,"write_usize","","Writes a single `usize` into this hasher.",134,[[]]],[11,"write_i8","","Writes a single `i8` into this hasher.",134,[[]]],[11,"write_i16","","Writes a single `i16` into this hasher.",134,[[]]],[11,"write_i32","","Writes a single `i32` into this hasher.",134,[[]]],[11,"write_i64","","Writes a single `i64` into this hasher.",134,[[]]],[11,"write_i128","","Writes a single `i128` into this hasher.",134,[[]]],[11,"write_isize","","Writes a single `isize` into this hasher.",134,[[]]],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",135,null],[10,"build_hasher","","Creates a new hasher.",135,[[]]],[14,"Hash","","Derive macro generating an impl of the trait `Hash`.",null,null],[0,"slice","core","Slice management and manipulation.",null,null],[3,"Iter","core::slice","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"Split","","An iterator over subslices separated by elements that…",null,null],[3,"SplitInclusive","","An iterator over subslices separated by elements that…",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"SplitInclusiveMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"RSplit","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are…",null,null],[3,"SplitN","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that…",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[]]],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`],…",null,[[]]],[5,"from_ref","","Converts a reference to T into a slice of length 1…",null,[[]]],[5,"from_mut","","Converts a reference to T into a slice of length 1…",null,[[]]],[0,"memchr","","Pure rust memchr implementation, taken from rust-memchr",null,null],[5,"memchr","core::slice::memchr","Returns the first index matching the byte `x` in `text`.",null,[[],["option",4]]],[5,"memrchr","","Returns the last index matching the byte `x` in `text`.",null,[[],["option",4]]],[8,"SliceIndex","core::slice","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",136,null],[10,"get","","Returns a shared reference to the output at this location,…",136,[[],["option",4]]],[10,"get_mut","","Returns a mutable reference to the output at this…",136,[[],["option",4]]],[10,"get_unchecked","","Returns a shared reference to the output at this location,…",136,[[]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this…",136,[[]]],[10,"index","","Returns a shared reference to the output at this location,…",136,[[]]],[10,"index_mut","","Returns a mutable reference to the output at this…",136,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",137,[[]]],[11,"into_slice","","Views the underlying data as a subslice of the original…",138,[[]]],[11,"as_slice","","Views the underlying data as a subslice of the original…",138,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not…",139,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",140,[[]]],[11,"remainder","","Returns the remainder of the original slice that is not…",141,[[]]],[11,"into_remainder","","Returns the remainder of the original slice that is not…",142,[[]]],[0,"str","core","String manipulation.",null,null],[3,"ParseBoolError","core::str","An error returned when parsing a `bool` using [`from_str`]…",null,null],[3,"Utf8Error","","Errors which can occur when attempting to interpret a…",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and…",null,null],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a…",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a…",null,null],[3,"SplitInclusive","","An iterator over the substrings of a string, terminated by…",null,null],[3,"EncodeUtf16","","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[3,"EscapeDebug","","The return type of [`str::escape_debug`].",null,null],[3,"EscapeDefault","","The return type of [`str::escape_default`].",null,null],[3,"EscapeUnicode","","The return type of [`str::escape_unicode`].",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["result",4],["utf8error",3]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,[[],[["result",4],["utf8error",3]]]],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without…",null,[[]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without…",null,[[]]],[5,"next_code_point","","Reads the next code point out of a byte iterator (assuming…",null,[[],["option",4]]],[5,"utf8_char_width","","Given a first byte, determines how many bytes are in this…",null,[[]]],[0,"pattern","","The string Pattern API.",null,null],[3,"CharSearcher","core::str::pattern","Associated type for `<char as Pattern<\'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<\'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<\'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<\'a>>::Searcher`.",null,null],[4,"SearchStep","","Result of calling `Searcher::next()` or…",null,null],[13,"Match","","Expresses that a match of the pattern has been found at…",143,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a…",143,null],[13,"Done","","Expresses that every byte of the haystack has been…",143,null],[8,"Pattern","","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",144,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the…",144,[[]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",144,[[]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the…",144,[[]]],[11,"strip_prefix_of","","Removes the pattern from the front of haystack, if it…",144,[[],["option",4]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the…",144,[[]]],[11,"strip_suffix_of","","Removes the pattern from the back of haystack, if it…",144,[[],["option",4]]],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",145,[[]]],[10,"next","","Performs the next search step starting from the front.",145,[[],["searchstep",4]]],[11,"next_match","","Finds the next `Match` result. See `next()`",145,[[],["option",4]]],[11,"next_reject","","Finds the next `Reject` result. See `next()` and…",145,[[],["option",4]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",146,[[],["searchstep",4]]],[11,"next_match_back","","Finds the next `Match` result. See `next_back()`",146,[[],["option",4]]],[11,"next_reject_back","","Finds the next `Reject` result. See `next_back()`",146,[[],["option",4]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be…",null,null],[0,"lossy","core::str","",null,null],[3,"Utf8Lossy","core::str::lossy","Lossy UTF-8 string.",null,null],[3,"Utf8LossyChunksIter","","Iterator over lossy UTF-8 string",null,null],[3,"Utf8LossyChunk","","",null,null],[12,"valid","","Sequence of valid chars. Can be empty between broken UTF-8…",147,null],[12,"broken","","Single broken char, empty if none. Empty iff iterator item…",147,null],[11,"from_str","","",148,[[],["utf8lossy",3]]],[11,"from_bytes","","",148,[[],["utf8lossy",3]]],[11,"chunks","","",148,[[],["utf8lossychunksiter",3]]],[8,"FromStr","core::str","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",149,null],[10,"from_str","","Parses a string `s` to return a value of this type.",149,[[],["result",4]]],[11,"valid_up_to","","Returns the index in the given string up to which valid…",150,[[]]],[11,"error_len","","Provides more information about the failure:",150,[[],["option",4]]],[11,"as_str","","Views the underlying data as a subslice of the original…",151,[[]]],[11,"as_str","","Views the underlying data as a subslice of the original…",152,[[]]],[0,"time","core","Temporal quantification.",null,null],[3,"Duration","core::time","A `Duration` type to represent a span of time, typically…",null,null],[18,"SECOND","","The duration of one second.",153,null],[18,"MILLISECOND","","The duration of one millisecond.",153,null],[18,"MICROSECOND","","The duration of one microsecond.",153,null],[18,"NANOSECOND","","The duration of one nanosecond.",153,null],[11,"new","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"from_secs","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"from_millis","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"from_micros","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"from_nanos","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"as_secs","","Returns the number of whole seconds contained by this…",153,[[]]],[11,"subsec_millis","","Returns the fractional part of this `Duration`, in whole…",153,[[]]],[11,"subsec_micros","","Returns the fractional part of this `Duration`, in whole…",153,[[]]],[11,"subsec_nanos","","Returns the fractional part of this `Duration`, in…",153,[[]]],[11,"as_millis","","Returns the total number of whole milliseconds contained…",153,[[]]],[11,"as_micros","","Returns the total number of whole microseconds contained…",153,[[]]],[11,"as_nanos","","Returns the total number of nanoseconds contained by this…",153,[[]]],[11,"checked_add","","Checked `Duration` addition. Computes `self + other`,…",153,[[["duration",3]],[["duration",3],["option",4]]]],[11,"checked_sub","","Checked `Duration` subtraction. Computes `self - other`,…",153,[[["duration",3]],[["duration",3],["option",4]]]],[11,"checked_mul","","Checked `Duration` multiplication. Computes `self *…",153,[[],[["duration",3],["option",4]]]],[11,"checked_div","","Checked `Duration` division. Computes `self / other`,…",153,[[],[["duration",3],["option",4]]]],[11,"as_secs_f64","","Returns the number of seconds contained by this `Duration`…",153,[[]]],[11,"as_secs_f32","","Returns the number of seconds contained by this `Duration`…",153,[[]]],[11,"from_secs_f64","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"from_secs_f32","","Creates a new `Duration` from the specified number of…",153,[[],["duration",3]]],[11,"mul_f64","","Multiplies `Duration` by `f64`.",153,[[],["duration",3]]],[11,"mul_f32","","Multiplies `Duration` by `f32`.",153,[[],["duration",3]]],[11,"div_f64","","Divide `Duration` by `f64`.",153,[[],["duration",3]]],[11,"div_f32","","Divide `Duration` by `f32`.",153,[[],["duration",3]]],[11,"div_duration_f64","","Divide `Duration` by `Duration` and return `f64`.",153,[[["duration",3]]]],[11,"div_duration_f32","","Divide `Duration` by `Duration` and return `f32`.",153,[[["duration",3]]]],[0,"unicode","core","",null,null],[5,"Alphabetic","core::unicode","",null,[[]]],[5,"Case_Ignorable","","",null,[[]]],[5,"Cased","","",null,[[]]],[5,"Cc","","",null,[[]]],[5,"Grapheme_Extend","","",null,[[]]],[5,"Lowercase","","",null,[[]]],[5,"N","","",null,[[]]],[5,"Uppercase","","",null,[[]]],[5,"White_Space","","",null,[[]]],[0,"derived_property","","",null,null],[5,"Case_Ignorable","core::unicode::derived_property","",null,[[]]],[5,"Cased","","",null,[[]]],[0,"conversions","core::unicode","",null,null],[5,"to_lower","core::unicode::conversions","",null,[[]]],[5,"to_upper","","",null,[[]]],[17,"UNICODE_VERSION","core::unicode","The version of Unicode that the Unicode parts of `char`…",null,null],[0,"future","core","Asynchronous values.",null,null],[3,"Pending","core::future","Creates a future which never resolves, representing a…",null,null],[3,"Ready","","Creates a future that is immediately ready with a value.",null,null],[5,"pending","","Creates a future which never resolves, representing a…",null,[[],["pending",3]]],[5,"ready","","Creates a future that is immediately ready with a value.",null,[[],["ready",3]]],[8,"Future","","A future represents an asynchronous computation.",null,null],[16,"Output","","The type of value produced on completion.",154,null],[10,"poll","","Attempt to resolve the future to a final value,…",154,[[["pin",3],["context",3]],["poll",4]]],[8,"IntoFuture","","Conversion into a `Future`.",null,null],[16,"Output","","The output that the future will produce on completion.",155,null],[16,"Future","","Which kind of future are we turning this into?",155,null],[10,"into_future","","Creates a future from a value.",155,[[]]],[0,"task","core","Types and Traits for working with asynchronous tasks.",null,null],[3,"Context","core::task","The `Context` of an asynchronous task.",null,null],[3,"RawWaker","","A `RawWaker` allows the implementor of a task executor to…",null,null],[3,"RawWakerVTable","","A virtual function pointer table (vtable) that specifies…",null,null],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying…",null,null],[4,"Poll","","Indicates whether a value is available or if the current…",null,null],[13,"Ready","","Represents that a value is immediately ready.",156,null],[13,"Pending","","Represents that a value is not ready yet.",156,null],[11,"map","","Changes the ready value of this `Poll` with the closure…",156,[[],["poll",4]]],[11,"is_ready","","Returns `true` if this is `Poll::Ready`",156,[[]]],[11,"is_pending","","Returns `true` if this is `Poll::Pending`",156,[[]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",156,[[],[["poll",4],["result",4]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",156,[[],[["poll",4],["result",4]]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",156,[[],[["option",4],["poll",4]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",156,[[],[["poll",4],["option",4]]]],[11,"new","","Creates a new `RawWaker` from the provided `data` pointer…",157,[[["rawwakervtable",3]],["rawwaker",3]]],[11,"new","","Creates a new `RawWakerVTable` from the provided `clone`,…",158,[[]]],[11,"from_waker","","Create a new `Context` from a `&Waker`.",159,[[["waker",3]]]],[11,"waker","","Returns a reference to the `Waker` for the current task.",159,[[],["waker",3]]],[11,"wake","","Wake up the task associated with this `Waker`.",160,[[]]],[11,"wake_by_ref","","Wake up the task associated with this `Waker` without…",160,[[]]],[11,"will_wake","","Returns `true` if this `Waker` and another `Waker` have…",160,[[["waker",3]]]],[11,"from_raw","","Creates a new `Waker` from [`RawWaker`].",160,[[["rawwaker",3]],["waker",3]]],[0,"alloc","core","Memory allocation APIs",null,null],[3,"Layout","core::alloc","Layout of a block of memory.",null,null],[3,"LayoutErr","","The parameters given to `Layout::from_size_align` or some…",null,null],[3,"AllocErr","","The `AllocErr` error indicates an allocation failure that…",null,null],[3,"MemoryBlock","","Represents a block of allocated memory returned by an…",null,null],[12,"ptr","","",161,null],[12,"size","","",161,null],[4,"AllocInit","","A desired initial state for allocated memory.",null,null],[13,"Uninitialized","","The contents of the new memory are uninitialized.",162,null],[13,"Zeroed","","The new memory is guaranteed to be zeroed.",162,null],[4,"ReallocPlacement","","A placement constraint when growing or shrinking an…",null,null],[13,"MayMove","","The allocator is allowed to move the allocation to a…",163,null],[13,"InPlace","","The address of the new memory must not change.",163,null],[11,"from_size_align","","Constructs a `Layout` from a given `size` and `align`, or…",164,[[],[["result",4],["layouterr",3]]]],[11,"from_size_align_unchecked","","Creates a layout, bypassing all checks.",164,[[]]],[11,"size","","The minimum size in bytes for a memory block of this layout.",164,[[]]],[11,"align","","The minimum byte alignment for a memory block of this…",164,[[]]],[11,"new","","Constructs a `Layout` suitable for holding a value of type…",164,[[]]],[11,"for_value","","Produces layout describing a record that could be used to…",164,[[]]],[11,"dangling","","Creates a `NonNull` that is dangling, but well-aligned for…",164,[[],["nonnull",3]]],[11,"align_to","","Creates a layout describing the record that can hold a…",164,[[],[["result",4],["layouterr",3]]]],[11,"padding_needed_for","","Returns the amount of padding we must insert after `self`…",164,[[]]],[11,"pad_to_align","","Creates a layout by rounding the size of this layout up to…",164,[[],["layout",3]]],[11,"repeat","","Creates a layout describing the record for `n` instances…",164,[[],[["result",4],["layouterr",3]]]],[11,"extend","","Creates a layout describing the record for `self` followed…",164,[[],[["result",4],["layouterr",3]]]],[11,"repeat_packed","","Creates a layout describing the record for `n` instances…",164,[[],[["result",4],["layouterr",3]]]],[11,"extend_packed","","Creates a layout describing the record for `self` followed…",164,[[],[["result",4],["layouterr",3]]]],[11,"array","","Creates a layout describing the record for a `[T; n]`.",164,[[],[["result",4],["layouterr",3]]]],[8,"GlobalAlloc","","A memory allocator that can be registered as the standard…",null,null],[10,"alloc","","Allocate memory as described by the given `layout`.",165,[[["layout",3]]]],[10,"dealloc","","Deallocate the block of memory at the given `ptr` pointer…",165,[[["layout",3]]]],[11,"alloc_zeroed","","Behaves like `alloc`, but also ensures that the contents…",165,[[["layout",3]]]],[11,"realloc","","Shrink or grow a block of memory to the given `new_size`.…",165,[[["layout",3]]]],[8,"AllocRef","","An implementation of `AllocRef` can allocate, grow,…",null,null],[10,"alloc","","Attempts to allocate a block of memory.",166,[[["allocinit",4],["layout",3]],[["memoryblock",3],["result",4],["allocerr",3]]]],[10,"dealloc","","Deallocates the memory referenced by `ptr`.",166,[[["layout",3],["nonnull",3]]]],[11,"grow","","Attempts to extend the memory block.",166,[[["allocinit",4],["layout",3],["nonnull",3],["reallocplacement",4]],[["memoryblock",3],["result",4],["allocerr",3]]]],[11,"shrink","","Attempts to shrink the memory block.",166,[[["layout",3],["nonnull",3],["reallocplacement",4]],[["memoryblock",3],["result",4],["allocerr",3]]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of…",166,[[]]],[11,"init","","Initialize the specified memory block.",162,[[["memoryblock",3]]]],[11,"init_offset","","Initialize the memory block like specified by `init` at…",162,[[["memoryblock",3]]]],[0,"primitive","core","This module reexports the primitive types to allow usage…",null,null],[0,"arch","","SIMD and vendor intrinsics module.",null,null],[0,"x86","core::arch","Platform-specific intrinsics for the `x86` platform.",null,null],[3,"__m64","core::arch::x86","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen `f32` types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",167,null],[12,"ebx","","EBX register.",167,null],[12,"ecx","","ECX register.",167,null],[12,"edx","","EDX register.",167,null],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp…",null,[[]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp…",null,[[]]],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given…",null,[[],["cpuidresult",3]]],[5,"__cpuid","","See `__cpuid_count`.",null,[[],["cpuidresult",3]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,[[]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf…",null,[[]]],[5,"_xsave","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstor","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_xsetbv","","Copies 64-bits from `val` to the extended control register…",null,[[]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR`…",null,[[]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstors","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the fist…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ss","","Compares the lowest `f32` of both inputs for equality. The…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ss","","Compares the lowest `f32` of both inputs for less than.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ss","","Compares the lowest `f32` of both inputs for less than or…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ss","","Compares the lowest `f32` of both inputs for greater than.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ss","","Compares the lowest `f32` of both inputs for greater than…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ss","","Compares the lowest `f32` of both inputs for inequality.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ss","","Checks if the lowest `f32` of both inputs are ordered. The…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ss","","Checks if the lowest `f32` of both inputs are unordered.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,[[["__m128",3]]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,[[["__m128",3]]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128",3]]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a`…",null,[[],["__m128",3]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,[[],["__m128",3]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,[[],["__m128",3]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values…",null,[[],["__m128",3]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values…",null,[[],["__m128",3]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,[[],["__m128",3]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel…",null,[[]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b`…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b`…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each element…",null,[[["__m128",3]]]],[5,"_mm_loadh_pi","","Sets the upper two single-precision floating-point values…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_loadl_pi","","Loads two floats from `p` into the lower half of a…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p`…",null,[[],["__m128",3]]],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from…",null,[[],["__m128",3]]],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,[[],["__m128",3]]],[5,"_mm_load_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128",3]]],[5,"_mm_loadu_ps","","Loads four `f32` values from memory into a `__m128`. There…",null,[[],["__m128",3]]],[5,"_mm_loadr_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128",3]]],[5,"_mm_storeh_pi","","Stores the upper half of `a` (64 bits) into memory.",null,[[["__m128",3]]]],[5,"_mm_storel_pi","","Stores the lower half of `a` (64 bits) into memory.",null,[[["__m128",3]]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of `a` into memory.",null,[[["__m128",3]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of `a` repeated four times…",null,[[["__m128",3]]]],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,[[["__m128",3]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into aligned memory.",null,[[["__m128",3]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no…",null,[[["__m128",3]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into aligned memory in reverse…",null,[[["__m128",3]]]],[5,"_mm_move_ss","","Returns a `__m128` with the first component from `b` and…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory…",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and…",null,[[]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer…",null,[[]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the…",null,[[]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128",3]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in…",null,[[["__m128",3]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a…",null,[[["__m128",3]]]],[5,"_mm_stream_pi","","Stores 64-bits of integer data from a into memory using a…",null,[[["__m64",3]]]],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m128",3],["__m64",3]],["__m128",3]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m128",3],["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64",3]]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64",3]]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvttps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi16","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi8","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence is…",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains `p`…",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_bslli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_bsrli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in `a` and `b` for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in `a` to…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_cvtsi32_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is `a` and all…",null,[[],["__m128i",3]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, from…",null,[[],["__m128i",3]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i",3]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of…",null,[[],["__m128i",3]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i",3]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i",3]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into…",null,[[["__m128i",3]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i",3]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i",3]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer `a` to a memory location.",null,[[["__m128i",3]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned…",null,[[["__m128i",3]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory…",null,[[]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_extract_epi16","","Returns the `imm8` element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_insert_epi16","","Returns a new vector where the `imm8` element of `a` is…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each element…",null,[[["__m128i",3]]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in `a` using the control in `imm8`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of `a` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of `a` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of `a` and then AND with `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_or_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_xor_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in `a` and `b` for equality.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_comieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d",3]]]],[5,"_mm_comilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d",3]]]],[5,"_mm_comile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_comigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d",3]]]],[5,"_mm_comige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_comineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d",3]]]],[5,"_mm_ucomieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d",3]]]],[5,"_mm_ucomilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d",3]]]],[5,"_mm_ucomile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_ucomigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d",3]]]],[5,"_mm_ucomige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_ucomineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d",3]]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3],["__m128",3]],["__m128",3]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit)…",null,[[["__m128d",3],["__m128",3]],["__m128d",3]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m128d",3]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m128d",3]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each element…",null,[[["__m128d",3]]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d",3]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element…",null,[[],["__m128d",3]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]`…",null,[[["__m128d",3]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d",3]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d",3]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point elements…",null,[[["__m128d",3]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements…",null,[[],["__m128d",3]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d",3]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d",3]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i",3]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values,…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a…",null,[[["__m64",3]],["__m128d",3]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]`…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a…",null,[[["__m128i",3]],["__m64",3]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector,…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d",3]],["__m64",3]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d",3]],["__m64",3]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. This…",null,[[],["__m128i",3]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_pi8","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_abs_pi16","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_abs_pi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_shuffle_pi8","","Shuffles packed 8-bit integers in `a` according to shuffle…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadd_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadd_pi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadds_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point…",null,[[["__m128",3]]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m128i",3]]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from `a` selected with `imm8`",null,[[["__m128i",3]]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_insert_epi8","","Returns a copy of `a` with the 8-bit integer from `i`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_epi32","","Returns a copy of `a` with the 32-bit integer from `i`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrm","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpestri","","Compares packed strings `a` and `b` with lengths `la` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrz","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrc","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrs","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestro","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestra","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128",3]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m256d",3]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision…",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision…",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from `a`,…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower…",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_permute2f128_si256","","Shuffles 258-bits (composed of integer data) selected by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[],["__m128",3]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_insertf128_ps","","Copies `a` to result, then inserts 128 bits (composed of 4…",null,[[["__m128",3],["__m256",3]],["__m256",3]]],[5,"_mm256_insertf128_pd","","Copies `a` to result, then inserts 128 bits (composed of 2…",null,[[["__m128d",3],["__m256d",3]],["__m256d",3]]],[5,"_mm256_insertf128_si256","","Copies `a` to result, then inserts 128 bits from `b` into…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi8","","Copies `a` to result, and inserts the 8-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi16","","Copies `a` to result, and inserts the 16-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi32","","Copies `a` to result, and inserts the 32-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d",3]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d",3]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256",3]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256",3]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d",3]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d",3]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256",3]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256",3]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i",3]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i",3]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i",3]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i",3]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m256d",3],["__m256i",3]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m128d",3],["__m128i",3]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m256",3],["__m256i",3]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m128i",3],["__m128",3]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into…",null,[[],["__m256i",3]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a…",null,[[["__m256i",3]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4…",null,[[["__m256d",3]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a…",null,[[["__m256",3]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most…",null,[[["__m256d",3]]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most…",null,[[["__m256",3]]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to…",null,[[],["__m256d",3]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to zero.",null,[[],["__m256",3]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to…",null,[[],["__m256i",3]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m256d",3]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value…",null,[[],["__m256",3]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer `a` to all all elements of…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d",3]],["__m256",3]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256",3]],["__m256d",3]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d",3]],["__m256i",3]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_undefined_ps","","Returns vector of type `__m256` with undefined elements.",null,[[],["__m256",3]]],[5,"_mm256_undefined_pd","","Returns vector of type `__m256d` with undefined elements.",null,[[],["__m256d",3]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i",3]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed…",null,[[],["__m256",3]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed…",null,[[],["__m256d",3]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from…",null,[[],["__m256i",3]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of 4…",null,[[["__m256",3]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of 2…",null,[[["__m256d",3]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of…",null,[[["__m256i",3]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256",3]]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in `a` and `b` into a…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from `a` and `b` using `mask`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from `a` selected with…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256i",3]],["__m128i",3]]],[5,"_mm_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m128",3]]],[5,"_mm256_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m256i",3]],["__m128",3]]],[5,"_mm_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm256_inserti128_si256","","Copies `a` to `dst`, then insert 128 bits (of integer…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m256i",3]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m256i",3]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit…",null,[[["__m256i",3]]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by `imm8` from…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in `a` across…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in `a` across…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned 8-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of `a` using the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i",3]]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i",3]]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from `a`, selected with `imm8`.",null,[[["__m256i",3]]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x…",null,[[["__m256d",3]]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256i",3]]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from…",null,[[]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least…",null,[[]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,[[]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[]]],[5,"_bzhi_u32","","Zeroes higher bits of `a` >= `index`.",null,[[]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at…",null,[[]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the…",null,[[]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,[[["__m128d",3]]]],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,[[["__m128",3]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,[[]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,[[]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant…",null,[[]]],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant…",null,[[]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,[[]]],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,[[]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,[[]]],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,[[]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,[[]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x`…",null,[[]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x`…",null,[[]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and…",null,[[]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and…",null,[[]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,[[],["__m64",3]]],[5,"_mm_add_pi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddb","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_add_pi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddw","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_add_pi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddd","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddsb","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddsw","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddusb","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddusw","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_packs_pi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_packs_pi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_set_pi16","","Sets packed 16-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set_pi32","","Sets packed 32-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set_pi8","","Sets packed 8-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set1_pi16","","Broadcasts 16-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_set1_pi32","","Broadcasts 32-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_set1_pi8","","Broadcasts 8-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_setr_pi16","","Sets packed 16-bit integers in dst with the supplied…",null,[[],["__m64",3]]],[5,"_mm_setr_pi32","","Sets packed 32-bit integers in dst with the supplied…",null,[[],["__m64",3]]],[5,"_mm_setr_pi8","","Sets packed 8-bit integers in dst with the supplied values…",null,[[],["__m64",3]]],[5,"_mm_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_m_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_mm_cvtsi32_si64","","Copies 32-bit integer `a` to the lower elements of the…",null,[[],["__m64",3]]],[5,"_mm_cvtsi64_si32","","Return the lower 32-bit integer in `a`.",null,[[["__m64",3]]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesimc_si128","","Performs the `InvMixColumns` transformation on `a`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store…",null,[[]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store…",null,[[]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant…",null,[[]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant…",null,[[]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"ud2","","Generates the trap instruction `UD2`",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_setzero_si512","","Returns vector of type `__m512i` with all elements set to…",null,[[],["__m512i",3]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in `dst` with the supplied…",null,[[],["__m512i",3]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer `a` to all elements of `dst`.",null,[[],["__m512i",3]]],[5,"_mm512_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmplt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpgt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmple_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpge_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpeq_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm256_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_bittest","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandset","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandreset","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandcomplement","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_xbegin","","Specifies the start of a restricted transactional memory…",null,[[]]],[5,"_xend","","Specifies the end of a restricted transactional memory…",null,[[]]],[5,"_xabort","","Forces a restricted transactional memory (RTM) region to…",null,[[]]],[5,"_xtest","","Queries whether the processor is executing in a…",null,[[]]],[5,"_xabort_code","","Retrieves the parameter passed to [`_xabort`] when…",null,[[]]],[5,"_mm_cvtph_ps","","Converts the 4 x 16-bit half-precision float values in the…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm256_cvtph_ps","","Converts the 8 x 16-bit half-precision float values in the…",null,[[["__m128i",3]],["__m256",3]]],[5,"_mm_cvtps_ph","","Converts the 4 x 32-bit float values in the 128-bit vector…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm256_cvtps_ph","","Converts the 8 x 32-bit float values in the 256-bit vector…",null,[[["__m256",3]],["__m128i",3]]],[6,"__mmask16","","The `__mmask16` type used in AVX-512 intrinsics, a 16-bit…",null,null],[6,"__mmask8","","The `__mmask8` type used in AVX-512 intrinsics, a 8-bit…",null,null],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see…",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see…",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1]…",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[17,"_XBEGIN_STARTED","","Transaction successfully started.",null,null],[17,"_XABORT_EXPLICIT","","Transaction explicitly aborted with xabort. The parameter…",null,null],[17,"_XABORT_RETRY","","Transaction retry is possible.",null,null],[17,"_XABORT_CONFLICT","","Transaction abort due to a memory conflict with another…",null,null],[17,"_XABORT_CAPACITY","","Transaction abort due to the transaction using too much…",null,null],[17,"_XABORT_DEBUG","","Transaction abort due to a debug trap.",null,null],[17,"_XABORT_NESTED","","Transaction abort in a inner nested transaction.",null,null],[0,"x86_64","core::arch","Platform-specific intrinsics for the `x86_64` platform.",null,null],[3,"__m64","core::arch::x86_64","64-bit wide integer vector type, x86-specific",null,null],[3,"__m128i","","128-bit wide integer vector type, x86-specific",null,null],[3,"__m128","","128-bit wide set of four `f32` types, x86-specific",null,null],[3,"__m128d","","128-bit wide set of two `f64` types, x86-specific",null,null],[3,"__m256i","","256-bit wide integer vector type, x86-specific",null,null],[3,"__m256","","256-bit wide set of eight `f32` types, x86-specific",null,null],[3,"__m256d","","256-bit wide set of four `f64` types, x86-specific",null,null],[3,"__m512i","","512-bit wide integer vector type, x86-specific",null,null],[3,"__m512","","512-bit wide set of sixteen `f32` types, x86-specific",null,null],[3,"__m512d","","512-bit wide set of eight `f64` types, x86-specific",null,null],[3,"CpuidResult","","Result of the `cpuid` instruction.",null,null],[12,"eax","","EAX register.",167,null],[12,"ebx","","EBX register.",167,null],[12,"ecx","","ECX register.",167,null],[12,"edx","","EDX register.",167,null],[5,"_fxsave","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_bswap","","Returns an integer with the reversed byte order of x",null,[[]]],[5,"_rdtsc","","Reads the current value of the processor’s time-stamp…",null,[[]]],[5,"__rdtscp","","Reads the current value of the processor’s time-stamp…",null,[[]]],[5,"__cpuid_count","","Returns the result of the `cpuid` instruction for a given…",null,[[],["cpuidresult",3]]],[5,"__cpuid","","See `__cpuid_count`.",null,[[],["cpuidresult",3]]],[5,"has_cpuid","","Does the host support the `cpuid` instruction?",null,[[]]],[5,"__get_cpuid_max","","Returns the highest-supported `leaf` (`EAX`) and sub-leaf…",null,[[]]],[5,"_xsave","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstor","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_xsetbv","","Copies 64-bits from `val` to the extended control register…",null,[[]]],[5,"_xgetbv","","Reads the contents of the extended control register `XCR`…",null,[[]]],[5,"_xsaveopt","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsavec","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsaves","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstors","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_mm_add_ss","","Adds the first component of `a` and `b`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_add_ps","","Adds __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ss","","Subtracts the first component of `b` from `a`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sub_ps","","Subtracts __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ss","","Multiplies the first component of `a` and `b`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_mul_ps","","Multiplies __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ss","","Divides the first component of `b` by `a`, the other…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_div_ps","","Divides __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ss","","Returns the square root of the first single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ss","","Returns the approximate reciprocal of the first…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rcp_ps","","Returns the approximate reciprocal of packed…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ss","","Returns the approximate reciprocal square root of the fist…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_rsqrt_ps","","Returns the approximate reciprocal square root of packed…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ss","","Compares the first single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_and_ps","","Bitwise AND of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_andnot_ps","","Bitwise AND-NOT of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_or_ps","","Bitwise OR of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_xor_ps","","Bitwise exclusive OR of packed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ss","","Compares the lowest `f32` of both inputs for equality. The…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ss","","Compares the lowest `f32` of both inputs for less than.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ss","","Compares the lowest `f32` of both inputs for less than or…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ss","","Compares the lowest `f32` of both inputs for greater than.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ss","","Compares the lowest `f32` of both inputs for greater than…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ss","","Compares the lowest `f32` of both inputs for inequality.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ss","","Compares the lowest `f32` of both inputs for…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ss","","Checks if the lowest `f32` of both inputs are ordered. The…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ss","","Checks if the lowest `f32` of both inputs are unordered.…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpeq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmplt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmple_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpgt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpneq_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnlt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnle_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpngt_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpnge_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cmpunord_ps","","Compares each of the four floats in `a` to the…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_comieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_comineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomieq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomilt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomile_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomigt_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomige_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_ucomineq_ss","","Compares two 32-bit floats from the low-order bits of `a`…",null,[[["__m128",3]]]],[5,"_mm_cvtss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvt_ss2si","","Alias for `_mm_cvtss_si32`.",null,[[["__m128",3]]]],[5,"_mm_cvttss_si32","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvtt_ss2si","","Alias for `_mm_cvttss_si32`.",null,[[["__m128",3]]]],[5,"_mm_cvtss_f32","","Extracts the lowest 32 bit float from the input vector.",null,[[["__m128",3]]]],[5,"_mm_cvtsi32_ss","","Converts a 32 bit integer to a 32 bit float. The result…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cvt_si2ss","","Alias for `_mm_cvtsi32_ss`.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_set_ss","","Construct a `__m128` with the lowest element set to `a`…",null,[[],["__m128",3]]],[5,"_mm_set1_ps","","Construct a `__m128` with all element set to `a`.",null,[[],["__m128",3]]],[5,"_mm_set_ps1","","Alias for `_mm_set1_ps`",null,[[],["__m128",3]]],[5,"_mm_set_ps","","Construct a `__m128` from four floating point values…",null,[[],["__m128",3]]],[5,"_mm_setr_ps","","Construct a `__m128` from four floating point values…",null,[[],["__m128",3]]],[5,"_mm_setzero_ps","","Construct a `__m128` with all elements initialized to zero.",null,[[],["__m128",3]]],[5,"_MM_SHUFFLE","","A utility function for creating masks to use with Intel…",null,[[]]],[5,"_mm_shuffle_ps","","Shuffles packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movehl_ps","","Combine higher half of `a` and `b`. The highwe half of `b`…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movelh_ps","","Combine lower half of `a` and `b`. The lower half of `b`…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_movemask_ps","","Returns a mask of the most significant bit of each element…",null,[[["__m128",3]]]],[5,"_mm_loadh_pi","","Sets the upper two single-precision floating-point values…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_loadl_pi","","Loads two floats from `p` into the lower half of a…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_load_ss","","Construct a `__m128` with the lowest element read from `p`…",null,[[],["__m128",3]]],[5,"_mm_load1_ps","","Construct a `__m128` by duplicating the value read from…",null,[[],["__m128",3]]],[5,"_mm_load_ps1","","Alias for `_mm_load1_ps`",null,[[],["__m128",3]]],[5,"_mm_load_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128",3]]],[5,"_mm_loadu_ps","","Loads four `f32` values from memory into a `__m128`. There…",null,[[],["__m128",3]]],[5,"_mm_loadr_ps","","Loads four `f32` values from aligned memory into a…",null,[[],["__m128",3]]],[5,"_mm_storeh_pi","","Stores the upper half of `a` (64 bits) into memory.",null,[[["__m128",3]]]],[5,"_mm_storel_pi","","Stores the lower half of `a` (64 bits) into memory.",null,[[["__m128",3]]]],[5,"_mm_store_ss","","Stores the lowest 32 bit float of `a` into memory.",null,[[["__m128",3]]]],[5,"_mm_store1_ps","","Stores the lowest 32 bit float of `a` repeated four times…",null,[[["__m128",3]]]],[5,"_mm_store_ps1","","Alias for `_mm_store1_ps`",null,[[["__m128",3]]]],[5,"_mm_store_ps","","Stores four 32-bit floats into aligned memory.",null,[[["__m128",3]]]],[5,"_mm_storeu_ps","","Stores four 32-bit floats into memory. There are no…",null,[[["__m128",3]]]],[5,"_mm_storer_ps","","Stores four 32-bit floats into aligned memory in reverse…",null,[[["__m128",3]]]],[5,"_mm_move_ss","","Returns a `__m128` with the first component from `b` and…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_sfence","","Performs a serializing operation on all store-to-memory…",null,[[]]],[5,"_mm_getcsr","","Gets the unsigned 32-bit value of the MXCSR control and…",null,[[]]],[5,"_mm_setcsr","","Sets the MXCSR register with the 32-bit unsigned integer…",null,[[]]],[5,"_MM_GET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_GET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_EXCEPTION_MASK","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_EXCEPTION_STATE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_FLUSH_ZERO_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_MM_SET_ROUNDING_MODE","","See `_mm_setcsr`",null,[[]]],[5,"_mm_prefetch","","Fetch the cache line that contains address `p` using the…",null,[[]]],[5,"_mm_undefined_ps","","Returns vector of type __m128 with undefined elements.",null,[[],["__m128",3]]],[5,"_MM_TRANSPOSE4_PS","","Transpose the 4x4 matrix formed by 4 rows of __m128 in…",null,[[["__m128",3]]]],[5,"_mm_stream_ps","","Stores `a` into the memory at `mem_addr` using a…",null,[[["__m128",3]]]],[5,"_mm_stream_pi","","Stores 64-bits of integer data from a into memory using a…",null,[[["__m64",3]]]],[5,"_mm_max_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmaxsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_max_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmaxub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_min_pi16","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pminsw","","Compares the packed 16-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_min_pu8","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pminub","","Compares the packed 8-bit signed integers of `a` and `b`…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mulhi_pu16","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mullo_pi16","","Multiplies packed 16-bit integer values and writes the…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pmulhuw","","Multiplies packed 16-bit unsigned integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_avg_pu8","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pavgb","","Computes the rounded averages of the packed unsigned 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_avg_pu16","","Computes the rounded averages of the packed unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pavgw","","Computes the rounded averages of the packed unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sad_pu8","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psadbw","","Subtracts the corresponding 8-bit unsigned integer values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvtpi32_ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m128",3],["__m64",3]],["__m128",3]]],[5,"_mm_cvt_pi2ps","","Converts two elements of a 64-bit vector of `[2 x i32]`…",null,[[["__m128",3],["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpu8_ps","","Converts the lower 4 8-bit values of `a` into a 128-bit…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpu16_ps","","Converts a 64-bit vector of `i16`s into a 128-bit vector…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_cvtpi32x2_ps","","Converts the two 32-bit signed integer values from each…",null,[[["__m64",3]],["__m128",3]]],[5,"_mm_maskmove_si64","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_m_maskmovq","","Conditionally copies the values from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_mm_extract_pi16","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64",3]]]],[5,"_m_pextrw","","Extracts 16-bit element from a 64-bit vector of `[4 x…",null,[[["__m64",3]]]],[5,"_mm_insert_pi16","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pinsrw","","Copies data from the 64-bit vector of `[4 x i16]` to the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_movemask_pi8","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_m_pmovmskb","","Takes the most significant bit from each 8-bit element in…",null,[[["__m64",3]]]],[5,"_mm_shuffle_pi16","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_pshufw","","Shuffles the 4 16-bit integers from a 64-bit integer…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvttps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi32","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvt_ps2pi","","Converts the two lower packed single-precision (32-bit)…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi16","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_cvtps_pi8","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m64",3]]],[5,"_mm_pause","","Provides a hint to the processor that the code sequence is…",null,[[]]],[5,"_mm_clflush","","Invalidates and flushes the cache line that contains `p`…",null,[[]]],[5,"_mm_lfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_mfence","","Performs a serializing operation on all load-from-memory…",null,[[]]],[5,"_mm_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd_epi16","","Multiplies and then horizontally add signed 16 bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sad_epu8","","Sum the absolute differences of packed unsigned 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi8","","Subtracts packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi16","","Subtracts packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_bslli_si128","","Shifts `a` left by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_bsrli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_si128","","Shifts `a` right by `imm8` bytes while shifting in zeros.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_and_si128","","Computes the bitwise AND of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_andnot_si128","","Computes the bitwise NOT of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_or_si128","","Computes the bitwise OR of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_xor_si128","","Computes the bitwise XOR of 128 bits (representing integer…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi8","","Compares packed 8-bit integers in `a` and `b` for less-than.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmplt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_pd","","Converts the lower two packed 32-bit integers in `a` to…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_cvtsi32_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_cvtsi32_si128","","Returns a vector whose lowest element is `a` and all…",null,[[],["__m128i",3]]],[5,"_mm_cvtsi128_si32","","Returns the lowest element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_set_epi64x","","Sets packed 64-bit integers with the supplied values, from…",null,[[],["__m128i",3]]],[5,"_mm_set_epi32","","Sets packed 32-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set_epi16","","Sets packed 16-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set_epi8","","Sets packed 8-bit integers with the supplied values.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi32","","Broadcasts 32-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi16","","Broadcasts 16-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_set1_epi8","","Broadcasts 8-bit integer `a` to all elements.",null,[[],["__m128i",3]]],[5,"_mm_setr_epi32","","Sets packed 32-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setr_epi16","","Sets packed 16-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setr_epi8","","Sets packed 8-bit integers with the supplied values in…",null,[[],["__m128i",3]]],[5,"_mm_setzero_si128","","Returns a vector with all elements set to zero.",null,[[],["__m128i",3]]],[5,"_mm_loadl_epi64","","Loads 64-bit integer from memory into first element of…",null,[[],["__m128i",3]]],[5,"_mm_load_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i",3]]],[5,"_mm_loadu_si128","","Loads 128-bits of integer data from memory into a new…",null,[[],["__m128i",3]]],[5,"_mm_maskmoveu_si128","","Conditionally store 8-bit integer elements from `a` into…",null,[[["__m128i",3]]]],[5,"_mm_store_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i",3]]]],[5,"_mm_storeu_si128","","Stores 128-bits of integer data from `a` into memory.",null,[[["__m128i",3]]]],[5,"_mm_storel_epi64","","Stores the lower 64-bit integer `a` to a memory location.",null,[[["__m128i",3]]]],[5,"_mm_stream_si128","","Stores a 128-bit integer vector to a 128-bit aligned…",null,[[["__m128i",3]]]],[5,"_mm_stream_si32","","Stores a 32-bit integer value in the specified memory…",null,[[]]],[5,"_mm_move_epi64","","Returns a vector where the low element is extracted from…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_extract_epi16","","Returns the `imm8` element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_insert_epi16","","Returns a new vector where the `imm8` element of `a` is…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_movemask_epi8","","Returns a mask of the most significant bit of each element…",null,[[["__m128i",3]]]],[5,"_mm_shuffle_epi32","","Shuffles 32-bit integers in `a` using the control in `imm8`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of `a` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of `a` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_add_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_div_pd","","Divide packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_max_pd","","Returns a new vector with the maximum values from…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_min_pd","","Returns a new vector with the minimum values from…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sqrt_pd","","Returns a new vector with the square root of each of the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_sub_pd","","Subtract packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_and_pd","","Computes the bitwise AND of packed double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_andnot_pd","","Computes the bitwise NOT of `a` and then AND with `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_or_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_xor_pd","","Computes the bitwise OR of `a` and `b`.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_sd","","Returns a new vector with the low element of `a` replaced…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpeq_pd","","Compares corresponding elements in `a` and `b` for equality.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmplt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmple_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpgt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpunord_pd","","Compares corresponding elements in `a` and `b` to see if…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpneq_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnlt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnle_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpngt_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmpnge_pd","","Compares corresponding elements in `a` and `b` for…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_comieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d",3]]]],[5,"_mm_comilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d",3]]]],[5,"_mm_comile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_comigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d",3]]]],[5,"_mm_comige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_comineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d",3]]]],[5,"_mm_ucomieq_sd","","Compares the lower element of `a` and `b` for equality.",null,[[["__m128d",3]]]],[5,"_mm_ucomilt_sd","","Compares the lower element of `a` and `b` for less-than.",null,[[["__m128d",3]]]],[5,"_mm_ucomile_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_ucomigt_sd","","Compares the lower element of `a` and `b` for greater-than.",null,[[["__m128d",3]]]],[5,"_mm_ucomige_sd","","Compares the lower element of `a` and `b` for…",null,[[["__m128d",3]]]],[5,"_mm_ucomineq_sd","","Compares the lower element of `a` and `b` for not-equal.",null,[[["__m128d",3]]]],[5,"_mm_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvtsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvtsd_ss","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3],["__m128",3]],["__m128",3]]],[5,"_mm_cvtsd_f64","","Returns the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_cvtss_sd","","Converts the lower single-precision (32-bit)…",null,[[["__m128d",3],["__m128",3]],["__m128d",3]]],[5,"_mm_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_cvttsd_si32","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_set_sd","","Copies double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m128d",3]]],[5,"_mm_set_pd1","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m128d",3]]],[5,"_mm_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_setzero_pd","","Returns packed double-precision (64-bit) floating-point…",null,[[],["__m128d",3]]],[5,"_mm_movemask_pd","","Returns a mask of the most significant bit of each element…",null,[[["__m128d",3]]]],[5,"_mm_load_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d",3]]],[5,"_mm_load_sd","","Loads a 64-bit double-precision value to the low element…",null,[[],["__m128d",3]]],[5,"_mm_loadh_pd","","Loads a double-precision value into the high-order bits of…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loadl_pd","","Loads a double-precision value into the low-order bits of…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_stream_pd","","Stores a 128-bit floating point vector of `[2 x double]`…",null,[[["__m128d",3]]]],[5,"_mm_store_sd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_store_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d",3]]]],[5,"_mm_storeu_pd","","Stores 128-bits (composed of 2 packed double-precision…",null,[[["__m128d",3]]]],[5,"_mm_store1_pd","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_store_pd1","","Stores the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]]]],[5,"_mm_storer_pd","","Stores 2 double-precision (64-bit) floating-point elements…",null,[[["__m128d",3]]]],[5,"_mm_storeh_pd","","Stores the upper 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_storel_pd","","Stores the lower 64 bits of a 128-bit vector of `[2 x…",null,[[["__m128d",3]]]],[5,"_mm_load1_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_load_pd1","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_loadr_pd","","Loads 2 double-precision (64-bit) floating-point elements…",null,[[],["__m128d",3]]],[5,"_mm_loadu_pd","","Loads 128-bits (composed of 2 packed double-precision…",null,[[],["__m128d",3]]],[5,"_mm_shuffle_pd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_move_sd","","Constructs a 128-bit floating-point vector of `[2 x…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_castpd_ps","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d",3]],["__m128",3]]],[5,"_mm_castpd_si128","","Casts a 128-bit floating-point vector of `[2 x double]`…",null,[[["__m128d",3]],["__m128i",3]]],[5,"_mm_castps_pd","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128",3]],["__m128d",3]]],[5,"_mm_castps_si128","","Casts a 128-bit floating-point vector of `[4 x float]`…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm_castsi128_pd","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_castsi128_ps","","Casts a 128-bit integer vector into a 128-bit…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_undefined_pd","","Returns vector of type __m128d with undefined elements.",null,[[],["__m128d",3]]],[5,"_mm_undefined_si128","","Returns vector of type __m128i with undefined elements.",null,[[],["__m128i",3]]],[5,"_mm_unpackhi_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_unpacklo_pd","","The resulting `__m128d` element is composed by the…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_add_si64","","Adds two signed or unsigned 64-bit integer values,…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mul_su32","","Multiplies 32-bit unsigned integer values contained in the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_si64","","Subtracts signed or unsigned 64-bit integer values and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cvtpi32_pd","","Converts the two signed 32-bit integer elements of a…",null,[[["__m64",3]],["__m128d",3]]],[5,"_mm_set_epi64","","Initializes both 64-bit values in a 128-bit vector of `[2…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_set1_epi64","","Initializes both values in a 128-bit vector of `[2 x i64]`…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_setr_epi64","","Constructs a 128-bit integer vector, initialized in…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_movepi64_pi64","","Returns the lower 64 bits of a 128-bit integer vector as a…",null,[[["__m128i",3]],["__m64",3]]],[5,"_mm_movpi64_epi64","","Moves the 64-bit operand to a 128-bit integer vector,…",null,[[["__m64",3]],["__m128i",3]]],[5,"_mm_cvtpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d",3]],["__m64",3]]],[5,"_mm_cvttpd_pi32","","Converts the two double-precision floating-point elements…",null,[[["__m128d",3]],["__m64",3]]],[5,"_mm_addsub_ps","","Alternatively add and subtract packed single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_addsub_pd","","Alternatively add and subtract packed double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_pd","","Horizontally adds adjacent pairs of double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hadd_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_hsub_pd","","Horizontally subtract adjacent pairs of double-precision…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_hsub_ps","","Horizontally adds adjacent pairs of single-precision…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_lddqu_si128","","Loads 128-bits of integer data from unaligned memory. This…",null,[[],["__m128i",3]]],[5,"_mm_movedup_pd","","Duplicate the low double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_loaddup_pd","","Loads a double-precision (64-bit) floating-point element…",null,[[],["__m128d",3]]],[5,"_mm_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_abs_epi8","","Computes the absolute value of packed 8-bit signed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi16","","Computes the absolute value of each of the packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_epi32","","Computes the absolute value of each of the packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_alignr_epi8","","Concatenate 16-byte blocks in `a` and `b` into a 32-byte…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadds_epi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hadd_epi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsubs_epi16","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_hsub_epi32","","Horizontally subtract the adjacent pairs of values…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_maddubs_epi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mulhrs_epi16","","Multiplies packed 16-bit signed integer values, truncate…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_abs_pi8","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_abs_pi16","","Computes the absolute value of packed 8-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_abs_pi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_shuffle_pi8","","Shuffles packed 8-bit integers in `a` according to shuffle…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_alignr_pi8","","Concatenates the two 64-bit integer vector operands, and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadd_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadd_pi32","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hadds_pi16","","Horizontally adds the adjacent pairs of values contained…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsub_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsub_pi32","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_hsubs_pi16","","Horizontally subtracts the adjacent pairs of values…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_maddubs_pi16","","Multiplies corresponding pairs of packed 8-bit unsigned…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_mulhrs_pi16","","Multiplies packed 16-bit signed integer values, truncates…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sign_pi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_blendv_epi8","","Blend packed 8-bit integers from `a` and `b` using `mask`",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blend_epi16","","Blend packed 16-bit integers from `a` and `b` using the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_blendv_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blendv_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_blend_pd","","Blend packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_blend_ps","","Blend packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_extract_ps","","Extracts a single-precision (32-bit) floating-point…",null,[[["__m128",3]]]],[5,"_mm_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m128i",3]]]],[5,"_mm_extract_epi32","","Extracts an 32-bit integer from `a` selected with `imm8`",null,[[["__m128i",3]]]],[5,"_mm_insert_ps","","Select a single value in `a` to store at some position in…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_insert_epi8","","Returns a copy of `a` with the 8-bit integer from `i`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_epi32","","Returns a copy of `a` with the 32-bit integer from `i`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi8","","Compares packed 8-bit integers in `a` and `b` and returns…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi16","","Sign extend packed 8-bit integers in `a` to packed 16-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi32","","Sign extend packed 8-bit integers in `a` to packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi8_epi64","","Sign extend packed 8-bit integers in the low 8 bytes of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi32","","Sign extend packed 16-bit integers in `a` to packed 32-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi16_epi64","","Sign extend packed 16-bit integers in `a` to packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepi32_epi64","","Sign extend packed 32-bit integers in `a` to packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi16","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi32","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu8_epi64","","Zeroes extend packed unsigned 8-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu16_epi64","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cvtepu32_epi64","","Zeroes extend packed unsigned 32-bit integers in `a` to…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_dp_pd","","Returns the dot product of two __m128d vectors.",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_dp_ps","","Returns the dot product of two __m128 vectors.",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_floor_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_floor_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_ceil_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_ceil_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_pd","","Round the packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_round_ps","","Round the packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_round_sd","","Round the lower double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_round_ss","","Round the lower single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_minpos_epu16","","Finds the minimum unsigned 16-bit element in the 128-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mpsadbw_epu8","","Subtracts 8-bit unsigned integer values and computes the…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_testz_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_testc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_testnzc_si128","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_all_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_all_ones","","Tests whether the specified bits in `a` 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_test_mix_ones_zeros","","Tests whether the specified bits in a 128-bit integer…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrm","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpistri","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrz","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrc","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistrs","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistro","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpistra","","Compares packed strings with implicit lengths in `a` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrm","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_cmpestri","","Compares packed strings `a` and `b` with lengths `la` and…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrz","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrc","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestrs","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestro","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_cmpestra","","Compares packed strings in `a` and `b` with lengths `la`…",null,[[["__m128i",3]]]],[5,"_mm_crc32_u8","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_crc32_u16","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_crc32_u32","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_mm_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_add_pd","","Adds packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_add_ps","","Adds packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_and_pd","","Computes the bitwise AND of a packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_and_ps","","Computes the bitwise AND of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_or_pd","","Computes the bitwise OR packed double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_or_ps","","Computes the bitwise OR packed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_shuffle_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_shuffle_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_andnot_pd","","Computes the bitwise NOT of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_andnot_ps","","Computes the bitwise NOT of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_max_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_max_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_min_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_min_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_mul_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_mul_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_addsub_pd","","Alternatively adds and subtracts packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_addsub_ps","","Alternatively adds and subtracts packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sub_pd","","Subtracts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_sub_ps","","Subtracts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_ps","","Computes the division of each of the 8 packed 32-bit…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_div_pd","","Computes the division of each of the 4 packed 64-bit…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_ceil_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_floor_pd","","Rounds packed double-precision (64-bit) floating point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_round_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_ceil_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_floor_ps","","Rounds packed single-precision (32-bit) floating point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_ps","","Returns the square root of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_sqrt_pd","","Returns the square root of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blend_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_blendv_pd","","Blends packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_blendv_ps","","Blends packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_dp_ps","","Conditionally multiplies the packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hadd_pd","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hadd_ps","","Horizontal addition of adjacent pairs in the two packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_hsub_pd","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_hsub_ps","","Horizontal subtraction of adjacent pairs in the two packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_xor_pd","","Computes the bitwise XOR of packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_xor_ps","","Computes the bitwise XOR of packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_cmp_pd","","Compares packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_cmp_ps","","Compares packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_cmp_sd","","Compares the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cmp_ss","","Compares the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_cvtepi32_pd","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_cvtepi32_ps","","Converts packed 32-bit integers in `a` to packed…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_cvtpd_ps","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128",3]]],[5,"_mm256_cvtps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_cvtps_pd","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m256d",3]]],[5,"_mm256_cvttpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvtpd_epi32","","Converts packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m128i",3]]],[5,"_mm256_cvttps_epi32","","Converts packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_extractf128_ps","","Extracts 128 bits (composed of 4 packed single-precision…",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_extractf128_pd","","Extracts 128 bits (composed of 2 packed double-precision…",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_extractf128_si256","","Extracts 128 bits (composed of integer data) from `a`,…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_zeroall","","Zeroes the contents of all XMM or YMM registers.",null,[[]]],[5,"_mm256_zeroupper","","Zeroes the upper 128 bits of all YMM registers; the lower…",null,[[]]],[5,"_mm256_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_permutevar_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_permute_ps","","Shuffles single-precision (32-bit) floating-point elements…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_permutevar_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_permute_pd","","Shuffles double-precision (64-bit) floating-point elements…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_permute2f128_ps","","Shuffles 256 bits (composed of 8 packed single-precision…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_permute2f128_pd","","Shuffles 256 bits (composed of 4 packed double-precision…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_permute2f128_si256","","Shuffles 258-bits (composed of integer data) selected by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm_broadcast_ss","","Broadcasts a single-precision (32-bit) floating-point…",null,[[],["__m128",3]]],[5,"_mm256_broadcast_sd","","Broadcasts a double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_broadcast_ps","","Broadcasts 128 bits from memory (composed of 4 packed…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_broadcast_pd","","Broadcasts 128 bits from memory (composed of 2 packed…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_insertf128_ps","","Copies `a` to result, then inserts 128 bits (composed of 4…",null,[[["__m128",3],["__m256",3]],["__m256",3]]],[5,"_mm256_insertf128_pd","","Copies `a` to result, then inserts 128 bits (composed of 2…",null,[[["__m128d",3],["__m256d",3]],["__m256d",3]]],[5,"_mm256_insertf128_si256","","Copies `a` to result, then inserts 128 bits from `b` into…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi8","","Copies `a` to result, and inserts the 8-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi16","","Copies `a` to result, and inserts the 16-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_insert_epi32","","Copies `a` to result, and inserts the 32-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_load_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d",3]]],[5,"_mm256_store_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d",3]]]],[5,"_mm256_load_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256",3]]],[5,"_mm256_store_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256",3]]]],[5,"_mm256_loadu_pd","","Loads 256-bits (composed of 4 packed double-precision…",null,[[],["__m256d",3]]],[5,"_mm256_storeu_pd","","Stores 256-bits (composed of 4 packed double-precision…",null,[[["__m256d",3]]]],[5,"_mm256_loadu_ps","","Loads 256-bits (composed of 8 packed single-precision…",null,[[],["__m256",3]]],[5,"_mm256_storeu_ps","","Stores 256-bits (composed of 8 packed single-precision…",null,[[["__m256",3]]]],[5,"_mm256_load_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i",3]]],[5,"_mm256_store_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i",3]]]],[5,"_mm256_loadu_si256","","Loads 256-bits of integer data from memory into result.…",null,[[],["__m256i",3]]],[5,"_mm256_storeu_si256","","Stores 256-bits of integer data from `a` into memory.…",null,[[["__m256i",3]]]],[5,"_mm256_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m256d",3],["__m256i",3]]]],[5,"_mm_maskload_pd","","Loads packed double-precision (64-bit) floating-point…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_maskstore_pd","","Stores packed double-precision (64-bit) floating-point…",null,[[["__m128d",3],["__m128i",3]]]],[5,"_mm256_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m256",3],["__m256i",3]]]],[5,"_mm_maskload_ps","","Loads packed single-precision (32-bit) floating-point…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_maskstore_ps","","Stores packed single-precision (32-bit) floating-point…",null,[[["__m128i",3],["__m128",3]]]],[5,"_mm256_movehdup_ps","","Duplicate odd-indexed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_moveldup_ps","","Duplicate even-indexed single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_movedup_pd","","Duplicate even-indexed double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_lddqu_si256","","Loads 256-bits of integer data from unaligned memory into…",null,[[],["__m256i",3]]],[5,"_mm256_stream_si256","","Moves integer data from a 256-bit integer vector to a…",null,[[["__m256i",3]]]],[5,"_mm256_stream_pd","","Moves double-precision values from a 256-bit vector of `[4…",null,[[["__m256d",3]]]],[5,"_mm256_stream_ps","","Moves single-precision floating point values from a…",null,[[["__m256",3]]]],[5,"_mm256_rcp_ps","","Computes the approximate reciprocal of packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_rsqrt_ps","","Computes the approximate reciprocal square root of packed…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpackhi_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpackhi_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_unpacklo_pd","","Unpacks and interleave double-precision (64-bit)…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_unpacklo_ps","","Unpacks and interleave single-precision (32-bit)…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm256_testz_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testnzc_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]]]],[5,"_mm256_testz_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm256_testc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm256_testnzc_pd","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256d",3]]]],[5,"_mm_testz_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm_testc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm_testnzc_pd","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128d",3]]]],[5,"_mm256_testz_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm256_testc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm256_testnzc_ps","","Computes the bitwise AND of 256 bits (representing…",null,[[["__m256",3]]]],[5,"_mm_testz_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm_testc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm_testnzc_ps","","Computes the bitwise AND of 128 bits (representing…",null,[[["__m128",3]]]],[5,"_mm256_movemask_pd","","Sets each bit of the returned mask based on the most…",null,[[["__m256d",3]]]],[5,"_mm256_movemask_ps","","Sets each bit of the returned mask based on the most…",null,[[["__m256",3]]]],[5,"_mm256_setzero_pd","","Returns vector of type __m256d with all elements set to…",null,[[],["__m256d",3]]],[5,"_mm256_setzero_ps","","Returns vector of type __m256 with all elements set to zero.",null,[[],["__m256",3]]],[5,"_mm256_setzero_si256","","Returns vector of type __m256i with all elements set to…",null,[[],["__m256i",3]]],[5,"_mm256_set_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_set_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm256_set_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_pd","","Sets packed double-precision (64-bit) floating-point…",null,[[],["__m256d",3]]],[5,"_mm256_setr_ps","","Sets packed single-precision (32-bit) floating-point…",null,[[],["__m256",3]]],[5,"_mm256_setr_epi8","","Sets packed 8-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi16","","Sets packed 16-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi32","","Sets packed 32-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_setr_epi64x","","Sets packed 64-bit integers in returned vector with the…",null,[[],["__m256i",3]]],[5,"_mm256_set1_pd","","Broadcasts double-precision (64-bit) floating-point value…",null,[[],["__m256d",3]]],[5,"_mm256_set1_ps","","Broadcasts single-precision (32-bit) floating-point value…",null,[[],["__m256",3]]],[5,"_mm256_set1_epi8","","Broadcasts 8-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi16","","Broadcasts 16-bit integer `a` to all all elements of…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi32","","Broadcasts 32-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_set1_epi64x","","Broadcasts 64-bit integer `a` to all elements of returned…",null,[[],["__m256i",3]]],[5,"_mm256_castpd_ps","","Cast vector of type __m256d to type __m256.",null,[[["__m256d",3]],["__m256",3]]],[5,"_mm256_castps_pd","","Cast vector of type __m256 to type __m256d.",null,[[["__m256",3]],["__m256d",3]]],[5,"_mm256_castps_si256","","Casts vector of type __m256 to type __m256i.",null,[[["__m256",3]],["__m256i",3]]],[5,"_mm256_castsi256_ps","","Casts vector of type __m256i to type __m256.",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_castpd_si256","","Casts vector of type __m256d to type __m256i.",null,[[["__m256d",3]],["__m256i",3]]],[5,"_mm256_castsi256_pd","","Casts vector of type __m256i to type __m256d.",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_castps256_ps128","","Casts vector of type __m256 to type __m128.",null,[[["__m256",3]],["__m128",3]]],[5,"_mm256_castpd256_pd128","","Casts vector of type __m256d to type __m128d.",null,[[["__m256d",3]],["__m128d",3]]],[5,"_mm256_castsi256_si128","","Casts vector of type __m256i to type __m128i.",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_castps128_ps256","","Casts vector of type __m128 to type __m256; the upper 128…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_castpd128_pd256","","Casts vector of type __m128d to type __m256d; the upper…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_castsi128_si256","","Casts vector of type __m128i to type __m256i; the upper…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextps128_ps256","","Constructs a 256-bit floating-point vector of `[8 x…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_zextsi128_si256","","Constructs a 256-bit integer vector from a 128-bit integer…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_zextpd128_pd256","","Constructs a 256-bit floating-point vector of `[4 x…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_undefined_ps","","Returns vector of type `__m256` with undefined elements.",null,[[],["__m256",3]]],[5,"_mm256_undefined_pd","","Returns vector of type `__m256d` with undefined elements.",null,[[],["__m256d",3]]],[5,"_mm256_undefined_si256","","Returns vector of type __m256i with undefined elements.",null,[[],["__m256i",3]]],[5,"_mm256_set_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_set_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_set_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_setr_m128","","Sets packed __m256 returned vector with the supplied values.",null,[[["__m128",3]],["__m256",3]]],[5,"_mm256_setr_m128d","","Sets packed __m256d returned vector with the supplied…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_setr_m128i","","Sets packed __m256i returned vector with the supplied…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_loadu2_m128","","Loads two 128-bit values (composed of 4 packed…",null,[[],["__m256",3]]],[5,"_mm256_loadu2_m128d","","Loads two 128-bit values (composed of 2 packed…",null,[[],["__m256d",3]]],[5,"_mm256_loadu2_m128i","","Loads two 128-bit values (composed of integer data) from…",null,[[],["__m256i",3]]],[5,"_mm256_storeu2_m128","","Stores the high and low 128-bit halves (each composed of 4…",null,[[["__m256",3]]]],[5,"_mm256_storeu2_m128d","","Stores the high and low 128-bit halves (each composed of 2…",null,[[["__m256d",3]]]],[5,"_mm256_storeu2_m128i","","Stores the high and low 128-bit halves (each composed of…",null,[[["__m256i",3]]]],[5,"_mm256_cvtss_f32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256",3]]]],[5,"_mm256_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi16","","Computes the absolute values of packed 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_abs_epi8","","Computes the absolute values of packed 8-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi64","","Adds packed 64-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_add_epi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_adds_epu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_alignr_epi8","","Concatenates pairs of 16-byte blocks in `a` and `b` into a…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_and_si256","","Computes the bitwise AND of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_andnot_si256","","Computes the bitwise NOT of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu16","","Averages packed unsigned 16-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_avg_epu8","","Averages packed unsigned 8-bit integers in `a` and `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_blend_epi32","","Blends packed 32-bit integers from `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_blend_epi16","","Blends packed 16-bit integers from `a` and `b` using…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_blendv_epi8","","Blends packed 8-bit integers from `a` and `b` using `mask`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastb_epi8","","Broadcasts the low packed 8-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastd_epi32","","Broadcasts the low packed 32-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastq_epi64","","Broadcasts the low packed 64-bit integer from `a` to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_broadcastsd_pd","","Broadcasts the low double-precision (64-bit)…",null,[[["__m128d",3]],["__m256d",3]]],[5,"_mm256_broadcastsi128_si256","","Broadcasts 128 bits of integer data from a to all 128-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_broadcastss_ps","","Broadcasts the low single-precision (32-bit)…",null,[[["__m128",3]],["__m256",3]]],[5,"_mm_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_broadcastw_epi16","","Broadcasts the low packed 16-bit integer from a to all…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi64","","Compares packed 64-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi32","","Compares packed 32-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi16","","Compares packed 16-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpeq_epi8","","Compares packed 8-bit integers in `a` and `b` for equality.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi64","","Compares packed 64-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi32","","Compares packed 32-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi16","","Compares packed 16-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cmpgt_epi8","","Compares packed 8-bit integers in `a` and `b` for…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi32","","Sign-extend 16-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi16_epi64","","Sign-extend 16-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi32_epi64","","Sign-extend 32-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi16","","Sign-extend 8-bit integers to 16-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi32","","Sign-extend 8-bit integers to 32-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepi8_epi64","","Sign-extend 8-bit integers to 64-bit integers.",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi32","","Zeroes extend packed unsigned 16-bit integers in `a` to…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu16_epi64","","Zero-extend the lower four unsigned 16-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu32_epi64","","Zero-extend unsigned 32-bit integers in `a` to 64-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi16","","Zero-extend unsigned 8-bit integers in `a` to 16-bit…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi32","","Zero-extend the lower eight unsigned 8-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_cvtepu8_epi64","","Zero-extend the lower four unsigned 8-bit integers in `a`…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_extracti128_si256","","Extracts 128 bits (of integer data) from `a` selected with…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_hadd_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadd_epi32","","Horizontally adds adjacent pairs of 32-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hadds_epi16","","Horizontally adds adjacent pairs of 16-bit integers in `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsub_epi32","","Horizontally subtract adjacent pairs of 32-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_hsubs_epi16","","Horizontally subtract adjacent pairs of 16-bit integers in…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256",3]]],[5,"_mm256_mask_i32gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m256i",3]]],[5,"_mm256_mask_i32gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m256d",3]]],[5,"_mm256_mask_i32gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m128i",3]]],[5,"_mm256_mask_i64gather_epi32","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3],["__m256i",3]],["__m128i",3]]],[5,"_mm_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m128i",3]],["__m128",3]]],[5,"_mm256_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m128",3]]],[5,"_mm256_mask_i64gather_ps","","Returns values from `slice` at offsets determined by…",null,[[["__m128",3],["__m256i",3]],["__m128",3]]],[5,"_mm_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mask_i64gather_epi64","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128i",3]],["__m128d",3]]],[5,"_mm_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m128d",3],["__m128i",3]],["__m128d",3]]],[5,"_mm256_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3]],["__m256d",3]]],[5,"_mm256_mask_i64gather_pd","","Returns values from `slice` at offsets determined by…",null,[[["__m256i",3],["__m256d",3]],["__m256d",3]]],[5,"_mm256_inserti128_si256","","Copies `a` to `dst`, then insert 128 bits (of integer…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_madd_epi16","","Multiplies packed signed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_maddubs_epi16","","Vertically multiplies each unsigned 8-bit integer from `a`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi32","","Loads packed 32-bit integers from memory pointed by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_maskload_epi64","","Loads packed 64-bit integers from memory pointed by…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi32","","Stores packed 32-bit integers from `a` into memory pointed…",null,[[["__m256i",3]]]],[5,"_mm_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m128i",3]]]],[5,"_mm256_maskstore_epi64","","Stores packed 64-bit integers from `a` into memory pointed…",null,[[["__m256i",3]]]],[5,"_mm256_max_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_max_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi16","","Compares packed 16-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi32","","Compares packed 32-bit integers in `a` and `b`, and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epi8","","Compares packed 8-bit integers in `a` and `b`, and returns…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu16","","Compares packed unsigned 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu32","","Compares packed unsigned 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_min_epu8","","Compares packed unsigned 8-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_movemask_epi8","","Creates mask from the most significant bit of each 8-bit…",null,[[["__m256i",3]]]],[5,"_mm256_mpsadbw_epu8","","Computes the sum of absolute differences (SADs) of…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epi32","","Multiplies the low 32-bit integers from each packed 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mul_epu32","","Multiplies the low unsigned 32-bit integers from each…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhi_epu16","","Multiplies the packed unsigned 16-bit integers in `a` and…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi16","","Multiplies the packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mullo_epi32","","Multiplies the packed 32-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_mulhrs_epi16","","Multiplies packed 16-bit integers in `a` and `b`,…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_or_si256","","Computes the bitwise OR of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packs_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_packus_epi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permutevar8x32_epi32","","Permutes packed 32-bit integers from `a` according to the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_epi64","","Permutes 64-bit integers from `a` using control mask `imm8`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute2x128_si256","","Shuffles 128-bits of integer data selected by `imm8` from…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_permute4x64_pd","","Shuffles 64-bit floating-point elements in `a` across…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm256_permutevar8x32_ps","","Shuffles eight 32-bit foating-point elements in `a` across…",null,[[["__m256i",3],["__m256",3]],["__m256",3]]],[5,"_mm256_sad_epu8","","Computes the absolute differences of packed unsigned 8-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi8","","Shuffles bytes from `a` according to the content of `b`.",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shuffle_epi32","","Shuffles 32-bit integers in 128-bit lanes of `a` using the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shufflehi_epi16","","Shuffles 16-bit integers in the high 64 bits of 128-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_shufflelo_epi16","","Shuffles 16-bit integers in the low 64 bits of 128-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi16","","Negates packed 16-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi32","","Negates packed 32-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sign_epi8","","Negates packed 8-bit integers in `a` when the…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi16","","Shifts packed 16-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi32","","Shifts packed 32-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sll_epi64","","Shifts packed 64-bit integers in `a` left by `count` while…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi16","","Shifts packed 16-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi32","","Shifts packed 32-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_epi64","","Shifts packed 64-bit integers in `a` left by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_slli_si256","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_bslli_epi128","","Shifts 128-bit lanes in `a` left by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi32","","Shifts packed 32-bit integers in `a` left by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_sllv_epi64","","Shifts packed 64-bit integers in `a` left by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_sra_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srai_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srai_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srav_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_si256","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_bsrli_epi128","","Shifts 128-bit lanes in `a` right by `imm8` bytes while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi16","","Shifts packed 16-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi32","","Shifts packed 32-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srl_epi64","","Shifts packed 64-bit integers in `a` right by `count`…",null,[[["__m128i",3],["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi16","","Shifts packed 16-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi32","","Shifts packed 32-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_srli_epi64","","Shifts packed 64-bit integers in `a` right by `imm8` while…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi32","","Shifts packed 32-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm256_srlv_epi64","","Shifts packed 64-bit integers in `a` right by the amount…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi32","","Subtract packed 32-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi64","","Subtract packed 64-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_sub_epi8","","Subtract packed 8-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_subs_epu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi8","","Unpacks and interleave 8-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi8","","Unpacks and interleave 8-bit integers from the low half of…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi16","","Unpacks and interleave 16-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi16","","Unpacks and interleave 16-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi32","","Unpacks and interleave 32-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi32","","Unpacks and interleave 32-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpackhi_epi64","","Unpacks and interleave 64-bit integers from the high half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_unpacklo_epi64","","Unpacks and interleave 64-bit integers from the low half…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_xor_si256","","Computes the bitwise XOR of 256 bits (representing integer…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_extract_epi8","","Extracts an 8-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i",3]]]],[5,"_mm256_extract_epi16","","Extracts a 16-bit integer from `a`, selected with `imm8`.…",null,[[["__m256i",3]]]],[5,"_mm256_extract_epi32","","Extracts a 32-bit integer from `a`, selected with `imm8`.",null,[[["__m256i",3]]]],[5,"_mm256_cvtsd_f64","","Returns the first element of the input vector of `[4 x…",null,[[["__m256d",3]]]],[5,"_mm256_cvtsi256_si32","","Returns the first element of the input vector of `[8 x…",null,[[["__m256i",3]]]],[5,"_mm_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmaddsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmaddsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fmsubadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fmsubadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmadd_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmadd_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmadd_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmadd_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm256_fnmsub_pd","","Multiplies packed double-precision (64-bit) floating-point…",null,[[["__m256d",3]],["__m256d",3]]],[5,"_mm_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm256_fnmsub_ps","","Multiplies packed single-precision (32-bit) floating-point…",null,[[["__m256",3]],["__m256",3]]],[5,"_mm_fnmsub_sd","","Multiplies the lower double-precision (64-bit)…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_fnmsub_ss","","Multiplies the lower single-precision (32-bit)…",null,[[["__m128",3]],["__m128",3]]],[5,"_lzcnt_u32","","Counts the leading most significant zero bits.",null,[[]]],[5,"_popcnt32","","Counts the bits that are set.",null,[[]]],[5,"_bextr_u32","","Extracts bits in range [`start`, `start` + `length`) from…",null,[[]]],[5,"_bextr2_u32","","Extracts bits of `a` specified by `control` into the least…",null,[[]]],[5,"_andn_u32","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[]]],[5,"_blsi_u32","","Extracts lowest set isolated bit.",null,[[]]],[5,"_blsmsk_u32","","Gets mask up to lowest set bit.",null,[[]]],[5,"_blsr_u32","","Resets the lowest set bit of `x`.",null,[[]]],[5,"_tzcnt_u32","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mm_tzcnt_32","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mulx_u32","","Unsigned multiply without affecting flags.",null,[[]]],[5,"_bzhi_u32","","Zeroes higher bits of `a` >= `index`.",null,[[]]],[5,"_pdep_u32","","Scatter contiguous low order bits of `a` to the result at…",null,[[]]],[5,"_pext_u32","","Gathers the bits of `x` specified by the `mask` into the…",null,[[]]],[5,"_mm_extract_si64","","Extracts the bit range specified by `y` from the lower 64…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_insert_si64","","Inserts the `[length:0]` bits of `y` into `x` at `index`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_stream_sd","","Non-temporal store of `a.0` into `p`.",null,[[["__m128d",3]]]],[5,"_mm_stream_ss","","Non-temporal store of `a.0` into `p`.",null,[[["__m128",3]]]],[5,"_blcfill_u32","","Clears all bits below the least significant zero bit of `x`.",null,[[]]],[5,"_blcfill_u64","","Clears all bits below the least significant zero bit of `x`.",null,[[]]],[5,"_blci_u32","","Sets all bits of `x` to 1 except for the least significant…",null,[[]]],[5,"_blci_u64","","Sets all bits of `x` to 1 except for the least significant…",null,[[]]],[5,"_blcic_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcic_u64","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcmsk_u32","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcmsk_u64","","Sets the least significant zero bit of `x` and clears all…",null,[[]]],[5,"_blcs_u32","","Sets the least significant zero bit of `x`.",null,[[]]],[5,"_blcs_u64","","Sets the least significant zero bit of `x`.",null,[[]]],[5,"_blsfill_u32","","Sets all bits of `x` below the least significant one.",null,[[]]],[5,"_blsfill_u64","","Sets all bits of `x` below the least significant one.",null,[[]]],[5,"_blsic_u32","","Clears least significant bit and sets all other bits.",null,[[]]],[5,"_blsic_u64","","Clears least significant bit and sets all other bits.",null,[[]]],[5,"_t1mskc_u32","","Clears all bits below the least significant zero of `x`…",null,[[]]],[5,"_t1mskc_u64","","Clears all bits below the least significant zero of `x`…",null,[[]]],[5,"_tzmsk_u32","","Sets all bits below the least significant one of `x` and…",null,[[]]],[5,"_tzmsk_u64","","Sets all bits below the least significant one of `x` and…",null,[[]]],[5,"_mm_setzero_si64","","Constructs a 64-bit integer vector initialized to zero.",null,[[],["__m64",3]]],[5,"_mm_add_pi8","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddb","","Adds packed 8-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_add_pi16","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddw","","Adds packed 16-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_add_pi32","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddd","","Adds packed 32-bit integers in `a` and `b`.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pi8","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddsb","","Adds packed 8-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pi16","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddsw","","Adds packed 16-bit integers in `a` and `b` using saturation.",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pu8","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddusb","","Adds packed unsigned 8-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_adds_pu16","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_paddusw","","Adds packed unsigned 16-bit integers in `a` and `b` using…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_sub_pi32","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubd","","Subtract packed 32-bit integers in `b` from packed 32-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pi8","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubsb","","Subtract packed 8-bit integers in `b` from packed 8-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pi16","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubsw","","Subtract packed 16-bit integers in `b` from packed 16-bit…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pu8","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubusb","","Subtract packed unsigned 8-bit integers in `b` from packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_subs_pu16","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64",3]],["__m64",3]]],[5,"_m_psubusw","","Subtract packed unsigned 16-bit integers in `b` from…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_packs_pi16","","Converts packed 16-bit integers from `a` and `b` to packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_packs_pi32","","Converts packed 32-bit integers from `a` and `b` to packed…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi8","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi16","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_cmpgt_pi32","","Compares whether each element of `a` is greater than the…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi16","","Unpacks the upper two elements from two `i16x4` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi8","","Unpacks the upper four elements from two `i8x8` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi8","","Unpacks the lower four elements from two `i8x8` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi16","","Unpacks the lower two elements from two `i16x4` vectors…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpackhi_pi32","","Unpacks the upper element from two `i32x2` vectors and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_unpacklo_pi32","","Unpacks the lower element from two `i32x2` vectors and…",null,[[["__m64",3]],["__m64",3]]],[5,"_mm_set_pi16","","Sets packed 16-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set_pi32","","Sets packed 32-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set_pi8","","Sets packed 8-bit integers in dst with the supplied values.",null,[[],["__m64",3]]],[5,"_mm_set1_pi16","","Broadcasts 16-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_set1_pi32","","Broadcasts 32-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_set1_pi8","","Broadcasts 8-bit integer a to all all elements of dst.",null,[[],["__m64",3]]],[5,"_mm_setr_pi16","","Sets packed 16-bit integers in dst with the supplied…",null,[[],["__m64",3]]],[5,"_mm_setr_pi32","","Sets packed 32-bit integers in dst with the supplied…",null,[[],["__m64",3]]],[5,"_mm_setr_pi8","","Sets packed 8-bit integers in dst with the supplied values…",null,[[],["__m64",3]]],[5,"_mm_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_m_empty","","Empty the MMX state, which marks the x87 FPU registers as…",null,[[]]],[5,"_mm_cvtsi32_si64","","Copies 32-bit integer `a` to the lower elements of the…",null,[[],["__m64",3]]],[5,"_mm_cvtsi64_si32","","Return the lower 32-bit integer in `a`.",null,[[["__m64",3]]]],[5,"_mm_clmulepi64_si128","","Performs a carry-less multiplication of two 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdec_si128","","Performs one round of an AES decryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesdeclast_si128","","Performs the last round of an AES decryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenc_si128","","Performs one round of an AES encryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesenclast_si128","","Performs the last round of an AES encryption flow on data…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aesimc_si128","","Performs the `InvMixColumns` transformation on `a`.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_aeskeygenassist_si128","","Assist in expanding the AES cipher key.",null,[[["__m128i",3]],["__m128i",3]]],[5,"_rdrand16_step","","Read a hardware generated 16-bit random value and store…",null,[[]]],[5,"_rdrand32_step","","Read a hardware generated 32-bit random value and store…",null,[[]]],[5,"_rdseed16_step","","Read a 16-bit NIST SP800-90B and SP800-90C compliant…",null,[[]]],[5,"_rdseed32_step","","Read a 32-bit NIST SP800-90B and SP800-90C compliant…",null,[[]]],[5,"_mm_sha1msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1msg2_epu32","","Performs the final calculation for the next four SHA1…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1nexte_epu32","","Calculate SHA1 state variable E after four rounds of…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha1rnds4_epu32","","Performs four rounds of SHA1 operation using an initial…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg1_epu32","","Performs an intermediate calculation for the next four…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256msg2_epu32","","Performs the final calculation for the next four SHA256…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_sha256rnds2_epu32","","Performs 2 rounds of SHA256 operation using an initial…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_addcarry_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_addcarryx_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_subborrow_u32","","Adds unsigned 32-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"ud2","","Generates the trap instruction `UD2`",null,[[]]],[5,"_mm512_abs_epi32","","Computes the absolute values of packed 32-bit integers in…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_mask_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__mmask16",6],["__m512i",3]],["__m512i",3]]],[5,"_mm512_maskz_abs_epi32","","Computes the absolute value of packed 32-bit integers in…",null,[[["__m512i",3],["__mmask16",6]],["__m512i",3]]],[5,"_mm512_setzero_si512","","Returns vector of type `__m512i` with all elements set to…",null,[[],["__m512i",3]]],[5,"_mm512_setr_epi32","","Sets packed 32-bit integers in `dst` with the supplied…",null,[[],["__m512i",3]]],[5,"_mm512_set1_epi64","","Broadcast 64-bit integer `a` to all elements of `dst`.",null,[[],["__m512i",3]]],[5,"_mm512_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epu64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmplt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmplt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpgt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpgt_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmple_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmple_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpge_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpge_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_cmpeq_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3]],["__mmask8",6]]],[5,"_mm512_mask_cmpeq_epi64_mask","","Compare packed unsigned 64-bit integers in a and b for…",null,[[["__m512i",3],["__mmask8",6]],["__mmask8",6]]],[5,"_mm512_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm512_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m512i",3]],["__m512i",3]]],[5,"_mm256_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm256_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_mm_madd52hi_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_madd52lo_epu64","","Multiply packed unsigned 52-bit integers in each 64-bit…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_bittest","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandset","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandreset","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandcomplement","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_xbegin","","Specifies the start of a restricted transactional memory…",null,[[]]],[5,"_xend","","Specifies the end of a restricted transactional memory…",null,[[]]],[5,"_xabort","","Forces a restricted transactional memory (RTM) region to…",null,[[]]],[5,"_xtest","","Queries whether the processor is executing in a…",null,[[]]],[5,"_xabort_code","","Retrieves the parameter passed to [`_xabort`] when…",null,[[]]],[5,"_mm_cvtph_ps","","Converts the 4 x 16-bit half-precision float values in the…",null,[[["__m128i",3]],["__m128",3]]],[5,"_mm256_cvtph_ps","","Converts the 8 x 16-bit half-precision float values in the…",null,[[["__m128i",3]],["__m256",3]]],[5,"_mm_cvtps_ph","","Converts the 4 x 32-bit float values in the 128-bit vector…",null,[[["__m128",3]],["__m128i",3]]],[5,"_mm256_cvtps_ph","","Converts the 8 x 32-bit float values in the 256-bit vector…",null,[[["__m256",3]],["__m128i",3]]],[5,"_fxsave64","","Saves the `x87` FPU, `MMX` technology, `XMM`, and `MXCSR`…",null,[[]]],[5,"_fxrstor64","","Restores the `XMM`, `MMX`, `MXCSR`, and `x87` FPU…",null,[[]]],[5,"_mm_cvtss_si64","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvttss_si64","","Converts the lowest 32 bit float in the input vector to a…",null,[[["__m128",3]]]],[5,"_mm_cvtsi64_ss","","Converts a 64 bit integer to a 32 bit float. The result…",null,[[["__m128",3]],["__m128",3]]],[5,"_mm_cvtsd_si64","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvtsd_si64x","","Alias for `_mm_cvtsd_si64`",null,[[["__m128d",3]]]],[5,"_mm_cvttsd_si64","","Converts the lower double-precision (64-bit)…",null,[[["__m128d",3]]]],[5,"_mm_cvttsd_si64x","","Alias for `_mm_cvttsd_si64`",null,[[["__m128d",3]]]],[5,"_mm_stream_si64","","Stores a 64-bit integer value in the specified memory…",null,[[]]],[5,"_mm_cvtsi64_si128","","Returns a vector whose lowest element is `a` and all…",null,[[],["__m128i",3]]],[5,"_mm_cvtsi64x_si128","","Returns a vector whose lowest element is `a` and all…",null,[[],["__m128i",3]]],[5,"_mm_cvtsi128_si64","","Returns the lowest element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_cvtsi128_si64x","","Returns the lowest element of `a`.",null,[[["__m128i",3]]]],[5,"_mm_cvtsi64_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_cvtsi64x_sd","","Returns `a` with its lower element replaced by `b` after…",null,[[["__m128d",3]],["__m128d",3]]],[5,"_mm_extract_epi64","","Extracts an 64-bit integer from `a` selected with `imm8`",null,[[["__m128i",3]]]],[5,"_mm_insert_epi64","","Returns a copy of `a` with the 64-bit integer from `i`…",null,[[["__m128i",3]],["__m128i",3]]],[5,"_mm_crc32_u64","","Starting with the initial value in `crc`, return the…",null,[[]]],[5,"_xsave64","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstor64","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_xsaveopt64","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsavec64","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xsaves64","","Performs a full or partial save of the enabled processor…",null,[[]]],[5,"_xrstors64","","Performs a full or partial restore of the enabled…",null,[[]]],[5,"_lzcnt_u64","","Counts the leading most significant zero bits.",null,[[]]],[5,"_popcnt64","","Counts the bits that are set.",null,[[]]],[5,"_mm256_insert_epi64","","Copies `a` to result, and insert the 64-bit integer `i`…",null,[[["__m256i",3]],["__m256i",3]]],[5,"_bextr_u64","","Extracts bits in range [`start`, `start` + `length`) from…",null,[[]]],[5,"_bextr2_u64","","Extracts bits of `a` specified by `control` into the least…",null,[[]]],[5,"_andn_u64","","Bitwise logical `AND` of inverted `a` with `b`.",null,[[]]],[5,"_blsi_u64","","Extracts lowest set isolated bit.",null,[[]]],[5,"_blsmsk_u64","","Gets mask up to lowest set bit.",null,[[]]],[5,"_blsr_u64","","Resets the lowest set bit of `x`.",null,[[]]],[5,"_tzcnt_u64","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mm_tzcnt_64","","Counts the number of trailing least significant zero bits.",null,[[]]],[5,"_mulx_u64","","Unsigned multiply without affecting flags.",null,[[]]],[5,"_bzhi_u64","","Zeroes higher bits of `a` >= `index`.",null,[[]]],[5,"_pdep_u64","","Scatter contiguous low order bits of `a` to the result at…",null,[[]]],[5,"_pext_u64","","Gathers the bits of `x` specified by the `mask` into the…",null,[[]]],[5,"_mm256_extract_epi64","","Extracts a 64-bit integer from `a`, selected with `imm8`.",null,[[["__m256i",3]]]],[5,"_mm512_set_epi64","","Sets packed 64-bit integers in `dst` with the supplied…",null,[[],["__m512i",3]]],[5,"_mm512_setr_epi64","","Sets packed 64-bit integers in `dst` with the supplied…",null,[[],["__m512i",3]]],[5,"_bswap64","","Returns an integer with the reversed byte order of x",null,[[]]],[5,"_rdrand64_step","","Read a hardware generated 64-bit random value and store…",null,[[]]],[5,"_rdseed64_step","","Read a 64-bit NIST SP800-90B and SP800-90C compliant…",null,[[]]],[5,"cmpxchg16b","","Compares and exchange 16 bytes (128 bits) of data…",null,[[["ordering",4]]]],[5,"_addcarry_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_addcarryx_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_subborrow_u64","","Adds unsigned 64-bit integers `a` and `b` with unsigned…",null,[[]]],[5,"_bittest64","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandset64","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandreset64","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[5,"_bittestandcomplement64","","Returns the bit in position `b` of the memory addressed by…",null,[[]]],[6,"__mmask16","","The `__mmask16` type used in AVX-512 intrinsics, a 16-bit…",null,null],[6,"__mmask8","","The `__mmask8` type used in AVX-512 intrinsics, a 8-bit…",null,null],[17,"_XCR_XFEATURE_ENABLED_MASK","","`XFEATURE_ENABLED_MASK` for `XCR`",null,null],[17,"_MM_EXCEPT_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_EXCEPT_MASK","","See `_MM_GET_EXCEPTION_STATE`",null,null],[17,"_MM_MASK_INVALID","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DENORM","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_DIV_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_OVERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_UNDERFLOW","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_INEXACT","","See `_mm_setcsr`",null,null],[17,"_MM_MASK_MASK","","See `_MM_GET_EXCEPTION_MASK`",null,null],[17,"_MM_ROUND_NEAREST","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_DOWN","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_UP","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_TOWARD_ZERO","","See `_mm_setcsr`",null,null],[17,"_MM_ROUND_MASK","","See `_MM_GET_ROUNDING_MODE`",null,null],[17,"_MM_FLUSH_ZERO_MASK","","See `_MM_GET_FLUSH_ZERO_MODE`",null,null],[17,"_MM_FLUSH_ZERO_ON","","See `_mm_setcsr`",null,null],[17,"_MM_FLUSH_ZERO_OFF","","See `_mm_setcsr`",null,null],[17,"_MM_HINT_T0","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T1","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_T2","","See `_mm_prefetch`.",null,null],[17,"_MM_HINT_NTA","","See `_mm_prefetch`.",null,null],[17,"_MM_FROUND_TO_NEAREST_INT","","round to nearest",null,null],[17,"_MM_FROUND_TO_NEG_INF","","round down",null,null],[17,"_MM_FROUND_TO_POS_INF","","round up",null,null],[17,"_MM_FROUND_TO_ZERO","","truncate",null,null],[17,"_MM_FROUND_CUR_DIRECTION","","use MXCSR.RC; see `vendor::_MM_SET_ROUNDING_MODE`",null,null],[17,"_MM_FROUND_RAISE_EXC","","do not suppress exceptions",null,null],[17,"_MM_FROUND_NO_EXC","","suppress exceptions",null,null],[17,"_MM_FROUND_NINT","","round to nearest and do not suppress exceptions",null,null],[17,"_MM_FROUND_FLOOR","","round down and do not suppress exceptions",null,null],[17,"_MM_FROUND_CEIL","","round up and do not suppress exceptions",null,null],[17,"_MM_FROUND_TRUNC","","truncate and do not suppress exceptions",null,null],[17,"_MM_FROUND_RINT","","use MXCSR.RC and do not suppress exceptions; see…",null,null],[17,"_MM_FROUND_NEARBYINT","","use MXCSR.RC and suppress exceptions; see…",null,null],[17,"_SIDD_UBYTE_OPS","","String contains unsigned 8-bit characters (Default)",null,null],[17,"_SIDD_UWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_SBYTE_OPS","","String contains signed 8-bit characters",null,null],[17,"_SIDD_SWORD_OPS","","String contains unsigned 16-bit characters",null,null],[17,"_SIDD_CMP_EQUAL_ANY","","For each character in `a`, find if it is in `b` (Default)",null,null],[17,"_SIDD_CMP_RANGES","","For each character in `a`, determine if `b[0] <= c <= b[1]…",null,null],[17,"_SIDD_CMP_EQUAL_EACH","","The strings defined by `a` and `b` are equal",null,null],[17,"_SIDD_CMP_EQUAL_ORDERED","","Search for the defined substring in the target",null,null],[17,"_SIDD_POSITIVE_POLARITY","","Do not negate results (Default)",null,null],[17,"_SIDD_NEGATIVE_POLARITY","","Negates results",null,null],[17,"_SIDD_MASKED_POSITIVE_POLARITY","","Do not negate results before the end of the string",null,null],[17,"_SIDD_MASKED_NEGATIVE_POLARITY","","Negates results only before the end of the string",null,null],[17,"_SIDD_LEAST_SIGNIFICANT","","Index only: return the least significant bit (Default)",null,null],[17,"_SIDD_MOST_SIGNIFICANT","","Index only: return the most significant bit",null,null],[17,"_SIDD_BIT_MASK","","Mask only: return the bit mask",null,null],[17,"_SIDD_UNIT_MASK","","Mask only: return the byte mask",null,null],[17,"_CMP_EQ_OQ","","Equal (ordered, non-signaling)",null,null],[17,"_CMP_LT_OS","","Less-than (ordered, signaling)",null,null],[17,"_CMP_LE_OS","","Less-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_UNORD_Q","","Unordered (non-signaling)",null,null],[17,"_CMP_NEQ_UQ","","Not-equal (unordered, non-signaling)",null,null],[17,"_CMP_NLT_US","","Not-less-than (unordered, signaling)",null,null],[17,"_CMP_NLE_US","","Not-less-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_ORD_Q","","Ordered (non-signaling)",null,null],[17,"_CMP_EQ_UQ","","Equal (unordered, non-signaling)",null,null],[17,"_CMP_NGE_US","","Not-greater-than-or-equal (unordered, signaling)",null,null],[17,"_CMP_NGT_US","","Not-greater-than (unordered, signaling)",null,null],[17,"_CMP_FALSE_OQ","","False (ordered, non-signaling)",null,null],[17,"_CMP_NEQ_OQ","","Not-equal (ordered, non-signaling)",null,null],[17,"_CMP_GE_OS","","Greater-than-or-equal (ordered, signaling)",null,null],[17,"_CMP_GT_OS","","Greater-than (ordered, signaling)",null,null],[17,"_CMP_TRUE_UQ","","True (unordered, non-signaling)",null,null],[17,"_CMP_EQ_OS","","Equal (ordered, signaling)",null,null],[17,"_CMP_LT_OQ","","Less-than (ordered, non-signaling)",null,null],[17,"_CMP_LE_OQ","","Less-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_UNORD_S","","Unordered (signaling)",null,null],[17,"_CMP_NEQ_US","","Not-equal (unordered, signaling)",null,null],[17,"_CMP_NLT_UQ","","Not-less-than (unordered, non-signaling)",null,null],[17,"_CMP_NLE_UQ","","Not-less-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_ORD_S","","Ordered (signaling)",null,null],[17,"_CMP_EQ_US","","Equal (unordered, signaling)",null,null],[17,"_CMP_NGE_UQ","","Not-greater-than-or-equal (unordered, non-signaling)",null,null],[17,"_CMP_NGT_UQ","","Not-greater-than (unordered, non-signaling)",null,null],[17,"_CMP_FALSE_OS","","False (ordered, signaling)",null,null],[17,"_CMP_NEQ_OS","","Not-equal (ordered, signaling)",null,null],[17,"_CMP_GE_OQ","","Greater-than-or-equal (ordered, non-signaling)",null,null],[17,"_CMP_GT_OQ","","Greater-than (ordered, non-signaling)",null,null],[17,"_CMP_TRUE_US","","True (unordered, signaling)",null,null],[17,"_XBEGIN_STARTED","","Transaction successfully started.",null,null],[17,"_XABORT_EXPLICIT","","Transaction explicitly aborted with xabort. The parameter…",null,null],[17,"_XABORT_RETRY","","Transaction retry is possible.",null,null],[17,"_XABORT_CONFLICT","","Transaction abort due to a memory conflict with another…",null,null],[17,"_XABORT_CAPACITY","","Transaction abort due to the transaction using too much…",null,null],[17,"_XABORT_DEBUG","","Transaction abort due to a debug trap.",null,null],[17,"_XABORT_NESTED","","Transaction abort in a inner nested transaction.",null,null],[0,"arm","core::arch","Platform-specific intrinsics for the `arm` platform.",null,null],[3,"int8x8_t","core::arch::arm","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed…",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",null,null],[12,"0","","",168,null],[12,"1","","",168,null],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",null,null],[12,"0","","",169,null],[12,"1","","",169,null],[12,"2","","",169,null],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",null,null],[12,"0","","",170,null],[12,"1","","",170,null],[12,"2","","",170,null],[12,"3","","",170,null],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",null,null],[12,"0","","",171,null],[12,"1","","",171,null],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",null,null],[12,"0","","",172,null],[12,"1","","",172,null],[12,"2","","",172,null],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",null,null],[12,"0","","",173,null],[12,"1","","",173,null],[12,"2","","",173,null],[12,"3","","",173,null],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",null,null],[12,"0","","",174,null],[12,"1","","",174,null],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",null,null],[12,"0","","",175,null],[12,"1","","",175,null],[12,"2","","",175,null],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",null,null],[12,"0","","",176,null],[12,"1","","",176,null],[12,"2","","",176,null],[12,"3","","",176,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[5,"__breakpoint","","Inserts a breakpoint instruction.",null,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",null,[[]]],[5,"_rev_u32","","Reverse the order of the bytes.",null,[[]]],[5,"vand_s8","","Vector bitwise and",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vandq_s8","","Vector bitwise and",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vand_s16","","Vector bitwise and",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vandq_s16","","Vector bitwise and",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vand_s32","","Vector bitwise and",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vandq_s32","","Vector bitwise and",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vand_u8","","Vector bitwise and",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vandq_u8","","Vector bitwise and",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vand_u16","","Vector bitwise and",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vandq_u16","","Vector bitwise and",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vand_u32","","Vector bitwise and",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vandq_u32","","Vector bitwise and",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vand_s64","","Vector bitwise and",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vandq_s64","","Vector bitwise and",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vand_u64","","Vector bitwise and",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vandq_u64","","Vector bitwise and",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vorr_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vorrq_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vorr_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vorrq_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vorr_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vorrq_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vorr_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vorrq_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vorr_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vorrq_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vorr_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vorrq_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vorr_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vorrq_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vorr_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vorrq_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"veor_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"veorq_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"veor_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"veorq_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"veor_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"veorq_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"veor_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"veorq_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"veor_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"veorq_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"veor_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"veorq_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"veor_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"veorq_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"veor_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"veorq_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vceq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vceqq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vceq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vceqq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vceq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vceq_s8","","Compare bitwise Equal (vector)",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vceqq_s8","","Compare bitwise Equal (vector)",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vceq_s16","","Compare bitwise Equal (vector)",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vceqq_s16","","Compare bitwise Equal (vector)",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vceq_s32","","Compare bitwise Equal (vector)",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_s32","","Compare bitwise Equal (vector)",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vceq_f32","","Floating-point compare equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_f32","","Floating-point compare equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_s8","","Compare signed greater than",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcgtq_s8","","Compare signed greater than",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcgt_s16","","Compare signed greater than",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcgtq_s16","","Compare signed greater than",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcgt_s32","","Compare signed greater than",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_s32","","Compare signed greater than",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_u8","","Compare unsigned highe",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcgtq_u8","","Compare unsigned highe",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcgt_u16","","Compare unsigned highe",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcgtq_u16","","Compare unsigned highe",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcgt_u32","","Compare unsigned highe",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_u32","","Compare unsigned highe",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_f32","","Floating-point compare greater than",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_f32","","Floating-point compare greater than",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_s8","","Compare signed less than",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcltq_s8","","Compare signed less than",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vclt_s16","","Compare signed less than",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcltq_s16","","Compare signed less than",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vclt_s32","","Compare signed less than",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_s32","","Compare signed less than",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_u8","","Compare unsigned less than",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcltq_u8","","Compare unsigned less than",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vclt_u16","","Compare unsigned less than",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcltq_u16","","Compare unsigned less than",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vclt_u32","","Compare unsigned less than",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_u32","","Compare unsigned less than",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_f32","","Floating-point compare less than",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_f32","","Floating-point compare less than",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_s8","","Compare signed less than or equal",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcleq_s8","","Compare signed less than or equal",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcle_s16","","Compare signed less than or equal",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcleq_s16","","Compare signed less than or equal",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcle_s32","","Compare signed less than or equal",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_s32","","Compare signed less than or equal",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_u8","","Compare unsigned less than or equal",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcleq_u8","","Compare unsigned less than or equal",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcle_u16","","Compare unsigned less than or equal",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcleq_u16","","Compare unsigned less than or equal",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcle_u32","","Compare unsigned less than or equal",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_u32","","Compare unsigned less than or equal",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_f32","","Floating-point compare less than or equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_f32","","Floating-point compare less than or equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_s8","","Compare signed greater than or equal",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcgeq_s8","","Compare signed greater than or equal",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcge_s16","","Compare signed greater than or equal",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcgeq_s16","","Compare signed greater than or equal",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcge_s32","","Compare signed greater than or equal",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_s32","","Compare signed greater than or equal",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_u8","","Compare unsigned greater than or equal",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcgeq_u8","","Compare unsigned greater than or equal",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcge_u16","","Compare unsigned greater than or equal",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcgeq_u16","","Compare unsigned greater than or equal",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcge_u32","","Compare unsigned greater than or equal",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_u32","","Compare unsigned greater than or equal",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_f32","","Floating-point compare greater than or equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_f32","","Floating-point compare greater than or equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vqsub_u8","","Saturating subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqsubq_u8","","Saturating subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqsub_u16","","Saturating subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vqsubq_u16","","Saturating subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vqsub_u32","","Saturating subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vqsubq_u32","","Saturating subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vqsub_s8","","Saturating subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vqsubq_s8","","Saturating subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vqsub_s16","","Saturating subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vqsubq_s16","","Saturating subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vqsub_s32","","Saturating subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vqsubq_s32","","Saturating subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vhadd_u8","","Halving add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vhaddq_u8","","Halving add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vhadd_u16","","Halving add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vhaddq_u16","","Halving add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vhadd_u32","","Halving add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vhaddq_u32","","Halving add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vhadd_s8","","Halving add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vhaddq_s8","","Halving add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vhadd_s16","","Halving add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vhaddq_s16","","Halving add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vhadd_s32","","Halving add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vhaddq_s32","","Halving add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vrhadd_u8","","Rounding halving add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vrhaddq_u8","","Rounding halving add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vrhadd_u16","","Rounding halving add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vrhaddq_u16","","Rounding halving add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vrhadd_u32","","Rounding halving add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vrhaddq_u32","","Rounding halving add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vrhadd_s8","","Rounding halving add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vrhaddq_s8","","Rounding halving add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vrhadd_s16","","Rounding halving add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vrhaddq_s16","","Rounding halving add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vrhadd_s32","","Rounding halving add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vrhaddq_s32","","Rounding halving add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vqadd_u8","","Saturating add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqaddq_u8","","Saturating add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqadd_u16","","Saturating add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vqaddq_u16","","Saturating add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vqadd_u32","","Saturating add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vqaddq_u32","","Saturating add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vqadd_s8","","Saturating add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vqaddq_s8","","Saturating add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vqadd_s16","","Saturating add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vqaddq_s16","","Saturating add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vqadd_s32","","Saturating add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vqaddq_s32","","Saturating add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmul_s8","","Multiply",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vmulq_s8","","Multiply",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vmul_s16","","Multiply",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vmulq_s16","","Multiply",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vmul_s32","","Multiply",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vmulq_s32","","Multiply",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmul_u8","","Multiply",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vmulq_u8","","Multiply",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vmul_u16","","Multiply",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vmulq_u16","","Multiply",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vmul_u32","","Multiply",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vmulq_u32","","Multiply",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vmul_f32","","Multiply",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vmulq_f32","","Multiply",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vsub_s8","","Subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vsubq_s8","","Subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vsub_s16","","Subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vsubq_s16","","Subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vsub_s32","","Subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vsubq_s32","","Subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vsub_u8","","Subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vsubq_u8","","Subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vsub_u16","","Subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vsubq_u16","","Subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vsub_u32","","Subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vsubq_u32","","Subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsub_s64","","Subtract",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vsubq_s64","","Subtract",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vsub_u64","","Subtract",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vsubq_u64","","Subtract",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vsub_f32","","Subtract",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vsubq_f32","","Subtract",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vhsub_u8","","Signed halving subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vhsubq_u8","","Signed halving subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vhsub_u16","","Signed halving subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vhsubq_u16","","Signed halving subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vhsub_u32","","Signed halving subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vhsubq_u32","","Signed halving subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vhsub_s8","","Signed halving subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vhsubq_s8","","Signed halving subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vhsub_s16","","Signed halving subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vhsubq_s16","","Signed halving subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vhsub_s32","","Signed halving subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vhsubq_s32","","Signed halving subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vqmovn_u64","","Unsigned saturating extract narrow.",null,[[["uint64x2_t",3]],["uint32x2_t",3]]],[5,"vadd_s8","","Vector add.",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vaddq_s8","","Vector add.",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vadd_s16","","Vector add.",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vaddq_s16","","Vector add.",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vadd_s32","","Vector add.",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vaddq_s32","","Vector add.",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vaddq_s64","","Vector add.",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vadd_u8","","Vector add.",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vaddq_u8","","Vector add.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vadd_u16","","Vector add.",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vaddq_u16","","Vector add.",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vadd_u32","","Vector add.",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vaddq_u32","","Vector add.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vaddq_u64","","Vector add.",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vadd_f32","","Vector add.",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vaddq_f32","","Vector add.",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vaddl_s8","","Vector long add.",null,[[["int8x8_t",3]],["int16x8_t",3]]],[5,"vaddl_s16","","Vector long add.",null,[[["int16x4_t",3]],["int32x4_t",3]]],[5,"vaddl_s32","","Vector long add.",null,[[["int32x2_t",3]],["int64x2_t",3]]],[5,"vaddl_u8","","Vector long add.",null,[[["uint8x8_t",3]],["uint16x8_t",3]]],[5,"vaddl_u16","","Vector long add.",null,[[["uint16x4_t",3]],["uint32x4_t",3]]],[5,"vaddl_u32","","Vector long add.",null,[[["uint32x2_t",3]],["uint64x2_t",3]]],[5,"vmovn_s16","","Vector narrow integer.",null,[[["int16x8_t",3]],["int8x8_t",3]]],[5,"vmovn_s32","","Vector narrow integer.",null,[[["int32x4_t",3]],["int16x4_t",3]]],[5,"vmovn_s64","","Vector narrow integer.",null,[[["int64x2_t",3]],["int32x2_t",3]]],[5,"vmovn_u16","","Vector narrow integer.",null,[[["uint16x8_t",3]],["uint8x8_t",3]]],[5,"vmovn_u32","","Vector narrow integer.",null,[[["uint32x4_t",3]],["uint16x4_t",3]]],[5,"vmovn_u64","","Vector narrow integer.",null,[[["uint64x2_t",3]],["uint32x2_t",3]]],[5,"vmovl_s8","","Vector long move.",null,[[["int8x8_t",3]],["int16x8_t",3]]],[5,"vmovl_s16","","Vector long move.",null,[[["int16x4_t",3]],["int32x4_t",3]]],[5,"vmovl_s32","","Vector long move.",null,[[["int32x2_t",3]],["int64x2_t",3]]],[5,"vmovl_u8","","Vector long move.",null,[[["uint8x8_t",3]],["uint16x8_t",3]]],[5,"vmovl_u16","","Vector long move.",null,[[["uint16x4_t",3]],["uint32x4_t",3]]],[5,"vmovl_u32","","Vector long move.",null,[[["uint32x2_t",3]],["uint64x2_t",3]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vmvn_s8","","Vector bitwise not.",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vmvnq_s8","","Vector bitwise not.",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vmvn_s16","","Vector bitwise not.",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vmvnq_s16","","Vector bitwise not.",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vmvn_s32","","Vector bitwise not.",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vmvnq_s32","","Vector bitwise not.",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmvn_u8","","Vector bitwise not.",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vmvnq_u8","","Vector bitwise not.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vmvn_u16","","Vector bitwise not.",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vmvnq_u16","","Vector bitwise not.",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vmvn_u32","","Vector bitwise not.",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vmvnq_u32","","Vector bitwise not.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vmvn_p8","","Vector bitwise not.",null,[[["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vmvnq_p8","","Vector bitwise not.",null,[[["poly8x16_t",3]],["poly8x16_t",3]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vgetq_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x2_t",3]]]],[5,"vget_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x1_t",3]]]],[5,"vgetq_lane_u16","","Move vector element to general-purpose register",null,[[["uint16x8_t",3]]]],[5,"vgetq_lane_u32","","Move vector element to general-purpose register",null,[[["uint32x4_t",3]]]],[5,"vget_lane_u8","","Move vector element to general-purpose register",null,[[["uint8x8_t",3]]]],[5,"vdupq_n_s8","","Duplicate vector element to vector or scalar",null,[[],["int8x16_t",3]]],[5,"vdupq_n_u8","","Duplicate vector element to vector or scalar",null,[[],["uint8x16_t",3]]],[5,"vmovq_n_u8","","Duplicate vector element to vector or scalar",null,[[],["uint8x16_t",3]]],[5,"vreinterpret_u64_u32","","Vector reinterpret cast operation",null,[[["uint32x2_t",3]],["uint64x1_t",3]]],[5,"vreinterpretq_s8_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["int8x16_t",3]]],[5,"vreinterpretq_u16_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint16x8_t",3]]],[5,"vreinterpretq_u32_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint32x4_t",3]]],[5,"vreinterpretq_u64_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint64x2_t",3]]],[5,"vreinterpretq_u8_s8","","Vector reinterpret cast operation",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vshrq_n_u8","","Unsigned shift right",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vshlq_n_u8","","Shift right",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vextq_s8","","Extract vector from pair of vectors",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vextq_u8","","Extract vector from pair of vectors",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vld1q_s8","","Load multiple single-element structures to one, two,…",null,[[],["int8x16_t",3]]],[5,"vld1q_u8","","Load multiple single-element structures to one, two,…",null,[[],["uint8x16_t",3]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[]]],[5,"__rsrp","","Reads a system register containing an address",null,[[]]],[5,"__wsr","","Writes a 32-bit system register",null,[[]]],[5,"__wsrp","","Writes a system register containing an address",null,[[]]],[0,"aarch64","core::arch","Platform-specific intrinsics for the `aarch64` platform.",null,null],[3,"float64x1_t","core::arch::aarch64","ARM-specific 64-bit wide vector of one packed `f64`.",null,null],[3,"float64x2_t","","ARM-specific 128-bit wide vector of two packed `f64`.",null,null],[3,"poly64x1_t","","ARM-specific 64-bit wide vector of one packed `p64`.",null,null],[3,"poly64_t","","ARM-specific 64-bit wide vector of one packed `p64`.",null,null],[3,"poly64x2_t","","ARM-specific 64-bit wide vector of two packed `p64`.",null,null],[3,"poly128_t","","ARM-specific 128-bit wide vector of one packed `p64`.",null,null],[3,"int8x16x2_t","","ARM-specific type containing two `int8x16_t` vectors.",null,null],[12,"0","","",177,null],[12,"1","","",177,null],[3,"int8x16x3_t","","ARM-specific type containing three `int8x16_t` vectors.",null,null],[12,"0","","",178,null],[12,"1","","",178,null],[12,"2","","",178,null],[3,"int8x16x4_t","","ARM-specific type containing four `int8x16_t` vectors.",null,null],[12,"0","","",179,null],[12,"1","","",179,null],[12,"2","","",179,null],[12,"3","","",179,null],[3,"uint8x16x2_t","","ARM-specific type containing two `uint8x16_t` vectors.",null,null],[12,"0","","",180,null],[12,"1","","",180,null],[3,"uint8x16x3_t","","ARM-specific type containing three `uint8x16_t` vectors.",null,null],[12,"0","","",181,null],[12,"1","","",181,null],[12,"2","","",181,null],[3,"uint8x16x4_t","","ARM-specific type containing four `uint8x16_t` vectors.",null,null],[12,"0","","",182,null],[12,"1","","",182,null],[12,"2","","",182,null],[12,"3","","",182,null],[3,"poly8x16x2_t","","ARM-specific type containing two `poly8x16_t` vectors.",null,null],[12,"0","","",183,null],[12,"1","","",183,null],[3,"poly8x16x3_t","","ARM-specific type containing three `poly8x16_t` vectors.",null,null],[12,"0","","",184,null],[12,"1","","",184,null],[12,"2","","",184,null],[3,"poly8x16x4_t","","ARM-specific type containing four `poly8x16_t` vectors.",null,null],[12,"0","","",185,null],[12,"1","","",185,null],[12,"2","","",185,null],[12,"3","","",185,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[3,"int8x8_t","","ARM-specific 64-bit wide vector of eight packed `i8`.",null,null],[3,"uint8x8_t","","ARM-specific 64-bit wide vector of eight packed `u8`.",null,null],[3,"poly8x8_t","","ARM-specific 64-bit wide polynomial vector of eight packed…",null,null],[3,"int16x4_t","","ARM-specific 64-bit wide vector of four packed `i16`.",null,null],[3,"uint16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"poly16x4_t","","ARM-specific 64-bit wide vector of four packed `u16`.",null,null],[3,"int32x2_t","","ARM-specific 64-bit wide vector of two packed `i32`.",null,null],[3,"uint32x2_t","","ARM-specific 64-bit wide vector of two packed `u32`.",null,null],[3,"float32x2_t","","ARM-specific 64-bit wide vector of two packed `f32`.",null,null],[3,"int64x1_t","","ARM-specific 64-bit wide vector of one packed `i64`.",null,null],[3,"uint64x1_t","","ARM-specific 64-bit wide vector of one packed `u64`.",null,null],[3,"int8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `i8`.",null,null],[3,"uint8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"poly8x16_t","","ARM-specific 128-bit wide vector of sixteen packed `u8`.",null,null],[3,"int16x8_t","","ARM-specific 128-bit wide vector of eight packed `i16`.",null,null],[3,"uint16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"poly16x8_t","","ARM-specific 128-bit wide vector of eight packed `u16`.",null,null],[3,"int32x4_t","","ARM-specific 128-bit wide vector of four packed `i32`.",null,null],[3,"uint32x4_t","","ARM-specific 128-bit wide vector of four packed `u32`.",null,null],[3,"float32x4_t","","ARM-specific 128-bit wide vector of four packed `f32`.",null,null],[3,"int64x2_t","","ARM-specific 128-bit wide vector of two packed `i64`.",null,null],[3,"uint64x2_t","","ARM-specific 128-bit wide vector of two packed `u64`.",null,null],[3,"int8x8x2_t","","ARM-specific type containing two `int8x8_t` vectors.",null,null],[12,"0","","",168,null],[12,"1","","",168,null],[3,"int8x8x3_t","","ARM-specific type containing three `int8x8_t` vectors.",null,null],[12,"0","","",169,null],[12,"1","","",169,null],[12,"2","","",169,null],[3,"int8x8x4_t","","ARM-specific type containing four `int8x8_t` vectors.",null,null],[12,"0","","",170,null],[12,"1","","",170,null],[12,"2","","",170,null],[12,"3","","",170,null],[3,"uint8x8x2_t","","ARM-specific type containing two `uint8x8_t` vectors.",null,null],[12,"0","","",171,null],[12,"1","","",171,null],[3,"uint8x8x3_t","","ARM-specific type containing three `uint8x8_t` vectors.",null,null],[12,"0","","",172,null],[12,"1","","",172,null],[12,"2","","",172,null],[3,"uint8x8x4_t","","ARM-specific type containing four `uint8x8_t` vectors.",null,null],[12,"0","","",173,null],[12,"1","","",173,null],[12,"2","","",173,null],[12,"3","","",173,null],[3,"poly8x8x2_t","","ARM-specific type containing two `poly8x8_t` vectors.",null,null],[12,"0","","",174,null],[12,"1","","",174,null],[3,"poly8x8x3_t","","ARM-specific type containing three `poly8x8_t` vectors.",null,null],[12,"0","","",175,null],[12,"1","","",175,null],[12,"2","","",175,null],[3,"poly8x8x4_t","","ARM-specific type containing four `poly8x8_t` vectors.",null,null],[12,"0","","",176,null],[12,"1","","",176,null],[12,"2","","",176,null],[12,"3","","",176,null],[3,"SY","","Full system is the required shareability domain, reads and…",null,null],[3,"APSR","","Application Program Status Register",null,null],[5,"_rev_u64","","Reverse the order of the bytes.",null,[[]]],[5,"_clz_u64","","Count Leading Zeros.",null,[[]]],[5,"_rbit_u64","","Reverse the bit order.",null,[[]]],[5,"_cls_u32","","Counts the leading most significant bits set.",null,[[]]],[5,"_cls_u64","","Counts the leading most significant bits set.",null,[[]]],[5,"vceq_u64","","Compare bitwise Equal (vector)",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vceqq_u64","","Compare bitwise Equal (vector)",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vceq_s64","","Compare bitwise Equal (vector)",null,[[["int64x1_t",3]],["uint64x1_t",3]]],[5,"vceqq_s64","","Compare bitwise Equal (vector)",null,[[["int64x2_t",3]],["uint64x2_t",3]]],[5,"vceq_p64","","Compare bitwise Equal (vector)",null,[[["poly64x1_t",3]],["uint64x1_t",3]]],[5,"vceqq_p64","","Compare bitwise Equal (vector)",null,[[["poly64x2_t",3]],["uint64x2_t",3]]],[5,"vceq_f64","","Floating-point compare equal",null,[[["float64x1_t",3]],["uint64x1_t",3]]],[5,"vceqq_f64","","Floating-point compare equal",null,[[["float64x2_t",3]],["uint64x2_t",3]]],[5,"vcgt_s64","","Compare signed greater than",null,[[["int64x1_t",3]],["uint64x1_t",3]]],[5,"vcgtq_s64","","Compare signed greater than",null,[[["int64x2_t",3]],["uint64x2_t",3]]],[5,"vcgt_u64","","Compare unsigned highe",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vcgtq_u64","","Compare unsigned highe",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vcgt_f64","","Floating-point compare greater than",null,[[["float64x1_t",3]],["uint64x1_t",3]]],[5,"vcgtq_f64","","Floating-point compare greater than",null,[[["float64x2_t",3]],["uint64x2_t",3]]],[5,"vclt_s64","","Compare signed less than",null,[[["int64x1_t",3]],["uint64x1_t",3]]],[5,"vcltq_s64","","Compare signed less than",null,[[["int64x2_t",3]],["uint64x2_t",3]]],[5,"vclt_u64","","Compare unsigned less than",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vcltq_u64","","Compare unsigned less than",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vclt_f64","","Floating-point compare less than",null,[[["float64x1_t",3]],["uint64x1_t",3]]],[5,"vcltq_f64","","Floating-point compare less than",null,[[["float64x2_t",3]],["uint64x2_t",3]]],[5,"vcle_s64","","Compare signed less than or equal",null,[[["int64x1_t",3]],["uint64x1_t",3]]],[5,"vcleq_s64","","Compare signed less than or equal",null,[[["int64x2_t",3]],["uint64x2_t",3]]],[5,"vcle_u64","","Compare unsigned less than or equal",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vcleq_u64","","Compare unsigned less than or equal",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vcle_f64","","Floating-point compare less than or equal",null,[[["float64x1_t",3]],["uint64x1_t",3]]],[5,"vcleq_f64","","Floating-point compare less than or equal",null,[[["float64x2_t",3]],["uint64x2_t",3]]],[5,"vcge_s64","","Compare signed greater than or equal",null,[[["int64x1_t",3]],["uint64x1_t",3]]],[5,"vcgeq_s64","","Compare signed greater than or equal",null,[[["int64x2_t",3]],["uint64x2_t",3]]],[5,"vcge_u64","","Compare unsigned greater than or equal",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vcgeq_u64","","Compare unsigned greater than or equal",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vcge_f64","","Floating-point compare greater than or equal",null,[[["float64x1_t",3]],["uint64x1_t",3]]],[5,"vcgeq_f64","","Floating-point compare greater than or equal",null,[[["float64x2_t",3]],["uint64x2_t",3]]],[5,"vmul_f64","","Multiply",null,[[["float64x1_t",3]],["float64x1_t",3]]],[5,"vmulq_f64","","Multiply",null,[[["float64x2_t",3]],["float64x2_t",3]]],[5,"vsub_f64","","Subtract",null,[[["float64x1_t",3]],["float64x1_t",3]]],[5,"vsubq_f64","","Subtract",null,[[["float64x2_t",3]],["float64x2_t",3]]],[5,"vpaddq_u8","","Add pairwise",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vmull_p64","","Polynomial multiply long",null,[[["poly64_t",3]],["poly128_t",3]]],[5,"vadd_f64","","Vector add.",null,[[["float64x1_t",3]],["float64x1_t",3]]],[5,"vaddq_f64","","Vector add.",null,[[["float64x2_t",3]],["float64x2_t",3]]],[5,"vaddd_s64","","Vector add.",null,[[]]],[5,"vaddd_u64","","Vector add.",null,[[]]],[5,"vmaxv_s8","","Horizontal vector max.",null,[[["int8x8_t",3]]]],[5,"vmaxvq_s8","","Horizontal vector max.",null,[[["int8x16_t",3]]]],[5,"vmaxv_s16","","Horizontal vector max.",null,[[["int16x4_t",3]]]],[5,"vmaxvq_s16","","Horizontal vector max.",null,[[["int16x8_t",3]]]],[5,"vmaxv_s32","","Horizontal vector max.",null,[[["int32x2_t",3]]]],[5,"vmaxvq_s32","","Horizontal vector max.",null,[[["int32x4_t",3]]]],[5,"vmaxv_u8","","Horizontal vector max.",null,[[["uint8x8_t",3]]]],[5,"vmaxvq_u8","","Horizontal vector max.",null,[[["uint8x16_t",3]]]],[5,"vmaxv_u16","","Horizontal vector max.",null,[[["uint16x4_t",3]]]],[5,"vmaxvq_u16","","Horizontal vector max.",null,[[["uint16x8_t",3]]]],[5,"vmaxv_u32","","Horizontal vector max.",null,[[["uint32x2_t",3]]]],[5,"vmaxvq_u32","","Horizontal vector max.",null,[[["uint32x4_t",3]]]],[5,"vmaxv_f32","","Horizontal vector max.",null,[[["float32x2_t",3]]]],[5,"vmaxvq_f32","","Horizontal vector max.",null,[[["float32x4_t",3]]]],[5,"vmaxvq_f64","","Horizontal vector max.",null,[[["float64x2_t",3]]]],[5,"vminv_s8","","Horizontal vector min.",null,[[["int8x8_t",3]]]],[5,"vminvq_s8","","Horizontal vector min.",null,[[["int8x16_t",3]]]],[5,"vminv_s16","","Horizontal vector min.",null,[[["int16x4_t",3]]]],[5,"vminvq_s16","","Horizontal vector min.",null,[[["int16x8_t",3]]]],[5,"vminv_s32","","Horizontal vector min.",null,[[["int32x2_t",3]]]],[5,"vminvq_s32","","Horizontal vector min.",null,[[["int32x4_t",3]]]],[5,"vminv_u8","","Horizontal vector min.",null,[[["uint8x8_t",3]]]],[5,"vminvq_u8","","Horizontal vector min.",null,[[["uint8x16_t",3]]]],[5,"vminv_u16","","Horizontal vector min.",null,[[["uint16x4_t",3]]]],[5,"vminvq_u16","","Horizontal vector min.",null,[[["uint16x8_t",3]]]],[5,"vminv_u32","","Horizontal vector min.",null,[[["uint32x2_t",3]]]],[5,"vminvq_u32","","Horizontal vector min.",null,[[["uint32x4_t",3]]]],[5,"vminv_f32","","Horizontal vector min.",null,[[["float32x2_t",3]]]],[5,"vminvq_f32","","Horizontal vector min.",null,[[["float32x4_t",3]]]],[5,"vminvq_f64","","Horizontal vector min.",null,[[["float64x2_t",3]]]],[5,"vpminq_s8","","Folding minimum of adjacent pairs",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vpminq_s16","","Folding minimum of adjacent pairs",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vpminq_s32","","Folding minimum of adjacent pairs",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vpminq_u8","","Folding minimum of adjacent pairs",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vpminq_u16","","Folding minimum of adjacent pairs",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vpminq_u32","","Folding minimum of adjacent pairs",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vpminq_f32","","Folding minimum of adjacent pairs",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vpminq_f64","","Folding minimum of adjacent pairs",null,[[["float64x2_t",3]],["float64x2_t",3]]],[5,"vpmaxq_s8","","Folding maximum of adjacent pairs",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vpmaxq_s16","","Folding maximum of adjacent pairs",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vpmaxq_s32","","Folding maximum of adjacent pairs",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vpmaxq_u8","","Folding maximum of adjacent pairs",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vpmaxq_u16","","Folding maximum of adjacent pairs",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vpmaxq_u32","","Folding maximum of adjacent pairs",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vpmaxq_f32","","Folding maximum of adjacent pairs",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vpmaxq_f64","","Folding maximum of adjacent pairs",null,[[["float64x2_t",3]],["float64x2_t",3]]],[5,"vcombine_s8","","Vector combine",null,[[["int8x8_t",3]],["int8x16_t",3]]],[5,"vcombine_s16","","Vector combine",null,[[["int16x4_t",3]],["int16x8_t",3]]],[5,"vcombine_s32","","Vector combine",null,[[["int32x2_t",3]],["int32x4_t",3]]],[5,"vcombine_s64","","Vector combine",null,[[["int64x1_t",3]],["int64x2_t",3]]],[5,"vcombine_u8","","Vector combine",null,[[["uint8x8_t",3]],["uint8x16_t",3]]],[5,"vcombine_u16","","Vector combine",null,[[["uint16x4_t",3]],["uint16x8_t",3]]],[5,"vcombine_u32","","Vector combine",null,[[["uint32x2_t",3]],["uint32x4_t",3]]],[5,"vcombine_u64","","Vector combine",null,[[["uint64x1_t",3]],["uint64x2_t",3]]],[5,"vcombine_p64","","Vector combine",null,[[["poly64x1_t",3]],["poly64x2_t",3]]],[5,"vcombine_f32","","Vector combine",null,[[["float32x2_t",3]],["float32x4_t",3]]],[5,"vcombine_p8","","Vector combine",null,[[["poly8x8_t",3]],["poly8x16_t",3]]],[5,"vcombine_p16","","Vector combine",null,[[["poly16x4_t",3]],["poly16x8_t",3]]],[5,"vcombine_f64","","Vector combine",null,[[["float64x1_t",3]],["float64x2_t",3]]],[5,"vtbl1_s8","","Table look-up",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vtbl1_u8","","Table look-up",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vtbl1_p8","","Table look-up",null,[[["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vtbl2_s8","","Table look-up",null,[[["int8x8x2_t",3],["int8x8_t",3]],["int8x8_t",3]]],[5,"vtbl2_u8","","Table look-up",null,[[["uint8x8x2_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vtbl2_p8","","Table look-up",null,[[["uint8x8_t",3],["poly8x8x2_t",3]],["poly8x8_t",3]]],[5,"vtbl3_s8","","Table look-up",null,[[["int8x8_t",3],["int8x8x3_t",3]],["int8x8_t",3]]],[5,"vtbl3_u8","","Table look-up",null,[[["uint8x8x3_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vtbl3_p8","","Table look-up",null,[[["poly8x8x3_t",3],["uint8x8_t",3]],["poly8x8_t",3]]],[5,"vtbl4_s8","","Table look-up",null,[[["int8x8_t",3],["int8x8x4_t",3]],["int8x8_t",3]]],[5,"vtbl4_u8","","Table look-up",null,[[["uint8x8_t",3],["uint8x8x4_t",3]],["uint8x8_t",3]]],[5,"vtbl4_p8","","Table look-up",null,[[["poly8x8x4_t",3],["uint8x8_t",3]],["poly8x8_t",3]]],[5,"vtbx1_s8","","Extended table look-up",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vtbx1_u8","","Extended table look-up",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vtbx1_p8","","Extended table look-up",null,[[["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vtbx2_s8","","Extended table look-up",null,[[["int8x8_t",3],["int8x8x2_t",3]],["int8x8_t",3]]],[5,"vtbx2_u8","","Extended table look-up",null,[[["uint8x8_t",3],["uint8x8x2_t",3]],["uint8x8_t",3]]],[5,"vtbx2_p8","","Extended table look-up",null,[[["poly8x8x2_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vtbx3_s8","","Extended table look-up",null,[[["int8x8_t",3],["int8x8x3_t",3]],["int8x8_t",3]]],[5,"vtbx3_u8","","Extended table look-up",null,[[["uint8x8x3_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vtbx3_p8","","Extended table look-up",null,[[["poly8x8x3_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vtbx4_s8","","Extended table look-up",null,[[["int8x8_t",3],["int8x8x4_t",3]],["int8x8_t",3]]],[5,"vtbx4_u8","","Extended table look-up",null,[[["uint8x8_t",3],["uint8x8x4_t",3]],["uint8x8_t",3]]],[5,"vtbx4_p8","","Extended table look-up",null,[[["poly8x8x4_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbl1_s8","","Table look-up",null,[[["uint8x8_t",3],["int8x16_t",3]],["int8x8_t",3]]],[5,"vqtbl1q_s8","","Table look-up",null,[[["uint8x16_t",3],["int8x16_t",3]],["int8x16_t",3]]],[5,"vqtbl1_u8","","Table look-up",null,[[["uint8x16_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqtbl1q_u8","","Table look-up",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqtbl1_p8","","Table look-up",null,[[["poly8x16_t",3],["uint8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbl1q_p8","","Table look-up",null,[[["poly8x16_t",3],["uint8x16_t",3]],["poly8x16_t",3]]],[5,"vqtbx1_s8","","Extended table look-up",null,[[["int8x8_t",3],["uint8x8_t",3],["int8x16_t",3]],["int8x8_t",3]]],[5,"vqtbx1q_s8","","Extended table look-up",null,[[["uint8x16_t",3],["int8x16_t",3]],["int8x16_t",3]]],[5,"vqtbx1_u8","","Extended table look-up",null,[[["uint8x16_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqtbx1q_u8","","Extended table look-up",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqtbx1_p8","","Extended table look-up",null,[[["poly8x16_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbx1q_p8","","Extended table look-up",null,[[["poly8x16_t",3],["uint8x16_t",3]],["poly8x16_t",3]]],[5,"vqtbl2_s8","","Table look-up",null,[[["uint8x8_t",3],["int8x16x2_t",3]],["int8x8_t",3]]],[5,"vqtbl2q_s8","","Table look-up",null,[[["uint8x16_t",3],["int8x16x2_t",3]],["int8x16_t",3]]],[5,"vqtbl2_u8","","Table look-up",null,[[["uint8x16x2_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqtbl2q_u8","","Table look-up",null,[[["uint8x16x2_t",3],["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqtbl2_p8","","Table look-up",null,[[["poly8x16x2_t",3],["uint8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbl2q_p8","","Table look-up",null,[[["uint8x16_t",3],["poly8x16x2_t",3]],["poly8x16_t",3]]],[5,"vqtbx2_s8","","Extended table look-up",null,[[["int8x8_t",3],["uint8x8_t",3],["int8x16x2_t",3]],["int8x8_t",3]]],[5,"vqtbx2q_s8","","Extended table look-up",null,[[["int8x16x2_t",3],["uint8x16_t",3],["int8x16_t",3]],["int8x16_t",3]]],[5,"vqtbx2_u8","","Extended table look-up",null,[[["uint8x16x2_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqtbx2q_u8","","Extended table look-up",null,[[["uint8x16_t",3],["uint8x16x2_t",3]],["uint8x16_t",3]]],[5,"vqtbx2_p8","","Extended table look-up",null,[[["poly8x16x2_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbx2q_p8","","Extended table look-up",null,[[["poly8x16_t",3],["poly8x16x2_t",3],["uint8x16_t",3]],["poly8x16_t",3]]],[5,"vqtbl3_s8","","Table look-up",null,[[["int8x16x3_t",3],["uint8x8_t",3]],["int8x8_t",3]]],[5,"vqtbl3q_s8","","Table look-up",null,[[["int8x16x3_t",3],["uint8x16_t",3]],["int8x16_t",3]]],[5,"vqtbl3_u8","","Table look-up",null,[[["uint8x16x3_t",3],["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqtbl3q_u8","","Table look-up",null,[[["uint8x16_t",3],["uint8x16x3_t",3]],["uint8x16_t",3]]],[5,"vqtbl3_p8","","Table look-up",null,[[["uint8x8_t",3],["poly8x16x3_t",3]],["poly8x8_t",3]]],[5,"vqtbl3q_p8","","Table look-up",null,[[["uint8x16_t",3],["poly8x16x3_t",3]],["poly8x16_t",3]]],[5,"vqtbx3_s8","","Extended table look-up",null,[[["int8x16x3_t",3],["int8x8_t",3],["uint8x8_t",3]],["int8x8_t",3]]],[5,"vqtbx3q_s8","","Extended table look-up",null,[[["int8x16x3_t",3],["uint8x16_t",3],["int8x16_t",3]],["int8x16_t",3]]],[5,"vqtbx3_u8","","Extended table look-up",null,[[["uint8x8_t",3],["uint8x16x3_t",3]],["uint8x8_t",3]]],[5,"vqtbx3q_u8","","Extended table look-up",null,[[["uint8x16_t",3],["uint8x16x3_t",3]],["uint8x16_t",3]]],[5,"vqtbx3_p8","","Extended table look-up",null,[[["poly8x16x3_t",3],["uint8x8_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbx3q_p8","","Extended table look-up",null,[[["poly8x16_t",3],["uint8x16_t",3],["poly8x16x3_t",3]],["poly8x16_t",3]]],[5,"vqtbl4_s8","","Table look-up",null,[[["int8x16x4_t",3],["uint8x8_t",3]],["int8x8_t",3]]],[5,"vqtbl4q_s8","","Table look-up",null,[[["uint8x16_t",3],["int8x16x4_t",3]],["int8x16_t",3]]],[5,"vqtbl4_u8","","Table look-up",null,[[["uint8x8_t",3],["uint8x16x4_t",3]],["uint8x8_t",3]]],[5,"vqtbl4q_u8","","Table look-up",null,[[["uint8x16_t",3],["uint8x16x4_t",3]],["uint8x16_t",3]]],[5,"vqtbl4_p8","","Table look-up",null,[[["uint8x8_t",3],["poly8x16x4_t",3]],["poly8x8_t",3]]],[5,"vqtbl4q_p8","","Table look-up",null,[[["uint8x16_t",3],["poly8x16x4_t",3]],["poly8x16_t",3]]],[5,"vqtbx4_s8","","Extended table look-up",null,[[["int8x8_t",3],["int8x16x4_t",3],["uint8x8_t",3]],["int8x8_t",3]]],[5,"vqtbx4q_s8","","Extended table look-up",null,[[["uint8x16_t",3],["int8x16x4_t",3],["int8x16_t",3]],["int8x16_t",3]]],[5,"vqtbx4_u8","","Extended table look-up",null,[[["uint8x8_t",3],["uint8x16x4_t",3]],["uint8x8_t",3]]],[5,"vqtbx4q_u8","","Extended table look-up",null,[[["uint8x16_t",3],["uint8x16x4_t",3]],["uint8x16_t",3]]],[5,"vqtbx4_p8","","Extended table look-up",null,[[["uint8x8_t",3],["poly8x16x4_t",3],["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vqtbx4q_p8","","Extended table look-up",null,[[["poly8x16_t",3],["uint8x16_t",3],["poly8x16x4_t",3]],["poly8x16_t",3]]],[5,"vaeseq_u8","","AES single round encryption.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vaesdq_u8","","AES single round decryption.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vaesmcq_u8","","AES mix columns.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vaesimcq_u8","","AES inverse mix columns.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vsha1h_u32","","SHA1 fixed rotate.",null,[[]]],[5,"vsha1cq_u32","","SHA1 hash update accelerator, choose.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha1mq_u32","","SHA1 hash update accelerator, majority.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha1pq_u32","","SHA1 hash update accelerator, parity.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha1su0q_u32","","SHA1 schedule update accelerator, first part.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha1su1q_u32","","SHA1 schedule update accelerator, second part.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha256hq_u32","","SHA256 hash update accelerator.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha256h2q_u32","","SHA256 hash update accelerator, upper part.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha256su0q_u32","","SHA256 schedule update accelerator, first part.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsha256su1q_u32","","SHA256 schedule update accelerator, second part.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"__tstart","","Starts a new transaction. When the transaction starts…",null,[[]]],[5,"__tcommit","","Commits the current transaction. For a nested transaction,…",null,[[]]],[5,"__tcancel","","Cancels the current transaction and discards all state…",null,[[]]],[5,"__ttest","","Tests if executing inside a transaction. If no transaction…",null,[[]]],[5,"__crc32d","","CRC32 single round checksum for quad words (64 bits).",null,[[]]],[5,"__crc32cd","","CRC32-C single round checksum for quad words (64 bits).",null,[[]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[]]],[5,"__rsrp","","Reads a system register containing an address",null,[[]]],[5,"__wsr","","Writes a 32-bit system register",null,[[]]],[5,"__wsrp","","Writes a system register containing an address",null,[[]]],[5,"brk","","Generates the trap instruction `BRK 1`",null,[[]]],[5,"__breakpoint","","Inserts a breakpoint instruction.",null,[[]]],[5,"_rev_u16","","Reverse the order of the bytes.",null,[[]]],[5,"_rev_u32","","Reverse the order of the bytes.",null,[[]]],[5,"vand_s8","","Vector bitwise and",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vandq_s8","","Vector bitwise and",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vand_s16","","Vector bitwise and",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vandq_s16","","Vector bitwise and",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vand_s32","","Vector bitwise and",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vandq_s32","","Vector bitwise and",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vand_u8","","Vector bitwise and",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vandq_u8","","Vector bitwise and",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vand_u16","","Vector bitwise and",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vandq_u16","","Vector bitwise and",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vand_u32","","Vector bitwise and",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vandq_u32","","Vector bitwise and",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vand_s64","","Vector bitwise and",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vandq_s64","","Vector bitwise and",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vand_u64","","Vector bitwise and",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vandq_u64","","Vector bitwise and",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vorr_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vorrq_s8","","Vector bitwise or (immediate, inclusive)",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vorr_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vorrq_s16","","Vector bitwise or (immediate, inclusive)",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vorr_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vorrq_s32","","Vector bitwise or (immediate, inclusive)",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vorr_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vorrq_u8","","Vector bitwise or (immediate, inclusive)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vorr_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vorrq_u16","","Vector bitwise or (immediate, inclusive)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vorr_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vorrq_u32","","Vector bitwise or (immediate, inclusive)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vorr_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vorrq_s64","","Vector bitwise or (immediate, inclusive)",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vorr_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vorrq_u64","","Vector bitwise or (immediate, inclusive)",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"veor_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"veorq_s8","","Vector bitwise exclusive or (vector)",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"veor_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"veorq_s16","","Vector bitwise exclusive or (vector)",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"veor_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"veorq_s32","","Vector bitwise exclusive or (vector)",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"veor_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"veorq_u8","","Vector bitwise exclusive or (vector)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"veor_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"veorq_u16","","Vector bitwise exclusive or (vector)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"veor_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"veorq_u32","","Vector bitwise exclusive or (vector)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"veor_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"veorq_s64","","Vector bitwise exclusive or (vector)",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"veor_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"veorq_u64","","Vector bitwise exclusive or (vector)",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vceq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vceqq_u8","","Compare bitwise Equal (vector)",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vceq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vceqq_u16","","Compare bitwise Equal (vector)",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vceq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_u32","","Compare bitwise Equal (vector)",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vceq_s8","","Compare bitwise Equal (vector)",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vceqq_s8","","Compare bitwise Equal (vector)",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vceq_s16","","Compare bitwise Equal (vector)",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vceqq_s16","","Compare bitwise Equal (vector)",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vceq_s32","","Compare bitwise Equal (vector)",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_s32","","Compare bitwise Equal (vector)",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vceq_f32","","Floating-point compare equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vceqq_f32","","Floating-point compare equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_s8","","Compare signed greater than",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcgtq_s8","","Compare signed greater than",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcgt_s16","","Compare signed greater than",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcgtq_s16","","Compare signed greater than",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcgt_s32","","Compare signed greater than",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_s32","","Compare signed greater than",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_u8","","Compare unsigned highe",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcgtq_u8","","Compare unsigned highe",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcgt_u16","","Compare unsigned highe",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcgtq_u16","","Compare unsigned highe",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcgt_u32","","Compare unsigned highe",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_u32","","Compare unsigned highe",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcgt_f32","","Floating-point compare greater than",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcgtq_f32","","Floating-point compare greater than",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_s8","","Compare signed less than",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcltq_s8","","Compare signed less than",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vclt_s16","","Compare signed less than",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcltq_s16","","Compare signed less than",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vclt_s32","","Compare signed less than",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_s32","","Compare signed less than",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_u8","","Compare unsigned less than",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcltq_u8","","Compare unsigned less than",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vclt_u16","","Compare unsigned less than",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcltq_u16","","Compare unsigned less than",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vclt_u32","","Compare unsigned less than",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_u32","","Compare unsigned less than",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vclt_f32","","Floating-point compare less than",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcltq_f32","","Floating-point compare less than",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_s8","","Compare signed less than or equal",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcleq_s8","","Compare signed less than or equal",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcle_s16","","Compare signed less than or equal",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcleq_s16","","Compare signed less than or equal",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcle_s32","","Compare signed less than or equal",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_s32","","Compare signed less than or equal",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_u8","","Compare unsigned less than or equal",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcleq_u8","","Compare unsigned less than or equal",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcle_u16","","Compare unsigned less than or equal",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcleq_u16","","Compare unsigned less than or equal",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcle_u32","","Compare unsigned less than or equal",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_u32","","Compare unsigned less than or equal",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcle_f32","","Floating-point compare less than or equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcleq_f32","","Floating-point compare less than or equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_s8","","Compare signed greater than or equal",null,[[["int8x8_t",3]],["uint8x8_t",3]]],[5,"vcgeq_s8","","Compare signed greater than or equal",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vcge_s16","","Compare signed greater than or equal",null,[[["int16x4_t",3]],["uint16x4_t",3]]],[5,"vcgeq_s16","","Compare signed greater than or equal",null,[[["int16x8_t",3]],["uint16x8_t",3]]],[5,"vcge_s32","","Compare signed greater than or equal",null,[[["int32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_s32","","Compare signed greater than or equal",null,[[["int32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_u8","","Compare unsigned greater than or equal",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vcgeq_u8","","Compare unsigned greater than or equal",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vcge_u16","","Compare unsigned greater than or equal",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vcgeq_u16","","Compare unsigned greater than or equal",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vcge_u32","","Compare unsigned greater than or equal",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_u32","","Compare unsigned greater than or equal",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vcge_f32","","Floating-point compare greater than or equal",null,[[["float32x2_t",3]],["uint32x2_t",3]]],[5,"vcgeq_f32","","Floating-point compare greater than or equal",null,[[["float32x4_t",3]],["uint32x4_t",3]]],[5,"vqsub_u8","","Saturating subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqsubq_u8","","Saturating subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqsub_u16","","Saturating subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vqsubq_u16","","Saturating subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vqsub_u32","","Saturating subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vqsubq_u32","","Saturating subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vqsub_s8","","Saturating subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vqsubq_s8","","Saturating subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vqsub_s16","","Saturating subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vqsubq_s16","","Saturating subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vqsub_s32","","Saturating subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vqsubq_s32","","Saturating subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vhadd_u8","","Halving add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vhaddq_u8","","Halving add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vhadd_u16","","Halving add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vhaddq_u16","","Halving add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vhadd_u32","","Halving add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vhaddq_u32","","Halving add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vhadd_s8","","Halving add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vhaddq_s8","","Halving add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vhadd_s16","","Halving add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vhaddq_s16","","Halving add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vhadd_s32","","Halving add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vhaddq_s32","","Halving add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vrhadd_u8","","Rounding halving add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vrhaddq_u8","","Rounding halving add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vrhadd_u16","","Rounding halving add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vrhaddq_u16","","Rounding halving add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vrhadd_u32","","Rounding halving add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vrhaddq_u32","","Rounding halving add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vrhadd_s8","","Rounding halving add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vrhaddq_s8","","Rounding halving add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vrhadd_s16","","Rounding halving add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vrhaddq_s16","","Rounding halving add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vrhadd_s32","","Rounding halving add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vrhaddq_s32","","Rounding halving add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vqadd_u8","","Saturating add",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vqaddq_u8","","Saturating add",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vqadd_u16","","Saturating add",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vqaddq_u16","","Saturating add",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vqadd_u32","","Saturating add",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vqaddq_u32","","Saturating add",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vqadd_s8","","Saturating add",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vqaddq_s8","","Saturating add",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vqadd_s16","","Saturating add",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vqaddq_s16","","Saturating add",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vqadd_s32","","Saturating add",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vqaddq_s32","","Saturating add",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmul_s8","","Multiply",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vmulq_s8","","Multiply",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vmul_s16","","Multiply",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vmulq_s16","","Multiply",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vmul_s32","","Multiply",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vmulq_s32","","Multiply",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmul_u8","","Multiply",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vmulq_u8","","Multiply",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vmul_u16","","Multiply",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vmulq_u16","","Multiply",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vmul_u32","","Multiply",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vmulq_u32","","Multiply",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vmul_f32","","Multiply",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vmulq_f32","","Multiply",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vsub_s8","","Subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vsubq_s8","","Subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vsub_s16","","Subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vsubq_s16","","Subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vsub_s32","","Subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vsubq_s32","","Subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vsub_u8","","Subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vsubq_u8","","Subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vsub_u16","","Subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vsubq_u16","","Subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vsub_u32","","Subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vsubq_u32","","Subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vsub_s64","","Subtract",null,[[["int64x1_t",3]],["int64x1_t",3]]],[5,"vsubq_s64","","Subtract",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vsub_u64","","Subtract",null,[[["uint64x1_t",3]],["uint64x1_t",3]]],[5,"vsubq_u64","","Subtract",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vsub_f32","","Subtract",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vsubq_f32","","Subtract",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vhsub_u8","","Signed halving subtract",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vhsubq_u8","","Signed halving subtract",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vhsub_u16","","Signed halving subtract",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vhsubq_u16","","Signed halving subtract",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vhsub_u32","","Signed halving subtract",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vhsubq_u32","","Signed halving subtract",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vhsub_s8","","Signed halving subtract",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vhsubq_s8","","Signed halving subtract",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vhsub_s16","","Signed halving subtract",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vhsubq_s16","","Signed halving subtract",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vhsub_s32","","Signed halving subtract",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vhsubq_s32","","Signed halving subtract",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vqmovn_u64","","Unsigned saturating extract narrow.",null,[[["uint64x2_t",3]],["uint32x2_t",3]]],[5,"vadd_s8","","Vector add.",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vaddq_s8","","Vector add.",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vadd_s16","","Vector add.",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vaddq_s16","","Vector add.",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vadd_s32","","Vector add.",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vaddq_s32","","Vector add.",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vaddq_s64","","Vector add.",null,[[["int64x2_t",3]],["int64x2_t",3]]],[5,"vadd_u8","","Vector add.",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vaddq_u8","","Vector add.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vadd_u16","","Vector add.",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vaddq_u16","","Vector add.",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vadd_u32","","Vector add.",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vaddq_u32","","Vector add.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vaddq_u64","","Vector add.",null,[[["uint64x2_t",3]],["uint64x2_t",3]]],[5,"vadd_f32","","Vector add.",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vaddq_f32","","Vector add.",null,[[["float32x4_t",3]],["float32x4_t",3]]],[5,"vaddl_s8","","Vector long add.",null,[[["int8x8_t",3]],["int16x8_t",3]]],[5,"vaddl_s16","","Vector long add.",null,[[["int16x4_t",3]],["int32x4_t",3]]],[5,"vaddl_s32","","Vector long add.",null,[[["int32x2_t",3]],["int64x2_t",3]]],[5,"vaddl_u8","","Vector long add.",null,[[["uint8x8_t",3]],["uint16x8_t",3]]],[5,"vaddl_u16","","Vector long add.",null,[[["uint16x4_t",3]],["uint32x4_t",3]]],[5,"vaddl_u32","","Vector long add.",null,[[["uint32x2_t",3]],["uint64x2_t",3]]],[5,"vmovn_s16","","Vector narrow integer.",null,[[["int16x8_t",3]],["int8x8_t",3]]],[5,"vmovn_s32","","Vector narrow integer.",null,[[["int32x4_t",3]],["int16x4_t",3]]],[5,"vmovn_s64","","Vector narrow integer.",null,[[["int64x2_t",3]],["int32x2_t",3]]],[5,"vmovn_u16","","Vector narrow integer.",null,[[["uint16x8_t",3]],["uint8x8_t",3]]],[5,"vmovn_u32","","Vector narrow integer.",null,[[["uint32x4_t",3]],["uint16x4_t",3]]],[5,"vmovn_u64","","Vector narrow integer.",null,[[["uint64x2_t",3]],["uint32x2_t",3]]],[5,"vmovl_s8","","Vector long move.",null,[[["int8x8_t",3]],["int16x8_t",3]]],[5,"vmovl_s16","","Vector long move.",null,[[["int16x4_t",3]],["int32x4_t",3]]],[5,"vmovl_s32","","Vector long move.",null,[[["int32x2_t",3]],["int64x2_t",3]]],[5,"vmovl_u8","","Vector long move.",null,[[["uint8x8_t",3]],["uint16x8_t",3]]],[5,"vmovl_u16","","Vector long move.",null,[[["uint16x4_t",3]],["uint32x4_t",3]]],[5,"vmovl_u32","","Vector long move.",null,[[["uint32x2_t",3]],["uint64x2_t",3]]],[5,"vrsqrte_f32","","Reciprocal square-root estimate.",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vmvn_s8","","Vector bitwise not.",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vmvnq_s8","","Vector bitwise not.",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vmvn_s16","","Vector bitwise not.",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vmvnq_s16","","Vector bitwise not.",null,[[["int16x8_t",3]],["int16x8_t",3]]],[5,"vmvn_s32","","Vector bitwise not.",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vmvnq_s32","","Vector bitwise not.",null,[[["int32x4_t",3]],["int32x4_t",3]]],[5,"vmvn_u8","","Vector bitwise not.",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vmvnq_u8","","Vector bitwise not.",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vmvn_u16","","Vector bitwise not.",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vmvnq_u16","","Vector bitwise not.",null,[[["uint16x8_t",3]],["uint16x8_t",3]]],[5,"vmvn_u32","","Vector bitwise not.",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vmvnq_u32","","Vector bitwise not.",null,[[["uint32x4_t",3]],["uint32x4_t",3]]],[5,"vmvn_p8","","Vector bitwise not.",null,[[["poly8x8_t",3]],["poly8x8_t",3]]],[5,"vmvnq_p8","","Vector bitwise not.",null,[[["poly8x16_t",3]],["poly8x16_t",3]]],[5,"vpmin_s8","","Folding minimum of adjacent pairs",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vpmin_s16","","Folding minimum of adjacent pairs",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vpmin_s32","","Folding minimum of adjacent pairs",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vpmin_u8","","Folding minimum of adjacent pairs",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vpmin_u16","","Folding minimum of adjacent pairs",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vpmin_u32","","Folding minimum of adjacent pairs",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vpmin_f32","","Folding minimum of adjacent pairs",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vpmax_s8","","Folding maximum of adjacent pairs",null,[[["int8x8_t",3]],["int8x8_t",3]]],[5,"vpmax_s16","","Folding maximum of adjacent pairs",null,[[["int16x4_t",3]],["int16x4_t",3]]],[5,"vpmax_s32","","Folding maximum of adjacent pairs",null,[[["int32x2_t",3]],["int32x2_t",3]]],[5,"vpmax_u8","","Folding maximum of adjacent pairs",null,[[["uint8x8_t",3]],["uint8x8_t",3]]],[5,"vpmax_u16","","Folding maximum of adjacent pairs",null,[[["uint16x4_t",3]],["uint16x4_t",3]]],[5,"vpmax_u32","","Folding maximum of adjacent pairs",null,[[["uint32x2_t",3]],["uint32x2_t",3]]],[5,"vpmax_f32","","Folding maximum of adjacent pairs",null,[[["float32x2_t",3]],["float32x2_t",3]]],[5,"vgetq_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x2_t",3]]]],[5,"vget_lane_u64","","Move vector element to general-purpose register",null,[[["uint64x1_t",3]]]],[5,"vgetq_lane_u16","","Move vector element to general-purpose register",null,[[["uint16x8_t",3]]]],[5,"vgetq_lane_u32","","Move vector element to general-purpose register",null,[[["uint32x4_t",3]]]],[5,"vget_lane_u8","","Move vector element to general-purpose register",null,[[["uint8x8_t",3]]]],[5,"vdupq_n_s8","","Duplicate vector element to vector or scalar",null,[[],["int8x16_t",3]]],[5,"vdupq_n_u8","","Duplicate vector element to vector or scalar",null,[[],["uint8x16_t",3]]],[5,"vmovq_n_u8","","Duplicate vector element to vector or scalar",null,[[],["uint8x16_t",3]]],[5,"vreinterpret_u64_u32","","Vector reinterpret cast operation",null,[[["uint32x2_t",3]],["uint64x1_t",3]]],[5,"vreinterpretq_s8_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["int8x16_t",3]]],[5,"vreinterpretq_u16_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint16x8_t",3]]],[5,"vreinterpretq_u32_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint32x4_t",3]]],[5,"vreinterpretq_u64_u8","","Vector reinterpret cast operation",null,[[["uint8x16_t",3]],["uint64x2_t",3]]],[5,"vreinterpretq_u8_s8","","Vector reinterpret cast operation",null,[[["int8x16_t",3]],["uint8x16_t",3]]],[5,"vshrq_n_u8","","Unsigned shift right",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vshlq_n_u8","","Shift right",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vextq_s8","","Extract vector from pair of vectors",null,[[["int8x16_t",3]],["int8x16_t",3]]],[5,"vextq_u8","","Extract vector from pair of vectors",null,[[["uint8x16_t",3]],["uint8x16_t",3]]],[5,"vld1q_s8","","Load multiple single-element structures to one, two,…",null,[[],["int8x16_t",3]]],[5,"vld1q_u8","","Load multiple single-element structures to one, two,…",null,[[],["uint8x16_t",3]]],[5,"__dmb","","Generates a DMB (data memory barrier) instruction or…",null,[[]]],[5,"__dsb","","Generates a DSB (data synchronization barrier) instruction…",null,[[]]],[5,"__isb","","Generates an ISB (instruction synchronization barrier)…",null,[[]]],[5,"__nop","","Generates an unspecified no-op instruction.",null,[[]]],[5,"__rsr","","Reads a 32-bit system register",null,[[]]],[5,"__rsrp","","Reads a system register containing an address",null,[[]]],[5,"__wsr","","Writes a 32-bit system register",null,[[]]],[5,"__wsrp","","Writes a system register containing an address",null,[[]]],[17,"_TMSTART_SUCCESS","","Transaction successfully started.",null,null],[17,"_TMFAILURE_REASON","","Extraction mask for failure reason",null,null],[17,"_TMFAILURE_RTRY","","Transaction retry is possible.",null,null],[17,"_TMFAILURE_CNCL","","Transaction executed a TCANCEL instruction",null,null],[17,"_TMFAILURE_MEM","","Transaction aborted because a conflict occurred",null,null],[17,"_TMFAILURE_IMP","","Fallback error type for any other reason",null,null],[17,"_TMFAILURE_ERR","","Transaction aborted because a non-permissible operation…",null,null],[17,"_TMFAILURE_SIZE","","Transaction aborted due to read or write set limit was…",null,null],[17,"_TMFAILURE_NEST","","Transaction aborted due to transactional nesting level was…",null,null],[17,"_TMFAILURE_DBG","","Transaction aborted due to a debug trap.",null,null],[17,"_TMFAILURE_INT","","Transaction failed from interrupt",null,null],[17,"_TMFAILURE_TRIVIAL","","Indicates a TRIVIAL version of TM is available",null,null],[0,"wasm32","core::arch","Platform-specific intrinsics for the `wasm32` platform.",null,null],[3,"v128","core::arch::wasm32","WASM-specific 128-bit wide SIMD vector type.",null,null],[5,"i32_atomic_wait","","Corresponding intrinsic to wasm\'s [`i32.atomic.wait`…",null,[[]]],[5,"i64_atomic_wait","","Corresponding intrinsic to wasm\'s [`i64.atomic.wait`…",null,[[]]],[5,"atomic_notify","","Corresponding intrinsic to wasm\'s [`atomic.notify`…",null,[[]]],[5,"v128_load","","Loads a `v128` vector from the given heap address.",null,[[],["v128",3]]],[5,"v128_store","","Stores a `v128` vector to the given heap address.",null,[[["v128",3]]]],[5,"v128_const","","Materializes a constant SIMD value from the immediate…",null,[[],["v128",3]]],[5,"i8x16_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"i8x16_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 16…",null,[[["v128",3]]]],[5,"i8x16_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 16…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"i16x8_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 8…",null,[[["v128",3]]]],[5,"i16x8_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 8…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"i32x4_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 4…",null,[[["v128",3]]]],[5,"i32x4_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 4…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"i64x2_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 2…",null,[[["v128",3]]]],[5,"i64x2_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 2…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"f32x4_extract_lane","","Extracts a lane from a 128-bit vector interpreted as 4…",null,[[["v128",3]]]],[5,"f32x4_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 4…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_splat","","Creates a vector with identical lanes.",null,[[],["v128",3]]],[5,"f64x2_extract_lane","","Extracts lane from a 128-bit vector interpreted as 2…",null,[[["v128",3]]]],[5,"f64x2_replace_lane","","Replaces a lane from a 128-bit vector interpreted as 2…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_lt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_lt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_gt_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_gt_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_le_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_le_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_ge_s","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_ge_u","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_lt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_gt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_le","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_ge","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_eq","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_ne","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_lt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_gt","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_le","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_ge","","Compares two 128-bit vectors as if they were two vectors…",null,[[["v128",3]],["v128",3]]],[5,"v128_not","","Flips each bit of the 128-bit input vector.",null,[[["v128",3]],["v128",3]]],[5,"v128_and","","Performs a bitwise and of the two input 128-bit vectors,…",null,[[["v128",3]],["v128",3]]],[5,"v128_or","","Performs a bitwise or of the two input 128-bit vectors,…",null,[[["v128",3]],["v128",3]]],[5,"v128_xor","","Performs a bitwise xor of the two input 128-bit vectors,…",null,[[["v128",3]],["v128",3]]],[5,"v128_bitselect","","Use the bitmask in `c` to select bits from `v1` when 1 and…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_neg","","Negates a 128-bit vectors intepreted as sixteen 8-bit…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128",3]]]],[5,"i8x16_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128",3]]]],[5,"i8x16_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_add","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_add_saturate_s","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_add_saturate_u","","Adds two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_sub_saturate_s","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_sub_saturate_u","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i8x16_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_neg","","Negates a 128-bit vectors intepreted as eight 16-bit…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128",3]]]],[5,"i16x8_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128",3]]]],[5,"i16x8_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_add","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_add_saturate_s","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_add_saturate_u","","Adds two 128-bit vectors as if they were two packed eight…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_sub_saturate_s","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_sub_saturate_u","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i16x8_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_neg","","Negates a 128-bit vectors intepreted as four 32-bit signed…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128",3]]]],[5,"i32x4_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128",3]]]],[5,"i32x4_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_add","","Adds two 128-bit vectors as if they were two packed four…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_mul","","Multiplies two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_neg","","Negates a 128-bit vectors intepreted as two 64-bit signed…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_any_true","","Returns 1 if any lane is nonzero or 0 if all lanes are zero.",null,[[["v128",3]]]],[5,"i64x2_all_true","","Returns 1 if all lanes are nonzero or 0 if any lane is…",null,[[["v128",3]]]],[5,"i64x2_shl","","Shifts each lane to the left by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_shr_s","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_shr_u","","Shifts each lane to the right by the specified number of…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_add","","Adds two 128-bit vectors as if they were two packed two…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_sub","","Subtracts two 128-bit vectors as if they were two packed…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_abs","","Calculates the absolute value of each lane of a 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_neg","","Negates each lane of a 128-bit vector interpreted as four…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_sqrt","","Calculates the square root of each lane of a 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_add","","Adds pairwise lanes of two 128-bit vectors interpreted as…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_sub","","Subtracts pairwise lanes of two 128-bit vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_mul","","Multiplies pairwise lanes of two 128-bit vectors…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_div","","Divides pairwise lanes of two 128-bit vectors interpreted…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_min","","Calculates the minimum of pairwise lanes of two 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_max","","Calculates the maximum of pairwise lanes of two 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_abs","","Calculates the absolute value of each lane of a 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_neg","","Negates each lane of a 128-bit vector interpreted as two…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_sqrt","","Calculates the square root of each lane of a 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_add","","Adds pairwise lanes of two 128-bit vectors interpreted as…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_sub","","Subtracts pairwise lanes of two 128-bit vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_mul","","Multiplies pairwise lanes of two 128-bit vectors…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_div","","Divides pairwise lanes of two 128-bit vectors interpreted…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_min","","Calculates the minimum of pairwise lanes of two 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_max","","Calculates the maximum of pairwise lanes of two 128-bit…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_trunc_s_f32x4_sat","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128",3]],["v128",3]]],[5,"i32x4_trunc_u_f32x4_sat","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_trunc_s_f64x2_sat","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128",3]],["v128",3]]],[5,"i64x2_trunc_u_f64x2_sat","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_convert_i32x4_s","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128",3]],["v128",3]]],[5,"f32x4_convert_i32x4_u","","Converts a 128-bit vector interpreted as four 32-bit…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_convert_s_i64x2","","Converts a 128-bit vector interpreted as two 64-bit signed…",null,[[["v128",3]],["v128",3]]],[5,"f64x2_convert_u_i64x2","","Converts a 128-bit vector interpreted as two 64-bit…",null,[[["v128",3]],["v128",3]]],[5,"memory_size","","Corresponding intrinsic to wasm\'s [`memory.size`…",null,[[]]],[5,"memory_grow","","Corresponding intrinsic to wasm\'s [`memory.grow`…",null,[[]]],[5,"unreachable","","Generates the trap instruction `UNREACHABLE`",null,[[]]],[0,"mips","core::arch","Platform-specific intrinsics for the `mips` platform.",null,null],[5,"break_","core::arch::mips","Generates the trap instruction `BREAK`",null,[[]]],[0,"mips64","core::arch","Platform-specific intrinsics for the `mips64` platform.",null,null],[5,"break_","core::arch::mips64","Generates the trap instruction `BREAK`",null,[[]]],[0,"powerpc","core::arch","Platform-specific intrinsics for the `PowerPC` platform.",null,null],[3,"vector_signed_long","core::arch::powerpc","PowerPC-specific 128-bit wide vector of two packed `i64`",null,null],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",null,null],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",null,null],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",null,null],[5,"vec_xxpermdi","","Vector permute.",null,[[]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[0,"powerpc64","core::arch","Platform-specific intrinsics for the `PowerPC64` platform.",null,null],[3,"vector_signed_long","core::arch::powerpc64","PowerPC-specific 128-bit wide vector of two packed `i64`",null,null],[3,"vector_unsigned_long","","PowerPC-specific 128-bit wide vector of two packed `u64`",null,null],[3,"vector_bool_long","","PowerPC-specific 128-bit wide vector mask of two elements",null,null],[3,"vector_double","","PowerPC-specific 128-bit wide vector of two packed `f64`",null,null],[5,"vec_xxpermdi","","Vector permute.",null,[[]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[0,"nvptx","core::arch","Platform-specific intrinsics for the `NVPTX` platform.",null,null],[5,"_syncthreads","core::arch::nvptx","Synchronizes all threads in the block.",null,[[]]],[5,"_block_dim_x","","x-th thread-block dimension.",null,[[]]],[5,"_block_dim_y","","y-th thread-block dimension.",null,[[]]],[5,"_block_dim_z","","z-th thread-block dimension.",null,[[]]],[5,"_block_idx_x","","x-th thread-block index.",null,[[]]],[5,"_block_idx_y","","y-th thread-block index.",null,[[]]],[5,"_block_idx_z","","z-th thread-block index.",null,[[]]],[5,"_grid_dim_x","","x-th block-grid dimension.",null,[[]]],[5,"_grid_dim_y","","y-th block-grid dimension.",null,[[]]],[5,"_grid_dim_z","","z-th block-grid dimension.",null,[[]]],[5,"_thread_idx_x","","x-th thread index.",null,[[]]],[5,"_thread_idx_y","","y-th thread index.",null,[[]]],[5,"_thread_idx_z","","z-th thread index.",null,[[]]],[5,"trap","","Generates the trap instruction `TRAP`",null,[[]]],[5,"__assert_fail","","Syscall to be used whenever the assert expression produces…",null,[[]]],[5,"vprintf","","Print formatted output from a kernel to a host-side output…",null,null],[5,"malloc","","Allocate memory dynamically from a fixed-size heap in…",null,null],[5,"free","","Free previously dynamically allocated memory.",null,null],[14,"panic","core","Panics the current thread.",null,null],[14,"assert_eq","","Asserts that two expressions are equal to each other…",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other…",null,null],[14,"debug_assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"matches","","Returns whether the given expression matches any of the…",null,null],[14,"try","","Unwraps a result or propagates its error.",null,null],[14,"write","","Writes formatted data into a buffer.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"unreachable","","Indicates unreachable code.",null,null],[14,"unimplemented","","Indicates unimplemented code by panicking with a message…",null,null],[14,"todo","","Indicates unfinished code.",null,null],[14,"compile_error","","Causes compilation to fail with the given error message…",null,null],[14,"format_args","","Constructs parameters for the other string-formatting…",null,null],[14,"format_args_nl","","Same as `format_args`, but adds a newline in the end.",null,null],[14,"env","","Inspects an environment variable at compile time.",null,null],[14,"option_env","","Optionally inspects an environment variable at compile time.",null,null],[14,"concat_idents","","Concatenates identifiers into one identifier.",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"line","","Expands to the line number on which it was invoked.",null,null],[14,"column","","Expands to the column number at which it was invoked.",null,null],[14,"file","","Expands to the file name in which it was invoked.",null,null],[14,"stringify","","Stringifies its arguments.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"cfg","","Evaluates boolean combinations of configuration flags at…",null,null],[14,"include","","Parses a file as an expression or an item according to the…",null,null],[14,"assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"asm","","Inline assembly.",null,null],[14,"llvm_asm","","LLVM-style inline assembly.",null,null],[14,"global_asm","","Module-level inline assembly.",null,null],[14,"log_syntax","","Prints passed tokens into the standard output.",null,null],[14,"trace_macros","","Enables or disables tracing functionality used for…",null,null],[14,"test","","Attribute macro applied to a function to turn it into a…",null,null],[14,"bench","","Attribute macro applied to a function to turn it into a…",null,null],[14,"test_case","","An implementation detail of the `#[test]` and `#[bench]`…",null,null],[14,"global_allocator","","Attribute macro applied to a static to register it as a…",null,null],[14,"cfg_accessible","","Keeps the item it\'s applied to if the passed path is…",null,null],[14,"RustcDecodable","","Unstable implementation detail of the `rustc` compiler, do…",null,null],[14,"RustcEncodable","","Unstable implementation detail of the `rustc` compiler, do…",null,null],[14,"Clone","","Derive macro generating an impl of the trait `Clone`.",null,null],[14,"PartialEq","","Derive macro generating an impl of the trait `PartialEq`.",null,null],[14,"Eq","","Derive macro generating an impl of the trait `Eq`.",null,null],[14,"Ord","","Derive macro generating an impl of the trait `Ord`.",null,null],[14,"PartialOrd","","Derive macro generating an impl of the trait `PartialOrd`.",null,null],[14,"Default","","Derive macro generating an impl of the trait `Default`.",null,null],[14,"Copy","","Derive macro generating an impl of the trait `Copy`.",null,null],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[14,"Hash","","Derive macro generating an impl of the trait `Hash`.",null,null],[11,"borrow","core::num","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"into","","",3,[[]]],[11,"from","","",3,[[]]],[11,"try_into","","",3,[[],["result",4]]],[11,"try_from","","",3,[[],["result",4]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"into","","",4,[[]]],[11,"from","","",4,[[]]],[11,"try_into","","",4,[[],["result",4]]],[11,"try_from","","",4,[[],["result",4]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"into","","",5,[[]]],[11,"from","","",5,[[]]],[11,"try_into","","",5,[[],["result",4]]],[11,"try_from","","",5,[[],["result",4]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"into","","",6,[[]]],[11,"from","","",6,[[]]],[11,"try_into","","",6,[[],["result",4]]],[11,"try_from","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"into","","",7,[[]]],[11,"from","","",7,[[]]],[11,"try_into","","",7,[[],["result",4]]],[11,"try_from","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"into","","",8,[[]]],[11,"from","","",8,[[]]],[11,"try_into","","",8,[[],["result",4]]],[11,"try_from","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"into","","",9,[[]]],[11,"from","","",9,[[]]],[11,"try_into","","",9,[[],["result",4]]],[11,"try_from","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"into","","",10,[[]]],[11,"from","","",10,[[]]],[11,"try_into","","",10,[[],["result",4]]],[11,"try_from","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"into","","",11,[[]]],[11,"from","","",11,[[]]],[11,"try_into","","",11,[[],["result",4]]],[11,"try_from","","",11,[[],["result",4]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"into","","",12,[[]]],[11,"from","","",12,[[]]],[11,"try_into","","",12,[[],["result",4]]],[11,"try_from","","",12,[[],["result",4]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"into","","",13,[[]]],[11,"from","","",13,[[]]],[11,"try_into","","",13,[[],["result",4]]],[11,"try_from","","",13,[[],["result",4]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"into","","",14,[[]]],[11,"from","","",14,[[]]],[11,"try_into","","",14,[[],["result",4]]],[11,"try_from","","",14,[[],["result",4]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"into","","",0,[[]]],[11,"from","","",0,[[]]],[11,"try_into","","",0,[[],["result",4]]],[11,"try_from","","",0,[[],["result",4]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"borrow","","",186,[[]]],[11,"borrow_mut","","",186,[[]]],[11,"into","","",186,[[]]],[11,"from","","",186,[[]]],[11,"from","","",186,[[]]],[11,"try_into","","",186,[[],["result",4]]],[11,"try_from","","",186,[[],["result",4]]],[11,"type_id","","",186,[[],["typeid",3]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"into","","",15,[[]]],[11,"from","","",15,[[]]],[11,"try_into","","",15,[[],["result",4]]],[11,"try_from","","",15,[[],["result",4]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"borrow","","",187,[[]]],[11,"borrow_mut","","",187,[[]]],[11,"into","","",187,[[]]],[11,"from","","",187,[[]]],[11,"try_into","","",187,[[],["result",4]]],[11,"try_from","","",187,[[],["result",4]]],[11,"type_id","","",187,[[],["typeid",3]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"into","","",1,[[]]],[11,"from","","",1,[[]]],[11,"try_into","","",1,[[],["result",4]]],[11,"try_from","","",1,[[],["result",4]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"into","","",2,[[]]],[11,"from","","",2,[[]]],[11,"try_into","","",2,[[],["result",4]]],[11,"try_from","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"borrow","core::mem","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"into","","",16,[[]]],[11,"from","","",16,[[]]],[11,"try_into","","",16,[[],["result",4]]],[11,"try_from","","",16,[[],["result",4]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"borrow","","",188,[[]]],[11,"borrow_mut","","",188,[[]]],[11,"into","","",188,[[]]],[11,"from","","",188,[[]]],[11,"try_into","","",188,[[],["result",4]]],[11,"try_from","","",188,[[],["result",4]]],[11,"type_id","","",188,[[],["typeid",3]]],[11,"borrow","","",17,[[]]],[11,"borrow_mut","","",17,[[]]],[11,"into","","",17,[[]]],[11,"from","","",17,[[]]],[11,"try_into","","",17,[[],["result",4]]],[11,"try_from","","",17,[[],["result",4]]],[11,"type_id","","",17,[[],["typeid",3]]],[11,"borrow","core::ptr","",18,[[]]],[11,"borrow_mut","","",18,[[]]],[11,"into","","",18,[[]]],[11,"from","","",18,[[]]],[11,"try_into","","",18,[[],["result",4]]],[11,"try_from","","",18,[[],["result",4]]],[11,"type_id","","",18,[[],["typeid",3]]],[11,"borrow","core::cmp","",22,[[]]],[11,"borrow_mut","","",22,[[]]],[11,"into","","",22,[[]]],[11,"from","","",22,[[]]],[11,"try_into","","",22,[[],["result",4]]],[11,"try_from","","",22,[[],["result",4]]],[11,"type_id","","",22,[[],["typeid",3]]],[11,"borrow","","",23,[[]]],[11,"borrow_mut","","",23,[[]]],[11,"into","","",23,[[]]],[11,"from","","",23,[[]]],[11,"try_into","","",23,[[],["result",4]]],[11,"try_from","","",23,[[],["result",4]]],[11,"type_id","","",23,[[],["typeid",3]]],[11,"borrow","core::convert","",189,[[]]],[11,"borrow_mut","","",189,[[]]],[11,"into","","",189,[[]]],[11,"from","","",189,[[]]],[11,"from","","",189,[[]]],[11,"try_into","","",189,[[],["result",4]]],[11,"try_from","","",189,[[],["result",4]]],[11,"type_id","","",189,[[],["typeid",3]]],[11,"borrow","core::marker","",190,[[]]],[11,"borrow_mut","","",190,[[]]],[11,"into","","",190,[[]]],[11,"from","","",190,[[]]],[11,"try_into","","",190,[[],["result",4]]],[11,"try_from","","",190,[[],["result",4]]],[11,"type_id","","",190,[[],["typeid",3]]],[11,"borrow","","",191,[[]]],[11,"borrow_mut","","",191,[[]]],[11,"into","","",191,[[]]],[11,"from","","",191,[[]]],[11,"try_into","","",191,[[],["result",4]]],[11,"try_from","","",191,[[],["result",4]]],[11,"type_id","","",191,[[],["typeid",3]]],[11,"borrow","core::ops","",35,[[]]],[11,"borrow_mut","","",35,[[]]],[11,"into","","",35,[[]]],[11,"from","","",35,[[]]],[11,"try_into","","",35,[[],["result",4]]],[11,"try_from","","",35,[[],["result",4]]],[11,"type_id","","",35,[[],["typeid",3]]],[11,"borrow","","",36,[[]]],[11,"borrow_mut","","",36,[[]]],[11,"into","","",36,[[]]],[11,"from","","",36,[[]]],[11,"try_into","","",36,[[],["result",4]]],[11,"try_from","","",36,[[],["result",4]]],[11,"type_id","","",36,[[],["typeid",3]]],[11,"borrow","","",192,[[]]],[11,"borrow_mut","","",192,[[]]],[11,"into","","",192,[[]]],[11,"from","","",192,[[]]],[11,"try_into","","",192,[[],["result",4]]],[11,"try_from","","",192,[[],["result",4]]],[11,"type_id","","",192,[[],["typeid",3]]],[11,"borrow","","",37,[[]]],[11,"borrow_mut","","",37,[[]]],[11,"into","","",37,[[]]],[11,"from","","",37,[[]]],[11,"try_into","","",37,[[],["result",4]]],[11,"try_from","","",37,[[],["result",4]]],[11,"type_id","","",37,[[],["typeid",3]]],[11,"borrow","","",41,[[]]],[11,"borrow_mut","","",41,[[]]],[11,"into","","",41,[[]]],[11,"from","","",41,[[]]],[11,"try_into","","",41,[[],["result",4]]],[11,"try_from","","",41,[[],["result",4]]],[11,"type_id","","",41,[[],["typeid",3]]],[11,"borrow","","",38,[[]]],[11,"borrow_mut","","",38,[[]]],[11,"into","","",38,[[]]],[11,"from","","",38,[[]]],[11,"try_into","","",38,[[],["result",4]]],[11,"try_from","","",38,[[],["result",4]]],[11,"type_id","","",38,[[],["typeid",3]]],[11,"borrow","","",39,[[]]],[11,"borrow_mut","","",39,[[]]],[11,"into","","",39,[[]]],[11,"from","","",39,[[]]],[11,"try_into","","",39,[[],["result",4]]],[11,"try_from","","",39,[[],["result",4]]],[11,"type_id","","",39,[[],["typeid",3]]],[11,"borrow","","",40,[[]]],[11,"borrow_mut","","",40,[[]]],[11,"into","","",40,[[]]],[11,"from","","",40,[[]]],[11,"try_into","","",40,[[],["result",4]]],[11,"try_from","","",40,[[],["result",4]]],[11,"type_id","","",40,[[],["typeid",3]]],[11,"borrow","core::any","",76,[[]]],[11,"borrow_mut","","",76,[[]]],[11,"into","","",76,[[]]],[11,"from","","",76,[[]]],[11,"try_into","","",76,[[],["result",4]]],[11,"try_from","","",76,[[],["result",4]]],[11,"type_id","","",76,[[],["typeid",3]]],[11,"borrow","core::array","",77,[[]]],[11,"borrow_mut","","",77,[[]]],[11,"into","","",77,[[]]],[11,"from","","",77,[[]]],[11,"try_into","","",77,[[],["result",4]]],[11,"try_from","","",77,[[],["result",4]]],[11,"type_id","","",77,[[],["typeid",3]]],[11,"borrow","","",193,[[]]],[11,"borrow_mut","","",193,[[]]],[11,"into","","",193,[[]]],[11,"from","","",193,[[]]],[11,"try_into","","",193,[[],["result",4]]],[11,"try_from","","",193,[[],["result",4]]],[11,"type_id","","",193,[[],["typeid",3]]],[11,"borrow","core::ascii","",194,[[]]],[11,"borrow_mut","","",194,[[]]],[11,"into","","",194,[[]]],[11,"from","","",194,[[]]],[11,"try_into","","",194,[[],["result",4]]],[11,"try_from","","",194,[[],["result",4]]],[11,"type_id","","",194,[[],["typeid",3]]],[11,"borrow","core::cell","",79,[[]]],[11,"borrow_mut","","",79,[[]]],[11,"into","","",79,[[]]],[11,"from","","",79,[[]]],[11,"from","","",79,[[]]],[11,"try_into","","",79,[[],["result",4]]],[11,"try_from","","",79,[[],["result",4]]],[11,"type_id","","",79,[[],["typeid",3]]],[11,"borrow","","",80,[[]]],[11,"borrow_mut","","",80,[[]]],[11,"into","","",80,[[]]],[11,"from","","",80,[[]]],[11,"from","","",80,[[]]],[11,"try_into","","",80,[[],["result",4]]],[11,"try_from","","",80,[[],["result",4]]],[11,"type_id","","",80,[[],["typeid",3]]],[11,"borrow","","",195,[[]]],[11,"borrow_mut","","",195,[[]]],[11,"into","","",195,[[]]],[11,"from","","",195,[[]]],[11,"try_into","","",195,[[],["result",4]]],[11,"try_from","","",195,[[],["result",4]]],[11,"type_id","","",195,[[],["typeid",3]]],[11,"borrow","","",196,[[]]],[11,"borrow_mut","","",196,[[]]],[11,"into","","",196,[[]]],[11,"from","","",196,[[]]],[11,"try_into","","",196,[[],["result",4]]],[11,"try_from","","",196,[[],["result",4]]],[11,"type_id","","",196,[[],["typeid",3]]],[11,"borrow","","",81,[[]]],[11,"borrow_mut","","",81,[[]]],[11,"into","","",81,[[]]],[11,"from","","",81,[[]]],[11,"try_into","","",81,[[],["result",4]]],[11,"try_from","","",81,[[],["result",4]]],[11,"type_id","","",81,[[],["typeid",3]]],[11,"borrow","","",82,[[]]],[11,"borrow_mut","","",82,[[]]],[11,"into","","",82,[[]]],[11,"from","","",82,[[]]],[11,"try_into","","",82,[[],["result",4]]],[11,"try_from","","",82,[[],["result",4]]],[11,"type_id","","",82,[[],["typeid",3]]],[11,"borrow","","",83,[[]]],[11,"borrow_mut","","",83,[[]]],[11,"into","","",83,[[]]],[11,"from","","",83,[[]]],[11,"from","","",83,[[]]],[11,"try_into","","",83,[[],["result",4]]],[11,"try_from","","",83,[[],["result",4]]],[11,"type_id","","",83,[[],["typeid",3]]],[11,"borrow","core::char","",197,[[]]],[11,"borrow_mut","","",197,[[]]],[11,"into","","",197,[[]]],[11,"from","","",197,[[]]],[11,"try_into","","",197,[[],["result",4]]],[11,"try_from","","",197,[[],["result",4]]],[11,"type_id","","",197,[[],["typeid",3]]],[11,"borrow","","",198,[[]]],[11,"borrow_mut","","",198,[[]]],[11,"into","","",198,[[]]],[11,"from","","",198,[[]]],[11,"try_into","","",198,[[],["result",4]]],[11,"try_from","","",198,[[],["result",4]]],[11,"type_id","","",198,[[],["typeid",3]]],[11,"borrow","","",199,[[]]],[11,"borrow_mut","","",199,[[]]],[11,"into","","",199,[[]]],[11,"from","","",199,[[]]],[11,"try_into","","",199,[[],["result",4]]],[11,"try_from","","",199,[[],["result",4]]],[11,"type_id","","",199,[[],["typeid",3]]],[11,"borrow","","",84,[[]]],[11,"borrow_mut","","",84,[[]]],[11,"into","","",84,[[]]],[11,"from","","",84,[[]]],[11,"try_into","","",84,[[],["result",4]]],[11,"try_from","","",84,[[],["result",4]]],[11,"type_id","","",84,[[],["typeid",3]]],[11,"borrow","","",200,[[]]],[11,"borrow_mut","","",200,[[]]],[11,"into","","",200,[[]]],[11,"from","","",200,[[]]],[11,"try_into","","",200,[[],["result",4]]],[11,"try_from","","",200,[[],["result",4]]],[11,"type_id","","",200,[[],["typeid",3]]],[11,"borrow","","",201,[[]]],[11,"borrow_mut","","",201,[[]]],[11,"into","","",201,[[]]],[11,"from","","",201,[[]]],[11,"try_into","","",201,[[],["result",4]]],[11,"try_from","","",201,[[],["result",4]]],[11,"type_id","","",201,[[],["typeid",3]]],[11,"borrow","","",202,[[]]],[11,"borrow_mut","","",202,[[]]],[11,"into","","",202,[[]]],[11,"from","","",202,[[]]],[11,"try_into","","",202,[[],["result",4]]],[11,"try_from","","",202,[[],["result",4]]],[11,"type_id","","",202,[[],["typeid",3]]],[11,"borrow","","",203,[[]]],[11,"borrow_mut","","",203,[[]]],[11,"into","","",203,[[]]],[11,"from","","",203,[[]]],[11,"try_into","","",203,[[],["result",4]]],[11,"try_from","","",203,[[],["result",4]]],[11,"type_id","","",203,[[],["typeid",3]]],[11,"borrow","","",204,[[]]],[11,"borrow_mut","","",204,[[]]],[11,"into","","",204,[[]]],[11,"from","","",204,[[]]],[11,"try_into","","",204,[[],["result",4]]],[11,"try_from","","",204,[[],["result",4]]],[11,"type_id","","",204,[[],["typeid",3]]],[11,"borrow","core::ffi","",85,[[]]],[11,"borrow_mut","","",85,[[]]],[11,"into","","",85,[[]]],[11,"from","","",85,[[]]],[11,"try_into","","",85,[[],["result",4]]],[11,"try_from","","",85,[[],["result",4]]],[11,"type_id","","",85,[[],["typeid",3]]],[11,"borrow","","",205,[[]]],[11,"borrow_mut","","",205,[[]]],[11,"into","","",205,[[]]],[11,"from","","",205,[[]]],[11,"try_into","","",205,[[],["result",4]]],[11,"try_from","","",205,[[],["result",4]]],[11,"type_id","","",205,[[],["typeid",3]]],[11,"borrow","","",206,[[]]],[11,"borrow_mut","","",206,[[]]],[11,"into","","",206,[[]]],[11,"from","","",206,[[]]],[11,"try_into","","",206,[[],["result",4]]],[11,"try_from","","",206,[[],["result",4]]],[11,"type_id","","",206,[[],["typeid",3]]],[11,"borrow","core::iter","",207,[[]]],[11,"borrow_mut","","",207,[[]]],[11,"into","","",207,[[]]],[11,"from","","",207,[[]]],[11,"try_into","","",207,[[],["result",4]]],[11,"try_from","","",207,[[],["result",4]]],[11,"type_id","","",207,[[],["typeid",3]]],[11,"borrow","","",208,[[]]],[11,"borrow_mut","","",208,[[]]],[11,"into","","",208,[[]]],[11,"from","","",208,[[]]],[11,"try_into","","",208,[[],["result",4]]],[11,"try_from","","",208,[[],["result",4]]],[11,"type_id","","",208,[[],["typeid",3]]],[11,"borrow","","",209,[[]]],[11,"borrow_mut","","",209,[[]]],[11,"into","","",209,[[]]],[11,"from","","",209,[[]]],[11,"try_into","","",209,[[],["result",4]]],[11,"try_from","","",209,[[],["result",4]]],[11,"type_id","","",209,[[],["typeid",3]]],[11,"borrow","","",210,[[]]],[11,"borrow_mut","","",210,[[]]],[11,"into","","",210,[[]]],[11,"from","","",210,[[]]],[11,"try_into","","",210,[[],["result",4]]],[11,"try_from","","",210,[[],["result",4]]],[11,"type_id","","",210,[[],["typeid",3]]],[11,"borrow","","",211,[[]]],[11,"borrow_mut","","",211,[[]]],[11,"into","","",211,[[]]],[11,"from","","",211,[[]]],[11,"try_into","","",211,[[],["result",4]]],[11,"try_from","","",211,[[],["result",4]]],[11,"type_id","","",211,[[],["typeid",3]]],[11,"borrow","","",212,[[]]],[11,"borrow_mut","","",212,[[]]],[11,"into","","",212,[[]]],[11,"from","","",212,[[]]],[11,"try_into","","",212,[[],["result",4]]],[11,"try_from","","",212,[[],["result",4]]],[11,"type_id","","",212,[[],["typeid",3]]],[11,"borrow","","",213,[[]]],[11,"borrow_mut","","",213,[[]]],[11,"into","","",213,[[]]],[11,"from","","",213,[[]]],[11,"try_into","","",213,[[],["result",4]]],[11,"try_from","","",213,[[],["result",4]]],[11,"type_id","","",213,[[],["typeid",3]]],[11,"borrow","","",214,[[]]],[11,"borrow_mut","","",214,[[]]],[11,"into","","",214,[[]]],[11,"from","","",214,[[]]],[11,"try_into","","",214,[[],["result",4]]],[11,"try_from","","",214,[[],["result",4]]],[11,"type_id","","",214,[[],["typeid",3]]],[11,"borrow","","",215,[[]]],[11,"borrow_mut","","",215,[[]]],[11,"into","","",215,[[]]],[11,"from","","",215,[[]]],[11,"try_into","","",215,[[],["result",4]]],[11,"try_from","","",215,[[],["result",4]]],[11,"type_id","","",215,[[],["typeid",3]]],[11,"borrow","","",216,[[]]],[11,"borrow_mut","","",216,[[]]],[11,"into","","",216,[[]]],[11,"from","","",216,[[]]],[11,"try_into","","",216,[[],["result",4]]],[11,"try_from","","",216,[[],["result",4]]],[11,"type_id","","",216,[[],["typeid",3]]],[11,"borrow","","",217,[[]]],[11,"borrow_mut","","",217,[[]]],[11,"into","","",217,[[]]],[11,"from","","",217,[[]]],[11,"try_into","","",217,[[],["result",4]]],[11,"try_from","","",217,[[],["result",4]]],[11,"type_id","","",217,[[],["typeid",3]]],[11,"borrow","","",218,[[]]],[11,"borrow_mut","","",218,[[]]],[11,"into","","",218,[[]]],[11,"from","","",218,[[]]],[11,"try_into","","",218,[[],["result",4]]],[11,"try_from","","",218,[[],["result",4]]],[11,"type_id","","",218,[[],["typeid",3]]],[11,"borrow","","",219,[[]]],[11,"borrow_mut","","",219,[[]]],[11,"into","","",219,[[]]],[11,"from","","",219,[[]]],[11,"try_into","","",219,[[],["result",4]]],[11,"try_from","","",219,[[],["result",4]]],[11,"type_id","","",219,[[],["typeid",3]]],[11,"borrow","","",220,[[]]],[11,"borrow_mut","","",220,[[]]],[11,"into","","",220,[[]]],[11,"from","","",220,[[]]],[11,"try_into","","",220,[[],["result",4]]],[11,"try_from","","",220,[[],["result",4]]],[11,"type_id","","",220,[[],["typeid",3]]],[11,"borrow","","",221,[[]]],[11,"borrow_mut","","",221,[[]]],[11,"into","","",221,[[]]],[11,"from","","",221,[[]]],[11,"try_into","","",221,[[],["result",4]]],[11,"try_from","","",221,[[],["result",4]]],[11,"type_id","","",221,[[],["typeid",3]]],[11,"borrow","","",222,[[]]],[11,"borrow_mut","","",222,[[]]],[11,"into","","",222,[[]]],[11,"from","","",222,[[]]],[11,"try_into","","",222,[[],["result",4]]],[11,"try_from","","",222,[[],["result",4]]],[11,"type_id","","",222,[[],["typeid",3]]],[11,"borrow","","",223,[[]]],[11,"borrow_mut","","",223,[[]]],[11,"into","","",223,[[]]],[11,"from","","",223,[[]]],[11,"try_into","","",223,[[],["result",4]]],[11,"try_from","","",223,[[],["result",4]]],[11,"type_id","","",223,[[],["typeid",3]]],[11,"borrow","","",224,[[]]],[11,"borrow_mut","","",224,[[]]],[11,"into","","",224,[[]]],[11,"from","","",224,[[]]],[11,"try_into","","",224,[[],["result",4]]],[11,"try_from","","",224,[[],["result",4]]],[11,"type_id","","",224,[[],["typeid",3]]],[11,"borrow","","",225,[[]]],[11,"borrow_mut","","",225,[[]]],[11,"into","","",225,[[]]],[11,"from","","",225,[[]]],[11,"try_into","","",225,[[],["result",4]]],[11,"try_from","","",225,[[],["result",4]]],[11,"type_id","","",225,[[],["typeid",3]]],[11,"borrow","","",226,[[]]],[11,"borrow_mut","","",226,[[]]],[11,"into","","",226,[[]]],[11,"from","","",226,[[]]],[11,"try_into","","",226,[[],["result",4]]],[11,"try_from","","",226,[[],["result",4]]],[11,"type_id","","",226,[[],["typeid",3]]],[11,"borrow","","",227,[[]]],[11,"borrow_mut","","",227,[[]]],[11,"into","","",227,[[]]],[11,"from","","",227,[[]]],[11,"try_into","","",227,[[],["result",4]]],[11,"try_from","","",227,[[],["result",4]]],[11,"type_id","","",227,[[],["typeid",3]]],[11,"borrow","","",86,[[]]],[11,"borrow_mut","","",86,[[]]],[11,"into","","",86,[[]]],[11,"from","","",86,[[]]],[11,"try_into","","",86,[[],["result",4]]],[11,"try_from","","",86,[[],["result",4]]],[11,"type_id","","",86,[[],["typeid",3]]],[11,"borrow","","",228,[[]]],[11,"borrow_mut","","",228,[[]]],[11,"into","","",228,[[]]],[11,"from","","",228,[[]]],[11,"try_into","","",228,[[],["result",4]]],[11,"try_from","","",228,[[],["result",4]]],[11,"type_id","","",228,[[],["typeid",3]]],[11,"borrow","","",229,[[]]],[11,"borrow_mut","","",229,[[]]],[11,"into","","",229,[[]]],[11,"from","","",229,[[]]],[11,"try_into","","",229,[[],["result",4]]],[11,"try_from","","",229,[[],["result",4]]],[11,"type_id","","",229,[[],["typeid",3]]],[11,"borrow","","",230,[[]]],[11,"borrow_mut","","",230,[[]]],[11,"into","","",230,[[]]],[11,"from","","",230,[[]]],[11,"try_into","","",230,[[],["result",4]]],[11,"try_from","","",230,[[],["result",4]]],[11,"type_id","","",230,[[],["typeid",3]]],[11,"borrow","","",231,[[]]],[11,"borrow_mut","","",231,[[]]],[11,"into","","",231,[[]]],[11,"from","","",231,[[]]],[11,"try_into","","",231,[[],["result",4]]],[11,"try_from","","",231,[[],["result",4]]],[11,"type_id","","",231,[[],["typeid",3]]],[11,"borrow","","",232,[[]]],[11,"borrow_mut","","",232,[[]]],[11,"into","","",232,[[]]],[11,"from","","",232,[[]]],[11,"try_into","","",232,[[],["result",4]]],[11,"try_from","","",232,[[],["result",4]]],[11,"type_id","","",232,[[],["typeid",3]]],[11,"borrow","","",233,[[]]],[11,"borrow_mut","","",233,[[]]],[11,"into","","",233,[[]]],[11,"from","","",233,[[]]],[11,"try_into","","",233,[[],["result",4]]],[11,"try_from","","",233,[[],["result",4]]],[11,"type_id","","",233,[[],["typeid",3]]],[11,"borrow","","",234,[[]]],[11,"borrow_mut","","",234,[[]]],[11,"into","","",234,[[]]],[11,"from","","",234,[[]]],[11,"try_into","","",234,[[],["result",4]]],[11,"try_from","","",234,[[],["result",4]]],[11,"type_id","","",234,[[],["typeid",3]]],[11,"borrow","core::option","",235,[[]]],[11,"borrow_mut","","",235,[[]]],[11,"into","","",235,[[]]],[11,"from","","",235,[[]]],[11,"try_into","","",235,[[],["result",4]]],[11,"try_from","","",235,[[],["result",4]]],[11,"type_id","","",235,[[],["typeid",3]]],[11,"borrow","","",236,[[]]],[11,"borrow_mut","","",236,[[]]],[11,"into","","",236,[[]]],[11,"from","","",236,[[]]],[11,"try_into","","",236,[[],["result",4]]],[11,"try_from","","",236,[[],["result",4]]],[11,"type_id","","",236,[[],["typeid",3]]],[11,"borrow","","",237,[[]]],[11,"borrow_mut","","",237,[[]]],[11,"into","","",237,[[]]],[11,"from","","",237,[[]]],[11,"try_into","","",237,[[],["result",4]]],[11,"try_from","","",237,[[],["result",4]]],[11,"type_id","","",237,[[],["typeid",3]]],[11,"borrow","","",238,[[]]],[11,"borrow_mut","","",238,[[]]],[11,"into","","",238,[[]]],[11,"from","","",238,[[]]],[11,"try_into","","",238,[[],["result",4]]],[11,"try_from","","",238,[[],["result",4]]],[11,"type_id","","",238,[[],["typeid",3]]],[11,"borrow","","",96,[[]]],[11,"borrow_mut","","",96,[[]]],[11,"into","","",96,[[]]],[11,"from","","",96,[[]]],[11,"from","","",96,[[]]],[11,"try_into","","",96,[[],["result",4]]],[11,"try_from","","",96,[[],["result",4]]],[11,"type_id","","",96,[[],["typeid",3]]],[11,"borrow","core::panic","",97,[[]]],[11,"borrow_mut","","",97,[[]]],[11,"into","","",97,[[]]],[11,"from","","",97,[[]]],[11,"try_into","","",97,[[],["result",4]]],[11,"try_from","","",97,[[],["result",4]]],[11,"type_id","","",97,[[],["typeid",3]]],[11,"borrow","","",98,[[]]],[11,"borrow_mut","","",98,[[]]],[11,"into","","",98,[[]]],[11,"from","","",98,[[]]],[11,"try_into","","",98,[[],["result",4]]],[11,"try_from","","",98,[[],["result",4]]],[11,"type_id","","",98,[[],["typeid",3]]],[11,"borrow","core::pin","",99,[[]]],[11,"borrow_mut","","",99,[[]]],[11,"into","","",99,[[]]],[11,"from","","",99,[[]]],[11,"try_into","","",99,[[],["result",4]]],[11,"try_from","","",99,[[],["result",4]]],[11,"type_id","","",99,[[],["typeid",3]]],[11,"borrow","core::raw","",100,[[]]],[11,"borrow_mut","","",100,[[]]],[11,"into","","",100,[[]]],[11,"from","","",100,[[]]],[11,"try_into","","",100,[[],["result",4]]],[11,"try_from","","",100,[[],["result",4]]],[11,"type_id","","",100,[[],["typeid",3]]],[11,"borrow","core::result","",239,[[]]],[11,"borrow_mut","","",239,[[]]],[11,"into","","",239,[[]]],[11,"from","","",239,[[]]],[11,"try_into","","",239,[[],["result",4]]],[11,"try_from","","",239,[[],["result",4]]],[11,"type_id","","",239,[[],["typeid",3]]],[11,"borrow","","",240,[[]]],[11,"borrow_mut","","",240,[[]]],[11,"into","","",240,[[]]],[11,"from","","",240,[[]]],[11,"try_into","","",240,[[],["result",4]]],[11,"try_from","","",240,[[],["result",4]]],[11,"type_id","","",240,[[],["typeid",3]]],[11,"borrow","","",241,[[]]],[11,"borrow_mut","","",241,[[]]],[11,"into","","",241,[[]]],[11,"from","","",241,[[]]],[11,"try_into","","",241,[[],["result",4]]],[11,"try_from","","",241,[[],["result",4]]],[11,"type_id","","",241,[[],["typeid",3]]],[11,"borrow","","",101,[[]]],[11,"borrow_mut","","",101,[[]]],[11,"into","","",101,[[]]],[11,"from","","",101,[[]]],[11,"try_into","","",101,[[],["result",4]]],[11,"try_from","","",101,[[],["result",4]]],[11,"type_id","","",101,[[],["typeid",3]]],[11,"borrow","core::sync::atomic","",103,[[]]],[11,"borrow_mut","","",103,[[]]],[11,"into","","",103,[[]]],[11,"from","","",103,[[]]],[11,"try_into","","",103,[[],["result",4]]],[11,"try_from","","",103,[[],["result",4]]],[11,"type_id","","",103,[[],["typeid",3]]],[11,"borrow","","",104,[[]]],[11,"borrow_mut","","",104,[[]]],[11,"into","","",104,[[]]],[11,"from","","",104,[[]]],[11,"try_into","","",104,[[],["result",4]]],[11,"try_from","","",104,[[],["result",4]]],[11,"type_id","","",104,[[],["typeid",3]]],[11,"borrow","","",105,[[]]],[11,"borrow_mut","","",105,[[]]],[11,"into","","",105,[[]]],[11,"from","","",105,[[]]],[11,"try_into","","",105,[[],["result",4]]],[11,"try_from","","",105,[[],["result",4]]],[11,"type_id","","",105,[[],["typeid",3]]],[11,"borrow","","",106,[[]]],[11,"borrow_mut","","",106,[[]]],[11,"into","","",106,[[]]],[11,"from","","",106,[[]]],[11,"try_into","","",106,[[],["result",4]]],[11,"try_from","","",106,[[],["result",4]]],[11,"type_id","","",106,[[],["typeid",3]]],[11,"borrow","","",107,[[]]],[11,"borrow_mut","","",107,[[]]],[11,"into","","",107,[[]]],[11,"from","","",107,[[]]],[11,"try_into","","",107,[[],["result",4]]],[11,"try_from","","",107,[[],["result",4]]],[11,"type_id","","",107,[[],["typeid",3]]],[11,"borrow","","",108,[[]]],[11,"borrow_mut","","",108,[[]]],[11,"into","","",108,[[]]],[11,"from","","",108,[[]]],[11,"try_into","","",108,[[],["result",4]]],[11,"try_from","","",108,[[],["result",4]]],[11,"type_id","","",108,[[],["typeid",3]]],[11,"borrow","","",109,[[]]],[11,"borrow_mut","","",109,[[]]],[11,"into","","",109,[[]]],[11,"from","","",109,[[]]],[11,"try_into","","",109,[[],["result",4]]],[11,"try_from","","",109,[[],["result",4]]],[11,"type_id","","",109,[[],["typeid",3]]],[11,"borrow","","",110,[[]]],[11,"borrow_mut","","",110,[[]]],[11,"into","","",110,[[]]],[11,"from","","",110,[[]]],[11,"try_into","","",110,[[],["result",4]]],[11,"try_from","","",110,[[],["result",4]]],[11,"type_id","","",110,[[],["typeid",3]]],[11,"borrow","","",111,[[]]],[11,"borrow_mut","","",111,[[]]],[11,"into","","",111,[[]]],[11,"from","","",111,[[]]],[11,"try_into","","",111,[[],["result",4]]],[11,"try_from","","",111,[[],["result",4]]],[11,"type_id","","",111,[[],["typeid",3]]],[11,"borrow","","",112,[[]]],[11,"borrow_mut","","",112,[[]]],[11,"into","","",112,[[]]],[11,"from","","",112,[[]]],[11,"try_into","","",112,[[],["result",4]]],[11,"try_from","","",112,[[],["result",4]]],[11,"type_id","","",112,[[],["typeid",3]]],[11,"borrow","","",113,[[]]],[11,"borrow_mut","","",113,[[]]],[11,"into","","",113,[[]]],[11,"from","","",113,[[]]],[11,"try_into","","",113,[[],["result",4]]],[11,"try_from","","",113,[[],["result",4]]],[11,"type_id","","",113,[[],["typeid",3]]],[11,"borrow","","",114,[[]]],[11,"borrow_mut","","",114,[[]]],[11,"into","","",114,[[]]],[11,"from","","",114,[[]]],[11,"try_into","","",114,[[],["result",4]]],[11,"try_from","","",114,[[],["result",4]]],[11,"type_id","","",114,[[],["typeid",3]]],[11,"borrow","","",102,[[]]],[11,"borrow_mut","","",102,[[]]],[11,"into","","",102,[[]]],[11,"from","","",102,[[]]],[11,"try_into","","",102,[[],["result",4]]],[11,"try_from","","",102,[[],["result",4]]],[11,"type_id","","",102,[[],["typeid",3]]],[11,"borrow","core::fmt","",119,[[]]],[11,"borrow_mut","","",119,[[]]],[11,"into","","",119,[[]]],[11,"from","","",119,[[]]],[11,"try_into","","",119,[[],["result",4]]],[11,"try_from","","",119,[[],["result",4]]],[11,"type_id","","",119,[[],["typeid",3]]],[11,"borrow","","",120,[[]]],[11,"borrow_mut","","",120,[[]]],[11,"into","","",120,[[]]],[11,"from","","",120,[[]]],[11,"try_into","","",120,[[],["result",4]]],[11,"try_from","","",120,[[],["result",4]]],[11,"type_id","","",120,[[],["typeid",3]]],[11,"borrow","","",118,[[]]],[11,"borrow_mut","","",118,[[]]],[11,"into","","",118,[[]]],[11,"from","","",118,[[]]],[11,"try_into","","",118,[[],["result",4]]],[11,"try_from","","",118,[[],["result",4]]],[11,"type_id","","",118,[[],["typeid",3]]],[11,"borrow","","",116,[[]]],[11,"borrow_mut","","",116,[[]]],[11,"into","","",116,[[]]],[11,"from","","",116,[[]]],[11,"try_into","","",116,[[],["result",4]]],[11,"try_from","","",116,[[],["result",4]]],[11,"type_id","","",116,[[],["typeid",3]]],[11,"borrow","","",117,[[]]],[11,"borrow_mut","","",117,[[]]],[11,"into","","",117,[[]]],[11,"from","","",117,[[]]],[11,"try_into","","",117,[[],["result",4]]],[11,"try_from","","",117,[[],["result",4]]],[11,"type_id","","",117,[[],["typeid",3]]],[11,"borrow","","",242,[[]]],[11,"borrow_mut","","",242,[[]]],[11,"into","","",242,[[]]],[11,"from","","",242,[[]]],[11,"try_into","","",242,[[],["result",4]]],[11,"try_from","","",242,[[],["result",4]]],[11,"type_id","","",242,[[],["typeid",3]]],[11,"borrow","","",131,[[]]],[11,"borrow_mut","","",131,[[]]],[11,"into","","",131,[[]]],[11,"from","","",131,[[]]],[11,"try_into","","",131,[[],["result",4]]],[11,"try_from","","",131,[[],["result",4]]],[11,"type_id","","",131,[[],["typeid",3]]],[11,"borrow","","",243,[[]]],[11,"borrow_mut","","",243,[[]]],[11,"into","","",243,[[]]],[11,"from","","",243,[[]]],[11,"try_into","","",243,[[],["result",4]]],[11,"try_from","","",243,[[],["result",4]]],[11,"type_id","","",243,[[],["typeid",3]]],[11,"borrow","","",115,[[]]],[11,"borrow_mut","","",115,[[]]],[11,"into","","",115,[[]]],[11,"from","","",115,[[]]],[11,"try_into","","",115,[[],["result",4]]],[11,"try_from","","",115,[[],["result",4]]],[11,"type_id","","",115,[[],["typeid",3]]],[11,"borrow","core::hash","",132,[[]]],[11,"borrow_mut","","",132,[[]]],[11,"into","","",132,[[]]],[11,"from","","",132,[[]]],[11,"try_into","","",132,[[],["result",4]]],[11,"try_from","","",132,[[],["result",4]]],[11,"type_id","","",132,[[],["typeid",3]]],[11,"borrow","","",244,[[]]],[11,"borrow_mut","","",244,[[]]],[11,"into","","",244,[[]]],[11,"from","","",244,[[]]],[11,"try_into","","",244,[[],["result",4]]],[11,"try_from","","",244,[[],["result",4]]],[11,"type_id","","",244,[[],["typeid",3]]],[11,"borrow","core::slice","",137,[[]]],[11,"borrow_mut","","",137,[[]]],[11,"into","","",137,[[]]],[11,"from","","",137,[[]]],[11,"try_into","","",137,[[],["result",4]]],[11,"try_from","","",137,[[],["result",4]]],[11,"type_id","","",137,[[],["typeid",3]]],[11,"borrow","","",138,[[]]],[11,"borrow_mut","","",138,[[]]],[11,"into","","",138,[[]]],[11,"from","","",138,[[]]],[11,"try_into","","",138,[[],["result",4]]],[11,"try_from","","",138,[[],["result",4]]],[11,"type_id","","",138,[[],["typeid",3]]],[11,"borrow","","",245,[[]]],[11,"borrow_mut","","",245,[[]]],[11,"into","","",245,[[]]],[11,"from","","",245,[[]]],[11,"try_into","","",245,[[],["result",4]]],[11,"try_from","","",245,[[],["result",4]]],[11,"type_id","","",245,[[],["typeid",3]]],[11,"borrow","","",246,[[]]],[11,"borrow_mut","","",246,[[]]],[11,"into","","",246,[[]]],[11,"from","","",246,[[]]],[11,"try_into","","",246,[[],["result",4]]],[11,"try_from","","",246,[[],["result",4]]],[11,"type_id","","",246,[[],["typeid",3]]],[11,"borrow","","",247,[[]]],[11,"borrow_mut","","",247,[[]]],[11,"into","","",247,[[]]],[11,"from","","",247,[[]]],[11,"try_into","","",247,[[],["result",4]]],[11,"try_from","","",247,[[],["result",4]]],[11,"type_id","","",247,[[],["typeid",3]]],[11,"borrow","","",248,[[]]],[11,"borrow_mut","","",248,[[]]],[11,"into","","",248,[[]]],[11,"from","","",248,[[]]],[11,"try_into","","",248,[[],["result",4]]],[11,"try_from","","",248,[[],["result",4]]],[11,"type_id","","",248,[[],["typeid",3]]],[11,"borrow","","",249,[[]]],[11,"borrow_mut","","",249,[[]]],[11,"into","","",249,[[]]],[11,"from","","",249,[[]]],[11,"try_into","","",249,[[],["result",4]]],[11,"try_from","","",249,[[],["result",4]]],[11,"type_id","","",249,[[],["typeid",3]]],[11,"borrow","","",250,[[]]],[11,"borrow_mut","","",250,[[]]],[11,"into","","",250,[[]]],[11,"from","","",250,[[]]],[11,"try_into","","",250,[[],["result",4]]],[11,"try_from","","",250,[[],["result",4]]],[11,"type_id","","",250,[[],["typeid",3]]],[11,"borrow","","",251,[[]]],[11,"borrow_mut","","",251,[[]]],[11,"into","","",251,[[]]],[11,"from","","",251,[[]]],[11,"try_into","","",251,[[],["result",4]]],[11,"try_from","","",251,[[],["result",4]]],[11,"type_id","","",251,[[],["typeid",3]]],[11,"borrow","","",252,[[]]],[11,"borrow_mut","","",252,[[]]],[11,"into","","",252,[[]]],[11,"from","","",252,[[]]],[11,"try_into","","",252,[[],["result",4]]],[11,"try_from","","",252,[[],["result",4]]],[11,"type_id","","",252,[[],["typeid",3]]],[11,"borrow","","",253,[[]]],[11,"borrow_mut","","",253,[[]]],[11,"into","","",253,[[]]],[11,"from","","",253,[[]]],[11,"try_into","","",253,[[],["result",4]]],[11,"try_from","","",253,[[],["result",4]]],[11,"type_id","","",253,[[],["typeid",3]]],[11,"borrow","","",254,[[]]],[11,"borrow_mut","","",254,[[]]],[11,"into","","",254,[[]]],[11,"from","","",254,[[]]],[11,"try_into","","",254,[[],["result",4]]],[11,"try_from","","",254,[[],["result",4]]],[11,"type_id","","",254,[[],["typeid",3]]],[11,"borrow","","",255,[[]]],[11,"borrow_mut","","",255,[[]]],[11,"into","","",255,[[]]],[11,"from","","",255,[[]]],[11,"try_into","","",255,[[],["result",4]]],[11,"try_from","","",255,[[],["result",4]]],[11,"type_id","","",255,[[],["typeid",3]]],[11,"borrow","","",256,[[]]],[11,"borrow_mut","","",256,[[]]],[11,"into","","",256,[[]]],[11,"from","","",256,[[]]],[11,"try_into","","",256,[[],["result",4]]],[11,"try_from","","",256,[[],["result",4]]],[11,"type_id","","",256,[[],["typeid",3]]],[11,"borrow","","",257,[[]]],[11,"borrow_mut","","",257,[[]]],[11,"into","","",257,[[]]],[11,"from","","",257,[[]]],[11,"try_into","","",257,[[],["result",4]]],[11,"try_from","","",257,[[],["result",4]]],[11,"type_id","","",257,[[],["typeid",3]]],[11,"borrow","","",139,[[]]],[11,"borrow_mut","","",139,[[]]],[11,"into","","",139,[[]]],[11,"from","","",139,[[]]],[11,"try_into","","",139,[[],["result",4]]],[11,"try_from","","",139,[[],["result",4]]],[11,"type_id","","",139,[[],["typeid",3]]],[11,"borrow","","",140,[[]]],[11,"borrow_mut","","",140,[[]]],[11,"into","","",140,[[]]],[11,"from","","",140,[[]]],[11,"try_into","","",140,[[],["result",4]]],[11,"try_from","","",140,[[],["result",4]]],[11,"type_id","","",140,[[],["typeid",3]]],[11,"borrow","","",258,[[]]],[11,"borrow_mut","","",258,[[]]],[11,"into","","",258,[[]]],[11,"from","","",258,[[]]],[11,"try_into","","",258,[[],["result",4]]],[11,"try_from","","",258,[[],["result",4]]],[11,"type_id","","",258,[[],["typeid",3]]],[11,"borrow","","",259,[[]]],[11,"borrow_mut","","",259,[[]]],[11,"into","","",259,[[]]],[11,"from","","",259,[[]]],[11,"try_into","","",259,[[],["result",4]]],[11,"try_from","","",259,[[],["result",4]]],[11,"type_id","","",259,[[],["typeid",3]]],[11,"borrow","","",141,[[]]],[11,"borrow_mut","","",141,[[]]],[11,"into","","",141,[[]]],[11,"from","","",141,[[]]],[11,"try_into","","",141,[[],["result",4]]],[11,"try_from","","",141,[[],["result",4]]],[11,"type_id","","",141,[[],["typeid",3]]],[11,"borrow","","",142,[[]]],[11,"borrow_mut","","",142,[[]]],[11,"into","","",142,[[]]],[11,"from","","",142,[[]]],[11,"try_into","","",142,[[],["result",4]]],[11,"try_from","","",142,[[],["result",4]]],[11,"type_id","","",142,[[],["typeid",3]]],[11,"borrow","core::str","",260,[[]]],[11,"borrow_mut","","",260,[[]]],[11,"into","","",260,[[]]],[11,"from","","",260,[[]]],[11,"try_into","","",260,[[],["result",4]]],[11,"try_from","","",260,[[],["result",4]]],[11,"type_id","","",260,[[],["typeid",3]]],[11,"borrow","","",150,[[]]],[11,"borrow_mut","","",150,[[]]],[11,"into","","",150,[[]]],[11,"from","","",150,[[]]],[11,"try_into","","",150,[[],["result",4]]],[11,"try_from","","",150,[[],["result",4]]],[11,"type_id","","",150,[[],["typeid",3]]],[11,"borrow","","",151,[[]]],[11,"borrow_mut","","",151,[[]]],[11,"into","","",151,[[]]],[11,"from","","",151,[[]]],[11,"try_into","","",151,[[],["result",4]]],[11,"try_from","","",151,[[],["result",4]]],[11,"type_id","","",151,[[],["typeid",3]]],[11,"borrow","","",152,[[]]],[11,"borrow_mut","","",152,[[]]],[11,"into","","",152,[[]]],[11,"from","","",152,[[]]],[11,"try_into","","",152,[[],["result",4]]],[11,"try_from","","",152,[[],["result",4]]],[11,"type_id","","",152,[[],["typeid",3]]],[11,"borrow","","",261,[[]]],[11,"borrow_mut","","",261,[[]]],[11,"into","","",261,[[]]],[11,"from","","",261,[[]]],[11,"try_into","","",261,[[],["result",4]]],[11,"try_from","","",261,[[],["result",4]]],[11,"type_id","","",261,[[],["typeid",3]]],[11,"borrow","","",262,[[]]],[11,"borrow_mut","","",262,[[]]],[11,"into","","",262,[[]]],[11,"from","","",262,[[]]],[11,"try_into","","",262,[[],["result",4]]],[11,"try_from","","",262,[[],["result",4]]],[11,"type_id","","",262,[[],["typeid",3]]],[11,"borrow","","",263,[[]]],[11,"borrow_mut","","",263,[[]]],[11,"into","","",263,[[]]],[11,"from","","",263,[[]]],[11,"try_into","","",263,[[],["result",4]]],[11,"try_from","","",263,[[],["result",4]]],[11,"type_id","","",263,[[],["typeid",3]]],[11,"borrow","","",264,[[]]],[11,"borrow_mut","","",264,[[]]],[11,"into","","",264,[[]]],[11,"from","","",264,[[]]],[11,"try_into","","",264,[[],["result",4]]],[11,"try_from","","",264,[[],["result",4]]],[11,"type_id","","",264,[[],["typeid",3]]],[11,"borrow","","",265,[[]]],[11,"borrow_mut","","",265,[[]]],[11,"into","","",265,[[]]],[11,"from","","",265,[[]]],[11,"try_into","","",265,[[],["result",4]]],[11,"try_from","","",265,[[],["result",4]]],[11,"type_id","","",265,[[],["typeid",3]]],[11,"borrow","","",266,[[]]],[11,"borrow_mut","","",266,[[]]],[11,"into","","",266,[[]]],[11,"from","","",266,[[]]],[11,"try_into","","",266,[[],["result",4]]],[11,"try_from","","",266,[[],["result",4]]],[11,"type_id","","",266,[[],["typeid",3]]],[11,"borrow","","",267,[[]]],[11,"borrow_mut","","",267,[[]]],[11,"into","","",267,[[]]],[11,"from","","",267,[[]]],[11,"try_into","","",267,[[],["result",4]]],[11,"try_from","","",267,[[],["result",4]]],[11,"type_id","","",267,[[],["typeid",3]]],[11,"borrow","","",268,[[]]],[11,"borrow_mut","","",268,[[]]],[11,"into","","",268,[[]]],[11,"from","","",268,[[]]],[11,"try_into","","",268,[[],["result",4]]],[11,"try_from","","",268,[[],["result",4]]],[11,"type_id","","",268,[[],["typeid",3]]],[11,"borrow","","",269,[[]]],[11,"borrow_mut","","",269,[[]]],[11,"into","","",269,[[]]],[11,"from","","",269,[[]]],[11,"try_into","","",269,[[],["result",4]]],[11,"try_from","","",269,[[],["result",4]]],[11,"type_id","","",269,[[],["typeid",3]]],[11,"borrow","","",270,[[]]],[11,"borrow_mut","","",270,[[]]],[11,"into","","",270,[[]]],[11,"from","","",270,[[]]],[11,"try_into","","",270,[[],["result",4]]],[11,"try_from","","",270,[[],["result",4]]],[11,"type_id","","",270,[[],["typeid",3]]],[11,"borrow","","",271,[[]]],[11,"borrow_mut","","",271,[[]]],[11,"into","","",271,[[]]],[11,"from","","",271,[[]]],[11,"try_into","","",271,[[],["result",4]]],[11,"try_from","","",271,[[],["result",4]]],[11,"type_id","","",271,[[],["typeid",3]]],[11,"borrow","","",272,[[]]],[11,"borrow_mut","","",272,[[]]],[11,"into","","",272,[[]]],[11,"from","","",272,[[]]],[11,"try_into","","",272,[[],["result",4]]],[11,"try_from","","",272,[[],["result",4]]],[11,"type_id","","",272,[[],["typeid",3]]],[11,"borrow","","",273,[[]]],[11,"borrow_mut","","",273,[[]]],[11,"into","","",273,[[]]],[11,"from","","",273,[[]]],[11,"try_into","","",273,[[],["result",4]]],[11,"try_from","","",273,[[],["result",4]]],[11,"type_id","","",273,[[],["typeid",3]]],[11,"borrow","","",274,[[]]],[11,"borrow_mut","","",274,[[]]],[11,"into","","",274,[[]]],[11,"from","","",274,[[]]],[11,"try_into","","",274,[[],["result",4]]],[11,"try_from","","",274,[[],["result",4]]],[11,"type_id","","",274,[[],["typeid",3]]],[11,"borrow","","",275,[[]]],[11,"borrow_mut","","",275,[[]]],[11,"into","","",275,[[]]],[11,"from","","",275,[[]]],[11,"try_into","","",275,[[],["result",4]]],[11,"try_from","","",275,[[],["result",4]]],[11,"type_id","","",275,[[],["typeid",3]]],[11,"borrow","","",276,[[]]],[11,"borrow_mut","","",276,[[]]],[11,"into","","",276,[[]]],[11,"from","","",276,[[]]],[11,"try_into","","",276,[[],["result",4]]],[11,"try_from","","",276,[[],["result",4]]],[11,"type_id","","",276,[[],["typeid",3]]],[11,"borrow","","",277,[[]]],[11,"borrow_mut","","",277,[[]]],[11,"into","","",277,[[]]],[11,"from","","",277,[[]]],[11,"try_into","","",277,[[],["result",4]]],[11,"try_from","","",277,[[],["result",4]]],[11,"type_id","","",277,[[],["typeid",3]]],[11,"borrow","","",278,[[]]],[11,"borrow_mut","","",278,[[]]],[11,"into","","",278,[[]]],[11,"from","","",278,[[]]],[11,"try_into","","",278,[[],["result",4]]],[11,"try_from","","",278,[[],["result",4]]],[11,"type_id","","",278,[[],["typeid",3]]],[11,"borrow","","",279,[[]]],[11,"borrow_mut","","",279,[[]]],[11,"into","","",279,[[]]],[11,"from","","",279,[[]]],[11,"try_into","","",279,[[],["result",4]]],[11,"try_from","","",279,[[],["result",4]]],[11,"type_id","","",279,[[],["typeid",3]]],[11,"borrow","","",280,[[]]],[11,"borrow_mut","","",280,[[]]],[11,"into","","",280,[[]]],[11,"from","","",280,[[]]],[11,"try_into","","",280,[[],["result",4]]],[11,"try_from","","",280,[[],["result",4]]],[11,"type_id","","",280,[[],["typeid",3]]],[11,"borrow","core::str::pattern","",281,[[]]],[11,"borrow_mut","","",281,[[]]],[11,"into","","",281,[[]]],[11,"from","","",281,[[]]],[11,"try_into","","",281,[[],["result",4]]],[11,"try_from","","",281,[[],["result",4]]],[11,"type_id","","",281,[[],["typeid",3]]],[11,"borrow","","",282,[[]]],[11,"borrow_mut","","",282,[[]]],[11,"into","","",282,[[]]],[11,"from","","",282,[[]]],[11,"try_into","","",282,[[],["result",4]]],[11,"try_from","","",282,[[],["result",4]]],[11,"type_id","","",282,[[],["typeid",3]]],[11,"borrow","","",283,[[]]],[11,"borrow_mut","","",283,[[]]],[11,"into","","",283,[[]]],[11,"from","","",283,[[]]],[11,"try_into","","",283,[[],["result",4]]],[11,"try_from","","",283,[[],["result",4]]],[11,"type_id","","",283,[[],["typeid",3]]],[11,"borrow","","",284,[[]]],[11,"borrow_mut","","",284,[[]]],[11,"into","","",284,[[]]],[11,"from","","",284,[[]]],[11,"try_into","","",284,[[],["result",4]]],[11,"try_from","","",284,[[],["result",4]]],[11,"type_id","","",284,[[],["typeid",3]]],[11,"borrow","","",143,[[]]],[11,"borrow_mut","","",143,[[]]],[11,"into","","",143,[[]]],[11,"from","","",143,[[]]],[11,"try_into","","",143,[[],["result",4]]],[11,"try_from","","",143,[[],["result",4]]],[11,"type_id","","",143,[[],["typeid",3]]],[11,"borrow","core::str::lossy","",148,[[]]],[11,"borrow_mut","","",148,[[]]],[11,"type_id","","",148,[[],["typeid",3]]],[11,"borrow","","",285,[[]]],[11,"borrow_mut","","",285,[[]]],[11,"into","","",285,[[]]],[11,"from","","",285,[[]]],[11,"try_into","","",285,[[],["result",4]]],[11,"try_from","","",285,[[],["result",4]]],[11,"type_id","","",285,[[],["typeid",3]]],[11,"borrow","","",147,[[]]],[11,"borrow_mut","","",147,[[]]],[11,"into","","",147,[[]]],[11,"from","","",147,[[]]],[11,"try_into","","",147,[[],["result",4]]],[11,"try_from","","",147,[[],["result",4]]],[11,"type_id","","",147,[[],["typeid",3]]],[11,"borrow","core::time","",153,[[]]],[11,"borrow_mut","","",153,[[]]],[11,"into","","",153,[[]]],[11,"from","","",153,[[]]],[11,"try_into","","",153,[[],["result",4]]],[11,"try_from","","",153,[[],["result",4]]],[11,"type_id","","",153,[[],["typeid",3]]],[11,"borrow","core::future","",286,[[]]],[11,"borrow_mut","","",286,[[]]],[11,"into","","",286,[[]]],[11,"from","","",286,[[]]],[11,"try_into","","",286,[[],["result",4]]],[11,"try_from","","",286,[[],["result",4]]],[11,"type_id","","",286,[[],["typeid",3]]],[11,"borrow","","",287,[[]]],[11,"borrow_mut","","",287,[[]]],[11,"into","","",287,[[]]],[11,"from","","",287,[[]]],[11,"try_into","","",287,[[],["result",4]]],[11,"try_from","","",287,[[],["result",4]]],[11,"type_id","","",287,[[],["typeid",3]]],[11,"borrow","core::task","",159,[[]]],[11,"borrow_mut","","",159,[[]]],[11,"into","","",159,[[]]],[11,"from","","",159,[[]]],[11,"try_into","","",159,[[],["result",4]]],[11,"try_from","","",159,[[],["result",4]]],[11,"type_id","","",159,[[],["typeid",3]]],[11,"borrow","","",157,[[]]],[11,"borrow_mut","","",157,[[]]],[11,"into","","",157,[[]]],[11,"from","","",157,[[]]],[11,"try_into","","",157,[[],["result",4]]],[11,"try_from","","",157,[[],["result",4]]],[11,"type_id","","",157,[[],["typeid",3]]],[11,"borrow","","",158,[[]]],[11,"borrow_mut","","",158,[[]]],[11,"into","","",158,[[]]],[11,"from","","",158,[[]]],[11,"try_into","","",158,[[],["result",4]]],[11,"try_from","","",158,[[],["result",4]]],[11,"type_id","","",158,[[],["typeid",3]]],[11,"borrow","","",160,[[]]],[11,"borrow_mut","","",160,[[]]],[11,"into","","",160,[[]]],[11,"from","","",160,[[]]],[11,"try_into","","",160,[[],["result",4]]],[11,"try_from","","",160,[[],["result",4]]],[11,"type_id","","",160,[[],["typeid",3]]],[11,"borrow","","",156,[[]]],[11,"borrow_mut","","",156,[[]]],[11,"into","","",156,[[]]],[11,"from","","",156,[[]]],[11,"from","","",156,[[]]],[11,"try_into","","",156,[[],["result",4]]],[11,"try_from","","",156,[[],["result",4]]],[11,"type_id","","",156,[[],["typeid",3]]],[11,"borrow","core::alloc","",164,[[]]],[11,"borrow_mut","","",164,[[]]],[11,"into","","",164,[[]]],[11,"from","","",164,[[]]],[11,"try_into","","",164,[[],["result",4]]],[11,"try_from","","",164,[[],["result",4]]],[11,"type_id","","",164,[[],["typeid",3]]],[11,"borrow","","",288,[[]]],[11,"borrow_mut","","",288,[[]]],[11,"into","","",288,[[]]],[11,"from","","",288,[[]]],[11,"try_into","","",288,[[],["result",4]]],[11,"try_from","","",288,[[],["result",4]]],[11,"type_id","","",288,[[],["typeid",3]]],[11,"borrow","","",289,[[]]],[11,"borrow_mut","","",289,[[]]],[11,"into","","",289,[[]]],[11,"from","","",289,[[]]],[11,"try_into","","",289,[[],["result",4]]],[11,"try_from","","",289,[[],["result",4]]],[11,"type_id","","",289,[[],["typeid",3]]],[11,"borrow","","",161,[[]]],[11,"borrow_mut","","",161,[[]]],[11,"into","","",161,[[]]],[11,"from","","",161,[[]]],[11,"try_into","","",161,[[],["result",4]]],[11,"try_from","","",161,[[],["result",4]]],[11,"type_id","","",161,[[],["typeid",3]]],[11,"borrow","","",162,[[]]],[11,"borrow_mut","","",162,[[]]],[11,"into","","",162,[[]]],[11,"from","","",162,[[]]],[11,"try_into","","",162,[[],["result",4]]],[11,"try_from","","",162,[[],["result",4]]],[11,"type_id","","",162,[[],["typeid",3]]],[11,"borrow","","",163,[[]]],[11,"borrow_mut","","",163,[[]]],[11,"into","","",163,[[]]],[11,"from","","",163,[[]]],[11,"try_into","","",163,[[],["result",4]]],[11,"try_from","","",163,[[],["result",4]]],[11,"type_id","","",163,[[],["typeid",3]]],[11,"borrow","core::arch::arm","",290,[[]]],[11,"borrow_mut","","",290,[[]]],[11,"into","","",290,[[]]],[11,"from","","",290,[[]]],[11,"try_into","","",290,[[],["result",4]]],[11,"try_from","","",290,[[],["result",4]]],[11,"type_id","","",290,[[],["typeid",3]]],[11,"borrow","","",291,[[]]],[11,"borrow_mut","","",291,[[]]],[11,"into","","",291,[[]]],[11,"from","","",291,[[]]],[11,"try_into","","",291,[[],["result",4]]],[11,"try_from","","",291,[[],["result",4]]],[11,"type_id","","",291,[[],["typeid",3]]],[11,"borrow","core::arch::x86","",292,[[]]],[11,"borrow_mut","","",292,[[]]],[11,"into","","",292,[[]]],[11,"from","","",292,[[]]],[11,"try_into","","",292,[[],["result",4]]],[11,"try_from","","",292,[[],["result",4]]],[11,"type_id","","",292,[[],["typeid",3]]],[11,"borrow","","",293,[[]]],[11,"borrow_mut","","",293,[[]]],[11,"into","","",293,[[]]],[11,"from","","",293,[[]]],[11,"try_into","","",293,[[],["result",4]]],[11,"try_from","","",293,[[],["result",4]]],[11,"type_id","","",293,[[],["typeid",3]]],[11,"borrow","","",294,[[]]],[11,"borrow_mut","","",294,[[]]],[11,"into","","",294,[[]]],[11,"from","","",294,[[]]],[11,"try_into","","",294,[[],["result",4]]],[11,"try_from","","",294,[[],["result",4]]],[11,"type_id","","",294,[[],["typeid",3]]],[11,"borrow","","",295,[[]]],[11,"borrow_mut","","",295,[[]]],[11,"into","","",295,[[]]],[11,"from","","",295,[[]]],[11,"try_into","","",295,[[],["result",4]]],[11,"try_from","","",295,[[],["result",4]]],[11,"type_id","","",295,[[],["typeid",3]]],[11,"borrow","","",296,[[]]],[11,"borrow_mut","","",296,[[]]],[11,"into","","",296,[[]]],[11,"from","","",296,[[]]],[11,"try_into","","",296,[[],["result",4]]],[11,"try_from","","",296,[[],["result",4]]],[11,"type_id","","",296,[[],["typeid",3]]],[11,"borrow","","",297,[[]]],[11,"borrow_mut","","",297,[[]]],[11,"into","","",297,[[]]],[11,"from","","",297,[[]]],[11,"try_into","","",297,[[],["result",4]]],[11,"try_from","","",297,[[],["result",4]]],[11,"type_id","","",297,[[],["typeid",3]]],[11,"borrow","","",298,[[]]],[11,"borrow_mut","","",298,[[]]],[11,"into","","",298,[[]]],[11,"from","","",298,[[]]],[11,"try_into","","",298,[[],["result",4]]],[11,"try_from","","",298,[[],["result",4]]],[11,"type_id","","",298,[[],["typeid",3]]],[11,"borrow","","",299,[[]]],[11,"borrow_mut","","",299,[[]]],[11,"into","","",299,[[]]],[11,"from","","",299,[[]]],[11,"try_into","","",299,[[],["result",4]]],[11,"try_from","","",299,[[],["result",4]]],[11,"type_id","","",299,[[],["typeid",3]]],[11,"borrow","","",300,[[]]],[11,"borrow_mut","","",300,[[]]],[11,"into","","",300,[[]]],[11,"from","","",300,[[]]],[11,"try_into","","",300,[[],["result",4]]],[11,"try_from","","",300,[[],["result",4]]],[11,"type_id","","",300,[[],["typeid",3]]],[11,"borrow","","",301,[[]]],[11,"borrow_mut","","",301,[[]]],[11,"into","","",301,[[]]],[11,"from","","",301,[[]]],[11,"try_into","","",301,[[],["result",4]]],[11,"try_from","","",301,[[],["result",4]]],[11,"type_id","","",301,[[],["typeid",3]]],[11,"borrow","","",167,[[]]],[11,"borrow_mut","","",167,[[]]],[11,"into","","",167,[[]]],[11,"from","","",167,[[]]],[11,"try_into","","",167,[[],["result",4]]],[11,"try_from","","",167,[[],["result",4]]],[11,"type_id","","",167,[[],["typeid",3]]],[11,"borrow","core::arch::aarch64","",302,[[]]],[11,"borrow_mut","","",302,[[]]],[11,"into","","",302,[[]]],[11,"from","","",302,[[]]],[11,"try_into","","",302,[[],["result",4]]],[11,"try_from","","",302,[[],["result",4]]],[11,"type_id","","",302,[[],["typeid",3]]],[11,"borrow","","",303,[[]]],[11,"borrow_mut","","",303,[[]]],[11,"into","","",303,[[]]],[11,"from","","",303,[[]]],[11,"try_into","","",303,[[],["result",4]]],[11,"try_from","","",303,[[],["result",4]]],[11,"type_id","","",303,[[],["typeid",3]]],[11,"borrow","","",304,[[]]],[11,"borrow_mut","","",304,[[]]],[11,"into","","",304,[[]]],[11,"from","","",304,[[]]],[11,"try_into","","",304,[[],["result",4]]],[11,"try_from","","",304,[[],["result",4]]],[11,"type_id","","",304,[[],["typeid",3]]],[11,"borrow","","",305,[[]]],[11,"borrow_mut","","",305,[[]]],[11,"into","","",305,[[]]],[11,"from","","",305,[[]]],[11,"try_into","","",305,[[],["result",4]]],[11,"try_from","","",305,[[],["result",4]]],[11,"type_id","","",305,[[],["typeid",3]]],[11,"borrow","","",306,[[]]],[11,"borrow_mut","","",306,[[]]],[11,"into","","",306,[[]]],[11,"from","","",306,[[]]],[11,"try_into","","",306,[[],["result",4]]],[11,"try_from","","",306,[[],["result",4]]],[11,"type_id","","",306,[[],["typeid",3]]],[11,"borrow","","",307,[[]]],[11,"borrow_mut","","",307,[[]]],[11,"into","","",307,[[]]],[11,"from","","",307,[[]]],[11,"try_into","","",307,[[],["result",4]]],[11,"try_from","","",307,[[],["result",4]]],[11,"type_id","","",307,[[],["typeid",3]]],[11,"borrow","","",177,[[]]],[11,"borrow_mut","","",177,[[]]],[11,"into","","",177,[[]]],[11,"from","","",177,[[]]],[11,"try_into","","",177,[[],["result",4]]],[11,"try_from","","",177,[[],["result",4]]],[11,"type_id","","",177,[[],["typeid",3]]],[11,"borrow","","",178,[[]]],[11,"borrow_mut","","",178,[[]]],[11,"into","","",178,[[]]],[11,"from","","",178,[[]]],[11,"try_into","","",178,[[],["result",4]]],[11,"try_from","","",178,[[],["result",4]]],[11,"type_id","","",178,[[],["typeid",3]]],[11,"borrow","","",179,[[]]],[11,"borrow_mut","","",179,[[]]],[11,"into","","",179,[[]]],[11,"from","","",179,[[]]],[11,"try_into","","",179,[[],["result",4]]],[11,"try_from","","",179,[[],["result",4]]],[11,"type_id","","",179,[[],["typeid",3]]],[11,"borrow","","",180,[[]]],[11,"borrow_mut","","",180,[[]]],[11,"into","","",180,[[]]],[11,"from","","",180,[[]]],[11,"try_into","","",180,[[],["result",4]]],[11,"try_from","","",180,[[],["result",4]]],[11,"type_id","","",180,[[],["typeid",3]]],[11,"borrow","","",181,[[]]],[11,"borrow_mut","","",181,[[]]],[11,"into","","",181,[[]]],[11,"from","","",181,[[]]],[11,"try_into","","",181,[[],["result",4]]],[11,"try_from","","",181,[[],["result",4]]],[11,"type_id","","",181,[[],["typeid",3]]],[11,"borrow","","",182,[[]]],[11,"borrow_mut","","",182,[[]]],[11,"into","","",182,[[]]],[11,"from","","",182,[[]]],[11,"try_into","","",182,[[],["result",4]]],[11,"try_from","","",182,[[],["result",4]]],[11,"type_id","","",182,[[],["typeid",3]]],[11,"borrow","","",183,[[]]],[11,"borrow_mut","","",183,[[]]],[11,"into","","",183,[[]]],[11,"from","","",183,[[]]],[11,"try_into","","",183,[[],["result",4]]],[11,"try_from","","",183,[[],["result",4]]],[11,"type_id","","",183,[[],["typeid",3]]],[11,"borrow","","",184,[[]]],[11,"borrow_mut","","",184,[[]]],[11,"into","","",184,[[]]],[11,"from","","",184,[[]]],[11,"try_into","","",184,[[],["result",4]]],[11,"try_from","","",184,[[],["result",4]]],[11,"type_id","","",184,[[],["typeid",3]]],[11,"borrow","","",185,[[]]],[11,"borrow_mut","","",185,[[]]],[11,"into","","",185,[[]]],[11,"from","","",185,[[]]],[11,"try_into","","",185,[[],["result",4]]],[11,"try_from","","",185,[[],["result",4]]],[11,"type_id","","",185,[[],["typeid",3]]],[11,"borrow","core::arch::arm","",308,[[]]],[11,"borrow_mut","","",308,[[]]],[11,"into","","",308,[[]]],[11,"from","","",308,[[]]],[11,"try_into","","",308,[[],["result",4]]],[11,"try_from","","",308,[[],["result",4]]],[11,"type_id","","",308,[[],["typeid",3]]],[11,"borrow","","",309,[[]]],[11,"borrow_mut","","",309,[[]]],[11,"into","","",309,[[]]],[11,"from","","",309,[[]]],[11,"try_into","","",309,[[],["result",4]]],[11,"try_from","","",309,[[],["result",4]]],[11,"type_id","","",309,[[],["typeid",3]]],[11,"borrow","","",310,[[]]],[11,"borrow_mut","","",310,[[]]],[11,"into","","",310,[[]]],[11,"from","","",310,[[]]],[11,"try_into","","",310,[[],["result",4]]],[11,"try_from","","",310,[[],["result",4]]],[11,"type_id","","",310,[[],["typeid",3]]],[11,"borrow","","",311,[[]]],[11,"borrow_mut","","",311,[[]]],[11,"into","","",311,[[]]],[11,"from","","",311,[[]]],[11,"try_into","","",311,[[],["result",4]]],[11,"try_from","","",311,[[],["result",4]]],[11,"type_id","","",311,[[],["typeid",3]]],[11,"borrow","","",312,[[]]],[11,"borrow_mut","","",312,[[]]],[11,"into","","",312,[[]]],[11,"from","","",312,[[]]],[11,"try_into","","",312,[[],["result",4]]],[11,"try_from","","",312,[[],["result",4]]],[11,"type_id","","",312,[[],["typeid",3]]],[11,"borrow","","",313,[[]]],[11,"borrow_mut","","",313,[[]]],[11,"into","","",313,[[]]],[11,"from","","",313,[[]]],[11,"try_into","","",313,[[],["result",4]]],[11,"try_from","","",313,[[],["result",4]]],[11,"type_id","","",313,[[],["typeid",3]]],[11,"borrow","","",314,[[]]],[11,"borrow_mut","","",314,[[]]],[11,"into","","",314,[[]]],[11,"from","","",314,[[]]],[11,"try_into","","",314,[[],["result",4]]],[11,"try_from","","",314,[[],["result",4]]],[11,"type_id","","",314,[[],["typeid",3]]],[11,"borrow","","",315,[[]]],[11,"borrow_mut","","",315,[[]]],[11,"into","","",315,[[]]],[11,"from","","",315,[[]]],[11,"try_into","","",315,[[],["result",4]]],[11,"try_from","","",315,[[],["result",4]]],[11,"type_id","","",315,[[],["typeid",3]]],[11,"borrow","","",316,[[]]],[11,"borrow_mut","","",316,[[]]],[11,"into","","",316,[[]]],[11,"from","","",316,[[]]],[11,"try_into","","",316,[[],["result",4]]],[11,"try_from","","",316,[[],["result",4]]],[11,"type_id","","",316,[[],["typeid",3]]],[11,"borrow","","",317,[[]]],[11,"borrow_mut","","",317,[[]]],[11,"into","","",317,[[]]],[11,"from","","",317,[[]]],[11,"try_into","","",317,[[],["result",4]]],[11,"try_from","","",317,[[],["result",4]]],[11,"type_id","","",317,[[],["typeid",3]]],[11,"borrow","","",318,[[]]],[11,"borrow_mut","","",318,[[]]],[11,"into","","",318,[[]]],[11,"from","","",318,[[]]],[11,"try_into","","",318,[[],["result",4]]],[11,"try_from","","",318,[[],["result",4]]],[11,"type_id","","",318,[[],["typeid",3]]],[11,"borrow","","",319,[[]]],[11,"borrow_mut","","",319,[[]]],[11,"into","","",319,[[]]],[11,"from","","",319,[[]]],[11,"try_into","","",319,[[],["result",4]]],[11,"try_from","","",319,[[],["result",4]]],[11,"type_id","","",319,[[],["typeid",3]]],[11,"borrow","","",320,[[]]],[11,"borrow_mut","","",320,[[]]],[11,"into","","",320,[[]]],[11,"from","","",320,[[]]],[11,"try_into","","",320,[[],["result",4]]],[11,"try_from","","",320,[[],["result",4]]],[11,"type_id","","",320,[[],["typeid",3]]],[11,"borrow","","",321,[[]]],[11,"borrow_mut","","",321,[[]]],[11,"into","","",321,[[]]],[11,"from","","",321,[[]]],[11,"try_into","","",321,[[],["result",4]]],[11,"try_from","","",321,[[],["result",4]]],[11,"type_id","","",321,[[],["typeid",3]]],[11,"borrow","","",322,[[]]],[11,"borrow_mut","","",322,[[]]],[11,"into","","",322,[[]]],[11,"from","","",322,[[]]],[11,"try_into","","",322,[[],["result",4]]],[11,"try_from","","",322,[[],["result",4]]],[11,"type_id","","",322,[[],["typeid",3]]],[11,"borrow","","",323,[[]]],[11,"borrow_mut","","",323,[[]]],[11,"into","","",323,[[]]],[11,"from","","",323,[[]]],[11,"try_into","","",323,[[],["result",4]]],[11,"try_from","","",323,[[],["result",4]]],[11,"type_id","","",323,[[],["typeid",3]]],[11,"borrow","","",324,[[]]],[11,"borrow_mut","","",324,[[]]],[11,"into","","",324,[[]]],[11,"from","","",324,[[]]],[11,"try_into","","",324,[[],["result",4]]],[11,"try_from","","",324,[[],["result",4]]],[11,"type_id","","",324,[[],["typeid",3]]],[11,"borrow","","",325,[[]]],[11,"borrow_mut","","",325,[[]]],[11,"into","","",325,[[]]],[11,"from","","",325,[[]]],[11,"try_into","","",325,[[],["result",4]]],[11,"try_from","","",325,[[],["result",4]]],[11,"type_id","","",325,[[],["typeid",3]]],[11,"borrow","","",326,[[]]],[11,"borrow_mut","","",326,[[]]],[11,"into","","",326,[[]]],[11,"from","","",326,[[]]],[11,"try_into","","",326,[[],["result",4]]],[11,"try_from","","",326,[[],["result",4]]],[11,"type_id","","",326,[[],["typeid",3]]],[11,"borrow","","",327,[[]]],[11,"borrow_mut","","",327,[[]]],[11,"into","","",327,[[]]],[11,"from","","",327,[[]]],[11,"try_into","","",327,[[],["result",4]]],[11,"try_from","","",327,[[],["result",4]]],[11,"type_id","","",327,[[],["typeid",3]]],[11,"borrow","","",328,[[]]],[11,"borrow_mut","","",328,[[]]],[11,"into","","",328,[[]]],[11,"from","","",328,[[]]],[11,"try_into","","",328,[[],["result",4]]],[11,"try_from","","",328,[[],["result",4]]],[11,"type_id","","",328,[[],["typeid",3]]],[11,"borrow","","",329,[[]]],[11,"borrow_mut","","",329,[[]]],[11,"into","","",329,[[]]],[11,"from","","",329,[[]]],[11,"try_into","","",329,[[],["result",4]]],[11,"try_from","","",329,[[],["result",4]]],[11,"type_id","","",329,[[],["typeid",3]]],[11,"borrow","","",168,[[]]],[11,"borrow_mut","","",168,[[]]],[11,"into","","",168,[[]]],[11,"from","","",168,[[]]],[11,"try_into","","",168,[[],["result",4]]],[11,"try_from","","",168,[[],["result",4]]],[11,"type_id","","",168,[[],["typeid",3]]],[11,"borrow","","",169,[[]]],[11,"borrow_mut","","",169,[[]]],[11,"into","","",169,[[]]],[11,"from","","",169,[[]]],[11,"try_into","","",169,[[],["result",4]]],[11,"try_from","","",169,[[],["result",4]]],[11,"type_id","","",169,[[],["typeid",3]]],[11,"borrow","","",170,[[]]],[11,"borrow_mut","","",170,[[]]],[11,"into","","",170,[[]]],[11,"from","","",170,[[]]],[11,"try_into","","",170,[[],["result",4]]],[11,"try_from","","",170,[[],["result",4]]],[11,"type_id","","",170,[[],["typeid",3]]],[11,"borrow","","",171,[[]]],[11,"borrow_mut","","",171,[[]]],[11,"into","","",171,[[]]],[11,"from","","",171,[[]]],[11,"try_into","","",171,[[],["result",4]]],[11,"try_from","","",171,[[],["result",4]]],[11,"type_id","","",171,[[],["typeid",3]]],[11,"borrow","","",172,[[]]],[11,"borrow_mut","","",172,[[]]],[11,"into","","",172,[[]]],[11,"from","","",172,[[]]],[11,"try_into","","",172,[[],["result",4]]],[11,"try_from","","",172,[[],["result",4]]],[11,"type_id","","",172,[[],["typeid",3]]],[11,"borrow","","",173,[[]]],[11,"borrow_mut","","",173,[[]]],[11,"into","","",173,[[]]],[11,"from","","",173,[[]]],[11,"try_into","","",173,[[],["result",4]]],[11,"try_from","","",173,[[],["result",4]]],[11,"type_id","","",173,[[],["typeid",3]]],[11,"borrow","","",174,[[]]],[11,"borrow_mut","","",174,[[]]],[11,"into","","",174,[[]]],[11,"from","","",174,[[]]],[11,"try_into","","",174,[[],["result",4]]],[11,"try_from","","",174,[[],["result",4]]],[11,"type_id","","",174,[[],["typeid",3]]],[11,"borrow","","",175,[[]]],[11,"borrow_mut","","",175,[[]]],[11,"into","","",175,[[]]],[11,"from","","",175,[[]]],[11,"try_into","","",175,[[],["result",4]]],[11,"try_from","","",175,[[],["result",4]]],[11,"type_id","","",175,[[],["typeid",3]]],[11,"borrow","","",176,[[]]],[11,"borrow_mut","","",176,[[]]],[11,"into","","",176,[[]]],[11,"from","","",176,[[]]],[11,"try_into","","",176,[[],["result",4]]],[11,"try_from","","",176,[[],["result",4]]],[11,"type_id","","",176,[[],["typeid",3]]],[11,"borrow","core::arch::wasm32","",330,[[]]],[11,"borrow_mut","","",330,[[]]],[11,"into","","",330,[[]]],[11,"from","","",330,[[]]],[11,"try_into","","",330,[[],["result",4]]],[11,"try_from","","",330,[[],["result",4]]],[11,"type_id","","",330,[[],["typeid",3]]],[11,"borrow","core::arch::powerpc","",331,[[]]],[11,"borrow_mut","","",331,[[]]],[11,"into","","",331,[[]]],[11,"from","","",331,[[]]],[11,"try_into","","",331,[[],["result",4]]],[11,"try_from","","",331,[[],["result",4]]],[11,"type_id","","",331,[[],["typeid",3]]],[11,"borrow","","",332,[[]]],[11,"borrow_mut","","",332,[[]]],[11,"into","","",332,[[]]],[11,"from","","",332,[[]]],[11,"try_into","","",332,[[],["result",4]]],[11,"try_from","","",332,[[],["result",4]]],[11,"type_id","","",332,[[],["typeid",3]]],[11,"borrow","","",333,[[]]],[11,"borrow_mut","","",333,[[]]],[11,"into","","",333,[[]]],[11,"from","","",333,[[]]],[11,"try_into","","",333,[[],["result",4]]],[11,"try_from","","",333,[[],["result",4]]],[11,"type_id","","",333,[[],["typeid",3]]],[11,"borrow","","",334,[[]]],[11,"borrow_mut","","",334,[[]]],[11,"into","","",334,[[]]],[11,"from","","",334,[[]]],[11,"try_into","","",334,[[],["result",4]]],[11,"try_from","","",334,[[],["result",4]]],[11,"type_id","","",334,[[],["typeid",3]]],[11,"clone","core::num","",3,[[],["nonzerou8",3]]],[11,"clone","","",4,[[],["nonzerou16",3]]],[11,"clone","","",5,[[],["nonzerou32",3]]],[11,"clone","","",6,[[],["nonzerou64",3]]],[11,"clone","","",7,[[],["nonzerou128",3]]],[11,"clone","","",8,[[],["nonzerousize",3]]],[11,"clone","","",9,[[],["nonzeroi8",3]]],[11,"clone","","",10,[[],["nonzeroi16",3]]],[11,"clone","","",11,[[],["nonzeroi32",3]]],[11,"clone","","",12,[[],["nonzeroi64",3]]],[11,"clone","","",13,[[],["nonzeroi128",3]]],[11,"clone","","",14,[[],["nonzeroisize",3]]],[11,"clone","","",0,[[],["wrapping",3]]],[11,"clone","","",187,[[],["parsefloaterror",3]]],[11,"clone","","",1,[[],["fpcategory",4]]],[11,"clone","","",186,[[],["tryfrominterror",3]]],[11,"clone","","",15,[[],["parseinterror",3]]],[11,"clone","","",2,[[],["interrorkind",4]]],[11,"clone","core::mem","",16,[[],["manuallydrop",3]]],[11,"clone","","",17,[[]]],[11,"clone","","",188,[[]]],[11,"clone","core::ptr","",18,[[]]],[11,"clone","core::cmp","",23,[[],["ordering",4]]],[11,"clone","","",22,[[],["reverse",3]]],[11,"clone","core::convert","",189,[[],["infallible",4]]],[11,"clone","core::marker","",190,[[]]],[11,"clone","","",191,[[],["phantompinned",3]]],[11,"clone","core::ops","",40,[[],["generatorstate",4]]],[11,"clone","","",192,[[],["rangefull",3]]],[11,"clone","","",35,[[],["range",3]]],[11,"clone","","",36,[[],["rangefrom",3]]],[11,"clone","","",37,[[],["rangeto",3]]],[11,"clone","","",41,[[],["rangeinclusive",3]]],[11,"clone","","",38,[[],["rangetoinclusive",3]]],[11,"clone","","",39,[[],["bound",4]]],[11,"clone","core::any","",76,[[],["typeid",3]]],[11,"clone","core::array","",77,[[]]],[11,"clone","","",193,[[],["tryfromsliceerror",3]]],[11,"clone","core::ascii","",194,[[],["escapedefault",3]]],[11,"clone","core::cell","",79,[[],["cell",3]]],[11,"clone","","Panics",80,[[],["refcell",3]]],[11,"clone","core::char","",198,[[],["parsecharerror",3]]],[11,"clone","","",197,[[],["chartryfromerror",3]]],[11,"clone","","",199,[[],["decodeutf16",3]]],[11,"clone","","",84,[[],["decodeutf16error",3]]],[11,"clone","","",200,[[],["escapeunicode",3]]],[11,"clone","","",201,[[],["escapedefault",3]]],[11,"clone","","",202,[[],["escapedebug",3]]],[11,"clone","","",203,[[],["tolowercase",3]]],[11,"clone","","",204,[[],["touppercase",3]]],[11,"clone","core::ffi","",85,[[]]],[11,"clone","core::iter","",219,[[],["chain",3]]],[11,"clone","","",227,[[]]],[11,"clone","","",216,[[]]],[11,"clone","","",233,[[],["fuse",3]]],[11,"clone","","",226,[[],["zip",3]]],[11,"clone","","",225,[[],["rev",3]]],[11,"clone","","",215,[[],["copied",3]]],[11,"clone","","",214,[[],["cloned",3]]],[11,"clone","","",220,[[],["cycle",3]]],[11,"clone","","",218,[[],["stepby",3]]],[11,"clone","","",224,[[],["map",3]]],[11,"clone","","",222,[[],["filter",3]]],[11,"clone","","",223,[[],["filtermap",3]]],[11,"clone","","",221,[[],["enumerate",3]]],[11,"clone","","",86,[[],["peekable",3]]],[11,"clone","","",230,[[],["skipwhile",3]]],[11,"clone","","",232,[[],["takewhile",3]]],[11,"clone","","",217,[[],["mapwhile",3]]],[11,"clone","","",229,[[],["skip",3]]],[11,"clone","","",231,[[],["take",3]]],[11,"clone","","",228,[[],["scan",3]]],[11,"clone","","",234,[[],["inspect",3]]],[11,"clone","","",211,[[],["repeat",3]]],[11,"clone","","",212,[[],["repeatwith",3]]],[11,"clone","","",207,[[],["empty",3]]],[11,"clone","","",209,[[],["once",3]]],[11,"clone","","",210,[[],["oncewith",3]]],[11,"clone","","",208,[[],["fromfn",3]]],[11,"clone","","",213,[[],["successors",3]]],[11,"clone","core::option","",96,[[]]],[11,"clone_from","","",96,[[]]],[11,"clone","","",235,[[]]],[11,"clone","","",237,[[],["intoiter",3]]],[11,"clone","","",238,[[],["noneerror",3]]],[11,"clone","core::pin","",99,[[],["pin",3]]],[11,"clone","core::raw","",100,[[],["traitobject",3]]],[11,"clone","core::result","",101,[[]]],[11,"clone_from","","",101,[[]]],[11,"clone","","",239,[[]]],[11,"clone","","",241,[[],["intoiter",3]]],[11,"clone","core::sync::atomic","",102,[[],["ordering",4]]],[11,"clone","core::fmt","",242,[[],["error",3]]],[11,"clone","","",243,[[],["arguments",3]]],[11,"clone","core::hash","",132,[[],["siphasher",3]]],[11,"clone","","",244,[[],["buildhasherdefault",3]]],[11,"clone","core::slice","",137,[[]]],[11,"clone","","",245,[[]]],[11,"clone","","",246,[[]]],[11,"clone","","",249,[[],["rsplit",3]]],[11,"clone","","",255,[[]]],[11,"clone","","",256,[[]]],[11,"clone","","",139,[[]]],[11,"clone","","",258,[[]]],[11,"clone","","",141,[[],["rchunksexact",3]]],[11,"clone","core::str::pattern","",143,[[],["searchstep",4]]],[11,"clone","","",281,[[],["charsearcher",3]]],[11,"clone","","",282,[[],["charslicesearcher",3]]],[11,"clone","","",283,[[],["charpredicatesearcher",3]]],[11,"clone","","",284,[[],["strsearcher",3]]],[11,"clone","core::str","",260,[[],["parseboolerror",3]]],[11,"clone","","",150,[[],["utf8error",3]]],[11,"clone","","",151,[[],["chars",3]]],[11,"clone","","",152,[[],["charindices",3]]],[11,"clone","","",261,[[],["bytes",3]]],[11,"clone","","",262,[[]]],[11,"clone","","",263,[[]]],[11,"clone","","",264,[[]]],[11,"clone","","",265,[[]]],[11,"clone","","",266,[[]]],[11,"clone","","",267,[[]]],[11,"clone","","",268,[[]]],[11,"clone","","",269,[[]]],[11,"clone","","",270,[[]]],[11,"clone","","",271,[[]]],[11,"clone","","",272,[[],["lines",3]]],[11,"clone","","",273,[[],["linesany",3]]],[11,"clone","","",274,[[],["splitwhitespace",3]]],[11,"clone","","",275,[[],["splitasciiwhitespace",3]]],[11,"clone","","",276,[[]]],[11,"clone","","",277,[[],["encodeutf16",3]]],[11,"clone","","",278,[[],["escapedebug",3]]],[11,"clone","","",279,[[],["escapedefault",3]]],[11,"clone","","",280,[[],["escapeunicode",3]]],[11,"clone","core::time","",153,[[],["duration",3]]],[11,"clone","core::future","",286,[[]]],[11,"clone","","",287,[[],["ready",3]]],[11,"clone","core::task","",156,[[],["poll",4]]],[11,"clone","","",158,[[],["rawwakervtable",3]]],[11,"clone","","",160,[[]]],[11,"clone","core::alloc","",164,[[],["layout",3]]],[11,"clone","","",288,[[],["layouterr",3]]],[11,"clone","","",289,[[],["allocerr",3]]],[11,"clone","","",162,[[],["allocinit",4]]],[11,"clone","","",161,[[],["memoryblock",3]]],[11,"clone","","",163,[[],["reallocplacement",4]]],[11,"clone","core::arch::x86","",292,[[],["__m64",3]]],[11,"clone","","",293,[[],["__m128i",3]]],[11,"clone","","",294,[[],["__m128",3]]],[11,"clone","","",295,[[],["__m128d",3]]],[11,"clone","","",296,[[],["__m256i",3]]],[11,"clone","","",297,[[],["__m256",3]]],[11,"clone","","",298,[[],["__m256d",3]]],[11,"clone","","",299,[[],["__m512i",3]]],[11,"clone","","",300,[[],["__m512",3]]],[11,"clone","","",301,[[],["__m512d",3]]],[11,"clone","","",167,[[],["cpuidresult",3]]],[11,"clone","core::arch::aarch64","",302,[[],["float64x1_t",3]]],[11,"clone","","",303,[[],["float64x2_t",3]]],[11,"clone","","",304,[[],["poly64x1_t",3]]],[11,"clone","","",305,[[],["poly64_t",3]]],[11,"clone","","",306,[[],["poly64x2_t",3]]],[11,"clone","","",307,[[],["poly128_t",3]]],[11,"clone","","",177,[[],["int8x16x2_t",3]]],[11,"clone","","",178,[[],["int8x16x3_t",3]]],[11,"clone","","",179,[[],["int8x16x4_t",3]]],[11,"clone","","",180,[[],["uint8x16x2_t",3]]],[11,"clone","","",181,[[],["uint8x16x3_t",3]]],[11,"clone","","",182,[[],["uint8x16x4_t",3]]],[11,"clone","","",183,[[],["poly8x16x2_t",3]]],[11,"clone","","",184,[[],["poly8x16x3_t",3]]],[11,"clone","","",185,[[],["poly8x16x4_t",3]]],[11,"clone","core::arch::arm","",308,[[],["int8x8_t",3]]],[11,"clone","","",309,[[],["uint8x8_t",3]]],[11,"clone","","",310,[[],["poly8x8_t",3]]],[11,"clone","","",311,[[],["int16x4_t",3]]],[11,"clone","","",312,[[],["uint16x4_t",3]]],[11,"clone","","",313,[[],["poly16x4_t",3]]],[11,"clone","","",314,[[],["int32x2_t",3]]],[11,"clone","","",315,[[],["uint32x2_t",3]]],[11,"clone","","",316,[[],["float32x2_t",3]]],[11,"clone","","",317,[[],["int64x1_t",3]]],[11,"clone","","",318,[[],["uint64x1_t",3]]],[11,"clone","","",319,[[],["int8x16_t",3]]],[11,"clone","","",320,[[],["uint8x16_t",3]]],[11,"clone","","",321,[[],["poly8x16_t",3]]],[11,"clone","","",322,[[],["int16x8_t",3]]],[11,"clone","","",323,[[],["uint16x8_t",3]]],[11,"clone","","",324,[[],["poly16x8_t",3]]],[11,"clone","","",325,[[],["int32x4_t",3]]],[11,"clone","","",326,[[],["uint32x4_t",3]]],[11,"clone","","",327,[[],["float32x4_t",3]]],[11,"clone","","",328,[[],["int64x2_t",3]]],[11,"clone","","",329,[[],["uint64x2_t",3]]],[11,"clone","","",168,[[],["int8x8x2_t",3]]],[11,"clone","","",169,[[],["int8x8x3_t",3]]],[11,"clone","","",170,[[],["int8x8x4_t",3]]],[11,"clone","","",171,[[],["uint8x8x2_t",3]]],[11,"clone","","",172,[[],["uint8x8x3_t",3]]],[11,"clone","","",173,[[],["uint8x8x4_t",3]]],[11,"clone","","",174,[[],["poly8x8x2_t",3]]],[11,"clone","","",175,[[],["poly8x8x3_t",3]]],[11,"clone","","",176,[[],["poly8x8x4_t",3]]],[11,"clone","core::arch::wasm32","",330,[[],["v128",3]]],[11,"clone","core::arch::powerpc","",331,[[],["vector_signed_long",3]]],[11,"clone","","",332,[[],["vector_unsigned_long",3]]],[11,"clone","","",333,[[],["vector_bool_long",3]]],[11,"clone","","",334,[[],["vector_double",3]]],[11,"eq","core::num","",3,[[["nonzerou8",3]]]],[11,"ne","","",3,[[["nonzerou8",3]]]],[11,"eq","","",4,[[["nonzerou16",3]]]],[11,"ne","","",4,[[["nonzerou16",3]]]],[11,"eq","","",5,[[["nonzerou32",3]]]],[11,"ne","","",5,[[["nonzerou32",3]]]],[11,"eq","","",6,[[["nonzerou64",3]]]],[11,"ne","","",6,[[["nonzerou64",3]]]],[11,"eq","","",7,[[["nonzerou128",3]]]],[11,"ne","","",7,[[["nonzerou128",3]]]],[11,"eq","","",8,[[["nonzerousize",3]]]],[11,"ne","","",8,[[["nonzerousize",3]]]],[11,"eq","","",9,[[["nonzeroi8",3]]]],[11,"ne","","",9,[[["nonzeroi8",3]]]],[11,"eq","","",10,[[["nonzeroi16",3]]]],[11,"ne","","",10,[[["nonzeroi16",3]]]],[11,"eq","","",11,[[["nonzeroi32",3]]]],[11,"ne","","",11,[[["nonzeroi32",3]]]],[11,"eq","","",12,[[["nonzeroi64",3]]]],[11,"ne","","",12,[[["nonzeroi64",3]]]],[11,"eq","","",13,[[["nonzeroi128",3]]]],[11,"ne","","",13,[[["nonzeroi128",3]]]],[11,"eq","","",14,[[["nonzeroisize",3]]]],[11,"ne","","",14,[[["nonzeroisize",3]]]],[11,"eq","","",0,[[["wrapping",3]]]],[11,"ne","","",0,[[["wrapping",3]]]],[11,"eq","","",187,[[["parsefloaterror",3]]]],[11,"ne","","",187,[[["parsefloaterror",3]]]],[11,"eq","","",1,[[["fpcategory",4]]]],[11,"eq","","",186,[[["tryfrominterror",3]]]],[11,"ne","","",186,[[["tryfrominterror",3]]]],[11,"eq","","",15,[[["parseinterror",3]]]],[11,"ne","","",15,[[["parseinterror",3]]]],[11,"eq","","",2,[[["interrorkind",4]]]],[11,"eq","core::mem","",16,[[["manuallydrop",3]]]],[11,"ne","","",16,[[["manuallydrop",3]]]],[11,"eq","","",188,[[]]],[11,"eq","core::ptr","",18,[[]]],[11,"eq","core::cmp","",23,[[["ordering",4]]]],[11,"eq","","",22,[[["reverse",3]]]],[11,"ne","","",22,[[["reverse",3]]]],[11,"eq","core::convert","",189,[[["infallible",4]]]],[11,"eq","core::marker","",190,[[["phantomdata",3]]]],[11,"eq","","",191,[[["phantompinned",3]]]],[11,"eq","core::ops","",40,[[["generatorstate",4]]]],[11,"ne","","",40,[[["generatorstate",4]]]],[11,"eq","","",192,[[["rangefull",3]]]],[11,"eq","","",35,[[["range",3]]]],[11,"ne","","",35,[[["range",3]]]],[11,"eq","","",36,[[["rangefrom",3]]]],[11,"ne","","",36,[[["rangefrom",3]]]],[11,"eq","","",37,[[["rangeto",3]]]],[11,"ne","","",37,[[["rangeto",3]]]],[11,"eq","","",41,[[["rangeinclusive",3]]]],[11,"ne","","",41,[[["rangeinclusive",3]]]],[11,"eq","","",38,[[["rangetoinclusive",3]]]],[11,"ne","","",38,[[["rangetoinclusive",3]]]],[11,"eq","","",39,[[["bound",4]]]],[11,"ne","","",39,[[["bound",4]]]],[11,"eq","core::any","",76,[[["typeid",3]]]],[11,"ne","","",76,[[["typeid",3]]]],[11,"eq","core::cell","",79,[[["cell",3]]]],[11,"eq","","Panics",80,[[["refcell",3]]]],[11,"eq","core::char","",198,[[["parsecharerror",3]]]],[11,"ne","","",198,[[["parsecharerror",3]]]],[11,"eq","","",197,[[["chartryfromerror",3]]]],[11,"ne","","",197,[[["chartryfromerror",3]]]],[11,"eq","","",84,[[["decodeutf16error",3]]]],[11,"ne","","",84,[[["decodeutf16error",3]]]],[11,"eq","core::option","",96,[[["option",4]]]],[11,"ne","","",96,[[["option",4]]]],[11,"eq","","",238,[[["noneerror",3]]]],[11,"eq","core::pin","",99,[[["pin",3]]]],[11,"ne","","",99,[[["pin",3]]]],[11,"eq","core::result","",101,[[["result",4]]]],[11,"ne","","",101,[[["result",4]]]],[11,"eq","core::sync::atomic","",102,[[["ordering",4]]]],[11,"eq","core::fmt","",242,[[["error",3]]]],[11,"eq","core::hash","",244,[[["buildhasherdefault",3]]]],[11,"eq","core::str::pattern","",143,[[["searchstep",4]]]],[11,"ne","","",143,[[["searchstep",4]]]],[11,"eq","core::str::lossy","",147,[[["utf8lossychunk",3]]]],[11,"ne","","",147,[[["utf8lossychunk",3]]]],[11,"eq","core::str","",260,[[["parseboolerror",3]]]],[11,"ne","","",260,[[["parseboolerror",3]]]],[11,"eq","","",150,[[["utf8error",3]]]],[11,"ne","","",150,[[["utf8error",3]]]],[11,"eq","core::time","",153,[[["duration",3]]]],[11,"ne","","",153,[[["duration",3]]]],[11,"eq","core::task","",156,[[["poll",4]]]],[11,"ne","","",156,[[["poll",4]]]],[11,"eq","","",157,[[["rawwaker",3]]]],[11,"ne","","",157,[[["rawwaker",3]]]],[11,"eq","","",158,[[["rawwakervtable",3]]]],[11,"ne","","",158,[[["rawwakervtable",3]]]],[11,"eq","core::alloc","",164,[[["layout",3]]]],[11,"ne","","",164,[[["layout",3]]]],[11,"eq","","",288,[[["layouterr",3]]]],[11,"ne","","",288,[[["layouterr",3]]]],[11,"eq","","",289,[[["allocerr",3]]]],[11,"eq","","",162,[[["allocinit",4]]]],[11,"eq","","",163,[[["reallocplacement",4]]]],[11,"eq","core::arch::x86","",167,[[["cpuidresult",3]]]],[11,"ne","","",167,[[["cpuidresult",3]]]],[11,"cmp","core::num","",3,[[["nonzerou8",3]],["ordering",4]]],[11,"cmp","","",4,[[["nonzerou16",3]],["ordering",4]]],[11,"cmp","","",5,[[["nonzerou32",3]],["ordering",4]]],[11,"cmp","","",6,[[["nonzerou64",3]],["ordering",4]]],[11,"cmp","","",7,[[["nonzerou128",3]],["ordering",4]]],[11,"cmp","","",8,[[["nonzerousize",3]],["ordering",4]]],[11,"cmp","","",9,[[["nonzeroi8",3]],["ordering",4]]],[11,"cmp","","",10,[[["nonzeroi16",3]],["ordering",4]]],[11,"cmp","","",11,[[["nonzeroi32",3]],["ordering",4]]],[11,"cmp","","",12,[[["nonzeroi64",3]],["ordering",4]]],[11,"cmp","","",13,[[["nonzeroi128",3]],["ordering",4]]],[11,"cmp","","",14,[[["nonzeroisize",3]],["ordering",4]]],[11,"cmp","","",0,[[["wrapping",3]],["ordering",4]]],[11,"cmp","core::mem","",16,[[["manuallydrop",3]],["ordering",4]]],[11,"cmp","core::ptr","",18,[[],["ordering",4]]],[11,"cmp","core::cmp","",22,[[["reverse",3]],["ordering",4]]],[11,"cmp","","",23,[[["ordering",4]],["ordering",4]]],[11,"cmp","core::convert","",189,[[],["ordering",4]]],[11,"cmp","core::marker","",190,[[["phantomdata",3]],["ordering",4]]],[11,"cmp","","",191,[[["phantompinned",3]],["ordering",4]]],[11,"cmp","core::ops","",40,[[["generatorstate",4]],["ordering",4]]],[11,"cmp","core::any","",76,[[["typeid",3]],["ordering",4]]],[11,"cmp","core::cell","",79,[[["cell",3]],["ordering",4]]],[11,"cmp","","Panics",80,[[["refcell",3]],["ordering",4]]],[11,"cmp","core::option","",96,[[["option",4]],["ordering",4]]],[11,"cmp","","",238,[[["noneerror",3]],["ordering",4]]],[11,"cmp","core::pin","",99,[[],["ordering",4]]],[11,"cmp","core::result","",101,[[["result",4]],["ordering",4]]],[11,"cmp","core::fmt","",242,[[["error",3]],["ordering",4]]],[11,"cmp","core::time","",153,[[["duration",3]],["ordering",4]]],[11,"cmp","core::task","",156,[[["poll",4]],["ordering",4]]],[11,"cmp","core::arch::x86","",167,[[["cpuidresult",3]],["ordering",4]]],[11,"partial_cmp","core::num","",3,[[["nonzerou8",3]],[["option",4],["ordering",4]]]],[11,"lt","","",3,[[["nonzerou8",3]]]],[11,"le","","",3,[[["nonzerou8",3]]]],[11,"gt","","",3,[[["nonzerou8",3]]]],[11,"ge","","",3,[[["nonzerou8",3]]]],[11,"partial_cmp","","",4,[[["nonzerou16",3]],[["option",4],["ordering",4]]]],[11,"lt","","",4,[[["nonzerou16",3]]]],[11,"le","","",4,[[["nonzerou16",3]]]],[11,"gt","","",4,[[["nonzerou16",3]]]],[11,"ge","","",4,[[["nonzerou16",3]]]],[11,"partial_cmp","","",5,[[["nonzerou32",3]],[["option",4],["ordering",4]]]],[11,"lt","","",5,[[["nonzerou32",3]]]],[11,"le","","",5,[[["nonzerou32",3]]]],[11,"gt","","",5,[[["nonzerou32",3]]]],[11,"ge","","",5,[[["nonzerou32",3]]]],[11,"partial_cmp","","",6,[[["nonzerou64",3]],[["option",4],["ordering",4]]]],[11,"lt","","",6,[[["nonzerou64",3]]]],[11,"le","","",6,[[["nonzerou64",3]]]],[11,"gt","","",6,[[["nonzerou64",3]]]],[11,"ge","","",6,[[["nonzerou64",3]]]],[11,"partial_cmp","","",7,[[["nonzerou128",3]],[["option",4],["ordering",4]]]],[11,"lt","","",7,[[["nonzerou128",3]]]],[11,"le","","",7,[[["nonzerou128",3]]]],[11,"gt","","",7,[[["nonzerou128",3]]]],[11,"ge","","",7,[[["nonzerou128",3]]]],[11,"partial_cmp","","",8,[[["nonzerousize",3]],[["option",4],["ordering",4]]]],[11,"lt","","",8,[[["nonzerousize",3]]]],[11,"le","","",8,[[["nonzerousize",3]]]],[11,"gt","","",8,[[["nonzerousize",3]]]],[11,"ge","","",8,[[["nonzerousize",3]]]],[11,"partial_cmp","","",9,[[["nonzeroi8",3]],[["option",4],["ordering",4]]]],[11,"lt","","",9,[[["nonzeroi8",3]]]],[11,"le","","",9,[[["nonzeroi8",3]]]],[11,"gt","","",9,[[["nonzeroi8",3]]]],[11,"ge","","",9,[[["nonzeroi8",3]]]],[11,"partial_cmp","","",10,[[["nonzeroi16",3]],[["option",4],["ordering",4]]]],[11,"lt","","",10,[[["nonzeroi16",3]]]],[11,"le","","",10,[[["nonzeroi16",3]]]],[11,"gt","","",10,[[["nonzeroi16",3]]]],[11,"ge","","",10,[[["nonzeroi16",3]]]],[11,"partial_cmp","","",11,[[["nonzeroi32",3]],[["option",4],["ordering",4]]]],[11,"lt","","",11,[[["nonzeroi32",3]]]],[11,"le","","",11,[[["nonzeroi32",3]]]],[11,"gt","","",11,[[["nonzeroi32",3]]]],[11,"ge","","",11,[[["nonzeroi32",3]]]],[11,"partial_cmp","","",12,[[["nonzeroi64",3]],[["option",4],["ordering",4]]]],[11,"lt","","",12,[[["nonzeroi64",3]]]],[11,"le","","",12,[[["nonzeroi64",3]]]],[11,"gt","","",12,[[["nonzeroi64",3]]]],[11,"ge","","",12,[[["nonzeroi64",3]]]],[11,"partial_cmp","","",13,[[["nonzeroi128",3]],[["option",4],["ordering",4]]]],[11,"lt","","",13,[[["nonzeroi128",3]]]],[11,"le","","",13,[[["nonzeroi128",3]]]],[11,"gt","","",13,[[["nonzeroi128",3]]]],[11,"ge","","",13,[[["nonzeroi128",3]]]],[11,"partial_cmp","","",14,[[["nonzeroisize",3]],[["option",4],["ordering",4]]]],[11,"lt","","",14,[[["nonzeroisize",3]]]],[11,"le","","",14,[[["nonzeroisize",3]]]],[11,"gt","","",14,[[["nonzeroisize",3]]]],[11,"ge","","",14,[[["nonzeroisize",3]]]],[11,"partial_cmp","","",0,[[["wrapping",3]],[["option",4],["ordering",4]]]],[11,"lt","","",0,[[["wrapping",3]]]],[11,"le","","",0,[[["wrapping",3]]]],[11,"gt","","",0,[[["wrapping",3]]]],[11,"ge","","",0,[[["wrapping",3]]]],[11,"partial_cmp","core::mem","",16,[[["manuallydrop",3]],[["option",4],["ordering",4]]]],[11,"lt","","",16,[[["manuallydrop",3]]]],[11,"le","","",16,[[["manuallydrop",3]]]],[11,"gt","","",16,[[["manuallydrop",3]]]],[11,"ge","","",16,[[["manuallydrop",3]]]],[11,"partial_cmp","core::ptr","",18,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp","core::cmp","",22,[[["reverse",3]],[["ordering",4],["option",4]]]],[11,"lt","","",22,[[]]],[11,"le","","",22,[[]]],[11,"gt","","",22,[[]]],[11,"ge","","",22,[[]]],[11,"partial_cmp","","",23,[[["ordering",4]],[["ordering",4],["option",4]]]],[11,"partial_cmp","core::convert","",189,[[],[["option",4],["ordering",4]]]],[11,"partial_cmp","core::marker","",190,[[["phantomdata",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","","",191,[[["phantompinned",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","core::ops","",40,[[["generatorstate",4]],[["option",4],["ordering",4]]]],[11,"lt","","",40,[[["generatorstate",4]]]],[11,"le","","",40,[[["generatorstate",4]]]],[11,"gt","","",40,[[["generatorstate",4]]]],[11,"ge","","",40,[[["generatorstate",4]]]],[11,"partial_cmp","core::any","",76,[[["typeid",3]],[["option",4],["ordering",4]]]],[11,"lt","","",76,[[["typeid",3]]]],[11,"le","","",76,[[["typeid",3]]]],[11,"gt","","",76,[[["typeid",3]]]],[11,"ge","","",76,[[["typeid",3]]]],[11,"partial_cmp","core::cell","",79,[[["cell",3]],[["ordering",4],["option",4]]]],[11,"lt","","",79,[[["cell",3]]]],[11,"le","","",79,[[["cell",3]]]],[11,"gt","","",79,[[["cell",3]]]],[11,"ge","","",79,[[["cell",3]]]],[11,"partial_cmp","","Panics",80,[[["refcell",3]],[["ordering",4],["option",4]]]],[11,"lt","","Panics",80,[[["refcell",3]]]],[11,"le","","Panics",80,[[["refcell",3]]]],[11,"gt","","Panics",80,[[["refcell",3]]]],[11,"ge","","Panics",80,[[["refcell",3]]]],[11,"partial_cmp","core::option","",96,[[["option",4]],[["option",4],["ordering",4]]]],[11,"lt","","",96,[[["option",4]]]],[11,"le","","",96,[[["option",4]]]],[11,"gt","","",96,[[["option",4]]]],[11,"ge","","",96,[[["option",4]]]],[11,"partial_cmp","","",238,[[["noneerror",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","core::pin","",99,[[["pin",3]],[["option",4],["ordering",4]]]],[11,"lt","","",99,[[["pin",3]]]],[11,"le","","",99,[[["pin",3]]]],[11,"gt","","",99,[[["pin",3]]]],[11,"ge","","",99,[[["pin",3]]]],[11,"partial_cmp","core::result","",101,[[["result",4]],[["option",4],["ordering",4]]]],[11,"lt","","",101,[[["result",4]]]],[11,"le","","",101,[[["result",4]]]],[11,"gt","","",101,[[["result",4]]]],[11,"ge","","",101,[[["result",4]]]],[11,"partial_cmp","core::fmt","",242,[[["error",3]],[["option",4],["ordering",4]]]],[11,"partial_cmp","core::time","",153,[[["duration",3]],[["option",4],["ordering",4]]]],[11,"lt","","",153,[[["duration",3]]]],[11,"le","","",153,[[["duration",3]]]],[11,"gt","","",153,[[["duration",3]]]],[11,"ge","","",153,[[["duration",3]]]],[11,"partial_cmp","core::task","",156,[[["poll",4]],[["option",4],["ordering",4]]]],[11,"lt","","",156,[[["poll",4]]]],[11,"le","","",156,[[["poll",4]]]],[11,"gt","","",156,[[["poll",4]]]],[11,"ge","","",156,[[["poll",4]]]],[11,"partial_cmp","core::arch::x86","",167,[[["cpuidresult",3]],[["option",4],["ordering",4]]]],[11,"lt","","",167,[[["cpuidresult",3]]]],[11,"le","","",167,[[["cpuidresult",3]]]],[11,"gt","","",167,[[["cpuidresult",3]]]],[11,"ge","","",167,[[["cpuidresult",3]]]],[11,"as_ref","core::slice","",137,[[]]],[11,"from","core::num","",186,[[["infallible",4]],["tryfrominterror",3]]],[11,"from","","",186,[[],["tryfrominterror",3]]],[11,"from","core::ptr","",18,[[]]],[11,"from","","",18,[[]]],[11,"from","core::num","",4,[[["nonzerou8",3]]]],[11,"from","","",5,[[["nonzerou8",3]]]],[11,"from","","",6,[[["nonzerou8",3]]]],[11,"from","","",7,[[["nonzerou8",3]]]],[11,"from","","",8,[[["nonzerou8",3]]]],[11,"from","","",5,[[["nonzerou16",3]]]],[11,"from","","",6,[[["nonzerou16",3]]]],[11,"from","","",7,[[["nonzerou16",3]]]],[11,"from","","",8,[[["nonzerou16",3]]]],[11,"from","","",6,[[["nonzerou32",3]]]],[11,"from","","",7,[[["nonzerou32",3]]]],[11,"from","","",7,[[["nonzerou64",3]]]],[11,"from","","",10,[[["nonzeroi8",3]]]],[11,"from","","",11,[[["nonzeroi8",3]]]],[11,"from","","",12,[[["nonzeroi8",3]]]],[11,"from","","",13,[[["nonzeroi8",3]]]],[11,"from","","",14,[[["nonzeroi8",3]]]],[11,"from","","",11,[[["nonzeroi16",3]]]],[11,"from","","",12,[[["nonzeroi16",3]]]],[11,"from","","",13,[[["nonzeroi16",3]]]],[11,"from","","",14,[[["nonzeroi16",3]]]],[11,"from","","",12,[[["nonzeroi32",3]]]],[11,"from","","",13,[[["nonzeroi32",3]]]],[11,"from","","",13,[[["nonzeroi64",3]]]],[11,"from","","",10,[[["nonzerou8",3]]]],[11,"from","","",11,[[["nonzerou8",3]]]],[11,"from","","",12,[[["nonzerou8",3]]]],[11,"from","","",13,[[["nonzerou8",3]]]],[11,"from","","",14,[[["nonzerou8",3]]]],[11,"from","","",11,[[["nonzerou16",3]]]],[11,"from","","",12,[[["nonzerou16",3]]]],[11,"from","","",13,[[["nonzerou16",3]]]],[11,"from","","",12,[[["nonzerou32",3]]]],[11,"from","","",13,[[["nonzerou32",3]]]],[11,"from","","",13,[[["nonzerou64",3]]]],[11,"from","core::convert","",189,[[]]],[11,"from","core::array","",193,[[["infallible",4]],["tryfromsliceerror",3]]],[11,"from","core::cell","",79,[[],["cell",3]]],[11,"from","","",80,[[],["refcell",3]]],[11,"from","","",83,[[],["unsafecell",3]]],[11,"from","core::option","Copies `val` into a new `Some`.",96,[[],["option",4]]],[11,"from","","Converts from `&Option<T>` to `Option<&T>`.",96,[[["option",4]],["option",4]]],[11,"from","","Converts from `&mut Option<T>` to `Option<&mut T>`",96,[[["option",4]],["option",4]]],[11,"from","core::sync::atomic","Converts a `bool` into an `AtomicBool`.",103,[[]]],[11,"from","","",104,[[]]],[11,"from","","Converts an `i8` into an `AtomicI8`.",105,[[]]],[11,"from","","Converts an `u8` into an `AtomicU8`.",106,[[]]],[11,"from","","Converts an `i16` into an `AtomicI16`.",107,[[]]],[11,"from","","Converts an `u16` into an `AtomicU16`.",108,[[]]],[11,"from","","Converts an `i32` into an `AtomicI32`.",109,[[]]],[11,"from","","Converts an `u32` into an `AtomicU32`.",110,[[]]],[11,"from","","Converts an `i64` into an `AtomicI64`.",111,[[]]],[11,"from","","Converts an `u64` into an `AtomicU64`.",112,[[]]],[11,"from","","Converts an `isize` into an `AtomicIsize`.",113,[[]]],[11,"from","","Converts an `usize` into an `AtomicUsize`.",114,[[]]],[11,"from","core::task","",156,[[],["poll",4]]],[11,"default","core::num","",0,[[],["wrapping",3]]],[11,"default","core::mem","",16,[[],["manuallydrop",3]]],[11,"default","core::cmp","",22,[[],["reverse",3]]],[11,"default","core::marker","",190,[[]]],[11,"default","core::cell","Creates a `Cell<T>`, with the `Default` value for T.",79,[[],["cell",3]]],[11,"default","","Creates a `RefCell<T>`, with the `Default` value for T.",80,[[],["refcell",3]]],[11,"default","","Creates an `UnsafeCell`, with the `Default` value for T.",83,[[],["unsafecell",3]]],[11,"default","core::iter","",207,[[],["empty",3]]],[11,"default","core::option","Returns [`None`][Option::None].",96,[[],["option",4]]],[11,"default","core::sync::atomic","Creates an `AtomicBool` initialized to `false`.",103,[[]]],[11,"default","","Creates a null `AtomicPtr<T>`.",104,[[],["atomicptr",3]]],[11,"default","","",105,[[]]],[11,"default","","",106,[[]]],[11,"default","","",107,[[]]],[11,"default","","",108,[[]]],[11,"default","","",109,[[]]],[11,"default","","",110,[[]]],[11,"default","","",111,[[]]],[11,"default","","",112,[[]]],[11,"default","","",113,[[]]],[11,"default","","",114,[[]]],[11,"default","core::fmt","",242,[[],["error",3]]],[11,"default","core::hash","",132,[[],["siphasher",3]]],[11,"default","","",244,[[],["buildhasherdefault",3]]],[11,"default","core::time","",153,[[],["duration",3]]],[11,"add","core::num","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"add","","",0,[[["wrapping",3]]]],[11,"add","core::time","",153,[[["duration",3]],["duration",3]]],[11,"sub","core::num","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"sub","","",0,[[["wrapping",3]]]],[11,"sub","core::time","",153,[[["duration",3]],["duration",3]]],[11,"mul","core::num","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"mul","","",0,[[["wrapping",3]]]],[11,"mul","core::time","",153,[[],["duration",3]]],[11,"div","core::num","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"div","","",0,[[["wrapping",3]]]],[11,"div","core::time","",153,[[],["duration",3]]],[11,"rem","core::num","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"rem","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"rem","","",0,[[["wrapping",3]]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"neg","","",0,[[]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","","",0,[[["wrapping",3]]]],[11,"add_assign","core::time","",153,[[["duration",3]]]],[11,"sub_assign","core::num","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","","",0,[[["wrapping",3]]]],[11,"sub_assign","core::time","",153,[[["duration",3]]]],[11,"mul_assign","core::num","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","","",0,[[["wrapping",3]]]],[11,"mul_assign","core::time","",153,[[]]],[11,"div_assign","core::num","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","","",0,[[["wrapping",3]]]],[11,"div_assign","core::time","",153,[[]]],[11,"rem_assign","core::num","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"rem_assign","","",0,[[["wrapping",3]]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"not","","",0,[[],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitand","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitand","","",0,[[["wrapping",3]]]],[11,"bitor","","",3,[[]]],[11,"bitor","","",3,[[]]],[11,"bitor","","",4,[[]]],[11,"bitor","","",4,[[]]],[11,"bitor","","",5,[[]]],[11,"bitor","","",5,[[]]],[11,"bitor","","",6,[[]]],[11,"bitor","","",6,[[]]],[11,"bitor","","",7,[[]]],[11,"bitor","","",7,[[]]],[11,"bitor","","",8,[[]]],[11,"bitor","","",8,[[]]],[11,"bitor","","",9,[[]]],[11,"bitor","","",9,[[]]],[11,"bitor","","",10,[[]]],[11,"bitor","","",10,[[]]],[11,"bitor","","",11,[[]]],[11,"bitor","","",11,[[]]],[11,"bitor","","",12,[[]]],[11,"bitor","","",12,[[]]],[11,"bitor","","",13,[[]]],[11,"bitor","","",13,[[]]],[11,"bitor","","",14,[[]]],[11,"bitor","","",14,[[]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"bitxor","","",0,[[["wrapping",3]],["wrapping",3]]],[11,"bitxor","","",0,[[["wrapping",3]]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shl","","",0,[[],["wrapping",3]]],[11,"shl","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"shr","","",0,[[],["wrapping",3]]],[11,"shr","","",0,[[]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitand_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",3,[[]]],[11,"bitor_assign","","",3,[[]]],[11,"bitor_assign","","",4,[[]]],[11,"bitor_assign","","",4,[[]]],[11,"bitor_assign","","",5,[[]]],[11,"bitor_assign","","",5,[[]]],[11,"bitor_assign","","",6,[[]]],[11,"bitor_assign","","",6,[[]]],[11,"bitor_assign","","",7,[[]]],[11,"bitor_assign","","",7,[[]]],[11,"bitor_assign","","",8,[[]]],[11,"bitor_assign","","",8,[[]]],[11,"bitor_assign","","",9,[[]]],[11,"bitor_assign","","",9,[[]]],[11,"bitor_assign","","",10,[[]]],[11,"bitor_assign","","",10,[[]]],[11,"bitor_assign","","",11,[[]]],[11,"bitor_assign","","",11,[[]]],[11,"bitor_assign","","",12,[[]]],[11,"bitor_assign","","",12,[[]]],[11,"bitor_assign","","",13,[[]]],[11,"bitor_assign","","",13,[[]]],[11,"bitor_assign","","",14,[[]]],[11,"bitor_assign","","",14,[[]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"bitxor_assign","","",0,[[["wrapping",3]]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shl_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"shr_assign","","",0,[[]]],[11,"deref","core::mem","",16,[[]]],[11,"deref","core::cell","",81,[[]]],[11,"deref","","",82,[[]]],[11,"deref","core::ffi","",205,[[],["valistimpl",3]]],[11,"deref","core::pin","",99,[[]]],[11,"deref_mut","core::mem","",16,[[]]],[11,"deref_mut","core::cell","",82,[[]]],[11,"deref_mut","core::ffi","",205,[[],["valistimpl",3]]],[11,"deref_mut","core::pin","",99,[[]]],[11,"drop","core::array","",77,[[]]],[11,"drop","core::ffi","",85,[[]]],[11,"drop","core::task","",160,[[]]],[11,"resume","core::pin","",99,[[["pin",3]],["generatorstate",4]]],[11,"start_bound","core::ops","",192,[[],["bound",4]]],[11,"end_bound","","",192,[[],["bound",4]]],[11,"start_bound","","",36,[[],["bound",4]]],[11,"end_bound","","",36,[[],["bound",4]]],[11,"start_bound","","",37,[[],["bound",4]]],[11,"end_bound","","",37,[[],["bound",4]]],[11,"start_bound","","",35,[[],["bound",4]]],[11,"end_bound","","",35,[[],["bound",4]]],[11,"start_bound","","",41,[[],["bound",4]]],[11,"end_bound","","",41,[[],["bound",4]]],[11,"start_bound","","",38,[[],["bound",4]]],[11,"end_bound","","",38,[[],["bound",4]]],[11,"start_bound","","",36,[[],["bound",4]]],[11,"end_bound","","",36,[[],["bound",4]]],[11,"start_bound","","",37,[[],["bound",4]]],[11,"end_bound","","",37,[[],["bound",4]]],[11,"start_bound","","",35,[[],["bound",4]]],[11,"end_bound","","",35,[[],["bound",4]]],[11,"start_bound","","",41,[[],["bound",4]]],[11,"end_bound","","",41,[[],["bound",4]]],[11,"start_bound","","",38,[[],["bound",4]]],[11,"end_bound","","",38,[[],["bound",4]]],[11,"into_result","core::option","",96,[[],[["result",4],["noneerror",3]]]],[11,"from_ok","","",96,[[]]],[11,"from_error","","",96,[[["noneerror",3]]]],[11,"into_result","core::result","",101,[[]]],[11,"from_ok","","",101,[[]]],[11,"from_error","","",101,[[]]],[11,"into_result","core::task","",156,[[],["result",4]]],[11,"from_error","","",156,[[]]],[11,"from_ok","","",156,[[]]],[11,"into_result","","",156,[[],["result",4]]],[11,"from_error","","",156,[[]]],[11,"from_ok","","",156,[[]]],[11,"sum","core::num","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","","",0,[[["iterator",8]]]],[11,"sum","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[],["result",4]]],[11,"sum","core::option","Takes each element in the `Iterator`: if it is a `None`,…",96,[[],["option",4]]],[11,"sum","core::time","",153,[[["iterator",8]],["duration",3]]],[11,"sum","","",153,[[["iterator",8]],["duration",3]]],[11,"product","core::num","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","","",0,[[["iterator",8]]]],[11,"product","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[],["result",4]]],[11,"product","core::option","Takes each element in the `Iterator`: if it is a `None`,…",96,[[],["option",4]]],[11,"from_iter","","Takes each element in the [`Iterator`]: if it is…",96,[[["intoiterator",8]],["option",4]]],[11,"from_iter","core::result","Takes each element in the `Iterator`: if it is an `Err`,…",101,[[["intoiterator",8]],["result",4]]],[11,"into_iter","core::option","Returns a consuming iterator over the possibly contained…",96,[[],["intoiter",3]]],[11,"into_iter","core::result","Returns a consuming iterator over the possibly contained…",101,[[],["intoiter",3]]],[11,"next_back","core::array","",77,[[],["option",4]]],[11,"next_back","core::ascii","",194,[[],["option",4]]],[11,"next_back","core::iter","",219,[[],["option",4]]],[11,"nth_back","","",219,[[],["option",4]]],[11,"rfind","","",219,[[],["option",4]]],[11,"try_rfold","","",219,[[]]],[11,"rfold","","",219,[[]]],[11,"next_back","","",227,[[],["option",4]]],[11,"try_rfold","","",227,[[]]],[11,"rfold","","",227,[[]]],[11,"next_back","","",216,[[],["option",4]]],[11,"try_rfold","","",216,[[]]],[11,"rfold","","",216,[[]]],[11,"next_back","","",233,[[],["option",4]]],[11,"nth_back","","",233,[[],["option",4]]],[11,"try_rfold","","",233,[[]]],[11,"rfold","","",233,[[]]],[11,"rfind","","",233,[[],["option",4]]],[11,"next_back","","",226,[[],["option",4]]],[11,"next_back","","",225,[[],["option",4]]],[11,"nth_back","","",225,[[],["option",4]]],[11,"try_rfold","","",225,[[]]],[11,"rfold","","",225,[[]]],[11,"rfind","","",225,[[],["option",4]]],[11,"next_back","","",215,[[],["option",4]]],[11,"try_rfold","","",215,[[]]],[11,"rfold","","",215,[[]]],[11,"next_back","","",214,[[],["option",4]]],[11,"try_rfold","","",214,[[]]],[11,"rfold","","",214,[[]]],[11,"next_back","","",218,[[],["option",4]]],[11,"nth_back","","",218,[[],["option",4]]],[11,"try_rfold","","",218,[[]]],[11,"rfold","","",218,[[]]],[11,"next_back","","",224,[[],["option",4]]],[11,"try_rfold","","",224,[[]]],[11,"rfold","","",224,[[]]],[11,"next_back","","",222,[[],["option",4]]],[11,"try_rfold","","",222,[[]]],[11,"rfold","","",222,[[]]],[11,"next_back","","",223,[[],["option",4]]],[11,"try_rfold","","",223,[[]]],[11,"rfold","","",223,[[]]],[11,"next_back","","",221,[[],["option",4]]],[11,"nth_back","","",221,[[],["option",4]]],[11,"try_rfold","","",221,[[]]],[11,"rfold","","",221,[[]]],[11,"next_back","","",86,[[],["option",4]]],[11,"try_rfold","","",86,[[]]],[11,"rfold","","",86,[[]]],[11,"next_back","","",229,[[],["option",4]]],[11,"nth_back","","",229,[[],["option",4]]],[11,"try_rfold","","",229,[[]]],[11,"rfold","","",229,[[]]],[11,"next_back","","",231,[[],["option",4]]],[11,"nth_back","","",231,[[],["option",4]]],[11,"try_rfold","","",231,[[]]],[11,"rfold","","",231,[[]]],[11,"next_back","","",234,[[],["option",4]]],[11,"try_rfold","","",234,[[]]],[11,"rfold","","",234,[[]]],[11,"next_back","core::ops","",35,[[],["option",4]]],[11,"nth_back","","",35,[[],["option",4]]],[11,"next_back","","",41,[[],["option",4]]],[11,"nth_back","","",41,[[],["option",4]]],[11,"try_rfold","","",41,[[]]],[11,"rfold","","",41,[[]]],[11,"next_back","core::iter","",211,[[],["option",4]]],[11,"next_back","","",207,[[],["option",4]]],[11,"next_back","","",209,[[],["option",4]]],[11,"next_back","","",210,[[],["option",4]]],[11,"next_back","core::option","",235,[[],["option",4]]],[11,"next_back","","",236,[[],["option",4]]],[11,"next_back","","",237,[[],["option",4]]],[11,"next_back","core::result","",239,[[],["option",4]]],[11,"next_back","","",240,[[],["option",4]]],[11,"next_back","","",241,[[],["option",4]]],[11,"next_back","core::slice","",137,[[],["option",4]]],[11,"nth_back","","",137,[[],["option",4]]],[11,"next_back","","",138,[[],["option",4]]],[11,"nth_back","","",138,[[],["option",4]]],[11,"next_back","","",245,[[],["option",4]]],[11,"next_back","","",246,[[],["option",4]]],[11,"next_back","","",247,[[],["option",4]]],[11,"next_back","","",248,[[],["option",4]]],[11,"next_back","","",249,[[],["option",4]]],[11,"next_back","","",250,[[],["option",4]]],[11,"next_back","","",255,[[],["option",4]]],[11,"nth_back","","",255,[[],["option",4]]],[11,"next_back","","",256,[[],["option",4]]],[11,"nth_back","","",256,[[],["option",4]]],[11,"next_back","","",257,[[],["option",4]]],[11,"nth_back","","",257,[[],["option",4]]],[11,"next_back","","",139,[[],["option",4]]],[11,"nth_back","","",139,[[],["option",4]]],[11,"next_back","","",140,[[],["option",4]]],[11,"nth_back","","",140,[[],["option",4]]],[11,"next_back","","",258,[[],["option",4]]],[11,"nth_back","","",258,[[],["option",4]]],[11,"next_back","","",259,[[],["option",4]]],[11,"nth_back","","",259,[[],["option",4]]],[11,"next_back","","",141,[[],["option",4]]],[11,"nth_back","","",141,[[],["option",4]]],[11,"next_back","","",142,[[],["option",4]]],[11,"nth_back","","",142,[[],["option",4]]],[11,"next_back","core::str","",151,[[],["option",4]]],[11,"next_back","","",152,[[],["option",4]]],[11,"next_back","","",261,[[],["option",4]]],[11,"nth_back","","",261,[[],["option",4]]],[11,"rfind","","",261,[[],["option",4]]],[11,"next_back","","",262,[[],["option",4]]],[11,"next_back","","",263,[[],["option",4]]],[11,"next_back","","",264,[[],["option",4]]],[11,"next_back","","",265,[[],["option",4]]],[11,"next_back","","",268,[[],["option",4]]],[11,"next_back","","",269,[[],["option",4]]],[11,"next_back","","",270,[[],["option",4]]],[11,"next_back","","",271,[[],["option",4]]],[11,"next_back","","",272,[[],["option",4]]],[11,"next_back","","",273,[[],["option",4]]],[11,"next_back","","",274,[[],["option",4]]],[11,"next_back","","",275,[[],["option",4]]],[11,"next_back","","",276,[[],["option",4]]],[11,"len","core::array","",77,[[]]],[11,"is_empty","","",77,[[]]],[11,"len","core::char","",200,[[]]],[11,"len","","",201,[[]]],[11,"len","core::iter","",233,[[]]],[11,"is_empty","","",233,[[]]],[11,"len","","",225,[[]]],[11,"is_empty","","",225,[[]]],[11,"len","","",215,[[]]],[11,"is_empty","","",215,[[]]],[11,"len","","",214,[[]]],[11,"is_empty","","",214,[[]]],[11,"len","","",224,[[]]],[11,"is_empty","","",224,[[]]],[11,"len","","",221,[[]]],[11,"is_empty","","",221,[[]]],[11,"len","","",234,[[]]],[11,"is_empty","","",234,[[]]],[11,"len","","",207,[[]]],[11,"len","","",209,[[]]],[11,"len","","",210,[[]]],[11,"len","core::slice","",137,[[]]],[11,"is_empty","","",137,[[]]],[11,"len","","",138,[[]]],[11,"is_empty","","",138,[[]]],[11,"is_empty","","",139,[[]]],[11,"is_empty","","",140,[[]]],[11,"is_empty","","",141,[[]]],[11,"is_empty","","",142,[[]]],[11,"len","core::str","",261,[[]]],[11,"is_empty","","",261,[[]]],[11,"next","core::array","",77,[[],["option",4]]],[11,"size_hint","","",77,[[]]],[11,"count","","",77,[[]]],[11,"last","","",77,[[],["option",4]]],[11,"next","core::ascii","",194,[[],["option",4]]],[11,"size_hint","","",194,[[]]],[11,"last","","",194,[[],["option",4]]],[11,"next","core::char","",199,[[],[["option",4],["result",4]]]],[11,"size_hint","","",199,[[]]],[11,"next","","",200,[[],["option",4]]],[11,"size_hint","","",200,[[]]],[11,"count","","",200,[[]]],[11,"last","","",200,[[],["option",4]]],[11,"next","","",201,[[],["option",4]]],[11,"size_hint","","",201,[[]]],[11,"count","","",201,[[]]],[11,"nth","","",201,[[],["option",4]]],[11,"last","","",201,[[],["option",4]]],[11,"next","","",202,[[],["option",4]]],[11,"size_hint","","",202,[[]]],[11,"next","","",203,[[],["option",4]]],[11,"size_hint","","",203,[[]]],[11,"next","","",204,[[],["option",4]]],[11,"size_hint","","",204,[[]]],[11,"next","core::iter","",219,[[],["option",4]]],[11,"count","","",219,[[]]],[11,"try_fold","","",219,[[]]],[11,"fold","","",219,[[]]],[11,"nth","","",219,[[],["option",4]]],[11,"find","","",219,[[],["option",4]]],[11,"last","","",219,[[],["option",4]]],[11,"size_hint","","",219,[[]]],[11,"next","","",227,[[],["option",4]]],[11,"size_hint","","",227,[[]]],[11,"try_fold","","",227,[[]]],[11,"fold","","",227,[[]]],[11,"next","","",216,[[],["option",4]]],[11,"size_hint","","",216,[[]]],[11,"try_fold","","",216,[[]]],[11,"fold","","",216,[[]]],[11,"next","","",233,[[],["option",4]]],[11,"nth","","",233,[[],["option",4]]],[11,"last","","",233,[[],["option",4]]],[11,"count","","",233,[[]]],[11,"size_hint","","",233,[[]]],[11,"try_fold","","",233,[[]]],[11,"fold","","",233,[[]]],[11,"find","","",233,[[],["option",4]]],[11,"next","","",226,[[],["option",4]]],[11,"size_hint","","",226,[[]]],[11,"nth","","",226,[[],["option",4]]],[11,"next","","",225,[[],["option",4]]],[11,"size_hint","","",225,[[]]],[11,"nth","","",225,[[],["option",4]]],[11,"try_fold","","",225,[[]]],[11,"fold","","",225,[[]]],[11,"find","","",225,[[],["option",4]]],[11,"next","","",215,[[],["option",4]]],[11,"size_hint","","",215,[[]]],[11,"try_fold","","",215,[[]]],[11,"fold","","",215,[[]]],[11,"nth","","",215,[[],["option",4]]],[11,"last","","",215,[[],["option",4]]],[11,"count","","",215,[[]]],[11,"next","","",214,[[],["option",4]]],[11,"size_hint","","",214,[[]]],[11,"try_fold","","",214,[[]]],[11,"fold","","",214,[[]]],[11,"next","","",220,[[],["option",4]]],[11,"size_hint","","",220,[[]]],[11,"try_fold","","",220,[[]]],[11,"next","","",218,[[],["option",4]]],[11,"size_hint","","",218,[[]]],[11,"nth","","",218,[[],["option",4]]],[11,"try_fold","","",218,[[]]],[11,"fold","","",218,[[]]],[11,"next","","",224,[[],["option",4]]],[11,"size_hint","","",224,[[]]],[11,"try_fold","","",224,[[]]],[11,"fold","","",224,[[]]],[11,"next","","",222,[[],["option",4]]],[11,"size_hint","","",222,[[]]],[11,"count","","",222,[[]]],[11,"try_fold","","",222,[[]]],[11,"fold","","",222,[[]]],[11,"next","","",223,[[],["option",4]]],[11,"size_hint","","",223,[[]]],[11,"try_fold","","",223,[[]]],[11,"fold","","",223,[[]]],[11,"next","","Overflow Behavior",221,[[],["option",4]]],[11,"size_hint","","",221,[[]]],[11,"nth","","",221,[[],["option",4]]],[11,"count","","",221,[[]]],[11,"try_fold","","",221,[[]]],[11,"fold","","",221,[[]]],[11,"next","","",86,[[],["option",4]]],[11,"count","","",86,[[]]],[11,"nth","","",86,[[],["option",4]]],[11,"last","","",86,[[],["option",4]]],[11,"size_hint","","",86,[[]]],[11,"try_fold","","",86,[[]]],[11,"fold","","",86,[[]]],[11,"next","","",230,[[],["option",4]]],[11,"size_hint","","",230,[[]]],[11,"try_fold","","",230,[[]]],[11,"fold","","",230,[[]]],[11,"next","","",232,[[],["option",4]]],[11,"size_hint","","",232,[[]]],[11,"try_fold","","",232,[[]]],[11,"fold","","",232,[[]]],[11,"next","","",217,[[],["option",4]]],[11,"size_hint","","",217,[[]]],[11,"try_fold","","",217,[[]]],[11,"fold","","",217,[[]]],[11,"next","","",229,[[],["option",4]]],[11,"nth","","",229,[[],["option",4]]],[11,"count","","",229,[[]]],[11,"last","","",229,[[],["option",4]]],[11,"size_hint","","",229,[[]]],[11,"try_fold","","",229,[[]]],[11,"fold","","",229,[[]]],[11,"next","","",231,[[],["option",4]]],[11,"nth","","",231,[[],["option",4]]],[11,"size_hint","","",231,[[]]],[11,"try_fold","","",231,[[]]],[11,"fold","","",231,[[]]],[11,"next","","",228,[[],["option",4]]],[11,"size_hint","","",228,[[]]],[11,"try_fold","","",228,[[]]],[11,"fold","","",228,[[]]],[11,"next","","",234,[[],["option",4]]],[11,"size_hint","","",234,[[]]],[11,"try_fold","","",234,[[]]],[11,"fold","","",234,[[]]],[11,"next","core::ops","",35,[[],["option",4]]],[11,"size_hint","","",35,[[]]],[11,"nth","","",35,[[],["option",4]]],[11,"last","","",35,[[],["option",4]]],[11,"min","","",35,[[],["option",4]]],[11,"max","","",35,[[],["option",4]]],[11,"next","","",36,[[],["option",4]]],[11,"size_hint","","",36,[[]]],[11,"nth","","",36,[[],["option",4]]],[11,"next","","",41,[[],["option",4]]],[11,"size_hint","","",41,[[]]],[11,"nth","","",41,[[],["option",4]]],[11,"try_fold","","",41,[[]]],[11,"fold","","",41,[[]]],[11,"last","","",41,[[],["option",4]]],[11,"min","","",41,[[],["option",4]]],[11,"max","","",41,[[],["option",4]]],[11,"next","core::iter","",211,[[],["option",4]]],[11,"size_hint","","",211,[[]]],[11,"next","","",212,[[],["option",4]]],[11,"size_hint","","",212,[[]]],[11,"next","","",207,[[],["option",4]]],[11,"size_hint","","",207,[[]]],[11,"next","","",209,[[],["option",4]]],[11,"size_hint","","",209,[[]]],[11,"next","","",210,[[],["option",4]]],[11,"size_hint","","",210,[[]]],[11,"next","","",208,[[],["option",4]]],[11,"next","","",213,[[],["option",4]]],[11,"size_hint","","",213,[[]]],[11,"next","core::option","",235,[[],["option",4]]],[11,"size_hint","","",235,[[]]],[11,"next","","",236,[[],["option",4]]],[11,"size_hint","","",236,[[]]],[11,"next","","",237,[[],["option",4]]],[11,"size_hint","","",237,[[]]],[11,"next","core::result","",239,[[],["option",4]]],[11,"size_hint","","",239,[[]]],[11,"next","","",240,[[],["option",4]]],[11,"size_hint","","",240,[[]]],[11,"next","","",241,[[],["option",4]]],[11,"size_hint","","",241,[[]]],[11,"next","core::slice","",137,[[],["option",4]]],[11,"size_hint","","",137,[[]]],[11,"count","","",137,[[]]],[11,"nth","","",137,[[],["option",4]]],[11,"last","","",137,[[],["option",4]]],[11,"for_each","","",137,[[]]],[11,"all","","",137,[[]]],[11,"any","","",137,[[]]],[11,"find","","",137,[[],["option",4]]],[11,"find_map","","",137,[[],["option",4]]],[11,"position","","",137,[[],["option",4]]],[11,"rposition","","",137,[[],["option",4]]],[11,"is_sorted_by","","",137,[[]]],[11,"next","","",138,[[],["option",4]]],[11,"size_hint","","",138,[[]]],[11,"count","","",138,[[]]],[11,"nth","","",138,[[],["option",4]]],[11,"last","","",138,[[],["option",4]]],[11,"for_each","","",138,[[]]],[11,"all","","",138,[[]]],[11,"any","","",138,[[]]],[11,"find","","",138,[[],["option",4]]],[11,"find_map","","",138,[[],["option",4]]],[11,"position","","",138,[[],["option",4]]],[11,"rposition","","",138,[[],["option",4]]],[11,"next","","",245,[[],["option",4]]],[11,"size_hint","","",245,[[]]],[11,"next","","",246,[[],["option",4]]],[11,"size_hint","","",246,[[]]],[11,"next","","",247,[[],["option",4]]],[11,"size_hint","","",247,[[]]],[11,"next","","",248,[[],["option",4]]],[11,"size_hint","","",248,[[]]],[11,"next","","",249,[[],["option",4]]],[11,"size_hint","","",249,[[]]],[11,"next","","",250,[[],["option",4]]],[11,"size_hint","","",250,[[]]],[11,"next","","",251,[[],["option",4]]],[11,"size_hint","","",251,[[]]],[11,"next","","",252,[[],["option",4]]],[11,"size_hint","","",252,[[]]],[11,"next","","",253,[[],["option",4]]],[11,"size_hint","","",253,[[]]],[11,"next","","",254,[[],["option",4]]],[11,"size_hint","","",254,[[]]],[11,"next","","",255,[[],["option",4]]],[11,"size_hint","","",255,[[]]],[11,"count","","",255,[[]]],[11,"nth","","",255,[[],["option",4]]],[11,"last","","",255,[[],["option",4]]],[11,"next","","",256,[[],["option",4]]],[11,"size_hint","","",256,[[]]],[11,"count","","",256,[[]]],[11,"nth","","",256,[[],["option",4]]],[11,"last","","",256,[[],["option",4]]],[11,"next","","",257,[[],["option",4]]],[11,"size_hint","","",257,[[]]],[11,"count","","",257,[[]]],[11,"nth","","",257,[[],["option",4]]],[11,"last","","",257,[[],["option",4]]],[11,"next","","",139,[[],["option",4]]],[11,"size_hint","","",139,[[]]],[11,"count","","",139,[[]]],[11,"nth","","",139,[[],["option",4]]],[11,"last","","",139,[[],["option",4]]],[11,"next","","",140,[[],["option",4]]],[11,"size_hint","","",140,[[]]],[11,"count","","",140,[[]]],[11,"nth","","",140,[[],["option",4]]],[11,"last","","",140,[[],["option",4]]],[11,"next","","",258,[[],["option",4]]],[11,"size_hint","","",258,[[]]],[11,"count","","",258,[[]]],[11,"nth","","",258,[[],["option",4]]],[11,"last","","",258,[[],["option",4]]],[11,"next","","",259,[[],["option",4]]],[11,"size_hint","","",259,[[]]],[11,"count","","",259,[[]]],[11,"nth","","",259,[[],["option",4]]],[11,"last","","",259,[[],["option",4]]],[11,"next","","",141,[[],["option",4]]],[11,"size_hint","","",141,[[]]],[11,"count","","",141,[[]]],[11,"nth","","",141,[[],["option",4]]],[11,"last","","",141,[[],["option",4]]],[11,"next","","",142,[[],["option",4]]],[11,"size_hint","","",142,[[]]],[11,"count","","",142,[[]]],[11,"nth","","",142,[[],["option",4]]],[11,"last","","",142,[[],["option",4]]],[11,"next","core::str::lossy","",285,[[],[["utf8lossychunk",3],["option",4]]]],[11,"next","core::str","",151,[[],["option",4]]],[11,"count","","",151,[[]]],[11,"size_hint","","",151,[[]]],[11,"last","","",151,[[],["option",4]]],[11,"next","","",152,[[],["option",4]]],[11,"count","","",152,[[]]],[11,"size_hint","","",152,[[]]],[11,"last","","",152,[[],["option",4]]],[11,"next","","",261,[[],["option",4]]],[11,"size_hint","","",261,[[]]],[11,"count","","",261,[[]]],[11,"last","","",261,[[],["option",4]]],[11,"nth","","",261,[[],["option",4]]],[11,"all","","",261,[[]]],[11,"any","","",261,[[]]],[11,"find","","",261,[[],["option",4]]],[11,"position","","",261,[[],["option",4]]],[11,"rposition","","",261,[[],["option",4]]],[11,"next","","",262,[[],["option",4]]],[11,"next","","",263,[[],["option",4]]],[11,"next","","",264,[[],["option",4]]],[11,"next","","",265,[[],["option",4]]],[11,"next","","",266,[[],["option",4]]],[11,"next","","",267,[[],["option",4]]],[11,"next","","",268,[[],["option",4]]],[11,"next","","",269,[[],["option",4]]],[11,"next","","",270,[[],["option",4]]],[11,"next","","",271,[[],["option",4]]],[11,"next","","",272,[[],["option",4]]],[11,"size_hint","","",272,[[]]],[11,"last","","",272,[[],["option",4]]],[11,"next","","",273,[[],["option",4]]],[11,"size_hint","","",273,[[]]],[11,"next","","",274,[[],["option",4]]],[11,"size_hint","","",274,[[]]],[11,"last","","",274,[[],["option",4]]],[11,"next","","",275,[[],["option",4]]],[11,"size_hint","","",275,[[]]],[11,"last","","",275,[[],["option",4]]],[11,"next","","",276,[[],["option",4]]],[11,"next","","",277,[[],["option",4]]],[11,"size_hint","","",277,[[]]],[11,"next","","",278,[[],["option",4]]],[11,"size_hint","","",278,[[]]],[11,"try_fold","","",278,[[]]],[11,"fold","","",278,[[]]],[11,"next","","",279,[[],["option",4]]],[11,"size_hint","","",279,[[]]],[11,"try_fold","","",279,[[]]],[11,"fold","","",279,[[]]],[11,"next","","",280,[[],["option",4]]],[11,"size_hint","","",280,[[]]],[11,"try_fold","","",280,[[]]],[11,"fold","","",280,[[]]],[11,"write_str","core::fmt","",131,[[],["result",6]]],[11,"write_char","","",131,[[],["result",6]]],[11,"write_fmt","","",131,[[["arguments",3]],["result",6]]],[11,"fmt","core::num","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",187,[[["formatter",3]],["result",6]]],[11,"fmt","","",1,[[["formatter",3]],["result",6]]],[11,"fmt","","",186,[[["formatter",3]],["result",6]]],[11,"fmt","","",15,[[["formatter",3]],["result",6]]],[11,"fmt","","",2,[[["formatter",3]],["result",6]]],[11,"fmt","core::mem","",16,[[["formatter",3]],["result",6]]],[11,"fmt","","",17,[[["formatter",3]],["result",6]]],[11,"fmt","","",188,[[["formatter",3]],["result",6]]],[11,"fmt","core::ptr","",18,[[["formatter",3]],["result",6]]],[11,"fmt","core::cmp","",23,[[["formatter",3]],["result",6]]],[11,"fmt","","",22,[[["formatter",3]],["result",6]]],[11,"fmt","core::convert","",189,[[["formatter",3]],["result",6]]],[11,"fmt","core::marker","",191,[[["formatter",3]],["result",6]]],[11,"fmt","core::ops","",40,[[["formatter",3]],["result",6]]],[11,"fmt","","",192,[[["formatter",3]],["result",6]]],[11,"fmt","","",35,[[["formatter",3]],["result",6]]],[11,"fmt","","",36,[[["formatter",3]],["result",6]]],[11,"fmt","","",37,[[["formatter",3]],["result",6]]],[11,"fmt","","",41,[[["formatter",3]],["result",6]]],[11,"fmt","","",38,[[["formatter",3]],["result",6]]],[11,"fmt","","",39,[[["formatter",3]],["result",6]]],[11,"fmt","core::any","",75,[[["formatter",3]],["result",6]]],[11,"fmt","","",75,[[["formatter",3]],["result",6]]],[11,"fmt","","",75,[[["formatter",3]],["result",6]]],[11,"fmt","","",76,[[["formatter",3]],["result",6]]],[11,"fmt","core::array","",77,[[["formatter",3]],["result",6]]],[11,"fmt","","",193,[[["formatter",3]],["result",6]]],[11,"fmt","core::ascii","",194,[[["formatter",3]],["result",6]]],[11,"fmt","core::cell","",195,[[["formatter",3]],["result",6]]],[11,"fmt","","",196,[[["formatter",3]],["result",6]]],[11,"fmt","core::char","",198,[[["formatter",3]],["result",6]]],[11,"fmt","","",197,[[["formatter",3]],["result",6]]],[11,"fmt","","",199,[[["formatter",3]],["result",6]]],[11,"fmt","","",84,[[["formatter",3]],["result",6]]],[11,"fmt","","",200,[[["formatter",3]],["result",6]]],[11,"fmt","","",201,[[["formatter",3]],["result",6]]],[11,"fmt","","",202,[[["formatter",3]],["result",6]]],[11,"fmt","","",203,[[["formatter",3]],["result",6]]],[11,"fmt","","",204,[[["formatter",3]],["result",6]]],[11,"fmt","core::ffi","",206,[[["formatter",3]],["result",6]]],[11,"fmt","","",85,[[["formatter",3]],["result",6]]],[11,"fmt","","",205,[[["formatter",3]],["result",6]]],[11,"fmt","core::iter","",219,[[["formatter",3]],["result",6]]],[11,"fmt","","",227,[[["formatter",3]],["result",6]]],[11,"fmt","","",216,[[["formatter",3]],["result",6]]],[11,"fmt","","",233,[[["formatter",3]],["result",6]]],[11,"fmt","","",226,[[["formatter",3]],["result",6]]],[11,"fmt","","",225,[[["formatter",3]],["result",6]]],[11,"fmt","","",215,[[["formatter",3]],["result",6]]],[11,"fmt","","",214,[[["formatter",3]],["result",6]]],[11,"fmt","","",220,[[["formatter",3]],["result",6]]],[11,"fmt","","",218,[[["formatter",3]],["result",6]]],[11,"fmt","","",224,[[["formatter",3]],["result",6]]],[11,"fmt","","",222,[[["formatter",3]],["result",6]]],[11,"fmt","","",223,[[["formatter",3]],["result",6]]],[11,"fmt","","",221,[[["formatter",3]],["result",6]]],[11,"fmt","","",86,[[["formatter",3]],["result",6]]],[11,"fmt","","",230,[[["formatter",3]],["result",6]]],[11,"fmt","","",232,[[["formatter",3]],["result",6]]],[11,"fmt","","",217,[[["formatter",3]],["result",6]]],[11,"fmt","","",229,[[["formatter",3]],["result",6]]],[11,"fmt","","",231,[[["formatter",3]],["result",6]]],[11,"fmt","","",228,[[["formatter",3]],["result",6]]],[11,"fmt","","",234,[[["formatter",3]],["result",6]]],[11,"fmt","","",211,[[["formatter",3]],["result",6]]],[11,"fmt","","",212,[[["formatter",3]],["result",6]]],[11,"fmt","","",207,[[["formatter",3]],["result",6]]],[11,"fmt","","",209,[[["formatter",3]],["result",6]]],[11,"fmt","","",210,[[["formatter",3]],["result",6]]],[11,"fmt","","",208,[[["formatter",3]],["result",6]]],[11,"fmt","","",213,[[["formatter",3]],["result",6]]],[11,"fmt","core::option","",96,[[["formatter",3]],["result",6]]],[11,"fmt","","",235,[[["formatter",3]],["result",6]]],[11,"fmt","","",236,[[["formatter",3]],["result",6]]],[11,"fmt","","",237,[[["formatter",3]],["result",6]]],[11,"fmt","","",238,[[["formatter",3]],["result",6]]],[11,"fmt","core::panic","",97,[[["formatter",3]],["result",6]]],[11,"fmt","","",98,[[["formatter",3]],["result",6]]],[11,"fmt","core::pin","",99,[[["formatter",3]],["result",6]]],[11,"fmt","core::result","",101,[[["formatter",3]],["result",6]]],[11,"fmt","","",239,[[["formatter",3]],["result",6]]],[11,"fmt","","",240,[[["formatter",3]],["result",6]]],[11,"fmt","","",241,[[["formatter",3]],["result",6]]],[11,"fmt","core::sync::atomic","",102,[[["formatter",3]],["result",6]]],[11,"fmt","","",105,[[["formatter",3]],["result",6]]],[11,"fmt","","",106,[[["formatter",3]],["result",6]]],[11,"fmt","","",107,[[["formatter",3]],["result",6]]],[11,"fmt","","",108,[[["formatter",3]],["result",6]]],[11,"fmt","","",109,[[["formatter",3]],["result",6]]],[11,"fmt","","",110,[[["formatter",3]],["result",6]]],[11,"fmt","","",111,[[["formatter",3]],["result",6]]],[11,"fmt","","",112,[[["formatter",3]],["result",6]]],[11,"fmt","","",113,[[["formatter",3]],["result",6]]],[11,"fmt","","",114,[[["formatter",3]],["result",6]]],[11,"fmt","","",103,[[["formatter",3]],["result",6]]],[11,"fmt","","",104,[[["formatter",3]],["result",6]]],[11,"fmt","core::fmt","",115,[[["formatter",3]],["result",6]]],[11,"fmt","","",242,[[["formatter",3]],["result",6]]],[11,"fmt","","",243,[[["formatter",3]],["result",6]]],[11,"fmt","core::marker","",190,[[["formatter",3]],["result",6]]],[11,"fmt","core::cell","",79,[[["formatter",3]],["result",6]]],[11,"fmt","","",80,[[["formatter",3]],["result",6]]],[11,"fmt","","",81,[[["formatter",3]],["result",6]]],[11,"fmt","","",82,[[["formatter",3]],["result",6]]],[11,"fmt","","",83,[[["formatter",3]],["result",6]]],[11,"fmt","core::hash","",132,[[["formatter",3]],["result",6]]],[11,"fmt","","",244,[[["formatter",3]],["result",6]]],[11,"fmt","core::slice","",137,[[["formatter",3]],["result",6]]],[11,"fmt","","",138,[[["formatter",3]],["result",6]]],[11,"fmt","","",245,[[["formatter",3]],["result",6]]],[11,"fmt","","",246,[[["formatter",3]],["result",6]]],[11,"fmt","","",247,[[["formatter",3]],["result",6]]],[11,"fmt","","",248,[[["formatter",3]],["result",6]]],[11,"fmt","","",249,[[["formatter",3]],["result",6]]],[11,"fmt","","",250,[[["formatter",3]],["result",6]]],[11,"fmt","","",251,[[["formatter",3]],["result",6]]],[11,"fmt","","",252,[[["formatter",3]],["result",6]]],[11,"fmt","","",253,[[["formatter",3]],["result",6]]],[11,"fmt","","",254,[[["formatter",3]],["result",6]]],[11,"fmt","","",255,[[["formatter",3]],["result",6]]],[11,"fmt","","",256,[[["formatter",3]],["result",6]]],[11,"fmt","","",257,[[["formatter",3]],["result",6]]],[11,"fmt","","",139,[[["formatter",3]],["result",6]]],[11,"fmt","","",140,[[["formatter",3]],["result",6]]],[11,"fmt","","",258,[[["formatter",3]],["result",6]]],[11,"fmt","","",259,[[["formatter",3]],["result",6]]],[11,"fmt","","",141,[[["formatter",3]],["result",6]]],[11,"fmt","","",142,[[["formatter",3]],["result",6]]],[11,"fmt","core::str::pattern","",143,[[["formatter",3]],["result",6]]],[11,"fmt","","",281,[[["formatter",3]],["result",6]]],[11,"fmt","","",282,[[["formatter",3]],["result",6]]],[11,"fmt","","",283,[[["formatter",3]],["result",6]]],[11,"fmt","","",284,[[["formatter",3]],["result",6]]],[11,"fmt","core::str::lossy","",147,[[["formatter",3]],["result",6]]],[11,"fmt","","",148,[[["formatter",3]],["result",6]]],[11,"fmt","core::str","",260,[[["formatter",3]],["result",6]]],[11,"fmt","","",150,[[["formatter",3]],["result",6]]],[11,"fmt","","",151,[[["formatter",3]],["result",6]]],[11,"fmt","","",152,[[["formatter",3]],["result",6]]],[11,"fmt","","",261,[[["formatter",3]],["result",6]]],[11,"fmt","","",262,[[["formatter",3]],["result",6]]],[11,"fmt","","",263,[[["formatter",3]],["result",6]]],[11,"fmt","","",264,[[["formatter",3]],["result",6]]],[11,"fmt","","",265,[[["formatter",3]],["result",6]]],[11,"fmt","","",266,[[["formatter",3]],["result",6]]],[11,"fmt","","",267,[[["formatter",3]],["result",6]]],[11,"fmt","","",268,[[["formatter",3]],["result",6]]],[11,"fmt","","",269,[[["formatter",3]],["result",6]]],[11,"fmt","","",270,[[["formatter",3]],["result",6]]],[11,"fmt","","",271,[[["formatter",3]],["result",6]]],[11,"fmt","","",272,[[["formatter",3]],["result",6]]],[11,"fmt","","",273,[[["formatter",3]],["result",6]]],[11,"fmt","","",274,[[["formatter",3]],["result",6]]],[11,"fmt","","",275,[[["formatter",3]],["result",6]]],[11,"fmt","","",276,[[["formatter",3]],["result",6]]],[11,"fmt","","",277,[[["formatter",3]],["result",6]]],[11,"fmt","","",278,[[["formatter",3]],["result",6]]],[11,"fmt","","",279,[[["formatter",3]],["result",6]]],[11,"fmt","","",280,[[["formatter",3]],["result",6]]],[11,"fmt","core::time","",153,[[["formatter",3]],["result",6]]],[11,"fmt","core::future","",286,[[["formatter",3]],["result",6]]],[11,"fmt","","",287,[[["formatter",3]],["result",6]]],[11,"fmt","core::task","",156,[[["formatter",3]],["result",6]]],[11,"fmt","","",157,[[["formatter",3]],["result",6]]],[11,"fmt","","",158,[[["formatter",3]],["result",6]]],[11,"fmt","","",159,[[["formatter",3]],["result",6]]],[11,"fmt","","",160,[[["formatter",3]],["result",6]]],[11,"fmt","core::alloc","",164,[[["formatter",3]],["result",6]]],[11,"fmt","","",288,[[["formatter",3]],["result",6]]],[11,"fmt","","",289,[[["formatter",3]],["result",6]]],[11,"fmt","","",162,[[["formatter",3]],["result",6]]],[11,"fmt","","",161,[[["formatter",3]],["result",6]]],[11,"fmt","","",163,[[["formatter",3]],["result",6]]],[11,"fmt","core::arch::x86","",292,[[["formatter",3]],["result",6]]],[11,"fmt","","",293,[[["formatter",3]],["result",6]]],[11,"fmt","","",294,[[["formatter",3]],["result",6]]],[11,"fmt","","",295,[[["formatter",3]],["result",6]]],[11,"fmt","","",296,[[["formatter",3]],["result",6]]],[11,"fmt","","",297,[[["formatter",3]],["result",6]]],[11,"fmt","","",298,[[["formatter",3]],["result",6]]],[11,"fmt","","",299,[[["formatter",3]],["result",6]]],[11,"fmt","","",300,[[["formatter",3]],["result",6]]],[11,"fmt","","",301,[[["formatter",3]],["result",6]]],[11,"fmt","","",167,[[["formatter",3]],["result",6]]],[11,"fmt","core::arch::aarch64","",302,[[["formatter",3]],["result",6]]],[11,"fmt","","",303,[[["formatter",3]],["result",6]]],[11,"fmt","","",304,[[["formatter",3]],["result",6]]],[11,"fmt","","",305,[[["formatter",3]],["result",6]]],[11,"fmt","","",306,[[["formatter",3]],["result",6]]],[11,"fmt","","",307,[[["formatter",3]],["result",6]]],[11,"fmt","core::arch::arm","",308,[[["formatter",3]],["result",6]]],[11,"fmt","","",309,[[["formatter",3]],["result",6]]],[11,"fmt","","",310,[[["formatter",3]],["result",6]]],[11,"fmt","","",311,[[["formatter",3]],["result",6]]],[11,"fmt","","",312,[[["formatter",3]],["result",6]]],[11,"fmt","","",313,[[["formatter",3]],["result",6]]],[11,"fmt","","",314,[[["formatter",3]],["result",6]]],[11,"fmt","","",315,[[["formatter",3]],["result",6]]],[11,"fmt","","",316,[[["formatter",3]],["result",6]]],[11,"fmt","","",317,[[["formatter",3]],["result",6]]],[11,"fmt","","",318,[[["formatter",3]],["result",6]]],[11,"fmt","","",319,[[["formatter",3]],["result",6]]],[11,"fmt","","",320,[[["formatter",3]],["result",6]]],[11,"fmt","","",321,[[["formatter",3]],["result",6]]],[11,"fmt","","",322,[[["formatter",3]],["result",6]]],[11,"fmt","","",323,[[["formatter",3]],["result",6]]],[11,"fmt","","",324,[[["formatter",3]],["result",6]]],[11,"fmt","","",325,[[["formatter",3]],["result",6]]],[11,"fmt","","",326,[[["formatter",3]],["result",6]]],[11,"fmt","","",327,[[["formatter",3]],["result",6]]],[11,"fmt","","",328,[[["formatter",3]],["result",6]]],[11,"fmt","","",329,[[["formatter",3]],["result",6]]],[11,"fmt","core::arch::wasm32","",330,[[["formatter",3]],["result",6]]],[11,"fmt","core::arch::powerpc","",331,[[["formatter",3]],["result",6]]],[11,"fmt","","",332,[[["formatter",3]],["result",6]]],[11,"fmt","","",333,[[["formatter",3]],["result",6]]],[11,"fmt","","",334,[[["formatter",3]],["result",6]]],[11,"fmt","core::num","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",187,[[["formatter",3]],["result",6]]],[11,"fmt","","",186,[[["formatter",3]],["result",6]]],[11,"fmt","","",15,[[["formatter",3]],["result",6]]],[11,"fmt","core::convert","",189,[[["formatter",3]],["result",6]]],[11,"fmt","core::array","",193,[[["formatter",3]],["result",6]]],[11,"fmt","core::ascii","",194,[[["formatter",3]],["result",6]]],[11,"fmt","core::cell","",195,[[["formatter",3]],["result",6]]],[11,"fmt","","",196,[[["formatter",3]],["result",6]]],[11,"fmt","","",81,[[["formatter",3]],["result",6]]],[11,"fmt","","",82,[[["formatter",3]],["result",6]]],[11,"fmt","core::char","",198,[[["formatter",3]],["result",6]]],[11,"fmt","","",197,[[["formatter",3]],["result",6]]],[11,"fmt","","",84,[[["formatter",3]],["result",6]]],[11,"fmt","","",200,[[["formatter",3]],["result",6]]],[11,"fmt","","",201,[[["formatter",3]],["result",6]]],[11,"fmt","","",202,[[["formatter",3]],["result",6]]],[11,"fmt","","",203,[[["formatter",3]],["result",6]]],[11,"fmt","","",204,[[["formatter",3]],["result",6]]],[11,"fmt","core::panic","",97,[[["formatter",3]],["result",6]]],[11,"fmt","","",98,[[["formatter",3]],["result",6]]],[11,"fmt","core::pin","",99,[[["formatter",3]],["result",6]]],[11,"fmt","core::fmt","",243,[[["formatter",3]],["result",6]]],[11,"fmt","","",242,[[["formatter",3]],["result",6]]],[11,"fmt","core::str::lossy","",148,[[["formatter",3]],["result",6]]],[11,"fmt","core::str","",260,[[["formatter",3]],["result",6]]],[11,"fmt","","",150,[[["formatter",3]],["result",6]]],[11,"fmt","","",278,[[["formatter",3]],["result",6]]],[11,"fmt","","",279,[[["formatter",3]],["result",6]]],[11,"fmt","","",280,[[["formatter",3]],["result",6]]],[11,"fmt","core::alloc","",288,[[["formatter",3]],["result",6]]],[11,"fmt","","",289,[[["formatter",3]],["result",6]]],[11,"fmt","core::num","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","core::ptr","",18,[[["formatter",3]],["result",6]]],[11,"fmt","core::pin","",99,[[["formatter",3]],["result",6]]],[11,"fmt","core::sync::atomic","",104,[[["formatter",3]],["result",6]]],[11,"hash","core::num","",3,[[]]],[11,"hash","","",4,[[]]],[11,"hash","","",5,[[]]],[11,"hash","","",6,[[]]],[11,"hash","","",7,[[]]],[11,"hash","","",8,[[]]],[11,"hash","","",9,[[]]],[11,"hash","","",10,[[]]],[11,"hash","","",11,[[]]],[11,"hash","","",12,[[]]],[11,"hash","","",13,[[]]],[11,"hash","","",14,[[]]],[11,"hash","","",0,[[]]],[11,"hash","core::mem","",16,[[]]],[11,"hash","","",188,[[]]],[11,"hash","core::ptr","",18,[[]]],[11,"hash","core::cmp","",23,[[]]],[11,"hash","","",22,[[]]],[11,"hash","core::convert","",189,[[]]],[11,"hash","core::marker","",190,[[]]],[11,"hash","","",191,[[]]],[11,"hash","core::ops","",40,[[]]],[11,"hash","","",192,[[]]],[11,"hash","","",35,[[]]],[11,"hash","","",36,[[]]],[11,"hash","","",37,[[]]],[11,"hash","","",41,[[]]],[11,"hash","","",38,[[]]],[11,"hash","","",39,[[]]],[11,"hash","core::any","",76,[[]]],[11,"hash","core::option","",96,[[]]],[11,"hash","","",238,[[]]],[11,"hash","core::pin","",99,[[]]],[11,"hash","core::result","",101,[[]]],[11,"hash","core::sync::atomic","",102,[[]]],[11,"hash","core::fmt","",242,[[]]],[11,"hash","core::time","",153,[[]]],[11,"hash","core::task","",156,[[]]],[11,"write","core::hash","",132,[[]]],[11,"finish","","",132,[[]]],[11,"build_hasher","","",244,[[]]],[11,"get","core::ops","",35,[[],["option",4]]],[11,"get_mut","","",35,[[],["option",4]]],[11,"get_unchecked","","",35,[[]]],[11,"get_unchecked_mut","","",35,[[]]],[11,"index","","",35,[[]]],[11,"index_mut","","",35,[[]]],[11,"get","","",37,[[],["option",4]]],[11,"get_mut","","",37,[[],["option",4]]],[11,"get_unchecked","","",37,[[]]],[11,"get_unchecked_mut","","",37,[[]]],[11,"index","","",37,[[]]],[11,"index_mut","","",37,[[]]],[11,"get","","",36,[[],["option",4]]],[11,"get_mut","","",36,[[],["option",4]]],[11,"get_unchecked","","",36,[[]]],[11,"get_unchecked_mut","","",36,[[]]],[11,"index","","",36,[[]]],[11,"index_mut","","",36,[[]]],[11,"get","","",192,[[],["option",4]]],[11,"get_mut","","",192,[[],["option",4]]],[11,"get_unchecked","","",192,[[]]],[11,"get_unchecked_mut","","",192,[[]]],[11,"index","","",192,[[]]],[11,"index_mut","","",192,[[]]],[11,"get","","",41,[[],["option",4]]],[11,"get_mut","","",41,[[],["option",4]]],[11,"get_unchecked","","",41,[[]]],[11,"get_unchecked_mut","","",41,[[]]],[11,"index","","",41,[[]]],[11,"index_mut","","",41,[[]]],[11,"get","","",38,[[],["option",4]]],[11,"get_mut","","",38,[[],["option",4]]],[11,"get_unchecked","","",38,[[]]],[11,"get_unchecked_mut","","",38,[[]]],[11,"index","","",38,[[]]],[11,"index_mut","","",38,[[]]],[11,"get","","",192,[[],["option",4]]],[11,"get_mut","","",192,[[],["option",4]]],[11,"get_unchecked","","",192,[[]]],[11,"get_unchecked_mut","","",192,[[]]],[11,"index","","",192,[[]]],[11,"index_mut","","",192,[[]]],[11,"get","","",35,[[],["option",4]]],[11,"get_mut","","",35,[[],["option",4]]],[11,"get_unchecked","","",35,[[]]],[11,"get_unchecked_mut","","",35,[[]]],[11,"index","","",35,[[]]],[11,"index_mut","","",35,[[]]],[11,"get","","",37,[[],["option",4]]],[11,"get_mut","","",37,[[],["option",4]]],[11,"get_unchecked","","",37,[[]]],[11,"get_unchecked_mut","","",37,[[]]],[11,"index","","",37,[[]]],[11,"index_mut","","",37,[[]]],[11,"get","","",36,[[],["option",4]]],[11,"get_mut","","",36,[[],["option",4]]],[11,"get_unchecked","","",36,[[]]],[11,"get_unchecked_mut","","",36,[[]]],[11,"index","","",36,[[]]],[11,"index_mut","","",36,[[]]],[11,"get","","",41,[[],["option",4]]],[11,"get_mut","","",41,[[],["option",4]]],[11,"get_unchecked","","",41,[[]]],[11,"get_unchecked_mut","","",41,[[]]],[11,"index","","",41,[[]]],[11,"index_mut","","",41,[[]]],[11,"get","","",38,[[],["option",4]]],[11,"get_mut","","",38,[[],["option",4]]],[11,"get_unchecked","","",38,[[]]],[11,"get_unchecked_mut","","",38,[[]]],[11,"index","","",38,[[]]],[11,"index_mut","","",38,[[]]],[11,"haystack","core::str::pattern","",281,[[]]],[11,"next","","",281,[[],["searchstep",4]]],[11,"next_match","","",281,[[],["option",4]]],[11,"haystack","","",282,[[]]],[11,"next","","",282,[[],["searchstep",4]]],[11,"next_match","","",282,[[],["option",4]]],[11,"next_reject","","",282,[[],["option",4]]],[11,"haystack","","",283,[[]]],[11,"next","","",283,[[],["searchstep",4]]],[11,"next_match","","",283,[[],["option",4]]],[11,"next_reject","","",283,[[],["option",4]]],[11,"haystack","","",284,[[]]],[11,"next","","",284,[[],["searchstep",4]]],[11,"next_match","","",284,[[],["option",4]]],[11,"next_back","","",281,[[],["searchstep",4]]],[11,"next_match_back","","",281,[[],["option",4]]],[11,"next_back","","",282,[[],["searchstep",4]]],[11,"next_match_back","","",282,[[],["option",4]]],[11,"next_reject_back","","",282,[[],["option",4]]],[11,"next_back","","",283,[[],["searchstep",4]]],[11,"next_match_back","","",283,[[],["option",4]]],[11,"next_reject_back","","",283,[[],["option",4]]],[11,"next_back","","",284,[[],["searchstep",4]]],[11,"next_match_back","","",284,[[],["option",4]]],[11,"from_str","core::num","",3,[[],["result",4]]],[11,"from_str","","",4,[[],["result",4]]],[11,"from_str","","",5,[[],["result",4]]],[11,"from_str","","",6,[[],["result",4]]],[11,"from_str","","",7,[[],["result",4]]],[11,"from_str","","",8,[[],["result",4]]],[11,"from_str","","",9,[[],["result",4]]],[11,"from_str","","",10,[[],["result",4]]],[11,"from_str","","",11,[[],["result",4]]],[11,"from_str","","",12,[[],["result",4]]],[11,"from_str","","",13,[[],["result",4]]],[11,"from_str","","",14,[[],["result",4]]],[11,"poll","core::pin","",99,[[["pin",3],["context",3]],["poll",4]]],[11,"poll","core::future","",286,[[["pin",3],["context",3]],["poll",4]]],[11,"poll","","",287,[[["pin",3],["context",3]],["poll",4]]],[11,"contains","core::ops","Returns `true` if `item` is contained in the range.",72,[[]]],[11,"forward","core::iter","Returns the value that would be obtained by taking the…",88,[[]]],[11,"forward_unchecked","","Returns the value that would be obtained by taking the…",88,[[]]],[11,"backward","","Returns the value that would be obtained by taking the…",88,[[]]],[11,"backward_unchecked","","Returns the value that would be obtained by taking the…",88,[[]]],[11,"extend_one","","Extends a collection with exactly one element.",90,[[]]],[11,"extend_reserve","","Reserves capacity in a collection for the given number of…",90,[[]]],[11,"nth_back","","Returns the `n`th element from the end of the iterator.",89,[[],["option",4]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes…",89,[[]]],[11,"rfold","","An iterator method that reduces the iterator\'s elements to…",89,[[]]],[11,"rfind","","Searches for an element of an iterator from the back that…",89,[[],["option",4]]],[11,"len","","Returns the exact length of the iterator.",93,[[]]],[11,"is_empty","","Returns `true` if the iterator is empty.",93,[[]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",87,[[]]],[11,"count","","Consumes the iterator, counting the number of iterations…",87,[[]]],[11,"last","","Consumes the iterator, returning the last element.",87,[[],["option",4]]],[11,"nth","","Returns the `n`th element of the iterator.",87,[[],["option",4]]],[11,"step_by","","Creates an iterator starting at the same point, but…",87,[[],["stepby",3]]],[11,"chain","","Takes two iterators and creates a new iterator over both…",87,[[],["chain",3]]],[11,"zip","","\'Zips up\' two iterators into a single iterator of pairs.",87,[[],["zip",3]]],[11,"map","","Takes a closure and creates an iterator which calls that…",87,[[],["map",3]]],[11,"for_each","","Calls a closure on each element of an iterator.",87,[[]]],[11,"filter","","Creates an iterator which uses a closure to determine if…",87,[[],["filter",3]]],[11,"filter_map","","Creates an iterator that both filters and maps.",87,[[],["filtermap",3]]],[11,"enumerate","","Creates an iterator which gives the current iteration…",87,[[],["enumerate",3]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the…",87,[[],["peekable",3]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a…",87,[[],["skipwhile",3]]],[11,"take_while","","Creates an iterator that yields elements based on a…",87,[[],["takewhile",3]]],[11,"map_while","","Creates an iterator that both yields elements based on a…",87,[[],["mapwhile",3]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",87,[[],["skip",3]]],[11,"take","","Creates an iterator that yields its first `n` elements.",87,[[],["take",3]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds…",87,[[],["scan",3]]],[11,"flat_map","","Creates an iterator that works like map, but flattens…",87,[[],["flatmap",3]]],[11,"flatten","","Creates an iterator that flattens nested structure.",87,[[],["flatten",3]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",87,[[],["fuse",3]]],[11,"inspect","","Does something with each element of an iterator, passing…",87,[[],["inspect",3]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",87,[[]]],[11,"collect","","Transforms an iterator into a collection.",87,[[],["fromiterator",8]]],[11,"partition","","Consumes an iterator, creating two collections from it.",87,[[]]],[11,"partition_in_place","","Reorders the elements of this iterator in-place according…",87,[[]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned…",87,[[]]],[11,"try_fold","","An iterator method that applies a function as long as it…",87,[[]]],[11,"try_for_each","","An iterator method that applies a fallible function to…",87,[[]]],[11,"fold","","An iterator method that applies a function, producing a…",87,[[]]],[11,"fold_first","","The same as `fold()`, but uses the first element in the…",87,[[],["option",4]]],[11,"all","","Tests if every element of the iterator matches a predicate.",87,[[]]],[11,"any","","Tests if any element of the iterator matches a predicate.",87,[[]]],[11,"find","","Searches for an element of an iterator that satisfies a…",87,[[],["option",4]]],[11,"find_map","","Applies function to the elements of iterator and returns…",87,[[],["option",4]]],[11,"try_find","","Applies function to the elements of iterator and returns…",87,[[],[["option",4],["result",4]]]],[11,"position","","Searches for an element in an iterator, returning its index.",87,[[],["option",4]]],[11,"rposition","","Searches for an element in an iterator from the right,…",87,[[],["option",4]]],[11,"max","","Returns the maximum element of an iterator.",87,[[],["option",4]]],[11,"min","","Returns the minimum element of an iterator.",87,[[],["option",4]]],[11,"max_by_key","","Returns the element that gives the maximum value from the…",87,[[],["option",4]]],[11,"max_by","","Returns the element that gives the maximum value with…",87,[[],["option",4]]],[11,"min_by_key","","Returns the element that gives the minimum value from the…",87,[[],["option",4]]],[11,"min_by","","Returns the element that gives the minimum value with…",87,[[],["option",4]]],[11,"rev","","Reverses an iterator\'s direction.",87,[[],["rev",3]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",87,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",87,[[],["copied",3]]],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",87,[[],["cloned",3]]],[11,"cycle","","Repeats an iterator endlessly.",87,[[],["cycle",3]]],[11,"sum","","Sums the elements of an iterator.",87,[[]]],[11,"product","","Iterates over the entire iterator, multiplying all the…",87,[[]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[],["ordering",4]]],[11,"cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[],["ordering",4]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator`…",87,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this `Iterator`…",87,[[],[["ordering",4],["option",4]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to…",87,[[]]],[11,"eq_by","","Determines if the elements of this `Iterator` are equal to…",87,[[]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal…",87,[[]]],[11,"lt","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"le","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"gt","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"ge","","Determines if the elements of this `Iterator` are…",87,[[]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",87,[[]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using…",87,[[]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using…",87,[[]]],[11,"alloc_zeroed","core::alloc","Behaves like `alloc`, but also ensures that the contents…",165,[[["layout",3]]]],[11,"realloc","","Shrink or grow a block of memory to the given `new_size`.…",165,[[["layout",3]]]]],"p":[[3,"Wrapping"],[4,"FpCategory"],[4,"IntErrorKind"],[3,"NonZeroU8"],[3,"NonZeroU16"],[3,"NonZeroU32"],[3,"NonZeroU64"],[3,"NonZeroU128"],[3,"NonZeroUsize"],[3,"NonZeroI8"],[3,"NonZeroI16"],[3,"NonZeroI32"],[3,"NonZeroI64"],[3,"NonZeroI128"],[3,"NonZeroIsize"],[3,"ParseIntError"],[3,"ManuallyDrop"],[19,"MaybeUninit"],[3,"NonNull"],[8,"Borrow"],[8,"BorrowMut"],[8,"Clone"],[3,"Reverse"],[4,"Ordering"],[8,"PartialEq"],[8,"Ord"],[8,"PartialOrd"],[8,"AsRef"],[8,"AsMut"],[8,"Into"],[8,"From"],[8,"TryInto"],[8,"TryFrom"],[8,"Default"],[8,"DiscriminantKind"],[3,"Range"],[3,"RangeFrom"],[3,"RangeTo"],[3,"RangeToInclusive"],[4,"Bound"],[4,"GeneratorState"],[3,"RangeInclusive"],[8,"Add"],[8,"Div"],[8,"Mul"],[8,"Neg"],[8,"Rem"],[8,"Sub"],[8,"AddAssign"],[8,"DivAssign"],[8,"MulAssign"],[8,"RemAssign"],[8,"SubAssign"],[8,"BitAnd"],[8,"BitOr"],[8,"BitXor"],[8,"Not"],[8,"Shl"],[8,"Shr"],[8,"BitAndAssign"],[8,"BitOrAssign"],[8,"BitXorAssign"],[8,"ShlAssign"],[8,"ShrAssign"],[8,"Deref"],[8,"DerefMut"],[8,"Drop"],[8,"Fn"],[8,"FnMut"],[8,"FnOnce"],[8,"Index"],[8,"IndexMut"],[8,"RangeBounds"],[8,"Try"],[8,"Generator"],[8,"Any"],[3,"TypeId"],[3,"IntoIter"],[8,"FixedSizeArray"],[3,"Cell"],[3,"RefCell"],[3,"Ref"],[3,"RefMut"],[3,"UnsafeCell"],[3,"DecodeUtf16Error"],[3,"VaListImpl"],[3,"Peekable"],[8,"Iterator"],[8,"Step"],[8,"DoubleEndedIterator"],[8,"Extend"],[8,"FromIterator"],[8,"IntoIterator"],[8,"ExactSizeIterator"],[8,"Product"],[8,"Sum"],[4,"Option"],[3,"PanicInfo"],[3,"Location"],[3,"Pin"],[3,"TraitObject"],[4,"Result"],[4,"Ordering"],[3,"AtomicBool"],[3,"AtomicPtr"],[3,"AtomicI8"],[3,"AtomicU8"],[3,"AtomicI16"],[3,"AtomicU16"],[3,"AtomicI32"],[3,"AtomicU32"],[3,"AtomicI64"],[3,"AtomicU64"],[3,"AtomicIsize"],[3,"AtomicUsize"],[4,"Alignment"],[3,"DebugStruct"],[3,"DebugTuple"],[3,"DebugSet"],[3,"DebugList"],[3,"DebugMap"],[8,"Write"],[8,"Debug"],[8,"Display"],[8,"Octal"],[8,"Binary"],[8,"LowerHex"],[8,"UpperHex"],[8,"Pointer"],[8,"LowerExp"],[8,"UpperExp"],[3,"Formatter"],[3,"SipHasher"],[8,"Hash"],[8,"Hasher"],[8,"BuildHasher"],[8,"SliceIndex"],[3,"Iter"],[3,"IterMut"],[3,"ChunksExact"],[3,"ChunksExactMut"],[3,"RChunksExact"],[3,"RChunksExactMut"],[4,"SearchStep"],[8,"Pattern"],[8,"Searcher"],[8,"ReverseSearcher"],[3,"Utf8LossyChunk"],[3,"Utf8Lossy"],[8,"FromStr"],[3,"Utf8Error"],[3,"Chars"],[3,"CharIndices"],[3,"Duration"],[8,"Future"],[8,"IntoFuture"],[4,"Poll"],[3,"RawWaker"],[3,"RawWakerVTable"],[3,"Context"],[3,"Waker"],[3,"MemoryBlock"],[4,"AllocInit"],[4,"ReallocPlacement"],[3,"Layout"],[8,"GlobalAlloc"],[8,"AllocRef"],[3,"CpuidResult"],[3,"int8x8x2_t"],[3,"int8x8x3_t"],[3,"int8x8x4_t"],[3,"uint8x8x2_t"],[3,"uint8x8x3_t"],[3,"uint8x8x4_t"],[3,"poly8x8x2_t"],[3,"poly8x8x3_t"],[3,"poly8x8x4_t"],[3,"int8x16x2_t"],[3,"int8x16x3_t"],[3,"int8x16x4_t"],[3,"uint8x16x2_t"],[3,"uint8x16x3_t"],[3,"uint8x16x4_t"],[3,"poly8x16x2_t"],[3,"poly8x16x3_t"],[3,"poly8x16x4_t"],[3,"TryFromIntError"],[3,"ParseFloatError"],[3,"Discriminant"],[4,"Infallible"],[3,"PhantomData"],[3,"PhantomPinned"],[3,"RangeFull"],[3,"TryFromSliceError"],[3,"EscapeDefault"],[3,"BorrowError"],[3,"BorrowMutError"],[3,"CharTryFromError"],[3,"ParseCharError"],[3,"DecodeUtf16"],[3,"EscapeUnicode"],[3,"EscapeDefault"],[3,"EscapeDebug"],[3,"ToLowercase"],[3,"ToUppercase"],[3,"VaList"],[4,"c_void"],[3,"Empty"],[3,"FromFn"],[3,"Once"],[3,"OnceWith"],[3,"Repeat"],[3,"RepeatWith"],[3,"Successors"],[3,"Cloned"],[3,"Copied"],[3,"Flatten"],[3,"MapWhile"],[3,"StepBy"],[3,"Chain"],[3,"Cycle"],[3,"Enumerate"],[3,"Filter"],[3,"FilterMap"],[3,"Map"],[3,"Rev"],[3,"Zip"],[3,"FlatMap"],[3,"Scan"],[3,"Skip"],[3,"SkipWhile"],[3,"Take"],[3,"TakeWhile"],[3,"Fuse"],[3,"Inspect"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"NoneError"],[3,"Iter"],[3,"IterMut"],[3,"IntoIter"],[3,"Error"],[3,"Arguments"],[3,"BuildHasherDefault"],[3,"Split"],[3,"SplitInclusive"],[3,"SplitMut"],[3,"SplitInclusiveMut"],[3,"RSplit"],[3,"RSplitMut"],[3,"SplitN"],[3,"RSplitN"],[3,"SplitNMut"],[3,"RSplitNMut"],[3,"Windows"],[3,"Chunks"],[3,"ChunksMut"],[3,"RChunks"],[3,"RChunksMut"],[3,"ParseBoolError"],[3,"Bytes"],[3,"Split"],[3,"RSplit"],[3,"SplitTerminator"],[3,"RSplitTerminator"],[3,"SplitN"],[3,"RSplitN"],[3,"MatchIndices"],[3,"RMatchIndices"],[3,"Matches"],[3,"RMatches"],[3,"Lines"],[3,"LinesAny"],[3,"SplitWhitespace"],[3,"SplitAsciiWhitespace"],[3,"SplitInclusive"],[3,"EncodeUtf16"],[3,"EscapeDebug"],[3,"EscapeDefault"],[3,"EscapeUnicode"],[3,"CharSearcher"],[3,"CharSliceSearcher"],[3,"CharPredicateSearcher"],[3,"StrSearcher"],[3,"Utf8LossyChunksIter"],[3,"Pending"],[3,"Ready"],[3,"LayoutErr"],[3,"AllocErr"],[3,"SY"],[3,"APSR"],[3,"__m64"],[3,"__m128i"],[3,"__m128"],[3,"__m128d"],[3,"__m256i"],[3,"__m256"],[3,"__m256d"],[3,"__m512i"],[3,"__m512"],[3,"__m512d"],[3,"float64x1_t"],[3,"float64x2_t"],[3,"poly64x1_t"],[3,"poly64_t"],[3,"poly64x2_t"],[3,"poly128_t"],[3,"int8x8_t"],[3,"uint8x8_t"],[3,"poly8x8_t"],[3,"int16x4_t"],[3,"uint16x4_t"],[3,"poly16x4_t"],[3,"int32x2_t"],[3,"uint32x2_t"],[3,"float32x2_t"],[3,"int64x1_t"],[3,"uint64x1_t"],[3,"int8x16_t"],[3,"uint8x16_t"],[3,"poly8x16_t"],[3,"int16x8_t"],[3,"uint16x8_t"],[3,"poly16x8_t"],[3,"int32x4_t"],[3,"uint32x4_t"],[3,"float32x4_t"],[3,"int64x2_t"],[3,"uint64x2_t"],[3,"v128"],[3,"vector_signed_long"],[3,"vector_unsigned_long"],[3,"vector_bool_long"],[3,"vector_double"]],"a":{"!=":[697,700],"%":[792,804],"%=":[804],"&":[808],"&*":[836],"&=":[826],"*":[786,802,836,839],"*=":[802],"+":[780,798],"+=":[798],"-":[789,795,806],"-=":[806],"..":[750,753,755,756],"..=":[758,759],"/":[783,800],"/=":[800],"<":[701,706],"<<":[820],"<<=":[832],"<=":[701,706],"==":[697,700],">":[701,706],">=":[701,706],">>":[823],">>=":[834],"?":[859,5436],"[":[850,853],"[]":[850,853],"]":[850,853],"^":[814],"^=":[830],"memcpy":[396,647],"memmove":[397,648],"{:?}":[1515],"{}":[1517],"|":[811],"|=":[828]}},\
"proc_macro":{"doc":"A support library for macro authors when defining new…","i":[[3,"Diagnostic","proc_macro","A structure representing a diagnostic message and…",null,null],[3,"TokenStream","","The main type provided by this crate, representing an…",null,null],[3,"LexError","","Error returned from `TokenStream::from_str`.",null,null],[3,"Span","","A region of source code, along with macro expansion…",null,null],[3,"LineColumn","","A line-column pair representing the start or end of a…",null,null],[12,"line","","The 1-indexed line in the source file on which the span…",0,null],[12,"column","","The 0-indexed column (in UTF-8 characters) in the source…",0,null],[3,"SourceFile","","The source file of a given `Span`.",null,null],[3,"Group","","A delimited token stream.",null,null],[3,"Punct","","An `Punct` is an single punctuation character like `+`,…",null,null],[3,"Ident","","An identifier (`ident`).",null,null],[3,"Literal","","A literal string (`\\\"hello\\\"`), byte string (`b\\\"hello\\\"`),…",null,null],[4,"Level","","An enum representing a diagnostic level.",null,null],[13,"Error","","An error.",1,null],[13,"Warning","","A warning.",1,null],[13,"Note","","A note.",1,null],[13,"Help","","A help message.",1,null],[4,"TokenTree","","A single token or a delimited sequence of token trees…",null,null],[13,"Group","","A token stream surrounded by bracket delimiters.",2,null],[13,"Ident","","An identifier.",2,null],[13,"Punct","","A single punctuation character (`+`, `,`, `$`, etc.).",2,null],[13,"Literal","","A literal character (`\'a\'`), string (`\\\"hello\\\"`), number…",2,null],[4,"Delimiter","","Describes how a sequence of token trees is delimited.",null,null],[13,"Parenthesis","","`( ... )`",3,null],[13,"Brace","","`{ ... }`",3,null],[13,"Bracket","","`[ ... ]`",3,null],[13,"None","","`Ø ... Ø` An implicit delimiter, that may, for example,…",3,null],[4,"Spacing","","Whether an `Punct` is followed immediately by another…",null,null],[13,"Alone","","e.g., `+` is `Alone` in `+ =`, `+ident` or `+()`.",4,null],[13,"Joint","","e.g., `+` is `Joint` in `+=` or `\'#`. Additionally, single…",4,null],[5,"is_available","","Determines whether proc_macro has been made accessible to…",null,[[]]],[5,"quote","","Quote a `TokenStream` into a `TokenStream`. This is the…",null,[[["tokenstream",3]],["tokenstream",3]]],[5,"quote_span","","Quote a `Span` into a `TokenStream`. This is needed to…",null,[[["span",3]],["tokenstream",3]]],[11,"new","","Creates a new diagnostic with the given `level` and…",5,[[["into",8],["level",4],["string",3]],["diagnostic",3]]],[11,"spanned","","Creates a new diagnostic with the given `level` and…",5,[[["level",4]],["diagnostic",3]]],[11,"span_error","","Adds a new child diagnostic message to `self` with the…",5,[[],["diagnostic",3]]],[11,"error","","Adds a new child diagnostic message to `self` with the…",5,[[["into",8],["string",3]],["diagnostic",3]]],[11,"span_warning","","Adds a new child diagnostic message to `self` with the…",5,[[],["diagnostic",3]]],[11,"warning","","Adds a new child diagnostic message to `self` with the…",5,[[["into",8],["string",3]],["diagnostic",3]]],[11,"span_note","","Adds a new child diagnostic message to `self` with the…",5,[[],["diagnostic",3]]],[11,"note","","Adds a new child diagnostic message to `self` with the…",5,[[["into",8],["string",3]],["diagnostic",3]]],[11,"span_help","","Adds a new child diagnostic message to `self` with the…",5,[[],["diagnostic",3]]],[11,"help","","Adds a new child diagnostic message to `self` with the…",5,[[["into",8],["string",3]],["diagnostic",3]]],[11,"level","","Returns the diagnostic `level` for `self`.",5,[[],["level",4]]],[11,"set_level","","Sets the level in `self` to `level`.",5,[[["level",4]]]],[11,"message","","Returns the message in `self`.",5,[[]]],[11,"set_message","","Sets the message in `self` to `message`.",5,[[["into",8],["string",3]]]],[11,"spans","","Returns the `Span`s in `self`.",5,[[]]],[11,"set_spans","","Sets the `Span`s in `self` to `spans`.",5,[[["multispan",8]]]],[11,"children","","Returns an iterator over the children diagnostics of `self`.",5,[[],["children",3]]],[11,"emit","","Emit the diagnostic.",5,[[]]],[0,"token_stream","","Public implementation details for the `TokenStream` type,…",null,null],[3,"IntoIter","proc_macro::token_stream","An iterator over `TokenStream`\'s `TokenTree`s. The…",null,null],[8,"MultiSpan","proc_macro","Trait implemented by types that can be converted into a…",null,null],[10,"into_spans","","Converts `self` into a `Vec<Span>`.",6,[[],[["vec",3],["span",3]]]],[11,"new","","Returns an empty `TokenStream` containing no token trees.",7,[[],["tokenstream",3]]],[11,"is_empty","","Checks if this `TokenStream` is empty.",7,[[]]],[11,"def_site","","A span that resolves at the macro definition site.",8,[[],["span",3]]],[11,"call_site","","The span of the invocation of the current procedural…",8,[[],["span",3]]],[11,"mixed_site","","A span that represents `macro_rules` hygiene, and…",8,[[],["span",3]]],[11,"source_file","","The original source file into which this span points.",8,[[],["sourcefile",3]]],[11,"parent","","The `Span` for the tokens in the previous macro expansion…",8,[[],[["option",4],["span",3]]]],[11,"source","","The span for the origin source code that `self` was…",8,[[],["span",3]]],[11,"start","","Gets the starting line/column in the source file for this…",8,[[],["linecolumn",3]]],[11,"end","","Gets the ending line/column in the source file for this…",8,[[],["linecolumn",3]]],[11,"join","","Creates a new span encompassing `self` and `other`.",8,[[["span",3]],[["option",4],["span",3]]]],[11,"resolved_at","","Creates a new span with the same line/column information…",8,[[["span",3]],["span",3]]],[11,"located_at","","Creates a new span with the same name resolution behavior…",8,[[["span",3]],["span",3]]],[11,"eq","","Compares to spans to see if they\'re equal.",8,[[["span",3]]]],[11,"source_text","","Returns the source text behind a span. This preserves the…",8,[[],[["option",4],["string",3]]]],[11,"error","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",8],["string",3]],["diagnostic",3]]],[11,"warning","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",8],["string",3]],["diagnostic",3]]],[11,"note","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",8],["string",3]],["diagnostic",3]]],[11,"help","","Creates a new `Diagnostic` with the given `message` at the…",8,[[["into",8],["string",3]],["diagnostic",3]]],[11,"path","","Gets the path to this source file.",9,[[],["pathbuf",3]]],[11,"is_real","","Returns `true` if this source file is a real source file,…",9,[[]]],[11,"span","","Returns the span of this tree, delegating to the `span`…",2,[[],["span",3]]],[11,"set_span","","Configures the span for only this token.",2,[[["span",3]]]],[11,"new","","Creates a new `Group` with the given delimiter and token…",10,[[["delimiter",4],["tokenstream",3]],["group",3]]],[11,"delimiter","","Returns the delimiter of this `Group`",10,[[],["delimiter",4]]],[11,"stream","","Returns the `TokenStream` of tokens that are delimited in…",10,[[],["tokenstream",3]]],[11,"span","","Returns the span for the delimiters of this token stream,…",10,[[],["span",3]]],[11,"span_open","","Returns the span pointing to the opening delimiter of this…",10,[[],["span",3]]],[11,"span_close","","Returns the span pointing to the closing delimiter of this…",10,[[],["span",3]]],[11,"set_span","","Configures the span for this `Group`\'s delimiters, but not…",10,[[["span",3]]]],[11,"new","","Creates a new `Punct` from the given character and…",11,[[["spacing",4]],["punct",3]]],[11,"as_char","","Returns the value of this punctuation character as `char`.",11,[[]]],[11,"spacing","","Returns the spacing of this punctuation character,…",11,[[],["spacing",4]]],[11,"span","","Returns the span for this punctuation character.",11,[[],["span",3]]],[11,"set_span","","Configure the span for this punctuation character.",11,[[["span",3]]]],[11,"new","","Creates a new `Ident` with the given `string` as well as…",12,[[["span",3]],["ident",3]]],[11,"new_raw","","Same as `Ident::new`, but creates a raw identifier…",12,[[["span",3]],["ident",3]]],[11,"span","","Returns the span of this `Ident`, encompassing the entire…",12,[[],["span",3]]],[11,"set_span","","Configures the span of this `Ident`, possibly changing its…",12,[[["span",3]]]],[11,"u8_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"u16_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"u32_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"u64_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"u128_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"usize_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"i8_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"i16_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"i32_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"i64_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"i128_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"isize_suffixed","","Creates a new suffixed integer literal with the specified…",13,[[],["literal",3]]],[11,"u8_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"u16_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"u32_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"u64_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"u128_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"usize_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"i8_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"i16_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"i32_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"i64_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"i128_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"isize_unsuffixed","","Creates a new unsuffixed integer literal with the…",13,[[],["literal",3]]],[11,"f32_unsuffixed","","Creates a new unsuffixed floating-point literal.",13,[[],["literal",3]]],[11,"f32_suffixed","","Creates a new suffixed floating-point literal.",13,[[],["literal",3]]],[11,"f64_unsuffixed","","Creates a new unsuffixed floating-point literal.",13,[[],["literal",3]]],[11,"f64_suffixed","","Creates a new suffixed floating-point literal.",13,[[],["literal",3]]],[11,"string","","String literal.",13,[[],["literal",3]]],[11,"character","","Character literal.",13,[[],["literal",3]]],[11,"byte_string","","Byte string literal.",13,[[],["literal",3]]],[11,"span","","Returns the span encompassing this literal.",13,[[],["span",3]]],[11,"set_span","","Configures the span associated for this literal.",13,[[["span",3]]]],[11,"subspan","","Returns a `Span` that is a subset of `self.span()`…",13,[[["rangebounds",8]],[["option",4],["span",3]]]],[14,"quote","","`quote!(..)` accepts arbitrary tokens and expands into a…",null,null],[11,"from","","",5,[[]]],[11,"into","","",5,[[]]],[11,"to_owned","","",5,[[]]],[11,"clone_into","","",5,[[]]],[11,"try_from","","",5,[[],["result",4]]],[11,"try_into","","",5,[[],["result",4]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"from","","",7,[[]]],[11,"into","","",7,[[]]],[11,"into_iter","","",7,[[]]],[11,"to_owned","","",7,[[]]],[11,"clone_into","","",7,[[]]],[11,"to_string","","",7,[[],["string",3]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"from","","",14,[[]]],[11,"into","","",14,[[]]],[11,"to_string","","",14,[[],["string",3]]],[11,"try_from","","",14,[[],["result",4]]],[11,"try_into","","",14,[[],["result",4]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"from","","",8,[[]]],[11,"into","","",8,[[]]],[11,"to_owned","","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"try_into","","",8,[[],["result",4]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","","",0,[[]]],[11,"into","","",0,[[]]],[11,"to_owned","","",0,[[]]],[11,"clone_into","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"try_into","","",0,[[],["result",4]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"to_owned","","",9,[[]]],[11,"clone_into","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"to_string","","",10,[[],["string",3]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"from","","",11,[[]]],[11,"into","","",11,[[]]],[11,"to_owned","","",11,[[]]],[11,"clone_into","","",11,[[]]],[11,"to_string","","",11,[[],["string",3]]],[11,"try_from","","",11,[[],["result",4]]],[11,"try_into","","",11,[[],["result",4]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"from","","",12,[[]]],[11,"into","","",12,[[]]],[11,"to_owned","","",12,[[]]],[11,"clone_into","","",12,[[]]],[11,"to_string","","",12,[[],["string",3]]],[11,"try_from","","",12,[[],["result",4]]],[11,"try_into","","",12,[[],["result",4]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"from","","",13,[[]]],[11,"into","","",13,[[]]],[11,"to_owned","","",13,[[]]],[11,"clone_into","","",13,[[]]],[11,"to_string","","",13,[[],["string",3]]],[11,"try_from","","",13,[[],["result",4]]],[11,"try_into","","",13,[[],["result",4]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",1,[[]]],[11,"into","","",1,[[]]],[11,"to_owned","","",1,[[]]],[11,"clone_into","","",1,[[]]],[11,"try_from","","",1,[[],["result",4]]],[11,"try_into","","",1,[[],["result",4]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"from","","",2,[[]]],[11,"into","","",2,[[]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"to_string","","",2,[[],["string",3]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"from","","",3,[[]]],[11,"into","","",3,[[]]],[11,"to_owned","","",3,[[]]],[11,"clone_into","","",3,[[]]],[11,"try_from","","",3,[[],["result",4]]],[11,"try_into","","",3,[[],["result",4]]],[11,"borrow","","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"from","","",4,[[]]],[11,"into","","",4,[[]]],[11,"to_owned","","",4,[[]]],[11,"clone_into","","",4,[[]]],[11,"try_from","","",4,[[],["result",4]]],[11,"try_into","","",4,[[],["result",4]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"from","proc_macro::token_stream","",15,[[]]],[11,"into","","",15,[[]]],[11,"into_iter","","",15,[[]]],[11,"to_owned","","",15,[[]]],[11,"clone_into","","",15,[[]]],[11,"try_from","","",15,[[],["result",4]]],[11,"try_into","","",15,[[],["result",4]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"into_spans","proc_macro","",8,[[],[["vec",3],["span",3]]]],[11,"from","","",7,[[["tokentree",4]],["tokenstream",3]]],[11,"from","","",2,[[["group",3]],["tokentree",4]]],[11,"from","","",2,[[["ident",3]],["tokentree",4]]],[11,"from","","",2,[[["punct",3]],["tokentree",4]]],[11,"from","","",2,[[["literal",3]],["tokentree",4]]],[11,"extend","","",7,[[["intoiterator",8]]]],[11,"extend","","",7,[[["intoiterator",8]]]],[11,"into_iter","","",7,[[],["intoiter",3]]],[11,"next","proc_macro::token_stream","",15,[[],[["option",4],["tokentree",4]]]],[11,"clone","proc_macro","",1,[[],["level",4]]],[11,"clone","","",5,[[],["diagnostic",3]]],[11,"clone","","",7,[[],["tokenstream",3]]],[11,"clone","proc_macro::token_stream","",15,[[],["intoiter",3]]],[11,"clone","proc_macro","",8,[[],["span",3]]],[11,"clone","","",0,[[],["linecolumn",3]]],[11,"clone","","",9,[[],["sourcefile",3]]],[11,"clone","","",2,[[],["tokentree",4]]],[11,"clone","","",10,[[],["group",3]]],[11,"clone","","",3,[[],["delimiter",4]]],[11,"clone","","",11,[[],["punct",3]]],[11,"clone","","",4,[[],["spacing",4]]],[11,"clone","","",12,[[],["ident",3]]],[11,"clone","","",13,[[],["literal",3]]],[11,"default","","",7,[[]]],[11,"cmp","","",0,[[],["ordering",4]]],[11,"eq","","",0,[[["linecolumn",3]]]],[11,"ne","","",0,[[["linecolumn",3]]]],[11,"eq","","",9,[[]]],[11,"eq","","",3,[[["delimiter",4]]]],[11,"eq","","",4,[[["spacing",4]]]],[11,"partial_cmp","","",0,[[],[["option",4],["ordering",4]]]],[11,"to_string","","",7,[[],["string",3]]],[11,"to_string","","",2,[[],["string",3]]],[11,"to_string","","",10,[[],["string",3]]],[11,"to_string","","",11,[[],["string",3]]],[11,"to_string","","",12,[[],["string",3]]],[11,"to_string","","",13,[[],["string",3]]],[11,"fmt","","",1,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",2,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",2,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"from_iter","","",7,[[["intoiterator",8]]]],[11,"from_iter","","",7,[[["intoiterator",8]]]],[11,"from_str","","",7,[[],[["result",4],["tokenstream",3],["lexerror",3]]]]],"p":[[3,"LineColumn"],[4,"Level"],[4,"TokenTree"],[4,"Delimiter"],[4,"Spacing"],[3,"Diagnostic"],[8,"MultiSpan"],[3,"TokenStream"],[3,"Span"],[3,"SourceFile"],[3,"Group"],[3,"Punct"],[3,"Ident"],[3,"Literal"],[3,"LexError"],[3,"IntoIter"]]},\
"std":{"doc":"The Rust Standard Library","i":[[0,"borrow","std","A module for working with borrowed data.",null,null],[8,"ToOwned","std::borrow","A generalization of `Clone` to borrowed data.",null,null],[16,"Owned","","The resulting type after obtaining ownership.",0,null],[10,"to_owned","","Creates owned data from borrowed data, usually by cloning.",0,[[]]],[11,"clone_into","","Uses borrowed data to replace owned data, usually by…",0,[[]]],[4,"Cow","","A clone-on-write smart pointer.",null,null],[13,"Borrowed","","Borrowed data.",1,null],[13,"Owned","","Owned data.",1,null],[8,"Borrow","","A trait for borrowing data.",null,null],[10,"borrow","","Immutably borrows from an owned value.",2,[[]]],[8,"BorrowMut","","A trait for mutably borrowing data.",null,null],[10,"borrow_mut","","Mutably borrows from an owned value.",3,[[]]],[0,"boxed","std","A pointer type for heap allocation.",null,null],[3,"Box","std::boxed","A pointer type for heap allocation.",null,null],[0,"fmt","std","Utilities for formatting and printing `String`s.",null,null],[5,"format","std::fmt","The `format` function takes an [`Arguments`] struct and…",null,[[["arguments",3]],["string",3]]],[4,"Alignment","","Possible alignments returned by `Formatter::align`",null,null],[13,"Left","","Indication that contents should be left-aligned.",4,null],[13,"Right","","Indication that contents should be right-aligned.",4,null],[13,"Center","","Indication that contents should be center-aligned.",4,null],[3,"Error","","The error type which is returned from formatting a message…",null,null],[5,"write","","The `write` function takes an output stream, and an…",null,[[["write",8],["arguments",3]],[["error",3],["result",4]]]],[3,"Arguments","","This structure represents a safely precompiled version of…",null,null],[8,"Binary","","`b` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",5,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Octal","","`o` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",6,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Debug","","`?` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",7,[[["formatter",3]],[["error",3],["result",4]]]],[14,"Debug","","Derive macro generating an impl of the trait `Debug`.",null,null],[8,"Display","","Format trait for an empty format, `{}`.",null,null],[10,"fmt","","Formats the value using the given formatter.",8,[[["formatter",3]],[["error",3],["result",4]]]],[3,"DebugList","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugMap","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugSet","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugStruct","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"DebugTuple","","A struct to help with `fmt::Debug` implementations.",null,null],[3,"Formatter","","Configuration for formatting.",null,null],[6,"Result","","The type returned by formatter methods.",null,null],[8,"Write","","A collection of methods that are required to format a…",null,null],[10,"write_str","","Writes a string slice into this writer, returning whether…",9,[[],[["error",3],["result",4]]]],[11,"write_char","","Writes a [`char`] into this writer, returning whether the…",9,[[],[["error",3],["result",4]]]],[11,"write_fmt","","Glue for usage of the [`write!`] macro with implementors…",9,[[["arguments",3]],[["error",3],["result",4]]]],[8,"LowerExp","","`e` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",10,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperExp","","`E` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",11,[[["formatter",3]],[["error",3],["result",4]]]],[8,"LowerHex","","`x` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",12,[[["formatter",3]],[["error",3],["result",4]]]],[8,"Pointer","","`p` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",13,[[["formatter",3]],[["error",3],["result",4]]]],[8,"UpperHex","","`X` formatting.",null,null],[10,"fmt","","Formats the value using the given formatter.",14,[[["formatter",3]],[["error",3],["result",4]]]],[14,"format","std","Creates a `String` using interpolation of runtime…",null,null],[0,"rc","","Single-threaded reference-counting pointers. \'Rc\' stands…",null,null],[3,"Rc","std::rc","A single-threaded reference-counting pointer. \'Rc\' stands…",null,null],[3,"Weak","","`Weak` is a version of [`Rc`] that holds a non-owning…",null,null],[0,"slice","std","A dynamically-sized view into a contiguous sequence, `[T]`.",null,null],[8,"Concat","std::slice","Helper trait for `[T]::concat`.",null,null],[16,"Output","","The resulting type after concatenation",15,null],[10,"concat","","Implementation of `[T]::concat`",15,[[]]],[8,"Join","","Helper trait for `[T]::join`",null,null],[16,"Output","","The resulting type after concatenation",16,null],[10,"join","","Implementation of `[T]::join`",16,[[]]],[8,"SliceIndex","","A helper trait used for indexing operations.",null,null],[16,"Output","","The output type returned by methods.",17,null],[10,"get","","Returns a shared reference to the output at this location,…",17,[[],["option",4]]],[10,"get_mut","","Returns a mutable reference to the output at this…",17,[[],["option",4]]],[10,"get_unchecked","","Returns a shared reference to the output at this location,…",17,[[]]],[10,"get_unchecked_mut","","Returns a mutable reference to the output at this…",17,[[]]],[10,"index","","Returns a shared reference to the output at this location,…",17,[[]]],[10,"index_mut","","Returns a mutable reference to the output at this…",17,[[]]],[5,"from_mut","","Converts a reference to T into a slice of length 1…",null,[[]]],[5,"from_ref","","Converts a reference to T into a slice of length 1…",null,[[]]],[5,"from_raw_parts","","Forms a slice from a pointer and a length.",null,[[]]],[5,"from_raw_parts_mut","","Performs the same functionality as [`from_raw_parts`],…",null,[[]]],[3,"Chunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"Windows","","An iterator over overlapping subslices of length `size`.",null,null],[3,"ChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"ChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"ChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"Split","","An iterator over subslices separated by elements that…",null,null],[3,"SplitMut","","An iterator over the mutable subslices of the vector which…",null,null],[3,"Iter","","Immutable slice iterator",null,null],[3,"IterMut","","Mutable slice iterator.",null,null],[3,"RChunks","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExact","","An iterator over a slice in (non-overlapping) chunks…",null,null],[3,"RChunksExactMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RChunksMut","","An iterator over a slice in (non-overlapping) mutable…",null,null],[3,"RSplit","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitMut","","An iterator over the subslices of the vector which are…",null,null],[3,"RSplitN","","An iterator over subslices separated by elements that…",null,null],[3,"RSplitNMut","","An iterator over subslices separated by elements that…",null,null],[3,"SplitN","","An iterator over subslices separated by elements that…",null,null],[3,"SplitNMut","","An iterator over subslices separated by elements that…",null,null],[0,"str","std","Unicode string slices.",null,null],[5,"from_boxed_utf8_unchecked","std::str","Converts a boxed slice of bytes to a boxed string slice…",null,[[["box",3]],["box",3]]],[0,"pattern","","The string Pattern API.",null,null],[8,"Pattern","std::str::pattern","A string pattern.",null,null],[16,"Searcher","","Associated searcher for this pattern",18,null],[10,"into_searcher","","Constructs the associated searcher from `self` and the…",18,[[]]],[11,"is_contained_in","","Checks whether the pattern matches anywhere in the haystack",18,[[]]],[11,"is_prefix_of","","Checks whether the pattern matches at the front of the…",18,[[]]],[11,"strip_prefix_of","","Removes the pattern from the front of haystack, if it…",18,[[],["option",4]]],[11,"is_suffix_of","","Checks whether the pattern matches at the back of the…",18,[[]]],[11,"strip_suffix_of","","Removes the pattern from the back of haystack, if it…",18,[[],["option",4]]],[4,"SearchStep","","Result of calling `Searcher::next()` or…",null,null],[13,"Match","","Expresses that a match of the pattern has been found at…",19,null],[13,"Reject","","Expresses that `haystack[a..b]` has been rejected as a…",19,null],[13,"Done","","Expresses that every byte of the haystack has been…",19,null],[8,"Searcher","","A searcher for a string pattern.",null,null],[10,"haystack","","Getter for the underlying string to be searched in",20,[[]]],[10,"next","","Performs the next search step starting from the front.",20,[[],["searchstep",4]]],[11,"next_match","","Finds the next `Match` result. See `next()`",20,[[],["option",4]]],[11,"next_reject","","Finds the next `Reject` result. See `next()` and…",20,[[],["option",4]]],[8,"ReverseSearcher","","A reverse searcher for a string pattern.",null,null],[10,"next_back","","Performs the next search step starting from the back.",21,[[],["searchstep",4]]],[11,"next_match_back","","Finds the next `Match` result. See `next_back()`",21,[[],["option",4]]],[11,"next_reject_back","","Finds the next `Reject` result. See `next_back()`",21,[[],["option",4]]],[8,"DoubleEndedSearcher","","A marker trait to express that a `ReverseSearcher` can be…",null,null],[3,"CharSearcher","","Associated type for `<char as Pattern<\'a>>::Searcher`.",null,null],[3,"CharSliceSearcher","","Associated type for `<&[char] as Pattern<\'a>>::Searcher`.",null,null],[3,"CharPredicateSearcher","","Associated type for `<F as Pattern<\'a>>::Searcher`.",null,null],[3,"StrSearcher","","Associated type for `<&str as Pattern<\'a>>::Searcher`.",null,null],[3,"EncodeUtf16","std::str","An iterator of [`u16`] over the string encoded as UTF-16.",null,null],[3,"SplitAsciiWhitespace","","An iterator over the non-ASCII-whitespace substrings of a…",null,null],[3,"SplitWhitespace","","An iterator over the non-whitespace substrings of a…",null,null],[5,"from_utf8","","Converts a slice of bytes to a string slice.",null,[[],[["result",4],["utf8error",3]]]],[5,"from_utf8_mut","","Converts a mutable slice of bytes to a mutable string slice.",null,[[],[["result",4],["utf8error",3]]]],[3,"Bytes","","An iterator over the bytes of a string slice.",null,null],[3,"CharIndices","","An iterator over the [`char`]s of a string slice, and…",null,null],[3,"Chars","","An iterator over the [`char`]s of a string slice.",null,null],[5,"from_utf8_unchecked","","Converts a slice of bytes to a string slice without…",null,[[]]],[5,"from_utf8_unchecked_mut","","Converts a slice of bytes to a string slice without…",null,[[]]],[3,"ParseBoolError","","An error returned when parsing a `bool` using [`from_str`]…",null,null],[3,"EscapeDebug","","The return type of [`str::escape_debug`].",null,null],[3,"EscapeDefault","","The return type of [`str::escape_default`].",null,null],[3,"EscapeUnicode","","The return type of [`str::escape_unicode`].",null,null],[8,"FromStr","","Parse a value from a string",null,null],[16,"Err","","The associated error which can be returned from parsing.",22,null],[10,"from_str","","Parses a string `s` to return a value of this type.",22,[[],["result",4]]],[3,"Utf8Error","","Errors which can occur when attempting to interpret a…",null,null],[3,"Lines","","An iterator over the lines of a string, as string slices.",null,null],[3,"LinesAny","","Created with the method [`lines_any`].",null,null],[3,"MatchIndices","","Created with the method [`match_indices`].",null,null],[3,"RMatchIndices","","Created with the method [`rmatch_indices`].",null,null],[3,"Matches","","Created with the method [`matches`].",null,null],[3,"RMatches","","Created with the method [`rmatches`].",null,null],[3,"RSplit","","Created with the method [`rsplit`].",null,null],[3,"Split","","Created with the method [`split`].",null,null],[3,"RSplitN","","Created with the method [`rsplitn`].",null,null],[3,"SplitN","","Created with the method [`splitn`].",null,null],[3,"RSplitTerminator","","Created with the method [`rsplit_terminator`].",null,null],[3,"SplitTerminator","","Created with the method [`split_terminator`].",null,null],[0,"string","std","A UTF-8 encoded, growable string.",null,null],[3,"String","std::string","A UTF-8 encoded, growable string.",null,null],[3,"FromUtf8Error","","A possible error value when converting a `String` from a…",null,null],[3,"FromUtf16Error","","A possible error value when converting a `String` from a…",null,null],[6,"ParseError","","A type alias for [`Infallible`].",null,null],[8,"ToString","","A trait for converting a value to a `String`.",null,null],[10,"to_string","","Converts the given value to a `String`.",23,[[],["string",3]]],[3,"Drain","","A draining iterator for `String`.",null,null],[0,"vec","std","A contiguous growable array type with heap-allocated…",null,null],[3,"Vec","std::vec","A contiguous growable array type, written `Vec<T>` but…",null,null],[3,"IntoIter","","An iterator that moves out of a vector.",null,null],[3,"Drain","","A draining iterator for `Vec<T>`.",null,null],[3,"Splice","","A splicing iterator for `Vec`.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on Vec.",null,null],[14,"vec","std","Creates a [`Vec`] containing the arguments.",null,null],[0,"any","","This module implements the `Any` trait, which enables…",null,null],[8,"Any","std::any","A trait to emulate dynamic typing.",null,null],[10,"type_id","","Gets the `TypeId` of `self`.",24,[[],["typeid",3]]],[3,"TypeId","","A `TypeId` represents a globally unique identifier for a…",null,null],[5,"type_name","","Returns the name of a type as a string slice.",null,[[]]],[5,"type_name_of_val","","Returns the name of the type of the pointed-to value as a…",null,[[]]],[0,"array","std","Implementations of things like `Eq` for fixed-length…",null,null],[8,"FixedSizeArray","std::array","Utility trait implemented only on arrays of fixed size",null,null],[10,"as_slice","","Converts the array to immutable slice",25,[[]]],[10,"as_mut_slice","","Converts the array to mutable slice",25,[[]]],[3,"TryFromSliceError","","The error type returned when a conversion from a slice to…",null,null],[8,"LengthAtMost32","","Implemented for lengths where trait impls are allowed on…",null,null],[3,"IntoIter","","A by-value [array] iterator.",null,null],[0,"cell","std","Shareable mutable containers.",null,null],[3,"Cell","std::cell","A mutable memory location.",null,null],[3,"RefCell","","A mutable memory location with dynamically checked borrow…",null,null],[3,"BorrowError","","An error returned by `RefCell::try_borrow`.",null,null],[3,"BorrowMutError","","An error returned by `RefCell::try_borrow_mut`.",null,null],[3,"Ref","","Wraps a borrowed reference to a value in a `RefCell` box.…",null,null],[3,"RefMut","","A wrapper type for a mutably borrowed value from a…",null,null],[3,"UnsafeCell","","The core primitive for interior mutability in Rust.",null,null],[0,"char","std","A character type.",null,null],[17,"MAX","std::char","The highest valid code point a `char` can have.",null,null],[17,"REPLACEMENT_CHARACTER","","`U+FFFD REPLACEMENT CHARACTER` (�) is used in Unicode to…",null,null],[3,"EscapeUnicode","","Returns an iterator that yields the hexadecimal Unicode…",null,null],[3,"EscapeDefault","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"EscapeDebug","","An iterator that yields the literal escape code of a `char`.",null,null],[3,"ToLowercase","","Returns an iterator that yields the lowercase equivalent…",null,null],[3,"ToUppercase","","Returns an iterator that yields the uppercase equivalent…",null,null],[5,"from_u32_unchecked","","Converts a `u32` to a `char`, ignoring validity.",null,[[]]],[3,"CharTryFromError","","The error type returned when a conversion from u32 to char…",null,null],[3,"ParseCharError","","An error which can be returned when parsing a char.",null,null],[5,"from_digit","","Converts a digit in the given radix to a `char`.",null,[[],["option",4]]],[5,"from_u32","","Converts a `u32` to a `char`.",null,[[],["option",4]]],[5,"decode_utf16","","Creates an iterator over the UTF-16 encoded code points in…",null,[[],["decodeutf16",3]]],[3,"DecodeUtf16","","An iterator that decodes UTF-16 encoded code points from…",null,null],[3,"DecodeUtf16Error","","An error that can be returned when decoding UTF-16 code…",null,null],[17,"UNICODE_VERSION","","The version of Unicode that the Unicode parts of `char`…",null,null],[0,"clone","std","The `Clone` trait for types that cannot be \'implicitly…",null,null],[8,"Clone","std::clone","A common trait for the ability to explicitly duplicate an…",null,null],[10,"clone","","Returns a copy of the value.",26,[[]]],[11,"clone_from","","Performs copy-assignment from `source`.",26,[[]]],[14,"Clone","","Derive macro generating an impl of the trait `Clone`.",null,null],[0,"cmp","std","Functionality for ordering and comparison.",null,null],[8,"PartialEq","std::cmp","Trait for equality comparisons which are partial…",null,null],[10,"eq","","This method tests for `self` and `other` values to be…",27,[[]]],[11,"ne","","This method tests for `!=`.",27,[[]]],[8,"Eq","","Trait for equality comparisons which are equivalence…",null,null],[4,"Ordering","","An `Ordering` is the result of a comparison between two…",null,null],[13,"Less","","An ordering where a compared value is less than another.",28,null],[13,"Equal","","An ordering where a compared value is equal to another.",28,null],[13,"Greater","","An ordering where a compared value is greater than another.",28,null],[3,"Reverse","","A helper struct for reverse ordering.",null,null],[12,"0","","",29,null],[8,"Ord","","Trait for types that form a total order.",null,null],[10,"cmp","","This method returns an [`Ordering`] between `self` and…",30,[[],["ordering",4]]],[11,"max","","Compares and returns the maximum of two values.",30,[[]]],[11,"min","","Compares and returns the minimum of two values.",30,[[]]],[11,"clamp","","Restrict a value to a certain interval.",30,[[]]],[8,"PartialOrd","","Trait for values that can be compared for a sort-order.",null,null],[10,"partial_cmp","","This method returns an ordering between `self` and `other`…",31,[[],[["ordering",4],["option",4]]]],[11,"lt","","This method tests less than (for `self` and `other`) and…",31,[[]]],[11,"le","","This method tests less than or equal to (for `self` and…",31,[[]]],[11,"gt","","This method tests greater than (for `self` and `other`)…",31,[[]]],[11,"ge","","This method tests greater than or equal to (for `self` and…",31,[[]]],[5,"min","","Compares and returns the minimum of two values.",null,[[]]],[5,"min_by","","Returns the minimum of two values with respect to the…",null,[[]]],[5,"min_by_key","","Returns the element that gives the minimum value from the…",null,[[]]],[5,"max","","Compares and returns the maximum of two values.",null,[[]]],[5,"max_by","","Returns the maximum of two values with respect to the…",null,[[]]],[5,"max_by_key","","Returns the element that gives the maximum value from the…",null,[[]]],[14,"PartialEq","","Derive macro generating an impl of the trait `PartialEq`.",null,null],[14,"Eq","","Derive macro generating an impl of the trait `Eq`.",null,null],[14,"Ord","","Derive macro generating an impl of the trait `Ord`.",null,null],[14,"PartialOrd","","Derive macro generating an impl of the trait `PartialOrd`.",null,null],[0,"convert","std","Traits for conversions between types.",null,null],[5,"identity","std::convert","The identity function.",null,[[]]],[8,"AsRef","","Used to do a cheap reference-to-reference conversion.",null,null],[10,"as_ref","","Performs the conversion.",32,[[]]],[8,"AsMut","","Used to do a cheap mutable-to-mutable reference conversion.",null,null],[10,"as_mut","","Performs the conversion.",33,[[]]],[8,"Into","","A value-to-value conversion that consumes the input value.…",null,null],[10,"into","","Performs the conversion.",34,[[]]],[8,"From","","Used to do value-to-value conversions while consuming the…",null,null],[10,"from","","Performs the conversion.",35,[[]]],[8,"TryInto","","An attempted conversion that consumes `self`, which may or…",null,null],[16,"Error","","The type returned in the event of a conversion error.",36,null],[10,"try_into","","Performs the conversion.",36,[[],["result",4]]],[8,"TryFrom","","Simple and safe type conversions that may fail in a…",null,null],[16,"Error","","The type returned in the event of a conversion error.",37,null],[10,"try_from","","Performs the conversion.",37,[[],["result",4]]],[4,"Infallible","","The error type for errors that can never happen.",null,null],[8,"FloatToInt","","Supporting trait for inherent methods of `f32` and `f64`…",null,null],[0,"default","std","The `Default` trait for types which may have meaningful…",null,null],[8,"Default","std::default","A trait for giving a type a useful default value.",null,null],[10,"default","","Returns the \\\"default value\\\" for a type.",38,[[]]],[14,"Default","","Derive macro generating an impl of the trait `Default`.",null,null],[0,"hash","std","Generic hashing support.",null,null],[8,"Hash","std::hash","A hashable type.",null,null],[10,"hash","","Feeds this value into the given [`Hasher`].",39,[[]]],[11,"hash_slice","","Feeds a slice of this type into the given [`Hasher`].",39,[[]]],[8,"Hasher","","A trait for hashing an arbitrary stream of bytes.",null,null],[10,"finish","","Returns the hash value for the values written so far.",40,[[]]],[10,"write","","Writes some data into this `Hasher`.",40,[[]]],[11,"write_u8","","Writes a single `u8` into this hasher.",40,[[]]],[11,"write_u16","","Writes a single `u16` into this hasher.",40,[[]]],[11,"write_u32","","Writes a single `u32` into this hasher.",40,[[]]],[11,"write_u64","","Writes a single `u64` into this hasher.",40,[[]]],[11,"write_u128","","Writes a single `u128` into this hasher.",40,[[]]],[11,"write_usize","","Writes a single `usize` into this hasher.",40,[[]]],[11,"write_i8","","Writes a single `i8` into this hasher.",40,[[]]],[11,"write_i16","","Writes a single `i16` into this hasher.",40,[[]]],[11,"write_i32","","Writes a single `i32` into this hasher.",40,[[]]],[11,"write_i64","","Writes a single `i64` into this hasher.",40,[[]]],[11,"write_i128","","Writes a single `i128` into this hasher.",40,[[]]],[11,"write_isize","","Writes a single `isize` into this hasher.",40,[[]]],[8,"BuildHasher","","A trait for creating instances of [`Hasher`].",null,null],[16,"Hasher","","Type of the hasher that will be created.",41,null],[10,"build_hasher","","Creates a new hasher.",41,[[]]],[3,"BuildHasherDefault","","Used to create a default [`BuildHasher`] instance for…",null,null],[3,"SipHasher","","An implementation of SipHash 2-4.",null,null],[14,"Hash","","Derive macro generating an impl of the trait `Hash`.",null,null],[0,"hint","std","Hints to compiler that affects how code should be emitted…",null,null],[5,"unreachable_unchecked","std::hint","Informs the compiler that this point in the code is not…",null,[[]]],[5,"spin_loop","","Emits a machine instruction hinting to the processor that…",null,[[]]],[5,"black_box","","An identity function that hints to the compiler to be…",null,[[]]],[0,"i128","std","The 128-bit signed integer type.",null,null],[17,"MIN","std::i128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i16","std","The 16-bit signed integer type.",null,null],[17,"MIN","std::i16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i32","std","The 32-bit signed integer type.",null,null],[17,"MIN","std::i32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i64","std","The 64-bit signed integer type.",null,null],[17,"MIN","std::i64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"i8","std","The 8-bit signed integer type.",null,null],[17,"MIN","std::i8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"intrinsics","std","Compiler intrinsics.",null,null],[5,"atomic_cxchg","std::intrinsics","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_acq","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_rel","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_acqrel","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_relaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_failacq","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchg_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_acq","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_rel","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_acqrel","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_relaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_failacq","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_acq_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_cxchgweak_acqrel_failrelaxed","","Stores a value if the current value is the same as the…",null,[[]]],[5,"atomic_load","","Loads the current value of the pointer.",null,[[]]],[5,"atomic_load_acq","","Loads the current value of the pointer.",null,[[]]],[5,"atomic_load_relaxed","","Loads the current value of the pointer.",null,[[]]],[5,"atomic_load_unordered","","",null,[[]]],[5,"atomic_store","","Stores the value at the specified memory location.",null,[[]]],[5,"atomic_store_rel","","Stores the value at the specified memory location.",null,[[]]],[5,"atomic_store_relaxed","","Stores the value at the specified memory location.",null,[[]]],[5,"atomic_store_unordered","","",null,[[]]],[5,"atomic_xchg","","Stores the value at the specified memory location,…",null,[[]]],[5,"atomic_xchg_acq","","Stores the value at the specified memory location,…",null,[[]]],[5,"atomic_xchg_rel","","Stores the value at the specified memory location,…",null,[[]]],[5,"atomic_xchg_acqrel","","Stores the value at the specified memory location,…",null,[[]]],[5,"atomic_xchg_relaxed","","Stores the value at the specified memory location,…",null,[[]]],[5,"atomic_xadd","","Adds to the current value, returning the previous value.",null,[[]]],[5,"atomic_xadd_acq","","Adds to the current value, returning the previous value.",null,[[]]],[5,"atomic_xadd_rel","","Adds to the current value, returning the previous value.",null,[[]]],[5,"atomic_xadd_acqrel","","Adds to the current value, returning the previous value.",null,[[]]],[5,"atomic_xadd_relaxed","","Adds to the current value, returning the previous value.",null,[[]]],[5,"atomic_xsub","","Subtract from the current value, returning the previous…",null,[[]]],[5,"atomic_xsub_acq","","Subtract from the current value, returning the previous…",null,[[]]],[5,"atomic_xsub_rel","","Subtract from the current value, returning the previous…",null,[[]]],[5,"atomic_xsub_acqrel","","Subtract from the current value, returning the previous…",null,[[]]],[5,"atomic_xsub_relaxed","","Subtract from the current value, returning the previous…",null,[[]]],[5,"atomic_and","","Bitwise and with the current value, returning the previous…",null,[[]]],[5,"atomic_and_acq","","Bitwise and with the current value, returning the previous…",null,[[]]],[5,"atomic_and_rel","","Bitwise and with the current value, returning the previous…",null,[[]]],[5,"atomic_and_acqrel","","Bitwise and with the current value, returning the previous…",null,[[]]],[5,"atomic_and_relaxed","","Bitwise and with the current value, returning the previous…",null,[[]]],[5,"atomic_nand","","Bitwise nand with the current value, returning the…",null,[[]]],[5,"atomic_nand_acq","","Bitwise nand with the current value, returning the…",null,[[]]],[5,"atomic_nand_rel","","Bitwise nand with the current value, returning the…",null,[[]]],[5,"atomic_nand_acqrel","","Bitwise nand with the current value, returning the…",null,[[]]],[5,"atomic_nand_relaxed","","Bitwise nand with the current value, returning the…",null,[[]]],[5,"atomic_or","","Bitwise or with the current value, returning the previous…",null,[[]]],[5,"atomic_or_acq","","Bitwise or with the current value, returning the previous…",null,[[]]],[5,"atomic_or_rel","","Bitwise or with the current value, returning the previous…",null,[[]]],[5,"atomic_or_acqrel","","Bitwise or with the current value, returning the previous…",null,[[]]],[5,"atomic_or_relaxed","","Bitwise or with the current value, returning the previous…",null,[[]]],[5,"atomic_xor","","Bitwise xor with the current value, returning the previous…",null,[[]]],[5,"atomic_xor_acq","","Bitwise xor with the current value, returning the previous…",null,[[]]],[5,"atomic_xor_rel","","Bitwise xor with the current value, returning the previous…",null,[[]]],[5,"atomic_xor_acqrel","","Bitwise xor with the current value, returning the previous…",null,[[]]],[5,"atomic_xor_relaxed","","Bitwise xor with the current value, returning the previous…",null,[[]]],[5,"atomic_max","","Maximum with the current value using a signed comparison.",null,[[]]],[5,"atomic_max_acq","","Maximum with the current value using a signed comparison.",null,[[]]],[5,"atomic_max_rel","","Maximum with the current value using a signed comparison.",null,[[]]],[5,"atomic_max_acqrel","","Maximum with the current value using a signed comparison.",null,[[]]],[5,"atomic_max_relaxed","","Maximum with the current value.",null,[[]]],[5,"atomic_min","","Minimum with the current value using a signed comparison.",null,[[]]],[5,"atomic_min_acq","","Minimum with the current value using a signed comparison.",null,[[]]],[5,"atomic_min_rel","","Minimum with the current value using a signed comparison.",null,[[]]],[5,"atomic_min_acqrel","","Minimum with the current value using a signed comparison.",null,[[]]],[5,"atomic_min_relaxed","","Minimum with the current value using a signed comparison.",null,[[]]],[5,"atomic_umin","","Minimum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umin_acq","","Minimum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umin_rel","","Minimum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umin_acqrel","","Minimum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umin_relaxed","","Minimum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umax","","Maximum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umax_acq","","Maximum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umax_rel","","Maximum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umax_acqrel","","Maximum with the current value using an unsigned comparison.",null,[[]]],[5,"atomic_umax_relaxed","","Maximum with the current value using an unsigned comparison.",null,[[]]],[5,"prefetch_read_data","","The `prefetch` intrinsic is a hint to the code generator…",null,[[]]],[5,"prefetch_write_data","","The `prefetch` intrinsic is a hint to the code generator…",null,[[]]],[5,"prefetch_read_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,[[]]],[5,"prefetch_write_instruction","","The `prefetch` intrinsic is a hint to the code generator…",null,[[]]],[5,"atomic_fence","","An atomic fence.",null,[[]]],[5,"atomic_fence_acq","","An atomic fence.",null,[[]]],[5,"atomic_fence_rel","","An atomic fence.",null,[[]]],[5,"atomic_fence_acqrel","","An atomic fence.",null,[[]]],[5,"atomic_singlethreadfence","","A compiler-only memory barrier.",null,[[]]],[5,"atomic_singlethreadfence_acq","","A compiler-only memory barrier.",null,[[]]],[5,"atomic_singlethreadfence_rel","","A compiler-only memory barrier.",null,[[]]],[5,"atomic_singlethreadfence_acqrel","","A compiler-only memory barrier.",null,[[]]],[5,"rustc_peek","","Magic intrinsic that derives its meaning from attributes…",null,[[]]],[5,"abort","","Aborts the execution of the process.",null,[[]]],[5,"unreachable","","Tells LLVM that this point in the code is not reachable,…",null,[[]]],[5,"assume","","Informs the optimizer that a condition is always true. If…",null,[[]]],[5,"likely","","Hints to the compiler that branch condition is likely to…",null,[[]]],[5,"unlikely","","Hints to the compiler that branch condition is likely to…",null,[[]]],[5,"breakpoint","","Executes a breakpoint trap, for inspection by a debugger.",null,[[]]],[5,"size_of","","The size of a type in bytes.",null,[[]]],[5,"move_val_init","","Moves a value to an uninitialized memory location.",null,[[]]],[5,"min_align_of","","The minimum alignment of a type.",null,[[]]],[5,"pref_align_of","","The prefered alignment of a type.",null,[[]]],[5,"size_of_val","","The size of the referenced value in bytes.",null,[[]]],[5,"min_align_of_val","","The required alignment of the referenced value.",null,[[]]],[5,"type_name","","Gets a static string slice containing the name of a type.",null,[[]]],[5,"type_id","","Gets an identifier which is globally unique to the…",null,[[]]],[5,"assert_inhabited","","A guard for unsafe functions that cannot ever be executed…",null,[[]]],[5,"assert_zero_valid","","A guard for unsafe functions that cannot ever be executed…",null,[[]]],[5,"assert_uninit_valid","","A guard for unsafe functions that cannot ever be executed…",null,[[]]],[5,"caller_location","","Gets a reference to a static `Location` indicating where…",null,[[],["location",3]]],[5,"forget","","Moves a value out of scope without running drop glue.",null,[[]]],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,[[]]],[5,"needs_drop","","Returns `true` if the actual type given as `T` requires…",null,[[]]],[5,"offset","","Calculates the offset from a pointer.",null,[[]]],[5,"arith_offset","","Calculates the offset from a pointer, potentially wrapping.",null,[[]]],[5,"volatile_copy_nonoverlapping_memory","","Equivalent to the appropriate `llvm.memcpy.p0i8.0i8.*`…",null,[[]]],[5,"volatile_copy_memory","","Equivalent to the appropriate `llvm.memmove.p0i8.0i8.*`…",null,[[]]],[5,"volatile_set_memory","","Equivalent to the appropriate `llvm.memset.p0i8.*`…",null,[[]]],[5,"volatile_load","","Performs a volatile load from the `src` pointer.",null,[[]]],[5,"volatile_store","","Performs a volatile store to the `dst` pointer.",null,[[]]],[5,"unaligned_volatile_load","","Performs a volatile load from the `src` pointer The…",null,[[]]],[5,"unaligned_volatile_store","","Performs a volatile store to the `dst` pointer. The…",null,[[]]],[5,"sqrtf32","","Returns the square root of an `f32`",null,[[]]],[5,"sqrtf64","","Returns the square root of an `f64`",null,[[]]],[5,"powif32","","Raises an `f32` to an integer power.",null,[[]]],[5,"powif64","","Raises an `f64` to an integer power.",null,[[]]],[5,"sinf32","","Returns the sine of an `f32`.",null,[[]]],[5,"sinf64","","Returns the sine of an `f64`.",null,[[]]],[5,"cosf32","","Returns the cosine of an `f32`.",null,[[]]],[5,"cosf64","","Returns the cosine of an `f64`.",null,[[]]],[5,"powf32","","Raises an `f32` to an `f32` power.",null,[[]]],[5,"powf64","","Raises an `f64` to an `f64` power.",null,[[]]],[5,"expf32","","Returns the exponential of an `f32`.",null,[[]]],[5,"expf64","","Returns the exponential of an `f64`.",null,[[]]],[5,"exp2f32","","Returns 2 raised to the power of an `f32`.",null,[[]]],[5,"exp2f64","","Returns 2 raised to the power of an `f64`.",null,[[]]],[5,"logf32","","Returns the natural logarithm of an `f32`.",null,[[]]],[5,"logf64","","Returns the natural logarithm of an `f64`.",null,[[]]],[5,"log10f32","","Returns the base 10 logarithm of an `f32`.",null,[[]]],[5,"log10f64","","Returns the base 10 logarithm of an `f64`.",null,[[]]],[5,"log2f32","","Returns the base 2 logarithm of an `f32`.",null,[[]]],[5,"log2f64","","Returns the base 2 logarithm of an `f64`.",null,[[]]],[5,"fmaf32","","Returns `a * b + c` for `f32` values.",null,[[]]],[5,"fmaf64","","Returns `a * b + c` for `f64` values.",null,[[]]],[5,"fabsf32","","Returns the absolute value of an `f32`.",null,[[]]],[5,"fabsf64","","Returns the absolute value of an `f64`.",null,[[]]],[5,"minnumf32","","Returns the minimum of two `f32` values.",null,[[]]],[5,"minnumf64","","Returns the minimum of two `f64` values.",null,[[]]],[5,"maxnumf32","","Returns the maximum of two `f32` values.",null,[[]]],[5,"maxnumf64","","Returns the maximum of two `f64` values.",null,[[]]],[5,"copysignf32","","Copies the sign from `y` to `x` for `f32` values.",null,[[]]],[5,"copysignf64","","Copies the sign from `y` to `x` for `f64` values.",null,[[]]],[5,"floorf32","","Returns the largest integer less than or equal to an `f32`.",null,[[]]],[5,"floorf64","","Returns the largest integer less than or equal to an `f64`.",null,[[]]],[5,"ceilf32","","Returns the smallest integer greater than or equal to an…",null,[[]]],[5,"ceilf64","","Returns the smallest integer greater than or equal to an…",null,[[]]],[5,"truncf32","","Returns the integer part of an `f32`.",null,[[]]],[5,"truncf64","","Returns the integer part of an `f64`.",null,[[]]],[5,"rintf32","","Returns the nearest integer to an `f32`. May raise an…",null,[[]]],[5,"rintf64","","Returns the nearest integer to an `f64`. May raise an…",null,[[]]],[5,"nearbyintf32","","Returns the nearest integer to an `f32`.",null,[[]]],[5,"nearbyintf64","","Returns the nearest integer to an `f64`.",null,[[]]],[5,"roundf32","","Returns the nearest integer to an `f32`. Rounds half-way…",null,[[]]],[5,"roundf64","","Returns the nearest integer to an `f64`. Rounds half-way…",null,[[]]],[5,"fadd_fast","","Float addition that allows optimizations based on…",null,[[]]],[5,"fsub_fast","","Float subtraction that allows optimizations based on…",null,[[]]],[5,"fmul_fast","","Float multiplication that allows optimizations based on…",null,[[]]],[5,"fdiv_fast","","Float division that allows optimizations based on…",null,[[]]],[5,"frem_fast","","Float remainder that allows optimizations based on…",null,[[]]],[5,"float_to_int_unchecked","","Convert with LLVM’s fptoui/fptosi, which may return undef…",null,[[]]],[5,"ctpop","","Returns the number of bits set in an integer type `T`",null,[[]]],[5,"ctlz","","Returns the number of leading unset bits (zeroes) in an…",null,[[]]],[5,"ctlz_nonzero","","Like `ctlz`, but extra-unsafe as it returns `undef` when…",null,[[]]],[5,"cttz","","Returns the number of trailing unset bits (zeroes) in an…",null,[[]]],[5,"cttz_nonzero","","Like `cttz`, but extra-unsafe as it returns `undef` when…",null,[[]]],[5,"bswap","","Reverses the bytes in an integer type `T`.",null,[[]]],[5,"bitreverse","","Reverses the bits in an integer type `T`.",null,[[]]],[5,"add_with_overflow","","Performs checked integer addition.",null,[[]]],[5,"sub_with_overflow","","Performs checked integer subtraction",null,[[]]],[5,"mul_with_overflow","","Performs checked integer multiplication",null,[[]]],[5,"exact_div","","Performs an exact division, resulting in undefined…",null,[[]]],[5,"unchecked_div","","Performs an unchecked division, resulting in undefined…",null,[[]]],[5,"unchecked_rem","","Returns the remainder of an unchecked division, resulting…",null,[[]]],[5,"unchecked_shl","","Performs an unchecked left shift, resulting in undefined…",null,[[]]],[5,"unchecked_shr","","Performs an unchecked right shift, resulting in undefined…",null,[[]]],[5,"unchecked_add","","Returns the result of an unchecked addition, resulting in…",null,[[]]],[5,"unchecked_sub","","Returns the result of an unchecked subtraction, resulting…",null,[[]]],[5,"unchecked_mul","","Returns the result of an unchecked multiplication,…",null,[[]]],[5,"rotate_left","","Performs rotate left.",null,[[]]],[5,"rotate_right","","Performs rotate right.",null,[[]]],[5,"wrapping_add","","Returns (a + b) mod 2N, where N is the width of T in bits.",null,[[]]],[5,"wrapping_sub","","Returns (a - b) mod 2N, where N is the width of T in bits.",null,[[]]],[5,"wrapping_mul","","Returns (a * b) mod 2N, where N is the width of T in bits.",null,[[]]],[5,"saturating_add","","Computes `a + b`, while saturating at numeric bounds.",null,[[]]],[5,"saturating_sub","","Computes `a - b`, while saturating at numeric bounds.",null,[[]]],[5,"discriminant_value","","Returns the value of the discriminant for the variant in…",null,[[]]],[5,"try","","Rust\'s \\\"try catch\\\" construct which invokes the function…",null,[[]]],[5,"nontemporal_store","","Emits a `!nontemporal` store according to LLVM (see their…",null,[[]]],[5,"ptr_offset_from","","See documentation of `<*const T>::offset_from` for details.",null,[[]]],[5,"miri_start_panic","","Internal hook used by Miri to implement unwinding. ICEs…",null,[[]]],[5,"copy_nonoverlapping","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at…",null,[[]]],[5,"drop_in_place","","Executes the destructor (if any) of the pointed-to value.",null,[[]]],[0,"isize","std","The pointer-sized signed integer type.",null,null],[17,"MIN","std::isize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"iter","std","Composable external iteration.",null,null],[8,"Iterator","std::iter","An interface for dealing with iterators.",null,null],[16,"Item","","The type of the elements being iterated over.",42,null],[10,"next","","Advances the iterator and returns the next value.",42,[[],["option",4]]],[11,"size_hint","","Returns the bounds on the remaining length of the iterator.",42,[[]]],[11,"count","","Consumes the iterator, counting the number of iterations…",42,[[]]],[11,"last","","Consumes the iterator, returning the last element.",42,[[],["option",4]]],[11,"nth","","Returns the `n`th element of the iterator.",42,[[],["option",4]]],[11,"step_by","","Creates an iterator starting at the same point, but…",42,[[],["stepby",3]]],[11,"chain","","Takes two iterators and creates a new iterator over both…",42,[[],["chain",3]]],[11,"zip","","\'Zips up\' two iterators into a single iterator of pairs.",42,[[],["zip",3]]],[11,"map","","Takes a closure and creates an iterator which calls that…",42,[[],["map",3]]],[11,"for_each","","Calls a closure on each element of an iterator.",42,[[]]],[11,"filter","","Creates an iterator which uses a closure to determine if…",42,[[],["filter",3]]],[11,"filter_map","","Creates an iterator that both filters and maps.",42,[[],["filtermap",3]]],[11,"enumerate","","Creates an iterator which gives the current iteration…",42,[[],["enumerate",3]]],[11,"peekable","","Creates an iterator which can use `peek` to look at the…",42,[[],["peekable",3]]],[11,"skip_while","","Creates an iterator that [`skip`]s elements based on a…",42,[[],["skipwhile",3]]],[11,"take_while","","Creates an iterator that yields elements based on a…",42,[[],["takewhile",3]]],[11,"map_while","","Creates an iterator that both yields elements based on a…",42,[[],["mapwhile",3]]],[11,"skip","","Creates an iterator that skips the first `n` elements.",42,[[],["skip",3]]],[11,"take","","Creates an iterator that yields its first `n` elements.",42,[[],["take",3]]],[11,"scan","","An iterator adaptor similar to [`fold`] that holds…",42,[[],["scan",3]]],[11,"flat_map","","Creates an iterator that works like map, but flattens…",42,[[],["flatmap",3]]],[11,"flatten","","Creates an iterator that flattens nested structure.",42,[[],["flatten",3]]],[11,"fuse","","Creates an iterator which ends after the first [`None`].",42,[[],["fuse",3]]],[11,"inspect","","Does something with each element of an iterator, passing…",42,[[],["inspect",3]]],[11,"by_ref","","Borrows an iterator, rather than consuming it.",42,[[]]],[11,"collect","","Transforms an iterator into a collection.",42,[[]]],[11,"partition","","Consumes an iterator, creating two collections from it.",42,[[]]],[11,"partition_in_place","","Reorders the elements of this iterator in-place according…",42,[[]]],[11,"is_partitioned","","Checks if the elements of this iterator are partitioned…",42,[[]]],[11,"try_fold","","An iterator method that applies a function as long as it…",42,[[]]],[11,"try_for_each","","An iterator method that applies a fallible function to…",42,[[]]],[11,"fold","","An iterator method that applies a function, producing a…",42,[[]]],[11,"fold_first","","The same as `fold()`, but uses the first element in the…",42,[[],["option",4]]],[11,"all","","Tests if every element of the iterator matches a predicate.",42,[[]]],[11,"any","","Tests if any element of the iterator matches a predicate.",42,[[]]],[11,"find","","Searches for an element of an iterator that satisfies a…",42,[[],["option",4]]],[11,"find_map","","Applies function to the elements of iterator and returns…",42,[[],["option",4]]],[11,"try_find","","Applies function to the elements of iterator and returns…",42,[[],[["result",4],["option",4]]]],[11,"position","","Searches for an element in an iterator, returning its index.",42,[[],["option",4]]],[11,"rposition","","Searches for an element in an iterator from the right,…",42,[[],["option",4]]],[11,"max","","Returns the maximum element of an iterator.",42,[[],["option",4]]],[11,"min","","Returns the minimum element of an iterator.",42,[[],["option",4]]],[11,"max_by_key","","Returns the element that gives the maximum value from the…",42,[[],["option",4]]],[11,"max_by","","Returns the element that gives the maximum value with…",42,[[],["option",4]]],[11,"min_by_key","","Returns the element that gives the minimum value from the…",42,[[],["option",4]]],[11,"min_by","","Returns the element that gives the minimum value with…",42,[[],["option",4]]],[11,"rev","","Reverses an iterator\'s direction.",42,[[],["rev",3]]],[11,"unzip","","Converts an iterator of pairs into a pair of containers.",42,[[]]],[11,"copied","","Creates an iterator which copies all of its elements.",42,[[],["copied",3]]],[11,"cloned","","Creates an iterator which [`clone`]s all of its elements.",42,[[],["cloned",3]]],[11,"cycle","","Repeats an iterator endlessly.",42,[[],["cycle",3]]],[11,"sum","","Sums the elements of an iterator.",42,[[]]],[11,"product","","Iterates over the entire iterator, multiplying all the…",42,[[]]],[11,"cmp","","Lexicographically compares the elements of this `Iterator`…",42,[[],["ordering",4]]],[11,"cmp_by","","Lexicographically compares the elements of this `Iterator`…",42,[[],["ordering",4]]],[11,"partial_cmp","","Lexicographically compares the elements of this `Iterator`…",42,[[],[["ordering",4],["option",4]]]],[11,"partial_cmp_by","","Lexicographically compares the elements of this `Iterator`…",42,[[],[["ordering",4],["option",4]]]],[11,"eq","","Determines if the elements of this `Iterator` are equal to…",42,[[]]],[11,"eq_by","","Determines if the elements of this `Iterator` are equal to…",42,[[]]],[11,"ne","","Determines if the elements of this `Iterator` are unequal…",42,[[]]],[11,"lt","","Determines if the elements of this `Iterator` are…",42,[[]]],[11,"le","","Determines if the elements of this `Iterator` are…",42,[[]]],[11,"gt","","Determines if the elements of this `Iterator` are…",42,[[]]],[11,"ge","","Determines if the elements of this `Iterator` are…",42,[[]]],[11,"is_sorted","","Checks if the elements of this iterator are sorted.",42,[[]]],[11,"is_sorted_by","","Checks if the elements of this iterator are sorted using…",42,[[]]],[11,"is_sorted_by_key","","Checks if the elements of this iterator are sorted using…",42,[[]]],[8,"Step","","Objects that have a notion of successor and predecessor…",null,null],[10,"steps_between","","Returns the number of successor steps required to get from…",43,[[],["option",4]]],[10,"forward_checked","","Returns the value that would be obtained by taking the…",43,[[],["option",4]]],[11,"forward","","Returns the value that would be obtained by taking the…",43,[[]]],[11,"forward_unchecked","","Returns the value that would be obtained by taking the…",43,[[]]],[10,"backward_checked","","Returns the value that would be obtained by taking the…",43,[[],["option",4]]],[11,"backward","","Returns the value that would be obtained by taking the…",43,[[]]],[11,"backward_unchecked","","Returns the value that would be obtained by taking the…",43,[[]]],[5,"empty","","Creates an iterator that yields nothing.",null,[[],["empty",3]]],[3,"Empty","","An iterator that yields nothing.",null,null],[5,"from_fn","","Creates a new iterator where each iteration calls the…",null,[[],["fromfn",3]]],[3,"FromFn","","An iterator where each iteration calls the provided…",null,null],[5,"once","","Creates an iterator that yields an element exactly once.",null,[[],["once",3]]],[3,"Once","","An iterator that yields an element exactly once.",null,null],[5,"once_with","","Creates an iterator that lazily generates a value exactly…",null,[[],["oncewith",3]]],[3,"OnceWith","","An iterator that yields a single element of type `A` by…",null,null],[5,"repeat","","Creates a new iterator that endlessly repeats a single…",null,[[],["repeat",3]]],[3,"Repeat","","An iterator that repeats an element endlessly.",null,null],[5,"repeat_with","","Creates a new iterator that repeats elements of type `A`…",null,[[],["repeatwith",3]]],[3,"RepeatWith","","An iterator that repeats elements of type `A` endlessly by…",null,null],[5,"successors","","Creates a new iterator where each successive item is…",null,[[["option",4]],["successors",3]]],[3,"Successors","","An new iterator where each successive item is computed…",null,null],[8,"FusedIterator","","An iterator that always continues to yield `None` when…",null,null],[8,"TrustedLen","","An iterator that reports an accurate length using size_hint.",null,null],[8,"DoubleEndedIterator","","An iterator able to yield elements from both ends.",null,null],[10,"next_back","","Removes and returns an element from the end of the iterator.",44,[[],["option",4]]],[11,"nth_back","","Returns the `n`th element from the end of the iterator.",44,[[],["option",4]]],[11,"try_rfold","","This is the reverse version of [`try_fold()`]: it takes…",44,[[]]],[11,"rfold","","An iterator method that reduces the iterator\'s elements to…",44,[[]]],[11,"rfind","","Searches for an element of an iterator from the back that…",44,[[],["option",4]]],[8,"Extend","","Extend a collection with the contents of an iterator.",null,null],[10,"extend","","Extends a collection with the contents of an iterator.",45,[[]]],[11,"extend_one","","Extends a collection with exactly one element.",45,[[]]],[11,"extend_reserve","","Reserves capacity in a collection for the given number of…",45,[[]]],[8,"FromIterator","","Conversion from an `Iterator`.",null,null],[10,"from_iter","","Creates a value from an iterator.",46,[[]]],[8,"IntoIterator","","Conversion into an `Iterator`.",null,null],[16,"Item","","The type of the elements being iterated over.",47,null],[16,"IntoIter","","Which kind of iterator are we turning this into?",47,null],[10,"into_iter","","Creates an iterator from a value.",47,[[]]],[8,"ExactSizeIterator","","An iterator that knows its exact length.",null,null],[11,"len","","Returns the exact length of the iterator.",48,[[]]],[11,"is_empty","","Returns `true` if the iterator is empty.",48,[[]]],[8,"Product","","Trait to represent types that can be created by…",null,null],[10,"product","","Method which takes an iterator and generates `Self` from…",49,[[]]],[8,"Sum","","Trait to represent types that can be created by summing up…",null,null],[10,"sum","","Method which takes an iterator and generates `Self` from…",50,[[]]],[3,"Cloned","","An iterator that clones the elements of an underlying…",null,null],[3,"Copied","","An iterator that copies the elements of an underlying…",null,null],[3,"Flatten","","An iterator that flattens one level of nesting in an…",null,null],[3,"MapWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"StepBy","","An iterator for stepping iterators by a custom amount.",null,null],[3,"Chain","","An iterator that links two iterators together, in a chain.",null,null],[3,"Cycle","","An iterator that repeats endlessly.",null,null],[3,"Enumerate","","An iterator that yields the current count and the element…",null,null],[3,"Filter","","An iterator that filters the elements of `iter` with…",null,null],[3,"FilterMap","","An iterator that uses `f` to both filter and map elements…",null,null],[3,"Map","","An iterator that maps the values of `iter` with `f`.",null,null],[3,"Rev","","A double-ended iterator with the direction inverted.",null,null],[3,"Zip","","An iterator that iterates two other iterators…",null,null],[3,"FlatMap","","An iterator that maps each element to an iterator, and…",null,null],[3,"Peekable","","An iterator with a `peek()` that returns an optional…",null,null],[3,"Scan","","An iterator to maintain state while iterating another…",null,null],[3,"Skip","","An iterator that skips over `n` elements of `iter`.",null,null],[3,"SkipWhile","","An iterator that rejects elements while `predicate`…",null,null],[3,"Take","","An iterator that only iterates over the first `n`…",null,null],[3,"TakeWhile","","An iterator that only accepts elements while `predicate`…",null,null],[3,"Fuse","","An iterator that yields `None` forever after the…",null,null],[3,"Inspect","","An iterator that calls a function with a reference to each…",null,null],[0,"marker","std","Primitive traits and types representing basic properties…",null,null],[8,"Send","std::marker","Types that can be transferred across thread boundaries.",null,null],[8,"Sized","","Types with a constant size known at compile time.",null,null],[8,"Unsize","","Types that can be \\\"unsized\\\" to a dynamically-sized type.",null,null],[8,"StructuralPartialEq","","Required trait for constants used in pattern matches.",null,null],[8,"StructuralEq","","Required trait for constants used in pattern matches.",null,null],[8,"Copy","","Types whose values can be duplicated simply by copying bits.",null,null],[8,"Sync","","Types for which it is safe to share references between…",null,null],[3,"PhantomData","","Zero-sized type used to mark things that \\\"act like\\\" they…",null,null],[8,"DiscriminantKind","","Compiler-internal trait used to indicate the type of enum…",null,null],[16,"Discriminant","","The type of the dicriminant, which must satisfy the trait…",51,null],[8,"Unpin","","Types that can be safely moved after being pinned.",null,null],[3,"PhantomPinned","","A marker type which does not implement `Unpin`.",null,null],[14,"Copy","","Derive macro generating an impl of the trait `Copy`.",null,null],[0,"mem","std","Basic functions for dealing with memory.",null,null],[5,"forget","std::mem","Takes ownership and \\\"forgets\\\" about the value without…",null,[[]]],[5,"forget_unsized","","Like [`forget`], but also accepts unsized values.",null,[[]]],[5,"size_of","","Returns the size of a type in bytes.",null,[[]]],[5,"size_of_val","","Returns the size of the pointed-to value in bytes.",null,[[]]],[5,"size_of_val_raw","","Returns the size of the pointed-to value in bytes.",null,[[]]],[5,"min_align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[]]],[5,"min_align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"align_of","","Returns the [ABI]-required minimum alignment of a type.",null,[[]]],[5,"align_of_val","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"align_of_val_raw","","Returns the [ABI]-required minimum alignment of the type…",null,[[]]],[5,"needs_drop","","Returns `true` if dropping values of type `T` matters.",null,[[]]],[5,"zeroed","","Returns the value of type `T` represented by the all-zero…",null,[[]]],[5,"uninitialized","","Bypasses Rust\'s normal memory-initialization checks by…",null,[[]]],[5,"swap","","Swaps the values at two mutable locations, without…",null,[[]]],[5,"take","","Replaces `dest` with the default value of `T`, returning…",null,[[]]],[5,"replace","","Moves `src` into the referenced `dest`, returning the…",null,[[]]],[5,"drop","","Disposes of a value.",null,[[]]],[5,"transmute_copy","","Interprets `src` as having type `&U`, and then reads `src`…",null,[[]]],[3,"Discriminant","","Opaque type representing the discriminant of an enum.",null,null],[5,"discriminant","","Returns a value uniquely identifying the enum variant in…",null,[[],["discriminant",3]]],[3,"ManuallyDrop","","A wrapper to inhibit compiler from automatically calling…",null,null],[19,"MaybeUninit","","A wrapper type to construct uninitialized instances of `T`.",null,null],[5,"transmute","","Reinterprets the bits of a value of one type as another…",null,[[]]],[0,"ops","std","Overloadable operators.",null,null],[8,"Add","std::ops","The addition operator `+`.",null,null],[16,"Output","","The resulting type after applying the `+` operator.",52,null],[10,"add","","Performs the `+` operation.",52,[[]]],[8,"Div","","The division operator `/`.",null,null],[16,"Output","","The resulting type after applying the `/` operator.",53,null],[10,"div","","Performs the `/` operation.",53,[[]]],[8,"Mul","","The multiplication operator `*`.",null,null],[16,"Output","","The resulting type after applying the `*` operator.",54,null],[10,"mul","","Performs the `*` operation.",54,[[]]],[8,"Neg","","The unary negation operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",55,null],[10,"neg","","Performs the unary `-` operation.",55,[[]]],[8,"Rem","","The remainder operator `%`.",null,null],[16,"Output","","The resulting type after applying the `%` operator.",56,null],[10,"rem","","Performs the `%` operation.",56,[[]]],[8,"Sub","","The subtraction operator `-`.",null,null],[16,"Output","","The resulting type after applying the `-` operator.",57,null],[10,"sub","","Performs the `-` operation.",57,[[]]],[8,"AddAssign","","The addition assignment operator `+=`.",null,null],[10,"add_assign","","Performs the `+=` operation.",58,[[]]],[8,"DivAssign","","The division assignment operator `/=`.",null,null],[10,"div_assign","","Performs the `/=` operation.",59,[[]]],[8,"MulAssign","","The multiplication assignment operator `*=`.",null,null],[10,"mul_assign","","Performs the `*=` operation.",60,[[]]],[8,"RemAssign","","The remainder assignment operator `%=`.",null,null],[10,"rem_assign","","Performs the `%=` operation.",61,[[]]],[8,"SubAssign","","The subtraction assignment operator `-=`.",null,null],[10,"sub_assign","","Performs the `-=` operation.",62,[[]]],[8,"BitAnd","","The bitwise AND operator `&`.",null,null],[16,"Output","","The resulting type after applying the `&` operator.",63,null],[10,"bitand","","Performs the `&` operation.",63,[[]]],[8,"BitOr","","The bitwise OR operator `|`.",null,null],[16,"Output","","The resulting type after applying the `|` operator.",64,null],[10,"bitor","","Performs the `|` operation.",64,[[]]],[8,"BitXor","","The bitwise XOR operator `^`.",null,null],[16,"Output","","The resulting type after applying the `^` operator.",65,null],[10,"bitxor","","Performs the `^` operation.",65,[[]]],[8,"Not","","The unary logical negation operator `!`.",null,null],[16,"Output","","The resulting type after applying the `!` operator.",66,null],[10,"not","","Performs the unary `!` operation.",66,[[]]],[8,"Shl","","The left shift operator `<<`. Note that because this trait…",null,null],[16,"Output","","The resulting type after applying the `<<` operator.",67,null],[10,"shl","","Performs the `<<` operation.",67,[[]]],[8,"Shr","","The right shift operator `>>`. Note that because this…",null,null],[16,"Output","","The resulting type after applying the `>>` operator.",68,null],[10,"shr","","Performs the `>>` operation.",68,[[]]],[8,"BitAndAssign","","The bitwise AND assignment operator `&=`.",null,null],[10,"bitand_assign","","Performs the `&=` operation.",69,[[]]],[8,"BitOrAssign","","The bitwise OR assignment operator `|=`.",null,null],[10,"bitor_assign","","Performs the `|=` operation.",70,[[]]],[8,"BitXorAssign","","The bitwise XOR assignment operator `^=`.",null,null],[10,"bitxor_assign","","Performs the `^=` operation.",71,[[]]],[8,"ShlAssign","","The left shift assignment operator `<<=`.",null,null],[10,"shl_assign","","Performs the `<<=` operation.",72,[[]]],[8,"ShrAssign","","The right shift assignment operator `>>=`.",null,null],[10,"shr_assign","","Performs the `>>=` operation.",73,[[]]],[8,"Deref","","Used for immutable dereferencing operations, like `*v`.",null,null],[16,"Target","","The resulting type after dereferencing.",74,null],[10,"deref","","Dereferences the value.",74,[[]]],[8,"DerefMut","","Used for mutable dereferencing operations, like in `*v =…",null,null],[10,"deref_mut","","Mutably dereferences the value.",75,[[]]],[8,"Drop","","Custom code within the destructor.",null,null],[10,"drop","","Executes the destructor for this type.",76,[[]]],[8,"Fn","","The version of the call operator that takes an immutable…",null,null],[10,"call","","Performs the call operation.",77,[[]]],[8,"FnMut","","The version of the call operator that takes a mutable…",null,null],[10,"call_mut","","Performs the call operation.",78,[[]]],[8,"FnOnce","","The version of the call operator that takes a by-value…",null,null],[16,"Output","","The returned type after the call operator is used.",79,null],[10,"call_once","","Performs the call operation.",79,[[]]],[8,"Index","","Used for indexing operations (`container[index]`) in…",null,null],[16,"Output","","The returned type after indexing.",80,null],[10,"index","","Performs the indexing (`container[index]`) operation.",80,[[]]],[8,"IndexMut","","Used for indexing operations (`container[index]`) in…",null,null],[10,"index_mut","","Performs the mutable indexing (`container[index]`)…",81,[[]]],[3,"Range","","A (half-open) range bounded inclusively below and…",null,null],[12,"start","","The lower bound of the range (inclusive).",82,null],[12,"end","","The upper bound of the range (exclusive).",82,null],[3,"RangeFrom","","A range only bounded inclusively below (`start..`).",null,null],[12,"start","","The lower bound of the range (inclusive).",83,null],[3,"RangeFull","","An unbounded range (`..`).",null,null],[3,"RangeTo","","A range only bounded exclusively above (`..end`).",null,null],[12,"end","","The upper bound of the range (exclusive).",84,null],[4,"Bound","","An endpoint of a range of keys.",null,null],[13,"Included","","An inclusive bound.",85,null],[13,"Excluded","","An exclusive bound.",85,null],[13,"Unbounded","","An infinite endpoint. Indicates that there is no bound in…",85,null],[8,"RangeBounds","","`RangeBounds` is implemented by Rust\'s built-in range…",null,null],[10,"start_bound","","Start index bound.",86,[[],["bound",4]]],[10,"end_bound","","End index bound.",86,[[],["bound",4]]],[11,"contains","","Returns `true` if `item` is contained in the range.",86,[[]]],[3,"RangeInclusive","","A range bounded inclusively below and above (`start..=end`).",null,null],[3,"RangeToInclusive","","A range only bounded inclusively above (`..=end`).",null,null],[12,"end","","The upper bound of the range (inclusive)",87,null],[8,"Try","","A trait for customizing the behavior of the `?` operator.",null,null],[16,"Ok","","The type of this value when viewed as successful.",88,null],[16,"Error","","The type of this value when viewed as failed.",88,null],[10,"into_result","","Applies the \\\"?\\\" operator. A return of `Ok(t)` means that…",88,[[],["result",4]]],[10,"from_error","","Wrap an error value to construct the composite result. For…",88,[[]]],[10,"from_ok","","Wrap an OK value to construct the composite result. For…",88,[[]]],[8,"Generator","","The trait implemented by builtin generator types.",null,null],[16,"Yield","","The type of value this generator yields.",89,null],[16,"Return","","The type of value this generator returns.",89,null],[10,"resume","","Resumes the execution of this generator.",89,[[["pin",3]],["generatorstate",4]]],[4,"GeneratorState","","The result of a generator resumption.",null,null],[13,"Yielded","","The generator suspended with a value.",90,null],[13,"Complete","","The generator completed with a return value.",90,null],[8,"CoerceUnsized","","Trait that indicates that this is a pointer or a wrapper…",null,null],[8,"DispatchFromDyn","","This is used for object safety, to check that a method\'s…",null,null],[0,"option","std","Optional values.",null,null],[4,"Option","std::option","The `Option` type. See the module level documentation for…",null,null],[13,"None","","No value",91,null],[13,"Some","","Some value `T`",91,null],[3,"Iter","","An iterator over a reference to the [`Some`] variant of an…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Some`]…",null,null],[3,"IntoIter","","An iterator over the value in [`Some`] variant of an…",null,null],[3,"NoneError","","The error type that results from applying the try operator…",null,null],[0,"pin","std","Types that pin data to its location in memory.",null,null],[3,"Pin","std::pin","A pinned pointer.",null,null],[0,"ptr","std","Manually manage memory through raw pointers.",null,null],[5,"drop_in_place","std::ptr","Executes the destructor (if any) of the pointed-to value.",null,[[]]],[5,"null","","Creates a null raw pointer.",null,[[]]],[5,"null_mut","","Creates a null mutable raw pointer.",null,[[]]],[5,"slice_from_raw_parts","","Forms a raw slice from a pointer and a length.",null,[[]]],[5,"slice_from_raw_parts_mut","","Performs the same functionality as…",null,[[]]],[5,"swap","","Swaps the values at two mutable locations of the same…",null,[[]]],[5,"swap_nonoverlapping","","Swaps `count * size_of::<T>()` bytes between the two…",null,[[]]],[5,"replace","","Moves `src` into the pointed `dst`, returning the previous…",null,[[]]],[5,"read","","Reads the value from `src` without moving it. This leaves…",null,[[]]],[5,"read_unaligned","","Reads the value from `src` without moving it. This leaves…",null,[[]]],[5,"write","","Overwrites a memory location with the given value without…",null,[[]]],[5,"write_unaligned","","Overwrites a memory location with the given value without…",null,[[]]],[5,"read_volatile","","Performs a volatile read of the value from `src` without…",null,[[]]],[5,"write_volatile","","Performs a volatile write of a memory location with the…",null,[[]]],[5,"eq","","Compares raw pointers for equality.",null,[[]]],[5,"hash","","Hash a raw pointer.",null,[[]]],[5,"copy_nonoverlapping","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"copy","","Copies `count * size_of::<T>()` bytes from `src` to `dst`.…",null,[[]]],[5,"write_bytes","","Sets `count * size_of::<T>()` bytes of memory starting at…",null,[[]]],[3,"NonNull","","`*mut T` but non-zero and covariant.",null,null],[0,"raw","std","Contains struct definitions for the layout of compiler…",null,null],[3,"TraitObject","std::raw","The representation of a trait object like `&dyn SomeTrait`.",null,null],[12,"data","","",92,null],[12,"vtable","","",92,null],[0,"result","std","Error handling with the `Result` type.",null,null],[4,"Result","std::result","`Result` is a type that represents either success ([`Ok`])…",null,null],[13,"Ok","","Contains the success value",93,null],[13,"Err","","Contains the error value",93,null],[3,"Iter","","An iterator over a reference to the [`Ok`] variant of a…",null,null],[3,"IterMut","","An iterator over a mutable reference to the [`Ok`] variant…",null,null],[3,"IntoIter","","An iterator over the value in a [`Ok`] variant of a…",null,null],[0,"u128","std","The 128-bit unsigned integer type.",null,null],[17,"MIN","std::u128","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u16","std","The 16-bit unsigned integer type.",null,null],[17,"MIN","std::u16","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u32","std","The 32-bit unsigned integer type.",null,null],[17,"MIN","std::u32","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u64","std","The 64-bit unsigned integer type.",null,null],[17,"MIN","std::u64","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"u8","std","The 8-bit unsigned integer type.",null,null],[17,"MIN","std::u8","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[0,"usize","std","The pointer-sized unsigned integer type.",null,null],[17,"MIN","std::usize","The smallest value that can be represented by this integer…",null,null],[17,"MAX","","The largest value that can be represented by this integer…",null,null],[14,"assert_eq","std","Asserts that two expressions are equal to each other…",null,null],[14,"assert_ne","","Asserts that two expressions are not equal to each other…",null,null],[14,"debug_assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"debug_assert_eq","","Asserts that two expressions are equal to each other.",null,null],[14,"debug_assert_ne","","Asserts that two expressions are not equal to each other.",null,null],[14,"matches","","Returns whether the given expression matches any of the…",null,null],[14,"try","","Unwraps a result or propagates its error.",null,null],[14,"todo","","Indicates unfinished code.",null,null],[14,"unimplemented","","Indicates unimplemented code by panicking with a message…",null,null],[14,"unreachable","","Indicates unreachable code.",null,null],[14,"write","","Writes formatted data into a buffer.",null,null],[14,"writeln","","Write formatted data into a buffer, with a newline appended.",null,null],[14,"asm","","Inline assembly.",null,null],[14,"assert","","Asserts that a boolean expression is `true` at runtime.",null,null],[14,"cfg","","Evaluates boolean combinations of configuration flags at…",null,null],[14,"column","","Expands to the column number at which it was invoked.",null,null],[14,"compile_error","","Causes compilation to fail with the given error message…",null,null],[14,"concat","","Concatenates literals into a static string slice.",null,null],[14,"concat_idents","","Concatenates identifiers into one identifier.",null,null],[14,"env","","Inspects an environment variable at compile time.",null,null],[14,"file","","Expands to the file name in which it was invoked.",null,null],[14,"format_args","","Constructs parameters for the other string-formatting…",null,null],[14,"format_args_nl","","Same as `format_args`, but adds a newline in the end.",null,null],[14,"global_asm","","Module-level inline assembly.",null,null],[14,"include","","Parses a file as an expression or an item according to the…",null,null],[14,"include_bytes","","Includes a file as a reference to a byte array.",null,null],[14,"include_str","","Includes a utf8-encoded file as a string.",null,null],[14,"line","","Expands to the line number on which it was invoked.",null,null],[14,"llvm_asm","","LLVM-style inline assembly.",null,null],[14,"log_syntax","","Prints passed tokens into the standard output.",null,null],[14,"module_path","","Expands to a string that represents the current module path.",null,null],[14,"option_env","","Optionally inspects an environment variable at compile time.",null,null],[14,"stringify","","Stringifies its arguments.",null,null],[14,"trace_macros","","Enables or disables tracing functionality used for…",null,null],[0,"primitive","","This module reexports the primitive types to allow usage…",null,null],[0,"prelude","","The Rust Prelude.",null,null],[0,"v1","std::prelude","The first version of the prelude of The Rust Standard…",null,null],[0,"f32","std","This module provides constants which are specific to the…",null,null],[0,"consts","std::f32","Basic mathematical constants.",null,null],[17,"PI","std::f32::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"DIGITS","std::f32","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f32`. Use `f32::EPSILON`…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"RADIX","","The radix or base of the internal representation of `f32`.…",null,null],[17,"INFINITY","","Infinity (∞). Use `f32::INFINITY` instead.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f32::NAN` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f32::NEG_INFINITY` instead.",null,null],[17,"MAX","","Largest finite `f32` value. Use `f32::MAX` instead.",null,null],[17,"MIN","","Smallest finite `f32` value. Use `f32::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f32` value. Use…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f32::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[0,"f64","std","This module provides constants which are specific to the…",null,null],[0,"consts","std::f64","Basic mathematical constants.",null,null],[17,"PI","std::f64::consts","Archimedes\' constant (π)",null,null],[17,"TAU","","The full circle constant (τ)",null,null],[17,"FRAC_PI_2","","π/2",null,null],[17,"FRAC_PI_3","","π/3",null,null],[17,"FRAC_PI_4","","π/4",null,null],[17,"FRAC_PI_6","","π/6",null,null],[17,"FRAC_PI_8","","π/8",null,null],[17,"FRAC_1_PI","","1/π",null,null],[17,"FRAC_2_PI","","2/π",null,null],[17,"FRAC_2_SQRT_PI","","2/sqrt(π)",null,null],[17,"SQRT_2","","sqrt(2)",null,null],[17,"FRAC_1_SQRT_2","","1/sqrt(2)",null,null],[17,"E","","Euler\'s number (e)",null,null],[17,"LOG2_10","","log2(10)",null,null],[17,"LOG2_E","","log2(e)",null,null],[17,"LOG10_2","","log10(2)",null,null],[17,"LOG10_E","","log10(e)",null,null],[17,"LN_2","","ln(2)",null,null],[17,"LN_10","","ln(10)",null,null],[17,"DIGITS","std::f64","Approximate number of significant digits in base 10. Use…",null,null],[17,"EPSILON","","[Machine epsilon] value for `f64`. Use `f64::EPSILON`…",null,null],[17,"MANTISSA_DIGITS","","Number of significant digits in base 2. Use…",null,null],[17,"RADIX","","The radix or base of the internal representation of `f64`.…",null,null],[17,"INFINITY","","Infinity (∞). Use `f64::INFINITY` instead.",null,null],[17,"MAX_10_EXP","","Maximum possible power of 10 exponent. Use…",null,null],[17,"NAN","","Not a Number (NaN). Use `f64::NAN` instead.",null,null],[17,"NEG_INFINITY","","Negative infinity (−∞). Use `f64::NEG_INFINITY` instead.",null,null],[17,"MAX","","Largest finite `f64` value. Use `f64::MAX` instead.",null,null],[17,"MIN","","Smallest finite `f64` value. Use `f64::MIN` instead.",null,null],[17,"MIN_POSITIVE","","Smallest positive normal `f64` value. Use…",null,null],[17,"MAX_EXP","","Maximum possible power of 2 exponent. Use `f64::MAX_EXP`…",null,null],[17,"MIN_10_EXP","","Minimum possible normal power of 10 exponent. Use…",null,null],[17,"MIN_EXP","","One greater than the minimum possible normal power of 2…",null,null],[0,"thread","std","Native threads.",null,null],[3,"AccessError","std::thread","An error returned by `LocalKey::try_with`.",null,null],[3,"LocalKey","","A thread local storage key which owns its contents.",null,null],[3,"Builder","","Thread factory, which can be used in order to configure…",null,null],[3,"ThreadId","","A unique identifier for a running thread.",null,null],[3,"Thread","","A handle to a thread.",null,null],[3,"JoinHandle","","An owned permission to join on a thread (block on its…",null,null],[5,"spawn","","Spawns a new thread, returning a [`JoinHandle`] for it.",null,[[],["joinhandle",3]]],[5,"current","","Gets a handle to the thread that invokes it.",null,[[],["thread",3]]],[5,"yield_now","","Cooperatively gives up a timeslice to the OS scheduler.",null,[[]]],[5,"panicking","","Determines whether the current thread is unwinding because…",null,[[]]],[5,"sleep_ms","","Puts the current thread to sleep for at least the…",null,[[]]],[5,"sleep","","Puts the current thread to sleep for at least the…",null,[[["duration",3]]]],[5,"park","","Blocks unless or until the current thread\'s token is made…",null,[[]]],[5,"park_timeout_ms","","Use [`park_timeout`].",null,[[]]],[5,"park_timeout","","Blocks unless or until the current thread\'s token is made…",null,[[["duration",3]]]],[11,"with","","Acquires a reference to the value in this TLS key.",94,[[]]],[11,"try_with","","Acquires a reference to the value in this TLS key.",94,[[],[["accesserror",3],["result",4]]]],[6,"Result","","A specialized [`Result`] type for threads.",null,null],[11,"new","","Generates the base configuration for spawning a thread,…",95,[[],["builder",3]]],[11,"name","","Names the thread-to-be. Currently the name is used for…",95,[[["string",3]],["builder",3]]],[11,"stack_size","","Sets the size of the stack (in bytes) for the new thread.",95,[[],["builder",3]]],[11,"spawn","","Spawns a new thread by taking ownership of the `Builder`,…",95,[[],[["joinhandle",3],["result",6]]]],[11,"spawn_unchecked","","Spawns a new thread without any lifetime restrictions by…",95,[[],[["joinhandle",3],["result",6]]]],[11,"as_u64","","This returns a numeric identifier for the thread…",96,[[],["nonzerou64",3]]],[11,"unpark","","Atomically makes the handle\'s token available if it is not…",97,[[]]],[11,"id","","Gets the thread\'s unique identifier.",97,[[],["threadid",3]]],[11,"name","","Gets the thread\'s name.",97,[[],["option",4]]],[11,"thread","","Extracts a handle to the underlying thread.",98,[[],["thread",3]]],[11,"join","","Waits for the associated thread to finish.",98,[[],["result",6]]],[0,"ascii","std","Operations on ASCII strings and characters.",null,null],[5,"escape_default","std::ascii","Returns an iterator that produces an escaped version of a…",null,[[],["escapedefault",3]]],[3,"EscapeDefault","","An iterator over the escaped version of a byte.",null,null],[8,"AsciiExt","","Extension methods for ASCII-subset only operations.",null,null],[16,"Owned","","Container type for copied ASCII characters.",99,null],[10,"is_ascii","","Checks if the value is within the ASCII range.",99,[[]]],[10,"to_ascii_uppercase","","Makes a copy of the value in its ASCII upper case…",99,[[]]],[10,"to_ascii_lowercase","","Makes a copy of the value in its ASCII lower case…",99,[[]]],[10,"eq_ignore_ascii_case","","Checks that two values are an ASCII case-insensitive match.",99,[[]]],[10,"make_ascii_uppercase","","Converts this type to its ASCII upper case equivalent…",99,[[]]],[10,"make_ascii_lowercase","","Converts this type to its ASCII lower case equivalent…",99,[[]]],[0,"backtrace","std","Support for capturing a stack backtrace of an OS thread",null,null],[3,"Backtrace","std::backtrace","A captured OS thread stack backtrace.",null,null],[4,"BacktraceStatus","","The current status of a backtrace, indicating whether it…",null,null],[13,"Unsupported","","Capturing a backtrace is not supported, likely because…",100,null],[13,"Disabled","","Capturing a backtrace has been disabled through either the…",100,null],[13,"Captured","","A backtrace has been captured and the `Backtrace` should…",100,null],[11,"capture","","Capture a stack backtrace of the current thread.",101,[[],["backtrace",3]]],[11,"force_capture","","Forcibly captures a full backtrace, regardless of…",101,[[],["backtrace",3]]],[11,"status","","Returns the status of this backtrace, indicating whether…",101,[[],["backtracestatus",4]]],[0,"collections","std","Collection types.",null,null],[0,"binary_heap","std::collections","A priority queue implemented with a binary heap.",null,null],[3,"BinaryHeap","std::collections::binary_heap","A priority queue implemented with a binary heap.",null,null],[3,"PeekMut","","Structure wrapping a mutable reference to the greatest…",null,null],[3,"Iter","","An iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `BinaryHeap`.",null,null],[3,"IntoIterSorted","","",null,null],[3,"Drain","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[3,"DrainSorted","","A draining iterator over the elements of a `BinaryHeap`.",null,null],[0,"btree_map","std::collections","A map based on a B-Tree.",null,null],[3,"BTreeMap","std::collections::btree_map","A map based on a B-Tree.",null,null],[3,"Iter","","An iterator over the entries of a `BTreeMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `BTreeMap`.",null,null],[3,"Keys","","An iterator over the keys of a `BTreeMap`.",null,null],[3,"Values","","An iterator over the values of a `BTreeMap`.",null,null],[3,"Range","","An iterator over a sub-range of entries in a `BTreeMap`.",null,null],[3,"RangeMut","","A mutable iterator over a sub-range of entries in a…",null,null],[4,"Entry","","A view into a single entry in a map, which may either be…",null,null],[13,"Vacant","","A vacant entry.",102,null],[13,"Occupied","","An occupied entry.",102,null],[3,"VacantEntry","","A view into a vacant entry in a `BTreeMap`. It is part of…",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `BTreeMap`. It is part…",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on BTreeMap.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `BTreeMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `BTreeMap`.",null,null],[0,"btree_set","std::collections","A set based on a B-Tree.",null,null],[3,"Iter","std::collections::btree_set","An iterator over the items of a `BTreeSet`.",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of…",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric…",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of…",null,null],[3,"Union","","A lazy iterator producing elements in the union of…",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on BTreeSet.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"IntoIter","","An owning iterator over the items of a `BTreeSet`.",null,null],[3,"Range","","An iterator over a sub-range of items in a `BTreeSet`.",null,null],[0,"linked_list","std::collections","A doubly-linked list with owned nodes.",null,null],[3,"LinkedList","std::collections::linked_list","A doubly-linked list with owned nodes.",null,null],[3,"Iter","","An iterator over the elements of a `LinkedList`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `LinkedList`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `LinkedList`.",null,null],[3,"Cursor","","A cursor over a `LinkedList`.",null,null],[3,"CursorMut","","A cursor over a `LinkedList` with editing operations.",null,null],[3,"DrainFilter","","An iterator produced by calling `drain_filter` on…",null,null],[0,"vec_deque","std::collections","A double-ended queue implemented with a growable ring…",null,null],[3,"VecDeque","std::collections::vec_deque","A double-ended queue implemented with a growable ring…",null,null],[3,"Iter","","An iterator over the elements of a `VecDeque`.",null,null],[3,"IterMut","","A mutable iterator over the elements of a `VecDeque`.",null,null],[3,"IntoIter","","An owning iterator over the elements of a `VecDeque`.",null,null],[3,"Drain","","A draining iterator over the elements of a `VecDeque`.",null,null],[3,"BTreeMap","std::collections","A map based on a B-Tree.",null,null],[3,"BTreeSet","","A set based on a B-Tree.",null,null],[3,"BinaryHeap","","A priority queue implemented with a binary heap.",null,null],[3,"LinkedList","","A doubly-linked list with owned nodes.",null,null],[3,"VecDeque","","A double-ended queue implemented with a growable ring…",null,null],[4,"TryReserveError","","The error type for `try_reserve` methods.",null,null],[13,"CapacityOverflow","","Error due to the computed capacity exceeding the…",103,null],[13,"AllocError","","The memory allocator returned an error",103,null],[12,"layout","std::collections::TryReserveError","The layout of allocation request that failed",104,null],[3,"HashMap","std::collections","A hash map implemented with quadratic probing and SIMD…",null,null],[3,"HashSet","","A hash set implemented as a `HashMap` where the value is…",null,null],[11,"new","","Creates an empty `HashMap`.",105,[[],[["hashmap",3],["randomstate",3]]]],[11,"with_capacity","","Creates an empty `HashMap` with the specified capacity.",105,[[],[["hashmap",3],["randomstate",3]]]],[11,"with_hasher","","Creates an empty `HashMap` which will use the given hash…",105,[[],["hashmap",3]]],[11,"with_capacity_and_hasher","","Creates an empty `HashMap` with the specified capacity,…",105,[[],["hashmap",3]]],[11,"capacity","","Returns the number of elements the map can hold without…",105,[[]]],[11,"keys","","An iterator visiting all keys in arbitrary order. The…",105,[[],["keys",3]]],[11,"values","","An iterator visiting all values in arbitrary order. The…",105,[[],["values",3]]],[11,"values_mut","","An iterator visiting all values mutably in arbitrary…",105,[[],["valuesmut",3]]],[11,"iter","","An iterator visiting all key-value pairs in arbitrary…",105,[[],["iter",3]]],[11,"iter_mut","","An iterator visiting all key-value pairs in arbitrary…",105,[[],["itermut",3]]],[11,"len","","Returns the number of elements in the map.",105,[[]]],[11,"is_empty","","Returns `true` if the map contains no elements.",105,[[]]],[11,"drain","","Clears the map, returning all key-value pairs as an…",105,[[],["drain",3]]],[11,"clear","","Clears the map, removing all key-value pairs. Keeps the…",105,[[]]],[11,"hasher","","Returns a reference to the map\'s [`BuildHasher`].",105,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",105,[[]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",105,[[],[["tryreserveerror",4],["result",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the map as much as possible. It…",105,[[]]],[11,"shrink_to","","Shrinks the capacity of the map with a lower limit. It…",105,[[]]],[11,"entry","","Gets the given key\'s corresponding entry in the map for…",105,[[],["entry",4]]],[11,"get","","Returns a reference to the value corresponding to the key.",105,[[],["option",4]]],[11,"get_key_value","","Returns the key-value pair corresponding to the supplied…",105,[[],["option",4]]],[11,"contains_key","","Returns `true` if the map contains a value for the…",105,[[]]],[11,"get_mut","","Returns a mutable reference to the value corresponding to…",105,[[],["option",4]]],[11,"insert","","Inserts a key-value pair into the map.",105,[[],["option",4]]],[11,"remove","","Removes a key from the map, returning the value at the key…",105,[[],["option",4]]],[11,"remove_entry","","Removes a key from the map, returning the stored key and…",105,[[],["option",4]]],[11,"retain","","Retains only the elements specified by the predicate.",105,[[]]],[11,"raw_entry_mut","","Creates a raw entry builder for the HashMap.",105,[[],["rawentrybuildermut",3]]],[11,"raw_entry","","Creates a raw immutable entry builder for the HashMap.",105,[[],["rawentrybuilder",3]]],[11,"new","","Creates an empty `HashSet`.",106,[[],[["hashset",3],["randomstate",3]]]],[11,"with_capacity","","Creates an empty `HashSet` with the specified capacity.",106,[[],[["hashset",3],["randomstate",3]]]],[11,"capacity","","Returns the number of elements the set can hold without…",106,[[]]],[11,"iter","","An iterator visiting all elements in arbitrary order. The…",106,[[],["iter",3]]],[11,"len","","Returns the number of elements in the set.",106,[[]]],[11,"is_empty","","Returns `true` if the set contains no elements.",106,[[]]],[11,"drain","","Clears the set, returning all elements in an iterator.",106,[[],["drain",3]]],[11,"clear","","Clears the set, removing all values.",106,[[]]],[11,"with_hasher","","Creates a new empty hash set which will use the given…",106,[[],["hashset",3]]],[11,"with_capacity_and_hasher","","Creates an empty `HashSet` with the specified capacity,…",106,[[],["hashset",3]]],[11,"hasher","","Returns a reference to the set\'s [`BuildHasher`].",106,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more elements…",106,[[]]],[11,"try_reserve","","Tries to reserve capacity for at least `additional` more…",106,[[],[["tryreserveerror",4],["result",4]]]],[11,"shrink_to_fit","","Shrinks the capacity of the set as much as possible. It…",106,[[]]],[11,"shrink_to","","Shrinks the capacity of the set with a lower limit. It…",106,[[]]],[11,"difference","","Visits the values representing the difference, i.e., the…",106,[[["hashset",3]],["difference",3]]],[11,"symmetric_difference","","Visits the values representing the symmetric difference,…",106,[[["hashset",3]],["symmetricdifference",3]]],[11,"intersection","","Visits the values representing the intersection, i.e., the…",106,[[["hashset",3]],["intersection",3]]],[11,"union","","Visits the values representing the union, i.e., all the…",106,[[["hashset",3]],["union",3]]],[11,"contains","","Returns `true` if the set contains a value.",106,[[]]],[11,"get","","Returns a reference to the value in the set, if any, that…",106,[[],["option",4]]],[11,"get_or_insert","","Inserts the given `value` into the set if it is not…",106,[[]]],[11,"get_or_insert_owned","","Inserts an owned copy of the given `value` into the set if…",106,[[]]],[11,"get_or_insert_with","","Inserts a value computed from `f` into the set if the…",106,[[]]],[11,"is_disjoint","","Returns `true` if `self` has no elements in common with…",106,[[["hashset",3]]]],[11,"is_subset","","Returns `true` if the set is a subset of another, i.e.,…",106,[[["hashset",3]]]],[11,"is_superset","","Returns `true` if the set is a superset of another, i.e.,…",106,[[["hashset",3]]]],[11,"insert","","Adds a value to the set.",106,[[]]],[11,"replace","","Adds a value to the set, replacing the existing value, if…",106,[[],["option",4]]],[11,"remove","","Removes a value from the set. Returns whether the value…",106,[[]]],[11,"take","","Removes and returns the value in the set, if any, that is…",106,[[],["option",4]]],[11,"retain","","Retains only the elements specified by the predicate.",106,[[]]],[0,"hash_map","","A hash map implemented with quadratic probing and SIMD…",null,null],[3,"HashMap","std::collections::hash_map","A hash map implemented with quadratic probing and SIMD…",null,null],[3,"Iter","","An iterator over the entries of a `HashMap`.",null,null],[3,"IterMut","","A mutable iterator over the entries of a `HashMap`.",null,null],[3,"IntoIter","","An owning iterator over the entries of a `HashMap`.",null,null],[3,"Keys","","An iterator over the keys of a `HashMap`.",null,null],[3,"Values","","An iterator over the values of a `HashMap`.",null,null],[3,"Drain","","A draining iterator over the entries of a `HashMap`.",null,null],[3,"ValuesMut","","A mutable iterator over the values of a `HashMap`.",null,null],[3,"RawEntryBuilderMut","","A builder for computing where in a HashMap a key-value…",null,null],[3,"RawOccupiedEntryMut","","A view into an occupied entry in a `HashMap`. It is part…",null,null],[3,"RawVacantEntryMut","","A view into a vacant entry in a `HashMap`. It is part of…",null,null],[3,"RawEntryBuilder","","A builder for computing where in a HashMap a key-value…",null,null],[3,"OccupiedEntry","","A view into an occupied entry in a `HashMap`. It is part…",null,null],[3,"VacantEntry","","A view into a vacant entry in a `HashMap`. It is part of…",null,null],[3,"RandomState","","`RandomState` is the default state for [`HashMap`] types.",null,null],[3,"DefaultHasher","","The default [`Hasher`] used by [`RandomState`].",null,null],[4,"RawEntryMut","","A view into a single entry in a map, which may either be…",null,null],[13,"Occupied","","An occupied entry.",107,null],[13,"Vacant","","A vacant entry.",107,null],[4,"Entry","","A view into a single entry in a map, which may either be…",null,null],[13,"Occupied","","An occupied entry.",108,null],[13,"Vacant","","A vacant entry.",108,null],[0,"hash_set","std::collections","A hash set implemented as a `HashMap` where the value is…",null,null],[3,"HashSet","std::collections::hash_set","A hash set implemented as a `HashMap` where the value is…",null,null],[3,"Iter","","An iterator over the items of a `HashSet`.",null,null],[3,"IntoIter","","An owning iterator over the items of a `HashSet`.",null,null],[3,"Drain","","A draining iterator over the items of a `HashSet`.",null,null],[3,"Intersection","","A lazy iterator producing elements in the intersection of…",null,null],[3,"Difference","","A lazy iterator producing elements in the difference of…",null,null],[3,"SymmetricDifference","","A lazy iterator producing elements in the symmetric…",null,null],[3,"Union","","A lazy iterator producing elements in the union of…",null,null],[0,"env","std","Inspection and manipulation of the process\'s environment.",null,null],[3,"Vars","std::env","An iterator over a snapshot of the environment variables…",null,null],[3,"VarsOs","","An iterator over a snapshot of the environment variables…",null,null],[3,"SplitPaths","","An iterator that splits an environment variable into paths…",null,null],[3,"JoinPathsError","","The error type for operations on the `PATH` variable.…",null,null],[3,"Args","","An iterator over the arguments of a process, yielding a…",null,null],[3,"ArgsOs","","An iterator over the arguments of a process, yielding an…",null,null],[4,"VarError","","The error type for operations interacting with environment…",null,null],[13,"NotPresent","","The specified environment variable was not present in the…",109,null],[13,"NotUnicode","","The specified environment variable was found, but it did…",109,null],[5,"current_dir","","Returns the current working directory as a [`PathBuf`].",null,[[],[["result",6],["pathbuf",3]]]],[5,"set_current_dir","","Changes the current working directory to the specified path.",null,[[["asref",8],["path",3]],["result",6]]],[5,"vars","","Returns an iterator of (variable, value) pairs of strings,…",null,[[],["vars",3]]],[5,"vars_os","","Returns an iterator of (variable, value) pairs of OS…",null,[[],["varsos",3]]],[5,"var","","Fetches the environment variable `key` from the current…",null,[[["asref",8],["osstr",3]],[["varerror",4],["result",4],["string",3]]]],[5,"var_os","","Fetches the environment variable `key` from the current…",null,[[["asref",8],["osstr",3]],[["option",4],["osstring",3]]]],[5,"set_var","","Sets the environment variable `k` to the value `v` for the…",null,[[["asref",8],["osstr",3]]]],[5,"remove_var","","Removes an environment variable from the environment of…",null,[[["asref",8],["osstr",3]]]],[5,"split_paths","","Parses input according to platform conventions for the…",null,[[],["splitpaths",3]]],[5,"join_paths","","Joins a collection of [`Path`]s appropriately for the…",null,[[],[["result",4],["osstring",3],["joinpathserror",3]]]],[5,"home_dir","","Returns the path of the current user\'s home directory if…",null,[[],[["option",4],["pathbuf",3]]]],[5,"temp_dir","","Returns the path of a temporary directory.",null,[[],["pathbuf",3]]],[5,"current_exe","","Returns the full filesystem path of the current running…",null,[[],[["result",6],["pathbuf",3]]]],[5,"args","","Returns the arguments which this program was started with…",null,[[],["args",3]]],[5,"args_os","","Returns the arguments which this program was started with…",null,[[],["argsos",3]]],[0,"consts","","Constants associated with the current target",null,null],[17,"ARCH","std::env::consts","A string describing the architecture of the CPU that is…",null,null],[17,"FAMILY","","The family of the operating system. Example value is `unix`.",null,null],[17,"OS","","A string describing the specific operating system in use.…",null,null],[17,"DLL_PREFIX","","Specifies the filename prefix used for shared libraries on…",null,null],[17,"DLL_SUFFIX","","Specifies the filename suffix used for shared libraries on…",null,null],[17,"DLL_EXTENSION","","Specifies the file extension used for shared libraries on…",null,null],[17,"EXE_SUFFIX","","Specifies the filename suffix used for executable binaries…",null,null],[17,"EXE_EXTENSION","","Specifies the file extension, if any, used for executable…",null,null],[0,"error","std","Traits for working with Errors.",null,null],[3,"Chain","std::error","An iterator over an [`Error`] and its sources.",null,null],[8,"Error","","`Error` is a trait representing the basic expectations for…",null,null],[11,"source","","The lower-level source of this error, if any.",110,[[],[["error",8],["option",4]]]],[11,"backtrace","","Returns a stack backtrace, if available, of where this…",110,[[],[["option",4],["backtrace",3]]]],[11,"description","","`if let Err(e) = \\\"xc\\\".parse::<u32>() { // Print `e`…",110,[[]]],[11,"cause","","",110,[[],[["error",8],["option",4]]]],[11,"is","","Returns `true` if the boxed type is the same as `T`",110,[[]]],[11,"downcast_ref","","Returns some reference to the boxed value if it is of type…",110,[[],["option",4]]],[11,"downcast_mut","","Returns some mutable reference to the boxed value if it is…",110,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type `dyn Error`.",110,[[]]],[11,"downcast_ref","","Forwards to the method defined on the type `dyn Error`.",110,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type `dyn Error`.",110,[[],["option",4]]],[11,"is","","Forwards to the method defined on the type `dyn Error`.",110,[[]]],[11,"downcast_ref","","Forwards to the method defined on the type `dyn Error`.",110,[[],["option",4]]],[11,"downcast_mut","","Forwards to the method defined on the type `dyn Error`.",110,[[],["option",4]]],[11,"downcast","","Attempts to downcast the box to a concrete type.",110,[[["box",3]],[["box",3],["box",3],["result",4]]]],[11,"chain","","Returns an iterator starting with the current error and…",110,[[],["chain",3]]],[11,"downcast","","Attempts to downcast the box to a concrete type.",110,[[["box",3]],[["box",3],["result",4],["box",3]]]],[11,"downcast","","Attempts to downcast the box to a concrete type.",110,[[["box",3]],[["result",4],["box",3],["box",3]]]],[0,"ffi","std","Utilities related to FFI bindings.",null,null],[4,"c_void","std::ffi","Equivalent to C\'s `void` type when used as a [pointer].",null,null],[3,"VaList","","A wrapper for a `va_list`",null,null],[3,"VaListImpl","","Basic implementation of a `va_list`.",null,null],[3,"FromBytesWithNulError","","An error indicating that a nul byte was not in the…",null,null],[3,"CStr","","Representation of a borrowed C string.",null,null],[3,"CString","","A type representing an owned, C-compatible, nul-terminated…",null,null],[3,"IntoStringError","","An error indicating invalid UTF-8 when converting a…",null,null],[3,"NulError","","An error indicating that an interior nul byte was found.",null,null],[3,"OsStr","","Borrowed reference to an OS string (see [`OsString`]).",null,null],[3,"OsString","","A type that can represent owned, mutable platform-native…",null,null],[11,"new","","Creates a new C-compatible string from a container of bytes.",111,[[["into",8],["vec",3]],[["cstring",3],["nulerror",3],["result",4]]]],[11,"from_vec_unchecked","","Creates a C-compatible string by consuming a byte vector,…",111,[[["vec",3]],["cstring",3]]],[11,"from_raw","","Retakes ownership of a `CString` that was transferred to C…",111,[[],["cstring",3]]],[11,"into_raw","","Consumes the `CString` and transfers ownership of the…",111,[[]]],[11,"into_string","","Converts the `CString` into a [`String`] if it contains…",111,[[],[["result",4],["string",3],["intostringerror",3]]]],[11,"into_bytes","","Consumes the `CString` and returns the underlying byte…",111,[[],["vec",3]]],[11,"into_bytes_with_nul","","Equivalent to the [`into_bytes`] function except that the…",111,[[],["vec",3]]],[11,"as_bytes","","Returns the contents of this `CString` as a slice of bytes.",111,[[]]],[11,"as_bytes_with_nul","","Equivalent to the [`as_bytes`] function except that the…",111,[[]]],[11,"as_c_str","","Extracts a [`CStr`] slice containing the entire string.",111,[[],["cstr",3]]],[11,"into_boxed_c_str","","Converts this `CString` into a boxed [`CStr`].",111,[[],[["box",3],["cstr",3]]]],[11,"nul_position","","Returns the position of the nul byte in the slice that…",112,[[]]],[11,"into_vec","","Consumes this error, returning the underlying vector of…",112,[[],["vec",3]]],[11,"into_cstring","","Consumes this error, returning original [`CString`] which…",113,[[],["cstring",3]]],[11,"utf8_error","","Access the underlying UTF-8 error that was the cause of…",113,[[],["utf8error",3]]],[11,"from_ptr","","Wraps a raw C string with a safe C string wrapper.",114,[[],["cstr",3]]],[11,"from_bytes_with_nul","","Creates a C string wrapper from a byte slice.",114,[[],[["frombyteswithnulerror",3],["result",4],["cstr",3]]]],[11,"from_bytes_with_nul_unchecked","","Unsafely creates a C string wrapper from a byte slice.",114,[[],["cstr",3]]],[11,"as_ptr","","Returns the inner pointer to this C string.",114,[[]]],[11,"to_bytes","","Converts this C string to a byte slice.",114,[[]]],[11,"to_bytes_with_nul","","Converts this C string to a byte slice containing the…",114,[[]]],[11,"to_str","","Yields a [`&str`] slice if the `CStr` contains valid UTF-8.",114,[[],[["result",4],["utf8error",3]]]],[11,"to_string_lossy","","Converts a `CStr` into a [`Cow`]`<`[`str`]`>`.",114,[[],["cow",4]]],[11,"into_c_string","","Converts a [`Box`]`<CStr>` into a [`CString`] without…",114,[[["box",3],["cstr",3]],["cstring",3]]],[11,"new","","Constructs a new empty `OsString`.",115,[[],["osstring",3]]],[11,"as_os_str","","Converts to an [`OsStr`] slice.",115,[[],["osstr",3]]],[11,"into_string","","Converts the `OsString` into a [`String`] if it contains…",115,[[],[["result",4],["string",3],["osstring",3]]]],[11,"push","","Extends the string with the given [`&OsStr`] slice.",115,[[["asref",8],["osstr",3]]]],[11,"with_capacity","","Creates a new `OsString` with the given capacity.",115,[[],["osstring",3]]],[11,"clear","","Truncates the `OsString` to zero length.",115,[[]]],[11,"capacity","","Returns the capacity this `OsString` can hold without…",115,[[]]],[11,"reserve","","Reserves capacity for at least `additional` more capacity…",115,[[]]],[11,"reserve_exact","","Reserves the minimum capacity for exactly `additional`…",115,[[]]],[11,"shrink_to_fit","","Shrinks the capacity of the `OsString` to match its length.",115,[[]]],[11,"shrink_to","","Shrinks the capacity of the `OsString` with a lower bound.",115,[[]]],[11,"into_boxed_os_str","","Converts this `OsString` into a boxed [`OsStr`].",115,[[],[["box",3],["osstr",3]]]],[11,"new","","Coerces into an `OsStr` slice.",116,[[],["osstr",3]]],[11,"to_str","","Yields a [`&str`] slice if the `OsStr` is valid Unicode.",116,[[],["option",4]]],[11,"to_string_lossy","","Converts an `OsStr` to a [`Cow`]`<`[`str`]`>`.",116,[[],["cow",4]]],[11,"to_os_string","","Copies the slice into an owned [`OsString`].",116,[[],["osstring",3]]],[11,"is_empty","","Checks whether the `OsStr` is empty.",116,[[]]],[11,"len","","Returns the length of this `OsStr`.",116,[[]]],[11,"into_os_string","","Converts a [`Box`]`<OsStr>` into an [`OsString`] without…",116,[[["box",3],["osstr",3]],["osstring",3]]],[11,"make_ascii_lowercase","","Converts this string to its ASCII lower case equivalent…",116,[[]]],[11,"make_ascii_uppercase","","Converts this string to its ASCII upper case equivalent…",116,[[]]],[11,"to_ascii_lowercase","","Returns a copy of this string where each character is…",116,[[],["osstring",3]]],[11,"to_ascii_uppercase","","Returns a copy of this string where each character is…",116,[[],["osstring",3]]],[11,"is_ascii","","Checks if all characters in this string are within the…",116,[[]]],[11,"eq_ignore_ascii_case","","Checks that two strings are an ASCII case-insensitive match.",116,[[]]],[0,"fs","std","Filesystem manipulation operations.",null,null],[3,"File","std::fs","A reference to an open file on the filesystem.",null,null],[3,"Metadata","","Metadata information about a file.",null,null],[3,"ReadDir","","Iterator over the entries in a directory.",null,null],[3,"DirEntry","","Entries returned by the [`ReadDir`] iterator.",null,null],[3,"OpenOptions","","Options and flags which can be used to configure how a…",null,null],[3,"Permissions","","Representation of the various permissions on a file.",null,null],[3,"FileType","","A structure representing a type of file with accessors for…",null,null],[3,"DirBuilder","","A builder used to create directories in various manners.",null,null],[5,"read","","Read the entire contents of a file into a bytes vector.",null,[[["asref",8],["path",3]],[["result",6],["vec",3]]]],[5,"read_to_string","","Read the entire contents of a file into a string.",null,[[["asref",8],["path",3]],[["string",3],["result",6]]]],[5,"write","","Write a slice as the entire contents of a file.",null,[[["asref",8],["asref",8],["path",3]],["result",6]]],[5,"remove_file","","Removes a file from the filesystem.",null,[[["asref",8],["path",3]],["result",6]]],[5,"metadata","","Given a path, query the file system to get information…",null,[[["asref",8],["path",3]],[["metadata",3],["result",6]]]],[5,"symlink_metadata","","Query the metadata about a file without following symlinks.",null,[[["asref",8],["path",3]],[["metadata",3],["result",6]]]],[5,"rename","","Rename a file or directory to a new name, replacing the…",null,[[["asref",8],["path",3]],["result",6]]],[5,"copy","","Copies the contents of one file to another. This function…",null,[[["asref",8],["path",3]],["result",6]]],[5,"hard_link","","Creates a new hard link on the filesystem.",null,[[["asref",8],["path",3]],["result",6]]],[5,"soft_link","","Creates a new symbolic link on the filesystem.",null,[[["asref",8],["path",3]],["result",6]]],[5,"read_link","","Reads a symbolic link, returning the file that the link…",null,[[["asref",8],["path",3]],[["result",6],["pathbuf",3]]]],[5,"canonicalize","","Returns the canonical, absolute form of a path with all…",null,[[["asref",8],["path",3]],[["result",6],["pathbuf",3]]]],[5,"create_dir","","Creates a new, empty directory at the provided path",null,[[["asref",8],["path",3]],["result",6]]],[5,"create_dir_all","","Recursively create a directory and all of its parent…",null,[[["asref",8],["path",3]],["result",6]]],[5,"remove_dir","","Removes an existing, empty directory.",null,[[["asref",8],["path",3]],["result",6]]],[5,"remove_dir_all","","Removes a directory at this path, after removing all its…",null,[[["asref",8],["path",3]],["result",6]]],[5,"read_dir","","Returns an iterator over the entries within a directory.",null,[[["asref",8],["path",3]],[["result",6],["readdir",3]]]],[5,"set_permissions","","Changes the permissions found on a file or a directory.",null,[[["permissions",3],["asref",8],["path",3]],["result",6]]],[11,"open","","Attempts to open a file in read-only mode.",117,[[["asref",8],["path",3]],[["result",6],["file",3]]]],[11,"create","","Opens a file in write-only mode.",117,[[["asref",8],["path",3]],[["result",6],["file",3]]]],[11,"with_options","","Returns a new OpenOptions object.",117,[[],["openoptions",3]]],[11,"sync_all","","Attempts to sync all OS-internal metadata to disk.",117,[[],["result",6]]],[11,"sync_data","","This function is similar to [`sync_all`], except that it…",117,[[],["result",6]]],[11,"set_len","","Truncates or extends the underlying file, updating the…",117,[[],["result",6]]],[11,"metadata","","Queries metadata about the underlying file.",117,[[],[["metadata",3],["result",6]]]],[11,"try_clone","","Creates a new `File` instance that shares the same…",117,[[],[["result",6],["file",3]]]],[11,"set_permissions","","Changes the permissions on the underlying file.",117,[[["permissions",3]],["result",6]]],[11,"new","","Creates a blank new set of options ready for configuration.",118,[[]]],[11,"read","","Sets the option for read access.",118,[[]]],[11,"write","","Sets the option for write access.",118,[[]]],[11,"append","","Sets the option for the append mode.",118,[[]]],[11,"truncate","","Sets the option for truncating a previous file.",118,[[]]],[11,"create","","Sets the option to create a new file, or open it if it…",118,[[]]],[11,"create_new","","Sets the option to create a new file, failing if it…",118,[[]]],[11,"open","","Opens a file at `path` with the options specified by `self`.",118,[[["asref",8],["path",3]],[["result",6],["file",3]]]],[11,"file_type","","Returns the file type for this metadata.",119,[[],["filetype",3]]],[11,"is_dir","","Returns `true` if this metadata is for a directory. The…",119,[[]]],[11,"is_file","","Returns `true` if this metadata is for a regular file. The…",119,[[]]],[11,"len","","Returns the size of the file, in bytes, this metadata is…",119,[[]]],[11,"permissions","","Returns the permissions of the file this metadata is for.",119,[[],["permissions",3]]],[11,"modified","","Returns the last modification time listed in this metadata.",119,[[],[["result",6],["systemtime",3]]]],[11,"accessed","","Returns the last access time of this metadata.",119,[[],[["result",6],["systemtime",3]]]],[11,"created","","Returns the creation time listed in this metadata.",119,[[],[["result",6],["systemtime",3]]]],[11,"readonly","","Returns `true` if these permissions describe a readonly…",120,[[]]],[11,"set_readonly","","Modifies the readonly flag for this set of permissions. If…",120,[[]]],[11,"is_dir","","Tests whether this file type represents a directory. The…",121,[[]]],[11,"is_file","","Tests whether this file type represents a regular file.…",121,[[]]],[11,"is_symlink","","Tests whether this file type represents a symbolic link.…",121,[[]]],[11,"path","","Returns the full path to the file that this entry…",122,[[],["pathbuf",3]]],[11,"metadata","","Returns the metadata for the file that this entry points at.",122,[[],[["metadata",3],["result",6]]]],[11,"file_type","","Returns the file type for the file that this entry points…",122,[[],[["result",6],["filetype",3]]]],[11,"file_name","","Returns the bare file name of this directory entry without…",122,[[],["osstring",3]]],[11,"new","","Creates a new set of options with default mode/security…",123,[[],["dirbuilder",3]]],[11,"recursive","","Indicates that directories should be created recursively,…",123,[[]]],[11,"create","","Creates the specified directory with the options…",123,[[["asref",8],["path",3]],["result",6]]],[0,"io","std","Traits, helpers, and type definitions for core I/O…",null,null],[3,"IntoInnerError","std::io","An error returned by `into_inner` which combines an error…",null,null],[3,"BufReader","","The `BufReader<R>` struct adds buffering to any reader.",null,null],[3,"BufWriter","","Wraps a writer and buffers its output.",null,null],[3,"LineWriter","","Wraps a writer and buffers output to it, flushing whenever…",null,null],[3,"Cursor","","A `Cursor` wraps an in-memory buffer and provides it with…",null,null],[3,"Error","","The error type for I/O operations of the [`Read`],…",null,null],[3,"Stderr","","A handle to the standard error stream of a process.",null,null],[3,"Stdin","","A handle to the standard input stream of a process.",null,null],[3,"Stdout","","A handle to the global standard output stream of the…",null,null],[3,"StderrLock","","A locked reference to the `Stderr` handle.",null,null],[3,"StdinLock","","A locked reference to the `Stdin` handle.",null,null],[3,"StdoutLock","","A locked reference to the `Stdout` handle.",null,null],[3,"Empty","","A reader which is always at EOF.",null,null],[3,"Repeat","","A reader which yields one byte over and over and over and…",null,null],[3,"Sink","","A writer which will move data into the void.",null,null],[3,"IoSliceMut","","A buffer type used with `Read::read_vectored`.",null,null],[3,"IoSlice","","A buffer type used with `Write::write_vectored`.",null,null],[3,"Initializer","","A type used to conditionally initialize buffers passed to…",null,null],[3,"Chain","","Adaptor to chain together two readers.",null,null],[3,"Take","","Reader adaptor which limits the bytes read from an…",null,null],[3,"Bytes","","An iterator over `u8` values of a reader.",null,null],[3,"Split","","An iterator over the contents of an instance of `BufRead`…",null,null],[3,"Lines","","An iterator over the lines of an instance of `BufRead`.",null,null],[4,"ErrorKind","","A list specifying general categories of I/O error.",null,null],[13,"NotFound","","An entity was not found, often a file.",124,null],[13,"PermissionDenied","","The operation lacked the necessary privileges to complete.",124,null],[13,"ConnectionRefused","","The connection was refused by the remote server.",124,null],[13,"ConnectionReset","","The connection was reset by the remote server.",124,null],[13,"ConnectionAborted","","The connection was aborted (terminated) by the remote…",124,null],[13,"NotConnected","","The network operation failed because it was not connected…",124,null],[13,"AddrInUse","","A socket address could not be bound because the address is…",124,null],[13,"AddrNotAvailable","","A nonexistent interface was requested or the requested…",124,null],[13,"BrokenPipe","","The operation failed because a pipe was closed.",124,null],[13,"AlreadyExists","","An entity already exists, often a file.",124,null],[13,"WouldBlock","","The operation needs to block to complete, but the blocking…",124,null],[13,"InvalidInput","","A parameter was incorrect.",124,null],[13,"InvalidData","","Data not valid for the operation were encountered.",124,null],[13,"TimedOut","","The I/O operation\'s timeout expired, causing it to be…",124,null],[13,"WriteZero","","An error returned when an operation could not be completed…",124,null],[13,"Interrupted","","This operation was interrupted.",124,null],[13,"Other","","Any I/O error not part of this list.",124,null],[13,"UnexpectedEof","","An error returned when an operation could not be completed…",124,null],[4,"SeekFrom","","Enumeration of possible methods to seek within an I/O…",null,null],[13,"Start","","Sets the offset to the provided number of bytes.",125,null],[13,"End","","Sets the offset to the size of this object plus the…",125,null],[13,"Current","","Sets the offset to the current position plus the specified…",125,null],[5,"stderr","","Constructs a new handle to the standard error of the…",null,[[],["stderr",3]]],[5,"stdin","","Constructs a new handle to the standard input of the…",null,[[],["stdin",3]]],[5,"stdout","","Constructs a new handle to the standard output of the…",null,[[],["stdout",3]]],[5,"copy","","Copies the entire contents of a reader into a writer.",null,[[],["result",6]]],[5,"empty","","Constructs a new handle to an empty reader.",null,[[],["empty",3]]],[5,"repeat","","Creates an instance of a reader that infinitely repeats…",null,[[],["repeat",3]]],[5,"sink","","Creates an instance of a writer which will successfully…",null,[[],["sink",3]]],[11,"new","","Creates a new `BufReader<R>` with a default buffer…",126,[[],["bufreader",3]]],[11,"with_capacity","","Creates a new `BufReader<R>` with the specified buffer…",126,[[],["bufreader",3]]],[11,"get_ref","","Gets a reference to the underlying reader.",126,[[]]],[11,"get_mut","","Gets a mutable reference to the underlying reader.",126,[[]]],[11,"buffer","","Returns a reference to the internally buffered data.",126,[[]]],[11,"capacity","","Returns the number of bytes the internal buffer can hold…",126,[[]]],[11,"into_inner","","Unwraps this `BufReader<R>`, returning the underlying…",126,[[]]],[11,"seek_relative","","Seeks relative to the current position. If the new…",126,[[],["result",6]]],[11,"new","","Creates a new `BufWriter<W>` with a default buffer…",127,[[],["bufwriter",3]]],[11,"with_capacity","","Creates a new `BufWriter<W>` with the specified buffer…",127,[[],["bufwriter",3]]],[11,"get_ref","","Gets a reference to the underlying writer.",127,[[]]],[11,"get_mut","","Gets a mutable reference to the underlying writer.",127,[[]]],[11,"buffer","","Returns a reference to the internally buffered data.",127,[[]]],[11,"capacity","","Returns the number of bytes the internal buffer can hold…",127,[[]]],[11,"into_inner","","Unwraps this `BufWriter<W>`, returning the underlying…",127,[[],[["intoinnererror",3],["result",4]]]],[11,"error","","Returns the error which caused the call to `into_inner()`…",128,[[],["error",3]]],[11,"into_inner","","Returns the buffered writer instance which generated the…",128,[[]]],[11,"new","","Creates a new `LineWriter`.",129,[[],["linewriter",3]]],[11,"with_capacity","","Creates a new `LineWriter` with a specified capacity for…",129,[[],["linewriter",3]]],[11,"get_ref","","Gets a reference to the underlying writer.",129,[[]]],[11,"get_mut","","Gets a mutable reference to the underlying writer.",129,[[]]],[11,"into_inner","","Unwraps this `LineWriter`, returning the underlying writer.",129,[[],[["intoinnererror",3],["result",4]]]],[11,"new","","Creates a new cursor wrapping the provided underlying…",130,[[],["cursor",3]]],[11,"into_inner","","Consumes this cursor, returning the underlying value.",130,[[]]],[11,"get_ref","","Gets a reference to the underlying value in this cursor.",130,[[]]],[11,"get_mut","","Gets a mutable reference to the underlying value in this…",130,[[]]],[11,"position","","Returns the current position of this cursor.",130,[[]]],[11,"set_position","","Sets the position of this cursor.",130,[[]]],[11,"new","","Creates a new I/O error from a known kind of error as well…",131,[[["errorkind",4]],["error",3]]],[11,"last_os_error","","Returns an error representing the last OS error which…",131,[[],["error",3]]],[11,"from_raw_os_error","","Creates a new instance of an `Error` from a particular OS…",131,[[],["error",3]]],[11,"raw_os_error","","Returns the OS error that this error represents (if any).",131,[[],["option",4]]],[11,"get_ref","","Returns a reference to the inner error wrapped by this…",131,[[],[["option",4],["error",8]]]],[11,"get_mut","","Returns a mutable reference to the inner error wrapped by…",131,[[],[["option",4],["error",8]]]],[11,"into_inner","","Consumes the `Error`, returning its inner error (if any).",131,[[],[["box",3],["option",4]]]],[11,"kind","","Returns the corresponding `ErrorKind` for this error.",131,[[],["errorkind",4]]],[0,"prelude","","The I/O Prelude",null,null],[11,"lock","","Locks this handle to the standard input stream, returning…",132,[[],["stdinlock",3]]],[11,"read_line","","Locks this handle and reads a line of input, appending it…",132,[[["string",3]],["result",6]]],[11,"lock","","Locks this handle to the standard output stream, returning…",133,[[],["stdoutlock",3]]],[11,"lock","","Locks this handle to the standard error stream, returning…",134,[[],["stderrlock",3]]],[6,"Result","","A specialized `Result` type for I/O operations.",null,null],[8,"Read","","The `Read` trait allows for reading bytes from a source.",null,null],[10,"read","","Pull some bytes from this source into the specified…",135,[[],["result",6]]],[11,"read_vectored","","Like `read`, except that it reads into a slice of buffers.",135,[[],["result",6]]],[11,"is_read_vectored","","Determines if this `Read`er has an efficient…",135,[[]]],[11,"initializer","","Determines if this `Read`er can work with buffers of…",135,[[],["initializer",3]]],[11,"read_to_end","","Read all bytes until EOF in this source, placing them into…",135,[[["vec",3]],["result",6]]],[11,"read_to_string","","Read all bytes until EOF in this source, appending them to…",135,[[["string",3]],["result",6]]],[11,"read_exact","","Read the exact number of bytes required to fill `buf`.",135,[[],["result",6]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of…",135,[[]]],[11,"bytes","","Transforms this `Read` instance to an [`Iterator`] over…",135,[[],["bytes",3]]],[11,"chain","","Creates an adaptor which will chain this stream with…",135,[[["read",8]],[["read",8],["chain",3]]]],[11,"take","","Creates an adaptor which will read at most `limit` bytes…",135,[[],["take",3]]],[8,"Write","","A trait for objects which are byte-oriented sinks.",null,null],[10,"write","","Write a buffer into this writer, returning how many bytes…",136,[[],["result",6]]],[11,"write_vectored","","Like `write`, except that it writes from a slice of buffers.",136,[[],["result",6]]],[11,"is_write_vectored","","Determines if this `Write`er has an efficient…",136,[[]]],[10,"flush","","Flush this output stream, ensuring that all intermediately…",136,[[],["result",6]]],[11,"write_all","","Attempts to write an entire buffer into this writer.",136,[[],["result",6]]],[11,"write_all_vectored","","Attempts to write multiple buffers into this writer.",136,[[],["result",6]]],[11,"write_fmt","","Writes a formatted string into this writer, returning any…",136,[[["arguments",3]],["result",6]]],[11,"by_ref","","Creates a \\\"by reference\\\" adaptor for this instance of…",136,[[]]],[8,"Seek","","The `Seek` trait provides a cursor which can be moved…",null,null],[10,"seek","","Seek to an offset, in bytes, in a stream.",137,[[["seekfrom",4]],["result",6]]],[11,"stream_len","","Returns the length of this stream (in bytes).",137,[[],["result",6]]],[11,"stream_position","","Returns the current seek position from the start of the…",137,[[],["result",6]]],[8,"BufRead","","A `BufRead` is a type of `Read`er which has an internal…",null,null],[10,"fill_buf","","Returns the contents of the internal buffer, filling it…",138,[[],["result",6]]],[10,"consume","","Tells this buffer that `amt` bytes have been consumed from…",138,[[]]],[11,"read_until","","Read all bytes into `buf` until the delimiter `byte` or…",138,[[["vec",3]],["result",6]]],[11,"read_line","","Read all bytes until a newline (the 0xA byte) is reached,…",138,[[["string",3]],["result",6]]],[11,"split","","Returns an iterator over the contents of this reader split…",138,[[],["split",3]]],[11,"lines","","Returns an iterator over the lines of this reader.",138,[[],["lines",3]]],[11,"new","","Creates a new `IoSliceMut` wrapping a byte slice.",139,[[],["ioslicemut",3]]],[11,"advance","","Advance the internal cursor of the slice.",139,[[]]],[11,"new","","Creates a new `IoSlice` wrapping a byte slice.",140,[[],["ioslice",3]]],[11,"advance","","Advance the internal cursor of the slice.",140,[[]]],[11,"zeroing","","Returns a new `Initializer` which will zero out buffers.",141,[[],["initializer",3]]],[11,"nop","","Returns a new `Initializer` which will not zero out buffers.",141,[[],["initializer",3]]],[11,"should_initialize","","Indicates if a buffer should be initialized.",141,[[]]],[11,"initialize","","Initializes a buffer if necessary.",141,[[]]],[11,"into_inner","","Consumes the `Chain`, returning the wrapped readers.",142,[[]]],[11,"get_ref","","Gets references to the underlying readers in this `Chain`.",142,[[]]],[11,"get_mut","","Gets mutable references to the underlying readers in this…",142,[[]]],[11,"limit","","Returns the number of bytes that can be read before this…",143,[[]]],[11,"set_limit","","Sets the number of bytes that can be read before this…",143,[[]]],[11,"into_inner","","Consumes the `Take`, returning the wrapped reader.",143,[[]]],[11,"get_ref","","Gets a reference to the underlying reader.",143,[[]]],[11,"get_mut","","Gets a mutable reference to the underlying reader.",143,[[]]],[0,"net","std","Networking primitives for TCP/UDP communication.",null,null],[3,"SocketAddrV4","std::net","An IPv4 socket address.",null,null],[3,"SocketAddrV6","","An IPv6 socket address.",null,null],[3,"Ipv4Addr","","An IPv4 address.",null,null],[3,"Ipv6Addr","","An IPv6 address.",null,null],[3,"AddrParseError","","An error which can be returned when parsing an IP address…",null,null],[3,"Incoming","","An iterator that infinitely [`accept`]s connections on a…",null,null],[3,"TcpListener","","A TCP socket server, listening for connections.",null,null],[3,"TcpStream","","A TCP stream between a local and a remote socket.",null,null],[3,"UdpSocket","","A UDP socket.",null,null],[4,"SocketAddr","","An internet socket address, either IPv4 or IPv6.",null,null],[13,"V4","","An IPv4 socket address.",144,null],[13,"V6","","An IPv6 socket address.",144,null],[4,"IpAddr","","An IP address, either IPv4 or IPv6.",null,null],[13,"V4","","An IPv4 address.",145,null],[13,"V6","","An IPv6 address.",145,null],[4,"Ipv6MulticastScope","","",null,null],[13,"InterfaceLocal","","",146,null],[13,"LinkLocal","","",146,null],[13,"RealmLocal","","",146,null],[13,"AdminLocal","","",146,null],[13,"SiteLocal","","",146,null],[13,"OrganizationLocal","","",146,null],[13,"Global","","",146,null],[4,"Shutdown","","Possible values which can be passed to the [`shutdown`]…",null,null],[13,"Read","","The reading portion of the [`TcpStream`] should be shut…",147,null],[13,"Write","","The writing portion of the [`TcpStream`] should be shut…",147,null],[13,"Both","","Both the reading and the writing portions of the…",147,null],[11,"new","","Creates a new socket address from an [IP address] and a…",144,[[["ipaddr",4]],["socketaddr",4]]],[11,"ip","","Returns the IP address associated with this socket address.",144,[[],["ipaddr",4]]],[11,"set_ip","","Changes the IP address associated with this socket address.",144,[[["ipaddr",4]]]],[11,"port","","Returns the port number associated with this socket address.",144,[[]]],[11,"set_port","","Changes the port number associated with this socket address.",144,[[]]],[11,"is_ipv4","","Returns [`true`] if the [IP address] in this `SocketAddr`…",144,[[]]],[11,"is_ipv6","","Returns [`true`] if the [IP address] in this `SocketAddr`…",144,[[]]],[11,"new","","Creates a new socket address from an [IPv4 address] and a…",148,[[["ipv4addr",3]],["socketaddrv4",3]]],[11,"ip","","Returns the IP address associated with this socket address.",148,[[],["ipv4addr",3]]],[11,"set_ip","","Changes the IP address associated with this socket address.",148,[[["ipv4addr",3]]]],[11,"port","","Returns the port number associated with this socket address.",148,[[]]],[11,"set_port","","Changes the port number associated with this socket address.",148,[[]]],[11,"new","","Creates a new socket address from an [IPv6 address], a…",149,[[["ipv6addr",3]],["socketaddrv6",3]]],[11,"ip","","Returns the IP address associated with this socket address.",149,[[],["ipv6addr",3]]],[11,"set_ip","","Changes the IP address associated with this socket address.",149,[[["ipv6addr",3]]]],[11,"port","","Returns the port number associated with this socket address.",149,[[]]],[11,"set_port","","Changes the port number associated with this socket address.",149,[[]]],[11,"flowinfo","","Returns the flow information associated with this address.",149,[[]]],[11,"set_flowinfo","","Changes the flow information associated with this socket…",149,[[]]],[11,"scope_id","","Returns the scope ID associated with this address.",149,[[]]],[11,"set_scope_id","","Changes the scope ID associated with this socket address.",149,[[]]],[11,"is_unspecified","","Returns [`true`] for the special \'unspecified\' address.",145,[[]]],[11,"is_loopback","","Returns [`true`] if this is a loopback address.",145,[[]]],[11,"is_global","","Returns [`true`] if the address appears to be globally…",145,[[]]],[11,"is_multicast","","Returns [`true`] if this is a multicast address.",145,[[]]],[11,"is_documentation","","Returns [`true`] if this address is in a range designated…",145,[[]]],[11,"is_ipv4","","Returns [`true`] if this address is an [IPv4 address], and…",145,[[]]],[11,"is_ipv6","","Returns [`true`] if this address is an [IPv6 address], and…",145,[[]]],[11,"new","","Creates a new IPv4 address from four eight-bit octets.",150,[[],["ipv4addr",3]]],[18,"LOCALHOST","","An IPv4 address with the address pointing to localhost:…",150,null],[18,"UNSPECIFIED","","An IPv4 address representing an unspecified address: 0.0.0.0",150,null],[18,"BROADCAST","","An IPv4 address representing the broadcast address:…",150,null],[11,"octets","","Returns the four eight-bit integers that make up this…",150,[[]]],[11,"is_unspecified","","Returns [`true`] for the special \'unspecified\' address…",150,[[]]],[11,"is_loopback","","Returns [`true`] if this is a loopback address…",150,[[]]],[11,"is_private","","Returns [`true`] if this is a private address.",150,[[]]],[11,"is_link_local","","Returns [`true`] if the address is link-local…",150,[[]]],[11,"is_global","","Returns [`true`] if the address appears to be globally…",150,[[]]],[11,"is_shared","","Returns [`true`] if this address is part of the Shared…",150,[[]]],[11,"is_ietf_protocol_assignment","","Returns [`true`] if this address is part of…",150,[[]]],[11,"is_benchmarking","","Returns [`true`] if this address part of the…",150,[[]]],[11,"is_reserved","","Returns [`true`] if this address is reserved by IANA for…",150,[[]]],[11,"is_multicast","","Returns [`true`] if this is a multicast address…",150,[[]]],[11,"is_broadcast","","Returns [`true`] if this is a broadcast address…",150,[[]]],[11,"is_documentation","","Returns [`true`] if this address is in a range designated…",150,[[]]],[11,"to_ipv6_compatible","","Converts this address to an IPv4-compatible [IPv6 address].",150,[[],["ipv6addr",3]]],[11,"to_ipv6_mapped","","Converts this address to an IPv4-mapped [IPv6 address].",150,[[],["ipv6addr",3]]],[11,"new","","Creates a new IPv6 address from eight 16-bit segments.",151,[[],["ipv6addr",3]]],[18,"LOCALHOST","","An IPv6 address representing localhost: `::1`.",151,null],[18,"UNSPECIFIED","","An IPv6 address representing the unspecified address: `::`",151,null],[11,"segments","","Returns the eight 16-bit segments that make up this address.",151,[[]]],[11,"is_unspecified","","Returns [`true`] for the special \'unspecified\' address (::).",151,[[]]],[11,"is_loopback","","Returns [`true`] if this is a loopback address (::1).",151,[[]]],[11,"is_global","","Returns [`true`] if the address appears to be globally…",151,[[]]],[11,"is_unique_local","","Returns [`true`] if this is a unique local address…",151,[[]]],[11,"is_unicast_link_local_strict","","Returns [`true`] if the address is a unicast link-local…",151,[[]]],[11,"is_unicast_link_local","","Returns [`true`] if the address is a unicast link-local…",151,[[]]],[11,"is_unicast_site_local","","Returns [`true`] if this is a deprecated unicast…",151,[[]]],[11,"is_documentation","","Returns [`true`] if this is an address reserved for…",151,[[]]],[11,"is_unicast_global","","Returns [`true`] if the address is a globally routable…",151,[[]]],[11,"multicast_scope","","Returns the address\'s multicast scope if the address is…",151,[[],[["option",4],["ipv6multicastscope",4]]]],[11,"is_multicast","","Returns [`true`] if this is a multicast address (ff00::/8).",151,[[]]],[11,"to_ipv4","","Converts this address to an [IPv4 address]. Returns…",151,[[],[["ipv4addr",3],["option",4]]]],[11,"octets","","Returns the sixteen eight-bit integers the IPv6 address…",151,[[]]],[11,"connect","","Opens a TCP connection to a remote host.",152,[[["tosocketaddrs",8]],[["result",6],["tcpstream",3]]]],[11,"connect_timeout","","Opens a TCP connection to a remote host with a timeout.",152,[[["socketaddr",4],["duration",3]],[["result",6],["tcpstream",3]]]],[11,"peer_addr","","Returns the socket address of the remote peer of this TCP…",152,[[],[["socketaddr",4],["result",6]]]],[11,"local_addr","","Returns the socket address of the local half of this TCP…",152,[[],[["socketaddr",4],["result",6]]]],[11,"shutdown","","Shuts down the read, write, or both halves of this…",152,[[["shutdown",4]],["result",6]]],[11,"try_clone","","Creates a new independently owned handle to the underlying…",152,[[],[["result",6],["tcpstream",3]]]],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",152,[[["option",4],["duration",3]],["result",6]]],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",152,[[["option",4],["duration",3]],["result",6]]],[11,"read_timeout","","Returns the read timeout of this socket.",152,[[],[["option",4],["result",6]]]],[11,"write_timeout","","Returns the write timeout of this socket.",152,[[],[["option",4],["result",6]]]],[11,"peek","","Receives data on the socket from the remote address to…",152,[[],["result",6]]],[11,"set_nodelay","","Sets the value of the `TCP_NODELAY` option on this socket.",152,[[],["result",6]]],[11,"nodelay","","Gets the value of the `TCP_NODELAY` option on this socket.",152,[[],["result",6]]],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",152,[[],["result",6]]],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",152,[[],["result",6]]],[11,"take_error","","Gets the value of the `SO_ERROR` option on this socket.",152,[[],[["option",4],["result",6]]]],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",152,[[],["result",6]]],[11,"bind","","Creates a new `TcpListener` which will be bound to the…",153,[[["tosocketaddrs",8]],[["result",6],["tcplistener",3]]]],[11,"local_addr","","Returns the local socket address of this listener.",153,[[],[["socketaddr",4],["result",6]]]],[11,"try_clone","","Creates a new independently owned handle to the underlying…",153,[[],[["result",6],["tcplistener",3]]]],[11,"accept","","Accept a new incoming connection from this listener.",153,[[],["result",6]]],[11,"incoming","","Returns an iterator over the connections being received on…",153,[[],["incoming",3]]],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",153,[[],["result",6]]],[11,"ttl","","Gets the value of the `IP_TTL` option for this socket.",153,[[],["result",6]]],[11,"set_only_v6","","",153,[[],["result",6]]],[11,"only_v6","","",153,[[],["result",6]]],[11,"take_error","","Gets the value of the `SO_ERROR` option on this socket.",153,[[],[["option",4],["result",6]]]],[11,"set_nonblocking","","Moves this TCP stream into or out of nonblocking mode.",153,[[],["result",6]]],[11,"bind","","Creates a UDP socket from the given address.",154,[[["tosocketaddrs",8]],[["udpsocket",3],["result",6]]]],[11,"recv_from","","Receives a single datagram message on the socket. On…",154,[[],["result",6]]],[11,"peek_from","","Receives a single datagram message on the socket, without…",154,[[],["result",6]]],[11,"send_to","","Sends data on the socket to the given address. On success,…",154,[[["tosocketaddrs",8]],["result",6]]],[11,"peer_addr","","Returns the socket address of the remote peer this socket…",154,[[],[["socketaddr",4],["result",6]]]],[11,"local_addr","","Returns the socket address that this socket was created…",154,[[],[["socketaddr",4],["result",6]]]],[11,"try_clone","","Creates a new independently owned handle to the underlying…",154,[[],[["udpsocket",3],["result",6]]]],[11,"set_read_timeout","","Sets the read timeout to the timeout specified.",154,[[["option",4],["duration",3]],["result",6]]],[11,"set_write_timeout","","Sets the write timeout to the timeout specified.",154,[[["option",4],["duration",3]],["result",6]]],[11,"read_timeout","","Returns the read timeout of this socket.",154,[[],[["option",4],["result",6]]]],[11,"write_timeout","","Returns the write timeout of this socket.",154,[[],[["option",4],["result",6]]]],[11,"set_broadcast","","Sets the value of the `SO_BROADCAST` option for this socket.",154,[[],["result",6]]],[11,"broadcast","","Gets the value of the `SO_BROADCAST` option for this socket.",154,[[],["result",6]]],[11,"set_multicast_loop_v4","","Sets the value of the `IP_MULTICAST_LOOP` option for this…",154,[[],["result",6]]],[11,"multicast_loop_v4","","Gets the value of the `IP_MULTICAST_LOOP` option for this…",154,[[],["result",6]]],[11,"set_multicast_ttl_v4","","Sets the value of the `IP_MULTICAST_TTL` option for this…",154,[[],["result",6]]],[11,"multicast_ttl_v4","","Gets the value of the `IP_MULTICAST_TTL` option for this…",154,[[],["result",6]]],[11,"set_multicast_loop_v6","","Sets the value of the `IPV6_MULTICAST_LOOP` option for…",154,[[],["result",6]]],[11,"multicast_loop_v6","","Gets the value of the `IPV6_MULTICAST_LOOP` option for…",154,[[],["result",6]]],[11,"set_ttl","","Sets the value for the `IP_TTL` option on this socket.",154,[[],["result",6]]],[11,"ttl","","Gets the value of the `I