#  tests for rtree-0.9.5-py38h8b54edf_0 (this is a generated file);
print('===== testing package: rtree-0.9.5-py38h8b54edf_0 =====');
print('running run_test.py');
#  --- run_test.py (begin) ---
import os
try:
    import cPickle as pickle
except ImportError:
    import pickle
from rtree import index
from rtree.index import Rtree

data = """34.3776829412 26.7375853734 49.3776829412 41.7375853734
-51.7912278527 56.5716384064 -36.7912278527 71.5716384064
-132.417278478 -96.7177218184 -117.417278478 -81.7177218184
19.9788779448 -53.1068061438 34.9788779448 -38.1068061438
50.9432853241 53.830194296 65.9432853241 68.830194296
114.777310066 -42.0534139041 129.777310066 -27.0534139041
-80.5201136918 -60.5173650142 -65.5201136918 -45.5173650142
-109.709042971 -88.8853631128 -94.7090429709 -73.8853631128
163.797701593 49.0535662325 178.797701593 64.0535662325
119.52474488 -47.8047995045 134.52474488 -32.8047995045
-49.6358346107 25.7591536504 -34.6358346107 40.7591536504
43.1951329802 -61.7003551556 58.1951329802 -46.7003551556
5.07182469992 -32.9621617938 20.0718246999 -17.9621617938
157.392784956 -59.9967638674 172.392784956 -44.9967638674
169.761387556 77.3118040104 184.761387556 92.3118040104
-90.9030625259 23.7969275036 -75.9030625259 38.7969275036
13.3161023563 35.5651016032 28.3161023563 50.5651016032
-71.4124633746 -27.8098115487 -56.4124633746 -12.8098115487
-101.490578923 40.5161619529 -86.4905789231 55.5161619529
-22.5493804457 -9.48190527182 -7.54938044566 5.51809472818
22.7819453953 81.6043699778 37.7819453953 96.6043699778
163.851232856 52.6576397095 178.851232856 67.6576397095
8.7520267341 -82.9532179134 23.7520267341 -67.9532179134
-25.1295517688 -52.9753074372 -10.1295517688 -37.9753074372
125.380855923 53.093317371 140.380855923 68.093317371
-79.9963004315 -8.58901526761 -64.9963004315 6.41098473239
-3.49476632412 -93.5592177527 11.5052336759 -78.5592177527
5.12311663372 38.9766284779 20.1231166337 53.9766284779
-126.802193031 72.7620993955 -111.802193031 87.7620993955
144.816733092 33.8296664631 159.816733092 48.8296664631
-124.187243051 30.4856075292 -109.187243051 45.4856075292
63.8011147852 -64.8232471563 78.8011147852 -49.8232471563
125.091625278 10.0243913301 140.091625278 25.0243913301
-79.6265618345 37.4238531184 -64.6265618345 52.4238531184
84.0917344559 -61.9889564492 99.0917344559 -46.9889564492
44.1303873224 36.9948838398 59.1303873224 51.9948838398
57.579189376 -44.3308895399 72.579189376 -29.3308895399
-135.915887605 -68.4604833795 -120.915887605 -53.4604833795
-52.5931165731 -83.132095062 -37.5931165731 -68.132095062
-3.66134703734 -24.6160151663 11.3386529627 -9.61601516627
50.9138603775 6.66349450637 65.9138603775 21.6634945064
-59.0308862561 -28.7050068456 -44.0308862561 -13.7050068456
51.6601755093 -32.4794848001 66.6601755093 -17.4794848001
-174.739939684 35.8453347176 -159.739939684 50.8453347176
-107.905359545 -33.9905804035 -92.9053595447 -18.9905804035
-43.8298865873 -38.8139629115 -28.8298865873 -23.8139629115
-186.673789279 15.8707951216 -171.673789279 30.8707951216
13.0878151873 18.9267257542 28.0878151873 33.9267257542
-19.7764534411 -15.1648038653 -4.7764534411 -0.16480386529
-136.725385806 -62.3357813894 -121.725385806 -47.3357813894
56.3180682679 27.7748493606 71.3180682679 42.7748493606
-117.234207271 -95.984091959 -102.234207271 -80.984091959
-112.676334783 69.8614225716 -97.6763347829 84.8614225716
63.4481415226 49.5185084111 78.4481415226 64.5185084111
-164.583933393 -24.3224792074 -149.583933393 -9.32247920738
29.8740632141 -94.4036564677 44.8740632141 -79.4036564677
111.222002785 27.3091348937 126.222002785 42.3091348937
153.388416036 -51.7982686059 168.388416036 -36.7982686059
101.187835391 -79.2096166175 116.187835391 -64.2096166175
88.5716895369 -0.592196575665 103.571689537 14.4078034243
121.697565289 -20.4740930579 136.697565289 -5.47409305786
-57.6430699458 32.6596016791 -42.6430699458 47.6596016791
-51.9988160106 -16.5263906642 -36.9988160106 -1.52639066423
-128.45654531 40.0833021378 -113.45654531 55.0833021378
104.084274855 1.04302798395 119.084274855 16.0430279839
-65.3078063084 52.8659272125 -50.3078063084 67.8659272125
-185.575231871 0.603830128936 -170.575231871 15.6038301289
-99.670852574 63.077063843 -84.670852574 78.077063843
-97.5397037499 24.1544066414 -82.5397037499 39.1544066414
17.1213365558 80.8998469932 32.1213365558 95.8998469932
-66.0514693697 -67.879371904 -51.0514693697 -52.879371904
-165.624597131 -28.2121530482 -150.624597131 -13.2121530482
-153.938620771 -22.5333324395 -138.938620771 -7.5333324395
108.059653776 -30.1015722619 123.059653776 -15.1015722619
66.3357992327 33.4460170804 81.3357992327 48.4460170804
122.051245261 62.1986667929 137.051245261 77.1986667929
-9.14331797752 -4.94220638202 5.85668202248 10.057793618
-6.21767716831 -37.4474638489 8.78232283169 -22.4474638489
-10.2422235441 -36.7771789022 4.75777645591 -21.7771789022
151.39952872 5.78259379576 166.39952872 20.7825937958
53.0412866301 27.1060539476 68.0412866301 42.1060539476
-179.969415049 -86.9431323167 -164.969415049 -71.9431323167
-122.143517094 52.4812451482 -107.143517094 67.4812451482
126.651232891 -71.3593917404 141.651232891 -56.3593917404
35.5628371672 -44.4833782826 50.5628371672 -29.4833782826
106.338230585 74.4980976394 121.338230585 89.4980976394
2.49246106376 64.4571886404 17.4924610638 79.4571886404
26.9239556956 74.8154250821 41.9239556956 89.8154250821
-145.467051901 -23.3901235678 -130.467051901 -8.39012356782
-31.1747618493 -78.3450857919 -16.1747618493 -63.3450857919
-45.6363494594 41.8549865381 -30.6363494594 56.8549865381
-139.598628861 -76.0620586165 -124.598628861 -61.0620586165
75.3893757582 -96.3227872859 90.3893757582 -81.3227872859
66.4127845964 -29.3758752649 81.4127845964 -14.3758752649
71.002709831 5.93248532466 86.002709831 20.9324853247
-166.73585749 -91.958750292 -151.73585749 -76.958750292
-122.966652056 -44.5184865975 -107.966652056 -29.5184865975
-114.787601823 -21.1179486167 -99.7876018227 -6.11794861667
-37.7449906403 -70.1494304858 -22.7449906403 -55.1494304858
70.2802523802 34.6578320934 85.2802523802 49.6578320934"""

boxes15 = []
for line in data.split('\n'):
    if not line:
        break
    [left, bottom, right, top] = [float(x) for x in line.split()]
    boxes15.append((left, bottom, right, top))


def boxes15_stream(interleaved=True):
    for i, (minx, miny, maxx, maxy) in enumerate(boxes15):
        if interleaved:
            yield (i, (minx, miny, maxx, maxy), 42)
        else:
            yield (i, (minx, maxx, miny, maxy), 42)

def check_c_api():
    assert int(str(index.__c_api_version__).split('.')[1]) >= 7

def test_non_stream_input():
    p = index.Property()
    idx = index.Index(properties=p)
    for i, coords in enumerate(boxes15):
        idx.add(i, coords)

    assert 0 in idx.intersection((0, 0, 60, 60))
    hits = list(idx.intersection((0, 0, 60, 60)))
    assert hits == [0, 4, 16, 27, 35, 40, 47, 50, 76, 80]

def test_stream_input():
    p = index.Property()
    sindex = index.Index(boxes15_stream(), properties=p)
    bounds = (0, 0, 60, 60)
    hits = sindex.intersection(bounds)
    assert sorted(hits) == [0, 4, 16, 27, 35, 40, 47, 50, 76, 80]

def test_index():
    idx = index.Index()
    unpickled = pickle.loads(pickle.dumps(idx))
    assert idx.handle is not unpickled.handle
    assert idx.properties.as_dict() == unpickled.properties.as_dict()
    assert idx.interleaved == unpickled.interleaved

def test_property():
    p = index.Property()
    unpickled = pickle.loads(pickle.dumps(p))
    assert p.handle is not unpickled.handle
    assert p.as_dict() == unpickled.as_dict()

check_c_api()
test_non_stream_input()

test_stream_input()
test_index()
test_property()
#  --- run_test.py (end) ---

print('===== rtree-0.9.5-py38h8b54edf_0 OK =====');
print("import: 'rtree'")
import rtree

