#! /usr/bin/env python

############################################################################
# Copyright (c) 2016 Dr. Peter Bunting, Aberystwyth University
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
#
# Purpose:  A command to convert an input image to a KMZ file. 
#
# Author: Pete Bunting
# Email: pfb@aber.ac.uk
# Date: 14/04/16
# Version: 1.0
#
# History:
# Version 1.0 - Created.
#
#############################################################################


import rsgislib.tools.visualisation
import argparse

parser = argparse.ArgumentParser(prog='rsgisimg2kmz.py', description='''Create a KMZ file of the input image...''')

parser.add_argument("-i", "--input", type=str, required=True, help='Input image.')
parser.add_argument("-o", "--output", type=str, required=True, help='Output KMZ.')
parser.add_argument("-b", "--bands", type=str, required=True, help='Comma seperated set of bands. Either single or r,g,b.')
parser.add_argument("-n", "--noproj", action='store_false', default=True, help='Do not re-project the image to lat/long.')
parser.add_argument("-f", "--finite", action='store_true', default=False, help='Apply a finite mask to the input image before stretching.')

# Call the parser to parse the arguments.
args = parser.parse_args()

rsgislib.tools.visualisation.create_kmz_img(args.input, args.output, args.bands, args.noproj, args.finite)

