#!/usr/bin/env python

#############################################
# rgsisvectools.py
#
#  Copyright 2018 RSGISLib.
#
#  RSGISLib: 'The remote sensing and GIS Software Library'
#
#  RSGISLib is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  RSGISLib is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
#
# Purpose:  Get information on vector files/layers. 
#
# Author: Pete Bunting
# Email: petebunting@mac.com
# Date: 17/12/2018
# Version: 1.0
# 
#############################################

import rsgislib.vectorutils

import argparse

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--vecfile", type=str, required=True, help="Input vector file.")
    parser.add_argument("--veclyr", type=str, required=False, help="Input vector file layer.")
    parser.add_argument("--lyrs", action='store_true', default=False, help="List the layers in vector file.")
    parser.add_argument("--cols", action='store_true', default=False, help="List the columns in vector layer.")
    parser.add_argument("--nfeats", action='store_true', default=False, help="Count for the number of feats in layer.")
    parser.add_argument("--proj", action='store_true', default=False, help="Print the projection of the vector layer.")
    args = parser.parse_args()
    
    if args.lyrs:
        vec_lyrs = rsgislib.vectorutils.get_vec_lyrs_lst(args.vecfile)
        for i, lyr in enumerate(vec_lyrs):
            print(f"{i + 1}: {lyr}")

    if args.cols:
        vec_cols = rsgislib.vectorutils.get_vec_lyr_cols(args.vecfile, args.veclyr)
        for i, col in enumerate(vec_cols):
            print(f"{i+1}: {col}")

    if args.nfeats:
        n_lyr_feats = rsgislib.vectorutils.get_vec_feat_count(args.vecfile, args.veclyr)
        print(f"N Features in {args.veclyr}: {n_lyr_feats}")
        
    if args.proj:
        proj_wkt = rsgislib.vectorutils.get_proj_wkt_from_vec(args.vecfile, args.veclyr)
        print(proj_wkt)
