#!/usr/bin/env python

#############################################
# rsgisimginfo.py
#
#  Copyright 2019 RSGISLib.
#
#  RSGISLib: 'The remote sensing and GIS Software Library'
#
#  RSGISLib is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  RSGISLib is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
#
# Purpose:  Get information on vector files/layers. 
#
# Author: Pete Bunting
# Email: petebunting@mac.com
# Date: 02/01/2019
# Version: 1.0
# 
#############################################

import argparse
import rsgislib.rastergis
import rsgislib.imageutils

if __name__ == "__main__":

    parser = argparse.ArgumentParser(description="Print image info to console.")
    parser.add_argument("-i", "--img", type=str, required=True, help="image file")
    args = parser.parse_args()

    print(f"Image: {args.img}")
    img_size = rsgislib.imageutils.get_img_size(args.img)
    print(f"Size: {img_size[0]} x {img_size[1]}")
    img_pxl_res = rsgislib.imageutils.get_img_res(args.img)
    print(f"Pixel Size: {img_pxl_res[0]} x {img_pxl_res[1]}")
    img_epsg = rsgislib.imageutils.get_epsg_proj_from_img(args.img)
    print(f"Image EPSG: {img_epsg}")
    n_bands = rsgislib.imageutils.get_img_band_count(args.img)
    print(f"N Bands: {n_bands}")

    band_names = rsgislib.imageutils.get_band_names(args.img)
    for band, band_name in enumerate(band_names):
        print(f"\tBand {band+1}: {band_name}")
        if rsgislib.imageutils.is_img_thematic(args.img, band+1):
            rat_cols = rsgislib.rastergis.get_rat_columns(args.img, band+1)
            print(f"\t RAT cols: {rat_cols}")


