#!/usr/bin/env python

import numpy as np
from roboticstoolbox.robot.ERobot import ERobot


class px150(ERobot):
    """
    Class that imports a PX150 URDF model

    ``px150()`` is a class which imports an Interbotix px150 robot definition
    from a URDF file.  The model describes its kinematic and graphical
    characteristics.

    .. runblock:: pycon

        >>> import roboticstoolbox as rtb
        >>> robot = rtb.models.URDF.px150()
        >>> print(robot)

    Defined joint configurations are:

    - qz, zero joint angle configuration, 'L' shaped configuration
    - qr, vertical 'READY' configuration

    :reference:
        - http://www.support.interbotix.com/html/specifications/px150.html

    .. codeauthor:: Jesse Haviland
    .. sectionauthor:: Peter Corke
    """
    def __init__(self):

        links, name = self.URDF_read(
            "interbotix_descriptions/urdf/px150.urdf.xacro")

        super().__init__(
                links,
                name=name,
                manufacturer='Interbotix'
            )

        self.addconfiguration(
            "qz", np.array([0, 0, 0, 0, 0, 0, 0, 0]))
        self.addconfiguration(
            "qr", np.array([0, -0.3, 0, -2.2, 0, 2.0, np.pi/4, 0]))


if __name__ == '__main__':   # pragma nocover

    robot = px150()
    print(robot)
