Barnes2013-FlatSurfaces
=======================

**Title of Manuscript**:
An Efficient Assignment of Drainage Direction Over Flat
Surfaces in Raster Digital Elevation Models

**Authors**: Richard Barnes, Clarence Lehman, David Mulla

**Corresponding Author**: Richard Barnes (rbarnes@umn.edu)

**DOI Number of Manuscript**
[10.1016/j.cageo.2013.01.009](http://dx.doi.org/10.1016/j.cageo.2013.01.009)

**Code Repositories**
 * [Author's GitHub Repository](https://github.com/r-barnes/Barnes2013-FlatSurfaces)
 * [Journal's GitHub Repository](https://github.com/cageo)

This repository contains a reference implementation of the algorithms presented
in the manuscript above. It also contains a reference implementation of the
algorithm presented by *Garbrecht and Martz* (1997). These implementations were
used in performing speed comparison tests in the manuscript.

All the programs can be produced simply by running **make**.

The program **generate\_square\_grid.exe** makes a square DEM with a single
outlet near the bottom-left corner. The grid size is specified as a
command-line argument.

The two reference implementations use the D8 neighbour system to indicate flow
directions. In this system all the flow from a central cell is directed to a
single neighbour which is represented by a number according to the following
system where 0 indicates the central cell.

    234
    105
    876

The program **barnes\_algorithm.exe** reads in a DEM file specified on the
command line. The file may be generated by **generate\_square\_grid.exe**, but
may also be any ArcGrid ASCII file. The program will time itself and report the
results back. The program will print the determined flow directions for the DEM
to a file named **out\_barnes**. The determined flow directions are also
printed as a matrix of arrows to **out\_barnes\_arrows**.

The program **garbrecht\_algorithm.exe** attempts to reproduce the algorithm
described by *Garbrecht and Martz* (1997). It accepts an ArcGRID ASCII file as
a command line input. The input file may also be generated with
**generate\_square\_grid.exe**. Note that this implementation does not apply
itself iteratively, meaning that some flats will be unresolvable. It writes the
determined flow directions to **out\_garbrecht**. The determined flow
directions are also printed as a matrix of arrows to **out\_garbrecht\_arrows**.

The directory **src/** contains the source code for reference implementations.
The source for the improved algorithm is drawn from the RichDEM hydroanalysis
package. All code can be compiled by running the **makefile** included in the
root directory. Running the BASH script **FIRST_RUN** will compile everything
and run the programs.

At the time of writing, the entire RichDEM code base could be downloaded from:
[https://github.com/r-barnes](https://github.com/r-barnes)
