# Recommended cmake macro use to write a cmake config file.

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ReaktoroConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Include the cmake targets of the project if they have not been yet.
if(NOT TARGET Reaktoro::Reaktoro)
    include("${PACKAGE_PREFIX_DIR}/lib/cmake/Reaktoro/ReaktoroTargets.cmake")
endif()

# Ensure dependencies from the conda environment are used (e.g., Boost).
list(APPEND CMAKE_PREFIX_PATH $ENV{CONDA_PREFIX})

# Find all dependencies below.
find_package(Eigen3 3.3.90 REQUIRED)
find_package(autodiff REQUIRED)
find_package(nlohmann_json 3.4.0 REQUIRED)
find_package(Optima REQUIRED)
find_package(ThermoFun REQUIRED)
find_package(yaml-cpp REQUIRED)
find_package(phreeqc4rkt REQUIRED)

# Recommended check at the end of a cmake config file.
check_required_components(Reaktoro)
