from __future__ import annotations
import reaktoro.reaktoro4py
import typing
import numpy
_Shape = typing.Tuple[int, ...]

__all__ = [
    "ActivityArgs",
    "ActivityModel",
    "ActivityModelCubicEOSParams",
    "ActivityModelDebyeHuckel",
    "ActivityModelDebyeHuckelKielland",
    "ActivityModelDebyeHuckelLimitingLaw",
    "ActivityModelDebyeHuckelPHREEQC",
    "ActivityModelDebyeHuckelParams",
    "ActivityModelDebyeHuckelWATEQ4F",
    "ActivityModelDrummond",
    "ActivityModelDrummondParams",
    "ActivityModelDuanSun",
    "ActivityModelHKF",
    "ActivityModelIdealAqueous",
    "ActivityModelIdealGas",
    "ActivityModelIdealIonExchange",
    "ActivityModelIdealSolution",
    "ActivityModelIonExchange",
    "ActivityModelIonExchangeGainesThomas",
    "ActivityModelPengRobinson",
    "ActivityModelPitzerHMW",
    "ActivityModelRedlichKister",
    "ActivityModelRedlichKwong",
    "ActivityModelRumpf",
    "ActivityModelSetschenow",
    "ActivityModelSoaveRedlichKwong",
    "ActivityModelSpycherPruessEnnis",
    "ActivityModelSpycherReed",
    "ActivityModelVanDerWaals",
    "ActivityProps",
    "ActivityPropsConstRef",
    "ActivityPropsRef",
    "AggregateState",
    "AqueousMixture",
    "AqueousMixtureState",
    "AqueousPhase",
    "AqueousProps",
    "ChemicalFormula",
    "ChemicalProps",
    "ChemicalPropsPhase",
    "ChemicalPropsPhaseConstRef",
    "ChemicalPropsPhaseRef",
    "ChemicalState",
    "ChemicalSystem",
    "CondensedPhase",
    "CondensedPhases",
    "ConstraintEquation",
    "ControlVariableP",
    "ControlVariableQ",
    "CriticalProps",
    "CubicEOSModel",
    "Database",
    "Element",
    "ElementList",
    "ElementalComposition",
    "EquilibriumConditions",
    "EquilibriumDims",
    "EquilibriumOptions",
    "EquilibriumProblem",
    "EquilibriumRestrictions",
    "EquilibriumResult",
    "EquilibriumSolver",
    "EquilibriumSpecs",
    "Exclude",
    "FormationReaction",
    "GaseousPhase",
    "GenericPhase",
    "GenericPhasesGenerator",
    "IonExchangePhase",
    "IonExchangeProps",
    "IonExchangeSurface",
    "IonExchangeSurfaceState",
    "LiquidPhase",
    "Material",
    "Memoization",
    "MineralPhase",
    "MineralPhases",
    "NasaDatabase",
    "Param",
    "Params",
    "Phase",
    "PhaseList",
    "Phases",
    "PhreeqcDatabase",
    "Reaction",
    "ReactionEquation",
    "ReactionProps",
    "ReactionThermoArgs",
    "ReactionThermoModel",
    "ReactionThermoModelConstLgK",
    "ReactionThermoModelGemsLgK",
    "ReactionThermoModelParamsConstLgK",
    "ReactionThermoModelParamsGemsLgK",
    "ReactionThermoModelParamsPhreeqcLgK",
    "ReactionThermoModelParamsVantHoff",
    "ReactionThermoModelPhreeqcLgK",
    "ReactionThermoModelPressureCorrection",
    "ReactionThermoModelVantHoff",
    "ReactionThermoModelYAML",
    "ReactionThermoProps",
    "SolidPhase",
    "Speciate",
    "Species",
    "SpeciesList",
    "SpeciesThermoProps",
    "StandardThermoModel",
    "StandardThermoModelConstant",
    "StandardThermoModelHKF",
    "StandardThermoModelHollandPowell",
    "StandardThermoModelInterpolation",
    "StandardThermoModelMaierKelley",
    "StandardThermoModelMineralHKF",
    "StandardThermoModelNasa",
    "StandardThermoModelParamsConstant",
    "StandardThermoModelParamsHKF",
    "StandardThermoModelParamsHollandPowell",
    "StandardThermoModelParamsInterpolation",
    "StandardThermoModelParamsMaierKelley",
    "StandardThermoModelParamsMineralHKF",
    "StandardThermoModelParamsNasa",
    "StandardThermoModelParamsNasaPolynomial",
    "StandardThermoModelParamsWaterHKF",
    "StandardThermoModelWaterHKF",
    "StandardThermoModelYAML",
    "StandardThermoProps",
    "StateOfMatter",
    "StringList",
    "SubstanceCriticalProps",
    "SubstanceCriticalPropsData",
    "SupcrtDatabase",
    "ThermoFunDatabase",
    "ThermoProps",
    "ThermoPropsPhase",
    "WaterElectroProps",
    "WaterHelmholtzProps",
    "WaterThermoProps",
    "barToPascal",
    "calorieToJoule",
    "chain",
    "cubicCentimeterToCubicMeter",
    "cubicMeterToCubicCentimeter",
    "equilibrate",
    "exclude",
    "extractNames",
    "faradayConstant",
    "identifyAggregateState",
    "interpolate",
    "jouleToCalorie",
    "ln10",
    "parseAggregateState",
    "parseChemicalFormula",
    "parseElectricCharge",
    "parseNumberStringPairs",
    "parseReaction",
    "parseReactionEquation",
    "precision",
    "speciate",
    "units",
    "universalGasConstant",
    "waterCriticalDensity",
    "waterCriticalPressure",
    "waterCriticalTemperature",
    "waterDensityHGK",
    "waterDensityWagnerPruss",
    "waterElectroPropsJohnsonNorton",
    "waterHelmholtzPropsHGK",
    "waterHelmholtzPropsWagnerPruss",
    "waterLiquidDensityHGK",
    "waterLiquidDensityWagnerPruss",
    "waterMolarMass",
    "waterPressureHGK",
    "waterPressureWagnerPruss",
    "waterSaturatedLiquidDensityWagnerPruss",
    "waterSaturatedPressureWagnerPruss",
    "waterSaturatedVapourDensityWagnerPruss",
    "waterSaturationLiquidDensityWagnerPruss",
    "waterSaturationPressureWagnerPruss",
    "waterSaturationVapourDensityWagnerPruss",
    "waterThermoProps",
    "waterThermoPropsHGK",
    "waterThermoPropsHGKMemoized",
    "waterThermoPropsWagnerPruss",
    "waterThermoPropsWagnerPrussMemoized",
    "waterTriplePointDensityLiquid",
    "waterTriplePointDensityVapour",
    "waterTriplePointPressure",
    "waterTriplePointTemperature",
    "waterVaporDensityHGK",
    "waterVaporDensityWagnerPruss",
    "yaml"
]


class ActivityArgs():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    @property
    def P(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def T(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def x(self) -> Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >:
        """
        :type: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >
        """
    pass
class ActivityModel():
    @staticmethod
    def __call__(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def apply(*args, **kwargs) -> typing.Any: ...
    def params(self) -> typing.List[Reaktoro::Param]: ...
    pass
class ActivityModelCubicEOSParams():
    def __init__(self) -> None: ...
    pass
class ActivityModelDebyeHuckelParams():
    def __init__(self) -> None: ...
    @staticmethod
    def aion(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def bion(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def bneutral(*args, **kwargs) -> typing.Any: ...
    def setKielland(self) -> None: ...
    def setLimitingLaw(self) -> None: ...
    def setPHREEQC(self) -> None: ...
    def setWATEQ4F(self) -> None: ...
    @property
    def aiondefault(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @aiondefault.setter
    def aiondefault(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def aions(self) -> typing.Dict[str, autodiff::detail::Real<1,double>]:
        """
        :type: typing.Dict[str, autodiff::detail::Real<1,double>]
        """
    @aions.setter
    def aions(self, arg0: typing.Dict[str, autodiff::detail::Real<1,double>]) -> None:
        pass
    @property
    def biondefault(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @biondefault.setter
    def biondefault(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bions(self) -> typing.Dict[str, autodiff::detail::Real<1,double>]:
        """
        :type: typing.Dict[str, autodiff::detail::Real<1,double>]
        """
    @bions.setter
    def bions(self, arg0: typing.Dict[str, autodiff::detail::Real<1,double>]) -> None:
        pass
    @property
    def bneutraldefault(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bneutraldefault.setter
    def bneutraldefault(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bneutrals(self) -> typing.Dict[str, autodiff::detail::Real<1,double>]:
        """
        :type: typing.Dict[str, autodiff::detail::Real<1,double>]
        """
    @bneutrals.setter
    def bneutrals(self, arg0: typing.Dict[str, autodiff::detail::Real<1,double>]) -> None:
        pass
    pass
class ActivityModelDrummondParams():
    def __init__(self) -> None: ...
    @property
    def a1(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @a1.setter
    def a1(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def a2(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @a2.setter
    def a2(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def a3(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @a3.setter
    def a3(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def a4(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @a4.setter
    def a4(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def a5(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @a5.setter
    def a5(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class ActivityProps():
    def __init__(self) -> None: ...
    def create(self) -> ActivityProps: ...
    @property
    def Cpx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Cpx.setter
    def Cpx(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Gx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Gx.setter
    def Gx(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Hx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Hx.setter
    def Hx(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Vx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Vx.setter
    def Vx(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VxP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VxP.setter
    def VxP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VxT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VxT.setter
    def VxT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def extra(self) -> typing.Dict[str, std::any]:
        """
        :type: typing.Dict[str, std::any]
        """
    @extra.setter
    def extra(self, arg0: typing.Dict[str, std::any]) -> None:
        pass
    @property
    def ln_a(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @ln_a.setter
    def ln_a(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    @property
    def ln_g(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @ln_g.setter
    def ln_g(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    pass
class ActivityPropsConstRef():
    @property
    def Cpx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def Gx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def Hx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def Vx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def VxP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def VxT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def extra(self) -> typing.Dict[str, std::any]:
        """
        :type: typing.Dict[str, std::any]
        """
    @property
    def ln_a(self) -> Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >:
        """
        :type: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >
        """
    @property
    def ln_g(self) -> Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >:
        """
        :type: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >
        """
    pass
class ActivityPropsRef():
    @property
    def Cpx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Cpx.setter
    def Cpx(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Gx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Gx.setter
    def Gx(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Hx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Hx.setter
    def Hx(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Vx(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Vx.setter
    def Vx(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VxP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VxP.setter
    def VxP(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VxT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VxT.setter
    def VxT(self, arg1: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def extra(self) -> typing.Dict[str, std::any]:
        """
        :type: typing.Dict[str, std::any]
        """
    @extra.setter
    def extra(self, arg1: typing.Dict[str, std::any]) -> None:
        pass
    @property
    def ln_a(self) -> Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >:
        """
        :type: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >
        """
    @ln_a.setter
    def ln_a(self, arg0: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >) -> None:
        pass
    @property
    def ln_g(self) -> Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >:
        """
        :type: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >
        """
    @ln_g.setter
    def ln_g(self, arg0: Eigen::Ref<Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>,0,Eigen::InnerStride<1> >) -> None:
        pass
    pass
class AggregateState():
    """
    Members:

      Gas

      Liquid

      Solid

      Plasma

      CondensedPhase

      Fluid

      LiquidCrystal

      CrystallineSolid

      AmorphousSolid

      Vitreous

      Adsorbed

      Monomeric

      Polymeric

      SolidSolution

      IonExchange

      Aqueous

      Undefined
    """
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __init__(self, value: int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Adsorbed: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Adsorbed: 10>
    AmorphousSolid: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.AmorphousSolid: 8>
    Aqueous: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Aqueous: 15>
    CondensedPhase: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.CondensedPhase: 4>
    CrystallineSolid: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.CrystallineSolid: 7>
    Fluid: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Fluid: 5>
    Gas: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Gas: 0>
    IonExchange: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.IonExchange: 14>
    Liquid: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Liquid: 1>
    LiquidCrystal: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.LiquidCrystal: 6>
    Monomeric: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Monomeric: 11>
    Plasma: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Plasma: 3>
    Polymeric: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Polymeric: 12>
    Solid: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Solid: 2>
    SolidSolution: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.SolidSolution: 13>
    Undefined: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Undefined: 16>
    Vitreous: reaktoro.reaktoro4py.AggregateState # value = <AggregateState.Vitreous: 9>
    __members__: dict # value = {'Gas': <AggregateState.Gas: 0>, 'Liquid': <AggregateState.Liquid: 1>, 'Solid': <AggregateState.Solid: 2>, 'Plasma': <AggregateState.Plasma: 3>, 'CondensedPhase': <AggregateState.CondensedPhase: 4>, 'Fluid': <AggregateState.Fluid: 5>, 'LiquidCrystal': <AggregateState.LiquidCrystal: 6>, 'CrystallineSolid': <AggregateState.CrystallineSolid: 7>, 'AmorphousSolid': <AggregateState.AmorphousSolid: 8>, 'Vitreous': <AggregateState.Vitreous: 9>, 'Adsorbed': <AggregateState.Adsorbed: 10>, 'Monomeric': <AggregateState.Monomeric: 11>, 'Polymeric': <AggregateState.Polymeric: 12>, 'SolidSolution': <AggregateState.SolidSolution: 13>, 'IonExchange': <AggregateState.IonExchange: 14>, 'Aqueous': <AggregateState.Aqueous: 15>, 'Undefined': <AggregateState.Undefined: 16>}
    pass
class AqueousMixture():
    def __init__(self, arg0: SpeciesList) -> None: ...
    def anions(self) -> SpeciesList: ...
    def cations(self) -> SpeciesList: ...
    def charged(self) -> SpeciesList: ...
    def charges(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def clone(self) -> AqueousMixture: ...
    def dissociationMatrix(self) -> numpy.ndarray[numpy.float64, _Shape[m, n]]: ...
    def indexWater(self) -> int: ...
    def indicesAnions(self) -> typing.List[int]: ...
    def indicesCations(self) -> typing.List[int]: ...
    def indicesCharged(self) -> typing.List[int]: ...
    def indicesNeutral(self) -> typing.List[int]: ...
    def neutral(self) -> SpeciesList: ...
    @typing.overload
    def species(self) -> SpeciesList: ...
    @typing.overload
    def species(self, arg0: int) -> Species: ...
    @staticmethod
    def state(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withWaterDensityFn(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withWaterDielectricConstantFn(*args, **kwargs) -> typing.Any: ...
    pass
class AqueousMixtureState():
    def __init__(self) -> None: ...
    @property
    def Ie(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Ie.setter
    def Ie(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Is(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Is.setter
    def Is(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def P(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @P.setter
    def P(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def T(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @T.setter
    def T(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilon(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilon.setter
    def epsilon(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def m(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @m.setter
    def m(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    @property
    def ms(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @ms.setter
    def ms(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    @property
    def rho(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @rho.setter
    def rho(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class GenericPhase():
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    @staticmethod
    def activityModel(*args, **kwargs) -> typing.Any: ...
    def additionalAggregateStates(self) -> typing.List[AggregateState]: ...
    def aggregateState(self) -> AggregateState: ...
    def convert(self, arg0: Database, arg1: typing.List[str]) -> Phase: ...
    def elements(self) -> typing.List[str]: ...
    @staticmethod
    def idealActivityModel(*args, **kwargs) -> typing.Any: ...
    def name(self) -> str: ...
    def named(self, arg0: str) -> GenericPhase: ...
    @staticmethod
    @typing.overload
    def set(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def set(self, arg0: AggregateState) -> GenericPhase: ...
    @staticmethod
    def setActivityModel(*args, **kwargs) -> typing.Any: ...
    def setAggregateState(self, arg0: AggregateState) -> GenericPhase: ...
    @staticmethod
    def setIdealActivityModel(*args, **kwargs) -> typing.Any: ...
    def setName(self, arg0: str) -> GenericPhase: ...
    @staticmethod
    def setStateOfMatter(*args, **kwargs) -> typing.Any: ...
    def species(self) -> typing.List[str]: ...
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: ...
    pass
class AqueousProps():
    @staticmethod
    def Eh(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self, arg0: ChemicalProps) -> None: ...
    @typing.overload
    def __init__(self, arg0: ChemicalState) -> None: ...
    @typing.overload
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def alkalinity(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elementMolalities(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elementMolality(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def ionicStrength(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def ionicStrengthEffective(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def ionicStrengthStoichiometric(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def output(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def output(self, arg0: str) -> None: ...
    @staticmethod
    def pE(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def pH(*args, **kwargs) -> typing.Any: ...
    def phase(self) -> Phase: ...
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndex(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndexLg(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndexLn(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndices(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndicesLg(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def saturationIndicesLn(*args, **kwargs) -> typing.Any: ...
    def saturationSpecies(self) -> SpeciesList: ...
    def setActivityModel(self, arg0: typing.Union[int, int, str], arg1: typing.Callable[[SpeciesList], ActivityModel]) -> None: ...
    @staticmethod
    def speciesMolalities(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesMolality(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def update(self, arg0: ChemicalProps) -> None: ...
    @typing.overload
    def update(self, arg0: ChemicalState) -> None: ...
    pass
class ChemicalFormula():
    def __eq__(self, arg0: ChemicalFormula) -> bool: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @typing.overload
    def __init__(self, formula: str, symbols: typing.List[typing.Tuple[str, float]], charge: float) -> None: ...
    def __repr__(self) -> str: ...
    def charge(self) -> float: ...
    def coefficient(self, arg0: str) -> float: ...
    def coefficients(self) -> typing.List[float]: ...
    def elements(self) -> typing.List[typing.Tuple[str, float]]: ...
    def equivalent(self, arg0: ChemicalFormula) -> bool: ...
    def molarMass(self) -> float: ...
    def str(self) -> str: ...
    def symbols(self) -> typing.List[str]: ...
    __hash__ = None
    pass
class ChemicalProps():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def amount(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species amounts in the system (in mol).
        """
    @staticmethod
    def charge(*args, **kwargs) -> typing.Any: 
        """
        Return the amount of electric charge in the system (in mol).
        """
    @staticmethod
    def density(*args, **kwargs) -> typing.Any: 
        """
        Return the density of the system (in kg/m³).
        """
    @staticmethod
    def elementAmount(*args, **kwargs) -> typing.Any: 
        """
        Return the amount of an element in the system (in mol).
        """
    @staticmethod
    def elementAmountAmongSpecies(*args, **kwargs) -> typing.Any: 
        """
        Return the amount of an element among a group of species in the system (in mol).
        """
    @staticmethod
    def elementAmountInPhase(*args, **kwargs) -> typing.Any: 
        """
        Return the amount of an element in the system (in mol).
        """
    @staticmethod
    def elementAmounts(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the elements in the system (in mol).
        """
    @staticmethod
    def elementAmountsAmongSpecies(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the elements among a group of species in the system (in mol).
        """
    @staticmethod
    def elementAmountsInPhase(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the elements in a phase of the system (in mol).
        """
    @staticmethod
    def elementMass(*args, **kwargs) -> typing.Any: 
        """
        Return the mass of an element in the system (in kg).
        """
    @staticmethod
    def elementMassAmongSpecies(*args, **kwargs) -> typing.Any: 
        """
        Return the mass of an element among a group of species in the system (in kg).
        """
    @staticmethod
    def elementMassInPhase(*args, **kwargs) -> typing.Any: 
        """
        Return the mass of an element in the system (in kg).
        """
    @staticmethod
    def enthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the enthalpy of formation of the system (in J).
        """
    @staticmethod
    def entropy(*args, **kwargs) -> typing.Any: 
        """
        Return the entropy of formation of the system (in J/K).
        """
    @staticmethod
    def gibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Gibbs energy of formation of the system (in J).
        """
    @staticmethod
    def heatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the isobaric heat capacity of the system (in J/K).
        """
    @staticmethod
    def heatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the isochoric heat capacity of the system (in J/K).
        """
    @staticmethod
    def helmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Helmholtz energy of formation of the system (in J).
        """
    def indicesPhasesWithFluidState(self) -> typing.List[int]: 
        """
        Return the indices of the phases in liquid, gaseous, or supercritical states.
        """
    def indicesPhasesWithSolidState(self) -> typing.List[int]: 
        """
        Return the indices of the phases in solid states.
        """
    @staticmethod
    def indicesPhasesWithState(*args, **kwargs) -> typing.Any: 
        """
        Return the indices of the phases in a given state of matter.
        """
    @staticmethod
    def indicesPhasesWithStates(*args, **kwargs) -> typing.Any: 
        """
        Return the indices of the phases with one of the given states of matter.
        """
    def indicesSpeciesInPhasesWithFluidState(self) -> typing.List[int]: 
        """
        Return the indices of the phases with liquid, gaseous, or supercritical states.
        """
    def indicesSpeciesInPhasesWithSolidState(self) -> typing.List[int]: 
        """
        Return the indices of the phases with solid states.
        """
    @staticmethod
    def indicesSpeciesInPhasesWithState(*args, **kwargs) -> typing.Any: 
        """
        Return the indices of the phases with a given state of matter.
        """
    @staticmethod
    def indicesSpeciesInPhasesWithStates(*args, **kwargs) -> typing.Any: 
        """
        Return the indices of the phases with one of the given states of matter.
        """
    @staticmethod
    def internalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the internal energy of formation of the system (in J).
        """
    @staticmethod
    def mass(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species masses in the system (in kg).
        """
    @staticmethod
    def molarEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar enthalpy of formation of the system (in J/mol).
        """
    @staticmethod
    def molarEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar entropy of formation of the system (in J/(mol·K)).
        """
    @staticmethod
    def molarGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Gibbs energy of formation of the system (in J/mol).
        """
    @staticmethod
    def molarHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isobaric heat capacity of the system (in J/(mol·K)).
        """
    @staticmethod
    def molarHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isochoric heat capacity of the system (in J/(mol·K)).
        """
    @staticmethod
    def molarHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Helmholtz energy of formation of the system (in J/mol).
        """
    @staticmethod
    def molarInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar internal energy of formation of the system (in J/mol).
        """
    @staticmethod
    def molarVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the molar volume of the system (in m³/mol).
        """
    @staticmethod
    def molarVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the molar volume of the system (in m³/(mol·Pa)).
        """
    @staticmethod
    def molarVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the molar volume of the system (in m³/(mol·K)).
        """
    @staticmethod
    @typing.overload
    def output(*args, **kwargs) -> typing.Any: 
        """
        Output the chemical properties of the system to a stream.

        Output the chemical properties of the system to a file.
        """
    @typing.overload
    def output(self, arg0: str) -> None: ...
    @staticmethod
    def phaseProps(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical properties of a phase with given index.

        Return the chemical properties of a phase with given index.
        """
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure of the system (in Pa).
        """
    @staticmethod
    def speciesActivitiesLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activities of the species in the system.
        """
    @staticmethod
    def speciesActivity(*args, **kwargs) -> typing.Any: 
        """
        Return the activity of a species in the system.
        """
    @staticmethod
    def speciesActivityCoefficient(*args, **kwargs) -> typing.Any: 
        """
        Return the activity coefficient of a species in the system.
        """
    @staticmethod
    def speciesActivityCoefficientLg(*args, **kwargs) -> typing.Any: 
        """
        Return the lg activity coefficient of a species in the system.
        """
    @staticmethod
    def speciesActivityCoefficientLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity coefficient of a species in the system.
        """
    @staticmethod
    def speciesActivityCoefficientsLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity coefficients of the species in the system.
        """
    @staticmethod
    def speciesActivityLg(*args, **kwargs) -> typing.Any: 
        """
        Return the lg activity of a species in the system.
        """
    @staticmethod
    def speciesActivityLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity of a species in the system.
        """
    @staticmethod
    def speciesAmount(*args, **kwargs) -> typing.Any: 
        """
        Return the amount of a species in the system (in mol).
        """
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the species in the system (in mol).
        """
    @staticmethod
    def speciesChemicalPotential(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical potential of a species in the system.
        """
    @staticmethod
    def speciesChemicalPotentials(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical potentials of the species in the system (in J/mol).
        """
    @staticmethod
    def speciesConcentration(*args, **kwargs) -> typing.Any: 
        """
        Return the concentration (activity divided by activity coefficient) of a species in the system.
        """
    @staticmethod
    def speciesConcentrationLg(*args, **kwargs) -> typing.Any: 
        """
        Return the lg concentration (activity divided by activity coefficient) of a species in the system.
        """
    @staticmethod
    def speciesConcentrationLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln concentration (activity divided by activity coefficient) of a species in the system.
        """
    @staticmethod
    def speciesConcentrationsLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln concentrations (activity divided by activity coefficient) of the species in the system.
        """
    @staticmethod
    def speciesMass(*args, **kwargs) -> typing.Any: 
        """
        Return the mass of a species in the system.
        """
    @staticmethod
    def speciesMasses(*args, **kwargs) -> typing.Any: 
        """
        Return the masses of the species in the system (in kg).
        """
    @staticmethod
    def speciesMoleFraction(*args, **kwargs) -> typing.Any: 
        """
        Return the mole fraction of a species in the system.
        """
    @staticmethod
    def speciesMoleFractions(*args, **kwargs) -> typing.Any: 
        """
        Return the mole fractions of the species in the system.
        """
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar enthalpies of formation of the species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar enthalpy of formation of a species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar entropies of formation of the species in the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar entropy of formation of the species a the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Gibbs energies of formation of the species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Gibbs energy of formation of a species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isobaric heat capacities of the species in the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isochoric heat capacities of the species in the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isobaric heat capacity of the species a the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isochoric heat capacity of the species a the system (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Helmholtz energies of formation of the species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Helmholtz energy of formation of a species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar internal energies of formation of the species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar internal energy of formation of a species in the system (in J/mol).
        """
    @staticmethod
    def speciesStandardVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar volume of a species in the system (in m³/mol).
        """
    @staticmethod
    def speciesStandardVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the standard partial molar volume of a species in the system (in m³/(mol·Pa)).
        """
    @staticmethod
    def speciesStandardVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the standard partial molar volume of a species in the system (in m³/(mol·K)).
        """
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar volumes of the species in the system (in m³/mol).
        """
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the standard molar volumes of the species in the system (in m³/(mol·Pa)).
        """
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the standard molar volumes of the species in the system (in m³/(mol·K)).
        """
    @staticmethod
    def specificEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific enthalpy of formation of the system (in J/kg).
        """
    @staticmethod
    def specificEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific entropy of formation of the system (in J/(kg·K)).
        """
    @staticmethod
    def specificGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Gibbs energy of formation of the system (in J/kg).
        """
    @staticmethod
    def specificHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isobaric heat capacity of the system (in J/(kg·K)).
        """
    @staticmethod
    def specificHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isochoric heat capacity of the system (in J/(kg·K)).
        """
    @staticmethod
    def specificHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Helmholtz energy of formation of the system (in J/kg).
        """
    @staticmethod
    def specificInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific internal energy of formation of the system (in J/kg).
        """
    @staticmethod
    def specificVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the specific volume of the system (in m³/kg).
        """
    @staticmethod
    def specificVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the specific volume of the system (in m³/(kg·Pa)).
        """
    @staticmethod
    def specificVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the specific volume of the system (in m³/(kg·K)).
        """
    @staticmethod
    def system(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical system associated with these chemical properties.
        """
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature of the system (in K).
        """
    @staticmethod
    @typing.overload
    def update(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the system.

        Update the chemical properties of the system.

        Update the chemical properties of the system with serialized data.

        Update the chemical properties of the system with serialized data.
        """
    @typing.overload
    def update(self, arg0: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> None: ...
    @staticmethod
    def updateIdeal(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the system using ideal activity models.

        Update the chemical properties of the system using ideal activity models.
        """
    @staticmethod
    def volume(*args, **kwargs) -> typing.Any: 
        """
        Return the volume of the system (in m³).
        """
    @staticmethod
    def volumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the volume of the system (in m³/Pa).
        """
    @staticmethod
    def volumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the volume of the system (in m³/K).
        """
    pass
class ChemicalPropsPhase():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def amount(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species amounts in the phase (in mol).
        """
    @staticmethod
    def data(*args, **kwargs) -> typing.Any: 
        """
        Return the primary chemical property data of the phase from which others are calculated.
        """
    @staticmethod
    def density(*args, **kwargs) -> typing.Any: 
        """
        Return the density of the phase (in kg/m³).
        """
    @staticmethod
    def enthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the enthalpy of the phase (in J).
        """
    @staticmethod
    def entropy(*args, **kwargs) -> typing.Any: 
        """
        Return the entropy of the phase (in J/K).
        """
    @staticmethod
    def gibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Gibbs energy of the phase (in J).
        """
    @staticmethod
    def heatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the isobaric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def heatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the isochoric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def helmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Helmholtz energy of the phase (in J).
        """
    @staticmethod
    def internalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the internal energy of the phase (in J).
        """
    @staticmethod
    def mass(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species masses in the phase (in kg).
        """
    @staticmethod
    def molarEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar enthalpy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar entropy of formation of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Gibbs energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isobaric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isochoric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Helmholtz energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar internal energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarMass(*args, **kwargs) -> typing.Any: 
        """
        Return the molar mass of the phase (in kg/mol).
        """
    @staticmethod
    def molarVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the molar volume of the phase (in m³/mol).
        """
    @staticmethod
    def molarVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the molar volume of the phase (in m³/(mol·Pa)).
        """
    @staticmethod
    def molarVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the molar volume of the phase (in m³/(mol·K)).
        """
    @staticmethod
    def phase(*args, **kwargs) -> typing.Any: 
        """
        Return the underlying Phase object.
        """
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure of the phase (in Pa).
        """
    @staticmethod
    def soundSpeed(*args, **kwargs) -> typing.Any: 
        """
        Return the speed of sound in the phase (in m/s).
        """
    @staticmethod
    def speciesActivitiesLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activities of the species in the phase.
        """
    @staticmethod
    def speciesActivityCoefficientsLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity coefficients of the species in the phase.
        """
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the species in the phase (in mol).
        """
    @staticmethod
    def speciesChemicalPotentials(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical potentials of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesMoleFractions(*args, **kwargs) -> typing.Any: 
        """
        Return the mole fractions of the species in the phase.
        """
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar enthalpies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar entropies of formation of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Gibbs energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isobaric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isochoric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Helmholtz energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar internal energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar volumes of the species in the phase (in m³/mol).
        """
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def specificEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific enthalpy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific entropy of formation of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Gibbs energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isobaric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isochoric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Helmholtz energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific internal energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the specific volume of the phase (in m³/kg).
        """
    @staticmethod
    def specificVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the specific volume of the phase (in m³/(kg·Pa)).
        """
    @staticmethod
    def specificVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the specific volume of the phase (in m³/(kg·K)).
        """
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: 
        """
        Return the state of matter of the phase.
        """
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature of the phase (in K).
        """
    @staticmethod
    def update(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the phase.
        """
    @staticmethod
    def updateIdeal(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the phase using ideal activity models.
        """
    @staticmethod
    def volume(*args, **kwargs) -> typing.Any: 
        """
        Return the volume of the phase (in m³).
        """
    @staticmethod
    def volumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the volume of the phase (in m³/Pa).
        """
    @staticmethod
    def volumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the volume of the phase (in m³/K).
        """
    pass
class ChemicalPropsPhaseConstRef():
    @staticmethod
    def amount(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species amounts in the phase (in mol).
        """
    @staticmethod
    def data(*args, **kwargs) -> typing.Any: 
        """
        Return the primary chemical property data of the phase from which others are calculated.
        """
    @staticmethod
    def density(*args, **kwargs) -> typing.Any: 
        """
        Return the density of the phase (in kg/m³).
        """
    @staticmethod
    def enthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the enthalpy of the phase (in J).
        """
    @staticmethod
    def entropy(*args, **kwargs) -> typing.Any: 
        """
        Return the entropy of the phase (in J/K).
        """
    @staticmethod
    def gibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Gibbs energy of the phase (in J).
        """
    @staticmethod
    def heatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the isobaric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def heatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the isochoric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def helmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Helmholtz energy of the phase (in J).
        """
    @staticmethod
    def internalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the internal energy of the phase (in J).
        """
    @staticmethod
    def mass(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species masses in the phase (in kg).
        """
    @staticmethod
    def molarEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar enthalpy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar entropy of formation of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Gibbs energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isobaric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isochoric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Helmholtz energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar internal energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarMass(*args, **kwargs) -> typing.Any: 
        """
        Return the molar mass of the phase (in kg/mol).
        """
    @staticmethod
    def molarVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the molar volume of the phase (in m³/mol).
        """
    @staticmethod
    def molarVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the molar volume of the phase (in m³/(mol·Pa)).
        """
    @staticmethod
    def molarVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the molar volume of the phase (in m³/(mol·K)).
        """
    @staticmethod
    def phase(*args, **kwargs) -> typing.Any: 
        """
        Return the underlying Phase object.
        """
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure of the phase (in Pa).
        """
    @staticmethod
    def soundSpeed(*args, **kwargs) -> typing.Any: 
        """
        Return the speed of sound in the phase (in m/s).
        """
    @staticmethod
    def speciesActivitiesLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activities of the species in the phase.
        """
    @staticmethod
    def speciesActivityCoefficientsLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity coefficients of the species in the phase.
        """
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the species in the phase (in mol).
        """
    @staticmethod
    def speciesChemicalPotentials(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical potentials of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesMoleFractions(*args, **kwargs) -> typing.Any: 
        """
        Return the mole fractions of the species in the phase.
        """
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar enthalpies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar entropies of formation of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Gibbs energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isobaric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isochoric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Helmholtz energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar internal energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar volumes of the species in the phase (in m³/mol).
        """
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def specificEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific enthalpy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific entropy of formation of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Gibbs energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isobaric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isochoric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Helmholtz energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific internal energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the specific volume of the phase (in m³/kg).
        """
    @staticmethod
    def specificVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the specific volume of the phase (in m³/(kg·Pa)).
        """
    @staticmethod
    def specificVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the specific volume of the phase (in m³/(kg·K)).
        """
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: 
        """
        Return the state of matter of the phase.
        """
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature of the phase (in K).
        """
    @staticmethod
    def volume(*args, **kwargs) -> typing.Any: 
        """
        Return the volume of the phase (in m³).
        """
    @staticmethod
    def volumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the volume of the phase (in m³/Pa).
        """
    @staticmethod
    def volumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the volume of the phase (in m³/K).
        """
    pass
class ChemicalPropsPhaseRef():
    @staticmethod
    def amount(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species amounts in the phase (in mol).
        """
    @staticmethod
    def data(*args, **kwargs) -> typing.Any: 
        """
        Return the primary chemical property data of the phase from which others are calculated.
        """
    @staticmethod
    def density(*args, **kwargs) -> typing.Any: 
        """
        Return the density of the phase (in kg/m³).
        """
    @staticmethod
    def enthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the enthalpy of the phase (in J).
        """
    @staticmethod
    def entropy(*args, **kwargs) -> typing.Any: 
        """
        Return the entropy of the phase (in J/K).
        """
    @staticmethod
    def gibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Gibbs energy of the phase (in J).
        """
    @staticmethod
    def heatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the isobaric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def heatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the isochoric heat capacity of the phase (in J/K).
        """
    @staticmethod
    def helmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the Helmholtz energy of the phase (in J).
        """
    @staticmethod
    def internalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the internal energy of the phase (in J).
        """
    @staticmethod
    def mass(*args, **kwargs) -> typing.Any: 
        """
        Return the sum of species masses in the phase (in kg).
        """
    @staticmethod
    def molarEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar enthalpy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar entropy of formation of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Gibbs energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isobaric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the molar isochoric heat capacity of the phase (in J/(mol·K)).
        """
    @staticmethod
    def molarHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar Helmholtz energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the molar internal energy of formation of the phase (in J/mol).
        """
    @staticmethod
    def molarMass(*args, **kwargs) -> typing.Any: 
        """
        Return the molar mass of the phase (in kg/mol).
        """
    @staticmethod
    def molarVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the molar volume of the phase (in m³/mol).
        """
    @staticmethod
    def molarVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the molar volume of the phase (in m³/(mol·Pa)).
        """
    @staticmethod
    def molarVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the molar volume of the phase (in m³/(mol·K)).
        """
    @staticmethod
    def phase(*args, **kwargs) -> typing.Any: 
        """
        Return the underlying Phase object.
        """
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure of the phase (in Pa).
        """
    @staticmethod
    def soundSpeed(*args, **kwargs) -> typing.Any: 
        """
        Return the speed of sound in the phase (in m/s).
        """
    @staticmethod
    def speciesActivitiesLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activities of the species in the phase.
        """
    @staticmethod
    def speciesActivityCoefficientsLn(*args, **kwargs) -> typing.Any: 
        """
        Return the ln activity coefficients of the species in the phase.
        """
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: 
        """
        Return the amounts of the species in the phase (in mol).
        """
    @staticmethod
    def speciesChemicalPotentials(*args, **kwargs) -> typing.Any: 
        """
        Return the chemical potentials of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesMoleFractions(*args, **kwargs) -> typing.Any: 
        """
        Return the mole fractions of the species in the phase.
        """
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar enthalpies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar entropies of formation of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Gibbs energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isobaric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar isochoric heat capacities of the species in the phase (in J/(mol·K)).
        """
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar Helmholtz energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar internal energies of formation of the species in the phase (in J/mol).
        """
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: 
        """
        Return the standard partial molar volumes of the species in the phase (in m³/mol).
        """
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the standard molar volumes of the species in the phase (in m³/(mol·K)).
        """
    @staticmethod
    def specificEnthalpy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific enthalpy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificEntropy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific entropy of formation of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificGibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Gibbs energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificHeatCapacityConstP(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isobaric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHeatCapacityConstV(*args, **kwargs) -> typing.Any: 
        """
        Return the specific isochoric heat capacity of the phase (in J/(kg·K)).
        """
    @staticmethod
    def specificHelmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific Helmholtz energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificInternalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Return the specific internal energy of formation of the phase (in J/kg).
        """
    @staticmethod
    def specificVolume(*args, **kwargs) -> typing.Any: 
        """
        Return the specific volume of the phase (in m³/kg).
        """
    @staticmethod
    def specificVolumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the specific volume of the phase (in m³/(kg·Pa)).
        """
    @staticmethod
    def specificVolumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the specific volume of the phase (in m³/(kg·K)).
        """
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: 
        """
        Return the state of matter of the phase.
        """
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature of the phase (in K).
        """
    @staticmethod
    def update(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the phase.
        """
    @staticmethod
    def updateIdeal(*args, **kwargs) -> typing.Any: 
        """
        Update the chemical properties of the phase using ideal activity models.
        """
    @staticmethod
    def volume(*args, **kwargs) -> typing.Any: 
        """
        Return the volume of the phase (in m³).
        """
    @staticmethod
    def volumeP(*args, **kwargs) -> typing.Any: 
        """
        Return the pressure derivative of the volume of the phase (in m³/Pa).
        """
    @staticmethod
    def volumeT(*args, **kwargs) -> typing.Any: 
        """
        Return the temperature derivative of the volume of the phase (in m³/K).
        """
    pass
class ChemicalState():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self, arg0: ChemicalState) -> None: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def add(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def charge(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def componentAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elementAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def equilibrium(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def output(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def output(self, arg0: str) -> None: ...
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: ...
    def props(self) -> ChemicalProps: ...
    @staticmethod
    def scaleFluidMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleFluidVolume(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scalePhaseMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scalePhaseVolume(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleSolidMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleSolidVolume(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleSpeciesAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleSpeciesAmountsInPhase(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def scaleVolume(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def set(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setPressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setSpeciesAmount(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def setSpeciesAmounts(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def setSpeciesAmounts(self, arg0: float) -> None: ...
    @typing.overload
    def setSpeciesAmounts(self, arg0: numpy.ndarray[numpy.float64]) -> None: ...
    @staticmethod
    def setSpeciesMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setTemperature(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesAmount(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesAmountsInPhase(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesMass(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def system(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: ...
    pass
class ChemicalSystem():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def database(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def element(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elements(*args, **kwargs) -> typing.Any: ...
    def formulaMatrix(self) -> numpy.ndarray[numpy.float64, _Shape[m, n]]: ...
    def formulaMatrixCharge(self) -> numpy.ndarray[numpy.float64, _Shape[m, n]]: ...
    def formulaMatrixElements(self) -> numpy.ndarray[numpy.float64, _Shape[m, n]]: ...
    @staticmethod
    def phase(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def phases(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def species(*args, **kwargs) -> typing.Any: ...
    pass
class CondensedPhase(GenericPhase):
    def __init__(self, arg0: str) -> None: ...
    pass
class GenericPhasesGenerator():
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    @staticmethod
    def activityModel(*args, **kwargs) -> typing.Any: ...
    def additionalAggregateStates(self) -> typing.List[AggregateState]: ...
    def aggregateState(self) -> AggregateState: ...
    def convert(self, arg0: Database, arg1: typing.List[str]) -> typing.List[GenericPhase]: ...
    def elements(self) -> typing.List[str]: ...
    @staticmethod
    def idealActivityModel(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def set(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def set(self, arg0: AggregateState) -> GenericPhasesGenerator: ...
    @staticmethod
    def setActivityModel(*args, **kwargs) -> typing.Any: ...
    def setAggregateState(self, arg0: AggregateState) -> GenericPhasesGenerator: ...
    @staticmethod
    def setIdealActivityModel(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setStateOfMatter(*args, **kwargs) -> typing.Any: ...
    def species(self) -> typing.List[str]: ...
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: ...
    pass
class ConstraintEquation():
    def __init__(self) -> None: ...
    @property
    def fn(self) -> typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]:
        """
        :type: typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]
        """
    @fn.setter
    def fn(self, arg0: typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]) -> None:
        pass
    @property
    def id(self) -> str:
        """
        :type: str
        """
    @id.setter
    def id(self, arg0: str) -> None:
        pass
    pass
class ControlVariableP():
    def __init__(self) -> None: ...
    @property
    def fn(self) -> typing.Callable[[ChemicalProps, autodiff::detail::Real<1,double>], autodiff::detail::Real<1,double>]:
        """
        :type: typing.Callable[[ChemicalProps, autodiff::detail::Real<1,double>], autodiff::detail::Real<1,double>]
        """
    @fn.setter
    def fn(self, arg0: typing.Callable[[ChemicalProps, autodiff::detail::Real<1,double>], autodiff::detail::Real<1,double>]) -> None:
        pass
    @property
    def ispecies(self) -> int:
        """
        :type: int
        """
    @ispecies.setter
    def ispecies(self, arg0: int) -> None:
        pass
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @name.setter
    def name(self, arg0: str) -> None:
        pass
    @property
    def substance(self) -> ChemicalFormula:
        """
        :type: ChemicalFormula
        """
    @substance.setter
    def substance(self, arg0: ChemicalFormula) -> None:
        pass
    pass
class ControlVariableQ():
    def __init__(self) -> None: ...
    @property
    def fn(self) -> typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]:
        """
        :type: typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]
        """
    @fn.setter
    def fn(self, arg0: typing.Callable[[ChemicalProps, Eigen::Ref<Eigen::Matrix<autodiff::detail::Real<1,double>,-1,1,0,-1,1> const ,0,Eigen::InnerStride<1> >], autodiff::detail::Real<1,double>]) -> None:
        pass
    @property
    def id(self) -> str:
        """
        :type: str
        """
    @id.setter
    def id(self, arg0: str) -> None:
        pass
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @name.setter
    def name(self, arg0: str) -> None:
        pass
    @property
    def substance(self) -> ChemicalFormula:
        """
        :type: ChemicalFormula
        """
    @substance.setter
    def substance(self, arg0: ChemicalFormula) -> None:
        pass
    pass
class CriticalProps():
    def __getitem__(self, arg0: int) -> SubstanceCriticalProps: ...
    def __init__(self) -> None: ...
    def __iter__(self) -> typing.Iterator: ...
    @staticmethod
    def __len__() -> int: ...
    @staticmethod
    def append(arg0: SubstanceCriticalProps) -> None: ...
    @staticmethod
    def data() -> typing.List[SubstanceCriticalProps]: ...
    @staticmethod
    def defaultCriticalProps() -> typing.Optional[SubstanceCriticalProps]: ...
    @staticmethod
    def find(arg0: str) -> int: ...
    @staticmethod
    @typing.overload
    def get(arg0: StringList) -> typing.Optional[SubstanceCriticalProps]: ...
    @staticmethod
    @typing.overload
    def get(arg0: str) -> typing.Optional[SubstanceCriticalProps]: ...
    @staticmethod
    def instance() -> CriticalProps: ...
    @staticmethod
    def overwrite(arg0: SubstanceCriticalProps) -> None: ...
    @staticmethod
    def setMissingAs(arg0: str) -> None: ...
    @staticmethod
    def size() -> int: ...
    pass
class CubicEOSModel():
    """
    Members:

      VanDerWaals

      RedlichKwong

      SoaveRedlichKwong

      PengRobinson
    """
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __init__(self, value: int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    PengRobinson: reaktoro.reaktoro4py.CubicEOSModel # value = <CubicEOSModel.PengRobinson: 3>
    RedlichKwong: reaktoro.reaktoro4py.CubicEOSModel # value = <CubicEOSModel.RedlichKwong: 1>
    SoaveRedlichKwong: reaktoro.reaktoro4py.CubicEOSModel # value = <CubicEOSModel.SoaveRedlichKwong: 2>
    VanDerWaals: reaktoro.reaktoro4py.CubicEOSModel # value = <CubicEOSModel.VanDerWaals: 0>
    __members__: dict # value = {'VanDerWaals': <CubicEOSModel.VanDerWaals: 0>, 'RedlichKwong': <CubicEOSModel.RedlichKwong: 1>, 'SoaveRedlichKwong': <CubicEOSModel.SoaveRedlichKwong: 2>, 'PengRobinson': <CubicEOSModel.PengRobinson: 3>}
    pass
class Database():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[Reaktoro::Element], arg1: typing.List[Reaktoro::Species]) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[Reaktoro::Species]) -> None: ...
    @staticmethod
    def addElement(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def addSpecies(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def addSpecies(self, arg0: typing.List[Reaktoro::Species]) -> None: ...
    @staticmethod
    def attachData(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def attachedData(*args, **kwargs) -> typing.Any: ...
    def clear(self) -> None: ...
    @staticmethod
    def element(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elements(*args, **kwargs) -> typing.Any: ...
    def extend(self, arg0: Database) -> None: ...
    @staticmethod
    def fromContents(arg0: str) -> Database: ...
    @staticmethod
    def fromFile(arg0: str) -> Database: ...
    @staticmethod
    def fromStream(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def reaction(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def species(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesWithAggregateState(*args, **kwargs) -> typing.Any: ...
    pass
class Element():
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @typing.overload
    def __init__(self, symbol: str, molar_mass: float, name: str = '', tags: typing.List[str] = []) -> None: ...
    def clone(self) -> Element: ...
    def molarMass(self) -> float: ...
    def name(self) -> str: ...
    def symbol(self) -> str: ...
    def tags(self) -> typing.List[str]: ...
    def withMolarMass(self, arg0: float) -> Element: ...
    def withName(self, arg0: str) -> Element: ...
    def withSymbol(self, arg0: str) -> Element: ...
    def withTags(self, arg0: StringList) -> Element: ...
    pass
class ElementList():
    def __add__(self, arg0: ElementList) -> ElementList: ...
    def __getitem__(self, arg0: int) -> Element: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[Element]) -> None: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def append(self, arg0: Element) -> None: ...
    def data(self) -> typing.List[Element]: ...
    def empty(self) -> bool: ...
    def find(self, arg0: str) -> int: ...
    def findWithName(self, arg0: str) -> int: ...
    def findWithSymbol(self, arg0: str) -> int: ...
    def get(self, arg0: str) -> Element: ...
    def getWithName(self, arg0: str) -> Element: ...
    def getWithSymbol(self, arg0: str) -> Element: ...
    def index(self, arg0: str) -> int: ...
    def indexWithName(self, arg0: str) -> int: ...
    def indexWithSymbol(self, arg0: str) -> int: ...
    def size(self) -> int: ...
    def withNames(self, arg0: StringList) -> ElementList: ...
    def withSymbols(self, arg0: StringList) -> ElementList: ...
    def withTag(self, arg0: str) -> ElementList: ...
    def withTags(self, arg0: StringList) -> ElementList: ...
    def withoutTag(self, arg0: str) -> ElementList: ...
    def withoutTags(self, arg0: StringList) -> ElementList: ...
    pass
class ElementalComposition():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[typing.Tuple[Element, float]]) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[typing.Tuple[str, float]]) -> None: ...
    def coefficient(self, arg0: str) -> float: ...
    def coefficients(self) -> typing.List[float]: ...
    def molarMass(self) -> float: ...
    def repr(self) -> str: ...
    def size(self) -> int: ...
    def symbols(self) -> typing.List[str]: ...
    pass
class EquilibriumConditions():
    @staticmethod
    def Eh(*args, **kwargs) -> typing.Any: 
        """
        Specify the Eh at chemical equilibrium
        """
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def activity(*args, **kwargs) -> typing.Any: 
        """
        Specify the activity of a species at chemical equilibrium
        """
    @staticmethod
    def charge(*args, **kwargs) -> typing.Any: 
        """
        Specify the electric charge at chemical equilibrium
        """
    @staticmethod
    def chemicalPotential(*args, **kwargs) -> typing.Any: 
        """
        Specify the chemical potential of a substance at chemical equilibrium
        """
    @staticmethod
    def elementAmount(*args, **kwargs) -> typing.Any: 
        """
        Specify the amount of an element at chemical equilibrium
        """
    @staticmethod
    def elementAmountInPhase(*args, **kwargs) -> typing.Any: 
        """
        Specify the amount of an element in a phase at chemical equilibrium
        """
    @staticmethod
    def elementMass(*args, **kwargs) -> typing.Any: 
        """
        Specify the mass of an element at chemical equilibrium
        """
    @staticmethod
    def elementMassInPhase(*args, **kwargs) -> typing.Any: 
        """
        Specify the mass of an element in a phase at chemical equilibrium
        """
    @staticmethod
    def enthalpy(*args, **kwargs) -> typing.Any: 
        """
        Specify the enthalpy of the system at chemical equilibrium
        """
    @staticmethod
    def entropy(*args, **kwargs) -> typing.Any: 
        """
        Specify the entropy of the system at chemical equilibrium
        """
    @staticmethod
    def fugacity(*args, **kwargs) -> typing.Any: 
        """
        Specify the fugacity of a gaseous species at chemical equilibrium
        """
    @staticmethod
    def gibbsEnergy(*args, **kwargs) -> typing.Any: 
        """
        Specify the Gibbs energy of the system at chemical equilibrium
        """
    @staticmethod
    def helmholtzEnergy(*args, **kwargs) -> typing.Any: 
        """
        Specify the Helmholtz energy of the system at chemical equilibrium
        """
    def inputNames(self) -> typing.List[str]: ...
    @staticmethod
    def inputValues(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def internalEnergy(*args, **kwargs) -> typing.Any: 
        """
        Specify the internal energy of the system at chemical equilibrium
        """
    @staticmethod
    def lgActivity(*args, **kwargs) -> typing.Any: 
        """
        Specify the lg activity of a species at chemical equilibrium
        """
    @staticmethod
    def lnActivity(*args, **kwargs) -> typing.Any: 
        """
        Specify the ln activity of a species at chemical equilibrium
        """
    def lowerBoundsControlVariablesP(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    @staticmethod
    def pE(*args, **kwargs) -> typing.Any: 
        """
        Specify the pE at chemical equilibrium
        """
    @staticmethod
    def pH(*args, **kwargs) -> typing.Any: 
        """
        Specify the pH at chemical equilibrium
        """
    @staticmethod
    def pMg(*args, **kwargs) -> typing.Any: 
        """
        Specify the pMg at chemical equilibrium
        """
    @staticmethod
    def phaseAmount(*args, **kwargs) -> typing.Any: 
        """
        Specify the amount of a phase at chemical equilibrium
        """
    @staticmethod
    def phaseMass(*args, **kwargs) -> typing.Any: 
        """
        Specify the mass of a phase at chemical equilibrium
        """
    @staticmethod
    def phaseVolume(*args, **kwargs) -> typing.Any: 
        """
        Specify the volume of a phase at chemical equilibrium
        """
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: 
        """
        Specify the pressure of the system at chemical equilibrium
        """
    @staticmethod
    def set(*args, **kwargs) -> typing.Any: ...
    def setLowerBoundPressure(self, value: float, unit: str = 'Pa') -> None: 
        """
        Set the lower bound for pressure during the equilibrium calculation
        """
    def setLowerBoundTemperature(self, value: float, unit: str = 'K') -> None: 
        """
        Set the lower bound for temperature during the equilibrium calculation
        """
    def setLowerBoundTitrant(self, substance: str, value: float, unit: str = 'mol') -> None: 
        """
        Set the lower bound for the amount of a titrant during the equilibrium calculation
        """
    def setUpperBoundPressure(self, value: float, unit: str = 'Pa') -> None: 
        """
        Set the upper bound for pressure during the equilibrium calculation
        """
    def setUpperBoundTemperature(self, value: float, unit: str = 'K') -> None: 
        """
        Set the upper bound for temperature during the equilibrium calculation
        """
    def setUpperBoundTitrant(self, substance: str, value: float, unit: str = 'mol') -> None: 
        """
        Set the upper bound for the amount of a titrant during the equilibrium calculation
        """
    def system(self) -> ChemicalSystem: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: 
        """
        Specify the temperature of the system at chemical equilibrium
        """
    def upperBoundsControlVariablesP(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    @staticmethod
    def volume(*args, **kwargs) -> typing.Any: 
        """
        Specify the volume of the system at chemical equilibrium
        """
    pass
class EquilibriumDims():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @property
    def Nb(self) -> int:
        """
        :type: int
        """
    @Nb.setter
    def Nb(self, arg0: int) -> None:
        pass
    @property
    def Ne(self) -> int:
        """
        :type: int
        """
    @Ne.setter
    def Ne(self, arg0: int) -> None:
        pass
    @property
    def Nn(self) -> int:
        """
        :type: int
        """
    @Nn.setter
    def Nn(self, arg0: int) -> None:
        pass
    @property
    def Np(self) -> int:
        """
        :type: int
        """
    @Np.setter
    def Np(self, arg0: int) -> None:
        pass
    @property
    def Nq(self) -> int:
        """
        :type: int
        """
    @Nq.setter
    def Nq(self, arg0: int) -> None:
        pass
    @property
    def Nt(self) -> int:
        """
        :type: int
        """
    @Nt.setter
    def Nt(self, arg0: int) -> None:
        pass
    @property
    def Nu(self) -> int:
        """
        :type: int
        """
    @Nu.setter
    def Nu(self, arg0: int) -> None:
        pass
    @property
    def Nw(self) -> int:
        """
        :type: int
        """
    @Nw.setter
    def Nw(self, arg0: int) -> None:
        pass
    @property
    def Nx(self) -> int:
        """
        :type: int
        """
    @Nx.setter
    def Nx(self, arg0: int) -> None:
        pass
    pass
class EquilibriumOptions():
    def __init__(self) -> None: ...
    @property
    def epsilon(self) -> float:
        """
        :type: float
        """
    @epsilon.setter
    def epsilon(self, arg0: float) -> None:
        pass
    @property
    def optima(self) -> Optima::Options:
        """
        :type: Optima::Options
        """
    @optima.setter
    def optima(self, arg0: Optima::Options) -> None:
        pass
    @property
    def use_ideal_activity_models(self) -> bool:
        """
        :type: bool
        """
    @use_ideal_activity_models.setter
    def use_ideal_activity_models(self, arg0: bool) -> None:
        pass
    pass
class EquilibriumRestrictions():
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    @typing.overload
    def canDecreaseFreely(self, arg0: int) -> None: ...
    @typing.overload
    def canDecreaseFreely(self, arg0: str) -> None: ...
    @typing.overload
    def canIncreaseFreely(self, arg0: int) -> None: ...
    @typing.overload
    def canIncreaseFreely(self, arg0: str) -> None: ...
    @typing.overload
    def canReactFreely(self, arg0: int) -> None: ...
    @typing.overload
    def canReactFreely(self, arg0: str) -> None: ...
    @typing.overload
    def cannotDecrease(self, arg0: int) -> None: ...
    @typing.overload
    def cannotDecrease(self, arg0: str) -> None: ...
    @typing.overload
    def cannotDecreaseBelow(self, arg0: int, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def cannotDecreaseBelow(self, arg0: str, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def cannotIncrease(self, arg0: int) -> None: ...
    @typing.overload
    def cannotIncrease(self, arg0: str) -> None: ...
    @typing.overload
    def cannotIncreaseAbove(self, arg0: int, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def cannotIncreaseAbove(self, arg0: str, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def cannotReact(self, arg0: int) -> None: ...
    @typing.overload
    def cannotReact(self, arg0: str) -> None: ...
    def speciesCannotDecrease(self) -> typing.Set[int]: ...
    def speciesCannotDecreaseBelow(self) -> typing.Dict[int, float]: ...
    def speciesCannotIncrease(self) -> typing.Set[int]: ...
    def speciesCannotIncreaseAbove(self) -> typing.Dict[int, float]: ...
    def system(self) -> ChemicalSystem: ...
    pass
class EquilibriumProblem(EquilibriumConditions, EquilibriumRestrictions):
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    @staticmethod
    def initialComponentAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def initialPressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def initialSpeciesAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def initialTemperature(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def startWith(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def startWithComponentAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def startWithPressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def startWithSpeciesAmounts(*args, **kwargs) -> typing.Any: ...
    def startWithState(self, arg0: ChemicalState) -> None: ...
    @staticmethod
    def startWithTemperature(*args, **kwargs) -> typing.Any: ...
    pass
class EquilibriumResult():
    def __init__(self) -> None: ...
    @property
    def optima(self) -> Optima::Result:
        """
        :type: Optima::Result
        """
    @optima.setter
    def optima(self, arg0: Optima::Result) -> None:
        pass
    pass
class EquilibriumSolver():
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    def setOptions(self, arg0: EquilibriumOptions) -> None: ...
    @typing.overload
    def solve(self, arg0: ChemicalState) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumConditions) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumConditions, arg2: EquilibriumRestrictions) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumConditions, arg2: EquilibriumRestrictions, arg3: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumConditions, arg2: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumRestrictions) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: EquilibriumRestrictions, arg2: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> EquilibriumResult: ...
    @typing.overload
    def solve(self, arg0: ChemicalState, arg1: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> EquilibriumResult: ...
    pass
class EquilibriumSpecs():
    def Eh(self) -> None: ...
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    def activity(self, arg0: str) -> None: ...
    def addConstraint(self, arg0: ConstraintEquation) -> None: ...
    def addControlVariableP(self, arg0: ControlVariableP) -> None: ...
    def addControlVariableQ(self, arg0: ControlVariableQ) -> None: ...
    @typing.overload
    def addInput(self, arg0: Param) -> int: ...
    @typing.overload
    def addInput(self, arg0: str) -> int: ...
    def addUnknownActivity(self, arg0: str) -> None: ...
    def addUnknownActivityCoefficient(self, arg0: str) -> None: ...
    def addUnknownChemicalPotential(self, arg0: str) -> None: ...
    def addUnknownStandardChemicalPotential(self, arg0: str) -> None: ...
    def addUnknownTitrantAmount(self, arg0: ChemicalFormula) -> None: ...
    def charge(self) -> None: ...
    def chemicalPotential(self, arg0: str) -> None: ...
    def constraintsEquationType(self) -> typing.List[ConstraintEquation]: ...
    def controlVariablesP(self) -> typing.List[ControlVariableP]: ...
    def controlVariablesQ(self) -> typing.List[ControlVariableQ]: ...
    def elementAmount(self, arg0: typing.Union[int, int, str]) -> None: ...
    def elementAmountInPhase(self, arg0: typing.Union[int, int, str], arg1: typing.Union[int, int, str]) -> None: ...
    def elementMass(self, arg0: typing.Union[int, int, str]) -> None: ...
    def elementMassInPhase(self, arg0: typing.Union[int, int, str], arg1: typing.Union[int, int, str]) -> None: ...
    def enthalpy(self) -> None: ...
    def entropy(self) -> None: ...
    def fugacity(self, arg0: str) -> None: ...
    def gibbsEnergy(self) -> None: ...
    def helmholtzEnergy(self) -> None: ...
    def indexControlVariablePressure(self) -> int: ...
    def indexControlVariableTemperature(self) -> int: ...
    def indicesParams(self) -> typing.List[int]: ...
    def inputs(self) -> typing.List[str]: ...
    def internalEnergy(self) -> None: ...
    def isPressureUnknown(self) -> bool: ...
    def isTemperatureUnknown(self) -> bool: ...
    def lgActivity(self, arg0: str) -> None: ...
    @typing.overload
    def lnActivity(self, arg0: Species) -> None: ...
    @typing.overload
    def lnActivity(self, arg0: str) -> None: ...
    def namesConstraints(self) -> typing.List[str]: ...
    def namesControlVariables(self) -> typing.List[str]: ...
    def namesControlVariablesP(self) -> typing.List[str]: ...
    def namesControlVariablesQ(self) -> typing.List[str]: ...
    def namesInputs(self) -> typing.List[str]: ...
    def namesParams(self) -> typing.List[str]: ...
    def namesTitrants(self) -> typing.List[str]: ...
    def namesTitrantsExplicit(self) -> typing.List[str]: ...
    def namesTitrantsImplicit(self) -> typing.List[str]: ...
    def numConstraints(self) -> int: ...
    def numControlVariables(self) -> int: ...
    def numControlVariablesP(self) -> int: ...
    def numControlVariablesQ(self) -> int: ...
    def numInputs(self) -> int: ...
    def numParams(self) -> int: ...
    def numTitrants(self) -> int: ...
    def numTitrantsExplicit(self) -> int: ...
    def numTitrantsImplicit(self) -> int: ...
    def openTo(self, arg0: ChemicalFormula) -> None: ...
    def pE(self) -> None: ...
    def pH(self) -> None: ...
    def pMg(self) -> None: ...
    def params(self) -> typing.List[Param]: ...
    def phaseAmount(self, arg0: typing.Union[int, int, str]) -> None: ...
    def phaseMass(self, arg0: typing.Union[int, int, str]) -> None: ...
    def phaseVolume(self, arg0: typing.Union[int, int, str]) -> None: ...
    def pressure(self) -> None: ...
    def system(self) -> ChemicalSystem: ...
    def temperature(self) -> None: ...
    def titrants(self) -> typing.List[ChemicalFormula]: ...
    def titrantsExplicit(self) -> typing.List[ChemicalFormula]: ...
    def titrantsImplicit(self) -> typing.List[ChemicalFormula]: ...
    def volume(self) -> None: ...
    pass
class Exclude():
    def __init__(self) -> None: ...
    @property
    def tags(self) -> typing.List[str]:
        """
        :type: typing.List[str]
        """
    @tags.setter
    def tags(self, arg0: typing.List[str]) -> None:
        pass
    pass
class FormationReaction():
    def __init__(self) -> None: ...
    def clone(self) -> FormationReaction: ...
    @staticmethod
    def createStandardThermoModel(*args, **kwargs) -> typing.Any: ...
    def initialized(self) -> bool: ...
    @staticmethod
    def productStandardVolumeModel(*args, **kwargs) -> typing.Any: ...
    def reactants(self) -> typing.List[typing.Tuple[Reaktoro::Species, float]]: ...
    @staticmethod
    def reactionThermoModel(*args, **kwargs) -> typing.Any: ...
    def stoichiometry(self, arg0: str) -> float: ...
    @staticmethod
    def withEquilibriumConstant(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withProductStandardVolume(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withProductStandardVolumeModel(*args, **kwargs) -> typing.Any: ...
    def withReactants(self, arg0: typing.List[typing.Tuple[Reaktoro::Species, float]]) -> FormationReaction: ...
    @staticmethod
    def withReactionThermoModel(*args, **kwargs) -> typing.Any: ...
    pass
class GaseousPhase(GenericPhase):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    pass
class AqueousPhase(GenericPhase):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    pass
class CondensedPhases(GenericPhasesGenerator):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    pass
class IonExchangePhase(GenericPhase):
    def __init__(self, arg0: str) -> None: ...
    pass
class IonExchangeProps():
    @typing.overload
    def __init__(self, arg0: ChemicalProps) -> None: ...
    @typing.overload
    def __init__(self, arg0: ChemicalState) -> None: ...
    @typing.overload
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    def __repr__(self) -> str: ...
    @staticmethod
    def elementAmount(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def elementAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def output(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def output(self, arg0: str) -> None: ...
    def phase(self) -> Phase: ...
    @staticmethod
    def speciesActivityCoefficientLg(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesActivityCoefficientsLg(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesAmount(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesAmounts(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesEquivalent(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesEquivalentFraction(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesEquivalentFractions(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesEquivalents(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def update(self, arg0: ChemicalProps) -> None: ...
    @typing.overload
    def update(self, arg0: ChemicalState) -> None: ...
    pass
class IonExchangeSurface():
    def __init__(self, arg0: SpeciesList) -> None: ...
    def clone(self) -> IonExchangeSurface: ...
    @typing.overload
    def species(self) -> SpeciesList: ...
    @typing.overload
    def species(self, arg0: int) -> Species: ...
    @staticmethod
    def state(*args, **kwargs) -> typing.Any: ...
    def ze(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    pass
class IonExchangeSurfaceState():
    def __init__(self) -> None: ...
    @property
    def beta(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @beta.setter
    def beta(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    @property
    def lng(self) -> Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>:
        """
        :type: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>
        """
    @lng.setter
    def lng(self, arg0: Eigen::Array<autodiff::detail::Real<1,double>,-1,1,0,-1,1>) -> None:
        pass
    pass
class LiquidPhase(GenericPhase):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    pass
class Material():
    def __add__(self, arg0: Material) -> Material: ...
    def __call__(self, arg0: float, arg1: str) -> Material: ...
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    def __repr__(self) -> str: ...
    @typing.overload
    def add(self, arg0: Material, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def add(self, arg0: str, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def addMaterialAmount(self, arg0: Material, arg1: float) -> None: ...
    @typing.overload
    def addMaterialAmount(self, arg0: Material, arg1: float, arg2: str) -> None: ...
    def addMaterialMass(self, arg0: Material, arg1: float, arg2: str) -> None: ...
    @typing.overload
    def addSpeciesAmount(self, arg0: typing.Union[int, int, str], arg1: float) -> None: ...
    @typing.overload
    def addSpeciesAmount(self, arg0: typing.Union[int, int, str], arg1: float, arg2: str) -> None: ...
    def addSpeciesMass(self, arg0: typing.Union[int, int, str], arg1: float, arg2: str) -> None: ...
    @typing.overload
    def addSubstanceAmount(self, arg0: ChemicalFormula, arg1: float) -> None: ...
    @typing.overload
    def addSubstanceAmount(self, arg0: ChemicalFormula, arg1: float, arg2: str) -> None: ...
    def addSubstanceMass(self, arg0: ChemicalFormula, arg1: float, arg2: str) -> None: ...
    def amount(self) -> float: ...
    def charge(self) -> float: ...
    def componentAmounts(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def elementAmounts(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    @typing.overload
    def equilibrate(self) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: EquilibriumOptions) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: EquilibriumRestrictions) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: EquilibriumRestrictions, arg1: EquilibriumOptions) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: float, arg1: str, arg2: float, arg3: str) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: float, arg1: str, arg2: float, arg3: str, arg4: EquilibriumOptions) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: float, arg1: str, arg2: float, arg3: str, arg4: EquilibriumRestrictions) -> ChemicalState: ...
    @typing.overload
    def equilibrate(self, arg0: float, arg1: str, arg2: float, arg3: str, arg4: EquilibriumRestrictions, arg5: EquilibriumOptions) -> ChemicalState: ...
    def initialState(self, arg0: float, arg1: float) -> ChemicalState: ...
    def mass(self) -> float: ...
    def molarMass(self) -> float: ...
    def result(self) -> EquilibriumResult: ...
    def scale(self, arg0: float, arg1: str) -> None: ...
    def scaleAmount(self, arg0: float, arg1: str) -> None: ...
    def scaleMass(self, arg0: float, arg1: str) -> None: ...
    def species(self) -> typing.List[typing.Tuple[int, float]]: ...
    def substances(self) -> typing.List[typing.Tuple[ChemicalFormula, float]]: ...
    def system(self) -> ChemicalSystem: ...
    pass
class Memoization():
    @staticmethod
    def disable() -> None: 
        """
        Disable memoization optimization.
        """
    @staticmethod
    def enable() -> None: 
        """
        Enable memoization optimization.
        """
    @staticmethod
    def isDisabled() -> bool: 
        """
        Return true if memoization is currently disabled.
        """
    @staticmethod
    def isEnabled() -> bool: 
        """
        Return true if memoization is currently enabled.
        """
    pass
class MineralPhase(GenericPhase):
    def __init__(self, arg0: str) -> None: ...
    pass
class MineralPhases(GenericPhasesGenerator):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate) -> None: ...
    @typing.overload
    def __init__(self, arg0: Speciate, arg1: Exclude) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    pass
class NasaDatabase(Database):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @staticmethod
    def fromFile(arg0: str) -> Database: ...
    @staticmethod
    def fromStream(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withName(arg0: str) -> NasaDatabase: ...
    pass
class Param():
    @staticmethod
    def Constant(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Param) -> None: ...
    @typing.overload
    def __init__(self, arg0: float) -> None: ...
    @typing.overload
    def __init__(self, arg0: str, arg1: float) -> None: ...
    def assign(self, arg0: Param) -> Param: ...
    def clone(self) -> Param: ...
    @typing.overload
    def id(self) -> str: ...
    @typing.overload
    def id(self, arg0: str) -> Param: ...
    @typing.overload
    def isconst(self) -> bool: ...
    @typing.overload
    def isconst(self, arg0: bool) -> Param: ...
    @typing.overload
    def lowerbound(self) -> float: ...
    @typing.overload
    def lowerbound(self, arg0: float) -> Param: ...
    @typing.overload
    def upperbound(self) -> float: ...
    @typing.overload
    def upperbound(self, arg0: float) -> Param: ...
    @staticmethod
    def value(*args, **kwargs) -> typing.Any: ...
    pass
class Params():
    def __init__(self) -> None: ...
    def at(self, arg0: str) -> Params: ...
    def get(self, arg0: str) -> Param: ...
    @typing.overload
    def set(self, arg0: str, arg1: Param) -> None: ...
    @typing.overload
    def set(self, arg0: str, arg1: Params) -> None: ...
    pass
class Phase():
    def __init__(self) -> None: ...
    def activityModel(self) -> ActivityModel: ...
    def aggregateState(self) -> AggregateState: ...
    def clone(self) -> Phase: ...
    def element(self, arg0: int) -> Element: ...
    def elements(self) -> ElementList: ...
    def idealActivityModel(self) -> ActivityModel: ...
    def name(self) -> str: ...
    @staticmethod
    def species(*args, **kwargs) -> typing.Any: ...
    def speciesMolarMasses(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    @staticmethod
    def stateOfMatter(*args, **kwargs) -> typing.Any: ...
    def withActivityModel(self, arg0: ActivityModel) -> Phase: ...
    def withIdealActivityModel(self, arg0: ActivityModel) -> Phase: ...
    def withName(self, arg0: str) -> Phase: ...
    @staticmethod
    def withSpecies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withStateOfMatter(*args, **kwargs) -> typing.Any: ...
    pass
class PhaseList():
    def __add__(self, arg0: PhaseList) -> PhaseList: ...
    def __getitem__(self, arg0: int) -> Phase: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[Phase]) -> None: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def append(self, arg0: Phase) -> None: ...
    def data(self) -> typing.List[Phase]: ...
    def empty(self) -> bool: ...
    def find(self, arg0: str) -> int: ...
    def findWithAggregateState(self, arg0: AggregateState) -> int: ...
    def findWithName(self, arg0: str) -> int: ...
    @typing.overload
    def findWithSpecies(self, arg0: int) -> int: ...
    @typing.overload
    def findWithSpecies(self, arg0: str) -> int: ...
    @staticmethod
    def findWithStateOfMatter(*args, **kwargs) -> typing.Any: ...
    def get(self, arg0: str) -> Phase: ...
    def getWithName(self, arg0: str) -> Phase: ...
    def index(self, arg0: str) -> int: ...
    def indexWithAggregateState(self, arg0: AggregateState) -> int: ...
    def indexWithName(self, arg0: str) -> int: ...
    @typing.overload
    def indexWithSpecies(self, arg0: int) -> int: ...
    @typing.overload
    def indexWithSpecies(self, arg0: str) -> int: ...
    @staticmethod
    def indexWithStateOfMatter(*args, **kwargs) -> typing.Any: ...
    def indicesSpeciesInPhases(self, arg0: typing.List[int]) -> typing.List[int]: ...
    def numSpeciesUntilPhase(self, arg0: int) -> int: ...
    def size(self) -> int: ...
    def species(self) -> typing.List[Reaktoro::Species]: ...
    def withAggregateState(self, arg0: AggregateState) -> PhaseList: ...
    def withNames(self, arg0: StringList) -> PhaseList: ...
    @staticmethod
    def withStateOfMatter(*args, **kwargs) -> typing.Any: ...
    pass
class Phases():
    def __init__(self, arg0: Database) -> None: ...
    @staticmethod
    def add(*args, **kwargs) -> typing.Any: ...
    def convert(self) -> typing.List[Phase]: ...
    def database(self) -> Database: ...
    pass
class PhreeqcDatabase(Database):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @staticmethod
    def contents(arg0: str) -> str: ...
    @staticmethod
    def fromContents(arg0: str) -> PhreeqcDatabase: ...
    @staticmethod
    def fromFile(arg0: str) -> PhreeqcDatabase: ...
    def load(self, arg0: str) -> PhreeqcDatabase: ...
    @staticmethod
    def namesEmbeddedDatabases() -> typing.List[str]: ...
    @staticmethod
    def withName(arg0: str) -> PhreeqcDatabase: ...
    pass
class Reaction():
    def __init__(self) -> None: ...
    def clone(self) -> Reaction: ...
    @staticmethod
    def equation(*args, **kwargs) -> typing.Any: ...
    def name(self) -> str: ...
    @staticmethod
    def props(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def rate(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def rateFn(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def withEquation(*args, **kwargs) -> typing.Any: ...
    def withName(self, arg0: str) -> Reaction: ...
    @staticmethod
    def withRateFn(*args, **kwargs) -> typing.Any: ...
    pass
class ReactionEquation():
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[typing.Tuple[Reaktoro::Species, float]]) -> None: ...
    def coefficient(self, arg0: str) -> float: ...
    def coefficients(self) -> typing.List[float]: ...
    def empty(self) -> bool: ...
    def size(self) -> int: ...
    def species(self) -> typing.List[Reaktoro::Species]: ...
    pass
class ReactionProps():
    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...
    @property
    def P(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @P.setter
    def P(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def T(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @T.setter
    def T(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dA0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dA0.setter
    def dA0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dCp0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dCp0.setter
    def dCp0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dCv0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dCv0.setter
    def dCv0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dG0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dG0.setter
    def dG0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dH0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dH0.setter
    def dH0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dS0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dS0.setter
    def dS0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dU0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dU0.setter
    def dU0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dV0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dV0.setter
    def dV0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dVP0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dVP0.setter
    def dVP0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dVT0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dVT0.setter
    def dVT0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def lgK(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @lgK.setter
    def lgK(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class ReactionThermoArgs():
    @property
    def P(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def T(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @property
    def dV0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    pass
class ReactionThermoModel():
    @typing.overload
    def __call__(self, arg0: ReactionThermoArgs) -> ReactionThermoProps: ...
    @typing.overload
    def __call__(self, arg0: ReactionThermoProps, arg1: ReactionThermoArgs) -> None: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.Callable[[ReactionThermoArgs], ReactionThermoProps]) -> None: ...
    def apply(self, arg0: ReactionThermoProps, arg1: ReactionThermoArgs) -> None: ...
    def params(self) -> typing.List[Param]: ...
    pass
class ReactionThermoModelParamsConstLgK():
    @property
    def Pr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Pr.setter
    def Pr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def lgKr(self) -> Param:
        """
        :type: Param
        """
    @lgKr.setter
    def lgKr(self, arg0: Param) -> None:
        pass
    pass
class ReactionThermoModelParamsGemsLgK():
    @property
    def A0(self) -> Param:
        """
        :type: Param
        """
    @A0.setter
    def A0(self, arg0: Param) -> None:
        pass
    @property
    def A1(self) -> Param:
        """
        :type: Param
        """
    @A1.setter
    def A1(self, arg0: Param) -> None:
        pass
    @property
    def A2(self) -> Param:
        """
        :type: Param
        """
    @A2.setter
    def A2(self, arg0: Param) -> None:
        pass
    @property
    def A3(self) -> Param:
        """
        :type: Param
        """
    @A3.setter
    def A3(self, arg0: Param) -> None:
        pass
    @property
    def A4(self) -> Param:
        """
        :type: Param
        """
    @A4.setter
    def A4(self, arg0: Param) -> None:
        pass
    @property
    def A5(self) -> Param:
        """
        :type: Param
        """
    @A5.setter
    def A5(self, arg0: Param) -> None:
        pass
    @property
    def A6(self) -> Param:
        """
        :type: Param
        """
    @A6.setter
    def A6(self, arg0: Param) -> None:
        pass
    @property
    def Pr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Pr.setter
    def Pr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class ReactionThermoModelParamsPhreeqcLgK():
    @property
    def A1(self) -> Param:
        """
        :type: Param
        """
    @A1.setter
    def A1(self, arg0: Param) -> None:
        pass
    @property
    def A2(self) -> Param:
        """
        :type: Param
        """
    @A2.setter
    def A2(self, arg0: Param) -> None:
        pass
    @property
    def A3(self) -> Param:
        """
        :type: Param
        """
    @A3.setter
    def A3(self, arg0: Param) -> None:
        pass
    @property
    def A4(self) -> Param:
        """
        :type: Param
        """
    @A4.setter
    def A4(self, arg0: Param) -> None:
        pass
    @property
    def A5(self) -> Param:
        """
        :type: Param
        """
    @A5.setter
    def A5(self, arg0: Param) -> None:
        pass
    @property
    def A6(self) -> Param:
        """
        :type: Param
        """
    @A6.setter
    def A6(self, arg0: Param) -> None:
        pass
    @property
    def Pr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Pr.setter
    def Pr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class ReactionThermoModelParamsVantHoff():
    @property
    def Pr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Pr.setter
    def Pr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Tr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tr.setter
    def Tr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dHr(self) -> Param:
        """
        :type: Param
        """
    @dHr.setter
    def dHr(self, arg0: Param) -> None:
        pass
    @property
    def lgKr(self) -> Param:
        """
        :type: Param
        """
    @lgKr.setter
    def lgKr(self, arg0: Param) -> None:
        pass
    pass
class ReactionThermoProps():
    def __init__(self) -> None: ...
    @property
    def dG0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dG0.setter
    def dG0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dH0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dH0.setter
    def dH0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class SolidPhase(GenericPhase):
    def __init__(self, arg0: StringList) -> None: ...
    pass
class Speciate():
    def __init__(self) -> None: ...
    @property
    def symbols(self) -> typing.List[str]:
        """
        :type: typing.List[str]
        """
    @symbols.setter
    def symbols(self, arg0: typing.List[str]) -> None:
        pass
    pass
class Species():
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    def aggregateState(self) -> AggregateState: ...
    @staticmethod
    def attachedData(*args, **kwargs) -> typing.Any: ...
    def charge(self) -> float: ...
    def clone(self) -> Species: ...
    def elements(self) -> ElementalComposition: ...
    def formula(self) -> ChemicalFormula: ...
    def molarMass(self) -> float: ...
    def name(self) -> str: ...
    @staticmethod
    def props(*args, **kwargs) -> typing.Any: ...
    def reaction(self) -> FormationReaction: ...
    def repr(self) -> str: ...
    @staticmethod
    def standardThermoModel(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def standardThermoProps(*args, **kwargs) -> typing.Any: ...
    def substance(self) -> str: ...
    def tags(self) -> typing.List[str]: ...
    def withAggregateState(self, arg0: AggregateState) -> Species: ...
    @staticmethod
    def withAttachedData(*args, **kwargs) -> typing.Any: ...
    def withCharge(self, arg0: float) -> Species: ...
    def withElements(self, arg0: ElementalComposition) -> Species: ...
    def withFormationReaction(self, arg0: FormationReaction) -> Species: ...
    def withFormula(self, arg0: str) -> Species: ...
    def withName(self, arg0: str) -> Species: ...
    def withStandardGibbsEnergy(self, arg0: Param) -> Species: ...
    @staticmethod
    def withStandardThermoModel(*args, **kwargs) -> typing.Any: ...
    def withSubstance(self, arg0: str) -> Species: ...
    def withTags(self, arg0: StringList) -> Species: ...
    pass
class SpeciesList():
    def __add__(self, arg0: SpeciesList) -> SpeciesList: ...
    def __getitem__(self, arg0: int) -> Species: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[Species]) -> None: ...
    def __iter__(self) -> typing.Iterator: ...
    def __len__(self) -> int: ...
    def append(self, arg0: Species) -> None: ...
    def data(self) -> typing.List[Species]: ...
    def elements(self) -> ElementList: ...
    def empty(self) -> bool: ...
    def find(self, arg0: str) -> int: ...
    def findWithFormula(self, arg0: ChemicalFormula) -> int: ...
    def findWithName(self, arg0: str) -> int: ...
    def findWithSubstance(self, arg0: str) -> int: ...
    def get(self, arg0: str) -> Species: ...
    def getWithFormula(self, arg0: ChemicalFormula) -> Species: ...
    def getWithName(self, arg0: str) -> Species: ...
    def getWithSubstance(self, arg0: str) -> Species: ...
    def index(self, arg0: str) -> int: ...
    def indexWithFormula(self, arg0: ChemicalFormula) -> int: ...
    def indexWithName(self, arg0: str) -> int: ...
    def indexWithSubstance(self, arg0: str) -> int: ...
    def size(self) -> int: ...
    def withAggregateState(self, arg0: AggregateState) -> SpeciesList: ...
    @staticmethod
    def withCharge(*args, **kwargs) -> typing.Any: ...
    def withElements(self, arg0: StringList) -> SpeciesList: ...
    def withElementsOf(self, arg0: StringList) -> SpeciesList: ...
    def withFormulas(self, arg0: StringList) -> SpeciesList: ...
    def withNames(self, arg0: StringList) -> SpeciesList: ...
    def withSubstances(self, arg0: StringList) -> SpeciesList: ...
    def withTag(self, arg0: str) -> SpeciesList: ...
    def withTags(self, arg0: StringList) -> SpeciesList: ...
    def withoutTag(self, arg0: str) -> SpeciesList: ...
    def withoutTags(self, arg0: StringList) -> SpeciesList: ...
    pass
class SpeciesThermoProps():
    @staticmethod
    def __init__(*args, **kwargs) -> typing.Any: ...
    def __repr__(self) -> str: ...
    @property
    def A0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @A0.setter
    def A0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Cp0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Cp0.setter
    def Cp0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Cv0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Cv0.setter
    def Cv0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def G0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @G0.setter
    def G0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def H0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @H0.setter
    def H0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def P(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @P.setter
    def P(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def S0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @S0.setter
    def S0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def T(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @T.setter
    def T(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def U0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @U0.setter
    def U0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def V0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @V0.setter
    def V0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VP0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VP0.setter
    def VP0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VT0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VT0.setter
    def VT0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class StandardThermoModel():
    @staticmethod
    def __call__(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @staticmethod
    def apply(*args, **kwargs) -> typing.Any: ...
    def params(self) -> typing.List[Param]: ...
    pass
class StandardThermoModelParamsConstant():
    @property
    def Cp0(self) -> Param:
        """
        :type: Param
        """
    @Cp0.setter
    def Cp0(self, arg0: Param) -> None:
        pass
    @property
    def G0(self) -> Param:
        """
        :type: Param
        """
    @G0.setter
    def G0(self, arg0: Param) -> None:
        pass
    @property
    def H0(self) -> Param:
        """
        :type: Param
        """
    @H0.setter
    def H0(self, arg0: Param) -> None:
        pass
    @property
    def V0(self) -> Param:
        """
        :type: Param
        """
    @V0.setter
    def V0(self, arg0: Param) -> None:
        pass
    @property
    def VP0(self) -> Param:
        """
        :type: Param
        """
    @VP0.setter
    def VP0(self, arg0: Param) -> None:
        pass
    @property
    def VT0(self) -> Param:
        """
        :type: Param
        """
    @VT0.setter
    def VT0(self, arg0: Param) -> None:
        pass
    pass
class StandardThermoModelParamsHKF():
    @property
    def Gf(self) -> Param:
        """
        :type: Param
        """
    @Gf.setter
    def Gf(self, arg0: Param) -> None:
        pass
    @property
    def Hf(self) -> Param:
        """
        :type: Param
        """
    @Hf.setter
    def Hf(self, arg0: Param) -> None:
        pass
    @property
    def Sr(self) -> Param:
        """
        :type: Param
        """
    @Sr.setter
    def Sr(self, arg0: Param) -> None:
        pass
    @property
    def Tmax(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tmax.setter
    def Tmax(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def a1(self) -> Param:
        """
        :type: Param
        """
    @a1.setter
    def a1(self, arg0: Param) -> None:
        pass
    @property
    def a2(self) -> Param:
        """
        :type: Param
        """
    @a2.setter
    def a2(self, arg0: Param) -> None:
        pass
    @property
    def a3(self) -> Param:
        """
        :type: Param
        """
    @a3.setter
    def a3(self, arg0: Param) -> None:
        pass
    @property
    def a4(self) -> Param:
        """
        :type: Param
        """
    @a4.setter
    def a4(self, arg0: Param) -> None:
        pass
    @property
    def c1(self) -> Param:
        """
        :type: Param
        """
    @c1.setter
    def c1(self, arg0: Param) -> None:
        pass
    @property
    def c2(self) -> Param:
        """
        :type: Param
        """
    @c2.setter
    def c2(self, arg0: Param) -> None:
        pass
    @property
    def charge(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @charge.setter
    def charge(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def wref(self) -> Param:
        """
        :type: Param
        """
    @wref.setter
    def wref(self, arg0: Param) -> None:
        pass
    pass
class StandardThermoModelParamsHollandPowell():
    @property
    def Gf(self) -> Param:
        """
        :type: Param
        """
    @Gf.setter
    def Gf(self, arg0: Param) -> None:
        pass
    @property
    def Hf(self) -> Param:
        """
        :type: Param
        """
    @Hf.setter
    def Hf(self, arg0: Param) -> None:
        pass
    @property
    def Sr(self) -> Param:
        """
        :type: Param
        """
    @Sr.setter
    def Sr(self, arg0: Param) -> None:
        pass
    @property
    def Tmax(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tmax.setter
    def Tmax(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Vr(self) -> Param:
        """
        :type: Param
        """
    @Vr.setter
    def Vr(self, arg0: Param) -> None:
        pass
    @property
    def a(self) -> Param:
        """
        :type: Param
        """
    @a.setter
    def a(self, arg0: Param) -> None:
        pass
    @property
    def alpha0(self) -> Param:
        """
        :type: Param
        """
    @alpha0.setter
    def alpha0(self, arg0: Param) -> None:
        pass
    @property
    def b(self) -> Param:
        """
        :type: Param
        """
    @b.setter
    def b(self, arg0: Param) -> None:
        pass
    @property
    def c(self) -> Param:
        """
        :type: Param
        """
    @c.setter
    def c(self, arg0: Param) -> None:
        pass
    @property
    def d(self) -> Param:
        """
        :type: Param
        """
    @d.setter
    def d(self, arg0: Param) -> None:
        pass
    @property
    def kappa0(self) -> Param:
        """
        :type: Param
        """
    @kappa0.setter
    def kappa0(self, arg0: Param) -> None:
        pass
    @property
    def kappa0p(self) -> Param:
        """
        :type: Param
        """
    @kappa0p.setter
    def kappa0p(self, arg0: Param) -> None:
        pass
    @property
    def kappa0pp(self) -> Param:
        """
        :type: Param
        """
    @kappa0pp.setter
    def kappa0pp(self, arg0: Param) -> None:
        pass
    @property
    def numatoms(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @numatoms.setter
    def numatoms(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class StandardThermoModelParamsInterpolation():
    @property
    def Cp0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @Cp0.setter
    def Cp0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def G0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @G0.setter
    def G0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def H0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @H0.setter
    def H0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def V0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @V0.setter
    def V0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def VP0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @VP0.setter
    def VP0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def VT0(self) -> typing.List[typing.List[float]]:
        """
        :type: typing.List[typing.List[float]]
        """
    @VT0.setter
    def VT0(self, arg0: typing.List[typing.List[float]]) -> None:
        pass
    @property
    def pressures(self) -> typing.List[float]:
        """
        :type: typing.List[float]
        """
    @pressures.setter
    def pressures(self, arg0: typing.List[float]) -> None:
        pass
    @property
    def temperatures(self) -> typing.List[float]:
        """
        :type: typing.List[float]
        """
    @temperatures.setter
    def temperatures(self, arg0: typing.List[float]) -> None:
        pass
    pass
class StandardThermoModelParamsMaierKelley():
    @property
    def Gf(self) -> Param:
        """
        :type: Param
        """
    @Gf.setter
    def Gf(self, arg0: Param) -> None:
        pass
    @property
    def Hf(self) -> Param:
        """
        :type: Param
        """
    @Hf.setter
    def Hf(self, arg0: Param) -> None:
        pass
    @property
    def Sr(self) -> Param:
        """
        :type: Param
        """
    @Sr.setter
    def Sr(self, arg0: Param) -> None:
        pass
    @property
    def Tmax(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tmax.setter
    def Tmax(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Vr(self) -> Param:
        """
        :type: Param
        """
    @Vr.setter
    def Vr(self, arg0: Param) -> None:
        pass
    @property
    def a(self) -> Param:
        """
        :type: Param
        """
    @a.setter
    def a(self, arg0: Param) -> None:
        pass
    @property
    def b(self) -> Param:
        """
        :type: Param
        """
    @b.setter
    def b(self, arg0: Param) -> None:
        pass
    @property
    def c(self) -> Param:
        """
        :type: Param
        """
    @c.setter
    def c(self, arg0: Param) -> None:
        pass
    pass
class StandardThermoModelParamsMineralHKF():
    @property
    def Gf(self) -> Param:
        """
        :type: Param
        """
    @Gf.setter
    def Gf(self, arg0: Param) -> None:
        pass
    @property
    def Hf(self) -> Param:
        """
        :type: Param
        """
    @Hf.setter
    def Hf(self, arg0: Param) -> None:
        pass
    @property
    def Htr(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @Htr.setter
    def Htr(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def Sr(self) -> Param:
        """
        :type: Param
        """
    @Sr.setter
    def Sr(self, arg0: Param) -> None:
        pass
    @property
    def Tmax(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tmax.setter
    def Tmax(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Ttr(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @Ttr.setter
    def Ttr(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def Vr(self) -> Param:
        """
        :type: Param
        """
    @Vr.setter
    def Vr(self, arg0: Param) -> None:
        pass
    @property
    def Vtr(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @Vtr.setter
    def Vtr(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def a(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @a.setter
    def a(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def b(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @b.setter
    def b(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def c(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @c.setter
    def c(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def dPdTtr(self) -> typing.List[Param]:
        """
        :type: typing.List[Param]
        """
    @dPdTtr.setter
    def dPdTtr(self, arg0: typing.List[Param]) -> None:
        pass
    @property
    def ntr(self) -> int:
        """
        :type: int
        """
    @ntr.setter
    def ntr(self, arg0: int) -> None:
        pass
    pass
class StandardThermoModelParamsNasa():
    @property
    def H0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @H0.setter
    def H0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def T0(self) -> float:
        """
        :type: float
        """
    @T0.setter
    def T0(self, arg0: float) -> None:
        pass
    @property
    def dH0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dH0.setter
    def dH0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def dHf(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @dHf.setter
    def dHf(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def polynomials(self) -> typing.List[StandardThermoModelParamsNasaPolynomial]:
        """
        :type: typing.List[StandardThermoModelParamsNasaPolynomial]
        """
    @polynomials.setter
    def polynomials(self, arg0: typing.List[StandardThermoModelParamsNasaPolynomial]) -> None:
        pass
    pass
class StandardThermoModelParamsNasaPolynomial():
    @property
    def Tmax(self) -> float:
        """
        :type: float
        """
    @Tmax.setter
    def Tmax(self, arg0: float) -> None:
        pass
    @property
    def Tmin(self) -> float:
        """
        :type: float
        """
    @Tmin.setter
    def Tmin(self, arg0: float) -> None:
        pass
    @property
    def a1(self) -> Param:
        """
        :type: Param
        """
    @a1.setter
    def a1(self, arg0: Param) -> None:
        pass
    @property
    def a2(self) -> Param:
        """
        :type: Param
        """
    @a2.setter
    def a2(self, arg0: Param) -> None:
        pass
    @property
    def a3(self) -> Param:
        """
        :type: Param
        """
    @a3.setter
    def a3(self, arg0: Param) -> None:
        pass
    @property
    def a4(self) -> Param:
        """
        :type: Param
        """
    @a4.setter
    def a4(self, arg0: Param) -> None:
        pass
    @property
    def a5(self) -> Param:
        """
        :type: Param
        """
    @a5.setter
    def a5(self, arg0: Param) -> None:
        pass
    @property
    def a6(self) -> Param:
        """
        :type: Param
        """
    @a6.setter
    def a6(self, arg0: Param) -> None:
        pass
    @property
    def a7(self) -> Param:
        """
        :type: Param
        """
    @a7.setter
    def a7(self, arg0: Param) -> None:
        pass
    @property
    def b1(self) -> Param:
        """
        :type: Param
        """
    @b1.setter
    def b1(self, arg0: Param) -> None:
        pass
    @property
    def b2(self) -> Param:
        """
        :type: Param
        """
    @b2.setter
    def b2(self, arg0: Param) -> None:
        pass
    @property
    def label(self) -> str:
        """
        :type: str
        """
    @label.setter
    def label(self, arg0: str) -> None:
        pass
    @property
    def state(self) -> AggregateState:
        """
        :type: AggregateState
        """
    @state.setter
    def state(self, arg0: AggregateState) -> None:
        pass
    pass
class StandardThermoModelParamsWaterHKF():
    @property
    def Gtr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Gtr.setter
    def Gtr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Htr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Htr.setter
    def Htr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Str(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Str.setter
    def Str(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Ttr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Ttr.setter
    def Ttr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class StandardThermoProps():
    def __init__(self) -> None: ...
    @property
    def Cp0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Cp0.setter
    def Cp0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def G0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @G0.setter
    def G0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def H0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @H0.setter
    def H0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def V0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @V0.setter
    def V0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VP0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VP0.setter
    def VP0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def VT0(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @VT0.setter
    def VT0(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class StateOfMatter():
    """
    Members:

      Unspecified : When the state of matter of a phase is unspecified

      Solid : When the state of matter of a phase is solid

      Liquid : When the state of matter of a phase is liquid

      Gas : When the state of matter of a phase is gas

      Supercritical : When the state of matter of a phase is supercritical

      Plasma : When the state of matter of a phase is plama

      Fluid : When the state of matter of a phase is either liquid, gas, or plasma

      Condensed : When the state of matter of a phase is either liquid or solid
    """
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __init__(self, value: int) -> None: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __repr__(self) -> str: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str:
        """
        :type: str
        """
    @property
    def value(self) -> int:
        """
        :type: int
        """
    Condensed: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Condensed: 7>
    Fluid: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Fluid: 6>
    Gas: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Gas: 3>
    Liquid: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Liquid: 2>
    Plasma: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Plasma: 5>
    Solid: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Solid: 1>
    Supercritical: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Supercritical: 4>
    Unspecified: reaktoro.reaktoro4py.StateOfMatter # value = <StateOfMatter.Unspecified: 0>
    __members__: dict # value = {'Unspecified': <StateOfMatter.Unspecified: 0>, 'Solid': <StateOfMatter.Solid: 1>, 'Liquid': <StateOfMatter.Liquid: 2>, 'Gas': <StateOfMatter.Gas: 3>, 'Supercritical': <StateOfMatter.Supercritical: 4>, 'Plasma': <StateOfMatter.Plasma: 5>, 'Fluid': <StateOfMatter.Fluid: 6>, 'Condensed': <StateOfMatter.Condensed: 7>}
    pass
class StringList():
    def __getitem__(self, arg0: int) -> str: ...
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @typing.overload
    def __init__(self, arg0: str, arg1: str) -> None: ...
    @typing.overload
    def __init__(self, arg0: typing.List[str]) -> None: ...
    def __setitem__(self, arg0: int, arg1: str) -> None: ...
    def data(self) -> typing.List[str]: ...
    def empty(self) -> bool: ...
    def size(self) -> int: ...
    pass
class SubstanceCriticalProps():
    @typing.overload
    def __init__(self, arg0: StringList) -> None: ...
    @typing.overload
    def __init__(self, arg0: SubstanceCriticalPropsData, arg1: StringList) -> None: ...
    @staticmethod
    def acentricFactor(*args, **kwargs) -> typing.Any: ...
    def data(self) -> SubstanceCriticalPropsData: ...
    def names(self) -> typing.List[str]: ...
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setAcentricFactor(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setPressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def setTemperature(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: ...
    pass
class SubstanceCriticalPropsData():
    def __init__(self) -> None: ...
    @property
    def Pcr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Pcr.setter
    def Pcr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def Tcr(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @Tcr.setter
    def Tcr(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def omega(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @omega.setter
    def omega(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class SupcrtDatabase(Database):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: Database) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @staticmethod
    def fromContents(arg0: str) -> SupcrtDatabase: ...
    @staticmethod
    def fromFile(arg0: str) -> SupcrtDatabase: ...
    @staticmethod
    def withName(arg0: str) -> SupcrtDatabase: ...
    pass
class ThermoFunDatabase(Database):
    @staticmethod
    @typing.overload
    def __init__(*args, **kwargs) -> typing.Any: ...
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg0: str) -> None: ...
    @staticmethod
    def fromContents(arg0: str) -> ThermoFunDatabase: ...
    @staticmethod
    def fromFile(arg0: str) -> ThermoFunDatabase: ...
    @staticmethod
    def withName(arg0: str) -> ThermoFunDatabase: ...
    pass
class ThermoProps():
    def __init__(self, arg0: ChemicalSystem) -> None: ...
    @staticmethod
    def phaseProps(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: ...
    def system(self) -> ChemicalSystem: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def update(*args, **kwargs) -> typing.Any: ...
    pass
class ThermoPropsPhase():
    def __init__(self, arg0: Phase) -> None: ...
    @staticmethod
    def data(*args, **kwargs) -> typing.Any: ...
    def phase(self) -> Phase: ...
    @staticmethod
    def pressure(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardEnthalpies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardEntropies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardGibbsEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHeatCapacitiesConstP(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHeatCapacitiesConstV(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardHelmholtzEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardInternalEnergies(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumes(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumesP(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def speciesStandardVolumesT(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def temperature(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    def update(*args, **kwargs) -> typing.Any: ...
    pass
class WaterElectroProps():
    def __init__(self) -> None: ...
    @property
    def bornN(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornN.setter
    def bornN(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bornQ(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornQ.setter
    def bornQ(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bornU(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornU.setter
    def bornU(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bornX(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornX.setter
    def bornX(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bornY(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornY.setter
    def bornY(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def bornZ(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @bornZ.setter
    def bornZ(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilon(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilon.setter
    def epsilon(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilonP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilonP.setter
    def epsilonP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilonPP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilonPP.setter
    def epsilonPP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilonT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilonT.setter
    def epsilonT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilonTP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilonTP.setter
    def epsilonTP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def epsilonTT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @epsilonTT.setter
    def epsilonTT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class WaterHelmholtzProps():
    def __init__(self) -> None: ...
    @property
    def helmholtz(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtz.setter
    def helmholtz(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzD.setter
    def helmholtzD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzDD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzDD.setter
    def helmholtzDD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzDDD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzDDD.setter
    def helmholtzDDD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzT.setter
    def helmholtzT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzTD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzTD.setter
    def helmholtzTD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzTDD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzTDD.setter
    def helmholtzTDD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzTT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzTT.setter
    def helmholtzTT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzTTD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzTTD.setter
    def helmholtzTTD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtzTTT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtzTTT.setter
    def helmholtzTTT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class WaterThermoProps():
    def __init__(self) -> None: ...
    @property
    def cp(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @cp.setter
    def cp(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def cv(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @cv.setter
    def cv(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def density(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @density.setter
    def density(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def densityP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @densityP.setter
    def densityP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def densityPP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @densityPP.setter
    def densityPP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def densityT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @densityT.setter
    def densityT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def densityTP(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @densityTP.setter
    def densityTP(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def densityTT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @densityTT.setter
    def densityTT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def enthalpy(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @enthalpy.setter
    def enthalpy(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def entropy(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @entropy.setter
    def entropy(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def gibbs(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @gibbs.setter
    def gibbs(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def helmholtz(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @helmholtz.setter
    def helmholtz(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def internal_energy(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @internal_energy.setter
    def internal_energy(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressure(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressure.setter
    def pressure(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressureD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressureD.setter
    def pressureD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressureDD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressureDD.setter
    def pressureDD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressureT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressureT.setter
    def pressureT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressureTD(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressureTD.setter
    def pressureTD(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def pressureTT(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @pressureTT.setter
    def pressureTT(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def temperature(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @temperature.setter
    def temperature(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    @property
    def volume(self) -> autodiff::detail::Real<1,double>:
        """
        :type: autodiff::detail::Real<1,double>
        """
    @volume.setter
    def volume(self, arg0: autodiff::detail::Real<1,double>) -> None:
        pass
    pass
class _ChemicalStateEquilibrium():
    def b(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def controlVariablesP(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def controlVariablesQ(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def elementChemicalPotentials(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def explicitTitrantAmounts(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def implicitTitrantAmounts(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def indicesPrimarySpecies(self) -> numpy.ndarray[numpy.int64, _Shape[m, 1]]: ...
    def indicesSecondarySpecies(self) -> numpy.ndarray[numpy.int64, _Shape[m, 1]]: ...
    def indicesStrictlyUnstableElements(self) -> numpy.ndarray[numpy.int64, _Shape[m, 1]]: ...
    def indicesStrictlyUnstableSpecies(self) -> numpy.ndarray[numpy.int64, _Shape[m, 1]]: ...
    def initialComponentAmounts(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def inputNames(self) -> typing.List[str]: ...
    def inputValues(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def numPrimarySpecies(self) -> int: ...
    def numSecondarySpecies(self) -> int: ...
    @staticmethod
    def optimaState(*args, **kwargs) -> typing.Any: ...
    def p(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def q(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def setControlVariablesP(self, arg0: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> None: ...
    def setControlVariablesQ(self, arg0: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> None: ...
    def setIndicesPrimarySecondarySpecies(self, arg0: numpy.ndarray[numpy.int64, _Shape[m, 1]], arg1: int) -> None: ...
    def setIndicesStrictlyUnstableElements(self, arg0: numpy.ndarray[numpy.int64, _Shape[m, 1]]) -> None: ...
    def setIndicesStrictlyUnstableSpecies(self, arg0: numpy.ndarray[numpy.int64, _Shape[m, 1]]) -> None: ...
    def setInitialComponentAmounts(self, arg0: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> None: ...
    def setInputNames(self, arg0: typing.List[str]) -> None: ...
    def setInputValues(self, arg0: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> None: ...
    @staticmethod
    def setOptimaState(*args, **kwargs) -> typing.Any: ...
    def speciesStabilities(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    def w(self) -> numpy.ndarray[numpy.float64, _Shape[m, 1]]: ...
    pass
class yaml():
    def __getitem__(self, arg0: str) -> yaml: ...
    def __init__(self) -> None: ...
    def __repr__(self) -> str: ...
    @staticmethod
    @typing.overload
    def parse(*args, **kwargs) -> typing.Any: ...
    @staticmethod
    @typing.overload
    def parse(arg0: str) -> yaml: ...
    pass
@typing.overload
def ActivityModelDebyeHuckel() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
@typing.overload
def ActivityModelDebyeHuckel(arg0: ActivityModelDebyeHuckelParams) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelDebyeHuckelKielland() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelDebyeHuckelLimitingLaw() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelDebyeHuckelPHREEQC() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelDebyeHuckelWATEQ4F() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
@typing.overload
def ActivityModelDrummond(arg0: str) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
@typing.overload
def ActivityModelDrummond(arg0: str, arg1: ActivityModelDrummondParams) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelDuanSun(arg0: str) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelHKF() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIdealAqueous() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIdealGas() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIdealIonExchange() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIdealSolution(arg0: StateOfMatter) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIonExchange() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelIonExchangeGainesThomas() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelPengRobinson(params: ActivityModelCubicEOSParams = ...) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelPitzerHMW() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelRedlichKister(*args, **kwargs) -> typing.Any:
    pass
def ActivityModelRedlichKwong(params: ActivityModelCubicEOSParams = ...) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelRumpf(arg0: str) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelSetschenow(*args, **kwargs) -> typing.Any:
    pass
def ActivityModelSoaveRedlichKwong(params: ActivityModelCubicEOSParams = ...) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelSpycherPruessEnnis() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelSpycherReed() -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ActivityModelVanDerWaals(params: ActivityModelCubicEOSParams = ...) -> typing.Callable[[SpeciesList], ActivityModel]:
    pass
def ReactionThermoModelConstLgK(arg0: ReactionThermoModelParamsConstLgK) -> ReactionThermoModel:
    pass
def ReactionThermoModelGemsLgK(arg0: ReactionThermoModelParamsGemsLgK) -> ReactionThermoModel:
    pass
def ReactionThermoModelPhreeqcLgK(arg0: ReactionThermoModelParamsPhreeqcLgK) -> ReactionThermoModel:
    pass
def ReactionThermoModelPressureCorrection(arg0: Param) -> ReactionThermoModel:
    pass
def ReactionThermoModelVantHoff(arg0: ReactionThermoModelParamsVantHoff) -> ReactionThermoModel:
    pass
def ReactionThermoModelYAML(arg0: yaml) -> ReactionThermoModel:
    pass
def StandardThermoModelConstant(arg0: StandardThermoModelParamsConstant) -> StandardThermoModel:
    pass
def StandardThermoModelHKF(arg0: StandardThermoModelParamsHKF) -> StandardThermoModel:
    pass
def StandardThermoModelHollandPowell(arg0: StandardThermoModelParamsHollandPowell) -> StandardThermoModel:
    pass
def StandardThermoModelInterpolation(arg0: StandardThermoModelParamsInterpolation) -> StandardThermoModel:
    pass
def StandardThermoModelMaierKelley(arg0: StandardThermoModelParamsMaierKelley) -> StandardThermoModel:
    pass
def StandardThermoModelMineralHKF(arg0: StandardThermoModelParamsMineralHKF) -> StandardThermoModel:
    pass
def StandardThermoModelNasa(arg0: StandardThermoModelParamsNasa) -> StandardThermoModel:
    pass
def StandardThermoModelWaterHKF(arg0: StandardThermoModelParamsWaterHKF) -> StandardThermoModel:
    pass
def StandardThermoModelYAML(arg0: yaml) -> StandardThermoModel:
    pass
def chain(*args, **kwargs) -> typing.Any:
    pass
@typing.overload
def equilibrate(arg0: ChemicalState) -> EquilibriumResult:
    pass
@typing.overload
def equilibrate(arg0: ChemicalState, arg1: EquilibriumOptions) -> EquilibriumResult:
    pass
@typing.overload
def equilibrate(arg0: ChemicalState, arg1: EquilibriumRestrictions) -> EquilibriumResult:
    pass
@typing.overload
def equilibrate(arg0: ChemicalState, arg1: EquilibriumRestrictions, arg2: EquilibriumOptions) -> EquilibriumResult:
    pass
@typing.overload
def equilibrate(arg0: ChemicalState, arg1: EquilibriumRestrictions, arg2: EquilibriumOptions, arg3: numpy.ndarray[numpy.float64, _Shape[m, 1]]) -> EquilibriumResult:
    pass
def exclude(arg0: StringList) -> Exclude:
    pass
@typing.overload
def extractNames(arg0: ElementList) -> typing.List[str]:
    pass
@typing.overload
def extractNames(arg0: PhaseList) -> typing.List[str]:
    pass
@typing.overload
def extractNames(arg0: SpeciesList) -> typing.List[str]:
    pass
def identifyAggregateState(arg0: str) -> AggregateState:
    pass
def interpolate(*args, **kwargs) -> typing.Any:
    pass
def parseAggregateState(arg0: str) -> AggregateState:
    pass
def parseChemicalFormula(arg0: str) -> typing.List[typing.Tuple[str, float]]:
    pass
def parseElectricCharge(arg0: str) -> float:
    pass
def parseNumberStringPairs(arg0: str) -> typing.List[typing.Tuple[str, float]]:
    pass
def parseReaction(arg0: str) -> typing.List[typing.Tuple[str, float]]:
    pass
def parseReactionEquation(arg0: str) -> typing.List[typing.Tuple[str, float]]:
    pass
@typing.overload
def precision() -> int:
    pass
@typing.overload
def precision(arg0: int) -> None:
    pass
def speciate(arg0: StringList) -> Speciate:
    pass
def waterDensityHGK(*args, **kwargs) -> typing.Any:
    pass
def waterDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterElectroPropsJohnsonNorton(*args, **kwargs) -> typing.Any:
    pass
def waterHelmholtzPropsHGK(*args, **kwargs) -> typing.Any:
    pass
def waterHelmholtzPropsWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterLiquidDensityHGK(*args, **kwargs) -> typing.Any:
    pass
def waterLiquidDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterPressureHGK(*args, **kwargs) -> typing.Any:
    pass
def waterPressureWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturatedLiquidDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturatedPressureWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturatedVapourDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturationLiquidDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturationPressureWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterSaturationVapourDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterThermoProps(*args, **kwargs) -> typing.Any:
    pass
def waterThermoPropsHGK(*args, **kwargs) -> typing.Any:
    pass
def waterThermoPropsHGKMemoized(*args, **kwargs) -> typing.Any:
    pass
def waterThermoPropsWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
def waterThermoPropsWagnerPrussMemoized(*args, **kwargs) -> typing.Any:
    pass
def waterVaporDensityHGK(*args, **kwargs) -> typing.Any:
    pass
def waterVaporDensityWagnerPruss(*args, **kwargs) -> typing.Any:
    pass
barToPascal = 100000.0
calorieToJoule = 4.184
cubicCentimeterToCubicMeter = 1e-06
cubicMeterToCubicCentimeter = 1000000.0
faradayConstant = 96485.3329
jouleToCalorie = 0.239005736
ln10 = 2.302585092994046
universalGasConstant = 8.3144621
waterCriticalDensity = 322.0
waterCriticalPressure = 22064000.0
waterCriticalTemperature = 647.096
waterMolarMass = 0.018015268
waterTriplePointDensityLiquid = 999.793
waterTriplePointDensityVapour = 0.00485458
waterTriplePointPressure = 611.655
waterTriplePointTemperature = 273.16
