/*
 *
 * The polynomials were generated using mo19937-generate-jump-poly.c
 * except poly_default, which is used in testing and was provided by
 * the authors of the original code.
 *
 */

static const char *poly_default =
    "10101001000001010011101111111100110111001110110001001101110110011000101000"
    "00110011110111000101111010111001110000011101011100101001101111000010011000"
    "00100001011111001100000110001111011110110110110101011110011010000111100111"
    "11110000011111010100001011001101110000100011101110001101011111110001000101"
    "01000100100011111010010001101011111000100111011100001001110011100101010100"
    "01001110110010001111010111100010000101101001001010011110011101111011110011"
    "00000101100010101011001111111001101000000000101010011000000101110010000111"
    "10000100000011001000111111110110011010001100011000001110011010110010011001"
    "01100111011101110110011010110110001100000100001100111100111010111000110011"
    "00001111101001001100000010100111101001011101111000111100011001111001100110"
    "01011000111101111101100011101110001101111111111000100101101111111110011111"
    "00111010100010010101000101110001101101011011110100010100101111111101011111"
    "01110100100100101110011010110011011011111011110010010110111000101001111100"
    "11111100001001001101010010111110011001001111110010111100101001111001111111"
    "01110101000111010111010010101101101001111101101001000001010010110111111011"
    "11001010010011000011010101111100101000001111011011101101000100000001011011"
    "10110110011001001100011110011000100101111000110000011000011000100111111010"
    "10010101111011101000111110111001100100111001010110101001011001001110110010"
    "10111001111011101010000010100101101100100111111110010001011100011000010100"
    "00101111110101000000000000110000101100000110110100110001100111100100111010"
    "11000100010000000001001110101001010010111011001010111101110100110000000011"
    "10110100101010011111010101100110101100101111010010110010110001111101110101"
    "01011011000101000011110100001010111101100011011100100111000100100011001100"
    "10001101010000110011111111101010100011101110110110001011011011110001001000"
    "01110101010111101101110111001101101110010001001001110101000001010101110111"
    "01111011101011010100101000110001010100011100100110111110000011011010000100"
    "11000000011011101100111100011100001001001000001101111101110001001101110001"
    "00000100000010000001000010000011011110010101010100000111100100111010001011"
    "10101110011111110001010100000010110011101111010100111010001000000110110100"
    "01111110011000111111000100010111011010001010110010000011111001101010110011"
    "00010111010000101010110000010101110000101111011001111001000011111101111010"
    "00011011100010100101100000101000011110111011011100000101100001010110000011"
    "10011010001000111000000000101110001010010101000100100011100011001001111101"
    "10110111010001101001000011001010110010100000101000101011100100100111011010"
    "11011111111100011101110110011101100011010110100100000100011111001101000111"
    "11011101100000111000011000011111111110101011110010011101011000110001010000"
    "00000100100001100001110011000110001100001111111011000001101010011101010111"
    "11100001111010100111110101101111101111111010101110100111001111011001011010"
    "01101111111010001010100111010110010100011011000100011100101111111101101110"
    "00000010000110001010010000100100001101010001110011101100101001100110101110"
    "00010101011011110000110100111001011110100010010010110011010110100000001100"
    "10011011001011011110000010101110110001100001101100001101011011011010001010"
    "11000110110110101001010000111101010000010001101101011100100001011001101011"
    "00100000110110011101011101100101010011011011011011100101100010101000111010"
    "00111101001011011110100100101101011001110010001111011101111011111011111101"
    "00000001011101100001001010101100010100001110110111001010000000001100000101"
    "01001011000101000111010100111100101110010010110010010011001000000100000000"
    "11101000001111101100000010111010000111111101001011100100001111111011000110"
    "11101010110101100101110101100011110100100011110011110111000101001111100010"
    "10111001111001111001011111000001110010110000010101101010100000101010110101"
    "11100101011110000100011111000001000011101111110101111100111000001000100001"
    "11100101111110001100100001111010001000110000110100110010111010010000000111"
    "10011101111001101001100101011101101000011101100101101011101011101010011001"
    "01001110001110011110111100010100011000110001110010101001010101000000000111"
    "01101101100001110100101000110100100101101111011011001110010100100100001101"
    "01110000001011100101011100010110111001001010000110100010110011010011110111"
    "01100111110100011100111110000111011010101000001100100100000010101110001001"
    "01110000000001111100000100110111111001111011011011001100111000001000011011"
    "01010110111111111010110011110001110010110010001010001001100000111000100100"
    "11011100111111000110000010000001101111101100110001011011111011111100011010"
    "11000111101101110111000100100101111011001110100010110000010100100011101101"
    "00110011111111110101000111010001001100010010001011100011011010000011011000"
    "01100110101101000011100010100010101110100001101000100011110101110101100111"
    "11111111111111111001010011010011010010101110110110100010010001111111110000"
    "01100001110110001100010010011101001110111110000011011000010100101110001110"
    "10011000011011110110001110011100011010101010110011101101100110110110011001"
    "11110011011100101001100100010001101101000001010111100000101001001101111001"
    "01001111100111001100101000100110011111101010101111001011100111111011011111"
    "01011001111011110001011111101011000001000001001100100001000001111001110001"
    "01000110001101011100000111011001000101001111001111111001010000101001100100"
    "11110111100001110011001110000000011100011010000110011101101010001101011111"
    "10010010100011101111001111101101101001011100111010010100010111001000011001"
    "11010011001000101010110011000011010101100001011000110001010011101101010001"
    "00101010000011011101100001011110111111110111100101001000011111100111010110"
    "01111111010101100111000011101111110001101000011001100111011100110101100111"
    "11010110000010111111010101100101000010011011011000111101101101111011110001"
    "10100100111011000100111101110111100001100010101100000110101100101001011011"
    "11110001000100100000110110000110010011011101111001000010000010010110100011"
    "11101110100110000101101000101111110010110010110000101110010011010111011011"
    "11010001011000010100101111100010011000011100111110010100010000001111000001"
    "00100010010110011010100011000010110011000011100111101111100100010110010101"
    "01111001001110110100100101110011001001100111111001111001110001001001101011"
    "10110101100000110000101100111111010000100000110000000101100100110000000111"
    "11111100001101000001000010100000111111100101111011101110001001111100101000"
    "11111101001000101011001010011110110000101101010001110111111010010011000100"
    "10000110111000010010010010100110010111011100110010110000000010100011010010"
    "01100100100101010001010010100000110100110111110111111110111111000111101111"
    "10010101111011101000100101011001010001110011100000011110000010100010101001"
    "11100000110010001001100000110001000110110000010101000111011110001010101011"
    "00011001101010111010101000111100111000111010011010011001010011100101001000"
    "01111111000011111111100111001100001010001011111101111001100000100110000010"
    "01110001111100000000000000110101101110101100110011010011011111101111111010"
    "10011001010111101100111011100011000101001111101011101100110111101011000001"
    "00111111000001101100011110111001011111100101111010110100100001001000000100"
    "00111110001000000101110100100000001011000101111101010111100011111101011000"
    "11110000010000100111101110011001100101011001111001101111110010011010010101"
    "11001100111001101101100100111100011111000110001110010111101001110100001101"
    "10010000001000100111001000000100110110001111100010010010001011110000010011"
    "00000010011001010101010101000000101011101001101110011100100010111101101000"
    "11000001110100010100100111111101011101000000110000101000010001110110110111"
    "11110110011100010001110011001011100010001011110001010111110101010100011001"
    "11100000100010011110101100000001111010111001011010010010010001011100011101"
    "11101110001100010010001000010111001110011000000011111110010100011000011000"
    "10110101111001100011110110000110010001001110011010011100010010100011100110"
    "00010011010010001001100111101100000110000111111001101100111001001100011000"
    "10011100001110101101100010101100001100100101110011001010010100111100010101"
    "11001101100001010010000110001000101001101001111001100101001000100101001101"
    "00010100100000111101010100011110111110010001100111100110110100011101001101"
    "11010110011111011101100010000110110000101011010100010000011010101010001111"
    "00101110011000010101010110010100110111011111100100011100111000010101001011"
    "10110111010111111111001010100000101011011100000101111100001101110000101011"
    "11111111010111110100010100010100000111101101000001101001101001010001001001"
    "00110100011100100001000110101111100101011100100111000111111111110100110100"
    "01101001000001100101100001001000101110000001101110111010001100100100000100"
    "10000010011010000000100001000101011101110011111100101110000101010101001100"
    "11110110110001000000010100111101111000111111001011101001100100001000111111"
    "10000111001000011100000111110001101001010100111010110011011000000101100010"
    "01000001010000000100000100111100000110111011110010110100011000010111100001"
    "11001010100101011000000100110101110001111111111111110000110101001101111111"
    "01110111101000011101110001001001111001101101011011101010101011010000010100"
    "01010011110000000100001101010111111000101101101011100011100100001011110000"
    "00101001100110011011110101110100100111111011111101101111011001010110000101"
    "00000011111111010000000101100011101100011110100011100011000100010100001111"
    "01011100001011011100011001110000001010001111110101000000111011100000110000"
    "01001100000100010100000011001101011110011101110111000111010001011001111100"
    "11111011011001000111001110100111011011101001100011111101100110100110101100"
    "01111101101010110100011111101100101011001010000000110110111011010011110110"
    "10011101010101001011010101101010111000001100001011100111010101001111000111"
    "10110101000100110010001111110110000001111001000010110100011101111001010011"
    "01111011010001000001101000010111101011011110100001101001100001110001100110"
    "10110111001011000110001001001011010101010100111111101100101000111110000100"
    "01110100000000111100010101010110100001001110101100011000101101101000001110"
    "01100001000000011011100000010010110100000001000010010010111101001110011100"
    "11101001011000010000000000101011001011010101000010000000000001001011011010"
    "00100011100010111010001000111111010100100011100101101011011111001101110011"
    "00001110000001001110101000000111101101000101010000111010010111001100100011"
    "01011100101010010110100000001100010111110111000110101011101010111001011000"
    "10001001110111010011010000011010111101110000000000001010110011111110001000"
    "00011101010111010001111011101110001110110000101010010010101010111100000111"
    "11001111001111010001011001000001000010000100001001001010111000001001101111"
    "10001000100001110001100001001000010101011100000100000101110100001001001011"
    "00111110110101001000011001100011111001110111010010000010100101001100101111"
    "01001011001001111111111011010000000111001100110011111100101101010011011010"
    "10011011100111100100011001100000000111110110110110000010110110001010101100"
    "01111010100011010011101010011000110010010101111111011111010011100000000010"
    "01110010111111111111111111110101101100101010010100011100010111101101010000"
    "01100101000010110100011011110111111111101101001000000010000110100010101000"
    "10101110010011000010111000001101011100100001010010010110110001111111010010"
    "01010111000110010000100101011011010100001010100110101010110111011011101100"
    "11111111010100011111100001001000100010011001100000110010011011111001011100"
    "00011000011000111110110110111001001100010010010110010101000000101010001111"
    "01010111110001110101011010101101011000101001001100110010001011000011011000"
    "01110001101011010110111100111001010000010110110000011001110010010111100111"
    "01010101111100001100010110000110010000110111100100000101110010000001001000"
    "10000101000011111000001111010001001101010110110000110110001100010110001000"
    "00110011010000100000110110000010110101000100011010101001101110010110001000"
    "01100100110101111110010000110000101111110110110100110101011000010111010011"
    "10110110000011001011010110110010110011100100100101111101011010010010100010"
    "00000000011001011011100011110000100001000011001110001010011111011100110111"
    "11111101110010001011111011010011100010101010000001100010010111101110011111"
    "10010101001000001100110010010001010000110010111100111011010000000010111000"
    "11110101101000001100110101101010110001101111100110001100101110001110000100"
    "00101110000101100111000011001110111111100011000000110011100010000011001001"
    "00111111100111101011000101000101001001100101110110100111111110011000010110"
    "00100011010110001001111101100110111110101001011011000110110111110000000011"
    "01110111101011100011101010101101111101111011101010111110010000001101101011"
    "01001001110100110101101000101001100010010011110001110011101111001101101100"
    "10010000010111100001001000100111011011101111101110010111011011010000010011"
    "00000001011100111001010100110001101111001111011000101100100110111010001100"
    "10100110010101001110000010110001110000011111110111001011100110010111101010"
    "10010110001001110111111001110100000000000101101111111110011010100101100111"
    "11011110111100010100000010110011100110010011011100010001000111100101100111"
    "11111001001000000001000101001100111001101100111000000000100001111001010111"
    "00111001011101000110101010010110110011000000001001010000101001001000001011"
    "00101101010110001100110101100111101001101001010011011000111010110100100111"
    "00101011110111101111001111111111011111011110000100000000111011000010001111"
    "11111100011011000000101110111001011010010010101100000111011011001010100111"
    "01101010101101000111001100011010101101100010111110011011001100110000011000"
    "01001110110011111011000111001011110011011111100101000101001001001011111011"
    "11001011001000110011010111010101001100001101011010011111111101010011101101"
    "11001110011001000010100010100001010101111000101100111000111011110111010000"
    "00000010011101101100011101101110111001010001001100110000000111100011110001"
    "11000010111000011001110001111101011111010001010010011001011000101100101010"
    "10000000100000110101111001011100011111100110100011110100011010001100011011"
    "11010111101010011000100100011101011101001000100101011010101100111001001000"
    "00101011100101010111101010011101110101011010111101100011110011011100000001"
    "00100000011100110000110011101101111011100110001010000110000100111000000010"
    "11011010001011011101111000000001100000100100001101110110110110010010000000"
    "00101111110000110000011101101000010101001110011111011100100011011110101110"
    "00011010010001110001000101000010001010001011000001000000001011001001110001"
    "01000010001101110000110000011010000010001011000011101010100011011001101111"
    "11111001011101110110100111010000011000010101101111000010001010110110011101"
    "00100011011010101010100000000000011111010111000010110100011101100010010110"
    "11100110000011101001111000011101111011100001011000001101001110000100000001"
    "10100100101100110011101010000011101110111010000100000010110100001000011001"
    "10011111100011111111111001010110101100110100101011110010100110011110011100"
    "10001010110111101111000101010011101111000000111110110100100010010111011001"
    "11111000000010011110101000001100011001001010110110001010100010000010010001"
    "00111001111011010011001001110011010110010010001101110011100010000001000011"
    "10001110110110111100010111011000000011111011110111101001000111111010101000"
    "01001110111111011100110101110101011011110000100110010010010010111111011000"
    "01010111110111110010111110110101111010010100100000110000100111100000011010"
    "00011101000010000001101100100001101000100001110011101011001100000110011100"
    "01000000100010010011000101000011001000001001010111110110001110010110111100"
    "00111000110110011110010000100001011101001110110110111100101100010100001110"
    "11001001010001100101010010001111011001111010010001010011010000000010100001"
    "11101101100100010011101101111110100110000111110001010011101111100001111011"
    "00101011101111001010111011110100010000101101000110111010101110111101101011"
    "00111011110111001000101110001001111011010001101111100011101000101100001110"
    "01111110100010101101111001011011111010001100100110010010010001110111110000"
    "10001011001100110111110010001011000110001101100000001000000101111011010100"
    "00111111010101011011101111001101110001110000000110100010000011111011010010"
    "00110011010011001001011110011110001011011110001110001001101010001010110111"
    "10100011010101100011111101011111000101011100011010101000000110011101110010"
    "11010011101001100101111101010100111000100000001010101111111110010001000111"
    "10011101010101100000001100000100101110101001111110101110010011000001101001"
    "11100100011010101000010010100001001101001001000001101100000101101110100110"
    "00110010010011101100001011101010100010100111110100111100100011110111010111"
    "00111011001111100011110010111100000110011000111000000100011001110011100010"
    "10001111110011011001100011100001101111001011111001110111101001111100000000"
    "10001001000001100011111110101110100110010110000010011001100111011001001000"
    "01001110100000010001111001010111110111001101010110101001000011001001110001"
    "00010000110100101000011110100011100111110100101110000010010100000101110101"
    "01110011110110011010101111100101011110001101110000001110101000000001111111"
    "01110101110001111101010000101101111000110111000100110011100000011010010001"
    "00000000100011110001001010001111110001100101100011001001011010101100100000"
    "00011111101001001100101011110011001110100101010100110011110011001100011101"
    "01000011001111101110001101011111001011000010000111100101110101000111100011"
    "01111101111000100101000111001100000100100001111011000001110011101100011010"
    "10001110100010010010101000110011010011100110100101000000111010001110100100"
    "00101010011011010111011110101110011010101111011010011000100100001111100100"
    "10100100000101010100101101010001101000000010100010110101010100111111101100"
    "11001001000111001101100101100001000010011110010000001100010010011010010000"
    "00000001000001111100101111010000111110101111010001011111111011111101111100"
    "01000111010111101110010111110101000111010011011010010011010101100010011000"
    "10111100001010110010111110111100111011001111100001101010111110001011100101"
    "11001100010011100101110000001101100100101001101011011100010111101000111100"
    "00101001100000100111010010101100011110110010101001100110010111011110000011"
    "11100001000101011110001001000000110101111010000001100101111001000100111101"
    "10011100111011110000001011011111001100111000000001011100110010111100100010"
    "11100110001011100010000011011011010010011101110011000101111000100110001001"
    "00000110000000111100001001000111100100111111011101101011010101010101001110"
    "00101100011000001001001111000101000001111100001110111010100010001100101100"
    "01100111000011110011001101101100000011110001111010101100010111000100010111"
    "01010001100001011100100001100101010110110011011010001110000100000000001110"
    "11100111101011111010101100110111011110011001010111111110110101110101001001"
    "00111111001010001001000101011101100000101111010000101000111111100111001010"
    "00110001100011010010100010100100010010111010101101000010100000111000001101"
    "10011110100010011010000110011001001010010110110000000010010101101010011100"
    "10010010101111101101100000110010111110110010101110001011110110111110001010"
    "01010010100100110100010111100000001011000110111110100001101011101100110100"
    "00011101001011111010001100010000000100001011001001100111000001100110111001"
    "11010010011111110101010100111110001101000000101000000000001110100010010110"
    "00011001101100011001111100100001100001100010100111010000100110010111000011"
    "11010111100011010010101001110101100011100001000100111000111000000010111001"
    "00100101010110101101101101101100101011101000110110110100011111001001110001"
    "01100111011010000101011111101011001010010000001100001101101001110001001010"
    "00011001001001111100100101110001100100000101101010101011110010010010110101"
    "00111010110110001101101100011111001000001101111001011001001100100110111011"
    "10110010000000001101001110100010110111001110100101100000011100010111110111"
    "01010011011001001101101101011111010100001101111010101010111011011001100110"
    "00111100100011010101101101111100110011010000111001101010011011011011001001"
    "11100101101100111010110010100100111111011100001101011000111000100011110111"
    "10111010001000000111111010101100000101111011111101011001101111111001111100"
    "11101010010001100101001110110010110000101101000110110000000111010111110110"
    "01011111001010101110101001010010001010101110010001101000111100001010000001"
    "01011000101000110101010011111000001000101100101100110100010100111111111111"
    "10001111010111010000001011100010010101010001110101000101101010011100111111"
    "00110001101101111010111100110100101110010111111101101010001110010101001100"
    "0010011001000101100110011110011";

static const char *poly_128 =
    "00010001111101110111001000101011110000000101001001010000011101111000101010"
    "00110100101001011001010111010110110010101110010110101100111001110001111010"
    "00010000010111001011000101000000100111011100110100001001111010000100100101"
    "00101110011110110100110000011100100001110110010001000000111111010001000001"
    "11101000101000101101111001011000011001001001011010011001000001000011100100"
    "01011010111111110100100010011000100110111011111011101110101110000100000110"
    "10110011111101100000100100101001010000001100111100001101001110100110101100"
    "01110011100101100000110001101011110101100110110000011101100100011001101011"
    "01110100001100101111111110001100101011110000000111101111110100010100001100"
    "00111111001010100001111101010101100000110100110010010101011011100110011000"
    "10110010101111001010111000010101110000010101000101101000001110011000000111"
    "01011001101000001000101101010100010101100000100011110110011010110011011110"
    "10101111000101001101000111110111001110000011101100100000001000001101010101"
    "11001111001111001000011010110101000111001010011111111110010010101001001110"
    "11110110000101111010011101101101011101101101100110111000100101100111001011"
    "11111010100100001111101001100011111001110010000110111110010101101100010001"
    "00001001000010000000001011011100101010010100011000110101001000010101100111"
    "10100111101011001101111000001110010110110011001011110110001010010110111111"
    "10110100010001100101001100111111001111111111011101101110001100010011001101"
    "10110110011010111001100100011111000011111001000011000100011001010100101010"
    "10011111000110011111101111110010001111001110110100011010010111001011111110"
    "01010110000101001110010110001011011010101111111001110001100100011001000010"
    "11100101101100011110011010010111101111110100110001101000010100000001010101"
    "01001111101111110101111110101110101010010100110010010101011001111100110110"
    "01100010110001010100010001100110111111011111100011000000101101101011111110"
    "10000101110101110111011110110000111100001110000011011010010010010010101100"
    "01110001001100010110110001001000111110101111000000100100010100100101101111"
    "10001101010011110111001000000101111111111010100000110010101011110011111100"
    "01111100010100010100001011001110001010010100001011111110110111110010010000"
    "11110001111101110001000101010101101001111000010110011010011111010011100101"
    "10110011010100001001100011000000011011011000011101001000011100110001010010"
    "10101011111000101110000000111011101100011010110001101100110000001010001100"
    "11110110101110011111011100011001001101101100110100111110010111110011000110"
    "10110101111100110111101011100000011000010001010001101001011000001111000101"
    "00010001100010110010101100000011011000000110000111100100001010000110100111"
    "10001101111111010010101100100111101010000001101100111111101101111100110111"
    "01010101101111101101010001000010111101110101001111000000001001111100111111"
    "11100010000010010001000101100110000111110010000000111101110110001001100011"
    "10011110110100011011001110011100011011000010000000101101101001010111000010"
    "00001010111111000000010010110101000010010000110011000110000001111001111001"
    "01010100000111000000110111011101011111100010101001100110011000001010111100"
    "10001110010010101000110001100100110111010010011001011000000001110001110111"
    "11100001001001010000010101001000010010101111111111100110010110101001101010"
    "00101110010111000111001001011010000110000111100010110110100000100110010000"
    "01001000000100011001010100011010110110010000011000011000111101100100001000"
    "00100010011001010010110111100011011000101011001100001111110110110000110011"
    "00101000110011010001000011100110111111010011010111100110110111111101111101"
    "01110010011001100000010110000010110010000010000000101100010010000110010010"
    "11010101111010101111010100010010101100011111011001101001110110010100100000"
    "01100100111101000100110010111000000001011110100011111110101001101011101011"
    "10001001110000111110100000101101100110010001111101111011001000101110111010"
    "11011111000110011010110100010110000100001111111111010010111001101010110000"
    "00001111000101100011101011011100111110111000000000011000111001100110110011"
    "11110100011100001111101000110001000011001100100001101111001011011001111011"
    "10000000001101100010000001100001001011100011110100001100100110001101000111"
    "10000011110010100010001101011101010011001100000010101001001101111101000111"
    "00111011000000001011110100111101100111011101110100111001010010101011001000"
    "11111100110001111011111110010100000011100110110001101110000010100001010001"
    "11010000101111001011111011001100010100010100001011100000001101000101100111"
    "11111010010101001101010000110011011011001111111001000010000101001111001011"
    "00010000001000001110000111001010011001000010111001100110100110110101111011"
    "11011100100100010101001001001100011111001010111001100011001010010000100011"
    "01010011001110011001110001110010100010000000000000110111001010101000011111"
    "10110111010001110110010110110001011101000100011111001011100001000010111111"
    "01111101010011001001000110001101110110001001010101100100000100101010110011"
    "00011110011100111001101111110101100100011111111101111001001101101001001010"
    "01100111000010100011001011111001011011111100010010100010101101000001011011"
    "01100000110101000101000010001111000100000111110011111111110010010001010001"
    "11101100110000111101110000001111110001000011111011101000101010110010101101"
    "10011001010010001011100001010110101010000001010110100001100110111001000001"
    "01100110001011001000001111111000110011100110100110011100001110011110000000"
    "00100100101010000011100101011000111001110001101001001000111001001100101011"
    "11000001110000101101001011010001001010000111000010011010100001010110000101"
    "10111011001100001110011110000110010000110100011101101110011001000011111100"
    "10110010011111000010100000001101110100000000101101000001100000010001100011"
    "11100010000111001111101100001101011111011000111101001111110000000110111101"
    "10110101101011101001000100110100011011001000001010100000000110010010000000"
    "11110110010010101101000111011000010101111010111000001001100111110000010110"
    "01001101111001111100100010111101101001101010000101100111111000010111111010"
    "10010100110001001001001000100010101011011000011100111000110101110000001110"
    "00011111000111100100001010110000101011110100011010101011000011001011000001"
    "00100000101011001100001100100010101010101010011100010010001010100011111110"
    "10100000001010101010010001010101001001110011001100001010001100110111101010"
    "00111101001110000000100111010001001001111010000100001111110001000100100010"
    "00100110101011001110100110101110110110100101111000110101101101001000001110"
    "01101011001100101111111010110111010011110010111000010101101110000011000101"
    "10110100011010111011000111010100011000111101011000100101000011000100010110"
    "11000101000000001000011111000000101110010000110001010101000010001101100011"
    "10001010010111001010000001001101101010000011111011000011010101101101001000"
    "11100001110110101000110101110010011100010010100111001101110110010001101001"
    "10110101010000101000111011101101110100110010101111010010110001001110011100"
    "11000000001101000001111001100001100000011001110100110011001100011000100101"
    "01111111111101101111110001111000100101011100001011001010000010100010110101"
    "00010101001010001001110111110011101001001000111010101111011010000100000100"
    "10001110011100100010011001001100100010001010011011110100000101101011101010"
    "11011010010001000111000011101011100111101111100101100000000000110001001001"
    "00111001000101111000000110001011110101111110111100000000100101011000111011"
    "10110100111010000010110010011100011110100001001011010101110010100010001000"
    "01000111011010000110111101011000100111000110000111001100010110000010110000"
    "00001101010000001101011001001011100011001001000110000110101011100001010001"
    "01000001110111101111101101100010010010101111010111100000101111001011001110"
    "11011100111101010110001111011010011111000010111110100001001010001011001000"
    "11011110000010101100101111110101000001101111010011000001000010111010101000"
    "11010010000001101100100101001000100011000010101011111110010000011101110111"
    "11000000110111111110100011000110011001011010111101010111011000010100010011"
    "10111111101100011111110100100010110111100111100010111001011100101010101101"
    "01110000001010110010000010010101111100010111110000000011101001000011111001"
    "01111110011110010010110010111101011010101010011100111111001111101000001111"
    "00100000111111000010100001111011111110110010001001000000000111010011001011"
    "11001011111110010100011110011011000010110001110111000101000010000101000000"
    "11001000000011100011011100100110001011101010011111100111110110010100001100"
    "10011100111001101011100011011101110000010110110010110000111001110110000011"
    "01110011100010110010100000000111001101100100111100111100001011000010000001"
    "11100110110000110111111001101001111111010000001011110011011011100100110000"
    "11010010111111011001001111110000000100011101110110100110111010011000000110"
    "01010000010101111111010110000100010010111010110110000100101010011001000011"
    "01101001100110010001110111101100110011101111101010000011111011011001111010"
    "01010101100001001110100101110000101000111100100011000001000010101001111101"
    "10011000001111101001110001101011111111001010010110100001101000000011101000"
    "10101110100011010111100001011100110100100001101000001011000110001001011111"
    "00011001111011101001010100111001110100001101000011011101100000011001100110"
    "10111100001011001101100001011000001101101000010010011100011100010011100110"
    "11111110010100110001001011001101111000100011111111100110111111001000001100"
    "10110101111010011101111110101110110100101100110001101101001010111101101000"
    "00001111111110010100010111000100001100110001111101110110100101010111101101"
    "10001010001001001100111111010011101111000000111011000011010011011101010100"
    "11100101001011010001100001100011000101010011101010110101000001101101111111"
    "11110011110010001111010001100100011010111101000000101101111010100110011110"
    "00101001011000100000101100110011110011011110001110010010100100011111110000"
    "11001101110001011011010100111001101010111101100101010101110010011110010000"
    "01100100111000001000110110101100111000101011000000100001000100010011000001"
    "11001100001111000001110011010111110100000100011000000101011010001111000010"
    "00010011110000001011001001100001101101111101110000011110100101110100001001"
    "00010011111100101011110101101011011101101110100001011100011000000000110110"
    "10001101010010001000110101010110111011011111101101011001110101101011010101"
    "11101000000010010011111000000101000110001000011100001101111010101100000100"
    "00010011111111110000000000111000111001011100101111000101111100101011101010"
    "00011000111111001110111111000001101101011011111110011010100100001111100111"
    "10000000010100010010101011010000011001110101011000101110010011111000001110"
    "10110111000101110001110110110000100100101110011110011001110111100010001001"
    "00011111000010100101011001001010100101100010010000110010000101010111111001"
    "00001110000000010110111001000110111010100111100000111001010100000111100000"
    "10001000001010110001010000100111001100110001111000100100011100110110001001"
    "11101110010011000001001110010100000000000111000111111111011100101011110101"
    "00010000100001010110100101011111111000011011001010000000101111010001011111"
    "01110100000010111101101110000001100100001100100111110001100010101000010011"
    "11110000010001000010111000011100110110010000001111111110001010011011010010"
    "00001111000100100001010110111011110110001001010001110001001100011001001100"
    "00000010111000111101011010110011000010101100010100001111000000110110110010"
    "00010101100010101110011001101110000010101101000101001111100101100001010101"
    "01001101101111101010001111100010000101000000001000101001000111111000110110"
    "01000111100001010101110110111110101111010111110011111110011110100010100001"
    "00110010111010100010011001000000010111100010000101001011001101100011100001"
    "00111101010010011010111111110000100111101010010100111111110111010011101000"
    "01001100010000100001001100101101111011100100011001111101000101100111110101"
    "11101011010001111101010010100111010100100101010010000000000110011001100010"
    "00100001010101010100001010011100000111000011100111000110111111100001010101"
    "01110010111010010010110011001111011010101110101111110001001100100111010001"
    "01100001010000010000000100110000001100001110111000001100000010110011100001"
    "01001010111101000110101000011000000111011100101010000111000010010101101010"
    "01011000010110110111101100110001001001010100111111010000001000010011010000"
    "11000101010111101111011111110001011100011100001011011101001011000000000010"
    "01010010001111011011000000001101110110010100000000100100011110111011101101"
    "10110101011000111010000110000100101100000011111111010001111001100100000100"
    "00000010100110011110000000010000011111000111101011110000000000010101101001"
    "10000001001010110010011011101100111000011000111010011010111100110100010111"
    "01000100011111001010100000011111111101010110000001000100011000011000010100"
    "01101001100111000001100101101000111110100010000111000010011000101000010111"
    "11101110001011100011100101010011000000001001101110101010111100011000100011"
    "01110111011100001100011010001101011010100110110011100000010111001011111110"
    "01010011010001000110000001110000010110010110001010110100000010100110100010"
    "11000111000011000011110011111001111010001101011010010001001000100100110100"
    "01010010110111011100011000100010101000101111110011001000000100011111000101"
    "11010000111100110010100101110101001011001010001000110001101010011000010001"
    "10101111100010110110010001001001111011010010011101110100001111100000110101"
    "00101011111000110110011001011101011100101111101011101110111111100000011100"
    "10000010011111000111011011000011000010011110011111111101100101111011100010"
    "11011000001101011100001111111111110101101010101001110000111110110011000001"
    "00000101011000101110101101001010000000010010000001011110111011100100001111"
    "10111111101000110100100001100011011111011001100010111001011011001011001010"
    "10010011010010100100011101101100110001100101001010111100110010011010001100"
    "00111011100101110101101000011001010010100011000001111001110110101101010010"
    "11011000110010001000010111011001110010100011110110101100100101100101101111"
    "10001001001111001111010010001010001101111010011010110001111010010011011100"
    "01110101100110001001001101100011011111001111101000010001100001110011011001"
    "10110010110000000101010001110100001010011101111110001101000011000000101110"
    "00100001010100101000010001110010001100010110011111111101111000011001110111"
    "01110011001001010010001000100001001000011100100000110001100011010111010011"
    "10100100011011001000111010101110100110011010111001100001010000100110101001"
    "01111101011101110000000101001111010110101010010000010010000010001011011110"
    "00000011000010111010000111100110111011101111001011110100010010111011101010"
    "10011011000011100011011011010010101100100101000100100100110111000111000111"
    "10011100000110000100011110101100011011111000101000001001100100011011000110"
    "10111000111010111000111110000110000101111101110010110111001011000111010001"
    "10110000100101010100100110010000110101101110110100010010101001110010000101"
    "10110110101110000110000111011001001100101101100010001110100100100011101110"
    "01000000000001000011011010001010001000001110010011100001100110101011011101"
    "11011110111100010010001110000101000101100111001010101000111010110111010110"
    "01110111111111010101101000010111111011011011100011100101010001011011100011"
    "11101110010101100010001101001010000111110100111100000001011011100100001011"
    "00001000100000000010010110000000000110011100000000000111100100100010000011"
    "10011101111110011111011000011001110001011000110001001111111100111110010101"
    "01101011110011001011000101000010111111110100101010001000100111101011100001"
    "00000100100011111111101100100001101011011100001010101000111110111111101011"
    "01001111111110100011101100101101100000001010111000111011101100111011110111"
    "10011110010000011001111001110111011011111010011011001110111010110011111010"
    "00001000101100100101010010101000101110001011110010110110010011100101000111"
    "01111110110101111001010110101101001001111111000001101001110100000001000011"
    "10101001001111101110000011010100101100001111001111010101011110001001010000"
    "01101011001010001110010010011111010011000001001111100101000100110010010101"
    "01110111111010011101101100000101011110111010011110001111110100111011110011"
    "01001110010101101010101100000110010100000001011010101010011010110000110110"
    "10110101010101111101101100110010000011110101011101101101111001100110001001"
    "00000101001010001111111010111001110101010110001111100110010101100010011111"
    "10000011001111110101110010000111000110000101010100100110001001100100010011"
    "01101000101101110010000001101001001110101111000110111000011101111110100100"
    "11011100000010101111000011001000010101010011011110010000011000000110100001"
    "00101100000001110100010010000110110101010111110001010000011001110010101011"
    "11100101101111000000101100110110010111101110010100110111100100011101101110"
    "00000101110110101111110101111111011011000011111001110110011010001000010000"
    "01101000100101100011000011000110101001110100111010110000100010110101110111"
    "10001011000100011110011100101101111001000010011101010011011010110101110010"
    "01101100011101001011011001110011010001010110100111001111100101100011100101"
    "00100000101110101011100011001101111110000111010010000010100100111010001110"
    "01100111110111010010010011001011111110101001110111101101111101101101001111"
    "01001011000010110000010010010100101100001000000110110011011101010001011110"
    "01000100111011010010000110110100101110101000111011111101011000111001010000"
    "11110111110110011111111100010110010110111010010001111101110011011010110000"
    "00100000101101000101011101000010000100111001100011100011100101000100100101"
    "10011100100110010100001110011110000101101000000110101101101111010000000111"
    "01001110010001010000010000010010000100001110100001000111100000101010110010"
    "11101001010110000000110011010100100100011000111011101111000101001001001100"
    "01100001111101101100001111000101100110010001000111001101101011110100110100"
    "01110100001111101101010101010000111110100101100010011001101101110001001000"
    "11011101000010001010110001111001111101110001111010010000001011101001111111"
    "00001010010010111101001000100111011100110101001011000010100000011101000011"
    "11110111100010011001100001100110010000101011001111110011101010001111010001"
    "01010111100110010000000110000100100001011101110111010001001011110010101111"
    "10000111110110111101101111000101000010001010011001001001001100100101011001"
    "10000000100000000111110011100111101001010000010000000000101011100001110101"
    "11001100000011001010101010111111110110100111100100110110010100111010100101"
    "00010001011010110001001110101101011111010000101010001100001100100101101110"
    "11111100110011100100011001010110011010100010001111111100000101000001011010"
    "10001110011101101011100110011011000110011010100001101000101010111000010010"
    "10011110001010100100001101110011101011100100101010001100110011110010001100"
    "10000100001100010011101100101111010111011010101110010100110101011100000101"
    "00010000111011000010110011000001100011001010000111000110001001000000110111"
    "11100000100101101000000000000011111100100011101111000010100111101000011101"
    "11001010101101100010101101011110011111100101111000111001111001101101001011"
    "11011010111011101101000001110111001010011001110010100100100100001010001100"
    "10101011100111010000011011110100001110000111011011001011010011000000111001"
    "00111100110010110011100101000111110111000110111110110110010101110110011101"
    "11111110011110000111101111101011000001110001011001001101110000101001010000"
    "11000001101110111110111100011010101100001011101000011101100000010001110101"
    "01001110011111010101110001110100001000100001011101001010001110100000101100"
    "00101110111110011110101111100111110010110111101011000011100111111101101001"
    "10010000011011111101101110110000110110011100110111000111101000010111011110"
    "10111001000000000111011110110001000010001110000001110110101010101100001111"
    "11101010110001111000011010011110111101100101010111000001100110100110100001"
    "00110011010111111101111010101110100111000101010011001111101111001100101000"
    "10100011111011100101111110000000110111101100000100110011111111110101111010"
    "00001111011110010001001001110100111110010000011110000011000000101001100011"
    "11011001100110101010010000100010101100000100111101010111100101110100010101"
    "11101100001001100011101001111101001011011010011100111001110001111101001001"
    "01000101110000011000010110100100001001001101010101110010010110000101011011"
    "01110011011111100101000000100101101010101001000101101011110011101010110100"
    "01011010100100001011101110111111001111111110110111011000101010000010000011"
    "11100100010010110010010011011011000001111100101100110101000001000111111100"
    "01110010110001000001001111001101110110110101101010111000010011110110001000"
    "1110010110111100011100101100011";

static const char *poly_132 =
    "10101000111110001111000101110110111101000001101010000011100100111000110010"
    "00100001010100100111010010001101100100011100100101011101001111000110000111"
    "01110001111110100110000110010101000100001101011000100111101001111011100101"
    "01000100111010000100110100011000001001110111001100101001000100010100010010"
    "11110001101101010001011011100111111110100000010000001000100100011000011101"
    "00000001110110011101011011011111100001000100010111101000100110111101001001"
    "00110010111100111011011101111111001110011111110101110101100011011101110100"
    "01110001001000110100010010011001010010011011000010010001001000010011110111"
    "10101010111110111111110111001100010110100000011000110110100001000010101011"
    "01011000100011010010101100001100001000000110000111001110000001010010001000"
    "10010111110000111101101011111110001100011101001011010011100100100001101111"
    "11110010000010110110001010001010000101110010000100100000010011010001010000"
    "11101010101001010101011000101011000010111010100110110000111001110110111010"
    "01001101100101001010101110011010110110010010001111000111000000011111011000"
    "01011110110111001011110101011100111001101011010001010101011010010011111011"
    "11011001011000011010011110000100111001100010001100000100100101101111110011"
    "00110001110001110001011010110011001111100101010101011000101100110111100011"
    "00101011000110111101010000001111100101011101000111111000011010111101001011"
    "11011101011010000111000100110001101011010110100010101011000000111011010101"
    "00101101011100100010011000011010101000000011101111100111010001011110100010"
    "00110010000010100010100000001101010111011011110101000110111100010000111111"
    "11101010100011010110100010110011101111000100011110100011101111111011111101"
    "11110001101010000111011011010000000011011100101010000100100011001000000111"
    "00001011100001011001100111110110001010100110100010000110000000100010101011"
    "01001011010101000111000110001100010010101000101111010111001100100111000011"
    "01111010110001010010110011100000100111000100100011101010101101001100101010"
    "10111010100101011010111100010001011100111010100011110111011010010101011011"
    "00101001000111000110000100010011010011000110101000110111101110111100001100"
    "01111111011110100000110100000111001100000100111111011110100001110011101010"
    "10101010001010011100000111011000001000011111111001000100101001110101101111"
    "00010001110000011000000110100010100111101110011000110100000101111101001001"
    "10011001011111111000010100101111011000111111101101001110011101011010111011"
    "11000001000010001100111101101011111101010010110110101101010101111000100100"
    "11100000111001011001010001101001100101000011000000000110100001100100111110"
    "01110101000000110111001110101110000011010001000100011110101000011011010010"
    "11010000110010011000000111010011010111010100101000001000000110010101100100"
    "10100010110101000110000011100100110110001010111101100001010010101101110100"
    "01110100101110110101111000001010011110011010100100110011010000110110010000"
    "01000011001010010110000101001000111100001000000011110011100111111100101011"
    "10001011010001101110001100100010000101101001011110001100111111010101000010"
    "00000101100111110000011111010010111111001010100110000101111111000100001111"
    "10101100001101111110011011010010001011010001110011111101011100001011010000"
    "11010100101000110110101110010000011111101110001010100101011100010101010000"
    "10111110010100110000001010101010111110110010111011001101101011111110100000"
    "11110011100100101001111101001010010000110011000001110111110111100010100100"
    "00010000000100011111110010111011110010110101100111111011100000100111111101"
    "10010010110000011101111001001100111000010110101101100011111110010011010100"
    "00000001100110100010011101110011000001101111011000100111000001100000011010"
    "00001110001101001011101101101101011001100001100101010001101010010100001100"
    "11010100000101100000100111100110100000001101101010110010001001100100101010"
    "10000000011000011100101011010100111011110001110000111000100100101011100011"
    "10001011001001001000100000100100010010100110010001111101010101001101110111"
    "11001101101101001101001010100000100010101010001011010101111111110000011000"
    "00011000000110111011000111001011111100101001010001111011011000010110011111"
    "10001111100111101011101100111001101001100111011010000101001101111101011101"
    "00010010101110001111001010101100100111001011101001110000001001111111000101"
    "00011100110111000000111000011011001000011100001101011001111111001111001011"
    "00010100001111011111000100000111110011111000111000001010000000010110000110"
    "00111001111010010110111000001101111110000110001110000101001010011110000101"
    "01100000000100101000000111010100111010000110011101110100101010100101110111"
    "00011101111000111110100010011101010110110110111000110001001011001011001000"
    "11010000011100110101001010001100000101100101110101010000001001110111110111"
    "00000111101011100010100100000100011001110111010110001101100110110100111111"
    "00000011011110111000101001000110010000111111000001110010001011100100011011"
    "01001011011111000011111001110000111111001011110110110110110010101010111010"
    "10001111100101010110101010100010000101000100101111001011100000000111110011"
    "00010100100101110100011101101100110110000000000101111100110001000111000010"
    "11001011010110101010000011111001111001110111111011000001000100010011001010"
    "00100010100110101101000000100110100101011101110000011011100001000010000110"
    "10100011011110010100010111010101101110011111010011100010001110011101110110"
    "11000010110000101110110110111101011000111110100101010110011011110110000110"
    "00010011101000100110001010000011111101011111101101100100110101011110001011"
    "01101110000101110011101011011111110011011100110111000010110010010010010101"
    "01111000001000001001100110111100110110011011011111010100111111111110111110"
    "01001001011111101101011010010001110100001111011010100010010110110001001001"
    "11100111011000111111011110100101000000100010010110001011001110010010110100"
    "10010111000100101110011100101111101100000001011100011010100110101101000110"
    "01101001100101001011101000010001001010001111110110011000111100100001001100"
    "11001000101101100110010101000100001010101110010110000011100001111010111110"
    "11010000100000011000100101110100011110011011000010100010101010101101101100"
    "10011000100010011011101000101111101100110011100011010111001001010010001111"
    "01011110110110111110101100111000001011000111011010101000011101001110011010"
    "01000000010111001001011101010100001101001111100010011101011001001110110001"
    "00111100110110010010010011011001010110001010001110000110110011010101001110"
    "00001111111000100011000000111000101000111101110111100010010111011110101011"
    "00011100111101000000010111101111010010111110100100111110111111100110101000"
    "01001010101100010110110111000000100100111000000111011010110101101000010111"
    "01001010111011100100100000111100000000001011110100110101101110111010101100"
    "01000101000100001110101010101010001110000000011011100000000111111101010100"
    "11110011100100000100100110000001010101111000000010010111100101001010010000"
    "00010011001001000001001100101100100010001000100011100010000100110110011100"
    "00010011010111010100010110101110001011010100100011100100111101111100011111"
    "10010100100000010100011111001011010011101111110011101000011101101110001110"
    "00110101010101001110101110110001101011001001011011110010001101101001001010"
    "10010000001110111111100101110010101010101000001001110010011100100000110110"
    "01110110000111010101010000111010000111110011001000000010001000101000000000"
    "10000011101111101011011111110111101000100000100000010101010110011110000111"
    "10010100000001110010110001101000101010110011111001000111001001001101001110"
    "10110110001100101100000110011101101001100010000000100100010010010011101111"
    "11110011011110110010101011100001000110000010001101010001011101001101110111"
    "01101110010110001100101000001110011010111000110111000011010010110111000111"
    "00111011110000000111011110001101100100000001100101100111010111110111000101"
    "01011101001110100111110110011010101100101100111000110010011101100010111000"
    "00000011010100111111111101001110111110111100100011011000111111100001111110"
    "01011011110101011000001100011111010011111011111101000101010000011111011111"
    "11111110011111100101000100101110001001001011101101100110101010101111100000"
    "00010011011110011000011000011001100110001001000010000010110101110000100000"
    "10101010000010101010010111011111111010111000001101010011101111001001000111"
    "11111111101011011011101111111011011110000101111010111110110101101010101011"
    "11110011000111000111111100011000111010100001100011001111011000101100100100"
    "11001011101001000010101000000001100000110101011111101110100011100011011110"
    "11010010100110111001010010001111001100011100101010101010011100100001100011"
    "11001001101001001111001000000011010011001001100001001100110011000011011110"
    "10000100101110001011011100011111011001010110100010001111100010100010100100"
    "01110100100110001010000101100110001101001110000101011000100110001100101010"
    "10101101111001100100101101010010011100011010100010001111111000100110000010"
    "10110110101110010111001101011011110110101110110001001111111100100110001010"
    "11110100100111011000100100101011110110111000101110000000010010100011111010"
    "10010100101001001001111100110011110111101000001110111101111100100111100011"
    "11100110100011010001100111000100001010100010010110000011000010100111001010"
    "10101001000110101111011100010101010011000100101111110011100110011001100000"
    "11000111000100110000100110111010101101100010110011110101011000101101000001"
    "11100001010100011011110111010010111101100001000111010011100000101100111010"
    "01100010100000000101011100010111101111111100011101101110110010001101011101"
    "00000000010110100010010010000011011010101011101000000001010000000010011110"
    "10110010100110100011000101001111111011000100110011000000001111101011001010"
    "11000100110111100010111101001001011011011001001101100001111110110111011010"
    "00110100101001111100111000000011000010001011101001001010101000001111100100"
    "10111001000100010101011000100000000101000001011010011100000101111001001100"
    "10111101000110001001011111000000110111111000100111000010000111100010111100"
    "01011100001011001011001001000011010001011110110100110110010011011101000111"
    "11010010011100011001001001000111011000100101011100000011111010011011000100"
    "00111111111011110110110010010000100100001010100100001101111010001110111101"
    "01101110110111101110100000101110100100010111101111000000111011000000000001"
    "10111011110001011110011011101000100101111000000100010110000101010101100000"
    "01010110011001111001010110111111001011101000111101010000001101010001011011"
    "00101011001111000001001110011100010000100001100111111111010110101000000111"
    "10110100001110001001111100110111011001101001000101100011110011001100100011"
    "10110001101100111110101111011010111101001110000101100010101011011111001111"
    "01101110101000100111110100110011100000101000000010100101000110011011000111"
    "01001010110011111111110000010010011110111011011011111110111111010100110110"
    "01110110011110011001001001011011111111001101101101101111010111001110010010"
    "10110010000100100111110011011100110010110111100000000000101001011001000011"
    "11000001110110100100010011010111110000110010011010000110011010000011100110"
    "00011111100111011110011110011100000011110011101110101110101110011111110011"
    "11100001101111100110110000111000001011101000010100111000001111010011101100"
    "11011011101111000001101000100010111000100100101100011000000101010011011100"
    "10010100001001010110000100111100110010111011000110011000011110111010110101"
    "01001000001100111011101011110111000101010100111000011100101011001100001101"
    "10111011111100011010000100111101100010100110010000010101101010100011001111"
    "10011011111011001101110000111101110110010011001100000111110101100101100100"
    "10100011101001011001111011110001100110001101101111011010001011111000101001"
    "11110101110011100000101001000011001111010101100011001110111010111010010110"
    "10101101010101110111100010101110110111000011111000100101000000011001000110"
    "10010111101100101101000100001010110101111100111101011000000001111010100101"
    "10111101101000011000000100111011001111110110001000100110111011010010011100"
    "00110100000010101110001000011100110011110001000110011010100010010101101001"
    "00101001101110010100101000101100101010011010010010000110111010000101101101"
    "00000100011101000001110111111011111000001110010001101000001111111011010001"
    "00110101001010011100001110011111011111001001100111101000010100110001100101"
    "10011100001111011001100110011100110100111010100010011001111011000000001101"
    "00010100010100100001111001010011011000000010011001010100001010010100001000"
    "00110100010011011010111110100101000010011001111111010110100100111001011110"
    "11110110010101101110110101001111101110011000101001010110001111010111001000"
    "00110011010000010001001100111010101000000100010111010101100111011101010110"
    "11010001000101100001111100000101100000000010010111111000001000010101110000"
    "00010100001110011100110111100000101000010011110001001110010101011111011100"
    "00101011011000101100000000011000011110000010111111000101000010100000111000"
    "10100001111010001010111100010100000100000110110101110110111101111100111110"
    "11111010001111010111010111101000110111011011011110111101101100010111111011"
    "10001110011110001111101110101101101101100001101101000010110000110110111101"
    "00001111000101111111111001101110010110011000010100100101101000100111111011"
    "01111111010100100111000011001001100100100111100001111111110111100010100110"
    "11111101110000011100000111111010110101111110101001001010011001111001111110"
    "00110101000101011011111001111001101111011001110100010110010001110011110111"
    "00100011010111010110011110100101110001110100101011001101010001111010010011"
    "01101100100011100010001100001011110010000010010101001011010111010010101000"
    "10100001110100111001001100011001111001011100010111100100001111101001100011"
    "10111111111011101000110100011111110001100011101111111000001011110011101110"
    "01000000010010111100101011001111100101011111000010100110110100011101010101"
    "01111000101110010111100111000000101100000000100011110100000110010010100110"
    "10001000100010011111101001101010100101001110110101110001100111010110101110"
    "00101110000100001011010010111101010000100000000101100011100110101111000000"
    "01000101111100011000001001001110011110100001001101001100111000111100101100"
    "11101100101001110010110100010101011100000010000011110111100001101100011001"
    "01111100101101010000100000101000110110110011011001100100001101111001110101"
    "10101010001101000110010001010111001001010110011000101001001101101011001111"
    "01011111101010010110111101110010010110101100111111011110001110101001000000"
    "00110001000001110101101100101111001000111010100001000011001110110111010100"
    "00000011110110110000001100000101101000110010111011110111011111100100011100"
    "10100010011001101001101010000010011110111010011010001100010101101010000100"
    "01100000101111001010100101000100010001001101111111111010011101111010111111"
    "11100100101000110101110010111001111100110011111010100011110011110101011101"
    "00010111111100001001011101101010011001111110001100101101011000000100000001"
    "10110011101011111110001010011011111001101010000011010110000010101110010000"
    "10101101101111111110011010011110110110001000010100111000111100101101111101"
    "10010011100100100111001001111100110000010011000110101000110001010100001001"
    "11011011111110000111000101111100001101010011101000110110111000000100110010"
    "11011011100101110100111111100111000001000001000111000110010100011010111110"
    "01010000100000111001001100101111000100111001110101110000000110110001110010"
    "11011110100000010110001010110100010101111111010011111111110001111000010000"
    "11100100101101001111110110001000110001011101110001100111010001010000010110"
    "01000101011000001000100100101110110001111110001011011011110010100111110110"
    "10010010010010010110110011010111011110001110100111000100011001101110100111"
    "00010100101100100111001010000100000111001101100010001011011010101110111100"
    "01100010111010110011110011000101000111010010111001010001100101001101001010"
    "11010001010111010111111011001111101111011001011011111001101110010110100010"
    "11011010011111010101100101010001100010011111101100000101100101101110110100"
    "01000111000110000000010001111001011000101011111111100110011111011011001001"
    "11110110011011110000011000001010011011101011001001001101111100111110001001"
    "00110101100111011001111001100100010000110110011000011101001011000010110110"
    "00011110011101011010100010100000000011001111000101111000111100011111101111"
    "11010000111100010011110111111101111100010111000110000100000001111111011001"
    "00010110000000010101001011100000100010000111000010001110000000111101110011"
    "10111100110100010000100110010010000001001001111011001111011101001000101000"
    "10100000100011001100010011101010011111011000011100010110001110111001001011"
    "01001011000011010000101100010111100000010100011110001100111000111111110001"
    "00111110100111001010110101110100011101010111110111001010110010001010010101"
    "00101010001011011001000001111011010011001001011000100010011011001011001001"
    "10110010100010011010010111101101001110101000011000101011000110110011010011"
    "01011000100000100100011101100010010111010011000010100110111010001110000010"
    "11110001110110011000000100011111100111000000000000101010110100100010110011"
    "01010101000111011010110010011000011110001111110010001010110101111000101101"
    "00111110000101010110100110110010100000010111111000000001000011101100001111"
    "10011110011100010000011010010101101110010000001001011000101101000111100001"
    "01111111000001011011010011001010001100000010101100000101101100101111110101"
    "11000000010010010001100010100010101000011110101100110010100100000111010111"
    "11010011011110111011100111111100101111101010101010000001001110000001100110"
    "11010100100010100010001000000110110011010011100100111100010011100101101111"
    "01110000100101011111100010010010101100010010001000111001101101010011011110"
    "01010110101110100100111110101001010100111001111010010101111000011101000011"
    "11000010001110011001001100010111110111001010100001101000111100111100110011"
    "01001011100111000110110000111101101100100100111100000010100110110100001100"
    "10101000011100111001110100001001010111101110101101001001000101010110110101"
    "00111101001100011010111110111011110100001111000000000110000010110011101011"
    "00110110010010100001101001101000010000011110101000000001101000111001001010"
    "01000100000100010100010001101011010000100111001001110101101011101000010010"
    "01100000011010100010010001101111000111000101111001001110011100111100010011"
    "10000010101000000000011110110000100110001110000101000000101101100010111001"
    "01000010100110101100110010000010010101110110010101001010000110011101100110"
    "01101011100011100110011011001100111000000011001100100001011100101000010111"
    "11111101111100010101101111001001011000101100110111111010010001100010101111"
    "00110110000110111100100100111000001000110010100111110000000010100100010001"
    "01010001111111011101011100111111100110111100001001011100011101110111010100"
    "01010111010011010001000010000011100110101011101101111010001011011101011101"
    "11010111000010111101100000000000001011101111100111100000000011001011111001"
    "10001110000111111110100111010001110000010111101011100101101000010011000111"
    "01010110110011101010010000000100110000000111100000000110010101100000110001"
    "01010111110101100101010011100011110111000101000100100101111101100000001100"
    "10010011111000011000000011110110111111110101100101010111011111100111100011"
    "11000001101010110100101001100101100110111001010111011001111000111010100111"
    "01110100101111110100101011111011101001010101010110001101100000111010011011"
    "00001111111100000111110000010001011000100000110111001111010001101110011111"
    "00101001111010010001000110011011001000010111000000100100110000000101000011"
    "10010100011110110100010101111011001110000000111101000101011101100011111111"
    "10101101110010100010100000011011111111100110011011101011111001110001101000"
    "00100001111011011001110010001110100110110011111101010001011000001101111100"
    "00110000110100001101101110010110001011100110010100001010101010100000101111"
    "10011101101011110111001110001100000000110101000110011010100101110101010110"
    "01001010100010100010001011110110101110110110000110111111011010011110111010"
    "11101011011100110111100101100010100011001111001011000110110111111011000100"
    "00101100100111000110110111001011011110100111110110010101110010101110010111"
    "01001100011001110111110111101100011100110010110110111101011011100011001110"
    "01011011111010101001001110110001001010010011100001011011001111100111010111"
    "01000000011001101000111001010100111111111000100111101100000110110100010100"
    "11111000000110111100011001110111111000110011101000000110110001101000010101"
    "01011001011110100100101111010000101110101110100100010110010000011001111110"
    "11111101100001011100110000110110100011010011010111111011001011010000100010"
    "00110101100100001001011101100111010001001111100011011000101010110011101010"
    "1010011011100100100010000001110";

static const char *poly_136 =
    "00100101101011011101101100100010111110000010110011011001100101110111001011"
    "01010000000100101000011100011110111110010111001011010001010000111110111011"
    "01100010101000011110100010010101101010011001110011111011010001111110110011"
    "11101001011100101010010011111110110100011111101110010101100000001100001110"
    "10111000010011100100000010001110111011100000101010100001100100000001101000"
    "11010000101110001110011111001111100110101110010100110010110011100100111010"
    "00001010110011001010101001100010010010010101000001101101000101000101101010"
    "00010101100000001101001100011010111001000000010000001010001010011011011100"
    "10100010011010010000001111000110001111011000000001001010101001001100100010"
    "01011000100100001010110100111110100010101100001100100111101001101010011000"
    "01101010111100010000001100010011110000100001111101101101011000010000011110"
    "11101010011110011011110111010000000010000010011011110010110001110111101000"
    "00111110100100000111101001101000001011110111101110011011110100011001101111"
    "10100110101100100111000100111000100101100100100100011100111100100110001100"
    "01111111010111110111000111100111010100111111110111010111000100010011111100"
    "01010001011010100010010000111001101010110110100001110000110011011010111110"
    "00000000111011010101010100010010011101101000101111101111000001001100001101"
    "10011101110111100011110101000011100110100001110000000111011111100100100011"
    "00101110110101011100101111011001111101001001010111000011010001010101000111"
    "11110100011011000000010111001110101110111011110100000110110111101011010100"
    "00111110011010001110100111110000111100000000111111101111000100010011010100"
    "00100101100001010101110101100010001111011001111111111010101011010010011000"
    "01000000100001010001000001111100100001100110010111101011010111110010101100"
    "11110000011101111110111010000100101110010010101010001001010011000101011011"
    "00111011101100110110110001010010001010101101100010110101110001110001100011"
    "00010011110001110011000100110000011110111000010011000101111111011011100010"
    "11101111100111001110011100000111001111010100011001110001100001101101001010"
    "11010100111010001010000101011000011101000100001011101111100010000111001001"
    "11001111010011101111001100101000011000000011000010100010111101100100111110"
    "01011010101110000001001110001011000011000110001011010000001111101111101011"
    "00101001010110110101011011000001011111010101100100000100100110111011111010"
    "10110011100100001111110110001101010100010100000001110100001011100111001000"
    "10100111101111000001101111100110001001100000111100010101100101011001011000"
    "10000001010000001111011110100111011001001110000100111000101011000111111101"
    "00000000011001101001110001100110001111000001101010100000000101001111001000"
    "00110011100011100001011111100000110010110001101111001000001000101110001001"
    "01000110111110011101010011100000010010001101011101100110000110111010101010"
    "00010001010011101011001001000101010110001111100000011011010000000101111110"
    "11000001110100011000001101010101100010101011001110000100000111111000101101"
    "00101111100010100111110111000101010001001100100100010101101111111010000101"
    "10001110000001110000000011100011100010110001001000010010010110011101011001"
    "01000110111011010001100110001101001111011101011011100110100001000011010010"
    "00101100111101000011111001010010110100010011001111011010101110110010010110"
    "10111101111111000101011111101100010001011000100101111001001010100010110101"
    "01001110000000110011010011011100011000001001111001011010110001100000111101"
    "11000011100100011101010001111101100110110001110011001011000000110001010100"
    "01111110100101001001001001110100101001010110110111110110100010001111010110"
    "10000011100110000001000101111000101001111010101010000100011001011011101000"
    "10010101000010011000000111011010001000100011010001011110010110101011001000"
    "11000110101011111100100000100001110101100011100001101000110101101100010010"
    "00100110100000000101000101000111000000111010111011110111111001001000001000"
    "11011111000011001101010111011100011110101100011000010011010100111111100001"
    "10100111110100110011001000101001101110101100110110000001010110111110100101"
    "10010100101101101011111000010001011111001100101011000011100110100000010001"
    "11100000000111110110101000101111010100010101110100101110001000011000111011"
    "10111001101101011111010101010010011100100010001001011100110110111110000100"
    "01110101010001010111101000011001000111010111011101101101111111000110001011"
    "10111000110101011100001111000100010000101001010101001000111100000110110101"
    "10101111100100101011001100110100000111100011110001100111010000101001000101"
    "01111110011100101001001100110111011010111110001101010101011101110111001000"
    "11011010111101111110010000000100101101001111011111010011100001001010000101"
    "01001010010111001011010111110010110100000111001100101101111100001011000101"
    "10001101101111101110110010011111011100000011010011100001001100110000000110"
    "11001111010011010011100001110100101010000010100010001010010110010100101010"
    "01110111000111001011010000010010000100010001001101001110001001000000011011"
    "01001110101100100100110101101010110110000000010010111000010100111000000001"
    "10011000101000011111010000111110111111010011110101011100110001001000101000"
    "10110100000011000100000100101010011100001011101111011000110001011000110011"
    "00011011001000110001011100101000100001011010000110000000111000110101111100"
    "01100110001110010101010011100100001001110001101101101000111101011100100011"
    "01111011001000101111011010011111010111000001011000111110101001000111000110"
    "11000111100111010000000101101011111010000000100101010101111010100100100010"
    "00101101010101110010010101100100010010011010110010111010010101111011110110"
    "00111111101011011101011101001110110011111100000101110010101111001101011100"
    "00010100011000110010001010111100010010111110110001011001010011010001000001"
    "01100001100010100101110100001100101101101011001100001111110111001000101011"
    "00111100010011111011110000000100010110001010001101101010001000100111001001"
    "00111111000001000011000110100101110101001010000100100101110100000000101110"
    "10001111101001011110110110011011100010001000101001000000010001000110011101"
    "10001111010111010110100110100011110001001101011001010010100101111110001110"
    "10100010000101011111000011100101011110011101011010100001000010101100000010"
    "01010111001110101010111001010010011110010111100100001010100111000101101101"
    "01111110010010111110110001100010101100000101000110000011110001000111101100"
    "11110110110111000000111000110010001110010110011101010010000010000001001111"
    "11001100101111110001100100010001010111110111011011111100010000111110010000"
    "01011000110110010110100011001110100100011111011110110000110011001100110001"
    "11010010001100100011101010010010101000111100110101010111000101100111110011"
    "00000100101111011100000000111010111100010010101010001101011011010010000001"
    "10110010111100101100110101000001010111010101011010001100101100100011010001"
    "10110111101100111111111111010000000011000111111001011010010010011000001100"
    "10110001100111000010011011110011101110000111011000110110100111000000111111"
    "10101110001100101111100000101010100100101111001010011110010100110101110000"
    "00100010100110100000110111101011110010000101111100111100001110111010000000"
    "10011000101000001101110110111111011111111000110110110010000100111100110011"
    "10101100011010001001110010010001100011100111011000011011110011010011111000"
    "00011100011110101101011000001100100100001001100000000111001100110011110110"
    "11001001100101001101011000110101001011010010011010101101111110010000011001"
    "01101110101101010110001000100011000111011011001011011011100011110010101110"
    "11110000011011100010111010010011010101110000010011111100011010001111010110"
    "01001110100110000010001100010010000011100010110001001110110110110000001010"
    "10000001111000100011011110111000110001010000110111010000111011111000011100"
    "01101111010111000100110101011110110111001010110001001101000100111001010001"
    "01001111110101100100110101111100101001000000110000011110111101100101111101"
    "00001001100111100011100100011000001111101001000101000001110000110001011001"
    "10011111010011000000100001110001111111001100100001010110111100001000011011"
    "00001101111001110000111100010100001011101011110010011101101111100100111100"
    "00000010011111101101111100110011010110000000000101100010010111101011001011"
    "00111011001111100111000010011010000000011001011100110001011000010110010111"
    "00000110100010100000100001000001111001001101100110111001110011010110000011"
    "11011000111100000110100101110111001001010000110110110110001100011101001100"
    "00111011011001100001010010000011001110110010111110011111111100001001000000"
    "10100000001011101011100101011111111101011110110010111001101001111000010011"
    "01101100001111100101011101010101111010111011110011101100011110100110101010"
    "01110001001101010100110011000011011101110000110010101011111110010010001011"
    "00011111000011000011010011101011001000011101010111000111001000100001101101"
    "00011110000101100111110101100101111000001101000001011101100001010111000011"
    "11110011100010101011010111111001110101010111101000100000011010000010110001"
    "00110101011010011111011111101011001010001010101011000110001110011111100101"
    "11000111110101111000100111101010001110010011000110111110111110011100110111"
    "11010010100110101000101101011101000000111100001000101000100011000011010010"
    "01101100010100111000100000110010110111000100011010000010010001100000100011"
    "10110001101111010111010111001101110110011010010001100001001110111110011100"
    "10101011011111000011010011011011000101110010000010100101110011010000011111"
    "10110111001010010101100001011101110001100100101011001011010111010111010001"
    "11011011010101100111101111110111011111101110111010110011100111111100100111"
    "01101001101000001010011100010110111001101000010011000000000110001110110110"
    "00100101101011001101101111011101100000100001110110010100100100111100111001"
    "11100000101111110100110000111011111100100101101110010111110000000101101010"
    "01011010101011000100111111110101001100011001010110011001110001011000011111"
    "10101110101101011110001101101101111011100010101011001110101011100001111001"
    "00011111111011011101100000010111000111001001100110001000011110011110001000"
    "00100110100000011001110110011100000011010010111010111110100100101001011011"
    "00110111011110101011011100000100001000110011000011011011101001111010000111"
    "00000111011100111000110101000111010011111110110011100001111101001000010010"
    "11101011111111000110101001001000101000010001010000011001010100100100011010"
    "11101111110101101001110101101010001101101001110101000000010001000111011101"
    "11010001000001000101110011001111001101101110001011000100101101010111100001"
    "11100111010111001000100011010000010100101111110000001100110100100100010100"
    "00001000101011101110111100010000001001100000010010111010101110011101101100"
    "11100100111000011011110011001011101100110100001000101000100100100101011111"
    "11000011110000000111011110000111000100111011010100010111010111000001010111"
    "00011010110011110011011110110010010001011011001010111001000111011100010100"
    "00100110010111101010100101000010010100101101100010101001110011010000100011"
    "01110000001001011011110101101011011110011111010101101101000111100101110001"
    "01010010011100101111100110101011001110111001110011001110011110000001100100"
    "11111011101111000001111001011011110111110000110100100010010000000010010110"
    "01110010111100110010100001010010000111111100000110001111111000101010010011"
    "01111000110100110101010111110001111010101101001100000001110110101110101011"
    "10001101100001100010010000010011011101011011010111001111101110101110010111"
    "10111011000000010110010000001111010010010010110001000110111011110001000111"
    "00010101100101110111001101010110000001110100000011001101001110000111111111"
    "11000100000010001100100100101000011000010010100001101111110101000110100100"
    "00100101011001001000101001001101111100011101011011001111011011011110001100"
    "01101010001100001000001001000010010100010101011110100001111000010001000110"
    "10011100100011001001001011000101000110110001110100101100010001000010101000"
    "00100110010101101000010010000110100000000010101111011011011101001101111010"
    "01000101101011011111011110110010011110111000110000011101001100110110110110"
    "11101001110010010010011010111011101100010100001011010000110101101111110110"
    "11100000011110111111000100001110011100011100100001100011110000101011001100"
    "11101100100001110000010110001011110110111100101110001001011000010101101001"
    "01000000000010110101100100011001101000001001000111001001110011111110100110"
    "10001111001011000100000101110110101001101111100100101000011010011010011111"
    "01101001010011110101001111000110101110110101011000100100000000101001111000"
    "01111111100101111001011100010010010110001111001001000100110000011011110010"
    "10111100011001110010111001001001000000100100110001000000110101010000000100"
    "10001111001100010000011101010101000010010111100011110011000000011111011000"
    "11010000000111010011100111010011100100010011101101011000001010100110110111"
    "01011100111011100001011001001111000010111001011111100101000110000101111111"
    "11101100000010011100110010001111100101011001001101000110001111111001101000"
    "00000010010111101101000011100110111100010110100110011111100000000111000000"
    "00010000111010111101111010010000010000110101010010000000111110101001001010"
    "10100000110011011011101011001100001000111101011111001001100111010001011000"
    "01000010111101100100000100101100000100101110011011101101000000000001000010"
    "00010110111010101111100000100111100000110010010110000011110111101000100011"
    "10110101101101011010101101010110000011110101011010100111110110100111011010"
    "01100110111110011100011001101100010000011110110110111100010000111010100111"
    "11011011011001011010111110111000110010100111110111111111101100011100010111"
    "00000011110011001000111101101011100000011111011011110111000110011111111111"
    "01100111001000000110110001111100011010000111000010110010100100010000000001"
    "10010000000011110011111111000010000111010100101000110001011001110001001111"
    "11001101011101010111111001111101011010000101101110110001000000100101010000"
    "10111010011010011100001101101111100110011100001100000010011000010001101000"
    "01000111000010110011110011001000110100111100110111111010111110111101001010"
    "01111100100101100101000010000011011110000000101000010011110010111011010111"
    "10011111010011011101011100011111010010100111001101101100110011000101111001"
    "11101111001100100000011110001011111111000100110001110010100001111100101010"
    "01110010010111000111001010010101100100010001000001001111000010001010000001"
    "00100001110010100000110000110001010011001101000011011101101001000110010110"
    "10000011011000110111001110010100000000001010011001001111110000001010110100"
    "11000010001000110001000101110010000110001010010001100111111110001111001011"
    "00101110110010011100000010010111110001110111000000111011101000100010001100"
    "11000011111000111111001111111101011010100110001101000001100001101000000001"
    "11011101011111111101001011011011001110000101011011110111010001010011011011"
    "10110101110000110110011100010001101111000010110101000100101000111111011110"
    "10011001000011011110101110000011001111010110111001001101110011100101100111"
    "01111000111110011011111011110100110111000110101101100000101000001100110000"
    "00001010000110011111010110111111101101100000000010110000001000010111010001"
    "10000010011000001100010111001001101101111101000000001011110111011011100110"
    "10000011010000110010011000011001001011111110001101000101010001011010110011"
    "11011000110010101101101011011000100100101110110010111001001110110101111111"
    "00110110001000110110010000101101001100000100101101001111010000110110010000"
    "10100000111101111101110001110000101010110111000011001000100101011110101011"
    "00010000100000111101100010101001101011010000101001111010110011111100110000"
    "00100100011100001000110000101010101111011110101001100100100010010100000010"
    "01011011011000110101001101010111100000100110010111010010001110001110001101"
    "10110010011000001000000100111001101000111010011011000010000000010000101101"
    "01101000010110100000101010110011110011111110001101010000011000111001100010"
    "11001000011010000010101111110011010010010110100100011110101111100101011100"
    "01100100100110011010111101101100011011011000011110100111001101110000001000"
    "00110000100101110110110011111110101111101010101100111100110010111111010101"
    "00010111011110111110011111111011011100000111011010101111000100011110000011"
    "10111000001110111001101001001110011101001100010110011110110011001001111111"
    "10100101011110100101100101010100110010110010001001010101001110100101110000"
    "01011101011101111001100011011111100110111010101101100101001010000000011110"
    "11100010000010110101110000101110010000110000011110111101110000010001110101"
    "10111111010111111101011000100010001101100100101010101111101010011100011100"
    "01001000011111001000110101011110010001101111111101111001110001101101101101"
    "00100000000001001111110100011100111101110001000011010110001101101100101000"
    "00100011101010011110111111111101011100100110100000101010101001111000101011"
    "11100000011001100111010001010101110000010001011110100100100010101000101011"
    "00010101101101000010010100110010110001101001100100010001011001100000111000"
    "10100011100111111111010000010110110000100001101011100000111101101100001111"
    "00001100101010001101011011000001111101001110110111011111101110011110110010"
    "00000011100011110001011100000010011111000101110110011110110001010100011101"
    "01010110001000000001011110111100100111111000000000100110010111000011001110"
    "01011011100110001100100111101110111010110101000010011001011100011000010100"
    "00110100000110001111000110010000110111011101100111001101111110111110000111"
    "01101111111101110101000101011100000111010001001001000111010001110110000001"
    "00001010001001110111111011010011101011010001010000011001100010011100100001"
    "00110000011011011111000111110100010100111101101101111001001011010001000011"
    "11111011111010011001001010010010000010001000110000100010101100110010010110"
    "10100110101010010110110111111110001110100010011101100101001110110101110000"
    "10011001010010011101011001011100100001111101011001001011011100101111001001"
    "11110101010011000100010111110001010010011001100111010110001101110101010101"
    "11010001000111111111010111111111000111101001001001010001100010110101001010"
    "11010101101100011100000001111010000111110001001011110001000101010111100001"
    "10110101000110111110010000100011010001101100101101100110010000100000111101"
    "01111101111000111001001010000100110001010011011110111100101001101101011001"
    "00001001110100111111110101000000111111001001011011100010100011010010100010"
    "10001001100001011000100000010000011010111011100010100101111101101100111101"
    "11000110111001010010011110101111100000000011000011101011000111001000001001"
    "01110000111111110000100000000101111110010001010100000000001010101011110011"
    "01100100100110110011000110101011100001010010001110100001111111110010111011"
    "00100101000000111100100100111001000111101111001011001111101111010110000101"
    "01101011000101100010101100101010001101100100001111111000100011101111000101"
    "00000110111101000111000100010111010101100010000111101110010000011011001101"
    "01110010011011001001111111001010110001011000000100100001100101110110100100"
    "11000100110000010011010111000100110111110101011000000100010101100101001110"
    "00001010110101000000011101000000001101011000010110010100100110111101100010"
    "00110110100110011101000000000011001010111110101001101100010110001111101100"
    "01110011111111000100110101110110001010111000100011010111110011111010100001"
    "01001110100001011111101011111110111011101010101101011111011010101010011111"
    "11001100010111110110010001101110100100110111101101111111000110000001101010"
    "00101101001010110101111101101000001100101110001011011011101000100101100101"
    "01001001100100011011111110001100001101011001001100110001101011111111001110"
    "01101000000110000110101111010001011100010010101010010110111110000101111100"
    "01111011111011001111001000001100000111100011010110000011100100001111000101"
    "00001101100011010111000101011010001011000100001010100001000100111001111100"
    "01011001101110011000010011110000100010111000100010101110111110010011111001"
    "10000111011001101010101000001011001111101001100111000100100110110100101101"
    "11010110010101111111001100001100100110100110101011010011000010001111000010"
    "00101000111010100101001100101100000011010111010011110100111110110110011011"
    "10100001000100111110001100011100110001010110000110011110000010000000100001"
    "11101001001101010001010100001110001101111110101110001111101111010000111100"
    "10111000111000100110011100010101001110001100011101010010010000010111110001"
    "01001111100100111111110110100110011010011000110011011101110010001001100001"
    "11010101101011010100101010101110100111111001010110110100110100001111010001"
    "10001100010110101101110111000101000011011101000100111001001001010100001011"
    "00011010111111101100011010010101100000101110100110010111111011001000100110"
    "1111100101000001011001101011110";

static const char *poly_140 =
    "10001000001100100100100011010001111000010001000011111010000011111001100001"
    "11101111100110100001110110101001011000101110010000010100001000101000100010"
    "11111110011100011111000010100111011100001111010101101100111110111111110000"
    "00100000110010111000010111000111011111010101011001111001010111011000101101"
    "11001001011111111010000110000110001000101011100011010101000010100000000001"
    "11110100101000110000100011101001000001111111101000001111101111000001010101"
    "01011000111110010110001000100110101001001100111000011111000101000111100110"
    "01011001101110111101110001110011011100010010001110011100011100111010010010"
    "01111001101010100000100010111010111000000010111000101100110101101111111010"
    "00000100110011110111011010001001011111101111111111000110010101110100100101"
    "00001111110110001010001011000011001011111000010011010001111111010111001001"
    "11100011101100101000001000111100001001101111111011001011011001001001101111"
    "00111111110100101010110011111110110111011111000011100010011000100001110010"
    "11101101000100111110110111010111110110100010011111110011001000000111000111"
    "01010000110100111010011101110110011110010111010101100010110000010000110100"
    "10001111010111100001011111111111111011010001010100100011011110010001000011"
    "00101111100001111011001000000110100110010011100011110011100100001101111111"
    "01100110110011001101000110111000100010111000100110000011000010101011101001"
    "00101101110100100111110001011101101011100110010000111001100010001010000011"
    "11111111011010100010111000000110111110010011010000100001100011000001000100"
    "00101000010110101001101010111100110000110111100011001010101100011111011110"
    "10101100001101100111000100101000001101001011101111100100110001110111100011"
    "10111010111101000000001111100000111111010110001001101101100010011011011000"
    "01111000001111010101010110011000100000010000100111110011111011011000010110"
    "00100011101110010110011000101110110001100001100010011100011000010010101100"
    "11000011111111011010100011011100101110111100000001101110001111110000000101"
    "10000100010000010001100010111100001110000011010111101111010010011111100110"
    "11011000000100001100100101111110011000000000100100001010100000011100011111"
    "00110100111111010100101100011000100111111001110101111000010100011110010111"
    "10101011101101000101110011000000101011100000010111110010111100101001111010"
    "00001110000011010010101111111101100110010111011100110111001011101001000110"
    "01100000111101000111001001111101101111011001100011111110111011001011101001"
    "00110110010000011110110100111001101001011011110100000011111101100100111110"
    "01011011001101000000010010101101011011010110011010001100110101111010100010"
    "11011100111101001000100010010101010101000110111110001011101110000101010111"
    "01001101101010100101100111111001110011000010010110101000001101100111111001"
    "11010111110100001111100000111000101011000011100000011010010000110011101010"
    "01110111101111000101100101101111100100111111010010011111110110000101001110"
    "01001001001101111101110010000001001011001100000001110010110000001011001101"
    "01111011001111001010010110000111010100010101001101101101101010111000101000"
    "10000111101000111101111101100010110010001000100001101010100010010010010001"
    "00100101111111011110111000010100100010001110001100010110101011100000010110"
    "01100110101100010010110110001100010000111111011001110000110111111111111000"
    "01111001111100011110111110100110011000110010001011011000001011001101010111"
    "10010100100011001001100101011110000110010010011111011001110111000111111010"
    "11110110000010001000110100011111010110011111001000100111110001101000011011"
    "01001001100001010100100011110001010000000010110001000101111110011010111010"
    "10101000010000111000101101101101001011100011000111101000100000000110011001"
    "00010100000101101011110101111111111010010010011100100001010100110001001100"
    "00111001101010101100011000101111111010010100111010011000000010010100101000"
    "10011000010010001111001111011011001001011001110110101100101011111111001000"
    "11110101010010101011001011000010101101011011111010010001111110100000101001"
    "10000011110100000001110110011011000101011000011010000001010110000010010101"
    "11011110100101000000110101001000000010001011011010001000111101000011100000"
    "01000110001100111111000101110001101111100001000100101000001111110011010011"
    "01010110100101000110111010110100111010101010110100010010110101001001010010"
    "10011000010110010001111101010000100101000110011010011000101110000111010110"
    "00000101001011100111101010010110101101100101001110000101100000001000000100"
    "01111110001001100101110111110000110000010110001000011001100010101110110110"
    "01010000110110000110000011010001100111101000010110111100101010010010010110"
    "11100111101111010000010010101010011011110111100110010100100110111001001001"
    "10101000100100011000110011011110100010010010110000110010111010010111000101"
    "10110010001100110110011100000001100101001100110111100100110000010001110010"
    "00001101011010010101100100101001100010101010010010000000101110100010110110"
    "01100010110000110110101011011011111011000011101111100111011001001011100111"
    "00110001000001100111011111011101111110000011011011001111110001111110111000"
    "00110100011110011000100100011011001110010111010110011100011101000001101111"
    "01100000011010100010110011001000011001010110111110011011011010000000111011"
    "00110101101110010010000001001010000000000111010001001111110101100111111110"
    "10000110100010001111101110101100010101100010001010101111001110011011000110"
    "11110010111001111100010010011111101110110111101101000010110101101101010010"
    "00100011100101101011011110000010000111010101100000110110001100000110010010"
    "11010010010001000110001011101000001001001111001001100011101010001000111110"
    "01001110100100101111110110001101001010111010000010001011101001010111010100"
    "11010110111010100001110100001001110110010101101110010101001010010110101100"
    "01010111001111010100010000011111000001111111010110000110110011010110110111"
    "01010101111001100001100010101010011001011010001111100001101011010111110111"
    "01011001111101110000110110001010010110010111111001011111110001111001010101"
    "01110001111111001001000010011101001101110001100101000011000111000111011100"
    "10100110110010111101000110101101110010011010011000101111101010111100011111"
    "00100110010011100111111010000100010000111011001101001001001000111100001111"
    "10010101011001111101010100100100110001110101110000001111000100011011100011"
    "00100000000111011000110000001101101101101101010001011100010011011110011001"
    "00011100011101110000000010110000010001011100010100101100100100101100001100"
    "00100101111010011101010111110001110000100101001011010001100111001000001111"
    "00100101011101010101001011111110100001111001001001110011011010011110111111"
    "10001001110110001110011010010100010100011001111010101111110100110011101001"
    "01011001011101001110001001000101000111100011101001101100111000011011000011"
    "01111011100011010100110111111101011100111001000110000001001000100010100011"
    "01000011000110010110011110010111101001001001110100001100111000011110101011"
    "10010011010110011000110011000111011100100110110100100000001100111111101110"
    "11001111000001001001010010011011111001111101001000011011010000110100010101"
    "11101001100001100000001101101111111001011010010011111110000101100101100101"
    "00000001000011001100000000001100010100000010111000011100100111111011011000"
    "00011001111011101001110001110000001110110101000101001000111000111101010101"
    "11010101101010011101101011000010100001010010011011110101011001110010111010"
    "11101000110010010010111000010010001011110001101000010000011101101010100010"
    "00011100000010010101100111001011100001001110001101000111011001110000000100"
    "00100000110001110101000110010100010110001111010100000000111111011000110101"
    "10111110000110100100000001000101110001010110111001100111101111111001100001"
    "10100110111001001001101101101001000110011111110100100001010011011000000011"
    "01101011101101010101010110100001000000110001100101111010000011111010100001"
    "01111010001011100110101000101110111001110110000100010101110100000011010101"
    "11101111001000011110011011111001000010100100101010011001010010110101010110"
    "01011000001100111010101100011000011101100111100100100101100110000101011111"
    "00100101100010110100110000011001001110000111100000111010000000011110100000"
    "10101111110111000011001111000110001011010101011111101101001100100011111111"
    "00111011010100011000010101000000110100010101010010001110100010101010001001"
    "01100101101001001001001111110010010001100001111101111101000011111101001011"
    "11100010010001010110110001001001010100000010100011001000110000111001111100"
    "11010110111001000000101011000010110111000110000010100010100100110111010110"
    "01010100100111101001110010100011001110100111110100101000100100110011001101"
    "00110010101000110100000100000111100100100111010000011011101101000000100011"
    "00011111010100011001110110100111010101101000111001000111000110011100100011"
    "01011001111110001101111101010111000011111101011001001000001011101011111101"
    "10111010110101010100101011101110010101010111101110100100000010101001111110"
    "01000011100011100101101000101101011100101100100110001111111101001011011000"
    "00101000111001011100101010010001000000101010000010011100110000111111001000"
    "01001001000101111001010110111100000100110011111111011111101111000001101011"
    "11101101111110111011011110111001100100000011000101100101111111001111010110"
    "00110011111011000101110010001001100000100010001111010110000000111100101000"
    "11100110110101101000111101111001111010101011000010110010011111010000011010"
    "01100111010101001010011101011110010000110000100000001110111110100110100101"
    "10100100100110100110001010111001110110110100011101101010010110100011111010"
    "11111011110011000111110110000100001111000101000101111000111111011001001001"
    "10111011111011110011100110001101100011101100110100111111000001010010110111"
    "00100101101111010100000110110011110010110110010100101100011010000010010011"
    "11011100010000010001010101010101100110100101001100101001000001100111101001"
    "10100010011101000011000111111000111010101011010110010011010000000000011111"
    "01111111010111001000100001011011001100101111111001100000001101110101011010"
    "01011110010111011000010111000010000110010011010000111010101000101000111100"
    "01011100011110100110010011100100000100001010100001001100111000000100010010"
    "10010100001111001100011101101110011010000010001001100100101010111001010010"
    "01101011101011101101100001110001010111010001000111000001100011001101011101"
    "01011010011100001010000110011101101101010010101100110011100101101100111011"
    "01011110110000111010101000011101011110011000000001001010100101111101100100"
    "10101101000010011011011010001000101100100100111000001010011010110111000101"
    "00101110101110011011001010111111100000101001010001001011001010111001110011"
    "01111010101011011100011100111110000010110000101011001011101011101010101110"
    "00011110110110010110011100010100011100100100000010010011101010000111001110"
    "01010000001111100111110010110010010010100111110010010111100011011011100000"
    "11001100110110001010100011001101010000001000100101110100101010001001111110"
    "10011101101101110001000111010100100111011111100110101101000110111111001101"
    "11100111011010000010100110001010100111011101011110110011110101010000110110"
    "10111110101010111111001111001111110010011000011101111001000111010111001101"
    "11000001011001100100011011110001111011011100010000011011000100101010100000"
    "10010100011011101110101110111011011001101001001001101011010001001010101111"
    "00000000110110101001011010011110000111011100111010011011101001011010000101"
    "11110010111110111100111111011010101100000000101100101000110100000111101101"
    "11011101001111010110100111101010001111111001011011111011111000110011010100"
    "00000001011000000011100011100001010110110101001111100101010001000000011100"
    "11111111100000001011000001110000100000111100000001101101110000011001100110"
    "00000011101110110111101100101111000110110001000110000011001100111100000100"
    "10001001001100010010000010111100100111110001000111111010011010000010101000"
    "10000111111000110101011001011110110010001100010001110100011110110101101111"
    "11100101000101101010100000011111010111110001110000101101111100111100011110"
    "10010000101101011000101010110011111100000000110001110011001001101011000010"
    "00001110101111000100011100101110000110111110100010011111011001000010111111"
    "11101111011110110100111011110001011011110001011110001010110110101001001011"
    "00010100010000001111101110010011100111001011101100001110101011111011110011"
    "00010001000111001001011011001100110111000110000111010010010001001100011111"
    "11111110100001011111001111011101111001011110001100111101001001010011001110"
    "00111010101100001001011000011001010101001101010001000011110101101000000100"
    "01111011110000011001001101101111110011111001010111110010000011110100010111"
    "11110110111101011001101001001101000110010000011110000000100100011010010101"
    "11100001110011110000111100101111011100001000100111100010101001101011100001"
    "10010000100011111000111000111010000111100000000110110010010010101111000010"
    "10011001111100010111111111010110110001010010001011100001110000100111010111"
    "11100111011110000111100111011111100000101110110000001001100101001111100000"
    "00101100111100100010110110000001100100010101110010011010011011111001001011"
    "11101001101111000010010000110000011001111011000100101010000001000001010010"
    "00000101010100011000111100100101110101010000010101011001011100100110011100"
    "11101010001101110110111110011110100111010001100010101000101101000111001101"
    "01101000010110011110011010100001100111100001000100111100101001010010011001"
    "01010101110000101011100011101101111001110110100100111110010111101011100100"
    "00010000111001110100101001100011000001111001110011001101100011010010100101"
    "10001100110101111010010111011111101110111110100011010011110001111100010110"
    "10111100110100010010011010000011011110101000101000101011111010000111110101"
    "11000101000111110000100101011011101010001010000011001101111111011100101011"
    "10010110010000011001000111001101010111100010010011111101111011110111010111"
    "11000111001110110000111010001110001110000111110100100111010111011001100010"
    "11111011100101011000101111001001100111001110101111001001110000100001111010"
    "11100001011101011110100010111101110011001101001011000010010110110000101001"
    "01111111001111100100111101111101000010100010001100101111000010001001011011"
    "10010001011011110010111000110011101001111110010100011101100111011111100111"
    "10101001010110101110001011111010100000110101010000100011000111101111010011"
    "11001001000011001111111100111100101011100100011111111000011101111101110001"
    "11011101011011001010111011110110011011001100011011101101110010110000111010"
    "11110111111101010100100111111100100001101010110110000101000001111001000011"
    "01010101111011000110110000001010011001011001010000001001010101111111001100"
    "01011000000011011111101100100111000101010011110110110011011000011100110001"
    "00011000001011110000101110111010000110001100011010110000100000101101110010"
    "11000001011111010111111011011010000110101001010101011100000011010101001101"
    "10010101100011101110110110100101001101011101001111111100001111101111111111"
    "01101001111010111100011111101000110111101000100101000011101010000110111111"
    "11100101010011011111110001110000011101001011110110100011111001011001000100"
    "11101111011111111001111011001110000011011100011100000010101111111010001110"
    "01101101100010100010110000010111011010001000000000010011010111101001100101"
    "11100001001100101001110010111101111110110000011001010001100101100011101011"
    "01000100101111001000000110010010001101011001100101101000011100000011101001"
    "10111111111011011011110010110010101001000101011111011110111010000010111010"
    "11000111101010101101111000011011100001001010010011101100100111101100110110"
    "10011001001001100001011100000010000000101110101010100011100101110001101001"
    "11101101101100001101110110110110111110101011101110001111111100000110001010"
    "11000111010000000111011010001111111101011011111001100101010001110001000011"
    "00001111100000111101100110101001000101010011001110000000101100010000010100"
    "11011101100111101101110011100011110000000100101111101001010000110101101011"
    "01111111110000010111000101001000101001000100000011101001101101111011000000"
    "01111101111001010111000111100100100001001000001101101000000111001000111101"
    "11001011001101000101011011010011010011100110101101001100010111010110001001"
    "11110111111100101000010010011010100111000100010110000100101001001101111000"
    "01010110100101000000001110001000111010110010111001111010101011100010000110"
    "01111000000011111100001111110101010110001001010110000011001100100001011010"
    "11101010100000001010000000010100110000111000101001000000010100010110001101"
    "11000100110001101011110110100000010000100001011001111111100011011101011111"
    "00101110111110111000011000100100000000100110001010100010111000100011100010"
    "11000001100111010010100000011001001100101001011110011100011001111110001001"
    "10100110011111111010011010001000010101111111110110101010101000000001001001"
    "00010001001100010000110000001010001001011000101101010111111001011000111001"
    "01010100101001110010111110110110101101001111000110101111011000100100100101"
    "00111010101111001111000000111101010001000111101001100110111011000101000101"
    "00011100011111011001001011110000011011101010011110110001110000100000111100"
    "10000010000101000111111111110110011110011101100011110111001010011000010100"
    "11110010110010001010001011110001100010101100100111101000100001110010100101"
    "10000000111111111101100001111100010111101011000001000110011011100111101000"
    "11001100011110111010110101001101100011001111010001010010100100101111100001"
    "11010100111000000000111111111000100101111101110001000000101001011011100110"
    "01010001001010011101010011011110110001001100011100101001000011101100100000"
    "11011001111011011000110010101010111011100000111110111101001110101010010101"
    "00011010101001001110010111110111110110011001111100100100011011010011011011"
    "11000000000111100010000100100101110010100001010111001100100111011110101011"
    "10011000010101000101101011111110111100011101010000011100101000010101110010"
    "10011011011100001011010100000011000101100100001100100110011011101110000100"
    "11000000010011010011110010100000000111001111100010111110111111011101010001"
    "01101101110011010100000101100000000111101010011101011011110010010010001010"
    "00100111111101011001011111100101110011011101110001001010111011111010111010"
    "00000001000000001100001000101010000101010001010110010110110101000100100110"
    "11001110001010000111010100001001001101000001000110000001111000110000010010"
    "11000011101001001000001100011100110111110010101100101100010011101100000001"
    "10100010110100101101110001110110111100111011011010011111010101001001100100"
    "01110101000010101011111101101100101101101111101000111001110101101100001001"
    "10001111110111101000101011011111110000010010010001001110100100101000100011"
    "10001110001111000011000011001101000011101011010011011011011110101101000111"
    "11101101011010100011101011001101110001001111011101111111011000100010001001"
    "11011111010010001011011000000000110011110010111101000001011110000100110111"
    "01010110000010110100111101110011100010011001000101101100010101111011101100"
    "00111110100100100110011110001110000100010111111110110011000010111101101011"
    "00001000011111100000011111110111001010011000011001110101011010000110100100"
    "00101100011100001101100101000011110110001100000011000100101001000111001110"
    "11100101110001011000101001001110110001110001001010011011000001001111110001"
    "10011101000110000011011110001001001110001011110110111111101111101000001000"
    "00001111101000001100111111000100101001011110101110101101001110101010110111"
    "11011100101010111100111110000110100001000010111110110010111010110111011001"
    "10111101100100110001000100101000101010011111001001011010000010011100011111"
    "00001001111110101110110111001011011110100101001100010101000101001100011101"
    "00100100110100100101101101111010011111100111000011110000010011110001100001"
    "00011010111101000111101110010110110010001100010110001000011001010110011001"
    "10101000000010110001001101101110111010111001101101001110111111101110011111"
    "11001111110001000100111110111110010101000001011010001011010100011011111110"
    "11010000110011001111101110110101101110111000000111111011000011010001101111"
    "01011010001001100101100110100011001110001000101110011000101010010011001000"
    "01110000110100100110100011111010100100001010011101000010110011110001011000"
    "01010000010010011001001111010110001101110110111100101001001000010100111001"
    "01100001111110010010001110110011001101111000010010101011010101000011110001"
    "00110101010100100111111101101110001001111011000101111111111010000010100001"
    "10100101100101111101110010101000100010001010011101001111000010101001000101"
    "01110100011001110011000110111000011110111001111100000100000110001000101011"
    "10011010011011111010100110101010101110010110101111110100001101010000111110"
    "10111000100101011100010011010101101000010111110100010100001111110100010001"
    "1111100110010011000000010101111";

static const char *poly_144 =
    "00000101111101111100100111111010111001001010001011111010000011000101101000"
    "11010101101000011001110001111001010100100101101111101100001111011000111011"
    "00110100101001010110010111010111110101111011010101000111010111010110011000"
    "11111010010001100110011010110000000100110100000110110110011101100001000111"
    "01101100000011100111000111100110011110111100001111111011011100001110000010"
    "01001010101100000001010000010100001110101001000111101000111110100100100100"
    "00111011110110010001110001100110011010101111000111011111101110010100111101"
    "10010111110111110010011001100010101011100001011010100000010000010011101111"
    "01110010111010000100011001010001011111011110001011000001010100100101000100"
    "10111001011100111011110010011100011111000010001011110110111001001101111010"
    "10011000000100100000010110011011100111001001101100100111010111110111001111"
    "11000001000101100101001100001010010000001110001001010010000000110111011101"
    "10000101011000100010011001111110100010111111111011000111111011100010100010"
    "11110100101100111010110001000001010110100010001011110001001010100000100001"
    "11111001101011111011001011011111000101101010110011000010100001001001111101"
    "00000101010111101011111101000110100110001111100010100101111000001010100010"
    "10011000101000001011101011010011011101011100010001011001101001101001001101"
    "00111010101110010100000011001010010111101101010110010101011000011010001110"
    "11011000111100101100001011100101001011010000101100110001111000011010101111"
    "11010110100100000000100100000001001000000010111101001011101011000111100010"
    "00010001111011100000010111101111110110100011000011100011110001100001110000"
    "01011000001110101101000100110101011110111010011101011001111111011110000100"
    "11011100000010010110011010000110100010000110110001101111010010001000001011"
    "11101110001011010110000000110000111000101010100110011111000111111100111111"
    "10010110110110110000100110110011001110001010111110110100111100000111100010"
    "00111111010010000000001000101110011001111101110100001000101011011011010011"
    "01000100111001001110100000111001000010110110100110111111000001101111010011"
    "10010011000111110101100100011111011101010100011101100101111010111001001011"
    "10101101011111001011110000010000101110011101111000010000100011100111101111"
    "11010011010111001010000011110111100000011000110011001000110100001011100010"
    "00010001110001010000110011110000110001100100101010011101010010101101101100"
    "11100100100000000000110001011111000111000111010011100011110000101011000110"
    "00100110111011011011111111101111000100000001011100101011010101111111101001"
    "10110111000110101001001001100000111110010010111000010000010001000001100111"
    "00011001001101010011110111101000011011111011101000000110011111100101001100"
    "10111000011110000110001110111001111011110000110111110100011010001100011011"
    "00010110011001010100101100101111000100100011100001010000110001011000110011"
    "01000000000101110010111001010010000010000110100001000010011011000011001000"
    "10100001000111000000001101010010001111000001101000110000100000011110110101"
    "10011010100011100101110100111000101011110010011011010100001001111110010000"
    "01111010100101001111011001110101111001000011110100101110000101101001000011"
    "10001011101011110010110111000100111010001110001011010001101010010111000000"
    "10010000110101111111111111010101111100100100011110111100001101000100110100"
    "10101100110111011001011111011111001110110000011111011111111111010001000100"
    "11100110100111111100011101111011011110010100011010000010100010000101000010"
    "10100011000101010110010110100111011011101100000111011011001101010001001110"
    "00011000101010011011010111111011011010001101100011110000110001000111100001"
    "11111010001011101111000011001010011100001100001101000110000001110000011101"
    "00110111001010000011110000100110010001101100101110000101100001010000101001"
    "11000110010010011010010011011111010010010110111101010111111001000010101101"
    "01010001011010101010001000011111010100001000110100111101001110101101010000"
    "11101010101101110001101011011110011000011000100000101011001000110100001000"
    "10100110101110100111000111000111110110100100101001001101010001100011010001"
    "01010101110111101110000111101100011011111111110101001011111011101001110100"
    "11101010000000100111111100010111100000101001111101110011101010110000111100"
    "01100001011011110011110010111000010010110100110011111101111110111000101000"
    "01010000011011111111001101100110101110110011000110010101101100011001111101"
    "11011111010000011010000111011101011000010011101011010001011111011100010001"
    "00111000001011101001101100101111011010101011010111110100011111011010100101"
    "00000101000111111101101100100001011000010000010101110011001100000011110100"
    "01010100011011111000010011000010011010101001010000101100010110000100000110"
    "10100100101000011000110000011000001000011101011110010000010101010001001101"
    "00001111001101001000000001101011111111101010101110101101101101100011110111"
    "10010100010000110001101110110000011010110010001110011010110001111110110001"
    "01000011101011111000001011110111111011110000000000010001011001010111000101"
    "10100011111111000110011110100010101000101001011101000010101011110000010111"
    "10001000110000011001100101110000001110000101011011011100101011001000101000"
    "01011111111000101111100100010111001011101100011111110000111110111010001100"
    "00110010111111011010100100111100110110111111100110001011001011101010101101"
    "10001110111110100110111011010000111110000101111101111001000000111111011100"
    "01100000000101010110011101001100101111000100101001111110001001100111110111"
    "01000100100100011001011100011110111001100001001000111110011110101001011001"
    "10010111100011001101100010000010111001100001100110001111010001101101100000"
    "11010101010110111000011110011111111000110011110010101000110111101101010101"
    "10010101010101101000110001111101011010101010111100011010100100000001011000"
    "00101110001001110110100011100010110100000010101011011011110011010011011101"
    "11100101100110010001110101110010011000010010000101101000001100101011001011"
    "11001110110110010001011010010110010011101010101001010000110010001110011111"
    "11000101010011100100001010010010110110100110100100101001000100100001101011"
    "11011000110010111000001101001011100011111011001100111010100110010110101100"
    "11111001101111101101111001010000001100110010101100111000100011111001001000"
    "00011000000011100011110001111111111011101110110101000101000000111100001010"
    "11000111001101100011000011001000001001101111000110110010101011010101010110"
    "10110001110001011011100101001100001111011110010100110000100110101111000110"
    "00010101101111000100001101011000100101011110111111001101010110100011001110"
    "10000011111110001000011100000011011000011111110010111011100001000011010111"
    "10111100100010101000100000110101101100100000001111101010110101111001111100"
    "00110001011011101010101000101100011010110011100000000010110111011011000010"
    "10010110010111010011010100001001000110010011010010011101111101101100100101"
    "10001110000110110101010101001100100010010010111110100011111010111001000001"
    "10111101010111001100101010100100010000100010100110110100001001101010101001"
    "11111001010000010111011010011001000100011010001001011101110000110000100010"
    "00001011111000110001111011001010000111110011101110001001101010111011101110"
    "00010101110011110100001011001011101011100010011000101000000011110011001000"
    "00001011111110110101111111100111100010111100001110101001001010001101000101"
    "11111000010010010011001100001011110100100010111100000010101110001000011100"
    "10000110110101011001100100011101100001010110100111001111110110100000001011"
    "01111000001100101101011001110010010011011000111100000100111000010101000110"
    "01110001100110111000000111101111011110110001101100101100100011010100000101"
    "01010111011010001100101000100110110110110111100111001000001011100111100001"
    "01101111000100101010010100011010110010101100110100011001100110000100000000"
    "11110101111011100111010110111001100010101110001111110110111111100000000001"
    "10111000100011011111010110001110100000011110000001100110100011101110110110"
    "11001101000110011100000110001101001110001001010101010111001100101001001100"
    "10010000101010100001011000011001010001111011011111101101110011110011101110"
    "10101011011110000011011111100001001001111101100011011011110000101111101110"
    "01110011000110001000001111100000000011111110110101110010000101111110010001"
    "01001111011010110111010111011000000011101100111001100001100111001000110001"
    "01100111011110101010001010100100101101110101101000011001100111011100011111"
    "10011001000110110010001011000011101101101101110100001001011111000101010101"
    "01101010101010001100011010111001001110011110101110111111101110011000100000"
    "01111101111011010010010101011011111001001000000001110111010010100011000001"
    "10110100111101101100010000110011011010001110111001000011010011101010001011"
    "00011101101000001111000000111101111111011011111010001110111111000100101111"
    "01000110000010111010110111110000100111111110010011101011010001100100011111"
    "10010010010001101010101010000010001001001110101000010100011111001001101011"
    "00001101101111101010110100001101100000100010110001001100001011111011001010"
    "01000000011101000001100000000100000000100111011000001011011101011000100101"
    "01011110110111000110111111001010000000010110111011110111010000111110001001"
    "10101001100011111101101100010000100101100010011100111101100111000111011000"
    "10011110010011100111010101010110001101000101100011110110100010110000001111"
    "11001000111110010101011101110110110011110111101101011100010000011000000100"
    "11001011010000110101000101111011001110010111101100001110011110010111100100"
    "00110101110111101010000101010101001110001111001101001001111010011001001000"
    "11000110111110101110101100000000111010101000011110010001111101110111010001"
    "01100010000101111111110000011111011000010011100000100011011011101011010110"
    "00001100010010010010110011000111110000011110100101000001110000000101011100"
    "01111111011011010000110000000101000000101000100100001100011010111010111111"
    "00110101111001001011010100101100000110110001010010010010100010111011101000"
    "11010010001100011110100100110000000100011010011111111111001000100010110011"
    "10111000011011000011010100001101111110000111100010101101001111001110101110"
    "10011110110110000001011011100111011001110010101100010001110001111010011101"
    "01100110001110111000000101010100010100110001101100001111001111011001010010"
    "00011011100010001010110011101100101110011110000000101001101001000011111111"
    "01010111101100011011101001110000011000111110110010110010100100000010110111"
    "00110111110100101010110000010111000000110010100001101010010110010001110000"
    "10100100110100101001000001010000001110110011110011011110110000000111000100"
    "11101101010000011000111101100110000000000110000010110000110111000001011110"
    "01111101111110001110011001001000101000001010110000100010111011111011010111"
    "11000001100110000101110100011100111101111011010001101110010010100100111101"
    "00111011100010010111011000100111101111100010001100001010100011110110011100"
    "00010111011001110001000011001100011010011111111110011100101011001100001011"
    "00011001100100100010010011011100111110000000110110010100111011100101000101"
    "10101010010101001100011101101001110111101101100110100001101000000110010001"
    "11011111100000001100001001010011110110001101000100011000111111001000000001"
    "00000010100101111001011010101001100011010011011011010111110001010100001111"
    "10110111111100101000111111001000011000010110110000001011111011011000011001"
    "10001000101101011011111000101100000111110010100101001111110010111001101000"
    "10101110101000001011011000001111100110000011111010100001110111011111010000"
    "01111111111101100010010011111010101001101011110000110110101010011110000111"
    "01000010010001011110101000110111001011111001100000010100001001011101111001"
    "01000110011010100011101000101000010110110001111110011010000110100100010000"
    "11111100100000100100100110100011010000111110101011111111001010001010100100"
    "10100111001011001000101001010111010011111100011010001100000011100100001101"
    "10010111001000000010011001101001001010100101111100011101101110111101101101"
    "11110110111011000111011111010101100011110101101001011000101100000011110011"
    "01011000011010100111011001101110111000101001000011011000101011010010110000"
    "01111000000000111101001010101010110101011011111000000110011011010001101110"
    "00101000110110101011011000101111101010110011010011010001101111100111000000"
    "01001101100101011010001100111010101101000101000110101010111010111001100101"
    "00110111011011111011110101011001001011010000101010101000001101010010000101"
    "01111011100001100101000001111111111110101111010111110110101101101010011100"
    "00101011011011001000110111101010111000011111010110010110000001010111111111"
    "01011010101111011110010000010101001010110111010101100001000100001000010000"
    "10101110111000001011000110111111011111000110100111110011101111001101011110"
    "11011001010111101010010010111111011001001101111010110001101110010111101110"
    "10001001011100111110110111010001101011110001101101010111000011101001000101"
    "01101100000001010101100111100000110010101000011111101011101001001000101101"
    "00000101001100000001100111011010100100010001000101010000000111001100010011"
    "11111011100110110000011101101000101000001001011100101111111000100111101001"
    "01110010110100010100110101100000001111001100101011010110011001110101101100"
    "00010010000001100011111001010000101000101100110011001010011101110000001110"
    "01101110101110111101000100011010000110111011100101111010100100010010000110"
    "01101011111000000000010001001011111111100011100011111100111010101101011000"
    "10011111110100000010011101011001100011110011010000111100010000011110011011"
    "00101101000011001101101100000011000010001010000111111101110111111111010100"
    "01000010110111110110110011001101101111110010000111110011111110011111101011"
    "10100010001000000000010010101010110001011011011100000000111101011110101000"
    "11111101000000111001000111111010100100101100000011101001011100011010011101"
    "01110010101101110010010001011010011101111010100100101100011000111011100010"
    "10110011111001100000110110011000011011001111000111101101100000000001111011"
    "00010111101010011110001010100101101110110010110001000001111000010110110001"
    "10001101100110011000101011100011010010101110100001000100010101101000101000"
    "01111100101110110110001011100011000010001001111001010011111000111110100011"
    "01011110100001111110111111000010001011011101001011001101011111110100011001"
    "01000001101011010101011001101100011110001011001111000110001100110000011011"
    "00001011110000100110000000001010101111010011000001010101100001101100011110"
    "10001011011001100001111110011111001000001110101000010101010001101111111010"
    "11000100011110110010011111011100001000100001000111101001101010101001110110"
    "11000011010001011010000111101010101100101100011100101101010100111100010110"
    "01010111010001111001000100000010100111101011100010010101010000101110110110"
    "00001101010110110010010110100111011010010110101111110011111101101000100000"
    "01011010100010011101010101011111100100110100101110100101101000000110101000"
    "10000111000110001101001001100000000011110000111101010111101100011111100011"
    "10000100111100001001010011000011000101111101100101011001110100000001100011"
    "10010101101110001110110010101101100100101111000011001101000011111100100011"
    "00001010011111110001010000100000011110100010000011101111001000100110111110"
    "01100111101011011110101110011101010001111001101001100011110010000110010101"
    "00001101000001001011000001000001000001010010110011000010111000010100101001"
    "01001011110011011111101111111001111011011100111010111100000111111011010110"
    "10011010001110100000110000000110111011011011001110111010101000110100101111"
    "01100110111000101010111110000011110010000101001010010010011110010100000110"
    "00011000111010000100110101110011011011110000010101100110000011110011011001"
    "10111110101001010110001101010011111110101101010111010101001000110011010110"
    "01101110111101000000101010101011001001101111011101100100101000110111001010"
    "00101000000101000111100100110111110010110000110000000101011111110001101110"
    "10001010100100111010011111111010011011011011001011001001011011101001001010"
    "00010011100110101100110010100010000111101000011101011101101000101011110101"
    "01010001110000110101110001111010001011011000001000111101010100101001110001"
    "10101000001111001101011010111001100110011111100000100101101011001110111011"
    "10100111001111001010011001100000000111001011010110100100010011110110100010"
    "10111001101000001110100101110110011110100110010001111111111101011010100101"
    "01100100101011010100000111001101110000000100010100111000100111001101111100"
    "11111011110001101110110100000110110101010001100000101101001100011000010111"
    "10001100101101101001101111010001011011101001010011010011001101010001001001"
    "10011001101000101010101110011000101011010001111000010111001101101110000100"
    "10010100110000001100010111101101101110010101101100101010111101010110010101"
    "00001110000011010001111011111111011000001001101011000101110011010111101101"
    "10111010101111110100011011100010100101100100011010101111010000010110101111"
    "11110001111010111011100111010010000101010010001111110100000101110010111101"
    "11001011010110101101101011110100001101001110000101100011110110011110001011"
    "00111100011001111000011101101000001000111011110110100000110101001000110000"
    "10111111101100000111110010011111011010100001010100010101111100001011000100"
    "11111100001001010100100010111011110100101111001110000100111010000110100010"
    "10111001110100100101101001110010011111011000011110011101011010101111011110"
    "11001101010100111111111010001110100111111111010001000101011011110010111010"
    "10010000100111111111010101001011011110100010100001011111101110111000001010"
    "10001101000011001010100111000000010101100011100110000101011000001011001100"
    "00010011000010111011011110001010101000001001101011011011101011011010100000"
    "11010010101001110011010100110001111000101000100100111100110000011111011001"
    "10001101010000100001111100001110011101000001011001100100100001101100000001"
    "11000010100110110001110101101001101101001111101111001000110011110111010110"
    "11100001011001100101010111110101111111111010111101011111010101000110010001"
    "01100111001001101000000101000111010001010011101100001000101100001101100000"
    "10100111100111001100111000001010010000110000100100010011001001101000000000"
    "11001010101010000100101000101100001111110001011111010100111000010110000110"
    "00011010101010010000001011000011010000100100111011011010100101100101011011"
    "00101011010001001111110000001110001011111000100010100010111111100111001010"
    "11000000010010101111000100100001000011111111010101110000110100101110111000"
    "10010001101010011011001110111011100110101010000100110010001100000100101011"
    "11011001110001001011001110100100011110011001010110001010111001111010101011"
    "11100100111001001110001101100110111001100111000010111010000111010011110101"
    "11111001101010010110111001100111111000000000111011111101001100110011010000"
    "11100101111001101001001010111100010001101010011110110000101101010010111000"
    "11010001011000011000010111111101000111011011111100001100111100111111000110"
    "01101001011001011110101010101011101101111011000011100011110100011100100101"
    "01110101110000111100001011011100000110100101101010111011110110101111011011"
    "11000010011100010100001100001010011000101000000101100110100100100010010111"
    "01110100110011101101100001011010100101111001100000001110010100111111110000"
    "10110111000100011010101000100001101110000100110101000111001101010110001110"
    "11101110011100110111000101000100010110011011000111111101110100001010101001"
    "10001101001011001101010011000000011010000011100111110110011100000111101010"
    "00101100001110000010110100000011011100100000101000001100011110101011100101"
    "11100111110001001110100000001010100010000001101011101000000001000101001100"
    "00000000110000110000100100000111101010111000110111011011100111110111000001"
    "10011100011001011100111111110111001010100110111101000111001001110101101111"
    "01110110111001000011000101101100000011111111101000010110111011001101000111"
    "00100010101101101000100100011110101011111011001000010001011000111000010101"
    "00101101101111111000011111000101011001111001110011011101101010101110110001"
    "00010000110010111001100110010101110010001100110010111011011011000101111100"
    "10010001111010011100100011001011101101101110000111001001110011101000101100"
    "01111110010011000000111010111110010100001001101110110100000010011001110010"
    "11101100011111101010001001110100010101101110000000100000011111010101111011"
    "01010101011101010110110110011111111100101100100000010011111101111100000111"
    "10010101011011110110000101001110110100100010001000111000001010010100000110"
    "10000101100100010001011111010000100011110010100111011110100000001110101110"
    "01100000011110001001111011010011111110100011011010001011010111001010110011"
    "11001111000000001100011001010000000000011010000010110101000000111100011110"
    "01000100111010000010111010111111010110000100011100000100101001010011100010"
    "0011110011101100000010111001011";
