require('es6-promise/auto');  // polyfill Promise on IE

var PageConfig = require('@quantlab/coreutils').PageConfig;
__webpack_public_path__ = PageConfig.getOption('publicUrl');

// This needs to come after __webpack_public_path__ is set.
require('font-awesome/css/font-awesome.min.css');
// Load the core theming before any other package.
require('@quantlab/theming/style/index.css');

var app = require('@quantlab/application').QuantLab;

function main() {
    var version = PageConfig.getOption('appVersion') || 'unknown';
    var name = PageConfig.getOption('appName') || 'QuantLab';
    var namespace = PageConfig.getOption('appNamespace') || 'quantlab';
    var devMode = PageConfig.getOption('devMode') || 'false';
    var settingsDir = PageConfig.getOption('settingsDir') || '';
    var assetsDir = PageConfig.getOption('assetsDir') || '';

    if (version[0] === 'v') {
        version = version.slice(1);
    }

    // Get the disabled extensions.
    var disabled = [];
    try {
        var option = PageConfig.getOption('disabledExtensions');
        disabled = JSON.parse(option);
    } catch (e) {
        // No-op
    }

    // Handle the registered mime extensions.
    var mimeExtensions = [];
    try {
        if (disabled.indexOf('@quantlab/vega2-extension') === -1) {
            mimeExtensions.push(require('@quantlab/vega2-extension'));
        }
    } catch (e) {
        console.error(e);
    }

    quantlab = new app({
        namespace: namespace,
        name: name,
        version: version,
        devMode: devMode.toLowerCase() === 'true',
        settingsDir: settingsDir,
        assetsDir: assetsDir,
        mimeExtensions: mimeExtensions
    });

    // Handled the registered standard extensions.
    try {
        if (disabled.indexOf('@quantlab/application-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/application-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/apputils-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/apputils-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/calendar-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/calendar-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/chatbox-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/chatbox-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/codemirror-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/codemirror-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/completer-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/completer-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/console-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/console-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/csvviewer-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/csvviewer-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/docmanager-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/docmanager-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/fileeditor-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/fileeditor-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/faq-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/faq-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/filebrowser-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/filebrowser-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/help-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/help-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/imageviewer-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/imageviewer-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/inspector-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/inspector-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/launcher-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/launcher-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/markdownviewer-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/markdownviewer-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/notebook-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/notebook-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/running-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/running-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/services-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/services-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/settingeditor-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/settingeditor-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/shortcuts-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/shortcuts-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/tabmanager-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/tabmanager-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/terminal-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/terminal-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/theme-light-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/theme-light-extension'));
        }
    } catch (e) {
        console.error(e);
    }
    try {
        if (disabled.indexOf('@quantlab/tooltip-extension') === -1) {
            quantlab.registerPluginModule(require('@quantlab/tooltip-extension'));
        }
    } catch (e) {
        console.error(e);
    }

    // Handle the ignored plugins.
    var ignorePlugins = [];
    try {
        var option = PageConfig.getOption('ignorePlugins');
        ignorePlugins = JSON.parse(option);
    } catch (e) {
        // No-op
    }
    quantlab.start({ "ignorePlugins": ignorePlugins });
}

window.onload = main;
