#pragma once

// @generated by aten/src/ATen/gen.py

#include "ATen/CPUTypeDefault.h"
#include "ATen/Context.h"
#include "ATen/CheckGenerator.h"



#ifdef _MSC_VER
#ifdef Type
#undef Type
#endif
#endif

namespace at {

struct CPUDoubleType final : public CPUTypeDefault {
  explicit CPUDoubleType();
  virtual ScalarType scalarType() const override;
  virtual caffe2::TypeMeta typeMeta() const override;
  virtual Backend backend() const override;
  virtual const char * toString() const override;
  virtual size_t elementSizeInBytes() const override;
  virtual TypeID ID() const override;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) override;
  Tensor & _th_set_(Tensor & self, Storage source) const override;
  Tensor & _th_set_(Tensor & self, Storage source, int64_t storage_offset, IntList size, IntList stride) const override;
  Tensor & _th_set_(Tensor & self, const Tensor & source) const override;
  Tensor & _th_set_(Tensor & self) const override;
  Tensor & _th_fill_(Tensor & self, Scalar value) const override;
  Tensor & _th_fill_(Tensor & self, const Tensor & value) const override;
  bool _th_is_set_to(const Tensor & self, const Tensor & tensor) const override;
  Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  Tensor & s__th_masked_fill_(Tensor & self, const Tensor & mask, const Tensor & value) const override;
  Tensor & s__th_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  Tensor & s__th_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const override;
  Tensor s__th_masked_select(const Tensor & self, const Tensor & mask) const override;
  Tensor & _th_nonzero_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_nonzero(const Tensor & self) const override;
  Tensor _th_clone(const Tensor & self) const override;
  Tensor _th_view(const Tensor & self, IntList size) const override;
  Tensor & _th_resize_as_(Tensor & self, const Tensor & the_template) const override;
  Tensor & _th_index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor _th_index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor & _th_index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & _th_take_out(Tensor & result, const Tensor & self, const Tensor & index) const override;
  Tensor _th_take(const Tensor & self, const Tensor & index) const override;
  Tensor & _th_put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  Tensor & _th_index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & _th_index_fill_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & value) const override;
  Tensor & _th_unfold_out(Tensor & result, const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  Tensor _th_unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  Tensor & _th_range_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  Tensor _th_range(Scalar start, Scalar end, Scalar step) const override;
  Tensor & _th_arange_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  Tensor _th_arange(Scalar start, Scalar end, Scalar step) const override;
  Tensor & _th_arange_out(Tensor & result, Scalar end) const override;
  Tensor _th_arange(Scalar end) const override;
  Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & _th_scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  Tensor & _th_scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  Tensor & _th_gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  Tensor _th_gather(const Tensor & self, int64_t dim, const Tensor & index) const override;
  bool _th_equal(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_and_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_and(const Tensor & self, Scalar other) const override;
  Tensor & s__th_and_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_and(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_iand_(Tensor & self, Scalar other) const override;
  Tensor & s__th_iand_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_or_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_or(const Tensor & self, Scalar other) const override;
  Tensor & s__th_or_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_or(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ior_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ior_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_xor_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_xor(const Tensor & self, Scalar other) const override;
  Tensor & s__th_xor_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_xor(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ixor_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ixor_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_lshift_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_lshift(const Tensor & self, Scalar other) const override;
  Tensor & s__th_lshift_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_lshift(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ilshift_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ilshift_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_rshift_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_rshift(const Tensor & self, Scalar other) const override;
  Tensor & s__th_rshift_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_rshift(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_irshift_(Tensor & self, Scalar other) const override;
  Tensor & s__th_irshift_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_lt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_lt(const Tensor & self, Scalar other) const override;
  Tensor & s__th_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_lt(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_lt_(Tensor & self, Scalar other) const override;
  Tensor & s__th_lt_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_gt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_gt(const Tensor & self, Scalar other) const override;
  Tensor & s__th_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_gt(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_gt_(Tensor & self, Scalar other) const override;
  Tensor & s__th_gt_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_le_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_le(const Tensor & self, Scalar other) const override;
  Tensor & s__th_le_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_le(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_le_(Tensor & self, Scalar other) const override;
  Tensor & s__th_le_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_ge_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_ge(const Tensor & self, Scalar other) const override;
  Tensor & s__th_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_ge(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ge_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ge_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_eq_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_eq(const Tensor & self, Scalar other) const override;
  Tensor & s__th_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_eq(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_eq_(Tensor & self, Scalar other) const override;
  Tensor & s__th_eq_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_ne_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_ne(const Tensor & self, Scalar other) const override;
  Tensor & s__th_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_ne(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_ne_(Tensor & self, Scalar other) const override;
  Tensor & s__th_ne_(Tensor & self, const Tensor & other) const override;
  Tensor & s__th_min_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_min(const Tensor & self, const Tensor & other) const override;
  Tensor _th_min(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor> _th_min(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor & s__th_max_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_max(const Tensor & self, const Tensor & other) const override;
  Tensor _th_max(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor> _th_max(const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> _th_kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor> _th_kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> _th_mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor> _th_mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  Tensor _th_median(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor,Tensor> _th_median(const Tensor & self, int64_t dim, bool keepdim) const override;
  std::tuple<Tensor &,Tensor &> _th_sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  std::tuple<Tensor,Tensor> _th_sort(const Tensor & self, int64_t dim, bool descending) const override;
  std::tuple<Tensor &,Tensor &> _th_topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  std::tuple<Tensor,Tensor> _th_topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  Tensor & _th_abs_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_abs(const Tensor & self) const override;
  Tensor & _th_log10_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_log10(const Tensor & self) const override;
  Tensor & _th_log2_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_log2(const Tensor & self) const override;
  Tensor & _th_lgamma_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_lgamma(const Tensor & self) const override;
  Tensor & _th_lgamma_(Tensor & self) const override;
  Tensor & _th_digamma_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_digamma(const Tensor & self) const override;
  Tensor & _th_digamma_(Tensor & self) const override;
  Tensor & _th_polygamma_out(Tensor & result, int64_t n, const Tensor & self) const override;
  Tensor _th_polygamma(int64_t n, const Tensor & self) const override;
  Tensor & _th_polygamma_(Tensor & self, int64_t n) const override;
  Tensor & _th_cosh_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_cosh(const Tensor & self) const override;
  Tensor & _th_sinh_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_sinh(const Tensor & self) const override;
  Tensor & _th_erfinv_(Tensor & self) const override;
  Tensor & _th_erfinv_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_erfinv(const Tensor & self) const override;
  Tensor & _th_frac_(Tensor & self) const override;
  Tensor & _th_frac_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_frac(const Tensor & self) const override;
  Tensor & _th_var_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_var(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_var(const Tensor & self, bool unbiased) const override;
  Tensor & _th_std_out(Tensor & result, const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_std(const Tensor & self, int64_t dim, bool unbiased, bool keepdim) const override;
  Tensor _th_std(const Tensor & self, bool unbiased) const override;
  Tensor _th_norm(const Tensor & self, Scalar p) const override;
  Tensor & _th_norm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  Tensor _th_norm(const Tensor & self, Scalar p, int64_t dim, bool keepdim) const override;
  Tensor & _th_renorm_out(Tensor & result, const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor _th_renorm(const Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor & _th_renorm_(Tensor & self, Scalar p, int64_t dim, Scalar maxnorm) const override;
  Tensor s__th_dist(const Tensor & self, const Tensor & other, Scalar p) const override;
  Tensor & _th_reciprocal_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_reciprocal(const Tensor & self) const override;
  Tensor & _th_reciprocal_(Tensor & self) const override;
  Tensor & _th_neg_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_neg(const Tensor & self) const override;
  Tensor & _th_neg_(Tensor & self) const override;
  Tensor & s__th_atan2_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_atan2(const Tensor & self, const Tensor & other) const override;
  Tensor & s__th_atan2_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const override;
  Tensor _th_pow(const Tensor & self, Scalar exponent) const override;
  Tensor & s__th_pow_out(Tensor & result, const Tensor & self, const Tensor & exponent) const override;
  Tensor s__th_pow(const Tensor & self, const Tensor & exponent) const override;
  Tensor & _th_pow_out(Tensor & result, Scalar self, const Tensor & exponent) const override;
  Tensor _th_pow(Scalar self, const Tensor & exponent) const override;
  Tensor & _th_pow_(Tensor & self, Scalar exponent) const override;
  Tensor & s__th_pow_(Tensor & self, const Tensor & exponent) const override;
  Tensor & s__th_lerp_out(Tensor & result, const Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor s__th_lerp(const Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor & s__th_lerp_(Tensor & self, const Tensor & end, Scalar weight) const override;
  Tensor & _th_linspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  Tensor _th_linspace(Scalar start, Scalar end, int64_t steps) const override;
  Tensor & _th_logspace_out(Tensor & result, Scalar start, Scalar end, int64_t steps) const override;
  Tensor _th_logspace(Scalar start, Scalar end, int64_t steps) const override;
  Tensor & _th_histc_out(Tensor & result, const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor _th_histc(const Tensor & self, int64_t bins, Scalar min, Scalar max) const override;
  Tensor & _th_zero_(Tensor & self) const override;
  Tensor & _th_cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  Tensor _th_cumsum(const Tensor & self, int64_t dim) const override;
  Tensor & _th_cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  Tensor _th_cumprod(const Tensor & self, int64_t dim) const override;
  Tensor & _th_sign_out(Tensor & result, const Tensor & self) const override;
  Tensor _th_sign(const Tensor & self) const override;
  Tensor & _th_sign_(Tensor & self) const override;
  Tensor _th_trace(const Tensor & self) const override;
  Tensor & _th_fmod_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_fmod(const Tensor & self, Scalar other) const override;
  Tensor & s__th_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_fmod(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_fmod_(Tensor & self, Scalar other) const override;
  Tensor & s__th_fmod_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_remainder_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor _th_remainder(const Tensor & self, Scalar other) const override;
  Tensor & s__th_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor s__th_remainder(const Tensor & self, const Tensor & other) const override;
  Tensor & _th_remainder_(Tensor & self, Scalar other) const override;
  Tensor & s__th_remainder_(Tensor & self, const Tensor & other) const override;
  Tensor & _th_clamp_out(Tensor & result, const Tensor & self, Scalar min, Scalar max) const override;
  Tensor _th_clamp(const Tensor & self, Scalar min, Scalar max) const override;
  Tensor & _th_clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const override;
  Tensor _th_clamp_min(const Tensor & self, Scalar min) const override;
  Tensor & _th_clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const override;
  Tensor _th_clamp_max(const Tensor & self, Scalar max) const override;
  Tensor _th_dot(const Tensor & self, const Tensor & tensor) const override;
  Tensor & _th_tril_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  Tensor _th_tril(const Tensor & self, int64_t diagonal) const override;
  Tensor & _th_tril_(Tensor & self, int64_t diagonal) const override;
  Tensor & _th_triu_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  Tensor _th_triu(const Tensor & self, int64_t diagonal) const override;
  Tensor & _th_triu_(Tensor & self, int64_t diagonal) const override;
  Tensor & _th_cross_out(Tensor & result, const Tensor & self, const Tensor & other, int64_t dim) const override;
  Tensor _th_cross(const Tensor & self, const Tensor & other, int64_t dim) const override;
  Tensor & _th_diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  Tensor _th_diag(const Tensor & self, int64_t diagonal) const override;
  Tensor & s__th_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const override;
  Tensor _th_ger(const Tensor & self, const Tensor & vec2) const override;
  Tensor & _th_mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const override;
  Tensor _th_mv(const Tensor & self, const Tensor & vec) const override;
  Tensor & _th_mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  Tensor _th_mm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & s__th_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor s__th_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & _th_addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & s__th_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor s__th_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor s__th_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  Tensor & s__th_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  std::tuple<Tensor &,Tensor &> _th_gesv_single_out(Tensor & solution, Tensor & lu, const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor,Tensor> _th_gesv_single(const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor &,Tensor &> _th_gels_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor,Tensor> _th_gels(const Tensor & self, const Tensor & A) const override;
  std::tuple<Tensor &,Tensor &> _th_trtrs_out(Tensor & res1, Tensor & res2, const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  std::tuple<Tensor,Tensor> _th_trtrs(const Tensor & self, const Tensor & A, bool upper, bool transpose, bool unitriangular) const override;
  std::tuple<Tensor &,Tensor &> _th_symeig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors, bool upper) const override;
  std::tuple<Tensor,Tensor> _th_symeig(const Tensor & self, bool eigenvectors, bool upper) const override;
  std::tuple<Tensor &,Tensor &> _th_eig_out(Tensor & res1, Tensor & res2, const Tensor & self, bool eigenvectors) const override;
  std::tuple<Tensor,Tensor> _th_eig(const Tensor & self, bool eigenvectors) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _th_svd_out(Tensor & res1, Tensor & res2, Tensor & res3, const Tensor & self, bool some, bool compute_uv) const override;
  std::tuple<Tensor,Tensor,Tensor> _th_svd(const Tensor & self, bool some, bool compute_uv) const override;
  Tensor & _th_getri_single_out(Tensor & output, const Tensor & self) const override;
  Tensor _th_getri_single(const Tensor & self) const override;
  Tensor & _th_potrf_single_out(Tensor & output, const Tensor & self, bool upper) const override;
  Tensor _th_potrf_single(const Tensor & self, bool upper) const override;
  Tensor & _th_potrs_single_out(Tensor & result, const Tensor & self, const Tensor & input2, bool upper) const override;
  Tensor _th_potrs_single(const Tensor & self, const Tensor & input2, bool upper) const override;
  Tensor & _th_potri_out(Tensor & output, const Tensor & self, bool upper) const override;
  Tensor _th_potri(const Tensor & self, bool upper) const override;
  std::tuple<Tensor &,Tensor &> _th_pstrf_out(Tensor & res1, Tensor & res2, const Tensor & self, bool upper, Scalar tol) const override;
  std::tuple<Tensor,Tensor> _th_pstrf(const Tensor & self, bool upper, Scalar tol) const override;
  std::tuple<Tensor &,Tensor &> _th_qr_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_qr(const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _th_geqrf_out(Tensor & res1, Tensor & res2, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _th_geqrf(const Tensor & self) const override;
  Tensor & _th_orgqr_out(Tensor & result, const Tensor & self, const Tensor & input2) const override;
  Tensor _th_orgqr(const Tensor & self, const Tensor & input2) const override;
  Tensor & _th_ormqr_out(Tensor & result, const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  Tensor _th_ormqr(const Tensor & self, const Tensor & input2, const Tensor & input3, bool left, bool transpose) const override;
  std::tuple<Tensor &,Tensor &> _th_btrifact_out(Tensor & result, Tensor & pivots, const Tensor & self, bool pivot) const override;
  std::tuple<Tensor,Tensor> _th_btrifact(const Tensor & self, bool pivot) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _th_btrifact_with_info_out(Tensor & result, Tensor & pivots, Tensor & info, const Tensor & self, bool pivot) const override;
  std::tuple<Tensor,Tensor,Tensor> _th_btrifact_with_info(const Tensor & self, bool pivot) const override;
  Tensor & _th_btrisolve_out(Tensor & result, const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor _th_btrisolve(const Tensor & self, const Tensor & LU_data, const Tensor & LU_pivots) const override;
  Tensor & _th_random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  Tensor & _th_random_(Tensor & self, int64_t to, Generator * generator) const override;
  Tensor & _th_random_(Tensor & self, Generator * generator) const override;
  Tensor & _th_multinomial_out(Tensor & result, const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor _th_multinomial(const Tensor & self, int64_t num_samples, bool replacement, Generator * generator) const override;
  Tensor & _th_uniform_(Tensor & self, double from, double to, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, const Tensor & mean, double std, Generator * generator) const override;
  Tensor _th_normal(const Tensor & mean, double std, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, double mean, const Tensor & std, Generator * generator) const override;
  Tensor _th_normal(double mean, const Tensor & std, Generator * generator) const override;
  Tensor & _th_normal_out(Tensor & output, const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor _th_normal(const Tensor & mean, const Tensor & std, Generator * generator) const override;
  Tensor & _th_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & _th_cauchy_(Tensor & self, double median, double sigma, Generator * generator) const override;
  Tensor & _th_log_normal_(Tensor & self, double mean, double std, Generator * generator) const override;
  Tensor & _th_exponential_(Tensor & self, double lambd, Generator * generator) const override;
  Tensor & _th_geometric_(Tensor & self, double p, Generator * generator) const override;
  Tensor & _th_dirichlet_grad_out(Tensor & output, const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  Tensor _th_dirichlet_grad(const Tensor & x, const Tensor & alpha, const Tensor & total) const override;
  Tensor _th_tensor(Storage storage, int64_t storageOffset, IntList size, IntList stride) const override;
  Tensor _th_tensor(IntList size, IntList stride) const override;
  Tensor _th_alias(const Tensor & self) const override;
  Tensor & _th_cat_out(Tensor & self, TensorList tensors, int64_t dim) const override;
  Tensor _th_cat(TensorList tensors, int64_t dim) const override;
  Tensor & _thnn_binary_cross_entropy_forward_out(Tensor & output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_binary_cross_entropy_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_binary_cross_entropy_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_binary_cross_entropy_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_mse_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_mse_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_mse_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_mse_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_multi_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_multi_margin_loss_forward(const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor & _thnn_multi_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  Tensor _thnn_multi_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, Scalar p, Scalar margin, const Tensor & weight, int64_t reduction) const override;
  std::tuple<Tensor &,Tensor &> _thnn_multilabel_margin_loss_forward_out(Tensor & output, Tensor & is_target, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  std::tuple<Tensor,Tensor> _thnn_multilabel_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_multilabel_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  Tensor _thnn_multilabel_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction, const Tensor & is_target) const override;
  std::tuple<Tensor &,Tensor &> _thnn_nll_loss_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor,Tensor> _thnn_nll_loss_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor & _thnn_nll_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor _thnn_nll_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  std::tuple<Tensor &,Tensor &> _thnn_nll_loss2d_forward_out(Tensor & output, Tensor & total_weight, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  std::tuple<Tensor,Tensor> _thnn_nll_loss2d_forward(const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index) const override;
  Tensor & _thnn_nll_loss2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor _thnn_nll_loss2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, const Tensor & weight, int64_t reduction, int64_t ignore_index, const Tensor & total_weight) const override;
  Tensor & _thnn_smooth_l1_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_smooth_l1_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_smooth_l1_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_smooth_l1_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_soft_margin_loss_forward_out(Tensor & output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_soft_margin_loss_forward(const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_soft_margin_loss_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor _thnn_soft_margin_loss_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & _thnn_elu_forward_out(Tensor & output, const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor _thnn_elu_forward(const Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor & _thnn_elu_backward_out(Tensor & grad_input, const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor _thnn_elu_backward(const Tensor & grad_output, Scalar alpha, Scalar scale, Scalar input_scale, const Tensor & output) const override;
  Tensor & _thnn_elu_forward_(Tensor & self, Scalar alpha, Scalar scale, Scalar input_scale) const override;
  Tensor & _thnn_glu_forward_out(Tensor & output, const Tensor & self, int64_t dim) const override;
  Tensor _thnn_glu_forward(const Tensor & self, int64_t dim) const override;
  Tensor & _thnn_glu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor _thnn_glu_backward(const Tensor & grad_output, const Tensor & self, int64_t dim) const override;
  Tensor & _thnn_hardtanh_forward_out(Tensor & output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor _thnn_hardtanh_forward(const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_hardtanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor _thnn_hardtanh_backward(const Tensor & grad_output, const Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_hardtanh_forward_(Tensor & self, Scalar min_val, Scalar max_val) const override;
  Tensor & _thnn_leaky_relu_forward_out(Tensor & output, const Tensor & self, Scalar negative_slope) const override;
  Tensor _thnn_leaky_relu_forward(const Tensor & self, Scalar negative_slope) const override;
  Tensor & _thnn_leaky_relu_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor _thnn_leaky_relu_backward(const Tensor & grad_output, const Tensor & self, Scalar negative_slope) const override;
  Tensor & _thnn_leaky_relu_forward_(Tensor & self, Scalar negative_slope) const override;
  std::tuple<Tensor &,Tensor &> _thnn_log_sigmoid_forward_out(Tensor & output, Tensor & buffer, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _thnn_log_sigmoid_forward(const Tensor & self) const override;
  Tensor & _thnn_log_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  Tensor _thnn_log_sigmoid_backward(const Tensor & grad_output, const Tensor & self, const Tensor & buffer) const override;
  Tensor & _thnn_rrelu_with_noise_forward_out(Tensor & output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor _thnn_rrelu_with_noise_forward(const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & _thnn_rrelu_with_noise_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor _thnn_rrelu_with_noise_backward(const Tensor & grad_output, const Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training) const override;
  Tensor & _thnn_rrelu_with_noise_forward_(Tensor & self, const Tensor & noise, Scalar lower, Scalar upper, bool training, Generator * generator) const override;
  Tensor & _thnn_softplus_forward_out(Tensor & output, const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor _thnn_softplus_forward(const Tensor & self, Scalar beta, Scalar threshold) const override;
  Tensor & _thnn_softplus_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor _thnn_softplus_backward(const Tensor & grad_output, const Tensor & self, Scalar beta, Scalar threshold, const Tensor & output) const override;
  Tensor & _thnn_softshrink_forward_out(Tensor & output, const Tensor & self, Scalar lambd) const override;
  Tensor _thnn_softshrink_forward(const Tensor & self, Scalar lambd) const override;
  Tensor & _thnn_softshrink_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor _thnn_softshrink_backward(const Tensor & grad_output, const Tensor & self, Scalar lambd) const override;
  Tensor & _thnn_adaptive_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  Tensor _thnn_adaptive_avg_pool2d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_adaptive_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  Tensor _thnn_adaptive_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self) const override;
  Tensor & _thnn_adaptive_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  Tensor _thnn_adaptive_avg_pool3d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_adaptive_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self) const override;
  Tensor _thnn_adaptive_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self) const override;
  std::tuple<Tensor &,Tensor &> _thnn_adaptive_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const override;
  std::tuple<Tensor,Tensor> _thnn_adaptive_max_pool2d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_adaptive_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  Tensor _thnn_adaptive_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> _thnn_adaptive_max_pool3d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList output_size) const override;
  std::tuple<Tensor,Tensor> _thnn_adaptive_max_pool3d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_adaptive_max_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  Tensor _thnn_adaptive_max_pool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices) const override;
  Tensor & _thnn_avg_pool2d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool2d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool3d_forward_out(Tensor & output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool3d_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor & _thnn_avg_pool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  Tensor _thnn_avg_pool3d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, bool ceil_mode, bool count_include_pad) const override;
  std::tuple<Tensor &,Tensor &> _thnn_fractional_max_pool2d_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const override;
  std::tuple<Tensor,Tensor> _thnn_fractional_max_pool2d_forward(const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & random_samples) const override;
  Tensor & _thnn_fractional_max_pool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const override;
  Tensor _thnn_fractional_max_pool2d_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList output_size, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> _thnn_max_pool2d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor> _thnn_max_pool2d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  Tensor & _thnn_max_pool2d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor _thnn_max_pool2d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  std::tuple<Tensor &,Tensor &> _thnn_max_pool3d_with_indices_forward_out(Tensor & output, Tensor & indices, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  std::tuple<Tensor,Tensor> _thnn_max_pool3d_with_indices_forward(const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode) const override;
  Tensor & _thnn_max_pool3d_with_indices_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor _thnn_max_pool3d_with_indices_backward(const Tensor & grad_output, const Tensor & self, IntList kernel_size, IntList stride, IntList padding, IntList dilation, bool ceil_mode, const Tensor & indices) const override;
  Tensor & _thnn_max_unpool2d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  Tensor _thnn_max_unpool2d_forward(const Tensor & self, const Tensor & indices, IntList output_size) const override;
  Tensor & _thnn_max_unpool2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  Tensor _thnn_max_unpool2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size) const override;
  Tensor & _thnn_max_unpool3d_forward_out(Tensor & output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  Tensor _thnn_max_unpool3d_forward(const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  Tensor & _thnn_max_unpool3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  Tensor _thnn_max_unpool3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & indices, IntList output_size, IntList stride, IntList padding) const override;
  Tensor & _thnn_reflection_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_reflection_pad1d_forward(const Tensor & self, IntList padding) const override;
  Tensor & _thnn_reflection_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_reflection_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor & _thnn_reflection_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_reflection_pad2d_forward(const Tensor & self, IntList padding) const override;
  Tensor & _thnn_reflection_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_reflection_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad1d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad1d_forward(const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad1d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad1d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad2d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad2d_forward(const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad2d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad2d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad3d_forward_out(Tensor & output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad3d_forward(const Tensor & self, IntList padding) const override;
  Tensor & _thnn_replication_pad3d_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor _thnn_replication_pad3d_backward(const Tensor & grad_output, const Tensor & self, IntList padding) const override;
  Tensor & _thnn_upsample_linear1d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor _thnn_upsample_linear1d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_linear1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor _thnn_upsample_linear1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bilinear2d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor _thnn_upsample_bilinear2d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_bilinear2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor _thnn_upsample_bilinear2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_trilinear3d_forward_out(Tensor & output, const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor _thnn_upsample_trilinear3d_forward(const Tensor & self, IntList output_size, bool align_corners) const override;
  Tensor & _thnn_upsample_trilinear3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor _thnn_upsample_trilinear3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size, bool align_corners) const override;
  Tensor & _thnn_upsample_nearest1d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  Tensor _thnn_upsample_nearest1d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_upsample_nearest1d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor _thnn_upsample_nearest1d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor & _thnn_upsample_nearest2d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  Tensor _thnn_upsample_nearest2d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_upsample_nearest2d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor _thnn_upsample_nearest2d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor & _thnn_upsample_nearest3d_forward_out(Tensor & output, const Tensor & self, IntList output_size) const override;
  Tensor _thnn_upsample_nearest3d_forward(const Tensor & self, IntList output_size) const override;
  Tensor & _thnn_upsample_nearest3d_backward_out(Tensor & grad_input, const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor _thnn_upsample_nearest3d_backward(const Tensor & grad_output, IntList output_size, IntList input_size) const override;
  Tensor & _thnn_sigmoid_forward_out(Tensor & output, const Tensor & self) const override;
  Tensor _thnn_sigmoid_forward(const Tensor & self) const override;
  Tensor & _thnn_sigmoid_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor _thnn_sigmoid_backward(const Tensor & grad_output, const Tensor & output) const override;
  Tensor & _thnn_tanh_forward_out(Tensor & output, const Tensor & self) const override;
  Tensor _thnn_tanh_forward(const Tensor & self) const override;
  Tensor & _thnn_tanh_backward_out(Tensor & grad_input, const Tensor & grad_output, const Tensor & output) const override;
  Tensor _thnn_tanh_backward(const Tensor & grad_output, const Tensor & output) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList output_padding, IntList dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_transpose3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_transpose3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList output_padding, IntList dilation, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_forward_out(Tensor & output, Tensor & finput, Tensor & fgrad_input, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, const Tensor & finput, const Tensor & fgrad_input, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated2d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated2d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_forward_out(Tensor & output, Tensor & columns, Tensor & ones, const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_forward(const Tensor & self, const Tensor & weight, IntList kernel_size, const Tensor & bias, IntList stride, IntList padding, IntList dilation) const override;
  std::tuple<Tensor &,Tensor &,Tensor &> _thnn_conv_dilated3d_backward_out(Tensor & grad_input, Tensor & grad_weight, Tensor & grad_bias, const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_conv_dilated3d_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight, IntList kernel_size, IntList stride, IntList padding, IntList dilation, const Tensor & columns, const Tensor & ones, std::array<bool,3> output_mask) const override;
  std::tuple<Tensor,Tensor> _cudnn_ctc_loss(const Tensor & log_probs, const Tensor & targets, IntList input_lengths, IntList target_lengths, int64_t blank, bool deterministic) const override;
  Tensor _cudnn_rnn_flatten_weight(TensorList weight_arr, int64_t weight_stride0, int64_t input_size, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, bool bidirectional) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _cudnn_rnn(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state) const override;
  std::tuple<Tensor,Tensor,Tensor,std::vector<Tensor>> _cudnn_rnn_backward(const Tensor & input, TensorList weight, int64_t weight_stride0, const Tensor & weight_buf, const Tensor & hx, const Tensor & cx, const Tensor & output, const Tensor & grad_output, const Tensor & grad_hy, const Tensor & grad_cy, int64_t mode, int64_t hidden_size, int64_t num_layers, bool batch_first, double dropout, bool train, bool bidirectional, IntList batch_sizes, const Tensor & dropout_state, const Tensor & reserve, std::array<bool,4> output_mask) const override;
  Tensor _cudnn_init_dropout_state(double dropout, bool train, int64_t dropout_seed, const TensorOptions & options) const override;
  std::tuple<Tensor,Tensor> _fused_dropout(const Tensor & self, double p, Generator * generator) const override;
  Tensor _masked_scale(const Tensor & self, const Tensor & mask, double scale) const override;
  Tensor & abs_(Tensor & self) const override;
  Tensor & abs_out(Tensor & result, const Tensor & self) const override;
  Tensor & acos_(Tensor & self) const override;
  Tensor & acos_out(Tensor & result, const Tensor & self) const override;
  Tensor & asin_(Tensor & self) const override;
  Tensor & asin_out(Tensor & result, const Tensor & self) const override;
  Tensor & atan_(Tensor & self) const override;
  Tensor & atan_out(Tensor & result, const Tensor & self) const override;
  Tensor baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  Tensor & bernoulli_(Tensor & self, const Tensor & p, Generator * generator) const override;
  Tensor & bernoulli_(Tensor & self, double p, Generator * generator) const override;
  Tensor bincount(const Tensor & self, const Tensor & weights, int64_t minlength) const override;
  Tensor bmm(const Tensor & self, const Tensor & mat2) const override;
  Tensor & bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  Tensor & ceil_(Tensor & self) const override;
  Tensor & ceil_out(Tensor & result, const Tensor & self) const override;
  Tensor & clamp_(Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const override;
  Tensor & clamp_out(Tensor & result, const Tensor & self, c10::optional<Scalar> min, c10::optional<Scalar> max) const override;
  Tensor & clamp_max_(Tensor & self, Scalar max) const override;
  Tensor & clamp_max_out(Tensor & result, const Tensor & self, Scalar max) const override;
  Tensor & clamp_min_(Tensor & self, Scalar min) const override;
  Tensor & clamp_min_out(Tensor & result, const Tensor & self, Scalar min) const override;
  Tensor & s_copy_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  Tensor _s_copy_from(const Tensor & self, const Tensor & dst, bool non_blocking) const override;
  void _copy_same_type_(Tensor & self, const Tensor & src) const override;
  Tensor & cos_(Tensor & self) const override;
  Tensor & cos_out(Tensor & result, const Tensor & self) const override;
  Tensor & cosh_(Tensor & self) const override;
  Tensor & cosh_out(Tensor & result, const Tensor & self) const override;
  Tensor cudnn_affine_grid_generator(const Tensor & theta, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  Tensor cudnn_affine_grid_generator_backward(const Tensor & grad, int64_t N, int64_t C, int64_t H, int64_t W) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const override;
  Tensor cudnn_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor cudnn_convolution_backward_bias(const Tensor & grad_output) const override;
  Tensor cudnn_convolution_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> cudnn_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor cudnn_convolution_transpose_backward_bias(const Tensor & grad_output) const override;
  Tensor cudnn_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_convolution_transpose_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor cudnn_grid_sampler(const Tensor & self, const Tensor & grid) const override;
  std::tuple<Tensor,Tensor> cudnn_grid_sampler_backward(const Tensor & self, const Tensor & grid, const Tensor & grad_output) const override;
  std::tuple<Tensor,Tensor> _ctc_loss(const Tensor & log_probs, const Tensor & targets, IntList input_lengths, IntList target_lengths, int64_t blank) const override;
  Tensor _ctc_loss_backward(const Tensor & grad, const Tensor & log_probs, const Tensor & targets, IntList input_lengths, IntList target_lengths, const Tensor & neg_log_likelihood, const Tensor & log_alpha, int64_t blank) const override;
  Tensor embedding_dense_backward(const Tensor & grad, const Tensor & indices, int64_t num_weights, int64_t padding_idx, bool scale_grad_by_freq) const override;
  Tensor & embedding_renorm_(Tensor & self, const Tensor & indices, double max_norm, double norm_type) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor> _embedding_bag(const Tensor & weight, const Tensor & indices, const Tensor & offsets, bool scale_grad_by_freq, int64_t mode, bool sparse) const override;
  Tensor _embedding_bag_dense_backward(const Tensor & grad, const Tensor & indices, const Tensor & offsets, const Tensor & offset2bag, const Tensor & bag_size, const Tensor & maximum_indices, int64_t num_weights, bool scale_grad_by_freq, int64_t mode) const override;
  Tensor empty(IntList size, const TensorOptions & options) const override;
  Tensor & resize_(Tensor & self, IntList size) const override;
  Tensor & erf_(Tensor & self) const override;
  Tensor & erf_out(Tensor & result, const Tensor & self) const override;
  Tensor & erfc_(Tensor & self) const override;
  Tensor & erfc_out(Tensor & result, const Tensor & self) const override;
  Tensor & exp_(Tensor & self) const override;
  Tensor & exp_out(Tensor & result, const Tensor & self) const override;
  Tensor & expm1_(Tensor & self) const override;
  Tensor & expm1_out(Tensor & result, const Tensor & self) const override;
  Tensor & eye_out(Tensor & result, int64_t n) const override;
  Tensor & eye_out(Tensor & result, int64_t n, int64_t m) const override;
  Tensor & floor_(Tensor & self) const override;
  Tensor & floor_out(Tensor & result, const Tensor & self) const override;
  Tensor grid_sampler_2d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  std::tuple<Tensor,Tensor> grid_sampler_2d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  Tensor grid_sampler_3d(const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  std::tuple<Tensor,Tensor> grid_sampler_3d_backward(const Tensor & grad_output, const Tensor & input, const Tensor & grid, int64_t interpolation_mode, int64_t padding_mode) const override;
  std::tuple<Tensor,Tensor> _gesv_helper(const Tensor & self, const Tensor & A) const override;
  Tensor _fft_with_size(const Tensor & self, int64_t signal_ndim, bool complex_input, bool complex_output, bool inverse, IntList checked_signal_sizes, bool normalized, bool onesided, IntList output_sizes) const override;
  Tensor _inverse_helper(const Tensor & self) const override;
  Tensor kl_div_backward(const Tensor & grad_output, const Tensor & self, const Tensor & target, int64_t reduction) const override;
  Tensor & log_(Tensor & self) const override;
  Tensor & log_out(Tensor & result, const Tensor & self) const override;
  Tensor & log10_(Tensor & self) const override;
  Tensor & log10_out(Tensor & result, const Tensor & self) const override;
  Tensor & log1p_(Tensor & self) const override;
  Tensor & log1p_out(Tensor & result, const Tensor & self) const override;
  Tensor & log2_(Tensor & self) const override;
  Tensor & log2_out(Tensor & result, const Tensor & self) const override;
  Tensor _log_softmax(const Tensor & self, int64_t dim, bool half_to_float) const override;
  Tensor _log_softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double exponential_average_factor, double epsilon) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_batch_norm_backward(const Tensor & input, const Tensor & grad_output, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_var, double epsilon) const override;
  Tensor miopen_convolution(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_backward_input(IntList self_size, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_convolution_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor miopen_convolution_backward_bias(const Tensor & grad_output) const override;
  Tensor miopen_convolution_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_transpose(const Tensor & self, const Tensor & weight, const Tensor & bias, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  std::tuple<Tensor,Tensor,Tensor> miopen_convolution_transpose_backward(const Tensor & self, const Tensor & grad_output, const Tensor & weight, IntList padding, IntList output_padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic, std::array<bool,3> output_mask) const override;
  Tensor miopen_convolution_transpose_backward_input(const Tensor & grad_output, const Tensor & weight, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor miopen_convolution_transpose_backward_weight(IntList weight_size, const Tensor & grad_output, const Tensor & self, IntList padding, IntList stride, IntList dilation, int64_t groups, bool benchmark, bool deterministic) const override;
  Tensor narrow_copy(const Tensor & self, int64_t dim, int64_t start, int64_t length) const override;
  std::tuple<Tensor,Tensor,Tensor> native_batch_norm(const Tensor & input, const Tensor & weight, const Tensor & bias, const Tensor & running_mean, const Tensor & running_var, bool training, double momentum, double eps) const override;
  std::tuple<Tensor,Tensor,Tensor> native_batch_norm_backward(const Tensor & grad_out, const Tensor & input, const Tensor & weight, const Tensor & running_mean, const Tensor & running_var, const Tensor & save_mean, const Tensor & save_invstd, bool train, double eps, std::array<bool,3> output_mask) const override;
  Tensor & randperm_out(Tensor & result, int64_t n, Generator * generator) const override;
  std::tuple<Tensor,Tensor> RoiPooling2d_forward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale) const override;
  Tensor RoiPooling2d_backward(const Tensor & input, const Tensor & rois, int64_t pooledHeight, int64_t pooledWidth, double spatialScale, const Tensor & gradOutput, const Tensor & argmaxes) const override;
  Tensor & round_(Tensor & self) const override;
  Tensor & round_out(Tensor & result, const Tensor & self) const override;
  Tensor prelu(const Tensor & self, const Tensor & weight) const override;
  std::tuple<Tensor,Tensor> prelu_backward(const Tensor & grad_output, const Tensor & self, const Tensor & weight) const override;
  Tensor hardshrink(const Tensor & self, Scalar lambd) const override;
  Tensor hardshrink_backward(const Tensor & grad_out, const Tensor & self, Scalar lambd) const override;
  Tensor & rsqrt_(Tensor & self) const override;
  Tensor & rsqrt_out(Tensor & result, const Tensor & self) const override;
  Tensor & sigmoid_(Tensor & self) const override;
  Tensor & sigmoid_out(Tensor & result, const Tensor & self) const override;
  Tensor & sin_(Tensor & self) const override;
  Tensor & sin_out(Tensor & result, const Tensor & self) const override;
  Tensor & sinh_(Tensor & self) const override;
  Tensor & sinh_out(Tensor & result, const Tensor & self) const override;
  Tensor _softmax(const Tensor & self, int64_t dim, bool half_to_float) const override;
  Tensor _softmax_backward_data(const Tensor & grad_output, const Tensor & output, int64_t dim, const Tensor & self) const override;
  Tensor & _sparse_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  Tensor & _sparse_dense_add_out(Tensor & result, const Tensor & self, SparseTensorRef other, Scalar alpha) const override;
  Tensor & _sparse_div_zerodim_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & _sparse_div_scalar_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & _sparse_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & _sparse_mul_zerodim_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  Tensor & _sparse_mul_scalar_out(Tensor & result, const Tensor & self, Scalar other) const override;
  Tensor & sspaddmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & sqrt_(Tensor & self) const override;
  Tensor & sqrt_out(Tensor & result, const Tensor & self) const override;
  Tensor & tan_(Tensor & self) const override;
  Tensor & tan_out(Tensor & result, const Tensor & self) const override;
  Tensor & tanh_(Tensor & self) const override;
  Tensor & tanh_out(Tensor & result, const Tensor & self) const override;
  Tensor flip(const Tensor & self, IntList dims) const override;
  Tensor roll(const Tensor & self, IntList shifts, IntList dims) const override;
  Tensor & trunc_(Tensor & self) const override;
  Tensor & trunc_out(Tensor & result, const Tensor & self) const override;
  std::tuple<Tensor,Tensor> _unique(const Tensor & self, bool sorted, bool return_inverse) const override;
  std::tuple<Tensor,Tensor> _unique_dim(const Tensor & self, int64_t dim, bool sorted, bool return_inverse) const override;
  Tensor _s_where(const Tensor & condition, const Tensor & self, const Tensor & other) const override;
  std::tuple<Tensor,Tensor> _weight_norm_cuda_interface(const Tensor & v, const Tensor & g, int64_t dim) const override;
  std::tuple<Tensor,Tensor> _weight_norm_cuda_interface_backward(const Tensor & grad_w, const Tensor & saved_v, const Tensor & saved_g, const Tensor & saved_norms, int64_t dim) const override;
  Tensor _standard_gamma_grad(const Tensor & self, const Tensor & output) const override;
  Tensor _standard_gamma(const Tensor & self, Generator * generator) const override;
  Tensor poisson(const Tensor & self, Generator * generator) const override;
  Tensor native_norm(const Tensor & self, Scalar p) const override;
  Tensor _sparse_sum_backward(const Tensor & grad, const Tensor & self, IntList dim) const override;
  Tensor native_clone(const Tensor & self) const override;
  Tensor & native_resize_as_(Tensor & self, const Tensor & the_template) const override;
  Tensor & native_pow_out(Tensor & result, const Tensor & self, Scalar exponent) const override;
  Tensor native_pow(const Tensor & self, Scalar exponent) const override;
  Tensor & native_zero_(Tensor & self) const override;
  Tensor & s_native_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor s_native_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor & s_native_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  Tensor _sparse_coo_tensor_with_dims(int64_t sparse_dim, int64_t dense_dim, IntList size, const TensorOptions & options) const override;
  Tensor _sparse_coo_tensor_with_dims_and_tensors(int64_t sparse_dim, int64_t dense_dim, IntList size, const Tensor & indices, const Tensor & values, const TensorOptions & options) const override;
  Tensor & sparse_resize_(Tensor & self, IntList size, int64_t sparse_dim, int64_t dense_dim) const override;
  Tensor & sparse_resize_and_clear_(Tensor & self, IntList size, int64_t sparse_dim, int64_t dense_dim) const override;
  Tensor sparse_mask(const Tensor & self, SparseTensorRef mask) const override;
  Tensor to_dense(const Tensor & self) const override;
  int64_t sparse_dim(const Tensor & self) const override;
  int64_t dense_dim(const Tensor & self) const override;
  int64_t _nnz(const Tensor & self) const override;
  Tensor coalesce(const Tensor & self) const override;
  bool is_coalesced(const Tensor & self) const override;
  Tensor _indices(const Tensor & self) const override;
  Tensor _values(const Tensor & self) const override;
  Tensor & _coalesced_(Tensor & self, bool coalesced) const override;
  Tensor indices(const Tensor & self) const override;
  Tensor values(const Tensor & self) const override;
  Tensor & hspmm_out(Tensor & result, const Tensor & mat1, const Tensor & mat2) const override;
  Tensor hspmm(const Tensor & mat1, const Tensor & mat2) const override;
  Tensor & copy_sparse_to_sparse_(Tensor & self, const Tensor & src, bool non_blocking) const override;
  Tensor to_sparse(const Tensor & self, int64_t sparse_dim) const override;
  Tensor to_sparse(const Tensor & self) const override;
  Scalar _local_scalar_dense(const Tensor & self) const override;
  std::tuple<Tensor,Tensor,Tensor> _thnn_fused_lstm_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & cx, const Tensor & input_bias, const Tensor & hidden_bias) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_lstm_cell_backward(const Tensor & grad_hy, const Tensor & grad_cy, const Tensor & cx, const Tensor & cy, const Tensor & workspace, bool has_bias) const override;
  std::tuple<Tensor,Tensor> _thnn_fused_gru_cell(const Tensor & input_gates, const Tensor & hidden_gates, const Tensor & hx, const Tensor & input_bias, const Tensor & hidden_bias) const override;
  std::tuple<Tensor,Tensor,Tensor,Tensor,Tensor> _thnn_fused_gru_cell_backward(const Tensor & grad_hy, const Tensor & workspace, bool has_bias) const override;
  Tensor _cholesky_helper(const Tensor & self, bool upper) const override;
  Tensor _potrs_helper(const Tensor & self, const Tensor & A, bool upper) const override;
};

} // namespace at
