import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class BoxGeometry(BaseGeometry):
    """BoxGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/BoxGeometry
    """

    def __init__(self, width=1, height=1, depth=1, widthSegments=1, heightSegments=1, depthSegments=1, **kwargs):
        kwargs['width'] = width
        kwargs['height'] = height
        kwargs['depth'] = depth
        kwargs['widthSegments'] = widthSegments
        kwargs['heightSegments'] = heightSegments
        kwargs['depthSegments'] = depthSegments
        super(BoxGeometry, self).__init__(**kwargs)

    _model_name = Unicode('BoxGeometryModel').tag(sync=True)

    width = CFloat(1, allow_none=False).tag(sync=True)

    height = CFloat(1, allow_none=False).tag(sync=True)

    depth = CFloat(1, allow_none=False).tag(sync=True)

    widthSegments = CInt(1, allow_none=False).tag(sync=True)

    heightSegments = CInt(1, allow_none=False).tag(sync=True)

    depthSegments = CInt(1, allow_none=False).tag(sync=True)

    type = Unicode("BoxGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    BoxGeometry.__signature__ = inspect.signature(BoxGeometry.__init__)
