import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseGeometry_autogen import BaseGeometry


@register
class TorusKnotGeometry(BaseGeometry):
    """TorusKnotGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/TorusKnotGeometry
    """

    def __init__(self, radius=1, tube=0.4, tubularSegments=64, radialSegments=8, p=2, q=3, **kwargs):
        kwargs['radius'] = radius
        kwargs['tube'] = tube
        kwargs['tubularSegments'] = tubularSegments
        kwargs['radialSegments'] = radialSegments
        kwargs['p'] = p
        kwargs['q'] = q
        super(TorusKnotGeometry, self).__init__(**kwargs)

    _model_name = Unicode('TorusKnotGeometryModel').tag(sync=True)

    radius = CFloat(1, allow_none=False).tag(sync=True)

    tube = CFloat(0.4, allow_none=False).tag(sync=True)

    tubularSegments = CInt(64, allow_none=False).tag(sync=True)

    radialSegments = CInt(8, allow_none=False).tag(sync=True)

    p = CInt(2, allow_none=False).tag(sync=True)

    q = CInt(3, allow_none=False).tag(sync=True)

    type = Unicode("TorusKnotGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    TorusKnotGeometry.__signature__ = inspect.signature(TorusKnotGeometry.__init__)
