import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..core.Object3D import Object3D

@register
class CloneArray(Object3D):
    """CloneArray

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, original=None, positions=[], merge=False, **kwargs):
        kwargs['original'] = original
        kwargs['positions'] = positions
        kwargs['merge'] = merge
        super(CloneArray, self).__init__(**kwargs)

    _model_name = Unicode('CloneArrayModel').tag(sync=True)

    original = Instance(Object3D, allow_none=True).tag(sync=True, **widget_serialization)

    positions = List(trait=List()).tag(sync=True)

    merge = Bool(False, allow_none=False).tag(sync=True)

    type = Unicode("CloneArray", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    CloneArray.__signature__ = inspect.signature(CloneArray.__init__)
