import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry


@register
class RingBufferGeometry(BaseBufferGeometry):
    """RingBufferGeometry

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/geometries/RingGeometry
    """

    def __init__(self, innerRadius=0.5, outerRadius=1, thetaSegments=8, phiSegments=8, thetaStart=0, thetaLength=6.283185307179586, **kwargs):
        kwargs['innerRadius'] = innerRadius
        kwargs['outerRadius'] = outerRadius
        kwargs['thetaSegments'] = thetaSegments
        kwargs['phiSegments'] = phiSegments
        kwargs['thetaStart'] = thetaStart
        kwargs['thetaLength'] = thetaLength
        super(RingBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('RingBufferGeometryModel').tag(sync=True)

    innerRadius = CFloat(0.5, allow_none=False).tag(sync=True)

    outerRadius = CFloat(1, allow_none=False).tag(sync=True)

    thetaSegments = CInt(8, allow_none=False, min=3).tag(sync=True)

    phiSegments = CInt(8, allow_none=False, min=1).tag(sync=True)

    thetaStart = CFloat(0, allow_none=False).tag(sync=True)

    thetaLength = CFloat(6.283185307179586, allow_none=False).tag(sync=True)

    type = Unicode("RingBufferGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    RingBufferGeometry.__signature__ = inspect.signature(RingBufferGeometry.__init__)
