import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Mesh_autogen import Mesh

from ..materials.LineMaterial_autogen import LineMaterial
from ..geometries.LineGeometry_autogen import LineGeometry

@register
class Line2(Mesh):
    """Line2

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, geometry=UninitializedSentinel, material=UninitializedSentinel, **kwargs):
        kwargs['geometry'] = geometry
        kwargs['material'] = material
        super(Line2, self).__init__(**kwargs)

    _model_name = Unicode('Line2Model').tag(sync=True)

    material = Union([
        Instance(Uninitialized),
        Instance(LineMaterial),
        ], default_value=UninitializedSentinel, allow_none=True).tag(sync=True, **unitialized_serialization)

    geometry = Union([
        Instance(Uninitialized),
        Instance(LineGeometry),
        ], default_value=UninitializedSentinel, allow_none=True).tag(sync=True, **unitialized_serialization)

    type = Unicode("Line2", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Line2.__signature__ = inspect.signature(Line2.__init__)
